/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.concert.IloNumVar;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxNumVar;
import java.io.IOException;
import java.io.ObjectOutputStream;

abstract class CpxSOS
extends CpxExtractable {
    private static final long serialVersionUID = 1210L;
    CplexIndex _index;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isInstalledExt()) {
            CplexIndex cplexIndex = this._index;
            try {
                this._index = new ExternalSOS(this.getSOSType(), this.getCpxNumVars(), this.getValues());
            }
            catch (IloException iloException) {
                throw new IOException();
            }
            objectOutputStream.defaultWriteObject();
            this._index = cplexIndex;
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    CpxSOS() {
    }

    protected CpxSOS(CplexI cplexI, CplexIndex cplexIndex, String string) {
        super(string);
        this.setCplexI(cplexI);
        this._index = cplexIndex;
    }

    protected CpxSOS(CplexI cplexI, byte by, CpxNumVar[] cpxNumVarArray, double[] dArray, int n, int n2, String string) throws IloException {
        super(string);
        if (cplexI != null) {
            this.setCplexI(cplexI);
            cplexI.useVars(cpxNumVarArray, n, n2, true);
            this._index = cplexI.addSOS(this, by, n, n2, cpxNumVarArray, dArray, this._name);
        } else {
            double[] dArray2 = new double[n2];
            CpxNumVar[] cpxNumVarArray2 = new CpxNumVar[n2];
            System.arraycopy(dArray, n, dArray2, 0, n2);
            System.arraycopy(cpxNumVarArray, n, cpxNumVarArray2, 0, n2);
            this._index = new ExternalSOS(by, cpxNumVarArray2, dArray2);
        }
    }

    abstract byte getSOSType();

    CpxNumVar[] getCpxNumVars() throws IloException {
        if (this.isInstalledExt()) {
            CpxNumVar[][] cpxNumVarArray = new CpxNumVar[1][];
            byte[] byArray = new byte[1];
            this.getCplexI().getCpxSOSs(this._index.getIndex(), this._index.getIndex(), byArray, cpxNumVarArray, null);
            return cpxNumVarArray[0];
        }
        ExternalSOS externalSOS = (ExternalSOS)this._index;
        return (CpxNumVar[])externalSOS._var.clone();
    }

    public IloNumVar[] getNumVars() throws IloException {
        return this.getCpxNumVars();
    }

    public double[] getValues() throws IloException {
        if (this.isInstalledExt()) {
            double[][] dArrayArray = new double[1][];
            byte[] byArray = new byte[1];
            this.getCplexI().getCpxSOSs(this._index.getIndex(), this._index.getIndex(), byArray, null, dArrayArray);
            return dArrayArray[0];
        }
        ExternalSOS externalSOS = (ExternalSOS)this._index;
        return (double[])externalSOS._val.clone();
    }

    void uninstallCon() throws IloException {
        if (this.isInstalledExt()) {
            CplexIndex[] cplexIndexArray = new CplexIndex[]{this._index};
            CpxNumVar[] cpxNumVarArray = this.getCpxNumVars();
            ExternalSOS externalSOS = new ExternalSOS(this.getSOSType(), cpxNumVarArray, this.getValues());
            this.getCplexI().delSOSs(cplexIndexArray, 0, 1);
            this._index = externalSOS;
            this.getCplexI().unUseVars(cpxNumVarArray, 0, cpxNumVarArray.length);
            this.setCplexI(null);
        }
    }

    void end() throws IloException {
        if (this.isInstalledExt()) {
            CplexIndex[] cplexIndexArray = new CplexIndex[]{this._index};
            this.getCplexI().delSOSs(cplexIndexArray, 0, 1);
        }
        super.end();
    }

    void installCon(CplexI cplexI) throws IloException {
        cplexI.checkCplexI(this);
        if (!this.isInstalledExt()) {
            ExternalSOS externalSOS = (ExternalSOS)this._index;
            cplexI.useVars(externalSOS._var, 0, externalSOS._var.length, true);
            this._index = cplexI.addSOS(this, externalSOS._type, 0, externalSOS._var.length, externalSOS._var, externalSOS._val, this._name);
            this.setCplexI(cplexI);
        }
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        CplexI cplexI = this.getCplexI();
        if (cplexI != null) {
            this.uninstallCon();
        }
        ExternalSOS externalSOS = (ExternalSOS)this._index;
        int n = externalSOS._var.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (externalSOS._var[i]._varIndex == cplexIndex) continue;
            if (n2 < i) {
                externalSOS._var[n2] = externalSOS._var[i];
                externalSOS._val[n2] = externalSOS._val[i];
            }
            ++n2;
        }
        if (n2 < n) {
            CpxNumVar[] cpxNumVarArray = new CpxNumVar[n2];
            double[] dArray = new double[n2];
            System.arraycopy(cpxNumVarArray, 0, externalSOS._var, 0, n2);
            System.arraycopy(dArray, 0, externalSOS._val, 0, n2);
            externalSOS._var = cpxNumVarArray;
            externalSOS._val = dArray;
        }
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    int getIndexValue() {
        return this._index._index;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IloSOS");
        if (this.getSOSType() == 49) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("2");
        }
        if (this.getName() != null) {
            stringBuffer.append(" " + this.getName() + " [");
        } else {
            stringBuffer.append("_" + super.toString() + " [");
        }
        try {
            CpxNumVar[] cpxNumVarArray = this.getCpxNumVars();
            double[] dArray = this.getValues();
            for (int i = 0; i < cpxNumVarArray.length; ++i) {
                stringBuffer.append(cpxNumVarArray[i]);
                stringBuffer.append(":");
                stringBuffer.append(dArray[i]);
                if (i >= cpxNumVarArray.length - 1) continue;
                stringBuffer.append(cpxNumVarArray[i]);
                stringBuffer.append(",\n               ");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    class ExternalSOS
    extends CplexIndex {
        private static final long serialVersionUID = 1210L;
        byte _type;
        CpxNumVar[] _var;
        double[] _val;

        ExternalSOS(byte by, CpxNumVar[] cpxNumVarArray, double[] dArray) {
            super(-1);
            this._type = by;
            this._var = cpxNumVarArray;
            this._val = dArray;
        }
    }
}

