/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.CpxConstExpr;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxLinearNumExpr;
import ilog.cplex.CpxLinkedExpr;
import ilog.cplex.CpxMult;
import ilog.cplex.CpxNegative;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxObjective;
import ilog.cplex.CpxQExpr;
import ilog.cplex.CpxQTerm;
import ilog.cplex.CpxQTermExtractor;

class CpxQextractor
implements CpxExprVisitor {
    CpxLinearExpr _linear;
    CpxQExpr _quad;
    CpxQTermExtractor _term;

    CpxQextractor(CpxObjective cpxObjective) {
        this._linear = cpxObjective._linear;
        this._quad = cpxObjective._quad;
        this._term = new CpxQTermExtractor();
    }

    CpxQextractor() {
        this._term = new CpxQTermExtractor();
        this._quad = new CpxQExpr();
        this._linear = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
    }

    public Object visitNumVar(CpxNumVar cpxNumVar) throws IloException {
        this._linear.addCoef(cpxNumVar, 1.0);
        return this;
    }

    public Object visitLinearExpr(CpxLinearExpr cpxLinearExpr) throws IloException {
        this._linear.addCoefs(cpxLinearExpr);
        this._linear._const += cpxLinearExpr._const;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitNegative(CpxNegative cpxNegative) throws IloException {
        CpxLinearExpr cpxLinearExpr = this._linear;
        CpxQExpr cpxQExpr = this._quad;
        this._linear = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        this._quad = new CpxQExpr();
        try {
            if (cpxNegative.getExpr().accept(this) == null) {
                this._linear = cpxLinearExpr;
                this._quad = cpxQExpr;
                Object var4_4 = null;
                return var4_4;
            }
            this._linear.scaleBy(-1.0);
            this._quad.scaleBy(-1.0);
            cpxLinearExpr.addCoefs(this._linear);
            cpxQExpr.addCoefs(this._quad);
            cpxLinearExpr._const -= this._linear._const;
        }
        finally {
            this._linear = cpxLinearExpr;
            this._quad = cpxQExpr;
        }
        return this;
    }

    public Object visitLinkedExpr(CpxLinkedExpr cpxLinkedExpr) throws IloException {
        Object object = null;
        CpxLinkedExpr.Link link = cpxLinkedExpr.first;
        while (link != cpxLinkedExpr.last) {
            object = link.expr.accept(this);
            if (object == null) {
                return null;
            }
            link = link.next;
        }
        if (cpxLinkedExpr.last != null && (object = cpxLinkedExpr.last.expr.accept(this)) == null) {
            return null;
        }
        return object;
    }

    public Object visitQTerm(CpxQTerm cpxQTerm) throws IloException {
        this._quad.addCoef(cpxQTerm.getVar1(), cpxQTerm.getVar2(), cpxQTerm.getVal());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitMult(CpxMult cpxMult) throws IloException {
        this._term.clear();
        if (cpxMult.accept(this._term) != null) {
            this._term.install(this._linear, this._quad);
            return this;
        }
        CpxLinearExpr cpxLinearExpr = this._linear;
        CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        CpxLinearNumExpr cpxLinearNumExpr2 = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        CpxQExpr cpxQExpr = this._quad;
        CpxQExpr cpxQExpr2 = new CpxQExpr();
        CpxQExpr cpxQExpr3 = new CpxQExpr();
        try {
            this._linear = cpxLinearNumExpr;
            this._quad = cpxQExpr2;
            if (cpxMult.getRight().accept(this) == null) {
                this._linear = cpxLinearExpr;
                this._quad = cpxQExpr;
                Object var8_8 = null;
                return var8_8;
            }
            this._linear = cpxLinearNumExpr2;
            this._quad = cpxQExpr3;
            if (cpxMult.getLeft().accept(this) == null) {
                this._linear = cpxLinearExpr;
                this._quad = cpxQExpr;
                Object var8_9 = null;
                return var8_9;
            }
        }
        finally {
            this._linear = cpxLinearExpr;
            this._quad = cpxQExpr;
        }
        if (cpxLinearNumExpr._const != 0.0) {
            cpxLinearNumExpr2.scaleBy(cpxLinearNumExpr._const);
            this._linear.addCoefs(cpxLinearNumExpr2);
            cpxLinearNumExpr2.scaleBy(1.0 / cpxLinearNumExpr._const);
            cpxQExpr3.scaleBy(cpxLinearNumExpr._const);
            cpxQExpr.addCoefs(cpxQExpr3.getNumVar1(), cpxQExpr3.getNumVar2(), cpxQExpr3.getNumVal(), 0, cpxQExpr3.getNum());
            cpxQExpr3.scaleBy(1.0 / cpxLinearNumExpr._const);
            this._linear._const += cpxLinearNumExpr._const * cpxLinearNumExpr2._const;
        }
        if (cpxLinearNumExpr.getNum() > 0) {
            if (cpxQExpr3.getNum() > 0) {
                return null;
            }
            if (cpxLinearNumExpr2.getNum() > 0) {
                int n = cpxLinearNumExpr.getNum();
                double[] dArray = cpxLinearNumExpr.getValues();
                CpxNumVar[] cpxNumVarArray = cpxLinearNumExpr.getNumVars();
                int n2 = cpxLinearNumExpr2.getNum();
                double[] dArray2 = cpxLinearNumExpr2.getValues();
                CpxNumVar[] cpxNumVarArray2 = cpxLinearNumExpr2.getNumVars();
                int n3 = n * n2;
                double[] dArray3 = new double[n3];
                CpxNumVar[] cpxNumVarArray3 = new CpxNumVar[n3];
                CpxNumVar[] cpxNumVarArray4 = new CpxNumVar[n3];
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        dArray3[n4] = dArray[i] * dArray2[j];
                        cpxNumVarArray3[n4] = cpxNumVarArray[i];
                        cpxNumVarArray4[n4] = cpxNumVarArray2[j];
                        ++n4;
                    }
                }
                cpxQExpr.addCoefs(cpxNumVarArray3, cpxNumVarArray4, dArray3, 0, n3);
            }
            if (cpxLinearNumExpr2._const != 0.0) {
                cpxLinearNumExpr.scaleBy(cpxLinearNumExpr2._const);
                this._linear.addCoefs(cpxLinearNumExpr);
                cpxLinearNumExpr.scaleBy(1.0 / cpxLinearNumExpr2._const);
            }
        }
        if (cpxQExpr2.getNum() > 0) {
            if (cpxQExpr3.getNum() > 0 || cpxLinearNumExpr2.getNum() > 0) {
                return null;
            }
            if (cpxLinearNumExpr2._const != 0.0) {
                cpxQExpr2.scaleBy(cpxLinearNumExpr2._const);
                this._quad.addCoefs(cpxQExpr2);
                cpxQExpr2.scaleBy(1.0 / cpxLinearNumExpr2._const);
            }
        }
        return this;
    }

    public Object visitConst(CpxConstExpr cpxConstExpr) throws IloException {
        this._linear._const += cpxConstExpr.getValue();
        return this;
    }
}

