/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloMPModeler;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVarType;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxSubExpr;
import ilog.cplex.CpxSubVar;
import ilog.cplex.IloCplexModeler;

public class CpxPWLVar
extends CpxSubVar {
    private static final long serialVersionUID = 1210L;
    private CpxNumExpr _base;
    private double[] _point;
    private double[] _slope;
    private double _a;
    private double _fa;
    CplexIndex _gcIndex;
    CpxSubExpr _subExpr;

    public CpxPWLVar(CpxNumExpr cpxNumExpr, double[] dArray, int n, int n2, double[] dArray2, int n3, double d, double d2, String string) throws IloException {
        super(-1.7976931348623157E308, Double.MAX_VALUE, IloNumVarType.Float, string);
        if (n + n2 > dArray.length) {
            throw new ArrayIndexOutOfBoundsException(n + n2);
        }
        if (n3 + n2 + 1 > dArray2.length) {
            throw new ArrayIndexOutOfBoundsException(n3 + n2 + 1);
        }
        this._point = new double[n2 + 2];
        this._slope = new double[n2 + 1];
        for (int i = 0; i < this._point.length - 2; ++i) {
            this._point[i] = dArray[i + n];
            this._slope[i] = dArray2[i + n3];
            if (i < 1 || !(this._point[i - 1] > this._point[i])) continue;
            throw new IloException("Points in piecewiseLinear must be ordered");
        }
        this._slope[n2] = dArray2[n3 + n2];
        this._point[n2] = -1.0;
        this._point[n2 + 1] = 1.0;
        this._base = cpxNumExpr;
        this._a = d;
        this._fa = d2;
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloMPModeler iloMPModeler = (IloMPModeler)iloCopyManager.getModeler();
        return iloMPModeler.piecewiseLinear((IloNumExpr)iloCopyManager.getCopy(this._base), this._point, this._slope, this._a, this._fa);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        throw check;
    }

    void removeVarsFromSubVar(CplexIndex cplexIndex) throws IloException {
        CpxNumExpr[] cpxNumExprArray = new CpxNumExpr[]{this._base};
        this.removeVarsFromSubExpr(cpxNumExprArray, cplexIndex);
        this._base = cpxNumExprArray[0];
    }

    void installVar(IloCplexModeler iloCplexModeler) throws IloException {
        double[] dArray = new double[this._point.length - 2];
        System.arraycopy(this._point, 0, dArray, 0, dArray.length);
        this._subExpr = new CpxSubExpr(this._base, null);
        CpxNumVar[] cpxNumVarArray = new CpxNumVar[]{this._subExpr};
        this.getCplexI().useVars(cpxNumVarArray, 0, 1, true);
        this._gcIndex = this.getCplexI().addPWL(this, this._varIndex, dArray, this._slope, this._a, this._fa, this._subExpr.getVarIndex(), this.getName());
    }

    void uninstallVar(IloCplexModeler iloCplexModeler) throws IloException {
        this.getCplexI().unUseVar(this._subExpr);
        this._subExpr = null;
        this.getCplexI().deleteGC(this._gcIndex, 9);
        this._gcIndex = null;
    }

    public Object accept(CpxExprVisitor cpxExprVisitor) throws IloException {
        return cpxExprVisitor.visitNumVar(this);
    }
}

