/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloColumn;
import ilog.concert.IloColumnArray;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloMPModeler;
import ilog.concert.IloModeler;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.concert.IloObjective;
import ilog.concert.IloObjectiveSense;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxLinearExpr;
import ilog.cplex.CpxLinearNumExpr;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxQExpr;
import ilog.cplex.CpxQTerm;
import ilog.cplex.CpxQextractor;
import ilog.cplex.IloCplex;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CpxObjective
extends CpxExtractable
implements IloObjective {
    private static final long serialVersionUID = 1210L;
    IloObjectiveSense _sense;
    CpxLinearExpr _linear;
    CpxQExpr _quad;
    CpxNumVar _const;

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloModeler iloModeler = iloCopyManager.getModeler();
        if (iloModeler instanceof IloMPModeler) {
            IloLinearNumExpr iloLinearNumExpr = (IloLinearNumExpr)iloCopyManager.getCopy(this._linear);
            CpxQExpr cpxQExpr = this._quad.makeCopy();
            CpxObjective cpxObjective = (CpxObjective)iloModeler.objective(this._sense, iloLinearNumExpr, this.getName());
            cpxObjective._quad = cpxQExpr;
            return cpxObjective;
        }
        return iloModeler.objective(this._sense, (IloNumExpr)iloCopyManager.getCopy(this.getExpr()), this.getName());
    }

    void end() throws IloException {
        if (this.isInstalledExt()) {
            this.getCplexI().setObjective(this.getSense(), 0, null, null, 0, null, null, null);
            if (this._const.getLB() != 0.0) {
                this.getCplexI().unUseVar(this._const);
            }
            if (this._const._varIndex != null) {
                this.getCplexI().delColumn(this._const._varIndex);
            }
            this._const._varIndex = null;
            this.setCplexI(null);
            this._const.setCplexI(null);
        }
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        this._linear.removeVars(cplexIndex);
        this._quad.removeVars(cplexIndex);
    }

    public IloObjectiveSense getSense() {
        return this._sense;
    }

    public void setSense(IloObjectiveSense iloObjectiveSense) throws IloException {
        if (this.isInstalledExt()) {
            this.getCplexI().setSense(iloObjectiveSense.getValue());
        }
        this._sense = iloObjectiveSense;
    }

    public IloNumExpr getExpr() throws IloException {
        CpxNumExpr cpxNumExpr = new CpxLinearNumExpr(this._linear.getValues(), this._linear.getNumVars(), 0, this._linear.getNum(), this._linear._const);
        for (int i = 0; i < this._quad._num; ++i) {
            cpxNumExpr = IloCplex.staticSum(cpxNumExpr, new CpxQTerm(this._quad._val[i], this._quad._var1[i], this._quad._var2[i]));
        }
        return cpxNumExpr;
    }

    public void setExpr(IloNumExpr iloNumExpr) throws IloException {
        CplexI cplexI = this.getCplexI();
        this.uninstallCon();
        this._linear.clear();
        this._quad.clear();
        if (iloNumExpr != null) {
            CpxQextractor cpxQextractor = new CpxQextractor(this);
            if (((CpxNumExpr)iloNumExpr).accept(cpxQextractor) == null) {
                throw new UnsupportedOperationException("CpxObjective for general expressions");
            }
            this._linear.removeDuplicates();
            if (this._linear._const != 0.0) {
                this._const.setLB(this._linear._const);
                this._const.setUB(this._linear._const);
                this._linear._const = 0.0;
                this._linear.addTerm((IloNumVar)this._const, 1.0);
            }
        }
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    public void setLinearCoef(double d, IloNumVar iloNumVar) throws IloException {
        this.setLinearCoef(iloNumVar, d);
    }

    public void setLinearCoef(IloNumVar iloNumVar, double d) throws IloException {
        CpxNumVar cpxNumVar = (CpxNumVar)iloNumVar;
        int n = this._linear.find(cpxNumVar);
        if (n < 0) {
            if (this.isInstalledExt()) {
                this.getCplexI().useVar(cpxNumVar, true);
            }
            n = this._linear.getNum();
            if (d != 0.0) {
                this._linear.addCoef(cpxNumVar, d);
            }
        } else if (d != 0.0) {
            this._linear.setCoef(n, d);
        } else {
            this._linear.remove(n);
        }
        if (this.isInstalledExt()) {
            this.getCplexI().setObjCoef(cpxNumVar.getVarIndex(), d);
        }
    }

    public void setLinearCoefs(double[] dArray, IloNumVar[] iloNumVarArray) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, 0, iloNumVarArray.length);
    }

    public void setLinearCoefs(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, 0, iloNumVarArray.length);
    }

    public void setLinearCoefs(double[] dArray, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        this.setLinearCoefs(iloNumVarArray, dArray, n, n2);
    }

    public void setLinearCoefs(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
        int n3;
        CpxNumVar[] cpxNumVarArray;
        this._linear.markVars();
        CplexIndex[] cplexIndexArray = new CplexIndex[n2 + n];
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            cpxNumVarArray = (CpxNumVar[])iloNumVarArray[i];
            if (cpxNumVarArray.isMarked()) {
                this._linear.setCoef(cpxNumVarArray.getVarIndexValue(), dArray[i]);
                cplexIndexArray[i] = cpxNumVarArray.getOriginalIndex();
                continue;
            }
            if (this.isInstalledExt()) {
                this.getCplexI().useVar((CpxNumVar)cpxNumVarArray, true);
                cplexIndexArray[i] = cpxNumVarArray.getVarIndex();
            }
            cpxNumVarArray.mark(-1);
            this._linear.addCoef((CpxNumVar)cpxNumVarArray, dArray[i]);
        }
        this._linear.unmarkVars();
        if (this.isInstalledExt()) {
            this.getCplexI().setObjCoefs(cplexIndexArray, dArray, n, n2);
        }
        double[] dArray2 = this._linear.getValues();
        cpxNumVarArray = this._linear.getNumVars();
        int n5 = this._linear.getNum();
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (dArray2[n3] == 0.0) continue;
            dArray2[n6] = dArray2[n3];
            cpxNumVarArray[n6] = cpxNumVarArray[n3];
            ++n6;
        }
        this._linear._num = n6;
        for (n3 = n6; n3 < n5; ++n3) {
            cpxNumVarArray[n3] = null;
        }
    }

    public void addToExpr(IloNumExpr iloNumExpr) throws IloException {
        CplexI cplexI = this.getCplexI();
        this.uninstallCon();
        CpxQextractor cpxQextractor = new CpxQextractor(this);
        if (((CpxNumExpr)iloNumExpr).accept(cpxQextractor) == null) {
            throw new UnsupportedOperationException("CpxObjective for general expressions");
        }
        this._linear.removeDuplicates();
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    public void clearExpr() throws IloException {
        CplexI cplexI = this.getCplexI();
        this.uninstallCon();
        this._linear.clear();
        this._quad.clear();
        this._const.setLB(0.0);
        this._const.setUB(0.0);
        this._linear._const = 0.0;
        if (cplexI != null) {
            this.installCon(cplexI);
        }
    }

    public IloColumn makeColumn(double d) throws IloException {
        return new ObjColumn(this, d);
    }

    public IloColumnArray makeColumnArray(double[] dArray, int n, int n2) throws IloException {
        return new ObjColumnArray(this, dArray, n, n2);
    }

    protected CpxObjective(IloObjectiveSense iloObjectiveSense, CpxNumExpr cpxNumExpr, String string) throws IloException {
        super(null);
        this._sense = iloObjectiveSense;
        this._quad = new CpxQExpr();
        this._const = new CpxNumVar(0.0, 0.0, IloNumVarType.Float, string);
        this._linear = new CpxLinearNumExpr();
        if (cpxNumExpr != null) {
            this.setExpr(cpxNumExpr);
        }
    }

    void deleteColumn(CpxNumVar cpxNumVar) throws IloException {
        this._linear.remove(cpxNumVar);
        this._quad.remove(cpxNumVar);
    }

    public void deleteColumns(CpxNumVar[] cpxNumVarArray, int n, int n2) throws IloException {
        int n3;
        int n4 = n + n2;
        for (n3 = n; n3 < n4; ++n3) {
            cpxNumVarArray[n3].mark(-1);
        }
        this._linear.removeMarked();
        this._quad.removeMarked();
        for (n3 = n; n3 < n4; ++n3) {
            cpxNumVarArray[n3].unmark();
        }
    }

    CpxNumVar[] getVars() throws IloException {
        int n = this._linear.getNum();
        CpxNumVar[] cpxNumVarArray = this._linear.getNumVars();
        int n2 = this._quad.getNum();
        CpxNumVar[] cpxNumVarArray2 = this._quad.getNumVar1();
        CpxNumVar[] cpxNumVarArray3 = this._quad.getNumVar2();
        CpxNumVar[] cpxNumVarArray4 = null;
        if (n >= 1 || n2 >= 1) {
            cpxNumVarArray4 = new CpxNumVar[n + 2 * n2];
            System.arraycopy(cpxNumVarArray, 0, cpxNumVarArray4, 0, n);
            System.arraycopy(cpxNumVarArray2, 0, cpxNumVarArray4, n, n2);
            System.arraycopy(cpxNumVarArray3, 0, cpxNumVarArray4, n + n2, n2);
        }
        return cpxNumVarArray4;
    }

    void addNewToExpr(CpxNumVar cpxNumVar, double d) throws IloException {
        this._linear.addCoef(cpxNumVar, d);
        if (this.isInstalledExt()) {
            this.getCplexI().useVar(cpxNumVar, true);
            this.getCplexI().setObjCoef(cpxNumVar.getVarIndex(), d);
        }
    }

    void addNewToExpr(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        CpxNumVar[] cpxNumVarArray = new CpxNumVar[n3];
        for (int i = n; i < n3; ++i) {
            cpxNumVarArray[i] = (CpxNumVar)iloNumVarArray[i];
        }
        this._linear.addCoefs(cpxNumVarArray, dArray, n, n2);
        if (this.isInstalledExt()) {
            this.getCplexI().useVars(cpxNumVarArray, n, n2, true);
            CplexIndex[] cplexIndexArray = new CplexIndex[n3];
            for (int i = n; i < n3; ++i) {
                cplexIndexArray[i] = cpxNumVarArray[i].getVarIndex();
            }
            this.getCplexI().setObjCoefs(cplexIndexArray, dArray, n, n2);
        }
    }

    void installCon(CplexI cplexI) throws IloException {
        int n;
        cplexI.checkCplexI(this);
        if (this.isInstalledExt()) {
            return;
        }
        this.setCplexI(cplexI);
        this._const.setCplexI(cplexI);
        CpxNumVar[] cpxNumVarArray = this.getVars();
        if (cpxNumVarArray != null) {
            cplexI.useVars(cpxNumVarArray, 0, cpxNumVarArray.length, true);
        }
        if (this._const.getLB() != 0.0) {
            cplexI.useVar(this._const, true);
        }
        int n2 = this._linear.getNum();
        CplexIndex[] cplexIndexArray = new CplexIndex[n2];
        CpxNumVar[] cpxNumVarArray2 = this._linear.getNumVars();
        for (n = 0; n < n2; ++n) {
            cplexIndexArray[n] = cpxNumVarArray2[n].getVarIndex();
        }
        n = this._quad.getNum();
        if (n > 0) {
            CpxNumVar[] cpxNumVarArray3 = this._quad.getNumVar1();
            CpxNumVar[] cpxNumVarArray4 = this._quad.getNumVar2();
            CplexIndex[] cplexIndexArray2 = new CplexIndex[n];
            CplexIndex[] cplexIndexArray3 = new CplexIndex[n];
            for (int i = 0; i < n; ++i) {
                cplexIndexArray2[i] = cpxNumVarArray3[i].getVarIndex();
                cplexIndexArray3[i] = cpxNumVarArray4[i].getVarIndex();
            }
            cplexI.setObjective(this.getSense(), n2, cplexIndexArray, this._linear.getValues(), n, this._quad.getNumVal(), cplexIndexArray2, cplexIndexArray3);
        } else {
            cplexI.setObjective(this.getSense(), n2, cplexIndexArray, this._linear.getValues(), 0, null, null, null);
        }
    }

    void uninstallCon() throws IloException {
        if (this.isInstalledExt()) {
            this.getCplexI().setObjective(this.getSense(), 0, null, null, 0, null, null, null);
            CpxNumVar[] cpxNumVarArray = this.getVars();
            if (cpxNumVarArray != null) {
                this.getCplexI().unUseVars(cpxNumVarArray, 0, cpxNumVarArray.length);
            }
            if (this._const.getLB() != 0.0) {
                this.getCplexI().unUseVar(this._const);
            }
            if (this._const._varIndex != null) {
                this.getCplexI().delColumn(this._const._varIndex);
            }
            this._const._varIndex = null;
            this.setCplexI(null);
            this._const.setCplexI(null);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._sense == IloObjectiveSense.Minimize) {
            stringBuffer.append("IloMinimize ");
        } else {
            stringBuffer.append("IloMaximize ");
        }
        if (this.getName() != null) {
            stringBuffer.append(this.getName());
        }
        stringBuffer.append(" : ");
        stringBuffer.append(this._linear);
        for (int i = 0; i < this._quad._num; ++i) {
            stringBuffer.append(" ");
            double d = this._quad._val[i];
            if (d < 0.0) {
                stringBuffer.append(d);
            } else {
                stringBuffer.append("+");
                stringBuffer.append(d);
            }
            stringBuffer.append("*");
            stringBuffer.append(this._quad._var1[i]);
            stringBuffer.append("*");
            stringBuffer.append(this._quad._var2[i]);
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this._sense == IloObjectiveSense.Minimize) {
            objectOutputStream.writeInt(1);
        } else {
            objectOutputStream.writeInt(-1);
        }
        objectOutputStream.writeObject(this._linear);
        objectOutputStream.writeObject(this._quad);
        objectOutputStream.writeObject(this._const);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._sense = objectInputStream.readInt() > 0 ? IloObjectiveSense.Minimize : IloObjectiveSense.Maximize;
        this._linear = (CpxLinearExpr)objectInputStream.readObject();
        this._quad = (CpxQExpr)objectInputStream.readObject();
        this._const = (CpxNumVar)objectInputStream.readObject();
    }

    private class ObjColumnArray
    extends IloColumnArray {
        CpxObjective _obj;
        double[] _val;
        int _start;
        int _num;

        ObjColumnArray(CpxObjective cpxObjective2, double[] dArray, int n, int n2) throws IloException {
            this._obj = cpxObjective2;
            this._val = dArray;
            this._start = n;
            this._num = n2;
        }

        public int getSize() {
            return this._num;
        }

        public void install(IloNumVar[] iloNumVarArray) throws IloException {
            double[] dArray = new double[this._num];
            System.arraycopy(this._val, this._start, dArray, 0, this._num);
            this._obj.addNewToExpr(iloNumVarArray, dArray, 0, this._num);
        }
    }

    private class ObjColumn
    extends IloColumn {
        CpxObjective _obj;
        double _val;

        ObjColumn(CpxObjective cpxObjective2, double d) throws IloException {
            this._obj = cpxObjective2;
            this._val = d;
        }

        public void install(IloNumVar iloNumVar) throws IloException {
            this._obj.addNewToExpr((CpxNumVar)iloNumVar, this._val);
        }
    }
}

