/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloColumn;
import ilog.concert.IloConversion;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntVar;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.MultipleConversionException;
import ilog.cplex.TmpIndex;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class CpxNumVar
extends CpxExtractable
implements CpxNumExpr,
IloNumVar,
IloIntVar {
    private static final long serialVersionUID = 1210L;
    double _lb;
    double _ub;
    byte _type;
    CplexIndex _varIndex;
    private IloNumVarType _conv;
    private static byte[] _TypeByte = new byte[]{67, 73, 66};

    void end() throws IloException {
        if (this.getCplexI() != null && this._varIndex != null) {
            this.getCplexI().delColumn(this._varIndex);
            this._varIndex = null;
        }
        super.end();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        CplexIndex cplexIndex = this._varIndex;
        this._varIndex = null;
        objectOutputStream.defaultWriteObject();
        this._varIndex = cplexIndex;
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        return iloCopyManager.getModeler().numVar(this.getLB(), this.getUB(), this.getType(), this.getName());
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        throw new UnsupportedOperationException("this should not happen");
    }

    public Object accept(CpxExprVisitor cpxExprVisitor) throws IloException {
        return cpxExprVisitor.visitNumVar(this);
    }

    public double getLB() throws IloException {
        return this._lb;
    }

    public int getMin() throws IloException {
        if (this._lb >= 0.0) {
            return (int)(this._lb + 1.0 - 1.0E-10);
        }
        if (this._lb > -2.147483647E9) {
            return (int)this._lb;
        }
        return -2147483647;
    }

    public double getUB() throws IloException {
        return this._ub;
    }

    public int getMax() throws IloException {
        if (this._ub < 0.0) {
            return (int)(this._ub - 1.0 + 1.0E-10);
        }
        if (this._ub < 2.147483647E9) {
            return (int)this._ub;
        }
        return Integer.MAX_VALUE;
    }

    public IloNumVarType getType() throws IloException {
        if (this._type == 83 || this._type == 67) {
            return IloNumVarType.Float;
        }
        if (this._type == 78 || this._type == 73) {
            return IloNumVarType.Int;
        }
        return IloNumVarType.Bool;
    }

    public void setLB(double d) throws IloException {
        this._lb = d <= -1.0E20 ? -1.0E20 : d;
        if (this.getCplexI() != null) {
            this.getCplexI().setLB(this._varIndex, this.getCpxLB());
        }
    }

    public void setMin(int n) throws IloException {
        if (n <= -2147483647) {
            this.setLB(-1.0E20);
        } else {
            this.setLB(n);
        }
    }

    public void setUB(double d) throws IloException {
        this._ub = d >= 1.0E20 ? 1.0E20 : d;
        if (this.getCplexI() != null) {
            this.getCplexI().setUB(this._varIndex, d);
        }
    }

    public void setMax(int n) throws IloException {
        if (n >= Integer.MAX_VALUE) {
            this.setUB(1.0E20);
        } else {
            this.setUB(n);
        }
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (this._lb <= -1.0E20) {
            stringBuffer.append("-infinity");
        } else if (this._type == 67) {
            stringBuffer.append(this._lb);
        } else {
            stringBuffer.append((long)this._lb);
        }
        stringBuffer.append("..");
        if (this._ub >= 1.0E20) {
            stringBuffer.append("infinity");
        } else if (this._type == 67) {
            stringBuffer.append(this._ub);
        } else {
            stringBuffer.append((long)this._ub);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected CpxNumVar(double d, double d2, IloNumVarType iloNumVarType, String string) throws IloException {
        super(string);
        this._lb = d;
        this._ub = d2;
        this._type = CpxNumVar.getTypeByte(iloNumVarType);
    }

    protected CpxNumVar(IloColumn iloColumn, double d, double d2, IloNumVarType iloNumVarType, String string) throws IloException {
        this(d, d2, iloNumVarType, string);
        if (iloColumn != null) {
            iloColumn.install(this);
        }
    }

    protected CpxNumVar(IloColumn iloColumn, double d, double d2, byte by, String string) throws IloException {
        super(string);
        this._lb = d;
        this._ub = d2;
        this._type = by;
        if (iloColumn != null) {
            iloColumn.install(this);
        }
    }

    double getCpxLB() throws IloException {
        return this._lb;
    }

    double getCpxUB() throws IloException {
        return this._ub;
    }

    byte getCpxType() throws IloException {
        return this.getConvType();
    }

    static byte getTypeByte(IloNumVarType iloNumVarType) {
        return _TypeByte[iloNumVarType.getTypeValue()];
    }

    byte getTypeByte() {
        return this._type;
    }

    final byte getConvType() {
        if (this._conv != null) {
            return CpxNumVar.getTypeByte(this._conv);
        }
        return this.getTypeByte();
    }

    void setConversion(IloConversion iloConversion, IloNumVarType iloNumVarType) throws MultipleConversionException, IloException {
        if (this._conv != null) {
            throw new MultipleConversionException(this);
        }
        this._conv = iloNumVarType;
        if (this.getCplexI() != null) {
            this.getCplexI().setType(this._varIndex, this.getCpxType());
            this.getCplexI().setLB(this._varIndex, this._lb);
        }
    }

    void clearConversion() throws IloException {
        this._conv = null;
        if (this.getCplexI() != null) {
            this.getCplexI().setType(this._varIndex, this.getCpxType());
            this.getCplexI().setLB(this._varIndex, this.getCpxLB());
        }
    }

    void setIndex(CplexIndex cplexIndex, CplexI cplexI) throws IloException {
        this._varIndex = cplexIndex;
        this.setCplexI(cplexI);
    }

    CplexIndex getVarIndex() {
        return this._varIndex;
    }

    int getVarIndexValue() {
        return this._varIndex._index;
    }

    CplexIndex getOriginalIndex() {
        return ((TmpIndex)this._varIndex)._orig;
    }

    boolean isMarked() {
        return this._varIndex instanceof TmpIndex;
    }

    void mark(int n) {
        TmpIndex tmpIndex = new TmpIndex(n);
        tmpIndex.install(this);
    }

    void unmark() {
        ((TmpIndex)this._varIndex).uninstall(this);
    }
}

