/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloAddable;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloModel;
import ilog.concert.IloNumVar;
import ilog.cplex.CplexI;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxConversion;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxGC;
import ilog.cplex.CpxLPMatrix;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxObjective;
import ilog.cplex.CpxRange;
import ilog.cplex.CpxSOS;
import ilog.cplex.CpxSOS1;
import ilog.cplex.CpxSOS2;
import ilog.cplex.IloCplex;
import ilog.cplex.LinkedList;
import ilog.cplex.ListIterator;
import ilog.cplex.MultipleConversionException;
import ilog.cplex.MultipleObjectiveException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CpxModel
extends CpxExtractable
implements IloModel {
    private static final long serialVersionUID = 1210L;
    CpxObjective _obj = null;
    LinkedList _lp = new LinkedList();
    LinkedList _conv = new LinkedList();
    LinkedList _sos1 = new LinkedList();
    LinkedList _sos2 = new LinkedList();
    LinkedList _range = new LinkedList();
    LinkedList _gc = new LinkedList();
    LinkedList _var = new LinkedList();

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        throw new UnsupportedOperationException();
    }

    void installCon(CplexI cplexI) throws IloException {
        cplexI.checkCplexI(this);
        if (!this.isInstalledExt()) {
            this.setCplexI(cplexI);
            if (this._obj != null) {
                this._obj.installCon(cplexI);
            }
            Iterator iterator = this._lp.iterator();
            while (iterator.hasNext()) {
                ((CpxLPMatrix)iterator.next()).installCon(cplexI);
            }
            iterator = this._sos1.iterator();
            while (iterator.hasNext()) {
                ((CpxSOS)iterator.next()).installCon(cplexI);
            }
            iterator = this._sos2.iterator();
            while (iterator.hasNext()) {
                ((CpxSOS)iterator.next()).installCon(cplexI);
            }
            iterator = this._range.listIterator();
            while (iterator.hasNext()) {
                ((CpxRange)iterator.next()).installCon(cplexI);
            }
            iterator = this._gc.listIterator();
            while (iterator.hasNext()) {
                ((CpxGC)iterator.next()).installCon(cplexI);
            }
            iterator = this._var.listIterator();
            while (iterator.hasNext()) {
                cplexI.useVar((CpxNumVar)iterator.next(), true);
            }
        }
    }

    void uninstallCon() throws IloException {
        this.uninstallAll();
        this.setCplexI(null);
    }

    void uninstallAll() throws IloException {
        if (this.isInstalledExt()) {
            Object object;
            if (this._obj != null) {
                this._obj.uninstallCon();
            }
            CpxRange[] cpxRangeArray = this._lp.iterator();
            while (cpxRangeArray.hasNext()) {
                ((CpxLPMatrix)cpxRangeArray.next()).uninstallCon();
            }
            cpxRangeArray = this._sos1.iterator();
            while (cpxRangeArray.hasNext()) {
                ((CpxSOS)cpxRangeArray.next()).uninstallCon();
            }
            cpxRangeArray = this._sos2.iterator();
            while (cpxRangeArray.hasNext()) {
                ((CpxSOS)cpxRangeArray.next()).uninstallCon();
            }
            cpxRangeArray = new CpxRange[this._range.size()];
            int n = 0;
            ListIterator listIterator = this._range.listIterator();
            while (listIterator.hasNext()) {
                object = (CpxRange)listIterator.next();
                if (((CpxRange)object).isQC()) {
                    ((CpxRange)object).uninstallCon();
                    continue;
                }
                cpxRangeArray[n++] = object;
            }
            if (n > 0) {
                CpxRange.uninstallRows(cpxRangeArray, n);
            }
            object = this._conv.listIterator();
            while (((ListIterator)object).hasNext()) {
                ((CpxConversion)((ListIterator)object).next()).uninstallCon();
            }
            Iterator iterator = this._gc.iterator();
            while (iterator.hasNext()) {
                ((CpxGC)iterator.next()).uninstallCon();
            }
            iterator = this._var.iterator();
            while (iterator.hasNext()) {
                this._cplexi.unUseVar((CpxNumVar)iterator.next());
            }
            this._cplexi.clearModel();
        }
    }

    void endAll() throws IloException {
        this._obj = null;
        this._lp = new LinkedList();
        this._range = new LinkedList();
        this._sos1 = new LinkedList();
        this._sos2 = new LinkedList();
        this._conv = new LinkedList();
        this._gc = new LinkedList();
        this._var = new LinkedList();
    }

    public IloAddable add(IloAddable iloAddable) throws IloException {
        if (iloAddable == null) {
            return null;
        }
        CpxExtractable cpxExtractable = (CpxExtractable)iloAddable;
        if (cpxExtractable instanceof CpxRange) {
            this.add((CpxRange)cpxExtractable);
        } else if (cpxExtractable instanceof CpxLPMatrix) {
            this.add((CpxLPMatrix)cpxExtractable);
        } else if (cpxExtractable instanceof CpxObjective) {
            this.add((CpxObjective)cpxExtractable);
        } else if (cpxExtractable instanceof CpxSOS1) {
            this.add((CpxSOS1)cpxExtractable);
        } else if (cpxExtractable instanceof CpxSOS2) {
            this.add((CpxSOS2)cpxExtractable);
        } else if (cpxExtractable instanceof CpxConversion) {
            this.add((CpxConversion)cpxExtractable);
        } else if (cpxExtractable instanceof CpxGC) {
            this.add((CpxGC)cpxExtractable);
        } else if (cpxExtractable instanceof CpxNumVar) {
            this.add((CpxNumVar)cpxExtractable);
        } else {
            throw new IloCplex.UnsupportedObjectException(cpxExtractable);
        }
        return cpxExtractable;
    }

    public IloAddable[] add(IloAddable[] iloAddableArray) throws IloException {
        return this.add(iloAddableArray, 0, iloAddableArray.length);
    }

    public IloAddable[] add(IloAddable[] iloAddableArray, int n, int n2) throws IloException {
        if (iloAddableArray == null) {
            return null;
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            IloAddable iloAddable = this.add(iloAddableArray[i]);
            if (iloAddable == iloAddableArray[i]) continue;
            IloAddable[] iloAddableArray2 = new IloAddable[n2];
            for (int j = n; j < i; ++j) {
                iloAddableArray2[j - n] = iloAddableArray[j];
            }
            iloAddableArray2[i - n] = iloAddable;
            ++i;
            while (i < n3) {
                iloAddableArray2[i - n] = this.add(iloAddableArray[i]);
                ++i;
            }
            return iloAddableArray2;
        }
        return iloAddableArray;
    }

    public IloAddable remove(IloAddable iloAddable) throws IloException {
        if (iloAddable == null) {
            return iloAddable;
        }
        CpxExtractable cpxExtractable = (CpxExtractable)iloAddable;
        if (cpxExtractable == this._obj) {
            this.remove((CpxObjective)cpxExtractable);
        } else if (cpxExtractable instanceof CpxRange) {
            this.remove((CpxRange)cpxExtractable);
        } else if (cpxExtractable instanceof CpxLPMatrix) {
            this.remove((CpxLPMatrix)cpxExtractable);
        } else if (cpxExtractable instanceof CpxSOS1) {
            this.remove((CpxSOS1)cpxExtractable);
        } else if (cpxExtractable instanceof CpxSOS2) {
            this.remove((CpxSOS2)cpxExtractable);
        } else if (cpxExtractable instanceof CpxConversion) {
            this.remove((CpxConversion)cpxExtractable);
        } else if (cpxExtractable instanceof CpxGC) {
            this.remove((CpxGC)cpxExtractable);
        } else if (cpxExtractable instanceof CpxNumVar) {
            this.remove((CpxNumVar)cpxExtractable);
        }
        return iloAddable;
    }

    public IloAddable[] remove(IloAddable[] iloAddableArray) throws IloException {
        return this.remove(iloAddableArray, 0, iloAddableArray.length);
    }

    public IloAddable[] remove(IloAddable[] iloAddableArray, int n, int n2) throws IloException {
        CplexI cplexI = this.getCplexI();
        CpxRange[] cpxRangeArray = new CpxRange[n2];
        CpxRange[] cpxRangeArray2 = new CpxRange[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 + n;
        for (int i = n; i < n5; ++i) {
            if (iloAddableArray[i] instanceof CpxRange) {
                CpxRange cpxRange = (CpxRange)iloAddableArray[i];
                if (cplexI != null && cplexI._registerAdd != -1) continue;
                cpxRangeArray2[n4++] = cpxRange;
                if (cplexI == null || cpxRange.getCplexI() != cplexI || cpxRange.isQC()) continue;
                cpxRangeArray[n3++] = cpxRange;
                continue;
            }
            this.remove(iloAddableArray[i]);
        }
        if (n4 > 0) {
            if (n3 > 0) {
                CpxRange.uninstallRows(cpxRangeArray, n3);
                if (cplexI != null) {
                    CpxRange.ExternalRow externalRow = null;
                    for (int i = 0; i < n3; ++i) {
                        if (cpxRangeArray[i].getCplexI() != null) continue;
                        externalRow = (CpxRange.ExternalRow)cpxRangeArray[i].getIndex();
                        cplexI.unUseVars(externalRow._linear._vars, 0, externalRow._linear._num);
                    }
                }
            }
            CplexIndex[] cplexIndexArray = new CplexIndex[n4];
            for (int i = 0; i < n4; ++i) {
                cplexIndexArray[i] = cpxRangeArray2[i].getIndex();
                cpxRangeArray2[i].setIndex(null);
            }
            ListIterator listIterator = this._range.listIterator();
            while (listIterator.hasNext()) {
                CpxRange cpxRange = (CpxRange)listIterator.next();
                if (cpxRange.getIndex() != null) continue;
                listIterator.remove();
                cpxRange.setIndex(cplexIndexArray[0]);
            }
            for (int i = 0; i < n4; ++i) {
                cpxRangeArray2[i].setIndex(null);
                cpxRangeArray2[i].setIndex(cplexIndexArray[i]);
            }
        }
        return iloAddableArray;
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        Iterator iterator = this._range.iterator();
        while (iterator.hasNext()) {
            ((CpxRange)iterator.next()).removeVars(cplexIndex);
        }
        iterator = this._lp.iterator();
        while (iterator.hasNext()) {
            ((CpxLPMatrix)iterator.next()).removeVars(cplexIndex);
        }
        iterator = this._sos1.iterator();
        while (iterator.hasNext()) {
            ((CpxSOS1)iterator.next()).removeVars(cplexIndex);
        }
        iterator = this._sos2.iterator();
        while (iterator.hasNext()) {
            ((CpxSOS2)iterator.next()).removeVars(cplexIndex);
        }
        iterator = this._conv.iterator();
        while (iterator.hasNext()) {
            ((CpxConversion)iterator.next()).removeVars(cplexIndex);
        }
        iterator = this._gc.iterator();
        while (iterator.hasNext()) {
            ((CpxGC)iterator.next()).removeVars(cplexIndex);
        }
        iterator = this._var.listIterator();
        while (((ListIterator)iterator).hasNext()) {
            if (this._cplexi != null) {
                this._cplexi.unUseVar((CpxNumVar)((ListIterator)iterator).next());
            }
            ((ListIterator)iterator).remove();
        }
        if (this._obj != null) {
            this._obj.removeVars(cplexIndex);
        }
    }

    void emptyModel() throws IloException {
        this.uninstallAll();
        this._obj = null;
        this._lp = new LinkedList();
        this._range = new LinkedList();
        this._sos1 = new LinkedList();
        this._sos2 = new LinkedList();
        this._conv = new LinkedList();
        this._gc = new LinkedList();
        this._var = new LinkedList();
    }

    public Iterator iterator() {
        return new ModelIterator(this);
    }

    CpxLPMatrix add(CpxLPMatrix cpxLPMatrix) throws IloException {
        if (cpxLPMatrix != null) {
            if (this.isInstalledExt()) {
                cpxLPMatrix.installCon(this.getCplexI());
            }
            this._lp.add(cpxLPMatrix);
        }
        return cpxLPMatrix;
    }

    CpxObjective add(CpxObjective cpxObjective) throws MultipleObjectiveException, IloException {
        if (this._obj != null) {
            throw new MultipleObjectiveException();
        }
        this._obj = cpxObjective;
        if (cpxObjective != null && this.isInstalledExt()) {
            cpxObjective.installCon(this.getCplexI());
        }
        return this._obj;
    }

    CpxConversion add(CpxConversion cpxConversion) throws MultipleConversionException, IloException {
        if (cpxConversion != null) {
            if (this.isInstalledExt()) {
                cpxConversion.installCon(this.getCplexI());
            }
            if (this.getCplexI() == null || this.getCplexI()._registerAdd == -1) {
                this._conv.add(cpxConversion);
            }
        }
        return cpxConversion;
    }

    CpxRange add(CpxRange cpxRange) throws IloException {
        if (cpxRange != null) {
            if (this.isInstalledExt()) {
                cpxRange.installCon(this.getCplexI());
            }
            if (this.getCplexI() == null || this.getCplexI()._registerAdd == -1) {
                this._range.add(cpxRange);
            }
        }
        return cpxRange;
    }

    CpxGC add(CpxGC cpxGC) throws IloException {
        if (cpxGC != null) {
            if (this.isInstalledExt()) {
                cpxGC.installCon(this.getCplexI());
            }
            if (this.getCplexI() == null || this.getCplexI()._registerAdd == -1) {
                this._gc.add(cpxGC);
            }
        }
        return cpxGC;
    }

    CpxSOS1 add(CpxSOS1 cpxSOS1) throws IloException {
        if (cpxSOS1 != null) {
            if (this.isInstalledExt()) {
                cpxSOS1.installCon(this.getCplexI());
            }
            if (this.getCplexI() == null || this.getCplexI()._registerAdd == -1) {
                this._sos1.add(cpxSOS1);
            }
        }
        return cpxSOS1;
    }

    CpxSOS2 add(CpxSOS2 cpxSOS2) throws IloException {
        if (cpxSOS2 != null) {
            if (this.isInstalledExt()) {
                cpxSOS2.installCon(this.getCplexI());
            }
            if (this.getCplexI() == null || this.getCplexI()._registerAdd == -1) {
                this._sos2.add(cpxSOS2);
            }
        }
        return cpxSOS2;
    }

    IloNumVar add(CpxNumVar cpxNumVar) throws IloException {
        if (cpxNumVar != null) {
            if (this.isInstalledExt()) {
                this.getCplexI().useVar(cpxNumVar, true);
            }
            if (this.getCplexI() == null || this.getCplexI()._registerAdd == -1) {
                this._var.add(cpxNumVar);
            }
        }
        return cpxNumVar;
    }

    void remove(CpxConversion cpxConversion) throws IloException {
        if ((this.getCplexI() != null && this.getCplexI()._registerAdd != -1 || this._conv.remove(cpxConversion)) && this.isInstalledExt()) {
            cpxConversion.uninstallCon();
        }
    }

    void remove(CpxGC cpxGC) throws IloException {
        if ((this.getCplexI() != null && this.getCplexI()._registerAdd != -1 || this._gc.remove(cpxGC)) && this.isInstalledExt()) {
            cpxGC.uninstallCon();
        }
    }

    void remove(CpxSOS1 cpxSOS1) throws IloException {
        if ((this.getCplexI() != null && this.getCplexI()._registerAdd != -1 || this._sos1.remove(cpxSOS1)) && this.isInstalledExt()) {
            cpxSOS1.uninstallCon();
        }
    }

    void remove(CpxSOS2 cpxSOS2) throws IloException {
        if ((this.getCplexI() != null && this.getCplexI()._registerAdd != -1 || this._sos2.remove(cpxSOS2)) && this.isInstalledExt()) {
            cpxSOS2.uninstallCon();
        }
    }

    void remove(CpxRange cpxRange) throws IloException {
        if ((this.getCplexI() != null && this.getCplexI()._registerAdd != -1 || this._range.remove(cpxRange)) && this.isInstalledExt()) {
            cpxRange.uninstallCon();
        }
    }

    void remove(CpxNumVar cpxNumVar) throws IloException {
        if ((this.getCplexI() != null && this.getCplexI()._registerAdd != -1 || this._var.remove(cpxNumVar)) && this.isInstalledExt()) {
            this.getCplexI().unUseVar(cpxNumVar);
        }
    }

    void remove(CpxObjective cpxObjective) throws IloException {
        if (this._obj == cpxObjective) {
            this._obj = null;
            if (cpxObjective != null && this.isInstalledExt()) {
                cpxObjective.uninstallCon();
            }
        }
    }

    void remove(CpxLPMatrix cpxLPMatrix) throws IloException {
        if (this._lp.remove(cpxLPMatrix) && this.isInstalledExt()) {
            cpxLPMatrix.uninstallCon();
        }
    }

    public CpxObjective getCpxObjective() {
        return this._obj;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IloModel ");
        if (this.getName() != null) {
            stringBuffer.append(this.getName());
        }
        stringBuffer.append(" {\n");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append('\n');
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        CplexI cplexI = this._cplexi;
        if (cplexI != null) {
            try {
                this.uninstallCon();
            }
            catch (IloException iloException) {
                // empty catch block
            }
        }
        objectOutputStream.defaultWriteObject();
        if (cplexI != null) {
            try {
                this.installCon(cplexI);
            }
            catch (IloException iloException) {
                // empty catch block
            }
        }
    }

    public class ModelIterator
    implements Iterator {
        CpxModel _init = null;
        CpxModel _model = null;
        CpxObjective _obj = null;
        ListIterator _lp = null;
        ListIterator _range = null;
        ListIterator _sos1 = null;
        ListIterator _sos2 = null;
        ListIterator _conv = null;
        ListIterator _gc = null;
        ListIterator _var = null;
        Object _object = null;
        boolean _hasNext = false;

        ModelIterator(CpxModel cpxModel2) {
            this.init(cpxModel2);
        }

        private final void init(CpxModel cpxModel) {
            this._init = cpxModel;
            this._model = cpxModel;
            this._obj = cpxModel._obj;
            this._lp = cpxModel._lp.listIterator();
            this._range = cpxModel._range.listIterator();
            this._sos1 = cpxModel._sos1.listIterator();
            this._sos2 = cpxModel._sos2.listIterator();
            this._conv = cpxModel._conv.listIterator();
            this._gc = cpxModel._gc.listIterator();
            this._var = cpxModel._var.listIterator();
            this._hasNext = this._model != null;
            this._hasNext |= this._obj != null;
            this._hasNext |= this._lp.hasNext();
            this._hasNext |= this._range.hasNext();
            this._hasNext |= this._sos1.hasNext();
            this._hasNext |= this._sos2.hasNext();
            this._hasNext |= this._conv.hasNext();
            this._hasNext |= this._gc.hasNext();
            this._hasNext |= this._var.hasNext();
        }

        public boolean MoveNext() {
            if (this._model == null || !this._hasNext) {
                this._hasNext = false;
                return false;
            }
            this._object = null;
            if (this._obj != null) {
                this._object = this._obj;
                this._obj = null;
                if (!(this._lp.hasNext() || this._range.hasNext() || this._sos1.hasNext() || this._sos2.hasNext() || this._conv.hasNext() || this._gc.hasNext() || this._var.hasNext())) {
                    this._hasNext = false;
                }
            } else if (this._lp.hasNext()) {
                this._object = this._lp.next();
                if (!(this._lp.hasNext() || this._range.hasNext() || this._sos1.hasNext() || this._sos2.hasNext() || this._conv.hasNext() || this._gc.hasNext() || this._var.hasNext())) {
                    this._hasNext = false;
                }
            } else if (this._range.hasNext()) {
                this._object = this._range.next();
                if (!(this._range.hasNext() || this._sos1.hasNext() || this._sos2.hasNext() || this._conv.hasNext() || this._gc.hasNext() || this._var.hasNext())) {
                    this._hasNext = false;
                }
            } else if (this._sos1.hasNext()) {
                this._object = this._sos1.next();
                if (!(this._sos1.hasNext() || this._sos2.hasNext() || this._conv.hasNext() || this._gc.hasNext() || this._var.hasNext())) {
                    this._hasNext = false;
                }
            } else if (this._sos2.hasNext()) {
                this._object = this._sos2.next();
                if (!(this._sos2.hasNext() || this._conv.hasNext() || this._gc.hasNext() || this._var.hasNext())) {
                    this._hasNext = false;
                }
            } else if (this._conv.hasNext()) {
                this._object = this._conv.next();
                if (!(this._conv.hasNext() || this._gc.hasNext() || this._var.hasNext())) {
                    this._hasNext = false;
                }
            } else if (this._gc.hasNext()) {
                this._object = this._gc.next();
                if (!this._gc.hasNext() && !this._var.hasNext()) {
                    this._hasNext = false;
                }
            } else if (this._var.hasNext()) {
                this._object = this._var.next();
                if (!this._var.hasNext()) {
                    this._hasNext = false;
                }
            }
            return true;
        }

        public Object next() {
            if (this.MoveNext()) {
                return this.getCurrent();
            }
            throw new NoSuchElementException();
        }

        public Object getCurrent() {
            return this._object;
        }

        public void Reset() {
            this.init(this._init);
        }

        public boolean hasNext() {
            return this._hasNext;
        }

        public void remove() {
            try {
                if (this._object == null) {
                    throw new IllegalStateException();
                }
                if (this._object instanceof CpxObjective) {
                    this._model.remove((CpxObjective)this._object);
                } else if (this._object instanceof CpxLPMatrix) {
                    this._lp.remove();
                    if (this._model.isInstalledExt()) {
                        ((CpxLPMatrix)this._object).uninstallCon();
                    }
                } else if (this._object instanceof CpxRange) {
                    this._range.remove();
                    if (this._model.isInstalledExt()) {
                        ((CpxRange)this._object).uninstallCon();
                    }
                } else if (this._object instanceof CpxSOS1) {
                    this._sos1.remove();
                    if (this._model.isInstalledExt()) {
                        ((CpxSOS1)this._object).uninstallCon();
                    }
                } else if (this._object instanceof CpxSOS2) {
                    this._sos2.remove();
                    if (this._model.isInstalledExt()) {
                        ((CpxSOS2)this._object).uninstallCon();
                    }
                } else if (this._object instanceof CpxConversion) {
                    this._conv.remove();
                    if (this._model.isInstalledExt()) {
                        ((CpxConversion)this._object).uninstallCon();
                    }
                } else if (this._object instanceof CpxGC) {
                    this._gc.remove();
                    if (this._model.isInstalledExt()) {
                        ((CpxGC)this._object).uninstallCon();
                    }
                } else if (this._object instanceof CpxNumVar) {
                    this._var.remove();
                    if (this._model.isInstalledExt()) {
                        CpxModel.this.getCplexI().unUseVar((CpxNumVar)this._object);
                    }
                }
            }
            catch (IloException iloException) {
                throw new IllegalStateException();
            }
        }
    }
}

