/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntVar;
import ilog.concert.IloLinearNumExpr;
import ilog.concert.IloLinearNumExprIterator;
import ilog.concert.IloNumVar;
import ilog.cplex.CplexIndex;
import ilog.cplex.CpxExprVisitor;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxSubVar;
import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class CpxLinearExpr
implements CpxNumExpr,
Serializable {
    private static final long serialVersionUID = 1210L;
    double[] _vals;
    CpxNumVar[] _vars;
    int _num;
    double _const;

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        throw check;
    }

    public Object accept(CpxExprVisitor cpxExprVisitor) throws IloException {
        return cpxExprVisitor.visitLinearExpr(this);
    }

    void removeVars(CplexIndex cplexIndex) throws IloException {
        int n = 0;
        for (int i = 0; i < this._num; ++i) {
            if (this._vars[i] instanceof CpxSubVar) {
                this._vars[i].removeVars(cplexIndex);
            }
            if (this._vars[i]._varIndex == cplexIndex) continue;
            if (n < i) {
                this._vars[n] = this._vars[i];
                this._vals[n] = this._vals[i];
            }
            ++n;
        }
        this._num = n;
    }

    public final void addTerm(double d, IloNumVar iloNumVar) throws IloException {
        this.makeSpace(1);
        this._vars[this._num] = (CpxNumVar)iloNumVar;
        this._vals[this._num] = d;
        ++this._num;
    }

    public void addTerm(IloNumVar iloNumVar, double d) throws IloException {
        this.addTerm(d, iloNumVar);
    }

    public void addTerms(double[] dArray, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        this.makeSpace(n2);
        System.arraycopy(dArray, n, this._vals, this._num, n2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this._vars[this._num++] = (CpxNumVar)iloNumVarArray[i];
        }
    }

    public void addTerms(int[] nArray, IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        this.makeSpace(n2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this._vals[this._num] = nArray[i];
            this._vars[this._num++] = (CpxNumVar)iloNumVarArray[i];
        }
    }

    public void addTerms(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2) throws IloException {
        this.addTerms(dArray, iloNumVarArray, n, n2);
    }

    public void addTerms(double[] dArray, IloNumVar[] iloNumVarArray) throws IloException {
        this.addTerms(dArray, iloNumVarArray, 0, dArray.length);
    }

    public void addTerms(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this.addTerms(dArray, iloNumVarArray, 0, dArray.length);
    }

    public void add(IloLinearNumExpr iloLinearNumExpr) throws IloException {
        this._const += iloLinearNumExpr.getConstant();
        IloLinearNumExprIterator iloLinearNumExprIterator = iloLinearNumExpr.linearIterator();
        while (iloLinearNumExprIterator.hasNext()) {
            IloNumVar iloNumVar = iloLinearNumExprIterator.nextNumVar();
            this.addTerm(iloNumVar, iloLinearNumExprIterator.getValue());
        }
    }

    public void remove(IloNumVar iloNumVar) throws IloException {
        this.remove((CpxNumVar)iloNumVar);
    }

    public void remove(IloNumVar[] iloNumVarArray) throws IloException {
        this.remove(iloNumVarArray, 0, iloNumVarArray.length);
    }

    final void removeMarked() {
        int n;
        int n2 = 0;
        for (n = 0; n < this._num; ++n) {
            if (this._vars[n].isMarked()) continue;
            this._vars[n2] = this._vars[n];
            this._vals[n2] = this._vals[n];
            ++n2;
        }
        for (n = n2; n < this._num; ++n) {
            this._vars[n] = null;
        }
        this._num = n2;
    }

    public void remove(IloNumVar[] iloNumVarArray, int n, int n2) throws IloException {
        int n3;
        int n4 = n + n2;
        for (n3 = n; n3 < n4; ++n3) {
            ((CpxNumVar)iloNumVarArray[n3]).mark(-1);
        }
        this.removeMarked();
        for (n3 = n; n3 < n4; ++n3) {
            ((CpxNumVar)iloNumVarArray[n3]).unmark();
        }
    }

    public void clear() throws IloException {
        for (int i = 0; i < this._num; ++i) {
            this._vars[i] = null;
        }
        this._num = 0;
        this._const = 0.0;
    }

    public double getCpxConstant() {
        return this._const;
    }

    public void addTerm(int n, IloIntVar iloIntVar) throws IloException {
        this.addTerm((double)n, (IloNumVar)iloIntVar);
    }

    public void addTerm(IloIntVar iloIntVar, int n) throws IloException {
        this.addTerm((double)n, (IloNumVar)iloIntVar);
    }

    public void addTerms(int[] nArray, IloIntVar[] iloIntVarArray, int n, int n2) throws IloException {
        this.makeSpace(n2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this._vals[this._num] = nArray[i];
            this._vars[this._num++] = (CpxNumVar)iloIntVarArray[i];
        }
    }

    public void addTerms(IloIntVar[] iloIntVarArray, int[] nArray, int n, int n2) throws IloException {
        this.addTerms(nArray, iloIntVarArray, n, n2);
    }

    public void addTerms(int[] nArray, IloIntVar[] iloIntVarArray) throws IloException {
        this.addTerms(nArray, iloIntVarArray, 0, nArray.length);
    }

    public void addTerms(IloIntVar[] iloIntVarArray, int[] nArray) throws IloException {
        this.addTerms(nArray, iloIntVarArray, 0, nArray.length);
    }

    public void remove(IloIntVar iloIntVar) throws IloException {
        this.remove((IloNumVar)iloIntVar);
    }

    public void remove(IloIntVar[] iloIntVarArray) throws IloException {
        this.remove((IloNumVar[])iloIntVarArray);
    }

    public void remove(IloIntVar[] iloIntVarArray, int n, int n2) throws IloException {
        this.remove((IloNumVar[])iloIntVarArray, n, n2);
    }

    protected CpxLinearExpr(double[] dArray, CpxNumVar[] cpxNumVarArray, int n, int n2, double d) {
        int n3;
        this._const = d;
        for (n3 = 128; n3 < n2; n3 *= 2) {
        }
        this._num = n2;
        this._vals = new double[n3];
        this._vars = new CpxNumVar[n3];
        if (n2 > 0) {
            System.arraycopy(dArray, n, this._vals, 0, n2);
            System.arraycopy(cpxNumVarArray, n, this._vars, 0, n2);
        }
    }

    CpxLinearExpr() {
        this(null, null, 0, 0, 0.0);
    }

    void makeSpace(int n) {
        int n2 = this._vals.length;
        if (this._num + n >= n2) {
            while (this._num + n >= n2) {
                n2 *= 2;
            }
            double[] dArray = new double[n2];
            CpxNumVar[] cpxNumVarArray = new CpxNumVar[n2];
            System.arraycopy(this._vals, 0, dArray, 0, this._num);
            System.arraycopy(this._vars, 0, cpxNumVarArray, 0, this._num);
            this._vals = dArray;
            this._vars = cpxNumVarArray;
        }
    }

    void scaleBy(double d) {
        int n = 0;
        while (n < this._num) {
            int n2 = n++;
            this._vals[n2] = this._vals[n2] * d;
        }
    }

    final int find(CpxNumVar cpxNumVar) {
        for (int i = 0; i < this._num; ++i) {
            if (this._vars[i] != cpxNumVar) continue;
            return i;
        }
        return -1;
    }

    public final void setCoef(int n, double d) {
        this._vals[n] = d;
    }

    void addCoef(CpxNumVar cpxNumVar, double d) throws IloException {
        this.makeSpace(1);
        this._vars[this._num] = cpxNumVar;
        this._vals[this._num] = d;
        ++this._num;
    }

    void addCoefs(CpxNumVar[] cpxNumVarArray, double[] dArray, int n, int n2) throws IloException {
        this.makeSpace(n2);
        System.arraycopy(cpxNumVarArray, n, this._vars, this._num, n2);
        System.arraycopy(dArray, n, this._vals, this._num, n2);
        this._num += n2;
    }

    void addCoefs(CpxLinearExpr cpxLinearExpr) throws IloException {
        this.addCoefs(cpxLinearExpr._vars, cpxLinearExpr._vals, 0, cpxLinearExpr._num);
    }

    public void setCoef(CpxNumVar cpxNumVar, double d) throws IloException {
        int n;
        for (n = 0; n < this._num && this._vars[n] != cpxNumVar; ++n) {
        }
        if (n == this._num) {
            this.addCoef(cpxNumVar, d);
        } else {
            this._vals[n] = d;
        }
    }

    void markVars() {
        for (int i = 0; i < this._num; ++i) {
            this._vars[i].mark(i);
        }
    }

    void unmarkVars() {
        for (int i = 0; i < this._num; ++i) {
            this._vars[i].unmark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoefs(CpxNumVar[] cpxNumVarArray, double[] dArray, int n, int n2) throws IloException {
        int n3 = this._num;
        this.markVars();
        try {
            int n4 = n + n2;
            for (int i = n; i < n4; ++i) {
                if (cpxNumVarArray[i].isMarked()) {
                    this._vals[cpxNumVarArray[i].getVarIndexValue()] = dArray[i];
                    continue;
                }
                this.makeSpace(n2 - i);
                this._vars[this._num] = cpxNumVarArray[i];
                this._vals[this._num] = dArray[i];
                this._vars[this._num].mark(this._num);
                ++this._num;
            }
        }
        finally {
            this.unmarkVars();
        }
    }

    public void remove(int n) {
        int n2 = --this._num;
        this._vals[n] = this._vals[n2];
        this._vars[n] = this._vars[n2];
        this._vars[n2] = null;
    }

    public void remove(CpxNumVar cpxNumVar) throws IloException {
        int n;
        int n2 = 0;
        for (n = 0; n < this._num; ++n) {
            if (this._vars[n] == cpxNumVar) continue;
            this._vals[n2] = this._vals[n];
            this._vars[n2] = this._vars[n];
            ++n2;
        }
        for (n = n2; n < this._num; ++n) {
            this._vars[n] = null;
        }
        this._num = n2;
    }

    CpxNumVar[] getNumVars() {
        return this._vars;
    }

    double[] getValues() {
        return this._vals;
    }

    int getNum() {
        return this._num;
    }

    synchronized void removeDuplicatesSafe(int[] nArray) throws IloException {
        int n;
        int n2 = 0;
        for (n = this._num - 1; n >= 0; --n) {
            nArray[this._vars[n].getVarIndexValue()] = n;
        }
        for (n = 0; n < this._num; ++n) {
            int n3 = this._vars[n].getVarIndexValue();
            if (nArray[n3] != n) {
                int n4 = nArray[n3];
                this._vals[n4] = this._vals[n4] + this._vals[n];
                continue;
            }
            ++n2;
        }
        this._num = n2;
    }

    void removeDuplicates() throws IloException {
        CpxLinearExpr.removeDuplicates(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void removeDuplicates(CpxLinearExpr cpxLinearExpr) throws IloException {
        int n = 0;
        try {
            int n2;
            for (n2 = 0; n2 < cpxLinearExpr._num; ++n2) {
                if (cpxLinearExpr._vars[n2].isMarked()) {
                    int n3 = cpxLinearExpr._vars[n2].getVarIndexValue();
                    cpxLinearExpr._vals[n3] = cpxLinearExpr._vals[n3] + cpxLinearExpr._vals[n2];
                    continue;
                }
                cpxLinearExpr._vars[n2].mark(n);
                if (n != n2) {
                    cpxLinearExpr._vars[n] = cpxLinearExpr._vars[n2];
                    cpxLinearExpr._vals[n] = cpxLinearExpr._vals[n2];
                }
                ++n;
            }
            for (n2 = n; n2 < cpxLinearExpr._num; ++n2) {
                cpxLinearExpr._vars[n2] = null;
            }
            cpxLinearExpr._num = n;
        }
        finally {
            cpxLinearExpr.unmarkVars();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._num; ++i) {
            double d = this._vals[i];
            if (i == 0) {
                stringBuffer.append(d);
            } else if (d < 0.0) {
                stringBuffer.append(" - ");
                stringBuffer.append(-d);
            } else {
                stringBuffer.append(" + ");
                stringBuffer.append(d);
            }
            stringBuffer.append("*");
            stringBuffer.append(this._vars[i]);
        }
        if (this._const != 0.0) {
            stringBuffer.append(" ");
            stringBuffer.append(this._const);
        }
        return stringBuffer.toString();
    }

    public abstract IloCopyable makeCopy(IloCopyManager var1) throws IloException;

    public static class LinIterator {
        CpxLinearExpr _sp;
        int _i;

        public LinIterator(CpxLinearExpr cpxLinearExpr) {
            this._sp = cpxLinearExpr;
            this._i = -1;
        }

        public double getCpxValue() throws IllegalStateException {
            if (this._i >= 0 && this._i < this._sp._num) {
                return this._sp._vals[this._i];
            }
            throw new NoSuchElementException();
        }

        public void setCpxValue(double d) throws IllegalStateException {
            if (this._i < 0 || this._i >= this._sp._num) {
                throw new NoSuchElementException();
            }
            this._sp._vals[this._i] = d;
        }

        public CpxNumVar nextCpxVar() throws NoSuchElementException {
            ++this._i;
            if (this._i < this._sp._num) {
                return this._sp._vars[this._i];
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this._i + 1 < this._sp._num;
        }

        public void remove() throws IllegalStateException {
            if (this._i < 0 || this._i >= this._sp._num) {
                throw new IllegalStateException();
            }
            this._sp.remove(this._i--);
        }

        public boolean MoveNext() {
            ++this._i;
            return this._i < this._sp._num;
        }

        public Object getCurrent() {
            if (this._i < this._sp._num) {
                return this._sp._vars[this._i];
            }
            return null;
        }

        public void Reset() {
            this._i = -1;
        }

        public void setNumVar(IloNumVar iloNumVar) throws IllegalStateException {
            CpxNumVar cpxNumVar;
            if (this._i < 0 || this._i >= this._sp._num) {
                throw new IllegalStateException();
            }
            this._sp._vars[this._i] = cpxNumVar = (CpxNumVar)iloNumVar;
        }
    }
}

