/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloException;
import ilog.cplex.Cplex;
import ilog.cplex.CplexI;
import ilog.cplex.CpxException;
import ilog.cplex.IloCplex;

abstract class CpxCallback
implements Cloneable {
    long _env;
    long _cbdata;
    int _wherefrom;
    boolean _abort = false;
    double[] _doubleAux = new double[1];
    int[] _intAux = new int[1];
    byte[] _byteAux = new byte[1];
    Object[] _objectAux = new Object[1];
    long[] _longAux = new long[1];
    IloException _exception = null;
    RuntimeException _throwable = null;
    IloCplex.Callback _userCB;
    CpxCallback _next = null;
    IloCplex _cplex;
    public static final int Continuous = -1;
    public static final int Presolve = 0;
    public static final int Simplex = 1;
    public static final int Barrier = 2;
    public static final int Crossover = 3;
    public static final int Conflict = 4;
    public static final int Network = 5;
    public static final int MIP = 6;
    public static final int Probing = 7;
    public static final int FractionalCut = 8;
    public static final int DisjunctiveCut = 9;
    public static final int FlowMIRCut = 10;
    public static final int Branch = 11;
    public static final int Cut = 12;
    public static final int Node = 13;
    public static final int Heuristic = 14;
    public static final int Incumbent = 15;
    public static final int Solve = 16;
    public static final int MIPInfo = 17;
    public static final int ProbingInfo = 18;
    public static final int FractionalCutInfo = 19;
    public static final int DisjunctiveCutInfo = 20;
    public static final int FlowMIRCutInfo = 21;
    public static final int Tuning = 22;

    final void CALL(int n) throws IloException {
        if (n != 0) {
            throw new CpxException(n, this.getCplexI()._getErrorMessage(n));
        }
    }

    void setEnv(long l) {
        this._env = l;
    }

    void setCBdata(long l) {
        this._cbdata = l;
    }

    final long getEnv() {
        return this._env;
    }

    final long getCBdata() {
        return this._cbdata;
    }

    void setWherefrom(int n) {
        this._wherefrom = n;
    }

    final int getWherefrom() {
        return this._wherefrom;
    }

    boolean isAborted() {
        return this._abort;
    }

    CpxCallback(IloCplex.Callback callback) {
        this._userCB = callback;
    }

    CpxCallback makeClone() throws CloneNotSupportedException {
        CpxCallback cpxCallback = (CpxCallback)this.clone();
        cpxCallback._doubleAux = new double[1];
        cpxCallback._intAux = new int[1];
        cpxCallback._byteAux = new byte[1];
        cpxCallback._objectAux = new Object[1];
        cpxCallback._longAux = new long[1];
        return cpxCallback;
    }

    boolean initThreads(int n, int n2) {
        try {
            CpxCallback cpxCallback = this;
            for (int i = 1; i < n; ++i) {
                cpxCallback._next = this.makeClone();
                cpxCallback._next._userCB = this._userCB.makeClone();
                cpxCallback._next._userCB.cb = cpxCallback._next;
                cpxCallback = cpxCallback._next;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    IloCplex getCplex() {
        return this._cplex;
    }

    CplexI getCplexI() {
        return this._cplex.getCplexI();
    }

    void setCplex(IloCplex iloCplex) {
        this._cplex = iloCplex;
    }

    final double getDoubleInfo(int n) throws IloException {
        this.CALL(Cplex.CPXgetcallbackinfo(this._env, this._cbdata, this._wherefrom, n, this._doubleAux));
        return this._doubleAux[0];
    }

    final int getIntInfo(int n) throws IloException {
        this.CALL(Cplex.CPXgetcallbackinfo(this._env, this._cbdata, this._wherefrom, n, this._intAux));
        return this._intAux[0];
    }

    final void checkException() throws IloException {
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._throwable != null) {
            throw this._throwable;
        }
    }

    Object callmain() throws IloException {
        try {
            this._userCB.main();
        }
        catch (IloException iloException) {
            this._exception = iloException;
            this.abort();
        }
        catch (RuntimeException runtimeException) {
            this._throwable = runtimeException;
            this.abort();
        }
        return this;
    }

    void abort() {
        this._abort = true;
    }

    final double getEndTime() throws IloException {
        return this.getDoubleInfo(19);
    }

    abstract int getCBType();
}

