/*
 * Decompiled with CFR 0.152.
 */
package ilog.cplex;

import ilog.concert.IloAddable;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloNumVarType;
import ilog.concert.IloObjectiveSense;
import ilog.concert.IloRange;
import ilog.cplex.ByteArray;
import ilog.cplex.CachedArray;
import ilog.cplex.Cplex;
import ilog.cplex.CplexIndex;
import ilog.cplex.CplexInitializer;
import ilog.cplex.CpxAnd;
import ilog.cplex.CpxBranchCallbackFunction;
import ilog.cplex.CpxCallback;
import ilog.cplex.CpxCutCallback;
import ilog.cplex.CpxCutCallbackFunction;
import ilog.cplex.CpxException;
import ilog.cplex.CpxExtractable;
import ilog.cplex.CpxFailGoal;
import ilog.cplex.CpxGC;
import ilog.cplex.CpxGoalBranchCallback;
import ilog.cplex.CpxGoalIncumbentCallback;
import ilog.cplex.CpxGoalLazyConstraintCallback;
import ilog.cplex.CpxGoalNodeCallback;
import ilog.cplex.CpxHeuristicCallbackFunction;
import ilog.cplex.CpxIncumbentCallbackFunction;
import ilog.cplex.CpxIntSet;
import ilog.cplex.CpxIntSetCardVar;
import ilog.cplex.CpxIntSetVar;
import ilog.cplex.CpxLPCallbackFunction;
import ilog.cplex.CpxLPMatrix;
import ilog.cplex.CpxLinearNumExpr;
import ilog.cplex.CpxMIPCallbackFunction;
import ilog.cplex.CpxMIPInfoCallbackFunction;
import ilog.cplex.CpxNetCallbackFunction;
import ilog.cplex.CpxNode;
import ilog.cplex.CpxNodeCallbackFunction;
import ilog.cplex.CpxNumExpr;
import ilog.cplex.CpxNumVar;
import ilog.cplex.CpxNumVarBound;
import ilog.cplex.CpxObjective;
import ilog.cplex.CpxOrder;
import ilog.cplex.CpxQextractor;
import ilog.cplex.CpxRange;
import ilog.cplex.CpxSOS;
import ilog.cplex.CpxSOS1;
import ilog.cplex.CpxSOS2;
import ilog.cplex.CpxSolveCallbackFunction;
import ilog.cplex.CpxSubVar;
import ilog.cplex.CpxTuningCallbackFunction;
import ilog.cplex.DoubleArray;
import ilog.cplex.IloCplex;
import ilog.cplex.IloCplexModeler;
import ilog.cplex.IndexManager;
import ilog.cplex.IntArray;
import ilog.cplex.NullOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class CplexI
extends Cplex {
    static final String IBM_COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5724-Y48\n(c) Copyright IBM Corp. 2001, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static CplexInitializer _cpxinit = new CplexInitializer();
    private IloCplexModeler _modeler = null;
    private PrintStream _printOut;
    private PrintStream _printWarn;
    private OutputStream _out;
    private OutputStream _warn;
    private OutputStream _null;
    public static final double Infinity = 1.0E20;
    double bigReal;
    long _env;
    long _lp;
    int _status;
    String _error;
    boolean _fixBasis;
    int _registerAdd = -1;
    boolean _solving;
    private CpxCallback[] _cb = new CpxCallback[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private int[] _reduce = new int[1];
    private int[] _prelinear = new int[1];
    private int[] _mipcbredlp = new int[1];
    private int[] _advind = new int[1];
    private IndexManager[] _gcs;
    private IndexManager _rows;
    private IndexManager _qcs;
    private IndexManager _soss;
    private IndexManager _cols;
    private IndexManager _filters;
    private CpxOrder _ord;
    private int[] tmplen;
    private byte[] tmptype;
    private double[] tmplb;
    private double[] tmpub;
    static final int maxJNINames = 1000000;
    private double[] _xCache = null;
    private CachedArray _slack = new CachedArray();
    private CachedArray _qcslack = new CachedArray();
    private CachedArray _solnpoolX = new CachedArray();
    private CachedArray _solnpoolSlack = new CachedArray();
    private CachedArray _solnpoolQCSlack = new CachedArray();
    HashMap _grpMap;
    private IloCplex.Goal _lastGoal;
    private IloCplex.Goal _rootGoal;
    private CpxNode _rootNode;
    private ArrayList[] _globalCuts;
    private boolean _usesEval;
    Vector _filter = new Vector();
    private AborterI _abort;

    final void setIloCplex(IloCplex iloCplex) {
        this._modeler = iloCplex;
    }

    final IloCplexModeler getModeler() {
        return this._modeler;
    }

    final void checkCplexI(CpxExtractable cpxExtractable) throws IloException {
        if (cpxExtractable._cplexi != null && cpxExtractable._cplexi != this) {
            throw new IloCplex.MultipleUseException();
        }
    }

    final long getEnv() {
        return this._env;
    }

    final long getLP() {
        return this._lp;
    }

    private void output(String string) {
        try {
            if (this.output() != null) {
                this.output().write(string.getBytes());
            }
        }
        catch (Exception exception) {
            System.err.println("WARNING: Could not print message: " + string);
            System.err.println("to IloCplex.output() due to exception " + exception);
        }
    }

    private void warn(String string) {
        try {
            if (this.warning() != null) {
                this.warning().write(string.getBytes());
            }
        }
        catch (Exception exception) {
            System.err.println("WARNING: Could not print warning message: " + string);
            System.err.println("to IloCplex.warn() due to exception " + exception);
        }
    }

    final void initCallbacks() throws IloException {
        int n = CplexI.CPXEgetmaxthreads(this._env);
        boolean bl = false;
        boolean bl2 = false;
        CplexI.CPXgetintparam(this._env, 1001, this._advind);
        CplexI.CPXgetintparam(this._env, 2055, this._mipcbredlp);
        CplexI.CPXgetintparam(this._env, 1057, this._reduce);
        CplexI.CPXgetintparam(this._env, 1058, this._prelinear);
        if (this._rootGoal != null || this._lastGoal != null) {
            CplexI.CPXsetintparam(this._env, 1001, 0);
        }
        this._lastGoal = this._rootGoal;
        if (this._cb[12] != null) {
            CpxCutCallback cpxCutCallback = (CpxCutCallback)this._cb[12];
            bl2 = true;
            bl = cpxCutCallback._lazy;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        for (int i = 0; i < this._cb.length; ++i) {
            if (this._cb[i] == null) continue;
            this._cb[i]._abort = false;
            this._cb[i]._exception = null;
            bl3 |= this._cb[i].initThreads(n, this.getNcols());
            bl4 = true;
        }
        if (!bl3) {
            this.warning().print("Could not initialize callbacks for multi-threading; switching back to sequential CPLEX");
            this.setIntParam(1067, 1);
        }
        if (bl4) {
            CplexI.CPXsetintparam(this._env, 2055, 0);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        double[][] dArrayArray = new double[1][];
        byte[][] byArrayArray = new byte[1][];
        int[][] nArrayArray = new int[1][];
        int[][] nArrayArray2 = new int[1][];
        double[][] dArrayArray2 = new double[1][];
        CplexI.CPXEgetlazyconstraints(this._env, this._lp, nArray, nArray2, dArrayArray, byArrayArray, nArrayArray, nArrayArray2, dArrayArray2);
        if (nArray[0] > 0 || bl) {
            CplexI.CPXsetintparam(this._env, 1057, 1);
        } else {
            CplexI.CPXEgetusercuts(this._env, this._lp, nArray, nArray2, dArrayArray, byArrayArray, nArrayArray, nArrayArray2, dArrayArray2);
            if (nArray[0] > 0 || bl2) {
                CplexI.CPXsetintparam(this._env, 1058, 0);
            }
        }
        if (this._cb[14] != null) {
            CplexI.CPXsetintparam(this._env, 1058, 0);
        }
    }

    final void finitCallbacks() {
        CplexI.CPXsetintparam(this._env, 1001, this._advind[0]);
        CplexI.CPXsetintparam(this._env, 1057, this._reduce[0]);
        CplexI.CPXsetintparam(this._env, 1058, this._prelinear[0]);
        CplexI.CPXsetintparam(this._env, 2055, this._mipcbredlp[0]);
    }

    final void checkCallbacks() throws IloException {
        for (int i = 0; i < this._cb.length; ++i) {
            if (this._cb[i] == null) continue;
            this._cb[i].checkException();
        }
    }

    void setCallback(CpxCallback cpxCallback) throws IloException {
        int n = cpxCallback.getCBType();
        int n2 = 0;
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                n2 = CplexI.CPXsetlpcallbackfunc(this.getEnv(), new CpxLPCallbackFunction(), this);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = CplexI.CPXsetmipcallbackfunc(this.getEnv(), new CpxMIPCallbackFunction(), this);
                break;
            }
            case 5: {
                n2 = CplexI.CPXsetnetcallbackfunc(this.getEnv(), new CpxNetCallbackFunction(), this);
                break;
            }
            case 11: {
                CpxBranchCallbackFunction cpxBranchCallbackFunction = new CpxBranchCallbackFunction();
                n2 = CplexI.CPXsetbranchcallbackfunc(this.getEnv(), cpxBranchCallbackFunction, this);
                if (n2 != 0) {
                    throw new CpxException(n2, CplexI.CPXgeterrorstring(this.getEnv(), n2));
                }
                n2 = CplexI.CPXsetbranchnosolncallbackfunc(this.getEnv(), cpxBranchCallbackFunction, this);
                CplexI.CPXsetintparam(this._env, 1057, 1);
                CplexI.CPXsetintparam(this._env, 1058, 0);
                break;
            }
            case 12: {
                n2 = CplexI.CPXsetcutcallbackfunc(this.getEnv(), new CpxCutCallbackFunction(), this);
                break;
            }
            case 14: {
                n2 = CplexI.CPXsetheuristiccallbackfunc(this.getEnv(), new CpxHeuristicCallbackFunction(), this);
                break;
            }
            case 15: {
                n2 = CplexI.CPXsetincumbentcallbackfunc(this.getEnv(), new CpxIncumbentCallbackFunction(), this);
                break;
            }
            case 13: {
                n2 = CplexI.CPXsetnodecallbackfunc(this.getEnv(), new CpxNodeCallbackFunction(), this);
                break;
            }
            case 16: {
                n2 = CplexI.CPXsetsolvecallbackfunc(this.getEnv(), new CpxSolveCallbackFunction(), this);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = CplexI.CPXsetinfocallbackfunc(this.getEnv(), new CpxMIPInfoCallbackFunction(), this);
                break;
            }
            case 22: {
                n2 = CplexI.CPXsettuningcallbackfunc(this.getEnv(), new CpxTuningCallbackFunction(), this);
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if (n2 != 0) {
            throw new CpxException(n2, CplexI.CPXgeterrorstring(this.getEnv(), n2));
        }
        if (n == -1) {
            this._cb[1] = cpxCallback;
            this._cb[2] = cpxCallback;
        } else {
            this._cb[n] = cpxCallback;
        }
    }

    void clearCallbacks() {
        for (int i = 0; i < this._cb.length; ++i) {
            if (this._cb[i] == null) continue;
            this._cb[i].setCplex(null);
            this._cb[i] = null;
        }
        CplexI.CPXsetlpcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetmipcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetnetcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetbranchcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetbranchnosolncallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetcutcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetheuristiccallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetincumbentcallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetnodecallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetsolvecallbackfunc(this.getEnv(), null, null);
        CplexI.CPXsetinfocallbackfunc(this.getEnv(), null, null);
    }

    CpxCallback getCallback(int n, int n2) {
        CpxCallback cpxCallback = this._cb[n];
        for (int i = 0; i < n2; ++i) {
            if (cpxCallback == null) {
                return null;
            }
            cpxCallback = cpxCallback._next;
        }
        return cpxCallback;
    }

    void callFinit() {
        if (this._env != 0L) {
            CplexI.lockILM(this);
        }
        this._env = 0L;
    }

    protected void finalize() {
        this.callFinit();
    }

    public CplexI(boolean bl) {
        this._env = 0L;
        this._lp = 0L;
        this._out = null;
        this._warn = null;
        this._printOut = null;
        this._printWarn = null;
        this._cb = null;
        this._gcs = null;
        this._rows = null;
        this._qcs = null;
        this._soss = null;
        this._cols = null;
        this._filters = null;
        this._ord = null;
        this._null = null;
    }

    public CplexI() throws IloException {
        this.init();
        this.tmplen = new int[2];
        this.tmptype = new byte[1];
        this.tmplb = new double[1];
        this.tmpub = new double[1];
        this._gcs = new IndexManager[27];
        for (int i = 0; i < 27; ++i) {
            this._gcs[i] = new IndexManager();
        }
        this._rows = this._gcs[3];
        this._qcs = this._gcs[4];
        this._soss = this._gcs[5];
        this._cols = new IndexManager();
        this._filters = new IndexManager();
        this._ord = new CpxOrder();
        this._null = new NullOutput();
        this._out = System.out;
        this._warn = System.err;
        this._printOut = new PrintStream(this._out);
        this._printWarn = new PrintStream(this._warn);
    }

    public PrintStream output() {
        return this._printOut;
    }

    public PrintStream warning() {
        return this._printWarn;
    }

    public void setOut(OutputStream outputStream) {
        this._out = outputStream != null ? outputStream : this._null;
        this._printOut = new PrintStream(this._out);
    }

    public void setWarning(OutputStream outputStream) {
        this._warn = outputStream != null ? outputStream : this._null;
        this._printWarn = new PrintStream(this._warn);
    }

    private final String probName() {
        String string = null;
        try {
            string = this._modeler._model.getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = "ilog.cplex";
        }
        return string;
    }

    private final String getColName(int n) {
        String string = null;
        int n2 = this._solving ? CplexI.CPXEgetorigcolind(this._env, this._lp, n) : n;
        try {
            if (n2 >= 0) {
                string = this._cols.getObject(n2).getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            string = "IloX" + n;
        }
        return string;
    }

    private final String getRowName(int n) {
        String string = null;
        int n2 = this._solving ? CplexI.CPXEgetorigrowind(this._env, this._lp, n) : n;
        try {
            if (n2 >= 0) {
                string = this._rows.getObject(n2).getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            string = "IloC" + n;
        }
        return string;
    }

    private final String getQCName(int n) {
        String string = null;
        try {
            string = this._qcs.getObject(n).getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            string = "IloC" + n;
        }
        return string;
    }

    private final String getSOSName(int n) {
        String string = null;
        try {
            string = this._soss.getObject(n).getName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            string = "IloS" + n;
        }
        return string;
    }

    private String[] getColNames(CplexI cplexI) throws IloException {
        int n = cplexI.getNcols();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getColName(i);
        }
        return stringArray;
    }

    private String[] getRowNames(CplexI cplexI) throws IloException {
        int n = cplexI.getNrows();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getRowName(i);
        }
        return stringArray;
    }

    private String[] getQCNames(CplexI cplexI) throws IloException {
        int n = cplexI.getNQCs();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getQCName(i);
        }
        return stringArray;
    }

    private String[] getSOSNames(CplexI cplexI) throws IloException {
        int n = cplexI.getNSOSs();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getSOSName(i);
        }
        return stringArray;
    }

    final boolean isQC(CpxRange cpxRange) {
        return this._qcs.getObject(cpxRange.getIndexValue()) == cpxRange;
    }

    void installNames(CplexI cplexI) throws IloException {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        this.origProbType();
        this._installNames(cplexI.probName(), null, 0, 0, 'P');
        CpxObjective cpxObjective = this._modeler._model.getCpxObjective();
        if (cpxObjective != null) {
            this._installNames(cpxObjective.getName(), null, 0, 0, 'O');
        }
        if ((stringArray4 = this.getRowNames(cplexI)) != null) {
            int n = cplexI.getNrows();
            this._installNames(null, stringArray4, 0, n, 'R');
        }
        if ((stringArray3 = this.getColNames(cplexI)) != null) {
            int n = cplexI.getNcols();
            this._installNames(null, stringArray3, 0, n, 'C');
        }
        if ((stringArray2 = this.getQCNames(cplexI)) != null) {
            int n = cplexI.getNQCs();
            this._installNames(null, stringArray2, 0, n, 'Q');
        }
        if ((stringArray = this.getSOSNames(cplexI)) != null) {
            int n = cplexI.getNSOSs();
            this._installNames(null, stringArray, 0, n, 'S');
        }
    }

    public boolean isMIP() {
        int n = this.getProbType();
        return n == 1 || n == 7 || n == 11 || n == 3 || n == 8 || n == 4 || n == 9 || n == 12;
    }

    public boolean isQO() {
        int n = this.getProbType();
        if (this.isQC()) {
            return this._modeler._model._obj != null && this._modeler._model._obj._quad != null && this._modeler._model._obj._quad.getNum() > 0;
        }
        return n == 5 || n == 7 || n == 8 || n == 9;
    }

    public boolean isQC() {
        int n = this.getProbType();
        return n == 10 || n == 11 || n == 12;
    }

    void exportModel(String string, IloCplex iloCplex) throws IloException {
        this.installNames(iloCplex._cplexi);
        this._writeModel(string);
    }

    static void importModel(String string, IloCplex iloCplex) throws IloException {
        int n;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        int[] nArray;
        Object[] objectArray2;
        Object object4;
        Object object5;
        Object object6;
        int n2;
        iloCplex.clearModel();
        CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)iloCplex.addLPMatrix(string);
        CplexI cplexI = cpxLPMatrix.getCplexI();
        cplexI._readModel(string);
        int n3 = cplexI._getNrows();
        CpxRange[] cpxRangeArray = new CpxRange[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            object6 = new CplexIndex(n2);
            cpxRangeArray[n2] = new CpxRange((CplexIndex)object6, null);
            cplexI._rows.addIndex((CplexIndex)object6, cpxRangeArray[n2]);
            cpxRangeArray[n2].setCplexI(cplexI);
        }
        cpxLPMatrix.addRows(cpxRangeArray, n3);
        n2 = cplexI._getNcols();
        object6 = new double[n2];
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        byte[] byArray = new byte[n2];
        cplexI._getVariables(n2, (double[])object6, dArray, dArray2, byArray);
        IloNumVar[] iloNumVarArray = new CpxNumVar[n2];
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == 67) {
                iloNumVarArray[i] = (CpxNumVar)iloCplex.numVar(dArray[i], dArray2[i]);
                continue;
            }
            if (byArray[i] == 66) {
                iloNumVarArray[i] = (CpxNumVar)iloCplex.numVar(dArray[i], dArray2[i], IloNumVarType.Bool, null);
                continue;
            }
            if (byArray[i] == 73) {
                iloNumVarArray[i] = (CpxNumVar)iloCplex.numVar(dArray[i], dArray2[i], IloNumVarType.Int, null);
                continue;
            }
            if (byArray[i] == 83) {
                iloNumVarArray[i] = (CpxNumVar)((Object)iloCplex.semiContVar(dArray[i], dArray2[i], IloNumVarType.Float));
                continue;
            }
            if (byArray[i] == 78) {
                iloNumVarArray[i] = (CpxNumVar)((Object)iloCplex.semiContVar(dArray[i], dArray2[i], IloNumVarType.Int));
                continue;
            }
            throw new CpxException(-1, "CPLEX error in importModel(): unsupported variable type");
        }
        Vector<IloConstraint> vector = new Vector<IloConstraint>();
        int n4 = cplexI._getNinds();
        if (n4 > 0) {
            int n5;
            int n6;
            int[] nArray2 = new int[]{-1};
            object5 = new int[]{-1};
            object4 = new double[]{0.0};
            objectArray2 = new byte[]{69};
            nArray = new int[]{-1};
            object3 = new int[]{-1};
            object2 = new int[]{-1};
            objectArray = new boolean[n4];
            for (n6 = 0; n6 < n4; ++n6) {
                objectArray[n6] = false;
                n5 = CplexI.CPXEgetindicator(cplexI._env, cplexI._lp, nArray2, (int[])object5, nArray, (double[])object4, (byte[])objectArray2, null, null, 0, object3, (int[])object2, n6);
                if (n5 != 0 && n5 != 1207) {
                    cplexI.CALL(n5);
                }
                if (object3[0] > 0 || nArray2[0] < 0 || object5[0] != false || object2[0] != 3) continue;
                Object object7 = Double.MAX_VALUE;
                Object object8 = -1.7976931348623157E308;
                if (objectArray2[0] == 76) {
                    object7 = object4[0];
                } else if (objectArray2[0] == 71) {
                    object8 = object4[0];
                } else {
                    Object object9 = object4[0];
                    object7 = object9;
                    object8 = object9;
                }
                int[] nArray3 = new int[]{0};
                String string2 = CplexI.CPXgetindconstrname(cplexI._env, cplexI._lp, n6, nArray3);
                if (nArray3[0] != 0) {
                    string2 = null;
                }
                if (string2 == null) {
                    string2 = "IloI" + n6;
                }
                if (iloNumVarArray[nArray2[0]] instanceof CpxRange) continue;
                CpxRange cpxRange = (CpxRange)iloCplex.range((double)object8, (double)object7, string2);
                cpxRange.incrementRefCnt(cplexI._getColumnNZnum(nArray2[0], nArray2[0]) + 1);
                iloNumVarArray[nArray2[0]] = cpxRange;
                objectArray[n6] = true;
            }
            for (n6 = n4 - 1; n6 >= 0; --n6) {
                n5 = CplexI.CPXEgetindicator(cplexI._env, cplexI._lp, nArray2, (int[])object5, nArray, (double[])object4, (byte[])objectArray2, null, null, 0, object3, (int[])object2, n6);
                if (n5 != 0 && n5 != 1207) {
                    cplexI.CALL(n5);
                }
                if (object3[0] > 0) continue;
                int n7 = -object3[0];
                object = new int[n7];
                double[] dArray3 = new double[n7];
                cplexI.CALL(CplexI.CPXEgetindicator(cplexI._env, cplexI._lp, nArray2, (int[])object5, nArray, (double[])object4, (byte[])objectArray2, object, dArray3, n7, object3, (int[])object2, n6));
                CpxLinearNumExpr cpxLinearNumExpr = (CpxLinearNumExpr)iloCplex.linearNumExpr();
                for (int i = 0; i < nArray[0]; ++i) {
                    cpxLinearNumExpr.addTerm(dArray3[i], iloNumVarArray[object[i]]);
                }
                if (object5[0] == false && nArray2[0] >= 0 && objectArray[n6] && object2[0] == 3) {
                    CpxRange cpxRange = (CpxRange)iloNumVarArray[nArray2[0]];
                    cpxRange.setExpr(cpxLinearNumExpr);
                    continue;
                }
                Object object10 = Double.MAX_VALUE;
                Object object11 = -1.7976931348623157E308;
                if (objectArray2[0] == 76) {
                    object10 = object4[0];
                } else if (objectArray2[0] == 71) {
                    object11 = object4[0];
                } else {
                    Object object12 = object4[0];
                    object10 = object12;
                    object11 = object12;
                }
                int[] nArray4 = new int[]{0};
                String string3 = CplexI.CPXgetindconstrname(cplexI._env, cplexI._lp, n6, nArray4);
                if (nArray4[0] != 0) {
                    string3 = null;
                }
                if (string3 == null) {
                    string3 = "IloI" + n6;
                }
                CpxRange cpxRange = (CpxRange)iloCplex.range((double)object11, cpxLinearNumExpr, (double)object10, string3);
                if (nArray2[0] < 0) {
                    if ((object2[0] & 1) != 0) {
                        if (object5[0] != false) {
                            vector.add(cpxRange);
                        } else {
                            vector.add(iloCplex.not(cpxRange));
                        }
                    } else if (object5[0] != false) {
                        vector.add(iloCplex.not(cpxRange));
                    } else {
                        vector.add(cpxRange);
                    }
                } else {
                    double d = object5[0] == false ? 1.0 : 0.0;
                    IloNumVar iloNumVar = iloNumVarArray[nArray2[0]];
                    if ((object2[0] & 1) != 0) {
                        vector.add(iloCplex.ifThen(iloCplex.eq((IloNumExpr)iloNumVar, d), cpxRange));
                    }
                    if ((object2[0] & 2) != 0) {
                        vector.add(iloCplex.ifThen(cpxRange, iloCplex.eq((IloNumExpr)iloNumVar, d)));
                    }
                }
                cplexI.CALL(CplexI.CPXdelindconstrs(cplexI._env, cplexI._lp, n6, n6));
            }
        }
        for (int i = 0; i < n2; ++i) {
            object5 = new CplexIndex(i);
            cplexI._cols.addIndex((CplexIndex)object5, (CpxExtractable)((Object)iloNumVarArray[i]));
            ((CpxNumVar)iloNumVarArray[i]).setIndex((CplexIndex)object5, cplexI);
        }
        cpxLPMatrix.addVars((CpxNumVar[])iloNumVarArray, n2);
        IloNumExpr iloNumExpr = iloCplex.scalProd(iloNumVarArray, (double[])object6);
        int n8 = cplexI._getQPNZnum();
        if (n8 > 0) {
            int n9 = cplexI._getNcols();
            objectArray2 = new double[n8];
            nArray = new int[n8];
            object3 = new int[n9 + 1];
            cplexI._getQP((int[])object3, nArray, (double[])objectArray2);
            for (int i = 0; i < n9; ++i) {
                for (int j = object3[i]; j < object3[i + 1]; ++j) {
                    iloNumExpr = iloCplex.sum(iloNumExpr, iloCplex.prod(0.5 * objectArray2[j], iloNumVarArray[nArray[j]], iloNumVarArray[i]));
                    if (iloNumVarArray[i] instanceof CpxSubVar) {
                        ((CpxSubVar)iloNumVarArray[i]).incrementRefCnt();
                    }
                    if (!(iloNumVarArray[nArray[j]] instanceof CpxSubVar)) continue;
                    ((CpxSubVar)iloNumVarArray[nArray[j]]).incrementRefCnt();
                }
            }
        }
        object4 = null;
        object4 = cplexI._getSense() == 1 ? (Object)((CpxObjective)iloCplex.addMinimize(iloNumExpr)) : (Object)((CpxObjective)iloCplex.addMaximize(iloNumExpr));
        if (iloCplex.isQC()) {
            int n10 = cplexI._getNQCs();
            for (int i = 0; i < n10; ++i) {
                object3 = new CplexIndex(i);
                object2 = new CpxRange((CplexIndex)object3, cplexI._getDelQCname(i));
                cplexI._qcs.addIndex((CplexIndex)object3, (CpxExtractable)object2);
                ((CpxExtractable)object2).setCplexI(cplexI);
                iloCplex._model._range.add((CpxExtractable)object2);
            }
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[n2];
        object3 = new String[n3];
        cplexI._getDelNames(null, null, stringArray2, null, 0, n2 - 1);
        for (n = 0; n < n2; ++n) {
            ((CpxExtractable)((Object)iloNumVarArray[n])).setName(stringArray2[n]);
        }
        cplexI._getDelNames(null, null, null, (String[])object3, 0, n3 - 1);
        for (n = 0; n < n3; ++n) {
            cpxRangeArray[n].setName((String)object3[n]);
        }
        cplexI._getDelNames(null, stringArray, null, null, 0, 0);
        ((CpxExtractable)object4).setName(stringArray[0]);
        if (iloCplex.isMIP()) {
            int n11;
            int n12 = cplexI._getNSOSs();
            if (n12 > 0) {
                int n13 = cplexI._getSOSNZnum(0, n12 - 1);
                object3 = new byte[n12];
                int[] nArray5 = new int[n12 + 1];
                objectArray = new int[n13];
                double[] dArray4 = new double[n13];
                String[] stringArray3 = new String[n12];
                cplexI._getSOSs(0, n12 - 1, (byte[])object3, nArray5, (int[])objectArray, dArray4);
                cplexI._getSOSNames(stringArray3, 0, n12 - 1);
                for (int i = 0; i < n12; ++i) {
                    CpxSOS cpxSOS;
                    object = new CplexIndex(i);
                    if (object3[i] == 49) {
                        cpxSOS = new CpxSOS1(cplexI, (CplexIndex)object, stringArray3[i]);
                        iloCplex._model._sos1.add(cpxSOS);
                    } else {
                        cpxSOS = new CpxSOS2(cplexI, (CplexIndex)object, stringArray3[i]);
                        iloCplex._model._sos2.add(cpxSOS);
                    }
                    cplexI._soss.addIndex((CplexIndex)object, cpxSOS);
                }
            }
            if ((n11 = cplexI._getOrderNum()) > 0) {
                object3 = new int[n11];
                int[] nArray6 = new int[n11];
                objectArray = new int[n11];
                cplexI._getOrder((int[])object3, nArray6, (int[])objectArray);
                for (int i = 0; i < n11; ++i) {
                    cplexI._ord.addOrder(((CpxNumVar)iloNumVarArray[object3[i]]).getVarIndex(), nArray6[i], objectArray[i]);
                }
            }
        }
        String[] stringArray4 = new String[1];
        cplexI._getDelNames(stringArray4, null, null, null, 0, 0);
        iloCplex.setName(stringArray4[0]);
        if (n4 > 0) {
            cplexI.unUseVars((CpxNumVar[])iloNumVarArray, 0, n2);
        }
        for (int i = 0; i < vector.size(); ++i) {
            iloCplex.add((IloAddable)vector.elementAt(i));
        }
    }

    final void useVars(CpxNumVar[] cpxNumVarArray, int n, int n2, boolean bl) throws IloException {
        int n3;
        CpxNumVar[] cpxNumVarArray2 = null;
        int n4 = 0;
        int n5 = n + n2;
        int n6 = this.getNcols();
        for (n3 = n; n3 < n5; ++n3) {
            if (cpxNumVarArray[n3]._varIndex != null) continue;
            cpxNumVarArray[n3].setIndex(this._cols.addIndex(new CplexIndex(n6 + n4), cpxNumVarArray[n3]), this);
            if (n4 == 0) {
                cpxNumVarArray2 = new CpxNumVar[n2];
            }
            cpxNumVarArray2[n4++] = cpxNumVarArray[n3];
        }
        if (n4 > 0) {
            double[] dArray = new double[n4];
            double[] dArray2 = new double[n4];
            byte[] byArray = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                dArray[i] = cpxNumVarArray2[i].getCpxLB();
                if (dArray[i] < -1.0E20) {
                    dArray[i] = -1.0E20;
                }
                dArray2[i] = cpxNumVarArray2[i].getCpxUB();
                if (dArray2[i] > 1.0E20) {
                    dArray2[i] = 1.0E20;
                }
                byArray[i] = cpxNumVarArray2[i].getCpxType();
            }
            this._newColumns(n4, dArray, dArray2, byArray);
        }
        if (bl) {
            for (n3 = n; n3 < n5; ++n3) {
                if (!(cpxNumVarArray[n3] instanceof CpxSubVar)) continue;
                ((CpxSubVar)cpxNumVarArray[n3]).userInstall(this._modeler);
            }
        }
    }

    final void unUseVars(CpxNumVar[] cpxNumVarArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (!(cpxNumVarArray[i] instanceof CpxSubVar)) continue;
            ((CpxSubVar)cpxNumVarArray[i]).userUninstall(this._modeler);
        }
    }

    final void unUseVar(CpxNumVar cpxNumVar) throws IloException {
        if (cpxNumVar instanceof CpxSubVar) {
            ((CpxSubVar)cpxNumVar).userUninstall(this._modeler);
        }
    }

    final void useVar(CpxNumVar cpxNumVar, boolean bl) throws IloException {
        if (cpxNumVar._varIndex == null) {
            double[] dArray = new double[]{cpxNumVar.getCpxLB()};
            double[] dArray2 = new double[]{cpxNumVar.getCpxUB()};
            byte[] byArray = new byte[]{cpxNumVar.getCpxType()};
            if (dArray[0] < -1.0E20) {
                dArray[0] = -1.0E20;
            }
            if (dArray2[0] > 1.0E20) {
                dArray2[0] = 1.0E20;
            }
            this._newColumns(1, dArray, dArray2, byArray);
            cpxNumVar.setIndex(this._cols.addIndex(new CplexIndex(this.getNcols()), cpxNumVar), this);
        }
        if (bl && cpxNumVar instanceof CpxSubVar) {
            ((CpxSubVar)cpxNumVar).userInstall(this._modeler);
        }
    }

    void setObjective(IloObjectiveSense iloObjectiveSense, int n, CplexIndex[] cplexIndexArray, double[] dArray, int n2, double[] dArray2, CplexIndex[] cplexIndexArray2, CplexIndex[] cplexIndexArray3) throws IloException {
        this.origProbType();
        this.invalidate();
        this.setSense(iloObjectiveSense.getValue());
        double[] dArray3 = new double[this.getNcols()];
        for (int i = 0; i < n; ++i) {
            int n3 = cplexIndexArray[i]._index;
            dArray3[n3] = dArray3[n3] + dArray[i];
        }
        this._setObjective(dArray3);
        if (n2 > 0) {
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                int n4 = cplexIndexArray2[i]._index;
                int n5 = cplexIndexArray3[i]._index;
                if (n4 <= n5) {
                    nArray[i] = n4;
                    nArray2[i] = n5;
                    continue;
                }
                nArray[i] = n5;
                nArray2[i] = n4;
            }
            this._setQ(n2, (double[])dArray2.clone(), nArray, nArray2);
        } else {
            switch (CplexI.CPXgetprobtype(this._env, this._lp)) {
                case 1: {
                    break;
                }
                case 7: {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
                    break;
                }
                case 10: 
                case 11: {
                    this._setQ(0, null, null, null);
                    break;
                }
                default: {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 0));
                }
            }
        }
    }

    public final int getNcols() {
        return this._cols.getNum();
    }

    public final int getNrows() {
        return this._rows.getNum();
    }

    public final int getNQCs() {
        return this._qcs.getNum();
    }

    public final int getNSOSs() {
        return this._soss.getNum();
    }

    public final int getNGCs(int n) {
        return this._gcs[n].getNum();
    }

    CpxNumVar getVariable(int n) {
        return (CpxNumVar)this._cols.getObject(n);
    }

    CpxRange getRange(int n) {
        return (CpxRange)this._rows.getObject(n);
    }

    public void setLB(CplexIndex cplexIndex, double d) throws IloException {
        if (d <= -1.0E20) {
            d = -1.0E20;
        }
        this._setLb(cplexIndex._index, d);
    }

    public void setUB(CplexIndex cplexIndex, double d) throws IloException {
        if (d > 1.0E20) {
            d = 1.0E20;
        }
        this._setUb(cplexIndex._index, d);
    }

    public void setType(CplexIndex cplexIndex, byte by) throws IloException {
        this._setType(cplexIndex._index, by);
    }

    public CplexIndex addQC(CpxRange cpxRange, double d, double d2, int n, double[] dArray, int[] nArray, int n2, double[] dArray2, int[] nArray2, int[] nArray3, String string) throws IloException {
        int n3;
        double d3;
        int n4 = this.getNQCs();
        if (d <= -1.0E20) {
            d3 = d2;
            n3 = 76;
        } else if (d2 >= 1.0E20) {
            d3 = d;
            n3 = 71;
        } else if (d == d2) {
            d3 = d;
            n3 = 69;
        } else {
            d3 = d;
            n3 = 82;
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXaddqconstr(this._env, this._lp, n, n2, d3, n3, nArray, dArray, nArray2, nArray3, dArray2, string));
        return this._qcs.addIndex(new CplexIndex(n4), cpxRange);
    }

    public CplexIndex addRow(CpxRange cpxRange, double d, double d2, int n, int[] nArray, double[] dArray) throws IloException {
        int n2 = this.getNrows();
        this.tmplb[0] = d;
        this.tmpub[0] = d2;
        this.tmplen[0] = 0;
        this.tmplen[1] = n;
        this._addRows(1, this.tmplb, this.tmpub, this.tmplen, nArray, dArray);
        return this._rows.addIndex(new CplexIndex(n2), cpxRange);
    }

    public CplexIndex[] addRows(int n, CpxRange[] cpxRangeArray, double[] dArray, double[] dArray2, int[] nArray, CplexIndex[] cplexIndexArray, double[] dArray3) throws IloException {
        int n2 = this.getNrows();
        int n3 = nArray[n];
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = cplexIndexArray[i]._index;
        }
        this._addRows(n, dArray, dArray2, nArray, nArray2, dArray3);
        CplexIndex[] cplexIndexArray2 = new CplexIndex[n];
        for (int i = 0; i < n; ++i) {
            cplexIndexArray2[i] = this._rows.addIndex(new CplexIndex(n2++), cpxRangeArray[i]);
        }
        return cplexIndexArray2;
    }

    void addCuts(IloConstraint[] iloConstraintArray, int n, int n2, int n3) throws IloException {
        Object object;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int[] nArray = new int[n2 + 1];
        CpxObjective[] cpxObjectiveArray = new CpxObjective[n2];
        CpxQextractor[] cpxQextractorArray = new CpxQextractor[n2];
        for (int i = 0; i < n2; ++i) {
            object = (CpxRange)iloConstraintArray[i + n];
            dArray[i] = ((CpxRange)object).getLB();
            dArray2[i] = ((CpxRange)object).getUB();
            cpxObjectiveArray[i] = new CpxObjective(IloObjectiveSense.Minimize, null, null);
            cpxQextractorArray[i] = new CpxQextractor(cpxObjectiveArray[i]);
            CpxNumExpr cpxNumExpr = ((CpxRange)object).getCpxExpr();
            cpxNumExpr.accept(cpxQextractorArray[i]);
            nArray[i + 1] = nArray[i] + cpxObjectiveArray[i]._linear._num;
        }
        int[] nArray2 = new int[nArray[n2]];
        object = new double[nArray[n2]];
        for (int i = 0; i < n2; ++i) {
            int n4 = cpxObjectiveArray[i]._linear._num;
            int n5 = nArray[i];
            System.arraycopy(cpxObjectiveArray[i]._linear._vals, 0, object, n5, n4);
            this.useVars(cpxObjectiveArray[i]._linear._vars, 0, n4, true);
            int n6 = 0;
            while (n6 < n4) {
                nArray2[n5] = cpxObjectiveArray[i]._linear._vars[n6].getVarIndexValue();
                ++n6;
                ++n5;
            }
        }
        this._addCuts(n2, dArray, dArray2, nArray, nArray2, (double[])object, n3);
    }

    void delCuts(int n) throws IloException {
        this._delCuts(n);
    }

    public CplexIndex addSOS(CpxExtractable cpxExtractable, byte by, int n, int n2, CpxNumVar[] cpxNumVarArray, double[] dArray, String string) throws IloException {
        int n3 = this.getNSOSs();
        int n4 = n + n2;
        byte[] byArray = new byte[]{by};
        int[] nArray = new int[]{0};
        String[] stringArray = new String[]{string};
        int[] nArray2 = new int[n4];
        for (int i = n; i < n4; ++i) {
            nArray2[i] = cpxNumVarArray[i].getVarIndexValue();
        }
        this.tmplen[0] = n;
        this.tmplen[1] = n4;
        this._addSOSs(1, byArray, this.tmplen, nArray2, dArray, (String[])(string != null ? stringArray : null));
        return this._soss.addIndex(new CplexIndex(n3), cpxExtractable);
    }

    public void deleteGC(CplexIndex cplexIndex, int n) throws IloException {
        this._gcs[n].deleteIndices(cplexIndex, cplexIndex);
        this.CALL(CplexI.CPXEdelgconstrs(this._env, this._lp, n, cplexIndex.getIndex(), cplexIndex.getIndex()));
    }

    public CplexIndex addIndicator(CpxExtractable cpxExtractable, CplexIndex cplexIndex, int n, double[] dArray, CpxNumVar[] cpxNumVarArray, char c, double d, String string) throws IloException {
        int n2 = this.getNGCs(6);
        int[] nArray = null;
        if (string == null) {
            string = "IloI" + n2;
        }
        if (n > 0) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = cpxNumVarArray[i].getVarIndexValue();
            }
        }
        this.CALL(CplexI.CPXEaddindconstr(this._env, this._lp, cplexIndex.getValue(), 0, n, d, c, nArray, dArray, 3, string));
        return this._gcs[6].addIndex(new CplexIndex(n2), cpxExtractable);
    }

    public CplexIndex addAbs(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(9);
        this.CALL(CplexI.CPXEaddabs(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[9].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addMin(CpxExtractable cpxExtractable, CplexIndex cplexIndex, double d, int n, int[] nArray, double[] dArray, CpxNumVar[] cpxNumVarArray, String string) throws IloException {
        int n2 = this.getNGCs(7);
        int[] nArray2 = null;
        int n3 = nArray.length;
        if (n3 > 0) {
            nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray2[i] = cpxNumVarArray[i].getVarIndexValue();
            }
        }
        double d2 = d > 1.0E20 ? 1.0E20 : d;
        this.CALL(CplexI.CPXEaddminexpr(this._env, this._lp, cplexIndex.getValue(), d2, n, n3, nArray, nArray2, dArray, string));
        return this._gcs[7].addIndex(new CplexIndex(n2), cpxExtractable);
    }

    public CplexIndex addMax(CpxExtractable cpxExtractable, CplexIndex cplexIndex, double d, int n, int[] nArray, double[] dArray, CpxNumVar[] cpxNumVarArray, String string) throws IloException {
        int n2 = this.getNGCs(8);
        int[] nArray2 = null;
        int n3 = nArray.length;
        if (n3 > 0) {
            nArray2 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray2[i] = cpxNumVarArray[i].getVarIndexValue();
            }
        }
        double d2 = d < -1.0E20 ? -1.0E20 : d;
        this.CALL(CplexI.CPXEaddmaxexpr(this._env, this._lp, cplexIndex.getValue(), d2, n, n3, nArray, nArray2, dArray, string));
        return this._gcs[8].addIndex(new CplexIndex(n2), cpxExtractable);
    }

    public CplexIndex addPWL(CpxExtractable cpxExtractable, CplexIndex cplexIndex, double[] dArray, double[] dArray2, double d, double d2, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(9);
        this.CALL(CplexI.CPXEaddpwl(this._env, this._lp, cplexIndex.getValue(), dArray.length, dArray, dArray2.length, dArray2, d, d2, cplexIndex2.getValue(), string));
        return this._gcs[9].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addSetVar(CpxIntSetVar cpxIntSetVar, String string) throws IloException {
        int n;
        int n2 = this.getNGCs(12);
        int n3 = cpxIntSetVar._possible.size();
        int[] nArray = cpxIntSetVar.getPossibleArray();
        double[] dArray = new double[n3];
        int n4 = cpxIntSetVar._required.size();
        int[] nArray2 = cpxIntSetVar.getRequiredArray();
        double[] dArray2 = new double[n4];
        for (n = 0; n < n3; ++n) {
            dArray[n] = nArray[n];
        }
        for (n = 0; n < n4; ++n) {
            dArray2[n] = nArray2[n];
        }
        this.CALL(CplexI.CPXEaddsetvar(this._env, this._lp, n3, dArray, n4, dArray2, string));
        return this._gcs[12].addIndex(new CplexIndex(n2), cpxIntSetVar);
    }

    public void changeSetVar(CpxIntSetVar cpxIntSetVar) throws IloException {
        int n;
        int n2 = cpxIntSetVar._possible.size();
        int[] nArray = cpxIntSetVar.getPossibleArray();
        double[] dArray = new double[n2];
        int n3 = cpxIntSetVar._required.size();
        int[] nArray2 = cpxIntSetVar.getRequiredArray();
        double[] dArray2 = new double[n3];
        for (n = 0; n < n2; ++n) {
            dArray[n] = nArray[n];
        }
        for (n = 0; n < n3; ++n) {
            dArray2[n] = nArray2[n];
        }
        this.CALL(CplexI.CPXEchgsetvar(this._env, this._lp, cpxIntSetVar._gcIndex.getValue(), n2, dArray, n3, dArray2));
    }

    CpxIntSet getIntSetValue(CpxIntSetVar cpxIntSetVar) throws IloException {
        int n = cpxIntSetVar._possible.size();
        int[] nArray = cpxIntSetVar.getPossibleArray();
        int[] nArray2 = new int[n];
        this.CALL(CplexI.CPXEgetsetvarvalues(this._env, this._lp, cpxIntSetVar._gcIndex.getValue(), n, nArray, nArray2));
        CpxIntSet cpxIntSet = new CpxIntSet();
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] != 1) continue;
            cpxIntSet.add(nArray[i]);
        }
        return cpxIntSet;
    }

    public CplexIndex addSetVarCard(CpxIntSetCardVar cpxIntSetCardVar, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(14);
        this.CALL(CplexI.CPXEaddsetvarcard(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[14].addIndex(new CplexIndex(n), cpxIntSetCardVar);
    }

    public CplexIndex addSetVarMember(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, int n, String string) throws IloException {
        int n2 = this.getNGCs(13);
        this.CALL(CplexI.CPXEaddsetvarmember(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), n, string));
        return this._gcs[13].addIndex(new CplexIndex(n2), cpxExtractable);
    }

    public CplexIndex addSetVarSum(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, double[] dArray, String string) throws IloException {
        int n = this.getNGCs(15);
        this.CALL(CplexI.CPXEaddsetvarsum(this._env, this._lp, cplexIndex2.getValue(), cplexIndex.getValue(), dArray.length, dArray, string));
        return this._gcs[15].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addSetVarMin(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, double[] dArray, String string) throws IloException {
        int n = this.getNGCs(16);
        this.CALL(CplexI.CPXEaddsetvarmin(this._env, this._lp, cplexIndex2.getValue(), cplexIndex.getValue(), dArray.length, dArray, string));
        return this._gcs[16].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addSetVarMax(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, double[] dArray, String string) throws IloException {
        int n = this.getNGCs(17);
        this.CALL(CplexI.CPXEaddsetvarmax(this._env, this._lp, cplexIndex2.getValue(), cplexIndex.getValue(), dArray.length, dArray, string));
        return this._gcs[17].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public CplexIndex addSetVarSubset(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, boolean bl, String string) throws IloException {
        int n = this.getNGCs(18);
        this.CALL(CplexI.CPXEaddsetvarsubset(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), bl ? 1 : 0, string));
        return this._gcs[18].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarDomain(CpxExtractable cpxExtractable, CplexIndex cplexIndex, int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) throws IloException {
        int n = this.getNGCs(19);
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = nArray[i];
        }
        this.CALL(CplexI.CPXEaddsetvardomain(this._env, this._lp, cplexIndex.getValue(), n2, dArray, bl ? 1 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0, string));
        return this._gcs[19].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarUnion(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, CplexIndex cplexIndex3, String string) throws IloException {
        int n = this.getNGCs(20);
        this.CALL(CplexI.CPXEaddsetvarunion(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), cplexIndex3.getValue(), string));
        return this._gcs[20].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarIntersection(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, CplexIndex cplexIndex3, String string) throws IloException {
        int n = this.getNGCs(21);
        this.CALL(CplexI.CPXEaddsetvarintersection(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), cplexIndex3.getValue(), string));
        return this._gcs[21].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarNullIntersect(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(22);
        this.CALL(CplexI.CPXEaddsetvarnullintersect(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[22].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarIntersect(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(23);
        this.CALL(CplexI.CPXEaddsetvarintersect(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[23].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarEq(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(24);
        this.CALL(CplexI.CPXEaddsetvareq(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[24].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarNEq(CpxExtractable cpxExtractable, CplexIndex cplexIndex, CplexIndex cplexIndex2, String string) throws IloException {
        int n = this.getNGCs(25);
        this.CALL(CplexI.CPXEaddsetvarneq(this._env, this._lp, cplexIndex.getValue(), cplexIndex2.getValue(), string));
        return this._gcs[25].addIndex(new CplexIndex(n), cpxExtractable);
    }

    CplexIndex addSetVarNEqCst(CpxExtractable cpxExtractable, CplexIndex cplexIndex, int[] nArray, String string) throws IloException {
        int n = this.getNGCs(26);
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = nArray[i];
        }
        this.CALL(CplexI.CPXEaddsetvarneqcst(this._env, this._lp, cplexIndex.getValue(), n2, dArray, string));
        return this._gcs[26].addIndex(new CplexIndex(n), cpxExtractable);
    }

    public void setLHS(CplexIndex cplexIndex, double d) throws IloException {
        if (d <= -1.0E20) {
            d = -1.0E20;
        }
        this._setLHS(cplexIndex._index, d);
    }

    public void setRHS(CplexIndex cplexIndex, double d) throws IloException {
        if (d >= 1.0E20) {
            d = 1.0E20;
        }
        this._setRHS(cplexIndex._index, d);
    }

    public void setLRHS(CplexIndex cplexIndex, double d, double d2) throws IloException {
        if (d <= -1.0E20) {
            d = -1.0E20;
        }
        if (d2 >= 1.0E20) {
            d2 = 1.0E20;
        }
        this._setLRHS(cplexIndex._index, d, d2);
    }

    public void addNZs(int[] nArray, int[] nArray2, double[] dArray, int n) throws IloException {
        this._addNZs(n, nArray, nArray2, dArray);
    }

    public void addNZ(CplexIndex cplexIndex, CplexIndex cplexIndex2, double d) throws IloException {
        double[] dArray = new double[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = cplexIndex._index;
        nArray2[0] = cplexIndex2._index;
        dArray[0] = d;
        this._addNZs(1, nArray, nArray2, dArray);
    }

    public void delColumn(CplexIndex cplexIndex) throws IloException {
        this._cols.deleteIndices(cplexIndex, cplexIndex);
        this._ord.deleteColumn(cplexIndex);
        this.removeFromFilters(cplexIndex);
        this._delColumns(cplexIndex.getValue(), cplexIndex.getValue());
    }

    public void delColumns(CpxNumVar[] cpxNumVarArray, int n, int n2) throws IloException {
        int[] nArray = new int[this.getNcols()];
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (cpxNumVarArray[i] == null || cpxNumVarArray[i].getVarIndex() == null || cpxNumVarArray[i].getVarIndexValue() < 0) continue;
            nArray[cpxNumVarArray[i].getVarIndexValue()] = 1;
            cpxNumVarArray[i].setIndex(null, null);
        }
        this._cols.deleteIndices(nArray);
        this._ord.deleteColumns(nArray);
        this.removeFromFilters(nArray);
        this._delColumns(nArray);
    }

    public void delRows(CplexIndex cplexIndex) throws IloException {
        this._rows.deleteIndices(cplexIndex._index, cplexIndex._index);
        this._delRows(cplexIndex._index, cplexIndex._index);
    }

    public void delRows(CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        int[] nArray = new int[this.getNrows()];
        for (int i = n; i < n3; ++i) {
            nArray[cplexIndexArray[i].getValue()] = 1;
        }
        this._rows.deleteIndices(nArray);
        this._delRows(nArray);
    }

    public void delRows(CpxRange[] cpxRangeArray, int n, int n2) throws IloException {
        int n3 = n + n2;
        int[] nArray = new int[this.getNrows()];
        for (int i = n; i < n3; ++i) {
            nArray[cpxRangeArray[i].getIndexValue()] = 1;
        }
        this._rows.deleteIndices(nArray);
        this._delRows(nArray);
    }

    public void delQC(CplexIndex cplexIndex) throws IloException {
        this.invalidate();
        this._qcs.deleteIndices(cplexIndex._index, cplexIndex._index);
        this._delQCs(cplexIndex._index, cplexIndex._index);
        if (this.getNQCs() <= 0) {
            if (this.isMIP()) {
                if (this.isQO()) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
                } else {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
                }
            } else if (this.isQO()) {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 5));
            } else {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 0));
            }
        }
    }

    public void delSOSs(CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int[] nArray = new int[this.getNSOSs()];
        n2 += n;
        for (int i = n; i < n2; ++i) {
            if (cplexIndexArray[i]._index < 0) continue;
            nArray[cplexIndexArray[i]._index] = 1;
        }
        this._soss.deleteIndices(nArray);
        this._delSOSs(nArray);
    }

    void clearModel() throws IloException {
        int n = this._cols.getNum();
        for (int i = 0; i < n; ++i) {
            ((CpxNumVar)this._cols.getObject((int)i))._varIndex = null;
        }
        this._clearModel();
        this._soss.clear();
        this._rows.clear();
        this._qcs.clear();
        this._cols.clear();
        this._filter.clear();
        this._filters.clear();
        this._ord.clear();
        this._status = 0;
    }

    void endModel() throws IloException {
        this._clearModel();
        for (int i = 0; i < 27; ++i) {
            this._gcs[i] = new IndexManager();
        }
        this._rows = this._gcs[3];
        this._qcs = this._gcs[4];
        this._soss = this._gcs[5];
        this._cols = new IndexManager();
        this._filter = new Vector();
        this._filters = new IndexManager();
        this._ord = new CpxOrder();
    }

    public void setNZ(CplexIndex cplexIndex, CplexIndex cplexIndex2, double d) throws IloException {
        this._setNZ(cplexIndex._index, cplexIndex2._index, d);
    }

    void setNZs(int[] nArray, int[] nArray2, double[] dArray, int n) throws IloException {
        this._setNZs(n, nArray, nArray2, dArray);
    }

    public void setNZs(CplexIndex[] cplexIndexArray, CplexIndex[] cplexIndexArray2, double[] dArray, int n, int n2) throws IloException {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = cplexIndexArray[i + n]._index;
            nArray2[i] = cplexIndexArray2[i + n]._index;
        }
        if (n == 0) {
            this._setNZs(n2, nArray, nArray2, dArray);
        } else {
            double[] dArray2 = new double[n2];
            System.arraycopy(dArray, n, dArray2, 0, n2);
            this._setNZs(n2, nArray, nArray2, dArray2);
        }
    }

    public void setObjCoef(CplexIndex cplexIndex, double d) throws IloException {
        this._setObjCoef(cplexIndex._index, d);
    }

    public void setObjCoefs(CplexIndex[] cplexIndexArray, double[] dArray, int n, int n2) throws IloException {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = cplexIndexArray[i + n].getIndex();
        }
        if (n > 0) {
            double[] dArray2 = new double[n2];
            System.arraycopy(dArray, n, dArray2, 0, n2);
            this._setObjCoefs(n2, nArray, dArray2);
        } else {
            this._setObjCoefs(n2, nArray, dArray);
        }
    }

    CpxNumVar[] getVars(int[] nArray, int n, int n2) {
        CpxNumVar[] cpxNumVarArray = new CpxNumVar[n2];
        for (int i = 0; i < n2; ++i) {
            cpxNumVarArray[i] = (CpxNumVar)this._cols.getObject(nArray[i + n]);
        }
        return cpxNumVarArray;
    }

    public void getQC(CpxRange cpxRange, double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3, int[][] nArray2, int[][] nArray3, double[][] dArray4) throws IloException {
        this.getQC(cpxRange.getIndexValue(), dArray, dArray2, nArray, dArray3, nArray2, nArray3, dArray4);
    }

    public void getQC(int n, double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3, int[][] nArray2, int[][] nArray3, double[][] dArray4) throws IloException {
        int n2 = 0;
        int n3 = 0;
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        double[] dArray5 = new double[]{0.0};
        byte[] byArray = new byte[]{0};
        int[] nArray6 = new int[]{0};
        int[] nArray7 = new int[]{0};
        int n4 = CplexI.CPXgetqconstr(this._env, this._lp, nArray4, nArray5, dArray5, byArray, null, null, 0, nArray6, null, null, null, 0, nArray7, n);
        if (n4 != 0 && n4 != 1207) {
            this.CALL(n4);
        }
        if (nArray != null || dArray3 != null || nArray2 != null || nArray3 != null || dArray4 != null) {
            int[] nArray8 = null;
            int[] nArray9 = null;
            int[] nArray10 = null;
            double[] dArray6 = null;
            double[] dArray7 = null;
            n2 = -nArray6[0];
            n3 = -nArray7[0];
            if (n2 > 0 && nArray != null && dArray3 != null) {
                nArray[0] = new int[n2];
                nArray8 = nArray[0];
                dArray3[0] = new double[n2];
                dArray6 = dArray3[0];
            }
            if (n3 > 0 && nArray2 != null && nArray3 != null && dArray4 != null) {
                nArray2[0] = new int[n3];
                nArray9 = nArray2[0];
                nArray3[0] = new int[n3];
                nArray10 = nArray3[0];
                dArray4[0] = new double[n3];
                dArray7 = dArray4[0];
            }
            this.CALL(CplexI.CPXgetqconstr(this._env, this._lp, nArray4, nArray5, dArray5, byArray, nArray8, dArray6, n2, nArray6, nArray9, nArray10, dArray7, n3, nArray7, n));
        }
        if (byArray[0] == 76) {
            if (dArray != null) {
                dArray[0] = -1.7976931348623157E308;
            }
            if (dArray2 != null) {
                dArray2[0] = dArray5[0];
            }
        } else if (byArray[0] == 71) {
            if (dArray != null) {
                dArray[0] = dArray5[0];
            }
            if (dArray2 != null) {
                dArray2[0] = Double.MAX_VALUE;
            }
        } else {
            if (dArray != null) {
                dArray[0] = dArray5[0];
            }
            if (dArray2 != null) {
                dArray2[0] = dArray5[0];
            }
        }
    }

    public void getCpxQC(CpxRange cpxRange, double[] dArray, double[] dArray2, CpxNumVar[][] cpxNumVarArray, double[][] dArray3, CpxNumVar[][] cpxNumVarArray2, CpxNumVar[][] cpxNumVarArray3, double[][] dArray4) throws IloException {
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        if (cpxNumVarArray != null && dArray3 != null) {
            object = new int[1][];
        }
        if (cpxNumVarArray2 != null && cpxNumVarArray3 != null && dArray3 != null) {
            object2 = new int[1][];
            object3 = new int[1][];
        }
        this.getQC(cpxRange, dArray, dArray2, (int[][])object, dArray3, (int[][])object2, (int[][])object3, dArray4);
        if (object != null && object[0] != null) {
            cpxNumVarArray[0] = this.getVars(object[0], 0, object[0].length);
        }
        if (object2 != null && object2[0] != null) {
            cpxNumVarArray2[0] = this.getVars(object2[0], 0, object2[0].length);
        }
        if (object3 != null && object3[0] != null) {
            cpxNumVarArray3[0] = this.getVars(object3[0], 0, object3[0].length);
        }
    }

    public void getRows(CpxRange[] cpxRangeArray, int n, int n2, double[] dArray, double[] dArray2, int[][] nArray, double[][] dArray3) throws IloException {
        int n3;
        int n4;
        int n5 = this.getNrows();
        int n6 = -1;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            int n8 = cpxRangeArray[i].getIndexValue();
            if (n8 < 0) continue;
            if (n8 < n5) {
                n5 = n8;
            }
            if (n8 <= n6) continue;
            n6 = n8;
        }
        double[] dArray4 = null;
        double[] dArray5 = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        double[] dArray6 = null;
        if (dArray != null || dArray2 != null) {
            dArray4 = new double[n6 - n5 + 1];
            dArray5 = new double[n6 - n5 + 1];
        }
        if (nArray != null && dArray3 != null) {
            n4 = this._getRowNZnum(n5, n6);
            nArray2 = new int[n6 - n5 + 2];
            nArray3 = new int[n4];
            dArray6 = new double[n4];
        }
        this._getRows(n5, n6, dArray4, dArray5, nArray2, nArray3, dArray6);
        if (dArray != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue();
                dArray[n4 - n] = dArray4[n3 - n5];
            }
        }
        if (dArray2 != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue();
                dArray2[n4 - n] = dArray5[n3 - n5];
            }
        }
        if (nArray != null && dArray3 != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue() - n5;
                int n9 = nArray2[n3];
                int n10 = nArray2[n3 + 1] - n9;
                dArray3[n4 - n] = new double[n10];
                System.arraycopy(dArray6, n9, dArray3[n4 - n], 0, n10);
                nArray[n4 - n] = new int[n10];
                for (int i = 0; i < n10; ++i) {
                    nArray[n4 - n][i] = nArray3[i + n9];
                }
            }
        }
    }

    public void getCpxRows(CpxRange[] cpxRangeArray, int n, int n2, double[] dArray, double[] dArray2, CpxNumVar[][] cpxNumVarArray, double[][] dArray3) throws IloException {
        int n3;
        int n4;
        int n5 = this.getNrows();
        int n6 = -1;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            int n8 = cpxRangeArray[i].getIndexValue();
            if (n8 < 0) continue;
            if (n8 < n5) {
                n5 = n8;
            }
            if (n8 <= n6) continue;
            n6 = n8;
        }
        double[] dArray4 = null;
        double[] dArray5 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        double[] dArray6 = null;
        if (dArray2 != null || dArray != null) {
            dArray4 = new double[n6 - n5 + 1];
            dArray5 = new double[n6 - n5 + 1];
        }
        if (cpxNumVarArray != null && dArray3 != null) {
            n4 = this._getRowNZnum(n5, n6);
            nArray = new int[n6 - n5 + 2];
            nArray2 = new int[n4];
            dArray6 = new double[n4];
        }
        this._getRows(n5, n6, dArray4, dArray5, nArray, nArray2, dArray6);
        if (dArray != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue();
                dArray[n4 - n] = dArray4[n3 - n5];
            }
        }
        if (dArray2 != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue();
                dArray2[n4 - n] = dArray5[n3 - n5];
            }
        }
        if (cpxNumVarArray != null && dArray3 != null) {
            for (n4 = n; n4 < n7; ++n4) {
                n3 = cpxRangeArray[n4].getIndexValue() - n5;
                int n9 = nArray[n3];
                int n10 = nArray[n3 + 1] - n9;
                dArray3[n4] = new double[n10];
                System.arraycopy(dArray6, n9, dArray3[n4], 0, n10);
                cpxNumVarArray[n4] = new CpxNumVar[n10];
                for (int i = 0; i < n10; ++i) {
                    cpxNumVarArray[n4][i] = (CpxNumVar)this._cols.getObject(nArray2[i + n9]);
                }
            }
        }
    }

    void getColumns(int n, int n2, int[] nArray, int[][] nArray2, double[][] dArray) throws IloException {
        int n3 = this._getColumnNZnum(n, n2);
        nArray2[0] = new int[n3];
        dArray[0] = new double[n3];
        this._getColumns(n, n2, nArray, nArray2[0], dArray[0]);
    }

    void getSOSs(int n, int n2, byte[] byArray, int[] nArray, int[][] nArray2, double[][] dArray) throws IloException {
        int n3 = this._getSOSNZnum(n, n2);
        nArray2[0] = new int[n3];
        dArray[0] = new double[n3];
        this._getSOSs(n, n2, byArray, nArray, nArray2[0], dArray[0]);
    }

    void getCpxSOSs(int n, int n2, byte[] byArray, CpxNumVar[][] cpxNumVarArray, double[][] dArray) throws IloException {
        int n3 = n2 - n + 1;
        int[] nArray = new int[n3 + 1];
        int[][] nArrayArray = new int[1][];
        double[][] dArrayArray = new double[1][];
        this.getSOSs(n, n2, byArray, nArray, nArrayArray, dArrayArray);
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i + 1] - nArray[i];
            if (dArray != null) {
                dArray[i] = new double[n4];
                System.arraycopy(dArrayArray[0], nArray[i], dArray[i], 0, n4);
            }
            if (cpxNumVarArray == null) continue;
            cpxNumVarArray[i] = new CpxNumVar[n4];
            for (int j = 0; j < n4; ++j) {
                cpxNumVarArray[i][j] = (CpxNumVar)this._cols.getObject(nArrayArray[0][nArray[i] + j]);
            }
        }
    }

    void setIntParam(int n, int n2) throws IloException {
        if (n == 1062) {
            if (n2 == 5) {
                this._setIntParam(1062, 5);
                this._setIntParam(1063, 0);
                this._setIntParam(2025, 5);
            } else if (n2 == 6) {
                this._setIntParam(1062, 6);
                this._setIntParam(1063, 0);
                this._setIntParam(2025, 0);
            } else {
                this._setIntParam(1062, n2);
                this._setIntParam(1063, n2);
                this._setIntParam(2025, n2);
            }
        } else {
            this._setIntParam(n, n2);
        }
    }

    int getIntParam(int n) throws IloException {
        int[] nArray = new int[1];
        this._getIntParam(n, nArray);
        return nArray[0];
    }

    int minIntParam(int n) throws IloException {
        int[] nArray = new int[1];
        this._minIntParam(n, nArray);
        return nArray[0];
    }

    int maxIntParam(int n) throws IloException {
        int[] nArray = new int[1];
        this._maxIntParam(n, nArray);
        return nArray[0];
    }

    int defIntParam(int n) throws IloException {
        int[] nArray = new int[1];
        this._defIntParam(n, nArray);
        return nArray[0];
    }

    void setDoubleParam(int n, double d) throws IloException {
        this._setDoubleParam(n, d);
    }

    double getDoubleParam(int n) throws IloException {
        double[] dArray = new double[1];
        this._getDoubleParam(n, dArray);
        return dArray[0];
    }

    double minDoubleParam(int n) throws IloException {
        double[] dArray = new double[1];
        this._minDoubleParam(n, dArray);
        return dArray[0];
    }

    double maxDoubleParam(int n) throws IloException {
        double[] dArray = new double[1];
        this._maxDoubleParam(n, dArray);
        return dArray[0];
    }

    double defDoubleParam(int n) throws IloException {
        double[] dArray = new double[1];
        this._defDoubleParam(n, dArray);
        return dArray[0];
    }

    void setStringParam(int n, String string) throws IloException {
        this._setStringParam(n, string);
    }

    String getStringParam(int n) throws IloException {
        String[] stringArray = new String[1];
        this._getStringParam(n, stringArray);
        return stringArray[0];
    }

    String defStringParam(int n) throws IloException {
        String[] stringArray = new String[1];
        this._defStringParam(n, stringArray);
        return stringArray[0];
    }

    IloCplex.ParameterSet getParameterSet() throws IloException {
        IloCplex.ParameterSet parameterSet = new IloCplex.ParameterSet();
        parameterSet.extractFrom(this);
        return parameterSet;
    }

    void setParameterSet(IloCplex.ParameterSet parameterSet) throws IloException {
        parameterSet.applyTo(this);
    }

    void fillXcache() throws IloException {
        double[] dArray = new double[]{0.0};
        if (CplexI.CPXgetobjval(this._env, this._lp, dArray) == 0) {
            int n = this.getNcols();
            if (this._xCache == null || this._xCache.length < n) {
                this._xCache = new double[n];
            }
            this.CALL(CplexI.CPXgetx(this._env, this._lp, this._xCache, 0, n - 1));
        }
    }

    double[] getXcache() throws IloException {
        double[] dArray = new double[]{0.0};
        this.CALL(CplexI.CPXgetobjval(this._env, this._lp, dArray));
        return this._xCache;
    }

    private void invalidate() {
        this._slack.invalidate();
        this._qcslack.invalidate();
        this._solnpoolX.invalidate();
        this._solnpoolSlack.invalidate();
        this._solnpoolQCSlack.invalidate();
    }

    private double[] getSlackArray() throws IloException {
        if (!this._slack.isValid(-1)) {
            int n = this.getNrows();
            this._slack.resize(n + 1);
            this.CALL(CplexI.CPXgetslack(this._env, this._lp, this._slack.getArray(), 0, n - 1));
            this._slack.validate(-1);
        }
        return this._slack.getArray();
    }

    private double[] getQCSlackArray() throws IloException {
        if (!this._qcslack.isValid(-1)) {
            int n = this.getNQCs();
            this._qcslack.resize(n + 1);
            this.CALL(CplexI.CPXgetqconstrslack(this._env, this._lp, this._qcslack.getArray(), 0, n - 1));
            this._qcslack.validate(-1);
        }
        return this._qcslack.getArray();
    }

    private double[] getSolnPoolXArray(int n) throws IloException {
        if (!this._solnpoolX.isValid(n)) {
            int n2 = this.getNcols();
            this._solnpoolX.resize(n2 + 1);
            this.CALL(CplexI.CPXgetsolnpoolx(this._env, this._lp, n, this._solnpoolX.getArray(), 0, n2 - 1));
            this._solnpoolX.validate(n);
        }
        return this._solnpoolX.getArray();
    }

    private double[] getSolnPoolSlackArray(int n) throws IloException {
        if (!this._solnpoolSlack.isValid(n)) {
            int n2 = this.getNrows();
            this._solnpoolSlack.resize(n2 + 1);
            this.CALL(CplexI.CPXgetsolnpoolslack(this._env, this._lp, n, this._solnpoolSlack.getArray(), 0, n2 - 1));
            this._solnpoolSlack.validate(n);
        }
        return this._solnpoolSlack.getArray();
    }

    private double[] getSolnPoolQCSlackArray(int n) throws IloException {
        if (!this._solnpoolQCSlack.isValid(n)) {
            int n2 = this.getNQCs();
            this._solnpoolQCSlack.resize(n2 + 1);
            this.CALL(CplexI.CPXgetsolnpoolqconstrslack(this._env, this._lp, n, this._solnpoolQCSlack.getArray(), 0, n2 - 1));
            this._solnpoolQCSlack.validate(n);
        }
        return this._solnpoolQCSlack.getArray();
    }

    void solve() throws IloException {
        this.invalidate();
        this.origProbType();
        this.initCallbacks();
        this._ord.install(this);
        this.flushFilters();
        int n = 0;
        this._solving = true;
        int n2 = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n2 == 1 || n2 == 7 || n2 == 11) {
            n = CplexI.CPXmipopt(this._env, this._lp);
        } else if (n2 == 5) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            CplexI.CPXgetintparam(this._env, 1062, nArray2);
            CplexI.CPXgetintparam(this._env, 1063, nArray);
            if (nArray2[0] == 5) {
                CplexI.CPXgetintparam(this._env, IloCplex.IntParam.SiftAlg.getValue(), nArray3);
                CplexI.CPXsetintparam(this._env, 1063, nArray3[0]);
            }
            n = CplexI.CPXqpopt(this._env, this._lp);
            CplexI.CPXsetintparam(this._env, 1063, nArray[0]);
        } else if (n2 == 10) {
            int[] nArray = new int[1];
            CplexI.CPXgetintparam(this._env, 1062, nArray);
            n = nArray[0] == 4 || nArray[0] == 0 ? CplexI.CPXhybbaropt(this._env, this._lp, -1) : CplexI.CPXqpopt(this._env, this._lp);
        } else {
            n = CplexI.CPXlpopt(this._env, this._lp);
        }
        this._solving = false;
        this.finitCallbacks();
        this.fillXcache();
        this.setStatus(n);
        this.checkCallbacks();
    }

    void populate() throws IloException {
        this.invalidate();
        this.initCallbacks();
        this._ord.install(this);
        this.flushFilters();
        this.origProbType();
        this._solving = true;
        int n = CplexI.CPXpopulate(this._env, this._lp);
        this._solving = false;
        this.finitCallbacks();
        this.fillXcache();
        this.setStatus(n);
        this.checkCallbacks();
    }

    void solveFixed(int n) throws IloException {
        int n2 = 0;
        this.invalidate();
        this.initCallbacks();
        if (this.isQC()) {
            throw new CpxException(-1, "solveFixed not allowed for models with quadratic constraints");
        }
        if (this.isQO()) {
            this.CALL(CplexI.CPXchgprobtypesolnpool(this._env, this._lp, n, 8));
        } else {
            this.CALL(CplexI.CPXchgprobtypesolnpool(this._env, this._lp, n, 3));
        }
        this._solving = true;
        n2 = CplexI.CPXgetprobtype(this._env, this._lp) == 8 ? CplexI.CPXqpopt(this._env, this._lp) : CplexI.CPXlpopt(this._env, this._lp);
        this._solving = false;
        this.finitCallbacks();
        this.fillXcache();
        this.setStatus(n2);
        this.checkCallbacks();
    }

    int tuneParam(IloCplex.ParameterSet parameterSet) throws IloException {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (parameterSet != null) {
            object3 = parameterSet.iterator();
            while (object3.hasNext()) {
                object2 = (IloCplex.Parameter)object3.next();
                switch (((IloCplex.Parameter)object2).getType()) {
                    case 1: {
                        ++n;
                        break;
                    }
                    case 0: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        ++n3;
                    }
                }
            }
        }
        object3 = new int[n + 1];
        object2 = new double[n + 1];
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        int[] nArray3 = new int[n3 + 1];
        String[] stringArray = new String[n3 + 1];
        n = 0;
        n2 = 0;
        n3 = 0;
        if (parameterSet != null) {
            object = parameterSet.iterator();
            while (object.hasNext()) {
                IloCplex.Parameter parameter = (IloCplex.Parameter)object.next();
                switch (parameter.getType()) {
                    case 1: {
                        object3[n] = ((IloCplex.DoubleParameter)parameter).getKey().getValue();
                        object2[n] = ((IloCplex.DoubleParameter)parameter).getValue();
                        ++n;
                        break;
                    }
                    case 0: {
                        nArray[n2] = ((IloCplex.IntParameter)parameter).getKey().getValue();
                        nArray2[n2] = ((IloCplex.IntParameter)parameter).getValue();
                        ++n2;
                        break;
                    }
                    case 2: {
                        nArray[n2] = ((IloCplex.BooleanParameter)parameter).getKey().getValue();
                        nArray[n2] = ((IloCplex.BooleanParameter)parameter).getValue() ? 1 : 0;
                        ++n2;
                        break;
                    }
                    case 3: {
                        nArray3[n3] = ((IloCplex.StringParameter)parameter).getKey().getValue();
                        stringArray[n3] = ((IloCplex.StringParameter)parameter).getValue();
                        ++n3;
                    }
                }
            }
        }
        object = new int[1];
        this.CALL(CplexI.CPXtuneparam(this._env, this._lp, n2, nArray, nArray2, n, (int[])object3, (double[])object2, n3, nArray3, stringArray, (int[])object));
        return (int)object[0];
    }

    int tuneParam(String[] stringArray, IloCplex.ParameterSet parameterSet) throws IloException {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (parameterSet != null) {
            object3 = parameterSet.iterator();
            while (object3.hasNext()) {
                object2 = (IloCplex.Parameter)object3.next();
                switch (((IloCplex.Parameter)object2).getType()) {
                    case 1: {
                        ++n;
                        break;
                    }
                    case 0: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        ++n3;
                    }
                }
            }
        }
        object3 = new int[n + 1];
        object2 = new double[n + 1];
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        int[] nArray3 = new int[n2 + 1];
        String[] stringArray2 = new String[n3 + 1];
        n = 0;
        n2 = 0;
        n3 = 0;
        if (parameterSet != null) {
            Iterator iterator = parameterSet.iterator();
            while (iterator.hasNext()) {
                object = (IloCplex.Parameter)iterator.next();
                switch (((IloCplex.Parameter)object).getType()) {
                    case 1: {
                        object3[n] = ((IloCplex.DoubleParameter)object).getKey().getValue();
                        object2[n] = ((IloCplex.DoubleParameter)object).getValue();
                        ++n;
                        break;
                    }
                    case 0: {
                        nArray[n2] = ((IloCplex.IntParameter)object).getKey().getValue();
                        nArray2[n2] = ((IloCplex.IntParameter)object).getValue();
                        ++n2;
                        break;
                    }
                    case 2: {
                        nArray[n2] = ((IloCplex.BooleanParameter)object).getKey().getValue();
                        nArray[n2] = ((IloCplex.BooleanParameter)object).getValue() ? 1 : 0;
                        ++n2;
                        break;
                    }
                    case 3: {
                        nArray3[n3] = ((IloCplex.StringParameter)object).getKey().getValue();
                        stringArray2[n3] = ((IloCplex.StringParameter)object).getValue();
                        ++n3;
                    }
                }
            }
        }
        int n4 = stringArray.length;
        object = new int[1];
        this.CALL(CplexI.CPXtuneparamprobset(this._env, n4, stringArray, null, n2, nArray, nArray2, n, (int[])object3, (double[])object2, n3, nArray3, stringArray2, (int[])object));
        return (int)object[0];
    }

    public double getObjValue() throws IloException {
        double[] dArray = new double[1];
        this._getObjValue(dArray);
        return dArray[0];
    }

    public double getBestObjValue() throws IloException {
        double[] dArray = new double[1];
        this._getBestObjValue(dArray);
        return dArray[0];
    }

    public double getMIPRelativeGap() throws IloException {
        double[] dArray = new double[1];
        this._getMIPRelativeGap(dArray);
        return dArray[0];
    }

    public double getCutoff() throws IloException {
        double[] dArray = new double[1];
        this._getCutoff(dArray);
        return dArray[0];
    }

    public double[] getX(int n, int n2) throws IloException {
        double[] dArray = this.getXcache();
        double[] dArray2 = new double[n2 - n + 1];
        System.arraycopy(dArray, n, dArray2, 0, n2 - n + 1);
        return dArray2;
    }

    public double[] getPi(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getPi(n, n2, dArray);
        return dArray;
    }

    public double[] getRowInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getRowInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getQCInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getQCInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getIndInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getIndInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getSOSInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getSOSInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getColInfeasibilities(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getColInfeasibilities(n, n2, dArray);
        return dArray;
    }

    public double[] getInfeasibilities(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        double[] dArray = new double[n2];
        int n3 = this.getNrows();
        double[] dArray2 = this.getRowInfeasibilities(0, n3 - 1);
        for (int i = 0; i < n2; ++i) {
            int n4 = i + n;
            IntArray intArray = new IntArray();
            ByteArray byteArray = new ByteArray();
            this.fillGroup(iloConstraintArray[n4], intArray, byteArray);
            int n5 = intArray.getSize();
            dArray[i] = 0.0;
            double[] dArray3 = new double[]{0.0};
            for (int j = 0; j < n5; ++j) {
                if (byteArray.getArray()[j] == 1 || byteArray.getArray()[j] == 2) {
                    dArray3 = this.getColInfeasibilities(intArray.getArray()[j], intArray.getArray()[j]);
                } else if (byteArray.getArray()[j] == 3) {
                    dArray3[0] = dArray2[intArray.getArray()[j]];
                } else if (byteArray.getArray()[j] == 4) {
                    dArray3 = this.getQCInfeasibilities(intArray.getArray()[j], intArray.getArray()[j]);
                } else if (byteArray.getArray()[j] == 5) {
                    dArray3 = this.getSOSInfeasibilities(intArray.getArray()[j], intArray.getArray()[j]);
                } else if (byteArray.getArray()[j] == 6) {
                    dArray3 = this.getIndInfeasibilities(intArray.getArray()[j], intArray.getArray()[j]);
                }
                dArray[i] = n5 > 1 ? Math.max(Math.abs(dArray3[0]), dArray[i]) : dArray3[0];
            }
        }
        return dArray;
    }

    public double[] getReducedCosts(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getReducedCosts(n, n2, dArray);
        return dArray;
    }

    public double[] getAX(int n, int n2) throws IloException {
        double[] dArray = new double[n2 - n + 1];
        this._getAX(n, n2, dArray);
        return dArray;
    }

    public IloCplex.BasisStatus getColumnBasis(CplexIndex cplexIndex) throws IloException {
        int[] nArray = new int[this.getNcols()];
        this._getBase(nArray, null);
        switch (nArray[cplexIndex.getIndex()]) {
            case 0: {
                return IloCplex.BasisStatus.AtLower;
            }
            case 1: {
                return IloCplex.BasisStatus.Basic;
            }
            case 2: {
                return IloCplex.BasisStatus.AtUpper;
            }
            case 3: {
                return IloCplex.BasisStatus.FreeOrSuperbasic;
            }
        }
        return IloCplex.BasisStatus.NotABasicStatus;
    }

    public IloCplex.BasisStatus[] getColumnBasis(CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int[] nArray = new int[this.getNcols()];
        this._getBase(nArray, null);
        IloCplex.BasisStatus[] basisStatusArray = new IloCplex.BasisStatus[n2];
        block6: for (int i = 0; i < n2; ++i) {
            switch (nArray[cplexIndexArray[i + n].getIndex()]) {
                case 0: {
                    basisStatusArray[i] = IloCplex.BasisStatus.AtLower;
                    continue block6;
                }
                case 1: {
                    basisStatusArray[i] = IloCplex.BasisStatus.Basic;
                    continue block6;
                }
                case 2: {
                    basisStatusArray[i] = IloCplex.BasisStatus.AtUpper;
                    continue block6;
                }
                case 3: {
                    basisStatusArray[i] = IloCplex.BasisStatus.FreeOrSuperbasic;
                    continue block6;
                }
                default: {
                    basisStatusArray[i] = IloCplex.BasisStatus.NotABasicStatus;
                }
            }
        }
        return basisStatusArray;
    }

    public IloCplex.BasisStatus getRowBasis(CplexIndex cplexIndex) throws IloException {
        int[] nArray = new int[this.getNrows()];
        this._getBase(null, nArray);
        switch (nArray[cplexIndex.getIndex()]) {
            case 0: {
                return IloCplex.BasisStatus.AtLower;
            }
            case 1: {
                return IloCplex.BasisStatus.Basic;
            }
            case 2: {
                return IloCplex.BasisStatus.AtUpper;
            }
            case 3: {
                return IloCplex.BasisStatus.FreeOrSuperbasic;
            }
        }
        return IloCplex.BasisStatus.NotABasicStatus;
    }

    public IloCplex.BasisStatus[] getRowBasis(CpxRange[] cpxRangeArray, int n, int n2) throws IloException {
        int[] nArray = new int[this.getNrows()];
        this._getBase(null, nArray);
        IloCplex.BasisStatus[] basisStatusArray = new IloCplex.BasisStatus[n2];
        block6: for (int i = 0; i < n2; ++i) {
            switch (nArray[cpxRangeArray[i + n].getIndexValue()]) {
                case 0: {
                    basisStatusArray[i] = IloCplex.BasisStatus.AtLower;
                    continue block6;
                }
                case 1: {
                    basisStatusArray[i] = IloCplex.BasisStatus.Basic;
                    continue block6;
                }
                case 2: {
                    basisStatusArray[i] = IloCplex.BasisStatus.AtUpper;
                    continue block6;
                }
                case 3: {
                    basisStatusArray[i] = IloCplex.BasisStatus.FreeOrSuperbasic;
                    continue block6;
                }
                default: {
                    basisStatusArray[i] = IloCplex.BasisStatus.NotABasicStatus;
                }
            }
        }
        return basisStatusArray;
    }

    public void setBasis(CplexIndex[] cplexIndexArray, IloCplex.BasisStatus[] basisStatusArray, int n, int n2, CplexIndex[] cplexIndexArray2, IloCplex.BasisStatus[] basisStatusArray2, int n3, int n4) throws IloException {
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int n8 = this.getNcols();
        int[] nArray2 = new int[n8];
        if (CplexI.CPXgetbase(this._env, this._lp, nArray2, nArray = new int[n7 = this.getNrows()]) != 0) {
            for (n6 = 0; n6 < n7; ++n6) {
                nArray[n6] = 1;
            }
            for (n6 = 0; n6 < n8; ++n6) {
                nArray2[n6] = 0;
            }
        }
        n6 = n + n2;
        for (n5 = n; n5 < n6; ++n5) {
            nArray2[cplexIndexArray[n5].getIndex()] = basisStatusArray[n5]._stat;
        }
        n5 = n3 + n4;
        for (int i = n3; i < n5; ++i) {
            nArray[cplexIndexArray2[i].getIndex()] = basisStatusArray2[i]._stat;
        }
        this._setBase(nArray2, nArray);
    }

    void setVectors(double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, int n, int n2, double[] dArray3, double[] dArray4, IloRange[] iloRangeArray, int n3, int n4) throws IloException {
        int n5;
        int n6 = n + n2;
        int[] nArray = new int[n6];
        for (n5 = n; n5 < n6; ++n5) {
            nArray[n5] = ((CpxNumVar)iloNumVarArray[n5]).getVarIndexValue();
        }
        n5 = n3 + n4;
        int[] nArray2 = new int[n5];
        for (int i = n3; i < n5; ++i) {
            nArray2[i] = ((CpxRange)iloRangeArray[i]).getIndexValue();
        }
        this._copyStart(dArray, dArray2, nArray, n, n2, dArray3, dArray4, nArray2, n3, n4);
    }

    public int addMIPStart(IloNumVar[] iloNumVarArray, double[] dArray, int n, int n2, IloCplex.MIPStartEffort mIPStartEffort, String string) throws IloException {
        int n3 = this.getNMIPStarts();
        double[] dArray2 = new double[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{mIPStartEffort._value};
        for (int i = 0; i < n2; ++i) {
            nArray[i] = ((CpxNumVar)iloNumVarArray[n + i]).getVarIndexValue();
            dArray2[i] = dArray[n + i];
        }
        if (string != null) {
            String[] stringArray = new String[]{string};
            this.CALL(CplexI.CPXaddmipstarts(this._env, this._lp, 1, n2, nArray2, nArray, dArray2, nArray3, stringArray));
        } else {
            this.CALL(CplexI.CPXaddmipstarts(this._env, this._lp, 1, n2, nArray2, nArray, dArray2, nArray3, null));
        }
        return n3;
    }

    public void changeMIPStart(int n, IloNumVar[] iloNumVarArray, double[] dArray, int n2, int n3, IloCplex.MIPStartEffort mIPStartEffort) throws IloException {
        double[] dArray2 = new double[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{mIPStartEffort._value};
        int[] nArray4 = new int[]{n};
        for (int i = 0; i < n3; ++i) {
            nArray[i] = ((CpxNumVar)iloNumVarArray[n2 + i]).getVarIndexValue();
            dArray2[i] = dArray[n2 + i];
        }
        this.CALL(CplexI.CPXchgmipstarts(this._env, this._lp, 1, nArray4, n3, nArray2, nArray, dArray2, nArray3));
    }

    public void deleteMIPStarts(int n, int n2) throws IloException {
        int n3 = n + n2 - 1;
        if (n3 >= this.getNMIPStarts()) {
            n3 = this.getNMIPStarts() - 1;
        }
        this.CALL(CplexI.CPXdelmipstarts(this._env, this._lp, n, n3));
    }

    public int getNMIPStarts() throws IloException {
        return CplexI.CPXgetnummipstarts(this._env, this._lp);
    }

    public String getMIPStartName(int n) throws IloException {
        int[] nArray = new int[]{0};
        String[] stringArray = CplexI.CPXgetmipstartname(this._env, this._lp, n, n, nArray);
        return stringArray[0];
    }

    public int getMIPStartIndex(String string) throws IloException {
        int[] nArray = new int[]{0};
        this.CALL(CplexI.CPXgetmipstartindex(this._env, this._lp, string, nArray));
        return nArray[0];
    }

    public IloCplex.MIPStartEffort getMIPStart(int n, CplexIndex[] cplexIndexArray, double[] dArray, boolean[] blArray) throws IloException {
        int n2;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        CplexI.CPXgetmipstarts(this._env, this._lp, nArray, null, null, null, null, 0, nArray2, n, n);
        int[] nArray4 = new int[]{0};
        double[] dArray2 = new double[-nArray2[0]];
        int[] nArray5 = new int[-nArray2[0]];
        this.CALL(CplexI.CPXgetmipstarts(this._env, this._lp, nArray, nArray4, nArray5, dArray2, nArray3, nArray5.length, nArray2, n, n));
        int n3 = this.getNcols();
        double[] dArray3 = new double[n3];
        boolean[] blArray2 = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray2[n2] = false;
        }
        for (n2 = 0; n2 < nArray[0]; ++n2) {
            dArray3[nArray5[n2]] = dArray2[n2];
            blArray2[nArray5[n2]] = true;
        }
        for (n2 = 0; n2 < cplexIndexArray.length; ++n2) {
            int n4 = cplexIndexArray[n2].getIndex();
            if (n4 >= 0 && blArray2[n4]) {
                dArray[n2] = dArray3[n4];
                blArray[n2] = true;
                continue;
            }
            dArray[n2] = 0.0;
            blArray[n2] = false;
        }
        switch (nArray3[0]) {
            case 1: {
                return IloCplex.MIPStartEffort.CheckFeas;
            }
            case 2: {
                return IloCplex.MIPStartEffort.SolveFixed;
            }
            case 3: {
                return IloCplex.MIPStartEffort.SolveMIP;
            }
            case 4: {
                return IloCplex.MIPStartEffort.Repair;
            }
        }
        return IloCplex.MIPStartEffort.Auto;
    }

    public IloNumVar[] getMIPStartVars(int n) throws IloException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        CplexI.CPXgetmipstarts(this._env, this._lp, nArray, null, null, null, null, 0, nArray2, n, n);
        int[] nArray3 = new int[]{0};
        double[] dArray = new double[-nArray2[0]];
        int[] nArray4 = new int[-nArray2[0]];
        this.CALL(CplexI.CPXgetmipstarts(this._env, this._lp, nArray, nArray3, nArray4, dArray, null, nArray4.length, nArray2, n, n));
        IloNumVar[] iloNumVarArray = new IloNumVar[nArray4.length];
        for (int i = 0; i < nArray4.length; ++i) {
            iloNumVarArray[i] = (IloNumVar)((Object)this._cols.getObject(nArray4[i]));
        }
        return iloNumVarArray;
    }

    public double[] getMIPStartValues(int n) throws IloException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        CplexI.CPXgetmipstarts(this._env, this._lp, nArray, null, null, null, null, 0, nArray2, n, n);
        int[] nArray3 = new int[]{0};
        double[] dArray = new double[-nArray2[0]];
        int[] nArray4 = new int[-nArray2[0]];
        this.CALL(CplexI.CPXgetmipstarts(this._env, this._lp, nArray, nArray3, nArray4, dArray, null, nArray4.length, nArray2, n, n));
        return dArray;
    }

    public void getRangeSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, CpxRange[] cpxRangeArray, int n, int n2) throws IloException {
        int n3;
        int n4 = this.getNrows();
        double[] dArray5 = dArray == null ? null : new double[n4];
        double[] dArray6 = dArray2 == null ? null : new double[n4];
        double[] dArray7 = dArray3 == null ? null : new double[n4];
        double[] dArray8 = dArray4 == null ? null : new double[n4];
        this._rangesa(0, n4 - 1, dArray5, dArray6, dArray7, dArray8);
        int n5 = n + n2;
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray[n3 - n] = dArray5[cpxRangeArray[n3].getIndexValue()];
            }
        }
        if (dArray2 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray2[n3 - n] = dArray6[cpxRangeArray[n3].getIndexValue()];
            }
        }
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray3[n3 - n] = dArray7[cpxRangeArray[n3].getIndexValue()];
            }
        }
        if (dArray4 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray4[n3 - n] = dArray8[cpxRangeArray[n3].getIndexValue()];
            }
        }
    }

    public void getRHSSA(double[] dArray, double[] dArray2, CpxRange[] cpxRangeArray, int n, int n2) throws IloException {
        int n3;
        int n4 = this.getNrows();
        double[] dArray3 = dArray == null ? null : new double[n4];
        double[] dArray4 = dArray2 == null ? null : new double[n4];
        this._rhssa(0, n4 - 1, dArray3, dArray4);
        int n5 = n + n2;
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray[n3 - n] = dArray3[cpxRangeArray[n3].getIndexValue()];
            }
        }
        if (dArray2 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray2[n3 - n] = dArray4[cpxRangeArray[n3].getIndexValue()];
            }
        }
    }

    public void getBoundSA(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int n3;
        int n4 = this.getNcols();
        double[] dArray5 = dArray == null ? null : new double[n4];
        double[] dArray6 = dArray2 == null ? null : new double[n4];
        double[] dArray7 = dArray3 == null ? null : new double[n4];
        double[] dArray8 = dArray4 == null ? null : new double[n4];
        this._boundsa(0, n4 - 1, dArray5, dArray6, dArray7, dArray8);
        int n5 = n + n2;
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray[n3 - n] = dArray5[cplexIndexArray[n3].getIndex()];
            }
        }
        if (dArray3 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray3[n3 - n] = dArray7[cplexIndexArray[n3].getIndex()];
            }
        }
        if (dArray2 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray2[n3 - n] = dArray6[cplexIndexArray[n3].getIndex()];
            }
        }
        if (dArray4 != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray4[n3 - n] = dArray8[cplexIndexArray[n3].getIndex()];
            }
        }
    }

    public void getObjSA(double[] dArray, double[] dArray2, CplexIndex[] cplexIndexArray, int n, int n2) throws IloException {
        int n3;
        int n4 = this.getNcols();
        double[] dArray3 = dArray == null ? null : new double[n4];
        double[] dArray4 = dArray2 == null ? null : new double[n4];
        this._objsa(0, n4 - 1, dArray3, dArray4);
        int n5 = n + n2;
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray[n3 - n] = dArray3[cplexIndexArray[n3].getIndex()];
            }
        }
        if (dArray != null) {
            for (n3 = n; n3 < n5; ++n3) {
                dArray2[n3 - n] = dArray4[cplexIndexArray[n3].getIndex()];
            }
        }
    }

    boolean isSoln() {
        int n = CplexI.CPXgetstat(this._env, this._lp);
        return n == 1 || n == 5 || n == 6 || n == 23 || n == 127 || n == 15 || n == 14 || n == 17 || n == 16 || n == 19 || n == 18 || n == 12 || n == 101 || n == 102 || n == 115 || n == 105 || n == 107 || n == 109 || n == 111 || n == 113 || n == 126 || n == 121 || n == 120 || n == 123 || n == 122 || n == 125 || n == 124 || n == 116;
    }

    public boolean feasOpt(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        IntArray intArray = new IntArray();
        IntArray intArray2 = new IntArray();
        ByteArray byteArray = new ByteArray();
        for (int i = 0; i < iloConstraintArray.length; ++i) {
            int n = i;
            if (iloConstraintArray[n] == null) continue;
            intArray.add(intArray2.getSize());
            this.fillGroup(iloConstraintArray[n], intArray2, byteArray);
        }
        this.invalidate();
        this.initCallbacks();
        this._solving = true;
        int n = CplexI.CPXfeasoptext(this.getEnv(), this.getLP(), intArray.getSize(), intArray2.getSize(), dArray, intArray.getArray(), intArray2.getArray(), byteArray.getArray());
        this._solving = false;
        this.finitCallbacks();
        this.fillXcache();
        this.setStatus(n);
        this.checkCallbacks();
        return this.isSoln();
    }

    boolean feasOpt(IloRange[] iloRangeArray, double[] dArray, double[] dArray2, IloNumVar[] iloNumVarArray, double[] dArray3, double[] dArray4) throws IloException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getNrows();
        int n6 = this.getNcols();
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = null;
        byte[] byArray = null;
        int n7 = 0;
        int[] nArray = null;
        byte[] byArray2 = null;
        double[] dArray10 = null;
        if (iloRangeArray != null && (n4 = iloRangeArray.length) > 0 && (dArray != null || dArray2 != null)) {
            nArray = new int[n5 + 1];
            byArray2 = new byte[n5 + 1];
            dArray10 = new double[n5 + 1];
            byArray = new byte[n5 + 1];
            this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray, 0, n5 - 1));
            dArray5 = new double[n5];
            if (dArray != null) {
                for (n3 = 0; n3 < n4; ++n3) {
                    if (iloRangeArray[n3] == null) continue;
                    n2 = ((CpxRange)iloRangeArray[n3]).getIndexValue();
                    if (((CpxRange)iloRangeArray[n3]).isQC()) {
                        byte[] byArray3 = new byte[]{0};
                        int[] nArray2 = new int[]{0};
                        CplexI.CPXgetqconstr(this._env, this._lp, null, null, null, byArray3, null, null, 0, nArray2, null, null, null, 0, nArray2, n2);
                        if (dArray9 == null) {
                            dArray9 = new double[this._getNQCs()];
                        }
                        if (byArray3[0] == 76) {
                            dArray9[n2] = dArray2[n3];
                            continue;
                        }
                        dArray9[n2] = dArray[n3];
                        continue;
                    }
                    if (byArray[n2] == 76) continue;
                    if (byArray[n2] == 69) {
                        byArray[n2] = 82;
                        nArray[n7] = n2;
                        byArray2[n7] = 82;
                        dArray10[n7] = 0.0;
                        ++n7;
                    }
                    dArray5[n2] = dArray[n3];
                }
            }
            if (dArray2 != null) {
                for (n3 = 0; n3 < n4; ++n3) {
                    if (((CpxRange)iloRangeArray[n3]).isQC() || byArray[n2 = ((CpxRange)iloRangeArray[n3]).getIndexValue()] == 71) continue;
                    if (byArray[n2] == 76) {
                        dArray5[n2] = dArray2[n3];
                        continue;
                    }
                    if (byArray[n2] == 69) {
                        byArray[n2] = 82;
                        nArray[n7] = n2;
                        byArray2[n7] = 82;
                        dArray10[n7] = 0.0;
                        ++n7;
                    }
                    if (dArray6 == null) {
                        dArray6 = new double[n5];
                    }
                    dArray6[n2] = dArray2[n3];
                }
            }
            if (n7 > 0) {
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, n7, nArray, byArray2));
                this.CALL(CplexI.CPXchgrngval(this._env, this._lp, n7, nArray, dArray10));
            }
        }
        if (iloNumVarArray != null && (n = iloNumVarArray.length) > 0) {
            if (dArray3 != null) {
                dArray7 = new double[n6];
                for (n3 = 0; n3 < n; ++n3) {
                    n2 = ((CpxNumVar)iloNumVarArray[n3]).getVarIndexValue();
                    dArray7[n2] = dArray3[n3];
                }
            }
            if (dArray4 != null) {
                dArray8 = new double[n6];
                for (n3 = 0; n3 < n; ++n3) {
                    n2 = ((CpxNumVar)iloNumVarArray[n3]).getVarIndexValue();
                    dArray8[n2] = dArray4[n3];
                }
            }
        }
        this.invalidate();
        this.initCallbacks();
        this._solving = true;
        n3 = CplexI.CPXEfeasopt(this._env, this._lp, dArray5, dArray6, dArray7, dArray8, dArray9);
        this._solving = false;
        this.finitCallbacks();
        this.fillXcache();
        this.setStatus(n3);
        this.checkCallbacks();
        return this.isSoln();
    }

    void getIIS(IloCplex.IIS.Status[][] statusArray, IloNumVar[][] iloNumVarArray, IloCplex.IIS.Status[][] statusArray2, IloConstraint[][] iloConstraintArray) throws IloException {
        int n;
        int[] nArray = new int[2];
        this._getIISsize(nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        this._getIIS(nArray4, nArray5, nArray2, nArray3);
        IloCplex.IIS.Status[] statusArray3 = new IloCplex.IIS.Status[]{IloCplex.IIS.Status.AtLower, IloCplex.IIS.Status.Fixed, IloCplex.IIS.Status.AtUpper};
        iloNumVarArray[0] = new CpxNumVar[n3];
        iloConstraintArray[0] = new CpxRange[n2];
        statusArray[0] = new IloCplex.IIS.Status[n3];
        statusArray2[0] = new IloCplex.IIS.Status[n2];
        for (n = 0; n < n3; ++n) {
            iloNumVarArray[0][n] = (CpxNumVar)this._cols.getObject(nArray2[n]);
            statusArray[0][n] = statusArray3[nArray3[n]];
        }
        for (n = 0; n < n2; ++n) {
            iloConstraintArray[0][n] = (CpxRange)this._rows.getObject(nArray4[n]);
            statusArray2[0][n] = statusArray3[nArray5[n]];
        }
    }

    private void fillElement(Object object, IntArray intArray, ByteArray byteArray) throws IloException {
        if (object instanceof CpxRange) {
            int n = ((CpxRange)object).getIndexValue();
            if (n >= 0) {
                intArray.add(n);
                if (((CpxRange)object).isQC()) {
                    byteArray.add((byte)4);
                } else {
                    byteArray.add((byte)3);
                }
            }
        } else if (object instanceof CpxNumVarBound) {
            int n = ((CpxNumVarBound)object).getCpxVar().getVarIndexValue();
            if (n >= 0) {
                intArray.add(n);
                byteArray.add((byte)((CpxNumVarBound)object).getCpxType());
            }
        } else if (object instanceof CpxSOS) {
            int n = ((CpxSOS)object).getIndexValue();
            if (n >= 0) {
                intArray.add(n);
                byteArray.add((byte)5);
            }
        } else if (object instanceof CpxGC) {
            if (((CpxGC)object).getGCIndex() != null) {
                intArray.add(((CpxGC)object).getGCIndex().getValue());
                byteArray.add((byte)((CpxGC)object).getGCExtractedType());
            }
        } else if (object instanceof CpxLPMatrix) {
            CpxLPMatrix cpxLPMatrix = (CpxLPMatrix)object;
            int n = cpxLPMatrix.getNrows();
            for (int i = 0; i < n; ++i) {
                this.fillElement(cpxLPMatrix._row[i], intArray, byteArray);
            }
        }
    }

    private void fillGroup(Object object, IntArray intArray, ByteArray byteArray) throws IloException {
        if (object instanceof CpxAnd && ((CpxAnd)object).getCplexI() != this) {
            Iterator iterator = ((CpxAnd)object).iterator();
            while (iterator.hasNext()) {
                this.fillGroup((CpxExtractable)iterator.next(), intArray, byteArray);
            }
        } else {
            this.fillElement(object, intArray, byteArray);
        }
    }

    boolean refineConflict(IloConstraint[] iloConstraintArray, double[] dArray, int n, int n2) throws IloException {
        IntArray intArray = new IntArray();
        IntArray intArray2 = new IntArray();
        DoubleArray doubleArray = new DoubleArray();
        ByteArray byteArray = new ByteArray();
        this._grpMap = new HashMap();
        for (int i = 0; i < n2; ++i) {
            int n3 = i + n;
            if (iloConstraintArray[n3] == null || this._grpMap.containsKey(iloConstraintArray[n3])) continue;
            intArray.add(intArray2.getSize());
            doubleArray.add(dArray[n3]);
            this.fillGroup(iloConstraintArray[n3], intArray2, byteArray);
            this._grpMap.put(iloConstraintArray[n3], new Integer(intArray.getSize() - 1));
        }
        this.invalidate();
        this.initCallbacks();
        this._solving = true;
        int n4 = CplexI.CPXrefineconflictext(this.getEnv(), this.getLP(), intArray.getSize(), intArray2.getSize(), doubleArray.getArray(), intArray.getArray(), intArray2.getArray(), byteArray.getArray());
        this._solving = false;
        this.finitCallbacks();
        this.setStatus(n4);
        this.checkCallbacks();
        return CplexI.CPXgetstat(this.getEnv(), this.getLP()) != 30;
    }

    boolean refineConflict(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        if (iloConstraintArray.length != dArray.length) {
            throw new IloException("IloCplex.refineConflict : contraint and preference arrays must have the same size.");
        }
        return this.refineConflict(iloConstraintArray, dArray, 0, iloConstraintArray.length);
    }

    boolean refineMIPStartConflict(int n, IloConstraint[] iloConstraintArray, double[] dArray, int n2, int n3) throws IloException {
        IntArray intArray = new IntArray();
        IntArray intArray2 = new IntArray();
        DoubleArray doubleArray = new DoubleArray();
        ByteArray byteArray = new ByteArray();
        this._grpMap = new HashMap();
        for (int i = 0; i < n3; ++i) {
            int n4 = i + n2;
            if (iloConstraintArray[n4] == null || this._grpMap.containsKey(iloConstraintArray[n4])) continue;
            intArray.add(intArray2.getSize());
            doubleArray.add(dArray[n4]);
            this.fillGroup(iloConstraintArray[n4], intArray2, byteArray);
            this._grpMap.put(iloConstraintArray[n4], new Integer(intArray.getSize() - 1));
        }
        this.invalidate();
        this.initCallbacks();
        this._solving = true;
        int n5 = CplexI.CPXrefinemipstartconflictext(this.getEnv(), this.getLP(), n, intArray.getSize(), intArray2.getSize(), doubleArray.getArray(), intArray.getArray(), intArray2.getArray(), byteArray.getArray());
        this._solving = false;
        this.CALL(n5);
        this.setStatus(0);
        this.checkCallbacks();
        return CplexI.CPXgetstat(this.getEnv(), this.getLP()) != 30;
    }

    IloCplex.ConflictStatus[] getConflict(IloConstraint[] iloConstraintArray, int n, int n2) throws IloException {
        this.CALL(CplexI.CPXgetconflict(this.getEnv(), this.getLP(), null, null, null, null, null, null, null));
        IloCplex.ConflictStatus[] conflictStatusArray = new IloCplex.ConflictStatus[n2];
        int n3 = n + n2;
        int[] nArray = new int[]{0};
        for (int i = n; i < n3; ++i) {
            int n4 = (Integer)this._grpMap.get(iloConstraintArray[i]);
            this.CALL(CplexI.CPXgetconflictext(this.getEnv(), this.getLP(), nArray, n4, n4));
            conflictStatusArray[i - n] = IloCplex.ConflictStatus.make(nArray[0]);
        }
        return conflictStatusArray;
    }

    CpxLinearNumExpr getRay() throws IloException {
        int n = this.getNcols();
        double[] dArray = new double[n];
        this._getRay(dArray);
        CpxLinearNumExpr cpxLinearNumExpr = new CpxLinearNumExpr(null, null, 0, 0, 0.0);
        cpxLinearNumExpr.makeSpace(n);
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == 0.0) continue;
            cpxLinearNumExpr.addTerm(dArray[i], (IloNumVar)((Object)this._cols.getObject(i)));
        }
        return cpxLinearNumExpr;
    }

    IloCopyable getDiverging() throws IloException {
        int[] nArray = new int[]{-1};
        int[] nArray2 = new int[]{-1};
        this.CALL(CplexI.CPXgetijdiv(this._env, this._lp, nArray, nArray2));
        if (nArray2[0] >= 0) {
            return this._cols.getObject(nArray2[0]);
        }
        if (nArray[0] >= 0) {
            return this._rows.getObject(nArray[0]);
        }
        return null;
    }

    double dualFarkas(IloConstraint[] iloConstraintArray, double[] dArray) throws IloException {
        int n = this.getNrows();
        if (dArray == null) {
            dArray = new double[n];
        }
        double[] dArray2 = new double[1];
        this._dualFarkas(dArray, dArray2);
        if (iloConstraintArray != null) {
            for (int i = 0; i < n; ++i) {
                iloConstraintArray[i] = (IloConstraint)((Object)this._rows.getObject(i));
            }
        }
        return dArray2[0];
    }

    void qpIndefCertificate(IloNumVar[] iloNumVarArray, double[] dArray) throws IloException {
        this._qpIndefCertificate(dArray);
        int n = this.getNcols();
        for (int i = 0; i < n; ++i) {
            iloNumVarArray[i] = (IloNumVar)((Object)this._cols.getObject(i));
        }
    }

    public IloCplex.Quality getQuality(int n, int n2) throws IloException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        double[] dArray = new double[1];
        IloCplex.Quality quality = new IloCplex.Quality();
        this._getQuality(n, nArray, nArray2, nArray3, dArray, n2);
        quality.var = null;
        quality.rng = null;
        if (nArray2[0] >= 0) {
            quality.rng = (CpxRange)this._rows.getObject(nArray2[0]);
        } else if (nArray3[0] >= 0) {
            quality.rng = (CpxRange)this._qcs.getObject(nArray3[0]);
        } else if (nArray[0] >= 0) {
            quality.var = (CpxNumVar)this._cols.getObject(nArray[0]);
        }
        quality.value = dArray[0];
        return quality;
    }

    final void setPriority(CplexIndex cplexIndex, int n) {
        this._ord.setPriority(cplexIndex, n);
    }

    final void setPriorities(CplexIndex[] cplexIndexArray, int[] nArray, int n, int n2) {
        this._ord.setPriorities(cplexIndexArray, nArray, n, n2);
    }

    final void setDirection(CplexIndex cplexIndex, int n) {
        this._ord.setDirection(cplexIndex, n);
    }

    final void setDirections(CplexIndex[] cplexIndexArray, int[] nArray, int n, int n2) {
        this._ord.setDirections(cplexIndexArray, nArray, n, n2);
    }

    final int getPriority(CplexIndex cplexIndex) {
        return this._ord.getPriority(cplexIndex);
    }

    final int getDirection(CplexIndex cplexIndex) {
        return this._ord.getDirection(cplexIndex);
    }

    final void getPriorities(int[] nArray, CplexIndex[] cplexIndexArray, int n, int n2) {
        this._ord.getPriorities(cplexIndexArray, nArray, n, n2);
    }

    final void getDirections(int[] nArray, CplexIndex[] cplexIndexArray, int n, int n2) {
        this._ord.getDirections(cplexIndexArray, nArray, n, n2);
    }

    public void copyOrder(int[] nArray, int[] nArray2, int[] nArray3) throws IloException {
        this._copyOrder(nArray, nArray2, nArray3);
    }

    void writeOrder(String string) throws IloException {
        this._ord.install(this);
        this.installNames(this);
        this._writeOrder(string);
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    void writeConflict(String string) throws IloException {
        this._ord.install(this);
        this.installNames(this);
        this._writeConflict(string);
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    void writeParam(String string) throws IloException {
        this.CALL(CplexI.CPXEwriteparam(this._env, string));
    }

    void writeBasis(String string) throws IloException {
        this.CALL(CplexI.CPXmbasewrite(this._env, this._lp, string));
    }

    void writeVectors(String string) throws IloException {
        this.installNames(this);
        this.CALL(CplexI.CPXvecwrite(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    void writeSolution(String string, int n) throws IloException {
        this.CALL(CplexI.CPXsolwritesolnpool(this._env, this._lp, n, string));
    }

    void writeSolutions(String string) throws IloException {
        this.CALL(CplexI.CPXsolwritesolnpoolall(this._env, this._lp, string));
    }

    void writeTextSolution(String string) throws IloException {
        this.CALL(CplexI.CPXtxtsolwrite(this._env, this._lp, string));
    }

    void writeMIPStart(String string, int n) throws IloException {
        this.installNames(this);
        this.CALL(CplexI.CPXwritemipstarts(this._env, this._lp, string, n, n));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    void writeMIPStarts(String string, int n, int n2) throws IloException {
        int n3 = n + n2 - 1;
        int n4 = this.getNMIPStarts();
        if (n3 >= n4) {
            n3 = n4 - 1;
        }
        this.CALL(CplexI.CPXwritemipstarts(this._env, this._lp, string, n, n3));
    }

    void readOrder(String string) throws IloException {
        this.installNames(this);
        this.CALL(CplexI.CPXreadcopyorder(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
        this._ord.read(this);
    }

    void readParam(String string) throws IloException {
        this.CALL(CplexI.CPXreadcopyparam(this._env, string));
    }

    void readBasis(String string) throws IloException {
        this.installNames(this);
        this.CALL(CplexI.CPXreadcopybase(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    void readSolution(String string) throws IloException {
        this.installNames(this);
        this.CALL(CplexI.CPXreadcopysol(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    void readVectors(String string) throws IloException {
        this.installNames(this);
        this.CALL(CplexI.CPXreadcopyvec(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    void readMIPStart(String string) throws IloException {
        this.installNames(this);
        this.CALL(CplexI.CPXreadcopymipstart(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    void readMIPStarts(String string) throws IloException {
        this.installNames(this);
        this.CALL(CplexI.CPXreadcopymipstarts(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void solve(IloCplex iloCplex, IloCplex.Goal goal) throws IloException {
        block13: {
            int n = CplexI.CPXEgetmaxthreads(this._env);
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            CpxCallback cpxCallback = null;
            CpxCallback cpxCallback2 = null;
            CpxCallback cpxCallback3 = null;
            CpxCallback cpxCallback4 = null;
            if (goal != null) {
                this._globalCuts = new ArrayList[n];
                for (int i = 0; i < this._globalCuts.length; ++i) {
                    this._globalCuts[i] = new ArrayList();
                }
                this.initGoals(nArray, nArray2);
                cpxCallback = this._cb[11];
                cpxCallback2 = this._cb[13];
                cpxCallback3 = this._cb[15];
                cpxCallback4 = this._cb[12];
                iloCplex.use(new CpxGoalBranchCallback(this));
                iloCplex.use(new CpxGoalNodeCallback(this));
                iloCplex.use(new CpxGoalIncumbentCallback(this, this.getDoubleParam(1016)));
                iloCplex.use(new CpxGoalLazyConstraintCallback(this));
                this._rootNode = new CpxNode(iloCplex, 1.0E20);
                this._rootNode._nId = new IloCplex.NodeId(0);
                this._rootNode.addGoalStack(goal);
            }
            try {
                this._rootGoal = goal;
                this.solve();
                this._rootGoal = null;
                Object var12_11 = null;
                if (goal == null) break block13;
                this._globalCuts = null;
                this._rootNode = null;
                this._cb[11] = null;
                this._cb[13] = null;
                this._cb[15] = null;
                this._cb[12] = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (goal != null) {
                    this._globalCuts = null;
                    this._rootNode = null;
                    this._cb[11] = null;
                    this._cb[13] = null;
                    this._cb[15] = null;
                    this._cb[12] = null;
                    CplexI.CPXsetbranchcallbackfunc(this.getEnv(), null, null);
                    CplexI.CPXsetincumbentcallbackfunc(this.getEnv(), null, null);
                    CplexI.CPXsetnodecallbackfunc(this.getEnv(), null, null);
                    CplexI.CPXsetcutcallbackfunc(this.getEnv(), null, null);
                    if (cpxCallback != null) {
                        this.setCallback(cpxCallback);
                    }
                    if (cpxCallback2 != null) {
                        this.setCallback(cpxCallback2);
                    }
                    if (cpxCallback3 != null) {
                        this.setCallback(cpxCallback3);
                    }
                    if (cpxCallback4 != null) {
                        this.setCallback(cpxCallback4);
                    }
                    this.finitGoals(nArray[0], nArray2[0]);
                }
                throw throwable;
            }
            CplexI.CPXsetbranchcallbackfunc(this.getEnv(), null, null);
            CplexI.CPXsetincumbentcallbackfunc(this.getEnv(), null, null);
            CplexI.CPXsetnodecallbackfunc(this.getEnv(), null, null);
            CplexI.CPXsetcutcallbackfunc(this.getEnv(), null, null);
            if (cpxCallback != null) {
                this.setCallback(cpxCallback);
            }
            if (cpxCallback2 != null) {
                this.setCallback(cpxCallback2);
            }
            if (cpxCallback3 != null) {
                this.setCallback(cpxCallback3);
            }
            if (cpxCallback4 != null) {
                this.setCallback(cpxCallback4);
            }
            this.finitGoals(nArray[0], nArray2[0]);
            {
            }
        }
    }

    public final IloCplex.Goal failGoal() {
        return new CpxFailGoal();
    }

    final CpxNode getRootNode() {
        return this._rootNode;
    }

    final void setRootNode(CpxNode cpxNode) {
        this._rootNode = cpxNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGlobalCuts(ArrayList arrayList, int n) {
        ArrayList arrayList2 = this._globalCuts[n];
        synchronized (arrayList2) {
            this._globalCuts[n].addAll(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postGlobalCuts(CpxGoalLazyConstraintCallback cpxGoalLazyConstraintCallback) throws IloException {
        for (int i = 0; i < this._globalCuts.length; ++i) {
            ArrayList arrayList = this._globalCuts[i];
            synchronized (arrayList) {
                for (int j = 0; j < this._globalCuts[i].size(); ++j) {
                    cpxGoalLazyConstraintCallback.addGlobalCut((IloRange)this._globalCuts[i].get(j));
                }
                this._globalCuts[i].clear();
                continue;
            }
        }
    }

    public final boolean useDefaultSearch() {
        return !this._usesEval;
    }

    public final void setDefaultSearch(boolean bl) {
        this._usesEval = !bl;
    }

    final void CALL(int n) throws IloException {
        if (n == 1002) {
            throw new IloCplex.CplexEndedException();
        }
        if (n != 0) {
            throw new CpxException(n, this._getErrorMessage(n));
        }
    }

    final void disableOutput() throws IloException {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        long[] lArray4 = new long[1];
        CplexI.CleanChannels(this._env);
        this.CALL(CplexI.CPXgetchannels(this._env, lArray3, lArray2, lArray, lArray4));
        CplexI.CPXdisconnectchannel(this._env, lArray[0]);
        CplexI.CPXdisconnectchannel(this._env, lArray2[0]);
        CplexI.CPXdisconnectchannel(this._env, lArray3[0]);
        CplexI.CPXdisconnectchannel(this._env, lArray4[0]);
    }

    final void enableOutput() throws IloException {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        long[] lArray4 = new long[1];
        this.CALL(CplexI.CPXgetchannels(this._env, lArray3, lArray2, lArray, lArray4));
        this.CALL(CplexI.CPXaddfuncdest(this._env, lArray[0], this, new ErrorChannelFunction()));
        this.CALL(CplexI.CPXaddfuncdest(this._env, lArray2[0], this, new WarnChannelFunction()));
        this.CALL(CplexI.CPXaddfuncdest(this._env, lArray3[0], this, new OutChannelFunction()));
        this.CALL(CplexI.CPXaddfuncdest(this._env, lArray4[0], this, new OutChannelFunction()));
    }

    public final int getNNZs() {
        return CplexI.CPXgetnumnz(this._env, this._lp);
    }

    public final int getNNZs(int[] nArray) {
        return CplexI.CPXEgetnumrownz(this._env, this._lp, nArray);
    }

    public final int getNintVars() {
        return CplexI.CPXgetnumint(this._env, this._lp);
    }

    public final int getNbinVars() {
        return CplexI.CPXgetnumbin(this._env, this._lp);
    }

    public final int getNsemiContVars() {
        return CplexI.CPXgetnumsemicont(this._env, this._lp);
    }

    public final int getNsemiIntVars() {
        return CplexI.CPXgetnumsemiint(this._env, this._lp);
    }

    public final int getNiterations() {
        if (this.isMIP()) {
            return CplexI.CPXgetmipitcnt(this._env, this._lp);
        }
        int n = CplexI.CPXgetsiftitcnt(this._env, this._lp);
        if (n > 0) {
            return n;
        }
        n = CplexI.CPXgetbaritcnt(this._env, this._lp);
        if (n > 0) {
            return n;
        }
        return CplexI.CPXgetitcnt(this._env, this._lp);
    }

    public final int getNbarrierIterations() {
        return CplexI.CPXgetbaritcnt(this._env, this._lp);
    }

    public final int getNsiftingIterations() {
        return CplexI.CPXgetsiftitcnt(this._env, this._lp);
    }

    public final int getNsiftingPhaseOneIterations() {
        return CplexI.CPXgetsiftphase1cnt(this._env, this._lp);
    }

    public final int getNphaseOneIterations() {
        return CplexI.CPXgetphase1cnt(this._env, this._lp);
    }

    public final int getNcrossDExch() {
        return CplexI.CPXgetcrossdexchcnt(this._env, this._lp);
    }

    public final int getNcrossDPush() {
        return CplexI.CPXgetcrossdpushcnt(this._env, this._lp);
    }

    public final int getNcrossPExch() {
        return CplexI.CPXgetcrosspexchcnt(this._env, this._lp);
    }

    public final int getNcrossPPush() {
        return CplexI.CPXgetcrossppushcnt(this._env, this._lp);
    }

    public final int getNdualSuperbasics() {
        return CplexI.CPXgetdsbcnt(this._env, this._lp);
    }

    public final int getNprimalSuperbasics() {
        return CplexI.CPXgetpsbcnt(this._env, this._lp);
    }

    public final int getNnodes() {
        return CplexI.CPXgetnodecnt(this._env, this._lp);
    }

    public final int getNnodesLeft() {
        return CplexI.CPXgetnodeleftcnt(this._env, this._lp);
    }

    public final int getNcuts(int n) throws IloException {
        int[] nArray = new int[1];
        this.CALL(CplexI.CPXgetnumcuts(this._env, this._lp, n, nArray));
        return nArray[0];
    }

    public final int getIncumbentNode() {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            return CplexI.CPXgetnodeint(this._env, this._lp);
        }
        return 0;
    }

    public final int getCplexStatus() {
        return this._status;
    }

    public final int getCplexSubStatus() {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            return CplexI.CPXgetsubstat(this._env, this._lp);
        }
        return 0;
    }

    public final int getMethod() {
        return CplexI.CPXgetmethod(this._env, this._lp);
    }

    public final int getSubMethod() {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            return CplexI.CPXgetsubmethod(this._env, this._lp);
        }
        return -1;
    }

    public final void setSense(int n) throws IloException {
        this.invalidate();
        CplexI.CPXchgobjsen(this._env, this._lp, n);
    }

    public final void _setIntParam(int n, int n2) throws IloException {
        this.CALL(CplexI.CPXsetintparam(this._env, n, n2));
    }

    public final void _getIntParam(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXgetintparam(this._env, n, nArray));
    }

    public final void _minIntParam(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXinfointparam(this._env, n, null, nArray, null));
    }

    public final void _maxIntParam(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXinfointparam(this._env, n, null, null, nArray));
    }

    public final void _defIntParam(int n, int[] nArray) throws IloException {
        this.CALL(CplexI.CPXinfointparam(this._env, n, nArray, null, null));
    }

    public final void _setDoubleParam(int n, double d) throws IloException {
        this.CALL(CplexI.CPXsetdblparam(this._env, n, d));
    }

    public final void _getDoubleParam(int n, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetdblparam(this._env, n, dArray));
    }

    public final void _minDoubleParam(int n, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXinfodblparam(this._env, n, null, dArray, null));
    }

    public final void _maxDoubleParam(int n, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXinfodblparam(this._env, n, null, null, dArray));
    }

    public final void _defDoubleParam(int n, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXinfodblparam(this._env, n, dArray, null, null));
    }

    public final void _setStringParam(int n, String string) throws IloException {
        this.CALL(CplexI.CPXsetstrparam(this._env, n, string));
    }

    public final void _getStringParam(int n, String[] stringArray) throws IloException {
        this.CALL(CplexI.CPXgetstrparam(this._env, n, stringArray));
    }

    public final void _defStringParam(int n, String[] stringArray) throws IloException {
        this.CALL(CplexI.CPXinfostrparam(this._env, n, stringArray));
    }

    public final void setDefaults() throws IloException {
        this.CALL(CplexI.CPXsetdefaults(this._env));
    }

    public final String getVersion() {
        return CplexI.CPXversion(this._env);
    }

    final String _getErrorMessage(int n) {
        if (this._error != null) {
            return this._error;
        }
        return CplexI.CPXgeterrorstring(this.getEnv(), n);
    }

    final void _readModel(String string) throws IloException {
        this.invalidate();
        this.CALL(CplexI.CPXreadcopyprob(this._env, this._lp, string, null));
        int n = CplexI.CPXgetnumrows(this._env, this._lp);
        byte[] byArray = new byte[n];
        this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray, 0, n - 1));
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != 82) continue;
            int[] nArray = new int[n];
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            byte[] byArray2 = new byte[]{76};
            byte[] byArray3 = new byte[]{71};
            int[] nArray2 = new int[]{0};
            this.CALL(CplexI.CPXgetrngval(this._env, this._lp, dArray, 0, n - 1));
            this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray2, 0, n - 1));
            int n2 = 0;
            while (i < n) {
                if (byArray[i] == 82) {
                    nArray2[0] = i;
                    if (dArray[i] <= -1.0E20) {
                        this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray2, byArray2));
                    } else if (dArray[i] >= 1.0E20) {
                        this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray2, byArray3));
                    } else if (dArray[i] < 0.0) {
                        nArray[n2] = i;
                        dArray2[n2] = dArray2[i] + dArray[i];
                        dArray[n2] = -dArray[i];
                        ++n2;
                    }
                }
                ++i;
            }
            if (n2 <= 0) continue;
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, n2, nArray, dArray2));
            this.CALL(CplexI.CPXchgrngval(this._env, this._lp, n2, nArray, dArray));
        }
    }

    final void _writeModel(String string) throws IloException {
        this.CALL(CplexI.CPXwriteprob(this._env, this._lp, string, null));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    final void _clearModel() throws IloException {
        this.invalidate();
        long[] lArray = new long[]{this._lp};
        this.CALL(CplexI.CPXfreeprob(this._env, lArray));
        this._lp = 0L;
        int[] nArray = new int[1];
        String string = this.probName();
        this._lp = CplexI.CPXcreateprob(this._env, nArray, string);
        this.CALL(nArray[0]);
    }

    final int _getSense() {
        return CplexI.CPXgetobjsen(this._env, this._lp);
    }

    final int _getNcols() {
        return CplexI.CPXgetnumcols(this._env, this._lp);
    }

    final int _getNinds() {
        return CplexI.CPXgetnumindconstrs(this._env, this._lp);
    }

    final int _getNrows() {
        return CplexI.CPXgetnumrows(this._env, this._lp);
    }

    final int _getNQCs() {
        return CplexI.CPXgetnumqconstrs(this._env, this._lp);
    }

    final int _getNSOSs() {
        return CplexI.CPXgetnumsos(this._env, this._lp);
    }

    private final void origProbType() throws IloException {
        switch (CplexI.CPXgetprobtype(this._env, this._lp)) {
            case 3: {
                this._status = 0;
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
                break;
            }
            case 8: {
                this._status = 0;
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
                break;
            }
        }
    }

    private final void checkStillMIP() throws IloException {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 3 || n == 8 || n == 11 || n == 7 || n == 1) {
            if (CplexI.CPXgetnumint(this._env, this._lp) > 0) {
                return;
            }
            if (CplexI.CPXgetnumbin(this._env, this._lp) > 0) {
                return;
            }
            if (CplexI.CPXgetnumsos(this._env, this._lp) > 0) {
                return;
            }
            if (CplexI.CPXgetnumsemicont(this._env, this._lp) > 0) {
                return;
            }
            if (CplexI.CPXgetnumsemiint(this._env, this._lp) > 0) {
                return;
            }
            for (int i = 5; i < 27; ++i) {
                if (CplexI.CPXEgetnumgconstrs(this._env, this._lp, i) <= 0) continue;
                return;
            }
            if (n == 11) {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 10));
            } else if (n == 7 || n == 8) {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 5));
            } else {
                this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 0));
            }
        }
    }

    final void _addRows(int n, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, double[] dArray3) throws IloException {
        byte[] byArray = new byte[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        int[] nArray3 = new int[n];
        int n2 = CplexI.CPXgetnumrows(this._env, this._lp);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (dArray2[i] >= 1.0E20) {
                byArray[i] = 71;
                dArray4[i] = dArray[i];
                continue;
            }
            if (dArray[i] <= -1.0E20) {
                byArray[i] = 76;
                dArray4[i] = dArray2[i];
                continue;
            }
            if (dArray[i] == dArray2[i]) {
                byArray[i] = 69;
                dArray4[i] = dArray2[i];
                continue;
            }
            byArray[i] = 82;
            dArray4[i] = dArray[i];
            dArray5[n3] = dArray2[i] - dArray[i];
            nArray3[n3] = i + n2;
            ++n3;
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXaddrows(this._env, this._lp, 0, n, nArray[n], dArray4, byArray, nArray, nArray2, dArray3, null, null));
        if (n3 > 0) {
            this.CALL(CplexI.CPXchgrngval(this._env, this._lp, n3, nArray3, dArray5));
        }
    }

    final void _delQCs(int n, int n2) throws IloException {
        this.origProbType();
        this.invalidate();
        if (n > n2) {
            return;
        }
        this.CALL(CplexI.CPXdelqconstrs(this._env, this._lp, n, n2));
        this.checkStillMIP();
    }

    final void _delRows(int n, int n2) throws IloException {
        this.origProbType();
        this.invalidate();
        if (n > n2) {
            return;
        }
        if (this._fixBasis && CplexI.CPXEcangetbase(this._env, this._lp) != 0) {
            int n3 = n2 - n + 1;
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = n + i;
            }
            this.CALL(CplexI.CPXpivotin(this._env, this._lp, nArray, n3));
        }
        this.CALL(CplexI.CPXdelrows(this._env, this._lp, n, n2));
        this.checkStillMIP();
    }

    final void _delRows(int[] nArray) throws IloException {
        this.origProbType();
        this.invalidate();
        if (this._fixBasis && CplexI.CPXEcangetbase(this._env, this._lp) != 0) {
            int n = CplexI.CPXgetnumrows(this._env, this._lp);
            int n2 = 0;
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == 0) continue;
                nArray2[n2++] = i;
            }
            this.CALL(CplexI.CPXpivotin(this._env, this._lp, nArray2, n2));
        }
        this.CALL(CplexI.CPXdelsetrows(this._env, this._lp, nArray));
        this.checkStillMIP();
    }

    final void _newColumns(int n, double[] dArray, double[] dArray2, byte[] byArray) throws IloException {
        int n2;
        this.origProbType();
        this.invalidate();
        boolean bl = false;
        for (n2 = 0; n2 < n; ++n2) {
            if (byArray[n2] == 67) continue;
            bl = true;
            break;
        }
        if (bl) {
            n2 = CplexI.CPXgetprobtype(this._env, this._lp);
            if (n2 != 1 && n2 != 7 && n2 != 11) {
                if (n2 == 5) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
                } else if (n2 == 10) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 11));
                } else if (n2 != 1) {
                    this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
                }
            }
            int n3 = CplexI.CPXgetnumcols(this._env, this._lp);
            int[] nArray = new int[n];
            int n4 = n3 - n;
            for (int i = 0; i < n; ++i) {
                nArray[i] = n4++;
            }
            this.CALL(CplexI.CPXnewcols(this._env, this._lp, n, null, dArray, dArray2, byArray, null));
        } else {
            this.CALL(CplexI.CPXnewcols(this._env, this._lp, n, null, dArray, dArray2, null, null));
        }
    }

    final void _delColumns(int n, int n2) throws IloException {
        this.origProbType();
        this.invalidate();
        if (n > n2) {
            return;
        }
        if (this._fixBasis && CplexI.CPXEcangetbase(this._env, this._lp) != 0) {
            int n3 = n2 - n + 1;
            int[] nArray = new int[n3];
            double[] dArray = new double[n3];
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = n + i;
                byArray[i] = 66;
            }
            this.CALL(CplexI.CPXchgbds(this._env, this._lp, n3, nArray, byArray, dArray));
            this.CALL(CplexI.CPXpivotout(this._env, this._lp, nArray, n3));
        }
        this.CALL(CplexI.CPXdelcols(this._env, this._lp, n, n2));
        this.checkStillMIP();
    }

    final void _delColumns(int[] nArray) throws IloException {
        this.origProbType();
        this.invalidate();
        if (this._fixBasis && CplexI.CPXEcangetbase(this._env, this._lp) != 0) {
            int n = CplexI.CPXgetnumcols(this._env, this._lp);
            int[] nArray2 = new int[n];
            double[] dArray = new double[n];
            byte[] byArray = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == 0) continue;
                byArray[n2] = 66;
                nArray2[n2++] = i;
            }
            this.CALL(CplexI.CPXchgbds(this._env, this._lp, n2, nArray2, byArray, dArray));
            this.CALL(CplexI.CPXpivotout(this._env, this._lp, nArray2, n2));
        }
        this.CALL(CplexI.CPXdelsetcols(this._env, this._lp, nArray));
        this.checkStillMIP();
    }

    final void _addSOSs(int n, byte[] byArray, int[] nArray, int[] nArray2, double[] dArray, String[] stringArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXaddsos(this._env, this._lp, n, nArray[n], byArray, nArray, nArray2, dArray, stringArray));
    }

    final void _delSOSs(int[] nArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXdelsetsos(this._env, this._lp, nArray));
        this.checkStillMIP();
    }

    final int _getSOSNZnum(int n, int n2) throws IloException {
        int[] nArray = new int[1];
        int n3 = CplexI.CPXgetsos(this._env, this._lp, null, null, null, null, null, 0, nArray, n, n2);
        if (n3 != 0 && n3 != 1207) {
            this.CALL(n3);
        }
        return -nArray[0];
    }

    final void _getSOSs(int n, int n2, byte[] byArray, int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        this.CALL(CplexI.CPXgetsos(this._env, this._lp, nArray3, byArray, nArray, nArray2, dArray, nArray2.length, nArray4, n, n2));
        nArray[n2 - n + 1] = nArray3[0];
    }

    final void _addNZs(int n, int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray3 = new int[1];
        CplexI.CPXgetintparam(this._env, IloCplex.BooleanParam.DataCheck.getValue(), nArray3);
        if (nArray3[0] != 0) {
            this.CALL(CplexI.CPXchgcoeflist(this._env, this._lp, n, nArray, nArray2, dArray));
        } else {
            this.CALL(CplexI.CPXEcacheNewNZsByNZ(this._env, this._lp, n, nArray, nArray2, dArray));
        }
    }

    final void _addCuts(int n, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, double[] dArray3, int n2) throws IloException {
        byte[] byArray = new byte[n];
        double[] dArray4 = new double[n];
        this.invalidate();
        int n3 = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n3 == 5 || n3 == 7) {
            this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 7));
        } else {
            this.CALL(CplexI.CPXchgprobtype(this._env, this._lp, 1));
        }
        for (int i = 0; i < n; ++i) {
            if (dArray2[i] >= 1.0E20) {
                byArray[i] = 71;
                dArray4[i] = dArray[i];
                continue;
            }
            if (dArray[i] <= -1.0E20) {
                byArray[i] = 76;
                dArray4[i] = dArray2[i];
                continue;
            }
            if (dArray[i] == dArray2[i]) {
                byArray[i] = 69;
                dArray4[i] = dArray2[i];
                continue;
            }
            byArray[i] = 71;
            dArray4[i] = dArray[i];
            double[] dArray5 = new double[1];
            int[] nArray3 = new int[1];
            byte[] byArray2 = new byte[1];
            dArray5[0] = dArray2[i];
            byArray2[0] = 76;
            if (n2 != 0) {
                this.CALL(CplexI.CPXaddlazyconstraints(this._env, this._lp, 1, nArray[i + 1] - nArray[i], dArray5, byArray2, nArray3, nArray2, dArray3, null));
                continue;
            }
            this.CALL(CplexI.CPXaddusercuts(this._env, this._lp, 1, nArray[i + 1] - nArray[i], dArray5, byArray2, nArray3, nArray2, dArray3, null));
        }
        if (n2 != 0) {
            this.CALL(CplexI.CPXaddlazyconstraints(this._env, this._lp, n, nArray[n], dArray4, byArray, nArray, nArray2, dArray3, null));
            this.CALL(Cplex.CPXsetintparam(this._env, 1057, 1));
        } else {
            this.CALL(CplexI.CPXaddusercuts(this._env, this._lp, n, nArray[n], dArray4, byArray, nArray, nArray2, dArray3, null));
            this.CALL(CplexI.CPXsetintparam(this._env, 1058, 0));
        }
    }

    final void _delCuts(int n) throws IloException {
        if (n != 0) {
            this.invalidate();
            this.CALL(CplexI.CPXfreelazyconstraints(this._env, this._lp));
        } else {
            this.invalidate();
            this.CALL(CplexI.CPXfreeusercuts(this._env, this._lp));
        }
        this.checkStillMIP();
    }

    final void _setObjective(double[] dArray) throws IloException {
        int n = dArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgobj(this._env, this._lp, n, nArray, dArray));
    }

    static int sortQ(int n, double[] dArray, int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        if (n < 2) {
            return n;
        }
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = 0; j < n - i; ++j) {
                n2 = n3 + i;
                for (n3 = j; n3 >= 0 && (nArray[n3] > nArray[n2] || nArray[n3] == nArray[n2] && nArray2[n3] > nArray2[n2]); n3 -= i) {
                    double d = dArray[n3];
                    dArray[n3] = dArray[n2];
                    dArray[n2] = d;
                    int n4 = nArray[n3];
                    nArray[n3] = nArray[n2];
                    nArray[n2] = n4;
                    n4 = nArray2[n3];
                    nArray2[n3] = nArray2[n2];
                    nArray2[n2] = n4;
                    n2 = n3;
                }
            }
        }
        n2 = 0;
        for (n3 = 1; n3 < n; ++n3) {
            if (nArray2[n3] != nArray2[n2] || nArray[n3] != nArray[n2]) {
                dArray[++n2] = dArray[n3];
                nArray[n2] = nArray[n3];
                nArray2[n2] = nArray2[n3];
                continue;
            }
            int n5 = n2;
            dArray[n5] = dArray[n5] + dArray[n3];
        }
        return n2 + 1;
    }

    final void _setQ(int n, double[] dArray, int[] nArray, int[] nArray2) throws IloException {
        int n2;
        int n3;
        int n4;
        int n5 = CplexI.sortQ(n, dArray, nArray, nArray2);
        int n6 = CplexI.CPXgetnumcols(this._env, this._lp);
        double[] dArray2 = new double[2 * n5];
        int[] nArray3 = new int[2 * n5];
        int[] nArray4 = new int[n6];
        int[] nArray5 = new int[n6];
        for (n4 = 0; n4 < n5; ++n4) {
            int n7 = n3 = nArray[n4];
            nArray4[n7] = nArray4[n7] + 1;
            n2 = nArray2[n4];
            if (n3 == n2) continue;
            int n8 = n2;
            nArray4[n8] = nArray4[n8] + 1;
        }
        nArray5[0] = 0;
        for (n4 = 1; n4 < n6; ++n4) {
            nArray5[n4] = nArray5[n4 - 1] + nArray4[n4 - 1];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray[n4];
            n2 = nArray2[n4];
            if (n3 == n2) {
                dArray2[nArray5[n3]] = 2.0 * dArray[n4];
                nArray3[nArray5[n3]] = n3;
                int n9 = n3;
                nArray5[n9] = nArray5[n9] + 1;
                continue;
            }
            dArray2[nArray5[n3]] = dArray[n4];
            nArray3[nArray5[n3]] = n2;
            int n10 = n3;
            nArray5[n10] = nArray5[n10] + 1;
            dArray2[nArray5[n2]] = dArray[n4];
            nArray3[nArray5[n2]] = n3;
            int n11 = n2;
            nArray5[n11] = nArray5[n11] + 1;
        }
        for (n4 = 0; n4 < n6; ++n4) {
            int n12 = n4;
            nArray5[n12] = nArray5[n12] - nArray4[n4];
        }
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXcopyquad(this._env, this._lp, nArray5, nArray4, nArray3, dArray2));
    }

    final void _setLb(int n, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray = new int[]{n};
        byte[] byArray = new byte[]{76};
        double[] dArray = new double[]{d};
        this.CALL(CplexI.CPXchgbds(this._env, this._lp, 1, nArray, byArray, dArray));
    }

    final void _setUb(int n, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray = new int[]{n};
        byte[] byArray = new byte[]{85};
        double[] dArray = new double[]{d};
        this.CALL(CplexI.CPXchgbds(this._env, this._lp, 1, nArray, byArray, dArray));
    }

    final void _setType(int n, byte by) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray = new int[]{n};
        byte[] byArray = new byte[]{by};
        this.CALL(CplexI.CPXchgctype(this._env, this._lp, 1, nArray, byArray));
        this.checkStillMIP();
    }

    final void _setLHS(int n, double d) throws IloException {
        byte[] byArray = new byte[1];
        int[] nArray = new int[]{n};
        double[] dArray = new double[]{d};
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray, n, n));
        if (byArray[0] == 71) {
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
        } else if (byArray[0] == 76) {
            if (d > -1.0E20) {
                double[] dArray2 = new double[1];
                this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray2, n, n));
                if (d == dArray2[0]) {
                    byArray[0] = 69;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                } else {
                    byArray[0] = 82;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
                    double[] dArray3 = new double[]{dArray2[0] - d};
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray3));
                }
            }
        } else if (byArray[0] == 69) {
            if (d <= -1.0E20) {
                byArray[0] = 76;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            } else {
                double[] dArray4 = new double[1];
                this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray4, n, n));
                if (dArray4[0] != d) {
                    byArray[0] = 82;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
                    double[] dArray5 = new double[]{dArray4[0] - d};
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray5));
                }
            }
        } else {
            double[] dArray6 = new double[1];
            double[] dArray7 = new double[1];
            this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray6, n, n));
            this.CALL(CplexI.CPXgetrngval(this._env, this._lp, dArray7, n, n));
            if (d <= -1.0E20) {
                byArray[0] = 76;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                dArray6[0] = dArray6[0] + dArray7[0];
                this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray6));
            } else if (dArray6[0] != d) {
                double d2 = dArray6[0] + dArray7[0];
                if (d == d2) {
                    byArray[0] = 69;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
                } else {
                    dArray7[0] = d2 - d;
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray7));
                }
            }
        }
    }

    final void _setRHS(int n, double d) throws IloException {
        byte[] byArray = new byte[1];
        int[] nArray = new int[]{n};
        double[] dArray = new double[]{d};
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray, n, n));
        if (byArray[0] == 76) {
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
        } else if (byArray[0] == 71) {
            if (d < 1.0E20) {
                double[] dArray2 = new double[1];
                this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray2, n, n));
                if (dArray2[0] == d) {
                    byArray[0] = 69;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                } else if (dArray2[0] <= -1.0E20) {
                    byArray[0] = 76;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    dArray2[0] = d;
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray2));
                } else {
                    byArray[0] = 82;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray2));
                    double[] dArray3 = new double[]{d - dArray2[0]};
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray3));
                }
            }
        } else if (byArray[0] == 69) {
            if (d >= 1.0E20) {
                byArray[0] = 71;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            } else {
                double[] dArray4 = new double[1];
                this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray4, n, n));
                if (dArray4[0] != d) {
                    byArray[0] = 82;
                    this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
                    this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray4));
                    double[] dArray5 = new double[]{d - dArray4[0]};
                    this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray5));
                }
            }
        } else if (d >= 1.0E20) {
            byArray[0] = 71;
            this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
        } else {
            double[] dArray6 = new double[1];
            this.CALL(CplexI.CPXgetrhs(this._env, this._lp, dArray6, n, n));
            double[] dArray7 = new double[]{d - dArray6[0]};
            if (dArray7[0] == 0.0) {
                byArray[0] = 69;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            } else {
                this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray7));
            }
        }
    }

    final void _setLRHS(int n, double d, double d2) throws IloException {
        byte[] byArray = new byte[1];
        int[] nArray = new int[]{n};
        double[] dArray = new double[]{d};
        double[] dArray2 = new double[]{d2};
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXgetsense(this._env, this._lp, byArray, n, n));
        if (d == d2) {
            if (byArray[0] != 69) {
                byArray[0] = 69;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            }
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
        } else if (d2 >= 1.0E20) {
            if (byArray[0] != 71) {
                byArray[0] = 71;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            }
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
        } else if (d <= -1.0E20) {
            if (byArray[0] != 76) {
                byArray[0] = 76;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            }
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray2));
        } else {
            if (byArray[0] != 82) {
                byArray[0] = 82;
                this.CALL(CplexI.CPXchgsense(this._env, this._lp, 1, nArray, byArray));
            }
            this.CALL(CplexI.CPXchgrhs(this._env, this._lp, 1, nArray, dArray));
            double[] dArray3 = new double[]{d2 - d};
            this.CALL(CplexI.CPXchgrngval(this._env, this._lp, 1, nArray, dArray3));
        }
    }

    final void _setObjCoef(int n, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        int[] nArray = new int[]{n};
        double[] dArray = new double[]{d};
        this.CALL(CplexI.CPXchgobj(this._env, this._lp, 1, nArray, dArray));
    }

    final void _setObjCoefs(int n, int[] nArray, double[] dArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgobj(this._env, this._lp, n, nArray, dArray));
    }

    final void _setNZ(int n, int n2, double d) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgcoef(this._env, this._lp, n, n2, d));
    }

    final void _setNZs(int n, int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        this.origProbType();
        this.invalidate();
        this.CALL(CplexI.CPXchgcoeflist(this._env, this._lp, n, nArray, nArray2, dArray));
    }

    final int _getQPNZnum() throws IloException {
        this.disableOutput();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = CplexI.CPXgetquad(this._env, this._lp, nArray, null, null, null, 0, nArray2, 0, CplexI.CPXgetnumcols(this._env, this._lp) - 1);
        this.enableOutput();
        if (n != 0 && n != 1207) {
            this.CALL(n);
        }
        return -nArray2[0];
    }

    final void _getQP(int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n = CplexI.CPXgetnumcols(this._env, this._lp);
        this.CALL(CplexI.CPXgetquad(this._env, this._lp, nArray3, nArray, nArray2, dArray, nArray2.length, nArray4, 0, n - 1));
        nArray[0] = 0;
        nArray[n] = nArray3[0];
    }

    final int _getRowNZnum(int n, int n2) throws IloException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n3 = CplexI.CPXgetrows(this._env, this._lp, nArray, null, null, null, 0, nArray2, n, n2);
        if (n3 != 0 && n3 != 1207) {
            this.CALL(n3);
        }
        return -nArray2[0];
    }

    final void _getRows(int n, int n2, double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, double[] dArray3) throws IloException {
        Object[] objectArray;
        Object[] objectArray2;
        int n3 = n2 - n + 1;
        if (nArray != null && nArray2 != null && dArray3 != null) {
            objectArray2 = new int[1];
            objectArray = new int[1];
            this.CALL(CplexI.CPXgetrows(this._env, this._lp, objectArray2, nArray, nArray2, dArray3, nArray2.length, objectArray, n, n2));
            nArray[0] = 0;
            nArray[n3] = objectArray2[0];
        }
        if (dArray != null && dArray2 != null) {
            objectArray2 = new double[n3];
            objectArray = new byte[n3];
            this.CALL(CplexI.CPXgetsense(this._env, this._lp, (byte[])objectArray, n, n2));
            this.CALL(CplexI.CPXgetrhs(this._env, this._lp, objectArray2, n, n2));
            for (int i = 0; i < n3; ++i) {
                if (objectArray[i] == 69) {
                    int n4 = objectArray2[i];
                    dArray2[i] = n4;
                    dArray[i] = n4;
                    continue;
                }
                if (objectArray[i] == 76) {
                    dArray[i] = -1.0E20;
                    dArray2[i] = objectArray2[i];
                    continue;
                }
                if (objectArray[i] == 71) {
                    dArray[i] = objectArray2[i];
                    dArray2[i] = 1.0E20;
                    continue;
                }
                double[] dArray4 = new double[1];
                this.CALL(CplexI.CPXgetrngval(this._env, this._lp, dArray4, i + n, i + n));
                dArray[i] = objectArray2[i];
                dArray2[i] = objectArray2[i] + dArray4[0];
            }
        }
    }

    final int _getColumnNZnum(int n, int n2) throws IloException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n3 = CplexI.CPXgetcols(this._env, this._lp, nArray, null, null, null, 0, nArray2, n, n2);
        if (n3 != 0 && n3 != 1207) {
            this.CALL(n3);
        }
        return -nArray2[0];
    }

    final void _getColumns(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) throws IloException {
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        this.CALL(CplexI.CPXgetcols(this._env, this._lp, nArray3, nArray, nArray2, dArray, nArray2.length, nArray4, n, n2));
        nArray[0] = 0;
        nArray[n2 - n + 1] = nArray3[0];
    }

    final void _getVariables(int n, double[] dArray, double[] dArray2, double[] dArray3, byte[] byArray) throws IloException {
        this.CALL(CplexI.CPXgetobj(this._env, this._lp, dArray, 0, n - 1));
        this.CALL(CplexI.CPXgetlb(this._env, this._lp, dArray2, 0, n - 1));
        this.CALL(CplexI.CPXgetub(this._env, this._lp, dArray3, 0, n - 1));
        int n2 = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n2 == 1 || n2 == 7 || n2 == 11 || n2 == 3) {
            this.CALL(CplexI.CPXgetctype(this._env, this._lp, byArray, 0, n - 1));
        } else {
            for (int i = 0; i < n; ++i) {
                byArray[i] = 67;
            }
        }
    }

    private final void setStatus(int n) throws IloException {
        this._status = 0;
        if (n == 1101) {
            this._status = 4;
            n = 0;
        } else {
            this._status = CplexI.CPXgetstat(this._env, this._lp);
            if (this._status == 101) {
                this._status = 1;
            } else if (this._status == 103) {
                this._status = 3;
            } else if (this._status == 107) {
                this._status = 11;
            } else if (this._status == 108) {
                this._status = 11;
            } else if (this._status == 113) {
                this._status = 13;
            } else if (this._status == 114) {
                this._status = 13;
            } else if (this._status == 115) {
                this._status = 5;
            } else if (this._status == 121) {
                this._status = 15;
            } else if (this._status == 120) {
                this._status = 14;
            } else if (this._status == 123) {
                this._status = 17;
            } else if (this._status == 122) {
                this._status = 16;
            } else if (this._status == 125) {
                this._status = 19;
            } else if (this._status == 124) {
                this._status = 18;
            }
        }
        this.CALL(n);
    }

    final void _getObjValue(double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetobjval(this._env, this._lp, dArray));
    }

    final void _getBestObjValue(double[] dArray) throws IloException {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            this.CALL(CplexI.CPXgetbestobjval(this._env, this._lp, dArray));
        } else {
            dArray[0] = CplexI.CPXgetobjsen(this._env, this._lp) == 1 ? this.bigReal : -this.bigReal;
        }
    }

    final void _getMIPRelativeGap(double[] dArray) throws IloException {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            this.CALL(CplexI.CPXgetmiprelgap(this._env, this._lp, dArray));
        } else {
            dArray[0] = this.bigReal;
        }
    }

    final void _getCutoff(double[] dArray) throws IloException {
        int n = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n == 1 || n == 7 || n == 11) {
            this.CALL(CplexI.CPXgetcutoff(this._env, this._lp, dArray));
        } else {
            dArray[0] = CplexI.CPXgetobjsen(this._env, this._lp) == 1 ? this.bigReal : -this.bigReal;
        }
    }

    final void _getAX(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetax(this._env, this._lp, dArray, n, n2));
    }

    final void _getPi(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetpi(this._env, this._lp, dArray, n, n2));
    }

    final void _getRowInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetrowinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getQCInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetqconstrinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getIndInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetindconstrinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getSOSInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetsosinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getColInfeasibilities(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetcolinfeas(this._env, this._lp, null, dArray, n, n2));
    }

    final void _getReducedCosts(int n, int n2, double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetdj(this._env, this._lp, dArray, n, n2));
    }

    final boolean isDfeas() throws IloException {
        int[] nArray = new int[1];
        if (CplexI.CPXsolninfo(this._env, this._lp, null, null, null, nArray) != 0) {
            return false;
        }
        return nArray[0] != 0;
    }

    final boolean isPfeas() throws IloException {
        int[] nArray = new int[1];
        if (CplexI.CPXsolninfo(this._env, this._lp, null, null, nArray, null) != 0) {
            return false;
        }
        return nArray[0] != 0;
    }

    final void _getBase(int[] nArray, int[] nArray2) throws IloException {
        this.CALL(CplexI.CPXgetbase(this._env, this._lp, nArray, nArray2));
    }

    final void _setBase(int[] nArray, int[] nArray2) throws IloException {
        this.CALL(CplexI.CPXcopybase(this._env, this._lp, nArray, nArray2));
    }

    final void _rangesa(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws IloException {
        this.CALL(CplexI.CPXErangesa(this._env, this._lp, n, n2, dArray, dArray2, dArray3, dArray4));
    }

    final void _rhssa(int n, int n2, double[] dArray, double[] dArray2) throws IloException {
        this.CALL(CplexI.CPXrhssa(this._env, this._lp, n, n2, dArray, dArray2));
    }

    final void _boundsa(int n, int n2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws IloException {
        this.CALL(CplexI.CPXboundsa(this._env, this._lp, n, n2, dArray, dArray2, dArray3, dArray4));
    }

    final void _objsa(int n, int n2, double[] dArray, double[] dArray2) throws IloException {
        this.CALL(CplexI.CPXobjsa(this._env, this._lp, n, n2, dArray, dArray2));
    }

    final void _getQuality(int n, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray, int n2) throws IloException {
        double[] dArray2 = new double[]{0.0};
        double[] dArray3 = new double[]{0.0};
        nArray2[0] = -1;
        nArray[0] = -1;
        nArray3[0] = -1;
        switch (n) {
            case 27: 
            case 28: {
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray2, n));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray, n));
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray3, 47));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 47));
                if (dArray2[0] > dArray[0]) {
                    dArray[0] = dArray2[0];
                    nArray2[0] = -1;
                    break;
                }
                nArray3[0] = -1;
                break;
            }
            case 1: 
            case 2: {
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray, n));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray, n));
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray3, 45));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 45));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray3, 49));
                if (dArray3[0] > dArray[0] && dArray3[0] > dArray2[0]) {
                    dArray[0] = dArray2[0];
                    nArray[0] = -1;
                    nArray2[0] = -1;
                    nArray3[0] = -1;
                    break;
                }
                if (dArray2[0] > dArray[0]) {
                    dArray[0] = dArray2[0];
                    nArray[0] = -1;
                    break;
                }
                nArray3[0] = -1;
                if (nArray[0] >= 0) break;
                nArray2[0] = -nArray[0] - 1;
                nArray[0] = -1;
                break;
            }
            case 11: 
            case 12: {
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray, n));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray, n));
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray3, 43));
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 43));
                if (dArray2[0] > dArray[0]) {
                    dArray[0] = dArray2[0];
                    nArray[0] = -1;
                    break;
                }
                nArray3[0] = -1;
                if (nArray[0] >= 0) break;
                nArray2[0] = -nArray[0] - 1;
                nArray[0] = -1;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 15: 
            case 16: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                this.CALL(CplexI.CPXgetsolnpoolintquality(this._env, this._lp, n2, nArray, n));
                if (nArray[0] > -1) break;
                nArray2[0] = -nArray[0] - 1;
                nArray[0] = -1;
                break;
            }
            default: {
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray, n));
                if (n == 35 || n == 36) {
                    this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 48));
                    dArray[0] = dArray[0] + dArray2[0];
                }
                if (n == 3 || n == 4) {
                    this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 46));
                    dArray[0] = dArray[0] + dArray2[0];
                    this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 50));
                    dArray[0] = dArray[0] + dArray2[0];
                }
                if (n != 13 && n != 14) break;
                this.CALL(CplexI.CPXgetsolnpooldblquality(this._env, this._lp, n2, dArray2, 44));
                dArray[0] = dArray[0] + dArray2[0];
            }
        }
    }

    final void _getIISsize(int[] nArray) throws IloException {
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n = CplexI.CPXfindiis(this._env, this._lp, nArray2, nArray3);
        if (n != 0) {
            if (n != 1101 && CplexI.CPXgetstat(this._env, this._lp) != 3) {
                this.CALL(n);
            }
            int[] nArray4 = new int[1];
            this.CALL(CplexI.CPXgetintparam(this._env, IloCplex.BooleanParam.PreInd.getValue(), nArray4));
            if (nArray4[0] == 0) {
                this.CALL(n);
            }
            this.CALL(CplexI.CPXsetintparam(this._env, IloCplex.BooleanParam.PreInd.getValue(), 0));
            n = CplexI.CPXlpopt(this._env, this._lp);
            this.CALL(CplexI.CPXsetintparam(this._env, IloCplex.BooleanParam.PreInd.getValue(), nArray4[0]));
            this.CALL(n);
            this.CALL(CplexI.CPXfindiis(this._env, this._lp, nArray2, nArray3));
        }
        nArray[0] = nArray2[0];
        nArray[1] = nArray3[0];
    }

    final void _getIIS(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws IloException {
        this.CALL(CplexI.CPXgetiis(this._env, this._lp, null, nArray, nArray2, null, nArray3, nArray4, null));
    }

    final void _getRay(double[] dArray) throws IloException {
        this.CALL(CplexI.CPXgetray(this._env, this._lp, dArray));
    }

    final void _dualFarkas(double[] dArray, double[] dArray2) throws IloException {
        this.CALL(CplexI.CPXdualfarkas(this._env, this._lp, dArray, dArray2));
    }

    final void _qpIndefCertificate(double[] dArray) throws IloException {
        this.CALL(CplexI.CPXqpindefcertificate(this._env, this._lp, dArray));
    }

    final String _getDelQCname(int n) {
        int[] nArray = new int[]{0};
        String string = CplexI.CPXgetqconstrname(this._env, this._lp, n, nArray);
        return string;
    }

    final void _getSOSNames(String[] stringArray, int n, int n2) throws IloException {
        int[] nArray;
        String[] stringArray2;
        if (stringArray != null && (stringArray2 = CplexI.CPXgetsosname(this._env, this._lp, n, n2, nArray = new int[]{0})) != null) {
            System.arraycopy(stringArray2, 0, stringArray, n, stringArray2.length);
        }
    }

    final void _getDelNames(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, int n, int n2) throws IloException {
        int[] nArray;
        String[] stringArray5;
        if (stringArray3 != null && (stringArray5 = CplexI.CPXgetcolname(this._env, this._lp, n, n2, nArray = new int[]{0})) != null) {
            System.arraycopy(stringArray5, 0, stringArray3, n, stringArray5.length);
        }
        if (stringArray4 != null && (stringArray5 = CplexI.CPXgetrowname(this._env, this._lp, n, n2, nArray = new int[]{0})) != null) {
            System.arraycopy(stringArray5, 0, stringArray4, n, stringArray5.length);
        }
        if (stringArray2 != null && CplexI.CPXgetobjname(this._env, this._lp, stringArray2) != 0) {
            stringArray2[0] = null;
        }
        if (stringArray != null) {
            this.CALL(CplexI.CPXgetprobname(this._env, this._lp, stringArray));
            this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
        }
    }

    final void _installNames(String string, String[] stringArray, int n, int n2, char c) throws IloException {
        if (string != null) {
            if (c == 'P') {
                this.CALL(CplexI.CPXchgprobname(this._env, this._lp, string));
            } else {
                this.CALL(CplexI.CPXcopyobjname(this._env, this._lp, string));
            }
        }
        if (stringArray != null && n2 > 0) {
            if (n + n2 > stringArray.length) {
                n2 = stringArray.length - n;
            }
            String[] stringArray2 = new String[n2];
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = i + n;
                stringArray2[i] = stringArray[i + n];
            }
            if (c == 'C') {
                this.CALL(CplexI.CPXchgcolname(this._env, this._lp, n2, nArray, stringArray2));
            } else if (c == 'Q') {
                this.CALL(CplexI.CPXEchgqcname(this._env, this._lp, n2, nArray, stringArray2));
            } else if (c == 'S') {
                this.CALL(CplexI.CPXEchgsosname(this._env, this._lp, n2, nArray, stringArray2));
            } else {
                this.CALL(CplexI.CPXchgrowname(this._env, this._lp, n2, nArray, stringArray2));
            }
        }
    }

    final int _getOrderNum() throws IloException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n = CplexI.CPXgetorder(this._env, this._lp, nArray, nArray2, nArray2, nArray2, 0, nArray3);
        if (n == 1207) {
            return -nArray3[0];
        }
        return 0;
    }

    final void _getOrder(int[] nArray, int[] nArray2, int[] nArray3) throws IloException {
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        this.CALL(CplexI.CPXgetorder(this._env, this._lp, nArray4, nArray, nArray2, nArray3, nArray.length, nArray5));
    }

    final void _copyOrder(int[] nArray, int[] nArray2, int[] nArray3) throws IloException {
        this.CALL(CplexI.CPXcopyorder(this._env, this._lp, nArray.length, nArray, nArray2, nArray3));
    }

    final void _writeOrder(String string) throws IloException {
        this.CALL(CplexI.CPXordwrite(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    final void _writeConflict(String string) throws IloException {
        this.CALL(CplexI.CPXclpwrite(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
    }

    final int getProbType() {
        return CplexI.CPXgetprobtype(this._env, this._lp);
    }

    final void setFixBasis(boolean bl) {
        this._fixBasis = bl;
    }

    final void _copyStart(double[] dArray, double[] dArray2, int[] nArray, int n, int n2, double[] dArray3, double[] dArray4, int[] nArray2, int n3, int n4) throws IloException {
        this.origProbType();
        int n5 = CplexI.CPXgetprobtype(this._env, this._lp);
        if (n5 == 1 || n5 == 7 || n5 == 11) {
            if (nArray != null && dArray != null) {
                if (n > 0) {
                    double[] dArray5 = new double[n2];
                    int[] nArray3 = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        nArray3[i] = nArray[i + n];
                        dArray5[i] = dArray[i + n];
                    }
                    this.CALL(CplexI.CPXchgmipstart(this._env, this._lp, n2, nArray3, dArray5));
                } else {
                    this.CALL(CplexI.CPXchgmipstart(this._env, this._lp, n2, nArray, dArray));
                }
            }
        } else {
            int n6;
            int n7 = CplexI.CPXgetnumrows(this._env, this._lp);
            int n8 = CplexI.CPXgetnumcols(this._env, this._lp);
            int n9 = n + n2;
            int n10 = n3 + n4;
            double[] dArray6 = new double[n8];
            double[] dArray7 = new double[n7];
            double[] dArray8 = new double[n8];
            double[] dArray9 = new double[n7];
            if (nArray != null && dArray != null) {
                CplexI.CPXgetx(this._env, this._lp, dArray6, 0, n8 - 1);
                for (n6 = n; n6 < n9; ++n6) {
                    dArray6[nArray[n6]] = dArray[n6];
                }
                if (nArray2 != null && dArray3 != null) {
                    CplexI.CPXgetslack(this._env, this._lp, dArray7, 0, n7 - 1);
                    for (n6 = n3; n6 < n10; ++n6) {
                        dArray7[nArray2[n6]] = dArray3[n6];
                    }
                    this.CALL(CplexI.CPXcopystart(this._env, this._lp, null, null, dArray6, dArray7, null, null));
                } else {
                    this.CALL(CplexI.CPXcopystart(this._env, this._lp, null, null, dArray6, null, null, null));
                }
            }
            if (nArray2 != null && dArray4 != null) {
                CplexI.CPXgetpi(this._env, this._lp, dArray9, 0, n7 - 1);
                for (n6 = n3; n6 < n10; ++n6) {
                    dArray9[nArray2[n6]] = dArray4[n6];
                }
                if (nArray != null && dArray2 != null) {
                    CplexI.CPXgetdj(this._env, this._lp, dArray8, 0, n8 - 1);
                    for (n6 = n; n6 < n9; ++n6) {
                        dArray8[nArray[n6]] = dArray2[n6];
                    }
                    this.CALL(CplexI.CPXcopystart(this._env, this._lp, null, null, null, null, dArray8, dArray9));
                } else {
                    this.CALL(CplexI.CPXcopystart(this._env, this._lp, null, null, null, null, null, dArray9));
                }
            }
        }
    }

    void init() throws IloException {
        int[] nArray = new int[1];
        this._env = CplexI.CPXopenCPLEX(nArray);
        this.CALL(nArray[0]);
        this.CALL(Cplex.threadInit(this._env));
        this._lp = CplexI.CPXcreateprob(this._env, nArray, this.probName());
        this.CALL(nArray[0]);
        this._status = 0;
        this.bigReal = CplexI.CPXEgetbigreal(this._env);
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        long[] lArray4 = new long[1];
        this.CALL(CplexI.CPXgetchannels(this._env, lArray3, lArray2, lArray, lArray4));
        this.disableOutput();
        this.enableOutput();
        this.CALL(CplexI.CPXEsetnamefunctions(this._env, this, new ColName(), new RowName(), new QCName(), null, new SOSName()));
    }

    final void finit() {
        long[] lArray;
        if (this._lp != 0L) {
            lArray = new long[]{this._lp};
            CplexI.CPXfreeprob(this._env, lArray);
        }
        lArray = new long[]{this._env};
        CplexI.CPXcloseCPLEX(lArray);
    }

    final void initGoals(int[] nArray, int[] nArray2) throws IloException {
        this.CALL(CplexI.CPXgetintparam(this._env, 2070, nArray));
        this.CALL(CplexI.CPXsetintparam(this._env, 2070, 1));
        this.CALL(CplexI.CPXgetintparam(this._env, 1001, nArray2));
        this.CALL(CplexI.CPXsetintparam(this._env, 1001, 0));
    }

    final void finitGoals(int n, int n2) throws IloException {
        this.CALL(CplexI.CPXsetintparam(this._env, 2070, n));
        this.CALL(CplexI.CPXsetintparam(this._env, 1001, n2));
    }

    static synchronized int lockILM(CplexI cplexI) {
        cplexI.finit();
        return 0;
    }

    static int putenv(String string) {
        return CplexI.CPXputenv(string);
    }

    static int registerLicense(String string, int n) {
        return CplexI.CPXRegisterLicense(string, n);
    }

    public double getSolnPoolMeanObjValue() throws IloException {
        double[] dArray = new double[1];
        this.CALL(CplexI.CPXgetsolnpoolmeanobjval(this._env, this._lp, dArray));
        return dArray[0];
    }

    public int getSolnPoolNsolns() {
        return CplexI.CPXgetsolnpoolnumsolns(this._env, this._lp);
    }

    public int getSolnPoolNreplaced() {
        return CplexI.CPXgetsolnpoolnumreplaced(this._env, this._lp);
    }

    public void delSolnPoolSolns(int n, int n2) throws IloException {
        if (n2 > 0) {
            this.CALL(CplexI.CPXdelsolnpoolsolns(this._env, this._lp, n, n + n2 - 1));
        }
    }

    public double getObjValue(int n) throws IloException {
        double[] dArray = new double[1];
        this.CALL(CplexI.CPXgetsolnpoolobjval(this._env, this._lp, n, dArray));
        return dArray[0];
    }

    public void getValuesForExpr(double[] dArray, int n) throws IloException {
        int n2 = this.getNcols();
        this.CALL(CplexI.CPXgetsolnpoolx(this._env, this._lp, n, dArray, 0, n2 - 1));
    }

    public double[] getValues(IloNumVar[] iloNumVarArray, int n, int n2, int n3) throws IloCplex.UnknownObjectException, IloException {
        int n4 = this.getNcols();
        double[] dArray = this.getSolnPoolXArray(n3);
        double[] dArray2 = new double[n2];
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            CpxNumVar cpxNumVar = (CpxNumVar)iloNumVarArray[i];
            if (cpxNumVar.getVarIndex() == null || cpxNumVar.getVarIndexValue() < 0) {
                throw new IloCplex.UnknownObjectException(cpxNumVar);
            }
            dArray2[i - n] = dArray[cpxNumVar.getVarIndexValue()];
        }
        return dArray2;
    }

    public double getQCSlack(int n, int n2) throws IloException {
        double[] dArray = new double[]{0.0};
        if (n2 == -1) {
            double[] dArray2 = this.getQCSlackArray();
            dArray[0] = dArray2[n];
        } else {
            double[] dArray3 = this.getSolnPoolQCSlackArray(n2);
            dArray[0] = dArray3[n];
        }
        return dArray[0];
    }

    public double[] getSlacks(int n, int n2, int n3) throws IloException {
        int n4 = n2 - n + 1;
        double[] dArray = new double[n4];
        if (n3 == -1) {
            double[] dArray2 = this.getSlackArray();
            System.arraycopy(dArray2, n, dArray, 0, n4);
        } else {
            double[] dArray3 = this.getSolnPoolSlackArray(n3);
            System.arraycopy(dArray3, n, dArray, 0, n4);
        }
        return dArray;
    }

    private void removeFromFilters(CplexIndex cplexIndex) {
        int n = 0;
        block0: for (int i = this._filter.size(); n < i; ++i) {
            Filter filter = (Filter)this._filter.elementAt(n);
            for (int j = 0; j < filter._var.length; ++j) {
                double[] dArray;
                if (filter._var[j] != cplexIndex) continue;
                CplexIndex[] cplexIndexArray = new CplexIndex[filter._var.length - 1];
                System.arraycopy(filter._var, 0, cplexIndexArray, 0, j);
                System.arraycopy(filter._var, j + 1, cplexIndexArray, j, cplexIndexArray.length - j);
                filter._var = cplexIndexArray;
                if (filter._weight != null) {
                    dArray = new double[filter._weight.length - 1];
                    System.arraycopy(filter._weight, 0, dArray, 0, j);
                    System.arraycopy(filter._weight, j + 1, dArray, j, dArray.length - j);
                    filter._weight = dArray;
                }
                if (filter._refval == null) continue block0;
                dArray = new double[filter._refval.length - 1];
                System.arraycopy(filter._refval, 0, dArray, 0, j);
                System.arraycopy(filter._refval, j + 1, dArray, j, dArray.length - j);
                filter._refval = dArray;
                continue block0;
            }
        }
    }

    void removeFromFilters(int[] nArray) {
        int n = 0;
        for (int i = this._filter.size(); n < i; ++i) {
            double[] dArray;
            Filter filter = (Filter)this._filter.elementAt(n);
            int n2 = filter._var.length;
            for (int j = n2 - 1; j >= 0; --j) {
                if (nArray[filter._var[j].getIndex()] == 0) continue;
                filter._var[j] = filter._var[--n2];
                if (filter._weight != null) {
                    filter._weight[j] = filter._weight[n2];
                }
                if (filter._refval == null) continue;
                filter._refval[j] = filter._refval[n2];
            }
            if (n2 == filter._var.length) continue;
            CplexIndex[] cplexIndexArray = new CplexIndex[n2];
            System.arraycopy(filter._var, 0, cplexIndexArray, 0, n2);
            filter._var = cplexIndexArray;
            if (filter._weight != null) {
                dArray = new double[n2];
                System.arraycopy(filter._weight, 0, dArray, 0, n2);
                filter._weight = dArray;
            }
            if (filter._refval == null) continue;
            dArray = new double[n2];
            System.arraycopy(filter._refval, 0, dArray, 0, n2);
            filter._refval = dArray;
        }
    }

    public void delFilter(IloCplex.FilterIndex filterIndex) throws IloException {
        this._filter.remove(filterIndex.getIndex());
        this._filters.deleteIndices(filterIndex, filterIndex);
        this.delFiltersFromLP();
    }

    public void delFilters() throws IloException {
        this._filter.removeAllElements();
        this._filters.clear();
        this.delFiltersFromLP();
    }

    private void delFiltersFromLP() throws IloException {
        int n = CplexI.CPXgetsolnpoolnumfilters(this._env, this._lp);
        if (n != 0) {
            this.CALL(CplexI.CPXdelsolnpoolfilters(this._env, this._lp, 0, n - 1));
        }
    }

    public IloCplex.FilterIndex[] readFilters(String string) throws IloException {
        this.delFiltersFromLP();
        this._filters.clear();
        this.installNames(this);
        this.CALL(CplexI.CPXreadcopysolnpoolfilters(this._env, this._lp, string));
        this.CALL(CplexI.CPXEdelnames(this._env, this._lp));
        int n = CplexI.CPXgetsolnpoolnumfilters(this._env, this._lp);
        IloCplex.FilterIndex[] filterIndexArray = new IloCplex.FilterIndex[n];
        for (int i = 0; i < n; ++i) {
            int[] nArray = new int[]{0};
            int n2 = CplexI.CPXgetsolnpoolfilter(this._env, this._lp, null, null, null, null, null, null, null, 0, nArray, i);
            if (n2 != 0 && n2 != 1207) {
                this.CALL(n2);
            }
            nArray[0] = -nArray[0];
            int[] nArray2 = new int[]{0};
            double[] dArray = new double[]{0.0};
            double[] dArray2 = new double[]{0.0};
            int[] nArray3 = new int[nArray[0]];
            double[] dArray3 = new double[nArray[0]];
            double[] dArray4 = new double[nArray[0]];
            int[] nArray4 = new int[]{0};
            this.CALL(CplexI.CPXgetsolnpoolfilter(this._env, this._lp, nArray2, dArray, dArray2, null, nArray3, dArray3, dArray4, nArray[0], nArray4, i));
            int[] nArray5 = new int[]{0};
            this._filter.add(new Filter(this, nArray2[0], dArray[0], dArray2[0], nArray3, dArray3, dArray4, CplexI.CPXgetsolnpoolfiltername(this._env, this._lp, i, nArray5)));
            filterIndexArray[i] = (IloCplex.FilterIndex)this._filters.addIndex(new IloCplex.FilterIndex(i), null);
        }
        return filterIndexArray;
    }

    private void flushFilters() throws IloException {
        int n;
        int n2 = this._filter.size();
        if (n2 > (n = CplexI.CPXgetsolnpoolnumfilters(this._env, this._lp))) {
            int[] nArray = new int[this.getNcols()];
            for (int i = n; i < n2; ++i) {
                Filter filter = (Filter)this._filter.elementAt(i);
                for (int j = 0; j < filter._var.length; ++j) {
                    nArray[j] = filter._var[j].getIndex();
                }
                if (filter._type == 1) {
                    this.CALL(CplexI.CPXaddsolnpooldivfilter(this._env, this._lp, filter._lb, filter._ub, filter._var.length, nArray, filter._weight, filter._refval, filter._name));
                    continue;
                }
                this.CALL(CplexI.CPXaddsolnpoolrngfilter(this._env, this._lp, filter._lb, filter._ub, filter._var.length, nArray, filter._weight, filter._name));
            }
        }
    }

    public void writeFilters(String string) throws IloException {
        this.flushFilters();
        this.CALL(CplexI.CPXfltwrite(this._env, this._lp, string));
    }

    public IloCplex.FilterIndex addDiversityFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, String string) {
        this._filter.add(new Filter(this, 1, d, d2, iloNumVarArray, dArray, dArray2, string));
        return (IloCplex.FilterIndex)this._filters.addIndex(new IloCplex.FilterIndex(this._filters.getNum()), null);
    }

    public IloCplex.FilterIndex getFilterIndex(String string) throws IloException {
        for (int i = 0; i < this._filter.size(); ++i) {
            if (!string.equals(((Filter)this._filter.elementAt((int)i))._name)) continue;
            return (IloCplex.FilterIndex)this._filters.getIndex(i);
        }
        throw new CpxException(-1, "unknown filter name");
    }

    public int getNfilters() {
        return this._filter.size();
    }

    public double getFilterLowerBound(IloCplex.FilterIndex filterIndex) {
        return ((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._lb;
    }

    public double getFilterUpperBound(IloCplex.FilterIndex filterIndex) {
        return ((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._ub;
    }

    public int getFilterType(IloCplex.FilterIndex filterIndex) {
        return ((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._type;
    }

    public IloNumVar[] getFilterVars(IloCplex.FilterIndex filterIndex) {
        CplexIndex[] cplexIndexArray = ((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._var;
        int n = cplexIndexArray.length;
        IloNumVar[] iloNumVarArray = new IloNumVar[n];
        for (int i = 0; i < n; ++i) {
            iloNumVarArray[i] = (IloNumVar)((Object)this._cols.getObject(cplexIndexArray[i]));
        }
        return iloNumVarArray;
    }

    public double[] getFilterWeights(IloCplex.FilterIndex filterIndex) {
        return (double[])((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._weight.clone();
    }

    public double[] getFilterRefVals(IloCplex.FilterIndex filterIndex) {
        return (double[])((Filter)this._filter.elementAt((int)filterIndex.getIndex()))._refval.clone();
    }

    public IloCplex.FilterIndex addRangeFilter(double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, String string) {
        this._filter.add(new Filter(this, 2, d, d2, iloNumVarArray, dArray, null, string));
        return (IloCplex.FilterIndex)this._filters.addIndex(new IloCplex.FilterIndex(this._filters.getNum()), null);
    }

    public double getCplexTime() throws IloException {
        double[] dArray = new double[1];
        this.CALL(CplexI.CPXgettime(this._env, dArray));
        return dArray[0];
    }

    public void use(AborterI aborterI) throws IloException {
        this.CALL(Cplex.CPXsetterminate(this._env, aborterI._p));
        aborterI.registerCplexI(this);
        this._abort = aborterI;
    }

    public void remove(AborterI aborterI) throws IloException {
        if (this._abort == aborterI) {
            if (this._env != 0L) {
                this.CALL(Cplex.CPXsetterminate(this._env, 0L));
            }
            aborterI.unregisterCplexI(this);
        }
    }

    public AborterI getAborter() {
        return this._abort;
    }

    public static class AborterI {
        long _p = Cplex.newNativeInt();
        Vector _cplexList = new Vector();

        void registerCplexI(CplexI cplexI) {
            this._cplexList.add(cplexI);
        }

        void unregisterCplexI(CplexI cplexI) {
            this._cplexList.remove(cplexI);
        }

        protected void finalize() throws IloException {
            while (this._cplexList.size() > 0) {
                ((CplexI)this._cplexList.elementAt(0)).remove(this);
            }
        }

        public void abort() {
            Cplex.setNativeInt(this._p, 1);
        }

        public void clear() {
            Cplex.setNativeInt(this._p, 0);
        }

        public boolean isAborted() {
            return Cplex.getNativeInt(this._p) != 0;
        }
    }

    private static class Filter {
        public int _type;
        public double _lb;
        public double _ub;
        public double[] _weight;
        public CplexIndex[] _var;
        public double[] _refval;
        public String _name;

        Filter(CplexI cplexI, int n, double d, double d2, IloNumVar[] iloNumVarArray, double[] dArray, double[] dArray2, String string) {
            this._type = n;
            this._lb = d;
            this._ub = d2;
            if (iloNumVarArray.length != 0) {
                this._var = new CplexIndex[iloNumVarArray.length];
                for (int i = 0; i < iloNumVarArray.length; ++i) {
                    this._var[i] = ((CpxNumVar)iloNumVarArray[i]).getVarIndex();
                }
                if (dArray != null) {
                    this._weight = (double[])dArray.clone();
                }
                if (dArray2 != null) {
                    this._refval = (double[])dArray2.clone();
                }
                this._name = string;
            }
        }

        Filter(CplexI cplexI, int n, double d, double d2, int[] nArray, double[] dArray, double[] dArray2, String string) {
            this._type = n;
            this._lb = d;
            this._ub = d2;
            if (nArray.length != 0) {
                this._var = new CplexIndex[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    this._var[i] = ((CpxNumVar)cplexI._cols.getObject(nArray[i])).getVarIndex();
                }
                if (dArray != null) {
                    this._weight = (double[])dArray.clone();
                }
                if (dArray2 != null) {
                    this._refval = (double[])dArray2.clone();
                }
                this._name = string;
            }
        }
    }

    class SOSName
    implements Cplex.NameFunction {
        SOSName() {
        }

        public String callIt(Object object, int n) {
            if (n >= CplexI.this._soss.getNum()) {
                return null;
            }
            CplexI cplexI = (CplexI)object;
            return cplexI.getSOSName(n);
        }
    }

    class QCName
    implements Cplex.NameFunction {
        QCName() {
        }

        public String callIt(Object object, int n) {
            if (n >= CplexI.this._qcs.getNum()) {
                return null;
            }
            CplexI cplexI = (CplexI)object;
            return cplexI.getQCName(n);
        }
    }

    class RowName
    implements Cplex.NameFunction {
        RowName() {
        }

        public String callIt(Object object, int n) {
            if (n >= CplexI.this._rows.getNum()) {
                return null;
            }
            CplexI cplexI = (CplexI)object;
            return cplexI.getRowName(n);
        }
    }

    class ColName
    implements Cplex.NameFunction {
        ColName() {
        }

        public String callIt(Object object, int n) {
            if (n >= CplexI.this._cols.getNum()) {
                return null;
            }
            CplexI cplexI = (CplexI)object;
            return cplexI.getColName(n);
        }
    }

    private class OutChannelFunction
    implements Cplex.MsgFunction {
        private OutChannelFunction() {
        }

        public void callIt(Object object, String string) {
            CplexI cplexI = (CplexI)object;
            cplexI.output().print(string);
        }
    }

    private class WarnChannelFunction
    implements Cplex.MsgFunction {
        private WarnChannelFunction() {
        }

        public void callIt(Object object, String string) {
            CplexI cplexI = (CplexI)object;
            cplexI.warning().print(string);
        }
    }

    private class ErrorChannelFunction
    implements Cplex.MsgFunction {
        private ErrorChannelFunction() {
        }

        public void callIt(Object object, String string) {
            CplexI cplexI = (CplexI)object;
            cplexI._error = string;
        }
    }

    class GoalStack {
        public IloCplex.Goal _goal;
        public GoalStack _prev;

        public GoalStack(IloCplex.Goal goal, GoalStack goalStack) {
            this._goal = goal;
            this._prev = goalStack;
        }
    }
}

