/*
 * Decompiled with CFR 0.152.
 */
package lp;

import java.io.PrintStream;
import java.util.Random;
import java.util.StringTokenizer;
import lp.Ref;
import lp.Util;
import lp.constant;
import lp.lprec;
import lp.matrec;

public class solve
implements constant {
    lprec Lp;
    int Rows;
    int Columns;
    int Sum;
    int Non_zeros;
    int Level;
    matrec[] Mat;
    int[] Col_no;
    int[] Col_end;
    int[] Row_end;
    double[] Orig_rh;
    double[] Rh;
    double[] Rhs;
    short[] Must_be_int;
    double[] Orig_upbo;
    double[] Orig_lowbo;
    double[] Upbo;
    double[] Lowbo;
    int[] Bas;
    short[] Basis;
    short[] Lower;
    int Eta_alloc;
    int Eta_size;
    double[] Eta_value;
    int[] Eta_row_nr;
    int[] Eta_col_end;
    int Num_inv;
    double[] Solution;
    double[] Best_solution;
    double Infinite;
    double Epsilon;
    double Epsb;
    double Epsd;
    double Epsel;
    double TREJ;
    double TINV;
    short Maximise;
    short Floor_first;
    double Extrad;
    int Warn_count;
    short JustInverted;
    short Status;
    short Doiter;
    short DoInvert;
    short Break_bb;

    void inc_mat_space(lprec lprec2, int n) {
        if (lprec2.non_zeros + n > lprec2.mat_alloc) {
            lprec2.mat_alloc = lprec2.non_zeros + n;
            matrec[] matrecArray = lprec2.mat;
            lprec2.mat = new matrec[lprec2.mat_alloc];
            for (int i = matrecArray.length; i < lprec2.mat.length; ++i) {
                lprec2.mat[i] = new matrec(0, 0.0);
            }
            System.arraycopy(matrecArray, 0, lprec2.mat, 0, matrecArray.length);
            int[] nArray = lprec2.col_no;
            lprec2.col_no = new int[lprec2.mat_alloc];
            System.arraycopy(nArray, 0, lprec2.col_no, 0, nArray.length);
            if (lprec2.active != 0) {
                this.Mat = lprec2.mat;
                this.Col_no = lprec2.col_no;
            }
        }
    }

    void inc_row_space(lprec lprec2) {
        if (lprec2.rows > lprec2.rows_alloc) {
            lprec2.rows_alloc = lprec2.rows + 10;
            lprec2.sum_alloc = lprec2.rows_alloc + lprec2.columns_alloc;
            double[] dArray = lprec2.orig_rh;
            lprec2.orig_rh = new double[lprec2.rows_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.orig_rh, 0, dArray.length);
            dArray = lprec2.rh;
            lprec2.rh = new double[lprec2.rows_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.rh, 0, dArray.length);
            dArray = lprec2.rhs;
            lprec2.rhs = new double[lprec2.rows_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.rhs, 0, dArray.length);
            dArray = lprec2.orig_upbo;
            lprec2.orig_upbo = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.orig_upbo, 0, dArray.length);
            dArray = lprec2.upbo;
            lprec2.upbo = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.upbo, 0, dArray.length);
            dArray = lprec2.orig_lowbo;
            lprec2.orig_lowbo = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.orig_lowbo, 0, dArray.length);
            dArray = lprec2.lowbo;
            lprec2.lowbo = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.lowbo, 0, dArray.length);
            dArray = lprec2.solution;
            lprec2.solution = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.solution, 0, dArray.length);
            dArray = lprec2.best_solution;
            lprec2.best_solution = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.best_solution, 0, dArray.length);
            int[] nArray = lprec2.row_end;
            lprec2.row_end = new int[lprec2.rows_alloc + 1];
            System.arraycopy(nArray, 0, lprec2.row_end, 0, nArray.length);
            short[] sArray = lprec2.basis;
            lprec2.basis = new short[lprec2.sum_alloc + 1];
            System.arraycopy(sArray, 0, lprec2.basis, 0, sArray.length);
            sArray = lprec2.lower;
            lprec2.lower = new short[lprec2.sum_alloc + 1];
            System.arraycopy(sArray, 0, lprec2.lower, 0, sArray.length);
            sArray = lprec2.must_be_int;
            lprec2.must_be_int = new short[lprec2.sum_alloc + 1];
            System.arraycopy(sArray, 0, lprec2.must_be_int, 0, sArray.length);
            nArray = lprec2.bas;
            lprec2.bas = new int[lprec2.rows_alloc + 1];
            System.arraycopy(nArray, 0, lprec2.bas, 0, nArray.length);
            dArray = lprec2.duals;
            lprec2.duals = new double[lprec2.rows_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.duals, 0, dArray.length);
            sArray = lprec2.ch_sign;
            lprec2.ch_sign = new short[lprec2.rows_alloc + 1];
            System.arraycopy(sArray, 0, lprec2.ch_sign, 0, sArray.length);
            nArray = lprec2.eta_col_end;
            lprec2.eta_col_end = new int[lprec2.rows_alloc + lprec2.max_num_inv];
            System.arraycopy(nArray, 0, lprec2.eta_col_end, 0, nArray.length);
            if (lprec2.names_used != 0) {
                String[] stringArray = lprec2.row_name;
                lprec2.row_name = new String[lprec2.rows_alloc + 1];
                System.arraycopy(stringArray, 0, lprec2.row_name, 0, stringArray.length);
            }
            if (lprec2.scaling_used != 0) {
                dArray = lprec2.scale;
                lprec2.scale = new double[lprec2.sum_alloc + 1];
                System.arraycopy(dArray, 0, lprec2.scale, 0, dArray.length);
            }
            if (lprec2.active != 0) {
                this.set_globals(lprec2);
            }
        }
    }

    void inc_col_space(lprec lprec2) {
        if (lprec2.columns >= lprec2.columns_alloc) {
            lprec2.columns_alloc = lprec2.columns + 10;
            lprec2.sum_alloc = lprec2.rows_alloc + lprec2.columns_alloc;
            short[] sArray = lprec2.must_be_int;
            lprec2.must_be_int = new short[lprec2.sum_alloc + 1];
            System.arraycopy(sArray, 0, lprec2.must_be_int, 0, sArray.length);
            double[] dArray = lprec2.orig_upbo;
            lprec2.orig_upbo = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.orig_upbo, 0, dArray.length);
            dArray = lprec2.upbo;
            lprec2.upbo = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.upbo, 0, dArray.length);
            dArray = lprec2.orig_lowbo;
            lprec2.orig_lowbo = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.orig_lowbo, 0, dArray.length);
            dArray = lprec2.lowbo;
            lprec2.lowbo = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.lowbo, 0, dArray.length);
            dArray = lprec2.solution;
            lprec2.solution = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.solution, 0, dArray.length);
            dArray = lprec2.best_solution;
            lprec2.best_solution = new double[lprec2.sum_alloc + 1];
            System.arraycopy(dArray, 0, lprec2.best_solution, 0, dArray.length);
            sArray = lprec2.basis;
            lprec2.basis = new short[lprec2.sum_alloc + 1];
            System.arraycopy(sArray, 0, lprec2.basis, 0, sArray.length);
            sArray = lprec2.lower;
            lprec2.lower = new short[lprec2.sum_alloc + 1];
            System.arraycopy(sArray, 0, lprec2.lower, 0, sArray.length);
            if (lprec2.names_used != 0) {
                String[] stringArray = lprec2.col_name;
                lprec2.col_name = new String[lprec2.columns_alloc + 1];
                System.arraycopy(stringArray, 0, lprec2.col_name, 0, stringArray.length);
            }
            if (lprec2.scaling_used != 0) {
                dArray = lprec2.scale;
                lprec2.scale = new double[lprec2.sum_alloc + 1];
                System.arraycopy(dArray, 0, lprec2.scale, 0, dArray.length);
            }
            int[] nArray = lprec2.col_end;
            lprec2.col_end = new int[lprec2.columns_alloc + 1];
            System.arraycopy(nArray, 0, lprec2.col_end, 0, nArray.length);
            if (lprec2.active != 0) {
                this.set_globals(lprec2);
            }
        }
    }

    public void set_mat(lprec lprec2, int n, int n2, double d) {
        int n3;
        if (n > lprec2.rows || n < 0) {
            System.err.print("Row out of range");
        }
        if (n2 > lprec2.columns || n2 < 1) {
            System.err.print("Column out of range");
        }
        if (lprec2.scaling_used != 0) {
            d *= lprec2.scale[n] * lprec2.scale[lprec2.rows + n2];
        }
        if (lprec2.basis[n2] == 1 && n > 0) {
            lprec2.basis_valid = 0;
        }
        lprec2.eta_valid = 0;
        for (n3 = lprec2.col_end[n2 - 1]; n3 < lprec2.col_end[n2] && lprec2.mat[n3].row_nr != n; ++n3) {
        }
        if (n3 != lprec2.col_end[n2] && lprec2.mat[n3].row_nr == n) {
            lprec2.mat[n3].value = lprec2.scaling_used != 0 ? (lprec2.ch_sign[n] != 0 ? -d * lprec2.scale[n] * lprec2.scale[n2] : d * lprec2.scale[n] * lprec2.scale[n2]) : (lprec2.ch_sign[n] != 0 ? -d : d);
        } else {
            int n4;
            int n5;
            this.inc_mat_space(lprec2, 1);
            for (n5 = n4 = lprec2.non_zeros; n5 > n3; --n5) {
                lprec2.mat[n5] = lprec2.mat[n5 - 1];
            }
            n5 = n2;
            while (n5 <= lprec2.columns) {
                int n6 = n5++;
                lprec2.col_end[n6] = lprec2.col_end[n6] + 1;
            }
            lprec2.mat[n3].row_nr = n;
            lprec2.mat[n3].value = lprec2.scaling_used != 0 ? (lprec2.ch_sign[n] != 0 ? -d * lprec2.scale[n] * lprec2.scale[n2] : d * lprec2.scale[n] * lprec2.scale[n2]) : (lprec2.ch_sign[n] != 0 ? -d : d);
            lprec2.row_end_valid = 0;
            ++lprec2.non_zeros;
            if (lprec2.active != 0) {
                this.Non_zeros = lprec2.non_zeros;
            }
        }
    }

    public void set_obj_fn(lprec lprec2, double[] dArray) {
        for (int i = 1; i <= lprec2.columns; ++i) {
            this.set_mat(lprec2, 0, i, dArray[i]);
        }
    }

    public void str_set_obj_fn(lprec lprec2, String string) {
        double[] dArray = new double[lprec2.columns + 1];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n < lprec2.columns) {
            dArray[++n] = Double.valueOf(stringTokenizer.nextToken());
        }
        if (n < lprec2.columns) {
            System.err.println("Not enough numbers in the string in str_set_obj_fn");
            System.exit(-1);
        }
        this.set_obj_fn(lprec2, dArray);
    }

    public void add_constraint(lprec lprec2, double[] dArray, short s, double d) {
        int n;
        short[] sArray = new short[lprec2.columns + 1];
        for (n = 1; n <= lprec2.columns; ++n) {
            if (dArray[n] != 0.0) {
                sArray[n] = 1;
                ++lprec2.non_zeros;
                continue;
            }
            sArray[n] = 0;
        }
        matrec[] matrecArray = new matrec[lprec2.non_zeros];
        for (n = 0; n < matrecArray.length; ++n) {
            matrecArray[n] = new matrec(0, 0.0);
        }
        this.inc_mat_space(lprec2, 0);
        ++lprec2.rows;
        ++lprec2.sum;
        this.inc_row_space(lprec2);
        if (lprec2.scaling_used != 0) {
            for (n = lprec2.sum; n > lprec2.rows; --n) {
                lprec2.scale[n] = lprec2.scale[n - 1];
            }
            lprec2.scale[lprec2.rows] = 1.0;
        }
        if (lprec2.names_used != 0) {
            lprec2.row_name[lprec2.rows] = new String("r_" + lprec2.rows);
        }
        if (lprec2.scaling_used != 0 && lprec2.columns_scaled != 0) {
            for (n = 1; n <= lprec2.columns; ++n) {
                int n2 = n;
                dArray[n2] = dArray[n2] * lprec2.scale[lprec2.rows + n];
            }
        }
        lprec2.ch_sign[lprec2.rows] = s == 2 ? (short)1 : 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 1; n <= lprec2.columns; ++n) {
            for (int i = n4; i < lprec2.col_end[n]; ++i) {
                matrecArray[n3].row_nr = lprec2.mat[i].row_nr;
                matrecArray[n3].value = lprec2.mat[i].value;
                ++n3;
            }
            if (sArray[n] != 0) {
                matrecArray[n3].value = lprec2.ch_sign[lprec2.rows] != 0 ? -dArray[n] : dArray[n];
                matrecArray[n3].row_nr = lprec2.rows;
            }
            n4 = lprec2.col_end[n];
            lprec2.col_end[n] = ++n3;
        }
        lprec2.mat = matrecArray;
        for (n = lprec2.sum; n > lprec2.rows; --n) {
            lprec2.orig_upbo[n] = lprec2.orig_upbo[n - 1];
            lprec2.orig_lowbo[n] = lprec2.orig_lowbo[n - 1];
            lprec2.basis[n] = lprec2.basis[n - 1];
            lprec2.lower[n] = lprec2.lower[n - 1];
            lprec2.must_be_int[n] = lprec2.must_be_int[n - 1];
        }
        for (n = 1; n <= lprec2.rows; ++n) {
            if (lprec2.bas[n] < lprec2.rows) continue;
            int n5 = n;
            lprec2.bas[n5] = lprec2.bas[n5] + 1;
        }
        if (s == 0 || s == 2) {
            lprec2.orig_upbo[lprec2.rows] = lprec2.infinite;
        } else if (s == 1) {
            lprec2.orig_upbo[lprec2.rows] = 0.0;
        } else {
            System.err.print("Wrong constraint type\n");
            System.exit(-1);
        }
        lprec2.orig_lowbo[lprec2.rows] = 0.0;
        lprec2.orig_rh[lprec2.rows] = s == 2 && d != 0.0 ? -d : d;
        lprec2.row_end_valid = 0;
        lprec2.bas[lprec2.rows] = lprec2.rows;
        lprec2.basis[lprec2.rows] = 1;
        lprec2.lower[lprec2.rows] = 1;
        if (lprec2.active != 0) {
            this.set_globals(lprec2);
        }
        lprec2.eta_valid = 0;
    }

    public void str_add_constraint(lprec lprec2, String string, short s, double d) {
        int n = 0;
        double[] dArray = new double[lprec2.columns + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n < lprec2.columns) {
            dArray[++n] = Double.valueOf(stringTokenizer.nextToken());
        }
        this.add_constraint(lprec2, dArray, s, d);
    }

    public void del_constraint(lprec lprec2, int n) {
        int n2;
        if (n < 1 || n > lprec2.rows) {
            System.err.println("There is no constraint nr. " + n);
            System.exit(-1);
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            for (int i = n4; i < lprec2.col_end[n2]; ++i) {
                if (lprec2.mat[i].row_nr != n) {
                    lprec2.mat[n3] = lprec2.mat[i];
                    if (lprec2.mat[n3].row_nr > n) {
                        --lprec2.mat[n3].row_nr;
                    }
                    ++n3;
                    continue;
                }
                --lprec2.non_zeros;
            }
            n4 = lprec2.col_end[n2];
            lprec2.col_end[n2] = n3;
        }
        for (n2 = n; n2 < lprec2.rows; ++n2) {
            lprec2.orig_rh[n2] = lprec2.orig_rh[n2 + 1];
            lprec2.ch_sign[n2] = lprec2.ch_sign[n2 + 1];
            lprec2.bas[n2] = lprec2.bas[n2 + 1];
            if (lprec2.names_used == 0) continue;
            lprec2.row_name[n2] = lprec2.row_name[n2 + 1];
        }
        for (n2 = 1; n2 < lprec2.rows; ++n2) {
            if (lprec2.bas[n2] <= n) continue;
            int n5 = n2;
            lprec2.bas[n5] = lprec2.bas[n5] - 1;
        }
        for (n2 = n; n2 < lprec2.sum; ++n2) {
            lprec2.lower[n2] = lprec2.lower[n2 + 1];
            lprec2.basis[n2] = lprec2.basis[n2 + 1];
            lprec2.orig_upbo[n2] = lprec2.orig_upbo[n2 + 1];
            lprec2.orig_lowbo[n2] = lprec2.orig_lowbo[n2 + 1];
            lprec2.must_be_int[n2] = lprec2.must_be_int[n2 + 1];
            if (lprec2.scaling_used == 0) continue;
            lprec2.scale[n2] = lprec2.scale[n2 + 1];
        }
        --lprec2.rows;
        --lprec2.sum;
        lprec2.row_end_valid = 0;
        if (lprec2.active != 0) {
            this.set_globals(lprec2);
        }
        lprec2.eta_valid = 0;
        lprec2.basis_valid = 0;
    }

    public void add_lag_con(lprec lprec2, double[] dArray, short s, double d) {
        int n;
        double d2 = 0.0;
        if (s == 0 || s == 1) {
            d2 = 1.0;
        } else if (s == 2) {
            d2 = -1.0;
        } else {
            System.err.print("con_type not implemented\n");
        }
        ++lprec2.nr_lagrange;
        if (lprec2.nr_lagrange == 1) {
            lprec2.lag_row = new double[lprec2.nr_lagrange][];
            lprec2.lag_rhs = new double[lprec2.nr_lagrange];
            lprec2.lambda = new double[lprec2.nr_lagrange];
            lprec2.lag_con_type = new short[lprec2.nr_lagrange];
            for (n = 0; n < lprec2.nr_lagrange; ++n) {
                lprec2.lag_rhs[n] = 0.0;
                lprec2.lambda[n] = 0.0;
                lprec2.lag_con_type[n] = 0;
            }
        } else {
            double[][] dArray2 = lprec2.lag_row;
            lprec2.lag_row = new double[lprec2.nr_lagrange][];
            System.arraycopy(dArray2, 0, lprec2.lag_row, 0, dArray2.length);
            double[] dArray3 = lprec2.lag_rhs;
            lprec2.lag_rhs = new double[lprec2.nr_lagrange];
            System.arraycopy(dArray3, 0, lprec2.lag_rhs, 0, dArray3.length);
            dArray3 = lprec2.lambda;
            lprec2.lambda = new double[lprec2.nr_lagrange];
            System.arraycopy(dArray3, 0, lprec2.lambda, 0, dArray3.length);
            short[] sArray = lprec2.lag_con_type;
            lprec2.lag_con_type = new short[lprec2.nr_lagrange];
            System.arraycopy(sArray, 0, lprec2.lag_con_type, 0, sArray.length);
        }
        lprec2.lag_row[lprec2.nr_lagrange - 1] = new double[lprec2.columns + 1];
        lprec2.lag_rhs[lprec2.nr_lagrange - 1] = d * d2;
        for (n = 1; n <= lprec2.columns; ++n) {
            lprec2.lag_row[lprec2.nr_lagrange - 1][n] = dArray[n] * d2;
        }
        lprec2.lambda[lprec2.nr_lagrange - 1] = 0.0;
        lprec2.lag_con_type[lprec2.nr_lagrange - 1] = s == 1 ? (short)1 : 0;
    }

    public void str_add_lag_con(lprec lprec2, String string, short s, double d) {
        int n = 0;
        double[] dArray = new double[lprec2.columns + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n < lprec2.columns) {
            dArray[++n] = Double.valueOf(stringTokenizer.nextToken());
        }
        if (n < lprec2.columns) {
            System.err.println("not enough value for str_add_lag_con");
            System.exit(-1);
        }
        this.add_lag_con(lprec2, dArray, s, d);
    }

    public void add_column(lprec lprec2, double[] dArray) {
        int n;
        ++lprec2.columns;
        ++lprec2.sum;
        this.inc_col_space(lprec2);
        this.inc_mat_space(lprec2, lprec2.rows + 1);
        if (lprec2.scaling_used != 0) {
            for (n = 0; n <= lprec2.rows; ++n) {
                int n2 = n;
                dArray[n2] = dArray[n2] * lprec2.scale[n];
            }
            lprec2.scale[lprec2.sum] = 1.0;
        }
        int n3 = lprec2.col_end[lprec2.columns - 1];
        for (n = 0; n <= lprec2.rows; ++n) {
            if (dArray[n] == 0.0) continue;
            lprec2.mat[n3].row_nr = n;
            lprec2.mat[n3].value = lprec2.ch_sign[n] != 0 ? -dArray[n] : dArray[n];
            ++lprec2.non_zeros;
            ++n3;
        }
        lprec2.col_end[lprec2.columns] = n3;
        lprec2.orig_lowbo[lprec2.sum] = 0.0;
        lprec2.orig_upbo[lprec2.sum] = lprec2.infinite;
        lprec2.lower[lprec2.sum] = 1;
        lprec2.basis[lprec2.sum] = 0;
        lprec2.must_be_int[lprec2.sum] = 0;
        if (lprec2.names_used != 0) {
            lprec2.col_name[lprec2.columns] = new String("var_" + lprec2.columns);
        }
        lprec2.row_end_valid = 0;
        if (lprec2.active != 0) {
            this.Sum = lprec2.sum;
            this.Columns = lprec2.columns;
            this.Non_zeros = lprec2.non_zeros;
        }
    }

    public void str_add_column(lprec lprec2, String string) {
        int n = 0;
        double[] dArray = new double[lprec2.rows + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n < lprec2.rows) {
            dArray[++n] = Double.valueOf(stringTokenizer.nextToken());
        }
        if (n < lprec2.rows) {
            System.err.println("Bad String in str_add_column");
            System.exit(-1);
        }
        this.add_column(lprec2, dArray);
    }

    public void del_column(lprec lprec2, int n) {
        int n2;
        if (n > lprec2.columns || n < 1) {
            System.err.print("Column out of range in del_column");
        }
        for (n2 = 1; n2 <= lprec2.rows; ++n2) {
            if (lprec2.bas[n2] == lprec2.rows + n) {
                lprec2.basis_valid = 0;
                continue;
            }
            if (lprec2.bas[n2] <= lprec2.rows + n) continue;
            int n3 = n2;
            lprec2.bas[n3] = lprec2.bas[n3] - 1;
        }
        for (n2 = lprec2.rows + n; n2 < lprec2.sum; ++n2) {
            if (lprec2.names_used != 0) {
                lprec2.col_name[n2 - lprec2.rows] = lprec2.col_name[n2 - lprec2.rows + 1];
            }
            lprec2.must_be_int[n2] = lprec2.must_be_int[n2 + 1];
            lprec2.orig_upbo[n2] = lprec2.orig_upbo[n2 + 1];
            lprec2.orig_lowbo[n2] = lprec2.orig_lowbo[n2 + 1];
            lprec2.upbo[n2] = lprec2.upbo[n2 + 1];
            lprec2.lowbo[n2] = lprec2.lowbo[n2 + 1];
            lprec2.basis[n2] = lprec2.basis[n2 + 1];
            lprec2.lower[n2] = lprec2.lower[n2 + 1];
            if (lprec2.scaling_used == 0) continue;
            lprec2.scale[n2] = lprec2.scale[n2 + 1];
        }
        for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
            for (int i = n; i <= lprec2.columns; ++i) {
                lprec2.lag_row[n2][i] = lprec2.lag_row[n2][i + 1];
            }
        }
        int n4 = lprec2.col_end[n - 1];
        int n5 = lprec2.col_end[n];
        int n6 = n5 - n4;
        for (n2 = n5; n2 < lprec2.non_zeros; ++n2) {
            lprec2.mat[n4] = lprec2.mat[n2];
            ++n4;
        }
        for (n2 = n; n2 < lprec2.columns; ++n2) {
            lprec2.col_end[n2] = lprec2.col_end[n2 + 1] - n6;
        }
        lprec2.non_zeros -= n6;
        lprec2.row_end_valid = 0;
        lprec2.eta_valid = 0;
        --lprec2.sum;
        --lprec2.columns;
        if (lprec2.active != 0) {
            this.set_globals(lprec2);
        }
    }

    public void set_upbo(lprec lprec2, int n, double d) {
        if (n > lprec2.columns || n < 1) {
            System.err.print("Column out of range");
        }
        if (lprec2.scaling_used != 0) {
            d /= lprec2.scale[lprec2.rows + n];
        }
        if (d < lprec2.orig_lowbo[lprec2.rows + n]) {
            System.err.print("Upperbound must be >= lowerbound");
        }
        lprec2.eta_valid = 0;
        lprec2.orig_upbo[lprec2.rows + n] = d;
    }

    public void set_lowbo(lprec lprec2, int n, double d) {
        if (n > lprec2.columns || n < 1) {
            System.err.print("Column out of range");
        }
        if (lprec2.scaling_used != 0) {
            d /= lprec2.scale[lprec2.rows + n];
        }
        if (d > lprec2.orig_upbo[lprec2.rows + n]) {
            System.err.print("Upperbound must be >= lowerbound");
        }
        lprec2.eta_valid = 0;
        lprec2.orig_lowbo[lprec2.rows + n] = d;
    }

    public void set_int(lprec lprec2, int n, short s) {
        if (n > lprec2.columns || n < 1) {
            System.err.print("Column out of range");
        }
        lprec2.must_be_int[lprec2.rows + n] = s;
        if (s == 1 && lprec2.columns_scaled != 0) {
            this.unscale_columns(lprec2);
        }
    }

    public void set_rh(lprec lprec2, int n, double d) {
        if (n > lprec2.rows || n < 0) {
            System.err.print("Row out of Range");
        }
        if (n == 0) {
            System.err.println("Warning: attempt to set RHS of objective function, ignored");
            return;
        }
        lprec2.orig_rh[n] = lprec2.scaling_used != 0 ? (lprec2.ch_sign[n] != 0 ? -d * lprec2.scale[n] : d * lprec2.scale[n]) : (lprec2.ch_sign[n] != 0 ? -d : d);
        lprec2.eta_valid = 0;
    }

    public void set_rh_vec(lprec lprec2, double[] dArray) {
        if (lprec2.scaling_used != 0) {
            for (int i = 1; i <= lprec2.rows; ++i) {
                lprec2.orig_rh[i] = lprec2.ch_sign[i] != 0 ? -dArray[i] * lprec2.scale[i] : dArray[i] * lprec2.scale[i];
            }
        } else {
            for (int i = 1; i <= lprec2.rows; ++i) {
                lprec2.orig_rh[i] = lprec2.ch_sign[i] != 0 ? -dArray[i] : dArray[i];
            }
        }
        lprec2.eta_valid = 0;
    }

    public void str_set_rh_vec(lprec lprec2, String string) {
        int n = 0;
        double[] dArray = new double[lprec2.rows + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n < lprec2.rows) {
            dArray[++n] = Double.valueOf(stringTokenizer.nextToken());
        }
        this.set_rh_vec(lprec2, dArray);
    }

    public void set_maxim(lprec lprec2) {
        if (lprec2.maximise == 0) {
            for (int i = 0; i < lprec2.non_zeros; ++i) {
                if (lprec2.mat[i].row_nr != 0) continue;
                lprec2.mat[i].value *= -1.0;
            }
            lprec2.eta_valid = 0;
        }
        lprec2.maximise = 1;
        lprec2.ch_sign[0] = 1;
        if (lprec2.active != 0) {
            this.Maximise = 1;
        }
    }

    public void set_minim(lprec lprec2) {
        if (lprec2.maximise == 1) {
            for (int i = 0; i < lprec2.non_zeros; ++i) {
                if (lprec2.mat[i].row_nr != 0) continue;
                lprec2.mat[i].value = -lprec2.mat[i].value;
            }
            lprec2.eta_valid = 0;
        }
        lprec2.maximise = 0;
        lprec2.ch_sign[0] = 0;
        if (lprec2.active != 0) {
            this.Maximise = 0;
        }
    }

    public void set_constr_type(lprec lprec2, int n, short s) {
        if (n > lprec2.rows || n < 1) {
            System.err.print("Row out of Range");
        }
        if (s == 1) {
            lprec2.orig_upbo[n] = 0.0;
            lprec2.basis_valid = 0;
            if (lprec2.ch_sign[n] != 0) {
                for (int i = 0; i < lprec2.non_zeros; ++i) {
                    if (lprec2.mat[i].row_nr != n) continue;
                    lprec2.mat[i].value *= -1.0;
                }
                lprec2.eta_valid = 0;
                lprec2.ch_sign[n] = 0;
                if (lprec2.orig_rh[n] != 0.0) {
                    int n2 = n;
                    lprec2.orig_rh[n2] = lprec2.orig_rh[n2] * -1.0;
                }
            }
        } else if (s == 0) {
            lprec2.orig_upbo[n] = lprec2.infinite;
            lprec2.basis_valid = 0;
            if (lprec2.ch_sign[n] != 0) {
                for (int i = 0; i < lprec2.non_zeros; ++i) {
                    if (lprec2.mat[i].row_nr != n) continue;
                    lprec2.mat[i].value *= -1.0;
                }
                lprec2.eta_valid = 0;
                lprec2.ch_sign[n] = 0;
                if (lprec2.orig_rh[n] != 0.0) {
                    int n3 = n;
                    lprec2.orig_rh[n3] = lprec2.orig_rh[n3] * -1.0;
                }
            }
        } else if (s == 2) {
            lprec2.orig_upbo[n] = lprec2.infinite;
            lprec2.basis_valid = 0;
            if (lprec2.ch_sign[n] == 0) {
                for (int i = 0; i < lprec2.non_zeros; ++i) {
                    if (lprec2.mat[i].row_nr != n) continue;
                    lprec2.mat[i].value *= -1.0;
                }
                lprec2.eta_valid = 0;
                lprec2.ch_sign[n] = 1;
                if (lprec2.orig_rh[n] != 0.0) {
                    int n4 = n;
                    lprec2.orig_rh[n4] = lprec2.orig_rh[n4] * -1.0;
                }
            }
        } else {
            System.err.print("Constraint type not (yet) implemented");
        }
    }

    public double mat_elm(lprec lprec2, int n, int n2) {
        int n3;
        if (n < 0 || n > lprec2.rows) {
            System.err.print("Row out of range in mat_elm");
        }
        if (n2 < 1 || n2 > lprec2.columns) {
            System.err.print("Column out of range in mat_elm");
        }
        double d = 0.0;
        for (n3 = lprec2.col_end[n2 - 1]; lprec2.mat[n3].row_nr != n && n3 < lprec2.col_end[n2]; ++n3) {
        }
        if (n3 != lprec2.col_end[n2]) {
            d = lprec2.mat[n3].value;
            if (lprec2.ch_sign[n] != 0) {
                d = -d;
            }
            if (lprec2.scaling_used != 0) {
                d /= lprec2.scale[n] * lprec2.scale[lprec2.rows + n2];
            }
        }
        return d;
    }

    public void get_row(lprec lprec2, int n, double[] dArray) {
        int n2;
        if (n < 0 || n > lprec2.rows) {
            System.err.print("Row nr. out of range in get_row");
        }
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            dArray[n2] = 0.0;
            for (int i = lprec2.col_end[n2 - 1]; i < lprec2.col_end[n2]; ++i) {
                if (lprec2.mat[i].row_nr != n) continue;
                dArray[n2] = lprec2.mat[i].value;
            }
            if (lprec2.scaling_used == 0) continue;
            int n3 = n2;
            dArray[n3] = dArray[n3] / (lprec2.scale[lprec2.rows + n2] * lprec2.scale[n]);
        }
        if (lprec2.ch_sign[n] != 0) {
            for (n2 = 0; n2 <= lprec2.columns; ++n2) {
                if (dArray[n2] == 0.0) continue;
                dArray[n2] = -dArray[n2];
            }
        }
    }

    public void get_column(lprec lprec2, int n, double[] dArray) {
        int n2;
        if (n < 1 || n > lprec2.columns) {
            System.err.print("Col. nr. out of range in get_column");
        }
        for (n2 = 0; n2 <= lprec2.rows; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = lprec2.col_end[n - 1]; n2 < lprec2.col_end[n]; ++n2) {
            dArray[lprec2.mat[n2].row_nr] = lprec2.mat[n2].value;
        }
        for (n2 = 0; n2 <= lprec2.rows; ++n2) {
            if (dArray[n2] == 0.0) continue;
            if (lprec2.ch_sign[n2] != 0) {
                int n3 = n2;
                dArray[n3] = dArray[n3] * -1.0;
            }
            if (lprec2.scaling_used == 0) continue;
            int n4 = n2;
            dArray[n4] = dArray[n4] / (lprec2.scale[n2] * lprec2.scale[lprec2.rows + n]);
        }
    }

    public void get_reduced_costs(lprec lprec2, double[] dArray) {
        int n;
        if (lprec2.basis_valid == 0) {
            System.err.print("Not a valid basis in get_reduced_costs");
        }
        this.set_globals(lprec2);
        if (lprec2.eta_valid == 0) {
            this.invert();
        }
        for (n = 1; n <= lprec2.sum; ++n) {
            dArray[n] = 0.0;
        }
        dArray[0] = 1.0;
        this.btran(dArray);
        for (n = 1; n <= lprec2.columns; ++n) {
            int n2 = lprec2.rows + n;
            if (this.Basis[n2] != 0 || !(this.Upbo[n2] > 0.0)) continue;
            double d = 0.0;
            for (int i = this.Col_end[n - 1]; i < this.Col_end[n]; ++i) {
                d += dArray[this.Mat[i].row_nr] * this.Mat[i].value;
            }
            dArray[n2] = d;
        }
        for (n = 1; n <= this.Sum; ++n) {
            dArray[n] = Util.round(dArray[n], this.Epsd);
        }
    }

    short is_feasible(lprec lprec2, double[] dArray) {
        int n;
        if (lprec2.scaling_used != 0) {
            for (n = lprec2.rows + 1; n <= lprec2.sum; ++n) {
                if (!(dArray[n - lprec2.rows] < lprec2.orig_lowbo[n] * lprec2.scale[n]) && !(dArray[n - lprec2.rows] > lprec2.orig_upbo[n] * lprec2.scale[n])) continue;
                return 0;
            }
        } else {
            for (n = lprec2.rows + 1; n <= lprec2.sum; ++n) {
                if (!(dArray[n - lprec2.rows] < lprec2.orig_lowbo[n]) && !(dArray[n - lprec2.rows] > lprec2.orig_upbo[n])) continue;
                return 0;
            }
        }
        double[] dArray2 = new double[lprec2.rows + 1];
        for (n = 0; n <= lprec2.rows; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 1; n <= lprec2.columns; ++n) {
            for (int i = lprec2.col_end[n - 1]; i < lprec2.col_end[n]; ++i) {
                int n2 = lprec2.mat[i].row_nr;
                dArray2[n2] = dArray2[n2] + lprec2.mat[i].value * dArray[n];
            }
        }
        for (n = 1; n <= lprec2.rows; ++n) {
            double d = lprec2.orig_rh[n] - dArray2[n];
            d = Util.round(d, 0.001);
            if ((lprec2.orig_upbo[n] != 0.0 || d == 0.0) && !(d < 0.0)) continue;
            return 0;
        }
        return 1;
    }

    short column_in_lp(lprec lprec2, double[] dArray) {
        if (lprec2.scaling_used != 0) {
            for (int i = 1; i <= lprec2.columns; ++i) {
                boolean bl = true;
                for (int j = lprec2.col_end[i - 1]; bl && j < lprec2.col_end[i]; ++j) {
                    double d = lprec2.mat[j].value;
                    if (lprec2.ch_sign[lprec2.mat[j].row_nr] != 0) {
                        d = -d;
                    }
                    d /= lprec2.scale[lprec2.rows + i];
                    d /= lprec2.scale[lprec2.mat[j].row_nr];
                    if (!(Math.abs(d -= dArray[lprec2.mat[j].row_nr]) > 0.001)) continue;
                    bl = false;
                }
                if (!bl) continue;
                return 1;
            }
        } else {
            for (int i = 1; i <= lprec2.columns; ++i) {
                boolean bl = true;
                for (int j = lprec2.col_end[i - 1]; bl && j < lprec2.col_end[i]; ++j) {
                    double d = lprec2.mat[j].value;
                    if (lprec2.ch_sign[lprec2.mat[j].row_nr] != 0) {
                        d *= -1.0;
                    }
                    if (!(Math.abs(d -= dArray[lprec2.mat[j].row_nr]) > 0.001)) continue;
                    bl = false;
                }
                if (!bl) continue;
                return 1;
            }
        }
        return 0;
    }

    public void print_lp(lprec lprec2) {
        int n;
        int n2;
        double[] dArray = new double[(lprec2.rows + 1) * lprec2.columns];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = 0.0;
        }
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            for (n = lprec2.col_end[n2 - 1]; n < lprec2.col_end[n2]; ++n) {
                dArray[(n2 - 1) * (lprec2.rows + 1) + lprec2.mat[n].row_nr] = lprec2.mat[n].value;
            }
        }
        System.out.println("problem name: " + lprec2.lp_name);
        System.out.print("          ");
        for (n = 1; n <= lprec2.columns; ++n) {
            if (lprec2.names_used != 0) {
                System.out.print(lprec2.col_name[n]);
                continue;
            }
            System.out.print("Var[" + n + "] ");
        }
        if (lprec2.maximise != 0) {
            System.out.print("\nMaximise  ");
            for (n = 0; n < lprec2.columns; ++n) {
                System.out.print(" " + -dArray[n * (lprec2.rows + 1)] + " ");
            }
        } else {
            System.out.print("\nMinimize  ");
            for (n = 0; n < lprec2.columns; ++n) {
                System.out.print(" " + dArray[n * (lprec2.rows + 1)] + " ");
            }
        }
        System.out.print("\n");
        for (n2 = 1; n2 <= lprec2.rows; ++n2) {
            if (lprec2.names_used != 0) {
                System.out.print(lprec2.row_name[n2]);
            } else {
                System.out.print("Row[" + n2 + "]  ");
            }
            for (n = 0; n < lprec2.columns; ++n) {
                if (lprec2.ch_sign[n2] != 0 && dArray[n * (lprec2.rows + 1) + n2] != 0.0) {
                    System.out.print(-dArray[n * (lprec2.rows + 1) + n2] + " ");
                    continue;
                }
                System.out.print(dArray[n * (lprec2.rows + 1) + n2] + " ");
            }
            if (lprec2.orig_upbo[n2] == lprec2.infinite) {
                if (lprec2.ch_sign[n2] != 0) {
                    System.out.print(">= ");
                } else {
                    System.out.print("<= ");
                }
            } else {
                System.out.print(" = ");
            }
            if (lprec2.ch_sign[n2] != 0) {
                System.out.println(-lprec2.orig_rh[n2]);
                continue;
            }
            System.out.println(lprec2.orig_rh[n2]);
        }
        System.out.print("Type      ");
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            if (lprec2.must_be_int[lprec2.rows + n2] == 1) {
                System.out.print("     Int ");
                continue;
            }
            System.out.print("    double ");
        }
        System.out.print("\nupbo      ");
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            if (lprec2.orig_upbo[lprec2.rows + n2] == lprec2.infinite) {
                System.out.print("     Inf ");
                continue;
            }
            System.out.print(lprec2.orig_upbo[lprec2.rows + n2] + " ");
        }
        System.out.print("\nlowbo     ");
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            System.out.print(lprec2.orig_lowbo[lprec2.rows + n2] + " ");
        }
        System.out.print("\n");
        for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
            System.out.print("lag[" + n2 + "]  ");
            for (n = 1; n <= lprec2.columns; ++n) {
                System.out.print(lprec2.lag_row[n2][n] + " ");
            }
            if (lprec2.orig_upbo[n2] == lprec2.infinite) {
                if (lprec2.lag_con_type[n2] == 2) {
                    System.out.print(">= ");
                } else if (lprec2.lag_con_type[n2] == 0) {
                    System.out.print("<= ");
                } else if (lprec2.lag_con_type[n2] == 1) {
                    System.out.print(" = ");
                }
            }
            System.out.println(lprec2.lag_rhs[n2]);
        }
    }

    public void set_row_name(lprec lprec2, int n, String string) {
        if (lprec2.names_used == 0) {
            int n2;
            lprec2.row_name = new String[lprec2.rows_alloc + 1];
            lprec2.col_name = new String[lprec2.columns_alloc + 1];
            lprec2.names_used = 1;
            for (n2 = 0; n2 <= lprec2.rows; ++n2) {
                lprec2.row_name[n2] = new String("r_" + n2);
            }
            for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                lprec2.col_name[n2] = new String("var_" + n2);
            }
        }
        lprec2.row_name[n] = string;
    }

    public void set_col_name(lprec lprec2, int n, String string) {
        if (lprec2.names_used == 0) {
            int n2;
            lprec2.row_name = new String[lprec2.rows_alloc + 1];
            lprec2.col_name = new String[lprec2.columns_alloc + 1];
            lprec2.names_used = 1;
            for (n2 = 0; n2 <= lprec2.rows; ++n2) {
                lprec2.row_name[n2] = new String("r_" + n2);
            }
            for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                lprec2.col_name[n2] = new String("var_" + n2);
            }
        }
        lprec2.col_name[n] = string;
    }

    private double minmax_to_scale(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            return 1.0;
        }
        double d3 = 1.0 / Math.pow(Math.E, (Math.log(d) + Math.log(d2)) / 2.0);
        return d3;
    }

    public void unscale_columns(lprec lprec2) {
        int n;
        for (int i = 1; i <= lprec2.columns; ++i) {
            for (n = lprec2.col_end[i - 1]; n < lprec2.col_end[i]; ++n) {
                lprec2.mat[n].value /= lprec2.scale[lprec2.rows + i];
            }
        }
        for (n = lprec2.rows + 1; n < lprec2.sum; ++n) {
            if (lprec2.orig_lowbo[n] != 0.0) {
                int n2 = n;
                lprec2.orig_lowbo[n2] = lprec2.orig_lowbo[n2] * lprec2.scale[n];
            }
            if (lprec2.orig_upbo[n] == lprec2.infinite) continue;
            int n3 = n;
            lprec2.orig_upbo[n3] = lprec2.orig_upbo[n3] * lprec2.scale[n];
        }
        for (n = lprec2.rows + 1; n <= lprec2.sum; ++n) {
            lprec2.scale[n] = 1.0;
        }
        lprec2.columns_scaled = 0;
        lprec2.eta_valid = 0;
    }

    public void unscale(lprec lprec2) {
        if (lprec2.scaling_used != 0) {
            int n;
            int n2;
            for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                for (n = lprec2.col_end[n2 - 1]; n < lprec2.col_end[n2]; ++n) {
                    lprec2.mat[n].value /= lprec2.scale[lprec2.rows + n2];
                }
            }
            for (n = lprec2.rows + 1; n < lprec2.sum; ++n) {
                if (lprec2.orig_lowbo[n] != 0.0) {
                    int n3 = n;
                    lprec2.orig_lowbo[n3] = lprec2.orig_lowbo[n3] * lprec2.scale[n];
                }
                if (lprec2.orig_upbo[n] == lprec2.infinite) continue;
                int n4 = n;
                lprec2.orig_upbo[n4] = lprec2.orig_upbo[n4] * lprec2.scale[n];
            }
            for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                for (n = lprec2.col_end[n2 - 1]; n < lprec2.col_end[n2]; ++n) {
                    lprec2.mat[n].value /= lprec2.scale[lprec2.mat[n].row_nr];
                }
            }
            for (n = 0; n <= lprec2.rows; ++n) {
                int n5 = n;
                lprec2.orig_rh[n5] = lprec2.orig_rh[n5] / lprec2.scale[n];
            }
            lprec2.scaling_used = 0;
            lprec2.eta_valid = 0;
        }
    }

    public void auto_scale(lprec lprec2) {
        int n;
        int n2;
        if (lprec2.scaling_used == 0) {
            lprec2.scale = new double[lprec2.sum_alloc + 1];
            for (n2 = 0; n2 <= lprec2.sum; ++n2) {
                lprec2.scale[n2] = 1.0;
            }
        }
        double[] dArray = new double[lprec2.rows + 1];
        double[] dArray2 = new double[lprec2.rows + 1];
        double[] dArray3 = new double[lprec2.sum + 1];
        for (n2 = 0; n2 <= lprec2.rows; ++n2) {
            dArray[n2] = 0.0;
            dArray2[n2] = lprec2.infinite;
        }
        for (n = 1; n <= lprec2.columns; ++n) {
            for (n2 = lprec2.col_end[n - 1]; n2 < lprec2.col_end[n]; ++n2) {
                int n3 = lprec2.mat[n2].row_nr;
                double d = Math.abs(lprec2.mat[n2].value);
                if (d == 0.0) continue;
                dArray[n3] = Math.max(dArray[n3], d);
                dArray2[n3] = Math.min(dArray2[n3], d);
            }
        }
        for (n2 = 0; n2 <= lprec2.rows; ++n2) {
            dArray3[n2] = this.minmax_to_scale(dArray2[n2], dArray[n2]);
            int n4 = n2;
            lprec2.scale[n4] = lprec2.scale[n4] * dArray3[n2];
        }
        for (n = 1; n <= lprec2.columns; ++n) {
            for (n2 = lprec2.col_end[n - 1]; n2 < lprec2.col_end[n]; ++n2) {
                lprec2.mat[n2].value *= dArray3[lprec2.mat[n2].row_nr];
            }
        }
        for (n2 = 0; n2 <= lprec2.rows; ++n2) {
            int n5 = n2;
            lprec2.orig_rh[n5] = lprec2.orig_rh[n5] * dArray3[n2];
        }
        short s = 0;
        for (n2 = lprec2.rows + 1; s == 0 && n2 <= lprec2.sum; ++n2) {
            s = lprec2.must_be_int[n2];
        }
        if (s == 0) {
            for (n = 1; n <= lprec2.columns; ++n) {
                double d = 0.0;
                double d2 = lprec2.infinite;
                for (n2 = lprec2.col_end[n - 1]; n2 < lprec2.col_end[n]; ++n2) {
                    if (lprec2.mat[n2].value == 0.0) continue;
                    d = Math.max(d, Math.abs(lprec2.mat[n2].value));
                    d2 = Math.min(d2, Math.abs(lprec2.mat[n2].value));
                }
                dArray3[lprec2.rows + n] = this.minmax_to_scale(d2, d);
                int n6 = lprec2.rows + n;
                lprec2.scale[n6] = lprec2.scale[n6] * dArray3[lprec2.rows + n];
            }
            for (n = 1; n <= lprec2.columns; ++n) {
                for (n2 = lprec2.col_end[n - 1]; n2 < lprec2.col_end[n]; ++n2) {
                    lprec2.mat[n2].value *= dArray3[lprec2.rows + n];
                }
            }
            for (n2 = lprec2.rows + 1; n2 < lprec2.sum; ++n2) {
                if (lprec2.orig_lowbo[n2] != 0.0) {
                    int n7 = n2;
                    lprec2.orig_lowbo[n7] = lprec2.orig_lowbo[n7] / dArray3[n2];
                }
                if (lprec2.orig_upbo[n2] == lprec2.infinite) continue;
                int n8 = n2;
                lprec2.orig_upbo[n8] = lprec2.orig_upbo[n8] / dArray3[n2];
            }
            lprec2.columns_scaled = 1;
        }
        lprec2.scaling_used = 1;
        lprec2.eta_valid = 0;
    }

    public void reset_basis(lprec lprec2) {
        lprec2.basis_valid = 0;
    }

    public void print_solution(lprec lprec2) {
        int n;
        System.out.println("Value of objective function: " + lprec2.best_solution[0]);
        for (n = 1; n <= lprec2.columns; ++n) {
            if (lprec2.names_used != 0) {
                System.out.println(lprec2.col_name[n] + " " + lprec2.best_solution[lprec2.rows + n]);
                continue;
            }
            System.out.println("Var [" + n + "]  " + lprec2.best_solution[lprec2.rows + n]);
        }
        if (lprec2.verbose != 0) {
            System.out.print("\nActual values of the constraints:\n");
            for (n = 1; n <= lprec2.rows; ++n) {
                if (lprec2.names_used != 0) {
                    System.out.println(lprec2.row_name[n] + " " + lprec2.best_solution[n]);
                    continue;
                }
                System.out.println("Row [" + n + "]  " + " " + lprec2.best_solution[n]);
            }
        }
        if (lprec2.verbose != 0 || lprec2.print_duals != 0) {
            if (lprec2.max_level != 1) {
                System.out.print("These are the duals from the node that gave the optimal solution.\n");
            } else {
                System.out.print("\nDual values:\n");
            }
            for (n = 1; n <= lprec2.rows; ++n) {
                if (lprec2.names_used != 0) {
                    System.out.println(lprec2.row_name[n] + " " + lprec2.duals[n]);
                    continue;
                }
                System.out.println("Row [" + n + "]  " + lprec2.duals[n]);
            }
        }
    }

    public void write_LP(lprec lprec2, PrintStream printStream) {
        int n;
        double[] dArray = new double[lprec2.columns + 1];
        if (lprec2.maximise != 0) {
            printStream.print("max:");
        } else {
            printStream.print("min:");
        }
        this.get_row(lprec2, 0, dArray);
        for (n = 1; n <= lprec2.columns; ++n) {
            if (dArray[n] == 0.0) continue;
            if (dArray[n] == -1.0) {
                printStream.print(" -");
            } else if (dArray[n] == 1.0) {
                printStream.print(" +");
            } else {
                printStream.print(dArray[n]);
            }
            if (lprec2.names_used != 0) {
                printStream.print(lprec2.col_name[n]);
                continue;
            }
            printStream.print("x" + n);
        }
        printStream.print(";\n");
        for (int i = 1; i <= lprec2.rows; ++i) {
            if (lprec2.names_used != 0) {
                printStream.print(lprec2.row_name[i]);
            }
            this.get_row(lprec2, i, dArray);
            for (n = 1; n <= lprec2.columns; ++n) {
                if (dArray[n] == 0.0) continue;
                if (dArray[n] == -1.0) {
                    printStream.print(" -");
                } else if (dArray[n] == 1.0) {
                    printStream.print(" +");
                } else {
                    printStream.print(" " + dArray[n] + " ");
                }
                if (lprec2.names_used != 0) {
                    printStream.print(lprec2.col_name[n]);
                    continue;
                }
                printStream.print("x" + n);
            }
            if (lprec2.orig_upbo[i] == 0.0) {
                printStream.print(" =");
            } else if (lprec2.ch_sign[i] != 0) {
                printStream.print(" >");
            } else {
                printStream.print(" <");
            }
            if (lprec2.ch_sign[i] != 0) {
                printStream.println(" " + -lprec2.orig_rh[i]);
                continue;
            }
            printStream.println(" " + lprec2.orig_rh[i]);
        }
        for (n = lprec2.rows + 1; n <= lprec2.sum; ++n) {
            if (lprec2.orig_lowbo[n] != 0.0) {
                if (lprec2.names_used != 0) {
                    printStream.println(lprec2.col_name[n - lprec2.rows] + ">" + lprec2.orig_lowbo[n] + ";");
                } else {
                    printStream.print("x" + (n - lprec2.rows) + " > " + lprec2.orig_lowbo[n] + ";");
                }
            }
            if (lprec2.orig_upbo[n] == lprec2.infinite) continue;
            if (lprec2.names_used != 0) {
                printStream.println(lprec2.col_name[n - lprec2.rows] + " < " + lprec2.orig_upbo[n] + ";");
                continue;
            }
            printStream.println("x" + (n - lprec2.rows) + " < " + lprec2.orig_upbo[n] + ";");
        }
        for (n = 1; lprec2.must_be_int[lprec2.rows + n] == 0 && n <= lprec2.columns; ++n) {
        }
        if (n <= lprec2.columns) {
            if (lprec2.names_used != 0) {
                printStream.print("\nint " + lprec2.col_name[n]);
            } else {
                printStream.print("\nint x" + n);
            }
            ++n;
            while (n <= lprec2.columns) {
                if (lprec2.must_be_int[lprec2.rows + n] != 0) {
                    if (lprec2.names_used != 0) {
                        printStream.print("," + lprec2.col_name[n]);
                    } else {
                        printStream.print(", x" + n);
                    }
                }
                ++n;
            }
            printStream.print(";\n");
        }
    }

    public void print_duals(lprec lprec2) {
        for (int i = 1; i <= lprec2.rows; ++i) {
            if (lprec2.names_used != 0) {
                System.out.println(lprec2.row_name[i] + " [" + i + "] " + lprec2.duals[i]);
                continue;
            }
            System.out.println("Dual       [" + i + "] " + lprec2.duals[i]);
        }
    }

    public void print_scales(lprec lprec2) {
        if (lprec2.scaling_used != 0) {
            int n;
            for (n = 0; n <= lprec2.rows; ++n) {
                System.out.println("Row[" + n + "]    scaled at " + lprec2.scale[n]);
            }
            for (n = 1; n <= lprec2.columns; ++n) {
                System.out.println("Column[" + n + "] scaled at " + lprec2.scale[lprec2.rows + n]);
            }
        }
    }

    private void print_indent() {
        System.out.print(this.Level);
        if (this.Level < 50) {
            for (int i = this.Level; i > 0; --i) {
                System.out.print("--");
            }
        } else {
            System.out.print(" *** too deep ***");
        }
        System.out.print("> ");
    }

    public void debug_print_solution() {
        if (this.Lp.debug != 0) {
            for (int i = this.Rows + 1; i <= this.Sum; ++i) {
                this.print_indent();
                if (this.Lp.names_used != 0) {
                    System.out.println(this.Lp.col_name[i - this.Rows] + " " + this.Solution[i]);
                    continue;
                }
                System.out.println("Var[" + (i - this.Rows) + "]   " + this.Solution[i]);
            }
        }
    }

    public void debug_print_bounds(double[] dArray, double[] dArray2) {
        if (this.Lp.debug != 0) {
            for (int i = this.Rows + 1; i <= this.Sum; ++i) {
                if (dArray2[i] != 0.0) {
                    this.print_indent();
                    if (this.Lp.names_used != 0) {
                        System.out.println(this.Lp.col_name[i - this.Rows] + " > " + dArray2[i]);
                    } else {
                        System.out.print("Var[" + (i - this.Rows) + "]  > " + dArray2[i]);
                    }
                }
                if (dArray[i] == this.Infinite) continue;
                this.print_indent();
                if (this.Lp.names_used != 0) {
                    System.out.println(this.Lp.col_name[i - this.Rows] + " < " + dArray[i]);
                    continue;
                }
                System.out.println("Var[" + (i - this.Rows) + "]  < " + dArray[i]);
            }
        }
    }

    public void debug_print(String string) {
        if (this.Lp.debug != 0) {
            this.print_indent();
            System.out.print(string);
        }
    }

    void set_globals(lprec lprec2) {
        if (this.Lp != null) {
            this.Lp.active = 0;
        }
        this.Lp = lprec2;
        this.Rows = lprec2.rows;
        this.Columns = lprec2.columns;
        this.Sum = this.Rows + this.Columns;
        this.Non_zeros = lprec2.non_zeros;
        this.Mat = lprec2.mat;
        this.Col_no = lprec2.col_no;
        this.Col_end = lprec2.col_end;
        this.Row_end = lprec2.row_end;
        this.Rh = lprec2.rh;
        this.Rhs = lprec2.rhs;
        this.Orig_rh = lprec2.orig_rh;
        this.Must_be_int = lprec2.must_be_int;
        this.Orig_upbo = lprec2.orig_upbo;
        this.Orig_lowbo = lprec2.orig_lowbo;
        this.Upbo = lprec2.upbo;
        this.Lowbo = lprec2.lowbo;
        this.Bas = lprec2.bas;
        this.Basis = lprec2.basis;
        this.Lower = lprec2.lower;
        this.Eta_alloc = lprec2.eta_alloc;
        this.Eta_size = lprec2.eta_size;
        this.Num_inv = lprec2.num_inv;
        this.Eta_value = lprec2.eta_value;
        this.Eta_row_nr = lprec2.eta_row_nr;
        this.Eta_col_end = lprec2.eta_col_end;
        this.Solution = lprec2.solution;
        this.Best_solution = lprec2.best_solution;
        this.Infinite = lprec2.infinite;
        this.Epsilon = lprec2.epsilon;
        this.Epsb = lprec2.epsb;
        this.Epsd = lprec2.epsd;
        this.Epsel = lprec2.epsel;
        this.TREJ = this.TREJ;
        this.TINV = this.TINV;
        this.Maximise = lprec2.maximise;
        this.Floor_first = lprec2.floor_first;
        lprec2.active = 1;
    }

    private void ftran(int n, int n2, double[] dArray) {
        int n3;
        for (n3 = n; n3 <= n2; ++n3) {
            int n4 = this.Eta_col_end[n3] - 1;
            int n5 = this.Eta_row_nr[n4];
            double d = dArray[n5];
            if (d != 0.0) {
                for (int i = this.Eta_col_end[n3 - 1]; i < n4; ++i) {
                    int n6 = this.Eta_row_nr[i];
                    dArray[n6] = dArray[n6] + d * this.Eta_value[i];
                }
            }
            int n7 = n5;
            dArray[n7] = dArray[n7] * this.Eta_value[n4];
        }
        for (n3 = 0; n3 <= this.Rows; ++n3) {
            Util.round(dArray[n3], this.Epsel);
        }
    }

    private void btran(double[] dArray) {
        for (int i = this.Eta_size; i >= 1; --i) {
            double d = 0.0;
            int n = this.Eta_col_end[i] - 1;
            for (int j = this.Eta_col_end[i - 1]; j <= n; ++j) {
                d += dArray[this.Eta_row_nr[j]] * this.Eta_value[j];
            }
            dArray[this.Eta_row_nr[n]] = d = Util.round(d, this.Epsel);
        }
    }

    static short Isvalid(lprec lprec2) {
        int n;
        int n2;
        int[] nArray;
        if (lprec2.row_end_valid == 0) {
            int[] nArray2 = new int[lprec2.rows + 1];
            nArray = new int[lprec2.rows + 1];
            for (n2 = 0; n2 <= lprec2.rows; ++n2) {
                nArray2[n2] = 0;
                nArray[n2] = 0;
            }
            for (n2 = 0; n2 < lprec2.non_zeros; ++n2) {
                int n3 = lprec2.mat[n2].row_nr;
                nArray[n3] = nArray[n3] + 1;
            }
            lprec2.row_end[0] = 0;
            for (n2 = 1; n2 <= lprec2.rows; ++n2) {
                lprec2.row_end[n2] = lprec2.row_end[n2 - 1] + nArray[n2];
            }
            for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                for (n = lprec2.col_end[n2 - 1]; n < lprec2.col_end[n2]; ++n) {
                    int n4 = lprec2.mat[n].row_nr;
                    if (n4 == 0) continue;
                    int n5 = n4;
                    nArray2[n5] = nArray2[n5] + 1;
                    lprec2.col_no[lprec2.row_end[n4 - 1] + nArray2[n4]] = n2;
                }
            }
            lprec2.row_end_valid = 1;
        }
        if (lprec2.valid != 0) {
            return 1;
        }
        nArray = new int[lprec2.rows + 1];
        for (n2 = 0; n2 <= lprec2.rows; ++n2) {
            nArray[n2] = 0;
        }
        int[] nArray3 = new int[lprec2.columns + 1];
        for (n2 = 0; n2 <= lprec2.columns; ++n2) {
            nArray3[n2] = 0;
        }
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            for (n = lprec2.col_end[n2 - 1]; n < lprec2.col_end[n2]; ++n) {
                int n6 = n2;
                nArray3[n6] = nArray3[n6] + 1;
                int n7 = lprec2.mat[n].row_nr;
                nArray[n7] = nArray[n7] + 1;
            }
        }
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            if (nArray3[n2] != 0) continue;
            if (lprec2.names_used != 0) {
                System.err.print("Warning: Variable " + lprec2.col_name[n2] + " not used in any constraints\n");
                continue;
            }
            System.err.print("Warning: Variable " + n2 + " not used in any constaints\n");
        }
        lprec2.valid = 1;
        return 1;
    }

    private void resize_eta() {
        this.Eta_alloc *= 2;
        double[] dArray = this.Eta_value;
        this.Eta_value = new double[this.Eta_alloc];
        System.arraycopy(dArray, 0, this.Eta_value, 0, dArray.length);
        this.Lp.eta_value = this.Eta_value;
        int[] nArray = this.Eta_row_nr;
        this.Eta_row_nr = new int[this.Eta_alloc];
        System.arraycopy(nArray, 0, this.Eta_row_nr, 0, nArray.length);
        this.Lp.eta_row_nr = this.Eta_row_nr;
    }

    private void condensecol(int n, double[] dArray) {
        int n2 = this.Eta_col_end[this.Eta_size];
        if (n2 + this.Rows + 2 > this.Eta_alloc) {
            this.resize_eta();
        }
        for (int i = 0; i <= this.Rows; ++i) {
            if (i == n || dArray[i] == 0.0) continue;
            this.Eta_row_nr[n2] = i;
            this.Eta_value[n2] = dArray[i];
            ++n2;
        }
        this.Eta_row_nr[n2] = n;
        this.Eta_value[n2] = dArray[n];
        this.Eta_col_end[this.Eta_size + 1] = ++n2;
    }

    private void addetacol() {
        double d;
        int n = this.Eta_col_end[this.Eta_size];
        ++this.Eta_size;
        int n2 = this.Eta_col_end[this.Eta_size];
        this.Eta_value[n2 - 1] = d = 1.0 / this.Eta_value[n2 - 1];
        int n3 = n;
        while (n3 < n2 - 1) {
            int n4 = n3++;
            this.Eta_value[n4] = this.Eta_value[n4] * -d;
        }
        this.JustInverted = 0;
    }

    private void setpivcol(short s, int n, double[] dArray) {
        int n2;
        double d = s != 0 ? 1.0 : -1.0;
        for (n2 = 0; n2 <= this.Rows; ++n2) {
            dArray[n2] = 0.0;
        }
        if (n > this.Rows) {
            int n3 = n - this.Rows;
            for (n2 = this.Col_end[n3 - 1]; n2 < this.Col_end[n3]; ++n2) {
                dArray[this.Mat[n2].row_nr] = this.Mat[n2].value * d;
            }
            dArray[0] = dArray[0] - this.Extrad * d;
        } else {
            dArray[n] = s != 0 ? 1.0 : -1.0;
        }
        this.ftran(1, this.Eta_size, dArray);
    }

    private void minoriteration(int n, int n2) {
        int n3;
        double d;
        int n4;
        double d2 = 0.0;
        int n5 = n + this.Rows;
        int n6 = n4 = this.Eta_col_end[this.Eta_size];
        ++this.Eta_size;
        if (this.Extrad != 0.0) {
            this.Eta_row_nr[n4] = 0;
            this.Eta_value[n4] = -this.Extrad;
            ++n4;
        }
        for (int i = this.Col_end[n - 1]; i < this.Col_end[n]; ++i) {
            int n7 = this.Mat[i].row_nr;
            if (n7 == 0 && this.Extrad != 0.0) {
                int n8 = this.Eta_col_end[this.Eta_size - 1];
                this.Eta_value[n8] = this.Eta_value[n8] + this.Mat[i].value;
                continue;
            }
            if (n7 != n2) {
                this.Eta_row_nr[n4] = n7;
                this.Eta_value[n4] = this.Mat[i].value;
                ++n4;
                continue;
            }
            d2 = this.Mat[i].value;
        }
        this.Eta_row_nr[n4] = n2;
        this.Eta_value[n4] = 1.0 / d2;
        ++n4;
        this.Rhs[n2] = d = this.Rhs[n2] / d2;
        for (n3 = n6; n3 < n4 - 1; ++n3) {
            int n9 = this.Eta_row_nr[n3];
            this.Rhs[n9] = this.Rhs[n9] - d * this.Eta_value[n3];
        }
        int n10 = this.Bas[n2];
        this.Bas[n2] = n5;
        this.Basis[n10] = 0;
        this.Basis[n5] = 1;
        n3 = n6;
        while (n3 < n4 - 1) {
            int n11 = n3++;
            this.Eta_value[n11] = this.Eta_value[n11] / -d2;
        }
        this.Eta_col_end[this.Eta_size] = n4;
    }

    private void rhsmincol(double d, int n, int n2) {
        if (n > this.Rows + 1) {
            System.err.print("Error: rhsmincol called with row_nr: " + n + ", rows: " + this.Rows + "\n");
            System.err.print("This indicates numerical instability\n");
            System.exit(-1);
        }
        int n3 = this.Eta_col_end[this.Eta_size];
        int n4 = this.Eta_col_end[this.Eta_size + 1];
        for (int i = n3; i < n4; ++i) {
            double d2 = this.Rhs[this.Eta_row_nr[i]] - d * this.Eta_value[i];
            this.Rhs[this.Eta_row_nr[i]] = d2 = Util.round(d2, this.Epsb);
        }
        this.Rhs[n] = d;
        int n5 = this.Bas[n];
        this.Bas[n] = n2;
        this.Basis[n5] = 0;
        this.Basis[n2] = 1;
    }

    void invert() {
        int n;
        double d;
        int n2;
        int n3;
        if (this.Lp.print_at_invert != 0) {
            System.out.print("Start Invert iter " + this.Lp.iter + " eta_size " + this.Eta_size + " rhs[0] " + -this.Rhs[0] + " \n");
        }
        int[] nArray = new int[this.Rows + 1];
        for (n3 = 0; n3 <= this.Rows; ++n3) {
            nArray[n3] = 0;
        }
        int[] nArray2 = new int[this.Rows + 1];
        for (n3 = 0; n3 <= this.Rows; ++n3) {
            nArray2[n3] = 0;
        }
        int[] nArray3 = new int[this.Rows + 1];
        for (n3 = 0; n3 <= this.Rows; ++n3) {
            nArray3[n3] = 0;
        }
        double[] dArray = new double[this.Rows + 1];
        for (n3 = 0; n3 <= this.Rows; ++n3) {
            dArray[n3] = 0.0;
        }
        short[] sArray = new short[this.Rows + 1];
        for (n3 = 0; n3 <= this.Rows; ++n3) {
            sArray[n3] = 1;
        }
        short[] sArray2 = new short[this.Columns + 1];
        for (n3 = 0; n3 < this.Columns; ++n3) {
            sArray2[n3] = 0;
        }
        int[] nArray4 = new int[this.Columns + 1];
        for (n3 = 0; n3 <= this.Columns; ++n3) {
            nArray4[n3] = 0;
        }
        for (n3 = 0; n3 <= this.Rows; ++n3) {
            if (this.Bas[n3] > this.Rows) {
                sArray2[this.Bas[n3] - this.Rows - 1] = 1;
                continue;
            }
            sArray[this.Bas[n3]] = 0;
        }
        for (n3 = 1; n3 <= this.Rows; ++n3) {
            if (sArray[n3] == 0) continue;
            for (n2 = this.Row_end[n3 - 1] + 1; n2 <= this.Row_end[n3]; ++n2) {
                int n4 = this.Col_no[n2];
                if (sArray2[n4 - 1] == 0) continue;
                int n5 = n4;
                nArray4[n5] = nArray4[n5] + 1;
                int n6 = n3 - 1;
                nArray[n6] = nArray[n6] + 1;
            }
        }
        for (n3 = 1; n3 <= this.Rows; ++n3) {
            this.Bas[n3] = n3;
        }
        for (n3 = 1; n3 <= this.Rows; ++n3) {
            this.Basis[n3] = 1;
        }
        for (n3 = 1; n3 <= this.Columns; ++n3) {
            this.Basis[n3 + this.Rows] = 0;
        }
        for (n3 = 0; n3 <= this.Rows; ++n3) {
            this.Rhs[n3] = this.Rh[n3];
        }
        for (n3 = 1; n3 <= this.Columns; ++n3) {
            int n7 = this.Rows + n3;
            if (this.Lower[n7] != 0) continue;
            d = this.Upbo[n7];
            for (n2 = this.Col_end[n3 - 1]; n2 < this.Col_end[n3]; ++n2) {
                int n8 = this.Mat[n2].row_nr;
                this.Rhs[n8] = this.Rhs[n8] - d * this.Mat[n2].value;
            }
        }
        for (n3 = 1; n3 <= this.Rows; ++n3) {
            if (this.Lower[n3] != 0) continue;
            int n9 = n3;
            this.Rhs[n9] = this.Rhs[n9] - this.Upbo[n3];
        }
        this.Eta_size = 0;
        int n10 = 0;
        int n11 = 0;
        this.Num_inv = 0;
        int n12 = 0;
        while (n10 < this.Rows) {
            if (++n11 > this.Rows) {
                n11 = 1;
            }
            ++n10;
            if (nArray[n11 - 1] != 1 || sArray[n11] == 0) continue;
            n10 = 0;
            n2 = this.Row_end[n11 - 1] + 1;
            while (sArray2[this.Col_no[n2] - 1] == 0) {
                ++n2;
            }
            n = this.Col_no[n2];
            sArray2[n - 1] = 0;
            nArray4[n] = 0;
            for (n2 = this.Col_end[n - 1]; n2 < this.Col_end[n]; ++n2) {
                if (sArray[this.Mat[n2].row_nr] == 0) continue;
                int n13 = this.Mat[n2].row_nr - 1;
                nArray[n13] = nArray[n13] - 1;
            }
            sArray[n11] = 0;
            this.minoriteration(n, n11);
        }
        n10 = 0;
        n = 0;
        while (n10 < this.Columns) {
            if (++n > this.Columns) {
                n = 1;
            }
            ++n10;
            if (nArray4[n] != 1 || sArray2[n - 1] == 0) continue;
            n10 = 0;
            n2 = this.Col_end[n - 1] + 1;
            while (sArray[this.Mat[n2 - 1].row_nr] == 0) {
                ++n2;
            }
            n11 = this.Mat[n2 - 1].row_nr;
            sArray[n11] = 0;
            nArray[n11 - 1] = 0;
            for (n2 = this.Row_end[n11 - 1] + 1; n2 <= this.Row_end[n11]; ++n2) {
                if (sArray2[this.Col_no[n2] - 1] == 0) continue;
                int n14 = this.Col_no[n2];
                nArray4[n14] = nArray4[n14] - 1;
            }
            sArray2[n - 1] = 0;
            nArray2[++n12 - 1] = n;
            nArray3[n12 - 1] = n11;
        }
        for (n2 = 1; n2 <= this.Columns; ++n2) {
            if (sArray2[n2 - 1] == 0) continue;
            sArray2[n2 - 1] = 0;
            this.setpivcol(this.Lower[this.Rows + n2], n2 + this.Rows, dArray);
            for (n11 = 1; (sArray[n11] == 0 || dArray[n11] == 0.0) && n11 <= this.Rows; ++n11) {
            }
            if (n11 == this.Rows + 1) {
                System.err.print("Inverting failed");
            }
            sArray[n11] = 0;
            this.condensecol(n11, dArray);
            d = this.Rhs[n11] / dArray[n11];
            this.rhsmincol(d, n11, this.Rows + n2);
            this.addetacol();
        }
        for (n3 = n12 - 1; n3 >= 0; --n3) {
            n = nArray2[n3];
            n11 = nArray3[n3];
            int n15 = n + this.Rows;
            for (n2 = 0; n2 <= this.Rows; ++n2) {
                dArray[n2] = 0.0;
            }
            for (n2 = this.Col_end[n - 1]; n2 < this.Col_end[n]; ++n2) {
                dArray[this.Mat[n2].row_nr] = this.Mat[n2].value;
            }
            dArray[0] = dArray[0] - this.Extrad;
            this.condensecol(n11, dArray);
            d = this.Rhs[n11] / dArray[n11];
            this.rhsmincol(d, n11, n15);
            this.addetacol();
        }
        for (n3 = 1; n3 <= this.Rows; ++n3) {
            this.Rhs[n3] = Util.round(this.Rhs[n3], this.Epsb);
        }
        if (this.Lp.print_at_invert != 0) {
            System.out.print("End Invert                eta_size " + this.Eta_size + " rhs[0] " + -this.Rhs[0] + "\n");
        }
        this.JustInverted = 1;
        this.DoInvert = 0;
    }

    private short colprim(Ref ref, short s, double[] dArray) {
        double d;
        int n;
        double d2 = -this.Epsd;
        ref.value = 0.0;
        if (s == 0) {
            for (n = 1; n <= this.Sum; ++n) {
                dArray[n] = 0.0;
            }
            dArray[0] = 1.0;
            this.btran(dArray);
            for (n = 1; n <= this.Columns; ++n) {
                int n2 = this.Rows + n;
                if (this.Basis[n2] != 0 || !(this.Upbo[n2] > 0.0)) continue;
                d = 0.0;
                for (int i = this.Col_end[n - 1]; i < this.Col_end[n]; ++i) {
                    d += dArray[this.Mat[i].row_nr] * this.Mat[i].value;
                }
                dArray[n2] = d;
            }
            for (n = 1; n <= this.Sum; ++n) {
                dArray[n] = Util.round(dArray[n], this.Epsd);
            }
        }
        for (n = 1; n <= this.Sum; ++n) {
            if (this.Basis[n] != 0 || !(this.Upbo[n] > 0.0) || !((d = this.Lower[n] != 0 ? dArray[n] : -dArray[n]) < d2)) continue;
            d2 = d;
            ref.value = n;
        }
        if (this.Lp.trace != 0) {
            if (ref.value > 0.0) {
                System.err.print("col_prim:" + ref.value + ", reduced cost: " + d2 + "\n");
            } else {
                System.err.print("col_prim: no negative reduced costs found, optimality!\n");
            }
        }
        if (ref.value == 0.0) {
            this.Doiter = 0;
            this.DoInvert = 0;
            this.Status = 0;
        }
        return ref.value > 0.0 ? (short)1 : 0;
    }

    private short rowprim(int n, Ref ref, Ref ref2, double[] dArray) {
        double d;
        int n2;
        double d2 = 0.0;
        ref.value = 0.0;
        ref2.value = this.Infinite;
        for (n2 = 1; n2 <= this.Rows; ++n2) {
            d2 = dArray[n2];
            if (Math.abs(d2) < this.TREJ) {
                d2 = 0.0;
            }
            if (d2 == 0.0) continue;
            d = 2.0 * this.Infinite;
            if (d2 > 0.0) {
                d = this.Rhs[n2] / d2;
            } else if (this.Upbo[this.Bas[n2]] < this.Infinite) {
                d = (this.Rhs[n2] - this.Upbo[this.Bas[n2]]) / d2;
            }
            Util.round(d, this.Epsel);
            if (!(d < ref2.value)) continue;
            ref2.value = d;
            ref.value = n2;
        }
        if (ref.value == 0.0) {
            for (n2 = 1; n2 <= this.Rows; ++n2) {
                d2 = dArray[n2];
                if (d2 == 0.0) continue;
                d = 2.0 * this.Infinite;
                if (d2 > 0.0) {
                    d = this.Rhs[n2] / d2;
                } else if (this.Upbo[this.Bas[n2]] < this.Infinite) {
                    d = (this.Rhs[n2] - this.Upbo[this.Bas[n2]]) / d2;
                }
                d = Util.round(d, this.Epsel);
                if (!(d < ref2.value)) continue;
                ref2.value = d;
                ref.value = n2;
            }
        }
        if (ref2.value < 0.0) {
            System.err.println("Warning: Numerical instability, qout = " + ref2.value);
            System.err.println("pcol[" + ref.value + "] = " + d2 + ", rhs[" + ref.value + "] = " + this.Rhs[(int)ref.value] + " , upbo = " + this.Upbo[this.Bas[(int)ref.value]]);
        }
        if (ref.value == 0.0) {
            if (this.Upbo[n] == this.Infinite) {
                this.Doiter = 0;
                this.DoInvert = 0;
                this.Status = (short)3;
            } else {
                for (n2 = 1; dArray[n2] >= 0.0 && n2 <= this.Rows; ++n2) {
                }
                if (n2 > this.Rows) {
                    this.Lower[n] = 0;
                    this.Rhs[0] = this.Rhs[0] + this.Upbo[n] * dArray[0];
                    this.Doiter = 0;
                    this.DoInvert = 0;
                } else if (dArray[n2] < 0.0) {
                    ref.value = n2;
                }
            }
        }
        if (ref.value > 0.0) {
            this.Doiter = 1;
        }
        if (this.Lp.trace != 0) {
            System.out.println("row_prim:" + ref.value + ", pivot element:" + dArray[(int)ref.value]);
        }
        return ref.value > 0.0 ? (short)1 : 0;
    }

    private short rowdual(Ref ref) {
        ref.value = 0.0;
        double d = -this.Epsb;
        int n = 0;
        boolean bl = false;
        while (n < this.Rows && !bl) {
            double d2;
            if ((d2 = this.Upbo[this.Bas[++n]]) == 0.0 && this.Rhs[n] != 0.0) {
                bl = true;
                ref.value = n;
                continue;
            }
            double d3 = this.Rhs[n] < d2 - this.Rhs[n] ? this.Rhs[n] : d2 - this.Rhs[n];
            if (!(d3 < d)) continue;
            d = d3;
            ref.value = n;
        }
        if (this.Lp.trace != 0) {
            if (ref.value > 0.0) {
                System.out.println("row_dual:" + ref.value + ", rhs of selected row:           " + this.Rhs[(int)ref.value]);
                if (this.Upbo[this.Bas[(int)ref.value]] < this.Infinite) {
                    System.out.println("               upper bound of basis variable:    " + this.Upbo[this.Bas[(int)ref.value]]);
                }
            } else {
                System.out.print("row_dual: no infeasibilities found\n");
            }
        }
        return ref.value > 0.0 ? (short)1 : 0;
    }

    private short coldual(int n, Ref ref, short s, double[] dArray, double[] dArray2) {
        double d;
        int n2;
        this.Doiter = 0;
        if (s == 0) {
            int n3;
            double d2;
            for (n2 = 0; n2 <= this.Rows; ++n2) {
                dArray[n2] = 0.0;
                dArray2[n2] = 0.0;
            }
            dArray2[0] = 1.0;
            dArray[n] = 1.0;
            for (n2 = this.Eta_size; n2 >= 1; --n2) {
                d = 0.0;
                d2 = 0.0;
                int n4 = this.Eta_row_nr[this.Eta_col_end[n2] - 1];
                for (n3 = this.Eta_col_end[n2 - 1]; n3 < this.Eta_col_end[n2]; ++n3) {
                    d2 += dArray[this.Eta_row_nr[n3]] * this.Eta_value[n3];
                    d += dArray2[this.Eta_row_nr[n3]] * this.Eta_value[n3];
                }
                dArray[n4] = d2 = Util.round(d2, this.Epsel);
                dArray2[n4] = d = Util.round(d, this.Epsel);
            }
            for (n2 = 1; n2 <= this.Columns; ++n2) {
                int n5 = this.Rows + n2;
                if (this.Basis[n5] != 0) continue;
                d = -this.Extrad * dArray2[0];
                d2 = 0.0;
                for (n3 = this.Col_end[n2 - 1]; n3 < this.Col_end[n2]; ++n3) {
                    d += dArray2[this.Mat[n3].row_nr] * this.Mat[n3].value;
                    d2 += dArray[this.Mat[n3].row_nr] * this.Mat[n3].value;
                }
                dArray2[n5] = d;
                dArray[n5] = d2;
            }
            for (n2 = 0; n2 <= this.Sum; ++n2) {
                dArray[n2] = Util.round(dArray[n2], this.Epsel);
                dArray2[n2] = Util.round(dArray2[n2], this.Epsd);
            }
        }
        double d3 = this.Rhs[n] > this.Upbo[this.Bas[n]] ? -1.0 : 1.0;
        double d4 = 0.0;
        ref.value = 0.0;
        double d5 = this.Infinite;
        for (n2 = 1; n2 <= this.Sum; ++n2) {
            d = this.Lower[n2] != 0 ? dArray[n2] * d3 : -dArray[n2] * d3;
            if (!(d < 0.0) || this.Basis[n2] != 0 || !(this.Upbo[n2] > 0.0)) continue;
            double d6 = this.Lower[n2] == 0 ? -dArray2[n2] / d : dArray2[n2] / d;
            if (d6 < d5) {
                d5 = d6;
                d4 = d;
                ref.value = n2;
                continue;
            }
            if (d6 != d5 || !(Math.abs(d) > Math.abs(d4))) continue;
            d4 = d;
            ref.value = n2;
        }
        if (this.Lp.trace != 0) {
            System.out.println("col_dual:" + ref.value + ", pivot element:  " + dArray[(int)ref.value]);
        }
        if (ref.value > 0.0) {
            this.Doiter = 1;
        }
        return ref.value > 0.0 ? (short)1 : 0;
    }

    private void iteration(int n, int n2, Ref ref, double d, Ref ref2, Ref ref3, short s, double[] dArray) {
        double d2;
        int n3;
        ++this.Lp.iter;
        double d3 = ref2.value = ref.value > d + this.Epsb ? 1.0 : 0.0;
        if (ref2.value != 0.0) {
            ref.value = d;
            ref3.value = ref3.value == 0.0 ? 1.0 : 0.0;
        }
        int n4 = this.Eta_col_end[this.Eta_size + 1];
        double d4 = this.Eta_value[n4 - 1];
        for (n3 = this.Eta_col_end[this.Eta_size]; n3 < n4; ++n3) {
            d2 = this.Rhs[this.Eta_row_nr[n3]] - ref.value * this.Eta_value[n3];
            this.Rhs[this.Eta_row_nr[n3]] = d2 = Util.round(d2, this.Epsb);
        }
        if (ref2.value == 0.0) {
            this.Rhs[n] = ref.value;
            int n5 = this.Bas[n];
            this.Bas[n] = n2;
            this.Basis[n5] = 0;
            this.Basis[n2] = 1;
            if (s != 0 && d4 < 0.0) {
                this.Lower[n5] = 0;
            }
            if (ref3.value == 0.0 && d < this.Infinite) {
                ref3.value = 1.0;
                this.Rhs[n] = d - this.Rhs[n];
                for (n3 = this.Eta_col_end[this.Eta_size]; n3 < n4; ++n3) {
                    this.Eta_value[n3] = -this.Eta_value[n3];
                }
            }
            this.addetacol();
            ++this.Num_inv;
        }
        if (this.Lp.trace != 0) {
            System.out.print("Theta = " + ref.value + " ");
            if (ref2.value != 0.0) {
                if (this.Lower[n2] == 0) {
                    System.out.print("Iteration:" + this.Lp.iter + ", variable" + n2 + " changed from 0 to its upper bound of " + this.Upbo[n2] + "\n");
                } else {
                    System.out.print("Iteration:" + this.Lp.iter + ", variable" + n2 + " changed its upper bound of " + this.Upbo[n2] + " to 0\n");
                }
            } else {
                System.out.print("Iteration:" + this.Lp.iter + ", variable" + n2 + " entered basis at:" + this.Rhs[n] + "\n");
            }
            if (s == 0) {
                d2 = 0.0;
                for (n3 = 1; n3 <= this.Rows; ++n3) {
                    if (this.Rhs[n3] < 0.0) {
                        d2 -= this.Rhs[n3];
                        continue;
                    }
                    if (!(this.Rhs[n3] > this.Upbo[this.Bas[n3]])) continue;
                    d2 += this.Rhs[n3] - this.Upbo[this.Bas[n3]];
                }
                System.out.println("feasibility gap of this basis:" + d2);
            } else {
                System.out.println("objective function value of this feasible basis: " + this.Rhs[0]);
            }
        }
    }

    private int solvelp() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        int n3 = 0;
        Ref ref = new Ref(0.0);
        Ref ref2 = new Ref(0.0);
        Ref ref3 = new Ref(0.0);
        double[] dArray = new double[this.Sum + 1];
        double[] dArray2 = new double[this.Sum + 1];
        double[] dArray3 = new double[this.Rows + 1];
        for (n = 0; n <= this.Sum; ++n) {
            dArray[n] = 0.0;
            dArray2[n] = 0.0;
        }
        for (n = 0; n <= this.Rows; ++n) {
            dArray3[n] = 0.0;
        }
        this.Lp.iter = 0;
        short s = 0;
        this.Status = (short)5;
        this.DoInvert = 0;
        this.Doiter = 0;
        n = 0;
        short s2 = 1;
        while (n != this.Rows && s2 != 0) {
            s2 = this.Rhs[++n] >= 0.0 && this.Rhs[n] <= this.Upbo[this.Bas[n]] ? (short)1 : 0;
        }
        if (this.Lp.trace != 0) {
            if (s2 != 0) {
                System.out.print("Start at feasible basis\n");
            } else {
                System.out.print("Start at infeasible basis\n");
            }
        }
        if (s2 == 0) {
            dArray[0] = 1.0;
            for (n = 1; n <= this.Rows; ++n) {
                dArray[n] = 0.0;
            }
            this.Extrad = 0.0;
            for (n = 1; n <= this.Columns; ++n) {
                int n4 = this.Rows + n;
                dArray[n4] = 0.0;
                for (int i = this.Col_end[n - 1]; i < this.Col_end[n]; ++i) {
                    if (dArray[this.Mat[i].row_nr] == 0.0) continue;
                    int n5 = n4;
                    dArray[n5] = dArray[n5] + dArray[this.Mat[i].row_nr] * this.Mat[i].value;
                }
                if (!(dArray[n4] < this.Extrad)) continue;
                this.Extrad = dArray[n4];
            }
        } else {
            this.Extrad = 0.0;
        }
        if (this.Lp.trace != 0) {
            System.out.println("Extrad = " + this.Extrad);
        }
        s = 0;
        while (this.Status == 5) {
            short s3;
            this.Doiter = 0;
            this.DoInvert = 0;
            this.construct_solution(this.Solution);
            this.debug_print_bounds(this.Upbo, this.Lowbo);
            this.debug_print_solution();
            if (s2 != 0) {
                ref.value = n2;
                s3 = this.colprim(ref, s, dArray);
                n2 = (int)ref.value;
                if (s3 != 0) {
                    this.setpivcol(this.Lower[n2], n2, dArray3);
                    ref.value = n3;
                    ref2.value = d2;
                    s3 = this.rowprim(n2, ref, ref2, dArray3);
                    n3 = (int)ref.value;
                    d2 = ref2.value;
                    if (s3 != 0) {
                        this.condensecol(n3, dArray3);
                    }
                }
            } else {
                if (s == 0) {
                    ref.value = n3;
                    s3 = this.rowdual(ref);
                    n3 = (int)ref.value;
                }
                if (n3 > 0) {
                    ref.value = n2;
                    s3 = this.coldual(n3, ref, s, dArray2, dArray);
                    n2 = (int)ref.value;
                    if (s3 != 0) {
                        this.setpivcol(this.Lower[n2], n2, dArray3);
                        if (dArray3[n3] == 0.0) {
                            System.err.println("An attempt was made to divide by zero (Pcol[" + n3 + "])");
                            System.err.println("This indicates numerical instability");
                            this.Doiter = 0;
                            if (this.JustInverted == 0) {
                                System.out.println("Reinverting Eta");
                                this.DoInvert = 1;
                            } else {
                                System.out.println("Can't reinvert, failure");
                                this.Status = (short)4;
                            }
                        } else {
                            this.condensecol(n3, dArray3);
                            d = this.Rhs[n3] - this.Upbo[this.Bas[n3]];
                            if (d > 0.0) {
                                d2 = d / dArray3[n3];
                                if (d2 <= this.Upbo[n2]) {
                                    this.Lower[this.Bas[n3]] = this.Lower[this.Bas[n3]] == 0 ? (short)1 : 0;
                                }
                            } else {
                                d2 = this.Rhs[n3] / dArray3[n3];
                            }
                        }
                    } else {
                        this.Status = (short)2;
                    }
                } else {
                    s2 = 1;
                    this.Doiter = 0;
                    this.Extrad = 0.0;
                    this.DoInvert = 1;
                }
            }
            if (this.Doiter != 0) {
                ref.value = d2;
                ref2.value = s;
                ref3.value = this.Lower[n2];
                this.iteration(n3, n2, ref, this.Upbo[n2], ref2, ref3, s2, dArray3);
                d2 = ref.value;
                s = (short)ref2.value;
                this.Lower[n2] = (short)ref3.value;
            }
            if (this.Num_inv >= this.Lp.max_num_inv) {
                this.DoInvert = 1;
            }
            if (this.DoInvert == 0) continue;
            if (this.Lp.print_at_invert != 0) {
                System.out.println("Inverting: Primal = " + s2);
            }
            this.invert();
        }
        this.Lp.total_iter += this.Lp.iter;
        return this.Status;
    }

    private short is_int(double d) {
        double d2 = d - Math.floor(d);
        if (d2 < this.Epsilon) {
            return 1;
        }
        if (d2 > 1.0 - this.Epsilon) {
            return 1;
        }
        return 0;
    }

    private void construct_solution(double[] dArray) {
        int n;
        for (n = 0; n <= this.Rows; ++n) {
            dArray[n] = 0.0;
        }
        if (this.Lp.scaling_used != 0) {
            for (n = this.Rows + 1; n <= this.Sum; ++n) {
                dArray[n] = this.Lowbo[n] * this.Lp.scale[n];
            }
            for (n = 1; n <= this.Rows; ++n) {
                int n2 = this.Bas[n];
                if (n2 <= this.Rows) continue;
                int n3 = n2;
                dArray[n3] = dArray[n3] + this.Rhs[n] * this.Lp.scale[n2];
            }
            for (n = this.Rows + 1; n <= this.Sum; ++n) {
                if (this.Basis[n] != 0 || this.Lower[n] != 0) continue;
                int n4 = n;
                dArray[n4] = dArray[n4] + this.Upbo[n] * this.Lp.scale[n];
            }
            for (int i = 1; i <= this.Columns; ++i) {
                double d = dArray[this.Rows + i];
                if (d == 0.0) continue;
                for (n = this.Col_end[i - 1]; n < this.Col_end[i]; ++n) {
                    int n5 = this.Mat[n].row_nr;
                    dArray[n5] = dArray[n5] + d / this.Lp.scale[this.Rows + i] * (this.Mat[n].value / this.Lp.scale[this.Mat[n].row_nr]);
                }
            }
            for (n = 0; n <= this.Rows; ++n) {
                if (Math.abs(dArray[n]) < this.Epsb) {
                    dArray[n] = 0.0;
                    continue;
                }
                if (this.Lp.ch_sign[n] == 0) continue;
                dArray[n] = -dArray[n];
            }
        } else {
            for (n = this.Rows + 1; n <= this.Sum; ++n) {
                dArray[n] = this.Lowbo[n];
            }
            for (n = 1; n <= this.Rows; ++n) {
                int n6 = this.Bas[n];
                if (n6 <= this.Rows) continue;
                int n7 = n6;
                dArray[n7] = dArray[n7] + this.Rhs[n];
            }
            for (n = this.Rows + 1; n <= this.Sum; ++n) {
                if (this.Basis[n] != 0 || this.Lower[n] != 0) continue;
                int n8 = n;
                dArray[n8] = dArray[n8] + this.Upbo[n];
            }
            for (int i = 1; i <= this.Columns; ++i) {
                double d = dArray[this.Rows + i];
                if (d == 0.0) continue;
                for (n = this.Col_end[i - 1]; n < this.Col_end[i]; ++n) {
                    int n9 = this.Mat[n].row_nr;
                    dArray[n9] = dArray[n9] + d * this.Mat[n].value;
                }
            }
            for (n = 0; n <= this.Rows; ++n) {
                if (Math.abs(dArray[n]) < this.Epsb) {
                    dArray[n] = 0.0;
                    continue;
                }
                if (this.Lp.ch_sign[n] == 0) continue;
                dArray[n] = -dArray[n];
            }
        }
    }

    private void calculate_duals() {
        int n;
        for (n = 1; n <= this.Rows; ++n) {
            this.Lp.duals[n] = 0.0;
        }
        this.Lp.duals[0] = 1.0;
        this.btran(this.Lp.duals);
        if (this.Lp.scaling_used != 0) {
            for (n = 1; n <= this.Rows; ++n) {
                int n2 = n;
                this.Lp.duals[n2] = this.Lp.duals[n2] * (this.Lp.scale[n] / this.Lp.scale[0]);
            }
        }
        for (n = 1; n <= this.Rows; ++n) {
            if (this.Lp.basis[n] != 0) {
                this.Lp.duals[n] = 0.0;
                continue;
            }
            if (this.Lp.ch_sign[0] != this.Lp.ch_sign[n]) continue;
            this.Lp.duals[n] = -this.Lp.duals[n];
        }
    }

    private int milpsolve(double[] dArray, double[] dArray2, short[] sArray, short[] sArray2, int[] nArray) {
        int n;
        double d;
        int n2;
        Random random = new Random();
        int n3 = 0;
        if (this.Break_bb != 0) {
            return 8;
        }
        ++this.Level;
        ++this.Lp.total_nodes;
        if (this.Level > this.Lp.max_level) {
            this.Lp.max_level = this.Level;
        }
        this.debug_print("starting solve\n");
        System.arraycopy(dArray, 0, this.Upbo, 0, this.Sum + 1);
        System.arraycopy(dArray2, 0, this.Lowbo, 0, this.Sum + 1);
        System.arraycopy(sArray, 0, this.Basis, 0, this.Sum + 1);
        System.arraycopy(sArray2, 0, this.Lower, 0, this.Sum + 1);
        System.arraycopy(nArray, 0, this.Bas, 0, this.Rows + 1);
        System.arraycopy(this.Orig_rh, 0, this.Rh, 0, this.Rows + 1);
        if (this.Lp.anti_degen != 0) {
            for (n2 = 1; n2 <= this.Columns; ++n2) {
                double d2 = random.nextDouble() * 0.001;
                if (d2 > this.Epsb) {
                    int n4 = n2 + this.Rows;
                    this.Lowbo[n4] = this.Lowbo[n4] - d2;
                }
                if (!((d2 = random.nextDouble() * 0.001) > this.Epsb)) continue;
                int n5 = n2 + this.Rows;
                this.Upbo[n5] = this.Upbo[n5] + d2;
            }
            this.Lp.eta_valid = 0;
        }
        if (this.Lp.eta_valid == 0) {
            for (n2 = 1; n2 <= this.Columns; ++n2) {
                if (this.Lowbo[this.Rows + n2] == 0.0) continue;
                d = this.Lowbo[this.Rows + n2];
                if (this.Upbo[this.Rows + n2] < this.Infinite) {
                    int n6 = this.Rows + n2;
                    this.Upbo[n6] = this.Upbo[n6] - d;
                }
                for (n = this.Col_end[n2 - 1]; n < this.Col_end[n2]; ++n) {
                    int n7 = this.Mat[n].row_nr;
                    this.Rh[n7] = this.Rh[n7] - d * this.Mat[n].value;
                }
            }
            this.invert();
            this.Lp.eta_valid = 1;
        }
        int n8 = this.solvelp();
        if (this.Lp.anti_degen != 0) {
            System.arraycopy(dArray, 0, this.Upbo, 0, this.Sum + 1);
            System.arraycopy(dArray2, 0, this.Lowbo, 0, this.Sum + 1);
            System.arraycopy(this.Orig_rh, 0, this.Rh, 0, this.Rows + 1);
            for (n2 = 1; n2 <= this.Columns; ++n2) {
                if (this.Lowbo[this.Rows + n2] == 0.0) continue;
                d = this.Lowbo[this.Rows + n2];
                if (this.Upbo[this.Rows + n2] < this.Infinite) {
                    int n9 = this.Rows + n2;
                    this.Upbo[n9] = this.Upbo[n9] - d;
                }
                for (n = this.Col_end[n2 - 1]; n < this.Col_end[n2]; ++n) {
                    int n10 = this.Mat[n].row_nr;
                    this.Rh[n10] = this.Rh[n10] - d * this.Mat[n].value;
                }
            }
            this.invert();
            this.Lp.eta_valid = 1;
            n8 = this.solvelp();
        }
        if (n8 != 0) {
            this.debug_print("this problem has no solution, it is " + (n8 == 3 ? "unbounded" : "infeasible"));
        }
        if (n8 == 2 && this.Lp.verbose != 0) {
            System.out.print("level" + this.Level + " INF\n");
        }
        if (n8 == 0) {
            boolean bl;
            this.construct_solution(this.Solution);
            this.debug_print("a solution was found\n");
            this.debug_print_solution();
            if (this.Maximise != 0) {
                bl = this.Solution[0] <= this.Best_solution[0];
            } else {
                boolean bl2 = bl = this.Solution[0] >= this.Best_solution[0];
            }
            if (bl) {
                if (this.Lp.verbose != 0) {
                    System.out.println("level" + this.Level + " OPT NOB value " + this.Solution[0] + " bound " + this.Best_solution[0]);
                }
                this.debug_print("but it was worse than the best sofar, discarded\n");
                --this.Level;
                return 1;
            }
            if (this.Lp.bb_rule == 0) {
                n3 = 0;
                for (n2 = this.Rows + 1; n2 <= this.Sum && n3 == 0; ++n2) {
                    if (this.Must_be_int[n2] == 0 || this.is_int(this.Solution[n2]) != 0) continue;
                    if (dArray2[n2] == dArray[n2]) {
                        System.err.println("Warning: integer var " + (n2 - this.Rows) + " is already fixed at " + dArray2[n2] + ", but has non-integer value " + this.Solution[n2]);
                        System.err.println("Perhaps the -e option should be used");
                        continue;
                    }
                    n3 = n2;
                }
            }
            if (this.Lp.bb_rule == 1) {
                int n11 = 0;
                for (n2 = this.Rows + 1; n2 <= this.Sum; ++n2) {
                    if (this.Must_be_int[n2] == 0 || this.is_int(this.Solution[n2]) != 0) continue;
                    ++n11;
                }
                if (n11 == 0) {
                    n3 = 0;
                } else {
                    int n12 = random.nextInt() % n11 + 1;
                    n2 = this.Rows + 1;
                    while (n12 > 0) {
                        if (this.Must_be_int[n2] != 0 && this.is_int(this.Solution[n2]) == 0) {
                            --n12;
                        }
                        ++n2;
                    }
                    n3 = n2 - 1;
                }
            }
            if (this.Lp.verbose == 1) {
                if (n3 != 0) {
                    System.out.println("level " + this.Level + " OPT     value " + this.Solution[0]);
                } else {
                    System.out.println("level " + this.Level + " OPT INT value " + this.Solution[0]);
                }
            }
            if (n3 != 0) {
                int n13;
                int n14;
                double[] dArray3 = new double[this.Sum + 1];
                double[] dArray4 = new double[this.Sum + 1];
                short[] sArray3 = new short[this.Sum + 1];
                short[] sArray4 = new short[this.Sum + 1];
                int[] nArray2 = new int[this.Rows + 1];
                System.arraycopy(dArray, 0, dArray3, 0, this.Sum + 1);
                System.arraycopy(dArray2, 0, dArray4, 0, this.Sum + 1);
                System.arraycopy(this.Lower, 0, sArray3, 0, this.Sum + 1);
                System.arraycopy(this.Basis, 0, sArray4, 0, this.Sum + 1);
                System.arraycopy(this.Bas, 0, nArray2, 0, this.Rows + 1);
                if (this.Lp.names_used != 0) {
                    this.debug_print("not enough ints. Selecting var " + this.Lp.col_name[n3 - this.Rows] + ", val: " + this.Solution[n3]);
                } else {
                    this.debug_print("not enough ints. Selecting Var [" + n3 + "], val: " + this.Solution[n3]);
                }
                this.debug_print("current bounds:\n");
                this.debug_print_bounds(dArray, dArray2);
                if (this.Floor_first != 0) {
                    double d3 = Math.ceil(this.Solution[n3]) - 1.0;
                    if (d3 < dArray2[n3]) {
                        this.debug_print("New upper bound value " + d3 + " conflicts with old lower bound " + dArray2[n3] + "\n");
                        n14 = 1;
                    } else {
                        dArray3[n3] = d3;
                        this.debug_print("starting first subproblem with bounds:");
                        this.debug_print_bounds(dArray3, dArray2);
                        this.Lp.eta_valid = 0;
                        n14 = this.milpsolve(dArray3, dArray2, sArray4, sArray3, nArray2);
                        this.Lp.eta_valid = 0;
                    }
                    d3 += 1.0;
                    if (d3 > dArray[n3]) {
                        this.debug_print("New lower bound value " + d3 + " conflicts with old upper bound " + dArray[n3] + "\n");
                        n13 = 1;
                    } else {
                        dArray4[n3] = d3;
                        this.debug_print("starting second subproblem with bounds:");
                        this.debug_print_bounds(dArray, dArray4);
                        this.Lp.eta_valid = 0;
                        n13 = this.milpsolve(dArray, dArray4, sArray4, sArray3, nArray2);
                        this.Lp.eta_valid = 0;
                    }
                } else {
                    double d4 = Math.ceil(this.Solution[n3]);
                    if (d4 > dArray[n3]) {
                        this.debug_print("New lower bound value " + d4 + " conflicts with old upper bound " + dArray[n3] + "\n");
                        n14 = 1;
                    } else {
                        dArray4[n3] = d4;
                        this.debug_print("starting first subproblem with bounds:");
                        this.debug_print_bounds(dArray, dArray4);
                        this.Lp.eta_valid = 0;
                        n14 = this.milpsolve(dArray, dArray4, sArray4, sArray3, nArray2);
                        this.Lp.eta_valid = 0;
                    }
                    d4 -= 1.0;
                    if (d4 < dArray2[n3]) {
                        this.debug_print("New upper bound value " + d4 + " conflicts with old lower bound " + dArray2[n3] + "\n");
                        n13 = 1;
                    } else {
                        dArray3[n3] = d4;
                        this.debug_print("starting second subproblem with bounds:");
                        this.debug_print_bounds(dArray3, dArray2);
                        this.Lp.eta_valid = 0;
                        n13 = this.milpsolve(dArray3, dArray2, sArray4, sArray3, nArray2);
                        this.Lp.eta_valid = 0;
                    }
                }
                n8 = n14 != 0 && n13 != 0 ? 2 : 0;
            } else {
                this.debug_print("--> valid solution found\n");
                if (this.Maximise != 0) {
                    bl = this.Solution[0] < this.Best_solution[0];
                } else {
                    boolean bl3 = bl = this.Solution[0] > this.Best_solution[0];
                }
                if (!bl) {
                    if (this.Lp.debug != 0 || this.Lp.verbose != 0 && this.Lp.print_sol == 0) {
                        System.out.print("*** new best solution: old: " + this.Best_solution[0] + ", new: " + this.Solution[0] + " ***\n");
                    }
                    System.arraycopy(this.Solution, 0, this.Best_solution, 0, this.Sum + 1);
                    this.calculate_duals();
                    if (this.Lp.print_sol != 0) {
                        this.print_solution(this.Lp);
                    }
                    if (this.Lp.break_at_int != 0) {
                        if (this.Maximise != 0 && this.Best_solution[0] > this.Lp.break_value) {
                            this.Break_bb = 1;
                        }
                        if (this.Maximise == 0 && this.Best_solution[0] < this.Lp.break_value) {
                            this.Break_bb = 1;
                        }
                    }
                }
            }
        }
        --this.Level;
        return n8;
    }

    public int solve(lprec lprec2) {
        if (lprec2.active == 0) {
            this.set_globals(lprec2);
        }
        lprec2.total_iter = 0;
        lprec2.max_level = 1;
        lprec2.total_nodes = 0;
        if (solve.Isvalid(lprec2) != 0) {
            this.Best_solution[0] = this.Maximise != 0 && lprec2.obj_bound == this.Infinite ? -this.Infinite : (this.Maximise == 0 && lprec2.obj_bound == -this.Infinite ? this.Infinite : lprec2.obj_bound);
            this.Level = 0;
            if (lprec2.basis_valid == 0) {
                int n;
                for (n = 0; n <= lprec2.rows; ++n) {
                    lprec2.basis[n] = 1;
                    lprec2.bas[n] = n;
                }
                for (n = lprec2.rows + 1; n <= lprec2.sum; ++n) {
                    lprec2.basis[n] = 0;
                }
                for (n = 0; n <= lprec2.sum; ++n) {
                    lprec2.lower[n] = 1;
                }
                lprec2.basis_valid = 1;
            }
            lprec2.eta_valid = 0;
            this.Break_bb = 0;
            int n = this.milpsolve(this.Orig_upbo, this.Orig_lowbo, this.Basis, this.Lower, this.Bas);
            lprec2.eta_size = this.Eta_size;
            lprec2.eta_alloc = this.Eta_alloc;
            lprec2.num_inv = this.Num_inv;
            return n;
        }
        return 4;
    }

    public int lag_solve(lprec lprec2, double d, int n, short s) {
        double d2;
        double d3;
        int n2;
        double[] dArray = new double[lprec2.columns + 1];
        double[] dArray2 = new double[lprec2.columns + 1];
        for (n2 = 0; n2 <= lprec2.columns; ++n2) {
            dArray2[n2] = 0.0;
        }
        double[] dArray3 = new double[lprec2.nr_lagrange];
        for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
            dArray3[n2] = 0.0;
        }
        double[] dArray4 = new double[lprec2.sum + 1];
        for (n2 = 0; n2 <= lprec2.sum; ++n2) {
            dArray4[n2] = 0.0;
        }
        int[] nArray = new int[lprec2.rows + 1];
        System.arraycopy(lprec2.bas, 0, nArray, 0, lprec2.rows + 1);
        short[] sArray = new short[lprec2.sum + 1];
        System.arraycopy(lprec2.lower, 0, sArray, 0, lprec2.sum + 1);
        this.get_row(lprec2, 0, dArray);
        double d4 = 2.0;
        if (lprec2.maximise != 0) {
            d3 = 1.0E24;
            d2 = d;
        } else {
            d2 = -1.0E24;
            d3 = d;
        }
        int n3 = 5;
        double d5 = 1.0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
            lprec2.lambda[n2] = 0.0;
        }
        while (n3 == 5) {
            int n6;
            ++n5;
            for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                dArray2[n2] = dArray[n2];
                for (n6 = 0; n6 < lprec2.nr_lagrange; ++n6) {
                    if (lprec2.maximise != 0) {
                        int n7 = n2;
                        dArray2[n7] = dArray2[n7] - lprec2.lambda[n6] * lprec2.lag_row[n6][n2];
                        continue;
                    }
                    int n8 = n2;
                    dArray2[n8] = dArray2[n8] + lprec2.lambda[n6] * lprec2.lag_row[n6][n2];
                }
            }
            for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                this.set_mat(lprec2, 0, n2, dArray2[n2]);
            }
            double d6 = 0.0;
            for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
                if (lprec2.maximise != 0) {
                    d6 += lprec2.lambda[n2] * lprec2.lag_rhs[n2];
                    continue;
                }
                d6 -= lprec2.lambda[n2] * lprec2.lag_rhs[n2];
            }
            if (s != 0) {
                System.out.println("Zub: " + d3 + " Zlb: " + d2 + " Step: " + d5 + " pie: " + d4 + " Feas " + n4);
                for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
                    System.out.println(n2 + " SubGrad " + dArray3[n2] + " lambda " + lprec2.lambda[n2]);
                }
            }
            if (s != 0 && lprec2.sum < 20) {
                this.print_lp(lprec2);
            }
            int n9 = this.solve(lprec2);
            if (s != 0 && lprec2.sum < 20) {
                this.print_solution(lprec2);
            }
            int n10 = 1;
            for (n2 = 1; n10 != 0 && n2 < lprec2.rows; ++n2) {
                n10 = nArray[n2] == lprec2.bas[n2] ? 1 : 0;
            }
            for (n2 = 1; n10 != 0 && n2 < lprec2.sum; ++n2) {
                n10 = sArray[n2] == lprec2.lower[n2] ? 1 : 0;
            }
            if (n10 == 0) {
                System.arraycopy(lprec2.lower, 0, sArray, 0, lprec2.sum + 1);
                System.arraycopy(lprec2.bas, 0, nArray, 0, lprec2.rows + 1);
                d4 *= 0.95;
            }
            if (s != 0) {
                System.out.println("result: " + n9 + "  same basis: " + n10);
            }
            if (n9 == 3) {
                for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                    System.out.print(dArray2[n2] + " ");
                }
                System.exit(-1);
            }
            if (n9 == 4) {
                n3 = 4;
            }
            if (n9 == 2) {
                n3 = 2;
            }
            double d7 = 0.0;
            for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
                dArray3[n2] = -lprec2.lag_rhs[n2];
                for (n6 = 1; n6 <= lprec2.columns; ++n6) {
                    int n11 = n2;
                    dArray3[n11] = dArray3[n11] + lprec2.best_solution[lprec2.rows + n6] * lprec2.lag_row[n2][n6];
                }
                d7 += dArray3[n2] * dArray3[n2];
            }
            n4 = 1;
            for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
                if (lprec2.lag_con_type[n2] != 0) {
                    if (!(Math.abs(dArray3[n2]) > lprec2.epsb)) continue;
                    n4 = 0;
                    continue;
                }
                if (!(dArray3[n2] > lprec2.epsb)) continue;
                n4 = 0;
            }
            if (n4 != 0) {
                bl = true;
                double d8 = 0.0;
                for (n2 = 1; n2 <= lprec2.columns; ++n2) {
                    d8 += lprec2.best_solution[lprec2.rows + n2] * dArray[n2];
                }
                if (lprec2.maximise != 0 && d8 > d2) {
                    d2 = d8;
                    for (n2 = 1; n2 <= lprec2.sum; ++n2) {
                        dArray4[n2] = lprec2.best_solution[n2];
                    }
                    dArray4[0] = d2;
                    if (s != 0) {
                        System.out.println("Best feasible solution: " + d2);
                    }
                } else if (d8 < d3) {
                    d3 = d8;
                    for (n2 = 1; n2 <= lprec2.sum; ++n2) {
                        dArray4[n2] = lprec2.best_solution[n2];
                    }
                    dArray4[0] = d3;
                    if (s != 0) {
                        System.out.println("Best feasible solution: " + d3);
                    }
                }
            }
            if (lprec2.maximise != 0) {
                d3 = Math.min(d3, d6 + lprec2.best_solution[0]);
            } else {
                d2 = Math.max(d2, d6 + lprec2.best_solution[0]);
            }
            if (Math.abs(d3 - d2) < 0.001) {
                n3 = 0;
            }
            d5 = d4 * (1.05 * d3 - d2) / d7;
            for (n2 = 0; n2 < lprec2.nr_lagrange; ++n2) {
                int n12 = n2;
                lprec2.lambda[n12] = lprec2.lambda[n12] + d5 * dArray3[n2];
                if (lprec2.lag_con_type[n2] != 0 || !(lprec2.lambda[n2] < 0.0)) continue;
                lprec2.lambda[n2] = 0.0;
            }
            if (n5 != n || n3 != 5) continue;
            if (bl) {
                n3 = 6;
                continue;
            }
            n3 = 7;
        }
        for (n2 = 0; n2 <= lprec2.sum; ++n2) {
            lprec2.best_solution[n2] = dArray4[n2];
        }
        for (n2 = 1; n2 <= lprec2.columns; ++n2) {
            this.set_mat(lprec2, 0, n2, dArray[n2]);
        }
        lprec2.lag_bound = lprec2.maximise != 0 ? d3 : d2;
        return n3;
    }
}

