/*
 * Decompiled with CFR 0.152.
 */
package de.utils;

import java.awt.TextArea;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtil {
    private static final char DEFAULT_TRIM_WHITESPACE = ' ';

    public static String chars(char paramChar, int paramInt) {
        char[] arrayOfChar = new char[paramInt];
        for (int i = 0; i < paramInt; ++i) {
            arrayOfChar[i] = paramChar;
        }
        return new String(arrayOfChar);
    }

    public static int StringToInteger(String pos) {
        if ("0 0 0".equals(pos)) {
            return 0;
        }
        if ("0 0 1".equals(pos)) {
            return 1;
        }
        if ("0 1 0".equals(pos)) {
            return 2;
        }
        if ("0 1 1".equals(pos)) {
            return 3;
        }
        if ("1 0 0".equals(pos)) {
            return 4;
        }
        if ("1 0 1".equals(pos)) {
            return 5;
        }
        if ("1 1 0".equals(pos)) {
            return 6;
        }
        if ("1 1 1".equals(pos)) {
            return 7;
        }
        return 0;
    }

    public static String numformat(int num, int ltot) {
        String numero = "" + num;
        for (int i = numero.length(); i < ltot; ++i) {
            numero = " " + numero;
        }
        return numero;
    }

    public static String numformat(double num, int ltot, int lmant) {
        int i;
        String strFormat = "";
        String strDouble = "";
        for (i = 0; i < ltot; ++i) {
            strDouble = strDouble + " ";
        }
        strFormat = strFormat + "#.";
        for (i = 0; i < lmant; ++i) {
            strFormat = strFormat + "0";
        }
        try {
            DecimalFormat df = new DecimalFormat(strFormat);
            strDouble = strDouble + df.format(num);
            int totalNew = strDouble.length();
            String s = strDouble.substring(totalNew - ltot);
            return s;
        }
        catch (IllegalArgumentException ex) {
            return String.valueOf(num);
        }
    }

    public static String numformat(double number, int numDecimalPlaces) {
        String strFormat = "#." + StringUtil.chars('0', numDecimalPlaces);
        try {
            DecimalFormat df = new DecimalFormat(strFormat);
            return df.format(number);
        }
        catch (IllegalArgumentException ex) {
            return String.valueOf(number);
        }
    }

    public static String IntegerToString(int pos) {
        if (pos == 0) {
            return "0 0 0";
        }
        if (pos == 1) {
            return "0 0 1";
        }
        if (pos == 2) {
            return "0 1 0";
        }
        if (pos == 3) {
            return "0 1 1";
        }
        if (pos == 4) {
            return "1 0 0";
        }
        if (pos == 5) {
            return "1 0 1";
        }
        if (pos == 6) {
            return "1 1 0";
        }
        if (pos == 7) {
            return "1 1 1";
        }
        return "1 1 0";
    }

    public static String trimAndUndercore(String TS) {
        String s1 = " ";
        String s2 = "_";
        TS = TS.trim();
        TS = TS.replace(s1.charAt(0), s2.charAt(0));
        return TS;
    }

    public static String trimAndRemoveQuotes(String TS) {
        TS = TS.trim();
        TS = TS.replaceAll("\"", "");
        TS = TS.replaceAll("'", "");
        return TS;
    }

    public static String StringToStringplanning(String lf) {
        if ("FIX".equals(lf)) {
            return "0";
        }
        if ("VAR".equals(lf)) {
            return "1";
        }
        if ("UPD".equals(lf)) {
            return "2";
        }
        return "0";
    }

    public static String printf(String paramString, int paramInt) {
        int i = paramString.length();
        if (i > paramInt) {
            return paramString.substring(0, paramInt);
        }
        if (i < paramInt) {
            return paramString + StringUtil.chars(' ', paramInt - i);
        }
        return paramString;
    }

    public static String printf(double paramDouble, int paramInt1, int paramInt2) {
        String str3;
        String str2;
        String str1 = String.valueOf(paramDouble);
        int i = str1.length();
        int j = str1.indexOf(".");
        if (j > 0) {
            str2 = str1.substring(0, j);
            str3 = str1.substring(j + 1, i);
        } else {
            str2 = str1;
            str3 = "";
        }
        if (str2.length() <= paramInt1 - paramInt2 - 1) {
            int k = str2.length();
            String str4 = k < paramInt1 - paramInt2 - 1 ? StringUtil.chars(' ', paramInt1 - paramInt2 - 1 - k) + str2 : str2;
            int m = str3.length();
            String str5 = m < paramInt2 ? str3 + StringUtil.chars('0', paramInt2 - m) : (m > paramInt2 ? str3.substring(0, paramInt2) : str3);
            str1 = str4 + "." + str5;
        } else {
            str1 = StringUtil.chars('*', i);
        }
        return str1;
    }

    public static String printf(int paramInt1, int paramInt2) {
        int i = Math.abs(paramInt2);
        String str = String.valueOf(paramInt1);
        int j = str.length();
        if (j < i) {
            str = paramInt2 > 0 ? StringUtil.chars(' ', i - j) + str : str + StringUtil.chars(' ', i - j);
        } else if (j > i) {
            str = StringUtil.chars('*', i);
        }
        return str;
    }

    public static String[] SplitLineWhitespace(String line) {
        int ntokens = 0;
        StringTokenizer tokens = new StringTokenizer(line);
        while (tokens.hasMoreTokens()) {
            ++ntokens;
            tokens.nextToken();
        }
        String[] salida = new String[ntokens];
        tokens = new StringTokenizer(line);
        int k = 0;
        while (tokens.hasMoreTokens()) {
            salida[k] = tokens.nextToken();
            ++k;
        }
        return salida;
    }

    public static String strformat(String cad, int ltot) {
        if (cad == null) {
            return null;
        }
        String cadmod = cad;
        if (cad.length() < ltot) {
            for (int i = cad.length(); i < ltot; ++i) {
                cadmod = cadmod + " ";
            }
        }
        return cadmod;
    }

    public static String strformat2(String cad, int ltot) {
        if (cad == null) {
            return null;
        }
        String cadmod = "";
        if (cad.length() < ltot) {
            for (int i = cad.length(); i < ltot; ++i) {
                cadmod = cadmod + " ";
            }
        }
        return cadmod + cad;
    }

    public static String LoadFlowTypeToIDString(String lf) {
        if ("DF".equals(lf)) {
            return "0";
        }
        if ("PQ".equals(lf)) {
            return "1";
        }
        if ("PV".equals(lf)) {
            return "2";
        }
        if ("SL".equals(lf)) {
            return "3";
        }
        if ("VD".equals(lf)) {
            return "4";
        }
        return "0";
    }

    public static String stringConcat(String ... strings) {
        int length = 0;
        for (String string : strings) {
            length += string.length();
        }
        StringBuilder concatString = new StringBuilder(length);
        for (String string : strings) {
            concatString.append(string);
        }
        return concatString.toString();
    }

    public static String trimLeft(String string) {
        return StringUtil.trimLeft(string, ' ');
    }

    public static String trimLeft(String string, char trimChar) {
        int i;
        int stringLength = string.length();
        for (i = 0; i < stringLength && string.charAt(i) == trimChar; ++i) {
        }
        if (i == 0) {
            return string;
        }
        return string.substring(i);
    }

    public static String trimRight(String string) {
        return StringUtil.trimRight(string, ' ');
    }

    public static String trimRight(String string, char trimChar) {
        int lastChar;
        int i;
        for (i = lastChar = string.length() - 1; i >= 0 && string.charAt(i) == trimChar; --i) {
        }
        if (i < lastChar) {
            return string.substring(0, i + 1);
        }
        return string;
    }

    public static String trim(String string) {
        return StringUtil.trimLeft(StringUtil.trimRight(string, ' '), ' ');
    }

    public static String nonNullString(String inString) {
        if (inString == null) {
            return "";
        }
        return inString;
    }

    public static boolean containsWhiteSpace(String inString) {
        return inString.indexOf(32) != -1;
    }

    public static int searchIndexInString(String key, String[] list) {
        int lo = 0;
        int hi = list.length - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            int cmp = key.compareToIgnoreCase(list[mid]);
            if (cmp == 0) {
                return mid;
            }
            if (cmp < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        return -lo;
    }

    public static int safeParseInt(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int safeParseInt(String s) {
        return StringUtil.safeParseInt(s, 0);
    }

    public static double safeParseDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double safeParseDouble(String s) {
        return StringUtil.safeParseDouble(s, 0.0);
    }

    public static String createUniqueCompName(String originalName) {
        if (originalName == null) {
            return null;
        }
        int lastCharPosition = originalName.length() - 1;
        if (originalName.lastIndexOf(")") != lastCharPosition) {
            return originalName + "(1)";
        }
        int lastOpenChar = originalName.lastIndexOf("(");
        if (lastOpenChar != -1) {
            String sIndex = originalName.substring(lastOpenChar);
            String sIndex2 = sIndex.replace("(", "");
            sIndex2 = sIndex2.replace(")", "");
            try {
                int nIndex = Integer.parseInt(sIndex2);
                sIndex = "(" + (nIndex + 1) + ")";
            }
            catch (NumberFormatException e) {
                sIndex = "(1)";
            }
            return originalName.substring(0, lastOpenChar) + sIndex;
        }
        return originalName + "(1)";
    }

    public static String createUniqueNameFromList(String newValue, List<String> previousValues) {
        while (previousValues.contains(newValue)) {
            newValue = StringUtil.createUniqueCompName(newValue);
        }
        return newValue;
    }

    public static String validText(String line) {
        char c;
        if (line == null) {
            return "";
        }
        String text = line;
        for (int lastCharPos = line.length() - 1; lastCharPos > -1 && ((c = text.charAt(lastCharPos)) == '\r' || c == '\n' || c == '\f' || c == '\u0000' || c == '\b'); --lastCharPos) {
            text = text.substring(0, lastCharPos);
        }
        return text;
    }

    public static File fileParent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            if (f.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(dirname);
    }

    public static boolean fileNameIsValid(String fileName) {
        if (fileName == null) {
            return false;
        }
        if (fileName.length() == 0) {
            return false;
        }
        return !fileName.contains("?") && !fileName.contains("*");
    }

    public static boolean extNameIsValid(String extName) {
        if (extName == null) {
            return false;
        }
        if (extName.length() == 0) {
            return false;
        }
        return !extName.contains("?") && !extName.contains("*");
    }

    public static void printTextAreaToFile(String filename, TextArea ta) throws IOException {
        StringBuilder sBuf = new StringBuilder();
        sBuf.append(ta.getText());
        FileOutputStream fos = new FileOutputStream(filename);
        for (int i = 0; i < sBuf.length(); ++i) {
            fos.write(sBuf.charAt(i));
        }
        fos.close();
    }

    public static void printFileToTextArea(String FileName, TextArea ta) throws IOException {
        int c;
        StringBuilder sBuf = new StringBuilder(100000);
        FileInputStream fis = new FileInputStream(FileName);
        while ((c = fis.read()) != -1) {
            sBuf.append((char)c);
        }
        fis.close();
        ta.setText(sBuf.toString());
    }
}

