/*
 * Decompiled with CFR 0.152.
 */
package de.utils;

import de.utils.Utils;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static final String XLSX_FILE_EXTENSION = ".xlsx";
    public static final String XLSM_FILE_EXTENSION = ".xlsm";

    public static Workbook openExcelConnection(String eFileName) throws InvalidFormatException, IOException {
        File fExcel = new File(eFileName);
        if (fExcel.exists()) {
            FileInputStream fis = new FileInputStream(fExcel);
            XSSFWorkbook wb = (XSSFWorkbook)WorkbookFactory.create((InputStream)fis);
            return wb;
        }
        return null;
    }

    public static void openExcelFile(String excelFile, String selectedSheet) throws IOException {
        File fExcel = new File(excelFile);
        if (selectedSheet != null) {
            try {
                int index;
                Workbook wb = ExcelUtil.openExcelConnection(excelFile);
                if (wb != null && (index = wb.getSheetIndex(selectedSheet)) >= 0) {
                    wb.setActiveSheet(index);
                }
                ExcelUtil.saveExcelWorkbook(wb, excelFile);
            }
            catch (InvalidFormatException e) {
                System.out.println("Internal error with POI selecting the active sheet: " + selectedSheet);
                e.printStackTrace(System.err);
            }
        }
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().edit(fExcel);
        }
    }

    public static Workbook newExcelConnection(String eFileName) throws InvalidFormatException, IOException {
        XSSFWorkbook wb = new XSSFWorkbook();
        if (ExcelUtil.saveExcelWorkbook((Workbook)wb, eFileName)) {
            return wb;
        }
        return null;
    }

    public static boolean saveExcelWorkbook(Workbook eWorkbook, String eFileName) throws IOException {
        File fExcel = new File(eFileName);
        if (eWorkbook != null) {
            if (eWorkbook instanceof XSSFWorkbook) {
                XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)((XSSFWorkbook)eWorkbook));
            } else if (eWorkbook instanceof HSSFWorkbook) {
                HSSFFormulaEvaluator.evaluateAllFormulaCells((Workbook)eWorkbook);
            } else assert (false) : "What kind of object are passing here? " + eWorkbook.getClass().getName();
            FileOutputStream out = new FileOutputStream(fExcel);
            eWorkbook.write((OutputStream)out);
            out.close();
            return true;
        }
        return false;
    }

    public static String[][] readExcel2007Data(String eFileName, String eSheetName, int nRowFrom, int nColumnFrom, int nRowTo, int nColumnTo) {
        File fExcel = new File(eFileName);
        try {
            if (fExcel.exists()) {
                OPCPackage pkg = OPCPackage.open((File)fExcel);
                XSSFWorkbook wb = new XSSFWorkbook(pkg);
                return ExcelUtil.readExcel2007Data((Workbook)wb, eSheetName, nRowFrom, nColumnFrom, nRowTo, nColumnTo);
            }
        }
        catch (IOException e) {
            assert (false) : "What went wrong with POI???";
            e.printStackTrace(System.err);
        }
        catch (InvalidFormatException e) {
            System.out.println("Unsupported Excel file: '" + eFileName + "'. Details: " + e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
        return null;
    }

    public static String[][] readExcel2007Data(Workbook eWorkbook, String eSheetName, int nRowFrom, int nColumnFrom, int nRowTo, int nColumnTo) {
        return ExcelUtil.readExcel2007Data(eWorkbook, eSheetName, nRowFrom, nColumnFrom, nRowTo, nColumnTo, true);
    }

    public static String[][] readExcel2007Data(Workbook eWorkbook, String eSheetName, int nRowFrom, int nColumnFrom, int nRowTo, int nColumnTo, boolean untilEmptyRow) {
        Row eRow;
        Sheet eSheet = eWorkbook.getSheet(eSheetName);
        if (eSheet == null) {
            return null;
        }
        ArrayList<Cell> lCells = new ArrayList<Cell>();
        int lastColInRange = nColumnFrom;
        int contRow = nRowFrom - 1;
        int contCol = nColumnFrom - 1;
        if (nRowTo <= 0) {
            nRowTo = eSheet.getLastRowNum() + 1;
        }
        while ((eRow = eSheet.getRow(contRow)) != null && contRow < nRowTo) {
            Cell eCell;
            Cell firstCell;
            contCol = nColumnFrom - 1;
            int lastColInRow = nColumnTo;
            if (untilEmptyRow && ((firstCell = eRow.getCell(contCol)) == null || ExcelUtil.getXLSCellValue(firstCell).isEmpty())) break;
            if (nColumnTo <= 0) {
                lastColInRow = eRow.getLastCellNum();
            }
            lastColInRange = Math.max(lastColInRange, lastColInRow);
            while ((eCell = eRow.getCell(contCol)) != null && contCol < lastColInRow) {
                lCells.add(eCell);
                ++contCol;
            }
            ++contRow;
        }
        int nRows = nRowTo - nRowFrom + 1;
        int nCols = lastColInRange - nColumnFrom + 1;
        assert (nRows >= 0 && nCols >= 0) : "Why negative???";
        nRows = Math.max(nRows, 1);
        nCols = Math.max(nCols, 1);
        String[][] data2 = Utils.getInitString2DArray(nRows, nCols, "");
        for (Cell cell : lCells) {
            String sValue;
            int r = cell.getRowIndex() - (nRowFrom - 1);
            int c = cell.getColumnIndex() - (nColumnFrom - 1);
            data2[r][c] = sValue = ExcelUtil.getXLSCellValue(cell);
        }
        return data2;
    }

    public static int writeExcel2007Data(String eFileName, String eSheetName, int nRowFrom, int nColumnFrom, String[][] data2) throws FileNotFoundException, IOException, InvalidFormatException {
        XSSFWorkbook wb;
        File fExcel = new File(eFileName);
        if (fExcel.exists()) {
            FileInputStream stream = new FileInputStream(fExcel);
            wb = (XSSFWorkbook)WorkbookFactory.create((InputStream)stream);
        } else {
            wb = (XSSFWorkbook)ExcelUtil.newExcelConnection(eFileName);
            if (wb == null) {
                return -1;
            }
        }
        int nRet = ExcelUtil.writeExcel2007Data((Workbook)wb, eSheetName, nRowFrom, nColumnFrom, data2);
        if (nRet > 0 && ExcelUtil.saveExcelWorkbook((Workbook)wb, eFileName)) {
            return nRet;
        }
        wb.close();
        return -1;
    }

    public static int writeExcel2007Data(Workbook eWorkbook, String eSheetName, int nRowFrom, int nColumnFrom, String[][] data2) {
        int nRet = 0;
        assert (--nRowFrom >= 0 && --nColumnFrom >= 0) : "Never use this function in invalid ranges";
        if (nRowFrom < 0 && nColumnFrom < 0) {
            return -1;
        }
        if (eWorkbook == null) {
            return -1;
        }
        if (data2 == null) {
            return -1;
        }
        Sheet sheet = eWorkbook.getSheet(eSheetName);
        if (sheet == null) {
            sheet = eWorkbook.createSheet(eSheetName);
        }
        assert (sheet != null) : "Why POI couldn't create sheet " + eSheetName;
        int rownum = nRowFrom;
        int i = 0;
        while (i < data2.length) {
            if (data2[i] != null) {
                Row row = sheet.getRow(rownum);
                if (row == null) {
                    row = sheet.createRow(rownum);
                }
                int colnum = nColumnFrom;
                int j = 0;
                while (j < data2[i].length) {
                    Cell cell = row.getCell(colnum);
                    if (cell == null) {
                        cell = row.createCell(colnum);
                    }
                    cell.setCellValue(data2[i][j]);
                    ++nRet;
                    ++j;
                    ++colnum;
                }
            }
            ++i;
            ++rownum;
        }
        return nRet;
    }

    public static void removeRowFromExcel(Workbook eWorkbook, String eSheetName, int rowIndex) {
        Row removingRow;
        Sheet eSheet = eWorkbook.getSheet(eSheetName);
        if (eSheet == null) {
            return;
        }
        int lastRowNum = eSheet.getLastRowNum();
        if (--rowIndex >= 0 && rowIndex < lastRowNum) {
            eSheet.shiftRows(rowIndex + 1, lastRowNum, -1);
        }
        if (rowIndex == lastRowNum && (removingRow = eSheet.getRow(rowIndex)) != null) {
            eSheet.removeRow(removingRow);
        }
    }

    public static void removeColumnFromExcel(Workbook eWorkbook, String eSheetName, int columnIndex) {
        int maxColumn = 0;
        --columnIndex;
        Sheet eSheet = eWorkbook.getSheet(eSheetName);
        if (eSheet == null) {
            return;
        }
        for (int r = 0; r < eSheet.getLastRowNum() + 1; ++r) {
            Row row = eSheet.getRow(r);
            if (row == null) continue;
            int lastColumn = row.getLastCellNum();
            if (lastColumn > maxColumn) {
                maxColumn = lastColumn;
            }
            if (lastColumn < columnIndex) continue;
            for (int x = columnIndex + 1; x < lastColumn + 1; ++x) {
                Cell nextCell;
                Cell oldCell = row.getCell(x - 1);
                if (oldCell != null) {
                    oldCell.removeCellComment();
                    row.removeCell(oldCell);
                }
                if ((nextCell = row.getCell(x)) == null) continue;
                Cell newCell = row.createCell(x - 1, nextCell.getCellType());
                ExcelUtil.cloneCell(newCell, nextCell);
            }
        }
        for (int c = 0; c < maxColumn; ++c) {
            eSheet.setColumnWidth(c, eSheet.getColumnWidth(c + 1));
        }
    }

    public static int clearContentExcel(Workbook eWorkbook, String eSheetName, int nRowFrom, int nColumnFrom, int nRowTo, int nColumnTo) {
        Sheet eSheet = eWorkbook.getSheet(eSheetName);
        if (eSheet == null) {
            return -1;
        }
        if (nRowTo <= 0) {
            nRowTo = ExcelUtil.lastNonEmptyRow(eSheet, nRowFrom, nColumnFrom);
        }
        nRowTo = Math.min(nRowTo, eSheet.getLastRowNum() + 1);
        if (nColumnTo <= 0) {
            nColumnTo = ExcelUtil.lastNonEmptyColumn(eSheet, nRowFrom, nColumnFrom);
        }
        if (nRowTo >= nRowFrom && nColumnTo >= nColumnFrom) {
            String[][] data2 = Utils.getInitString2DArray(nRowTo - nRowFrom + 1, nColumnTo - nColumnFrom + 1, "");
            return ExcelUtil.writeExcel2007Data(eWorkbook, eSheetName, nRowFrom, nColumnFrom, data2);
        }
        return 0;
    }

    public static int clearContentExcel(String eFileName, String eSheetName, int nRowFrom, int nColumnFrom, int nRowTo, int nColumnTo) throws FileNotFoundException, IOException, InvalidFormatException {
        File fExcel = new File(eFileName);
        if (!fExcel.exists()) {
            return -1;
        }
        FileInputStream stream = new FileInputStream(fExcel);
        XSSFWorkbook wb = (XSSFWorkbook)WorkbookFactory.create((InputStream)stream);
        int nRet = ExcelUtil.clearContentExcel((Workbook)wb, eSheetName, nRowFrom, nColumnFrom, nRowTo, nColumnTo);
        if (nRet > 0 && ExcelUtil.saveExcelWorkbook((Workbook)wb, eFileName)) {
            return nRet;
        }
        wb.close();
        return 0;
    }

    public static int findRowInExcel(Object oSearch, Workbook eWorkbook, String eSheetName, int nRowFrom, int nColFrom, boolean matchCase) {
        assert (oSearch != null) : "Never use null here!";
        String[][] data2 = ExcelUtil.readExcel2007Data(eWorkbook, eSheetName, nRowFrom, nColFrom, -1, nColFrom);
        if (data2 != null) {
            int contRow = nRowFrom;
            for (String[] data1 : data2) {
                if (matchCase ? data1[0].trim().equals(oSearch.toString().trim()) : data1[0].trim().equalsIgnoreCase(oSearch.toString().trim())) {
                    return contRow;
                }
                ++contRow;
            }
        }
        return -1;
    }

    public static int findColumnInExcel(Object oSearch, Workbook eWorkbook, String eSheetName, int nRowFrom, int nColFrom, boolean matchCase) {
        String[][] data2 = ExcelUtil.readExcel2007Data(eWorkbook, eSheetName, nRowFrom, nColFrom, nRowFrom, -1);
        if (data2 != null) {
            int contCol = nColFrom;
            for (String data1 : data2[0]) {
                if (matchCase ? data1.trim().equals(oSearch.toString().trim()) : data1.trim().equalsIgnoreCase(oSearch.toString().trim())) {
                    return contCol;
                }
                ++contCol;
            }
        }
        return -1;
    }

    @Deprecated
    public static String getXLSXCellValue(XSSFCell cell) {
        switch (cell.getCellType()) {
            case 3: {
                return "";
            }
            case 0: {
                return ExcelUtil.int_double2String(cell.getNumericCellValue());
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                switch (cell.getCachedFormulaResultType()) {
                    case 0: {
                        return ExcelUtil.int_double2String(cell.getNumericCellValue());
                    }
                    case 1: {
                        return String.valueOf(cell.getRichStringCellValue());
                    }
                    case 4: {
                        return String.valueOf(cell.getBooleanCellValue());
                    }
                    case 5: {
                        return cell.getErrorCellString();
                    }
                }
                return "";
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return cell.getErrorCellString();
            }
        }
        assert (false) : "What is this cell type?" + cell.getCellType();
        return "";
    }

    public static String getXLSCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 3: {
                return "";
            }
            case 0: {
                return ExcelUtil.int_double2String(cell.getNumericCellValue());
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                switch (cell.getCachedFormulaResultType()) {
                    case 0: {
                        return ExcelUtil.int_double2String(cell.getNumericCellValue());
                    }
                    case 1: {
                        return String.valueOf(cell.getRichStringCellValue());
                    }
                    case 4: {
                        return String.valueOf(cell.getBooleanCellValue());
                    }
                    case 5: {
                        return "";
                    }
                }
                return "";
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return "";
            }
        }
        assert (false) : "What is this unsupported cell type?" + cell.getCellType();
        return "";
    }

    private static int lastNonEmptyRow(Sheet eSheet, int initRow, int nColumn) {
        String val;
        Row eRow;
        if (eSheet == null) {
            return -1;
        }
        --nColumn;
        int contRow = --initRow;
        while ((eRow = eSheet.getRow(contRow)) != null && eRow.getCell(nColumn) != null && (val = ExcelUtil.getXLSCellValue(eRow.getCell(nColumn))) != null && !val.isEmpty()) {
            ++contRow;
        }
        return contRow + 1;
    }

    private static int lastNonEmptyColumn(Sheet eSheet, int nRow, int initColumn) {
        String val;
        Cell eCell;
        if (eSheet == null) {
            return -1;
        }
        Row eRow = eSheet.getRow(--nRow);
        int contCol = --initColumn;
        while ((eCell = eRow.getCell(contCol)) != null && (val = ExcelUtil.getXLSCellValue(eCell)) != null && !val.isEmpty()) {
            ++contCol;
        }
        return contCol + 1;
    }

    private static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        switch (cNew.getCellType()) {
            case 4: {
                cNew.setCellValue(cOld.getBooleanCellValue());
                break;
            }
            case 0: {
                cNew.setCellValue(cOld.getNumericCellValue());
                break;
            }
            case 1: {
                cNew.setCellValue(cOld.getStringCellValue());
                break;
            }
            case 5: {
                cNew.setCellValue((double)cOld.getErrorCellValue());
                break;
            }
            case 2: {
                cNew.setCellFormula(cOld.getCellFormula());
            }
        }
    }

    public static String[][] clipboardExcel2Array() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(null);
        if (content != null) {
            try {
                String value = content.getTransferData(DataFlavor.stringFlavor).toString();
                String[] sRows = value.split("\n");
                String[][] rawData = new String[sRows.length][];
                for (int nRow = 0; nRow < sRows.length; ++nRow) {
                    String[] sCols = sRows[nRow].split("\t");
                    rawData[nRow] = new String[sCols.length];
                    System.arraycopy(sCols, 0, rawData[nRow], 0, sCols.length);
                }
                return rawData;
            }
            catch (UnsupportedFlavorException e) {
                System.err.println("Pasting from clipboard error: UNSUPPORTED FLAVOR EXCEPTION " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                System.err.println("Pasting from clipboard error: DATA CONSUMED EXCEPTION " + e.getLocalizedMessage());
            }
        }
        return null;
    }

    public static int columnNameToInteger(String columnID) {
        if (columnID == null) {
            return -1;
        }
        String column = columnID.toLowerCase();
        char[] ch = column.toCharArray();
        int pos = 0;
        int cont = 0;
        for (char c : ch) {
            assert (c >= 'a' && c <= 'z') : "This is an invalid range!!";
            if (c < 'a' || c > 'z') {
                return -1;
            }
            pos = c - 97 + 1;
            ++cont;
        }
        return (cont - 1) * 26 + pos;
    }

    public static String columnIntegerToName(int col) {
        int dividend = col;
        String columnName = "";
        while (dividend > 0) {
            int modulo = (dividend - 1) % 26;
            int i = 65 + modulo;
            columnName = new Character((char)i).toString() + columnName;
            dividend = (dividend - modulo) / 26;
        }
        return columnName;
    }

    public static boolean isExcel2007FileType(String eWorkbookName) {
        return eWorkbookName.toLowerCase().endsWith(XLSX_FILE_EXTENSION) || eWorkbookName.toLowerCase().endsWith(XLSM_FILE_EXTENSION);
    }

    private static String int_double2String(double d) {
        if (d % 1.0 == 0.0) {
            return String.valueOf((int)d);
        }
        return String.valueOf(d);
    }
}

