/*
 * Decompiled with CFR 0.152.
 */
package de.utils;

import de.utils.DatasetItem;
import de.utils.Utils;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DE_ChartFactory {
    public static final int SERIES_XY_LINE = 0;
    public static final int SERIES_XY_AREA = 1;
    public static final int SERIES_TYPE_PIE = 2;
    public static final int SERIES_TYPE_LINE = 3;
    public static final int SERIES_TYPE_COLUMN = 4;
    public static final int SERIES_TYPE_AREA = 5;
    public static final int SERIES_TYPE_COLUMNSTACK = 6;
    public static final int SERIES_TYPE_AREASTACK = 7;

    public static JFreeChart createXYChart(String sTitle, int leftAxisType, double[][] dYLeftValues, double[][] dXLeftValues, String[] leftLabels, Color[] leftSeriesColors, String yLeftAxisLabel, int rightAxisType, double[][] dYRightValues, double[][] dXRightValues, String[] rightLabels, Color[] rightSeriesColors, String yRightAxisLabel, String xAxisLabel) {
        int nLeftSeries = 0;
        int nRightSeries = 0;
        double dMaxX = 0.0;
        double dMinX = 0.0;
        boolean is2axis = dYRightValues != null;
        nLeftSeries = dYLeftValues.length;
        if (is2axis) {
            nRightSeries = dYRightValues.length;
        }
        assert (leftLabels.length >= nLeftSeries) : "You are missing labels for some of your series!! All labels must have a name";
        if (rightLabels != null) assert (rightLabels.length >= nRightSeries) : "You are missing labels for some of your series!! All labels must have a name";
        if (leftSeriesColors != null) assert (leftSeriesColors.length >= nLeftSeries) : "You are missing Color definition for some of your series!! All series must have a Color!";
        if (rightSeriesColors != null) assert (rightSeriesColors.length >= nRightSeries) : "You are missing Color definition for some of your series!! All series must have a Color!";
        XYPlot plot = new XYPlot();
        XYSeries[] leftSeries = new XYSeries[nLeftSeries];
        XYSeriesCollection datasetLeft = new XYSeriesCollection();
        for (int s = 0; s < nLeftSeries; ++s) {
            int nYdata = dYLeftValues[s].length;
            if (dXLeftValues[s] == null) {
                dXLeftValues[s] = new double[nYdata];
                for (int i = 0; i < nYdata; ++i) {
                    dXLeftValues[s][i] = Utils.safeDivision((double)i * 100.0, nYdata);
                }
            }
            assert (dYLeftValues[s].length == dXLeftValues[s].length) : "Left axis series '" + s + "' has different number of x and y values. Series must have identical lengths!";
            leftSeries[s] = new XYSeries((Comparable)((Object)leftLabels[s]));
            for (int y = 0; y < dYLeftValues[s].length; ++y) {
                leftSeries[s].add(dXLeftValues[s][y], dYLeftValues[s][y]);
            }
            datasetLeft.addSeries(leftSeries[s]);
            dMaxX = Math.max(dMaxX, Utils.getMaximum(dXLeftValues[s]));
            dMinX = Math.min(dMinX, Utils.getMinimum(dXLeftValues[s]));
        }
        XYAreaRenderer rendererYLeft = new XYAreaRenderer(DE_ChartFactory.type2RenderType(leftAxisType));
        if (leftSeriesColors != null) {
            for (int i = 0; i < nLeftSeries; ++i) {
                rendererYLeft.setSeriesPaint(i, (Paint)leftSeriesColors[i]);
            }
        }
        XYSeries[] rightSeries = new XYSeries[nRightSeries];
        XYSeriesCollection datasetRight = new XYSeriesCollection();
        XYAreaRenderer rendererYRight = null;
        if (is2axis) {
            for (int s = 0; s < nRightSeries; ++s) {
                int nYdata = dYRightValues[s].length;
                if (dXRightValues[s] == null) {
                    dXRightValues[s] = new double[nYdata];
                    for (int i = 0; i < nYdata; ++i) {
                        dXRightValues[s][i] = Utils.safeDivision((double)i * 100.0, nYdata);
                    }
                }
                assert (dYRightValues[s].length == dXRightValues[s].length) : "Series '" + s + "' has different number of x and y values. Series must have identical lengths!";
                rightSeries[s] = new XYSeries((Comparable)((Object)rightLabels[s]));
                for (int y = 0; y < dYRightValues[s].length; ++y) {
                    rightSeries[s].add(dXRightValues[s][y], dYRightValues[s][y]);
                }
                datasetRight.addSeries(rightSeries[s]);
                dMaxX = Math.max(dMaxX, Utils.getMaximum(dXRightValues[s]));
                dMinX = Math.min(dMinX, Utils.getMinimum(dXRightValues[s]));
            }
            rendererYRight = new XYAreaRenderer(DE_ChartFactory.type2RenderType(rightAxisType));
            if (rightSeriesColors != null) {
                for (int i = 0; i < nRightSeries; ++i) {
                    rendererYRight.setSeriesPaint(i, (Paint)rightSeriesColors[i]);
                }
            }
        }
        NumberAxis domainX = new NumberAxis(xAxisLabel);
        domainX.setUpperBound(dMaxX);
        plot.setDomainAxis(0, (ValueAxis)domainX);
        NumberAxis rangeYLeft = new NumberAxis(yLeftAxisLabel);
        plot.setRangeAxis(0, (ValueAxis)rangeYLeft);
        plot.setDataset(0, (XYDataset)datasetLeft);
        plot.setRenderer(0, (XYItemRenderer)rendererYLeft);
        if (is2axis) {
            NumberAxis domain2 = new NumberAxis();
            domain2.setVisible(false);
            plot.setDomainAxis(1, (ValueAxis)domain2);
            NumberAxis rangeYRight = new NumberAxis(yRightAxisLabel);
            plot.setRangeAxis(1, (ValueAxis)rangeYRight);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            plot.setDataset(1, (XYDataset)datasetRight);
            plot.setRenderer(1, (XYItemRenderer)rendererYRight);
            plot.mapDatasetToDomainAxis(1, 0);
            plot.mapDatasetToRangeAxis(1, 0);
        }
        JFreeChart chart = new JFreeChart(sTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        DE_ChartFactory.setDeepEditChartStyle(chart);
        return chart;
    }

    public static JFreeChart createLineChart(String sTitle, double[][] dYLeftValues, String[] leftLabels, Color[] leftColors, String yLeftAxisLabel, double[][] dYRightValues, String[] rightLabels, Color[] rightColors, String yRightAxisLabel, String[] sXValues, String xAxisLabel) {
        int i;
        boolean is2axis;
        int nLeftSeries = dYLeftValues.length;
        int nRightSeries = 0;
        boolean bl = is2axis = dYRightValues != null;
        if (is2axis) {
            nRightSeries = dYRightValues.length;
        }
        if (sXValues == null) {
            int nXsize = dYLeftValues[0].length;
            sXValues = new String[nXsize];
            for (i = 0; i < nXsize; ++i) {
                sXValues[i] = String.valueOf(i + 1);
            }
        }
        if (leftLabels == null) {
            leftLabels = new String[nLeftSeries];
            for (int i2 = 0; i2 < nLeftSeries; ++i2) {
                leftLabels[i2] = String.valueOf(i2 + 1);
            }
        }
        DefaultCategoryDataset datasetLeft = new DefaultCategoryDataset();
        for (i = 0; i < dYLeftValues.length; ++i) {
            for (int k = 0; k < dYLeftValues[i].length; ++k) {
                datasetLeft.setValue(dYLeftValues[i][k], (Comparable)((Object)leftLabels[i]), (Comparable)((Object)sXValues[k]));
            }
        }
        JFreeChart chart = ChartFactory.createLineChart((String)sTitle, (String)xAxisLabel, (String)yLeftAxisLabel, (CategoryDataset)datasetLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        if (is2axis) {
            if (rightLabels == null) {
                rightLabels = new String[nRightSeries];
                for (int i3 = 0; i3 < nRightSeries; ++i3) {
                    rightLabels[i3] = String.valueOf(i3 + 1);
                }
            }
            DefaultCategoryDataset datasetRight = new DefaultCategoryDataset();
            for (int i4 = 0; i4 < dYRightValues.length; ++i4) {
                for (int k = 0; k < dYRightValues[i4].length; ++k) {
                    datasetRight.setValue(dYRightValues[i4][k], (Comparable)((Object)rightLabels[i4]), (Comparable)((Object)sXValues[k]));
                }
            }
            NumberAxis axis2 = new NumberAxis(yRightAxisLabel);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            plot.setDataset(1, (CategoryDataset)datasetRight);
            plot.mapDatasetToRangeAxis(0, 0);
            plot.mapDatasetToRangeAxis(1, 1);
        }
        DE_ChartFactory.setDeepEditChartStyle(chart);
        return chart;
    }

    public static JFreeChart createLineChart(String sTitle, DefaultCategoryDataset datasetLeft, String yLeftAxisLabel, DefaultCategoryDataset datasetRight, String yRightAxisLabel, String xAxisLabel) {
        return DE_ChartFactory.createCategoryChart(sTitle, (CategoryDataset)datasetLeft, yLeftAxisLabel, 3, (CategoryDataset)datasetRight, yRightAxisLabel, 3, xAxisLabel);
    }

    public static JFreeChart createCategoryChart(String sTitle, CategoryDataset datasetLeft, String yLeftAxisLabel, int leftType, CategoryDataset datasetRight, String yRightAxisLabel, int rightType, String xAxisLabel) {
        JFreeChart chart;
        switch (leftType) {
            case 3: {
                chart = ChartFactory.createLineChart((String)sTitle, (String)xAxisLabel, (String)yLeftAxisLabel, (CategoryDataset)datasetLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 5: {
                chart = ChartFactory.createAreaChart((String)sTitle, (String)xAxisLabel, (String)yLeftAxisLabel, (CategoryDataset)datasetLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 7: {
                chart = ChartFactory.createStackedAreaChart((String)sTitle, (String)xAxisLabel, (String)yLeftAxisLabel, (CategoryDataset)datasetLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 6: {
                chart = ChartFactory.createStackedBarChart((String)sTitle, (String)xAxisLabel, (String)yLeftAxisLabel, (CategoryDataset)datasetLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case 4: {
                chart = ChartFactory.createBarChart((String)sTitle, (String)xAxisLabel, (String)yLeftAxisLabel, (CategoryDataset)datasetLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            default: {
                chart = ChartFactory.createLineChart((String)sTitle, (String)xAxisLabel, (String)yLeftAxisLabel, (CategoryDataset)datasetLeft, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            }
        }
        if (datasetRight != null) {
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            NumberAxis axis2 = new NumberAxis(yRightAxisLabel);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            plot.setDataset(1, datasetRight);
            CategoryItemRenderer rendererYRight = DE_ChartFactory.getRendererType(rightType);
            plot.setRenderer(1, rendererYRight);
            plot.mapDatasetToRangeAxis(0, 0);
            plot.mapDatasetToRangeAxis(1, 1);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        }
        DE_ChartFactory.setDeepEditChartStyle(chart);
        return chart;
    }

    public static JFreeChart createPieChart(String sTitle, double[] dValues, String[] sLabels) {
        if (sLabels == null) {
            int nSeries = dValues.length;
            sLabels = new String[nSeries];
            for (int i = 0; i < nSeries; ++i) {
                sLabels[i] = String.valueOf(i + 1);
            }
        }
        DefaultPieDataset dataset = new DefaultPieDataset();
        int nValues = dValues.length;
        for (int i = 0; i < nValues; ++i) {
            dataset.setValue((Comparable)((Object)sLabels[i]), dValues[i]);
        }
        JFreeChart chart = ChartFactory.createPieChart3D((String)sTitle, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        DE_ChartFactory.setDeepEditChartStyle(chart);
        return chart;
    }

    public static JFreeChart createPieChart(String sTitle, PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart3D((String)sTitle, (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        DE_ChartFactory.setDeepEditChartStyle(chart);
        return chart;
    }

    private static void setDeepEditChartStyle(JFreeChart chart) {
        chart.setBackgroundPaint((Paint)Color.WHITE);
        Plot plot = chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        int nLegend = plot.getLegendItems().getItemCount();
        if (nLegend > 20) {
            chart.removeLegend();
        }
        if (plot instanceof CategoryPlot || plot instanceof XYPlot) {
            // empty if block
        }
    }

    private static int type2RenderType(int seriesType) {
        switch (seriesType) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
        }
        return 3;
    }

    private static CategoryItemRenderer getRendererType(int seriesType) {
        switch (seriesType) {
            case 5: {
                return new AreaRenderer();
            }
            case 7: {
                return new StackedAreaRenderer();
            }
            case 4: {
                return new BarRenderer();
            }
            case 6: {
                return new StackedBarRenderer();
            }
            case 3: {
                return new LineAndShapeRenderer();
            }
        }
        return new LineAndShapeRenderer();
    }

    public static void changeCategoryChartType(JFreeChart chart, int newChartType) {
        if (chart.getPlot() instanceof CategoryPlot) {
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setRenderer(0, DE_ChartFactory.getRendererType(newChartType));
            if (plot.getDatasetCount() > 1) {
                // empty if block
            }
        }
    }

    public static void replaceDataset(JFreeChart chart, DefaultCategoryDataset dataset, int index) {
        CategoryPlot plot;
        if (chart.getPlot() instanceof CategoryPlot && (plot = chart.getCategoryPlot()).getDatasetCount() > index) {
            plot.setDataset(index, (CategoryDataset)dataset);
        }
    }

    public static void sortDataset(JFreeChart chart, int index, boolean descending, boolean usePercentage) {
        block8: {
            CategoryPlot plot;
            if (chart.getPlot() instanceof CategoryPlot && (plot = chart.getCategoryPlot()).getDatasetCount() > index) {
                final boolean desc = descending;
                try {
                    DefaultCategoryDataset set = (DefaultCategoryDataset)plot.getDataset(index);
                    DefaultCategoryDataset clone_set = (DefaultCategoryDataset)set.clone();
                    set.clear();
                    for (Object oRow : clone_set.getRowKeys()) {
                        ArrayList<DatasetItem> lSerie = new ArrayList<DatasetItem>();
                        for (Object oCol : clone_set.getColumnKeys()) {
                            Number dValue = clone_set.getValue((Comparable)oRow, (Comparable)oCol);
                            lSerie.add(new DatasetItem((Comparable)oRow, (Comparable)oCol, dValue));
                        }
                        Collections.sort(lSerie, new Comparator<DatasetItem>(){

                            @Override
                            public int compare(DatasetItem o1, DatasetItem o2) {
                                if (desc) {
                                    return (int)Math.floor(o2.val.doubleValue() - o1.val.doubleValue());
                                }
                                return (int)Math.floor(o1.val.doubleValue() - o2.val.doubleValue());
                            }
                        });
                        int cont = 0;
                        for (DatasetItem d : lSerie) {
                            if (usePercentage) {
                                set.addValue(d.val, d.row, (Comparable)((Object)String.valueOf(Math.rint(100.0 * (double)cont / (double)lSerie.size()))));
                            } else {
                                set.addValue(d.val, d.row, (Comparable)((Object)String.valueOf(cont)));
                            }
                            ++cont;
                        }
                    }
                }
                catch (CloneNotSupportedException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)("What happened to clone?? Is this category dataset?" + e.getLocalizedMessage()));
                }
            }
        }
    }

    public static int chartTypeString2Integer(String chartType) {
        if (chartType == null) {
            return 3;
        }
        if ("".equals(chartType)) {
            return 3;
        }
        if ("Line".equalsIgnoreCase(chartType)) {
            return 3;
        }
        if ("Area".equalsIgnoreCase(chartType)) {
            return 5;
        }
        if ("AreaStack".equalsIgnoreCase(chartType)) {
            return 7;
        }
        if ("Column".equalsIgnoreCase(chartType)) {
            return 4;
        }
        if ("ColumnStack".equalsIgnoreCase(chartType)) {
            return 6;
        }
        if ("Pie".equalsIgnoreCase(chartType)) {
            return 2;
        }
        return 3;
    }
}

