/*
 * Decompiled with CFR 0.152.
 */
package de.solver.gmsi;

import de.core.DeepEdit;
import de.data.DE_ValidationException;
import de.solver.gmsi.GMSi_Set;
import javax.swing.table.DefaultTableModel;

class SetModel
extends DefaultTableModel {
    private final GMSi_Set set;
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_VALUE = "Value";
    private boolean editable = false;

    public SetModel(GMSi_Set set) {
        this.set = set;
        int nColumn = set.getDimension() <= 1 ? 2 : set.getDimension() + 1;
        Object[] columnNames = new String[nColumn];
        columnNames[0] = COLUMN_ID;
        if (set.isFundamental()) {
            columnNames[1] = COLUMN_VALUE;
        } else {
            int cont = 1;
            for (GMSi_Set parent : set.getParents()) {
                columnNames[cont] = parent.getName();
                ++cont;
            }
        }
        super.setColumnIdentifiers(columnNames);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public GMSi_Set getSet() {
        return this.set;
    }

    @Override
    public void addRow(Object[] row) {
        Object[] new_row = new Object[row.length + 1];
        new_row[0] = this.getRowCount() + 1;
        int cont = 1;
        Object[] arr$ = row;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object o;
            new_row[cont] = o = arr$[i$];
            ++cont;
        }
        super.addRow(new_row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.editable) {
            return column != 0;
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        assert (column != 0) : "Why are you editing index column?? Are you allowing user to move rows or changed COLUMN_INDEX_ID CONSTANTS??";
        int nElements = this.set.isFundamental() ? 1 : this.set.getDimension();
        Object[] newElement = new Object[nElements];
        Object[] oldElement = new Object[nElements];
        for (int i = 1; i < this.getColumnCount(); ++i) {
            newElement[i - 1] = i == column ? aValue : this.getValueAt(row, i);
            oldElement[i - 1] = this.getValueAt(row, i);
        }
        if (aValue != null) {
            try {
                int index = Integer.parseInt(this.getValueAt(row, 0).toString()) - 1;
                if (this.set.setValueAt(index, newElement) != null) {
                    super.setValueAt(aValue, row, column);
                }
            }
            catch (DE_ValidationException e) {
                DeepEdit.printlnToMessageTab("Invalid value found in row " + (row + 1) + " for parameter '" + this.set.getName() + "': " + e.getLocalizedMessage());
            }
        }
    }
}

