/*
 * Decompiled with CFR 0.152.
 */
package de.solver.gmsi;

import de.edil.pet.PETNew_Wizard;
import de.solver.DefaultSETVisualFrame;
import de.solver.gmsi.GMSi_Set;
import de.solver.gmsi.SetModel;
import de.utils.ExcelUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;

public class GmsiSETVisualFrame
extends DefaultSETVisualFrame {
    public GmsiSETVisualFrame(Dialog parent, GMSi_Set set, boolean editable) {
        super((Window)parent, set.getDisplayName(), editable);
        SetModel model = new SetModel(set);
        model.setEditable(editable);
        JTable tblSET = this.getSetTable();
        tblSET.setModel(model);
        tblSET.setAutoCreateRowSorter(false);
        List<GMSi_Set> lSets = set.getParents();
        for (int i = 0; i < set.getDimension(); ++i) {
            JComboBox<Object> comboBox = new JComboBox<Object>();
            TableColumn column = tblSET.getColumnModel().getColumn(i + 1);
            for (Object o : lSets.get(i).values()) {
                comboBox.addItem(o);
            }
            column.setCellEditor(new DefaultCellEditor(comboBox));
        }
        for (Object[] oElement : set.allValues()) {
            model.addRow(oElement);
        }
        this.setDescription(set.getDescription());
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if ("Paste".equalsIgnoreCase(event.getActionCommand())) {
                    GmsiSETVisualFrame.this.pasteFromClipboard();
                }
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(86, 2, false);
        tblSET.registerKeyboardAction(listener, "Paste", stroke, 0);
    }

    public void pasteFromClipboard() {
        JTable tblSET = this.getSetTable();
        SetModel model = (SetModel)tblSET.getModel();
        int nIniRow = tblSET.getSelectedRow();
        int nIniCol = tblSET.getSelectedColumn();
        int nMaxCol = tblSET.getColumnCount();
        int nMaxRow = tblSET.getRowCount();
        if (nIniCol == 0 || nIniRow == -1 || nIniCol == -1) {
            return;
        }
        int nPastedValues = 0;
        String[][] rawData = ExcelUtil.clipboardExcel2Array();
        if (rawData != null) {
            int nRow;
            int nYesNo = JOptionPane.showConfirmDialog(this, "Are you sure you want to paste values from clipboard?", "Paste from Clipboard", 0, 3);
            if (nYesNo == 1) {
                return;
            }
            for (int i = 0; i < rawData.length && (nRow = nIniRow + i) < nMaxRow; ++i) {
                int nCol;
                for (int k = 0; k < rawData[i].length && (nCol = nIniCol + k) < nMaxCol; ++k) {
                    if (rawData[i][k] == null) continue;
                    model.setValueAt(rawData[i][k], nRow, nCol);
                    ++nPastedValues;
                }
            }
            if (nPastedValues > 0) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeClosingWindow() {
        try {
            if (this.getParent() instanceof PETNew_Wizard) {
                ((PETNew_Wizard)this.getParent()).refreshLabels();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Set " + this.getTitle() + "' couldn't be updated! \nException info: " + e.getMessage(), "Unexpected error updating SET", 0);
            e.printStackTrace(System.err);
        }
    }
}

