/*
 * Decompiled with CFR 0.152.
 */
package de.solver.gmsi;

import de.core.Busbar;
import de.core.Constraint;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Schematic;
import de.core.Simulation;
import de.core.comp;
import de.core.hdb_link;
import de.core.hdb_res;
import de.core.hdb_unit;
import de.core.ndb_1pol;
import de.core.ndb_branch;
import de.data.DE_GeneralEnums;
import de.data.DE_ValidationException;
import de.data.DE_VariableEnums;
import de.data.ParameterData;
import de.solver.DE_Parameter;
import de.solver.DE_Set;
import de.solver.DE_solver;
import de.solver.DE_solverMappingInfo;
import de.solver.gmsi.GMSi_Parameter;
import de.solver.gmsi.GMSi_Set;
import de.solver.gmsi.GMSi_Subset;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class GMSi_solver
implements DE_solver {
    private static DE_solverMappingInfo DE_GamsMappingXML;
    private static final boolean USE_NEW_GAMS_FORMAT = false;

    @Override
    public DE_Set createClassSet(String sClassName) throws DE_ValidationException {
        Collection<comp> lComp = "Generator".equalsIgnoreCase(sClassName) ? DeepEdit.getActiveSchematic().getComponents(Generator.class) : ("Line".equalsIgnoreCase(sClassName) ? DeepEdit.getActiveSchematic().getComponents(ndb_branch.class) : ("hdb_unit".equalsIgnoreCase(sClassName) ? DeepEdit.getActiveSchematic().getComponents(hdb_unit.class) : DeepEdit.getComponents(sClassName)));
        assert (lComp != null) : "what is wrong with this class name??" + sClassName;
        GMSi_Set classSET = new GMSi_Set(sClassName);
        for (comp c : lComp) {
            ((DE_Set)classSET).add(c);
        }
        return classSET;
    }

    @Override
    public DE_Parameter createClassParameter(String parameterName, String sClassName) throws DE_ValidationException {
        GMSi_Parameter parameter = new GMSi_Parameter(sClassName + "::" + parameterName);
        for (String setName : GMSi_Parameter.getSetsFromParameterName(parameterName)) {
            DE_Set set = this.createDefaultSet(setName);
            parameter.addSet(set);
        }
        this.classParameter(parameter);
        return parameter;
    }

    @Override
    public DE_Set createSet(DE_GeneralEnums.ConstraintCategory category) throws DE_ValidationException {
        GMSi_Set constraintSet = new GMSi_Set(category.name());
        List<comp> constraints = DeepEdit.getComponents("Constraint");
        for (comp c : constraints) {
            if (((Constraint)c).getCategory() != category) continue;
            ((DE_Set)constraintSet).add(c);
        }
        return constraintSet;
    }

    @Override
    public DE_Parameter createLHSParameter(String name, Constraint[] c) throws DE_ValidationException {
        DE_Set set_constraint = this.createClassSet("Constraint");
        DE_Set set_comp = this.createCompSETFromConstraintList(c);
        GMSi_Parameter parameter = new GMSi_Parameter(name, set_constraint, set_comp);
        for (Constraint c1 : c) {
            for (int id : c1.getAllCoefficientIDs()) {
                Object[] o = new Object[]{c1, c1.getCoefficientComp(id)};
                ((DE_Parameter)parameter).setValue(c1.getCoefficientValue(id), o);
            }
        }
        return parameter;
    }

    @Override
    public DE_Parameter createLHSParameter(DE_GeneralEnums.ConstraintCategory category) throws DE_ValidationException {
        DE_Set set_constraint = this.createSet(category);
        GMSi_Set set_comp = new GMSi_Set("comp");
        for (String className : Constraint.getCategoryClassNameList(category)) {
            DE_Set set_class = this.createClassSet(className);
            ((DE_Set)set_comp).copyInto(set_class);
        }
        GMSi_Parameter parameter = new GMSi_Parameter(category.name() + "::" + "lhs(Constraint,comp)", set_constraint, set_comp);
        for (Constraint c : this.getConstraintList(category)) {
            for (int id : c.getAllCoefficientIDs()) {
                Object[] o = new Object[]{c, c.getCoefficientComp(id)};
                ((DE_Parameter)parameter).setValue(c.getCoefficientValue(id), o);
            }
        }
        return parameter;
    }

    public static DE_solverMappingInfo getSolverConfig(File mappingFile) {
        if (DE_GamsMappingXML == null) {
            GMSi_solver.initMappingFile(mappingFile);
        }
        return DE_GamsMappingXML;
    }

    private List<Constraint> getConstraintList(DE_GeneralEnums.ConstraintCategory category) {
        List<comp> constraints = DeepEdit.getComponents("Constraint");
        ArrayList<Constraint> lReturn = new ArrayList<Constraint>();
        for (comp c : constraints) {
            Constraint tempConstraint = (Constraint)c;
            if (tempConstraint.getCategory() != category) continue;
            lReturn.add(tempConstraint);
        }
        return lReturn;
    }

    private DE_Set createCompSETFromConstraintList(Constraint[] c) throws DE_ValidationException {
        GMSi_Set set_comp = new GMSi_Set("comp");
        LinkedList<String> lClass = new LinkedList<String>();
        for (Constraint c1 : c) {
            for (String className : Constraint.getCategoryClassNameList(c1.getCategory())) {
                if (lClass.contains(className)) continue;
                lClass.add(className);
            }
        }
        for (String className : lClass) {
            DE_Set set_class = this.createClassSet(className);
            set_class.copyInto(set_comp);
        }
        return set_comp;
    }

    public void constraintLHSParameter(DE_GeneralEnums.ConstraintCategory category, DE_Parameter parameter) throws DE_ValidationException {
        for (Constraint c : this.getConstraintList(category)) {
            for (int id : c.getAllCoefficientIDs()) {
                comp compCoeff = c.getCoefficientComp(id);
                double dValue = c.getCoefficientValue(id);
                parameter.setValue(dValue, compCoeff, c);
            }
        }
    }

    public void constraintRHSParameter(DE_GeneralEnums.ConstraintCategory category, DE_Parameter parameter) throws DE_ValidationException {
        for (Constraint c : this.getConstraintList(category)) {
            parameter.setValue(c.getRHS(), c);
        }
    }

    @Override
    public DE_Parameter createRHSParameter(String name, Constraint[] c) throws DE_ValidationException {
        DE_Set set_constraint = this.createClassSet("Constraint");
        GMSi_Parameter parameter = new GMSi_Parameter(name, set_constraint);
        for (Constraint c1 : c) {
            double dValue = c1.getRHS();
            ((DE_Parameter)parameter).setValue(dValue, c1);
        }
        return parameter;
    }

    @Override
    public DE_Parameter createRHSParameter(DE_GeneralEnums.ConstraintCategory category) throws DE_ValidationException {
        DE_Set set_constraint = this.createClassSet("Constraint");
        GMSi_Parameter parameter = new GMSi_Parameter(category.name() + "::" + "lhs(Constraint,comp)", set_constraint);
        for (Constraint c : this.getConstraintList(category)) {
            double dValue = c.getRHS();
            ((DE_Parameter)parameter).setValue(dValue, c);
        }
        return parameter;
    }

    @Override
    public void addToParameter(DE_Parameter parameterLHS, DE_Parameter parameterRHS, Constraint c) throws DE_ValidationException {
        for (int id : c.getAllCoefficientIDs()) {
            comp compCoeff = c.getCoefficientComp(id);
            double dValue = c.getCoefficientValue(id);
            parameterLHS.setValue(dValue, compCoeff, c);
        }
        parameterRHS.setValue(c.getRHS(), c);
    }

    public boolean addToParameter(String parameterDataName, String className, DE_Parameter parameter) throws DE_ValidationException {
        boolean bSuccess = true;
        for (comp c : DeepEdit.getComponents(className)) {
            ParameterData pData = c.getDefaultParameterInfo(parameterDataName);
            bSuccess &= c.getParameterInfo(parameterDataName, pData);
            bSuccess &= parameter.setValue(pData.getdValue(), c, parameterDataName);
        }
        return bSuccess;
    }

    @Override
    public void readParameterFromModel(File modelFile, List<DE_Set> setList, List<DE_Parameter> parameterList) throws FileNotFoundException, IOException {
        if (modelFile == null) {
            return;
        }
        if (parameterList == null) {
            return;
        }
        HashMap<String, DE_Set> mSet = new HashMap<String, DE_Set>(setList.size());
        for (DE_Set set : setList) {
            String sSolverName = set.getSolverName();
            DE_Set set0 = mSet.put(sSolverName, set);
            assert (set0 == null) : "Why this SET solver's name '" + sSolverName + "' is not unique? Did you forget to clear set before re-reading?";
        }
        int nLine = 1;
        Scanner scanner = new Scanner(modelFile);
        scanner.useDelimiter(System.getProperty("line.separator"));
        boolean bDataExpected = false;
        while (scanner.hasNext()) {
            String sLine = scanner.next().trim();
            if (sLine.startsWith("PARAMETER")) {
                while (scanner.hasNext()) {
                    sLine = scanner.next().trim();
                    ++nLine;
                    if (sLine.startsWith("/") || bDataExpected) continue;
                    if (sLine.isEmpty()) break;
                    String sParameterName = sLine;
                    String sParameterDescription = null;
                    int n = sLine.indexOf(" ");
                    if (n != -1) {
                        sParameterName = sLine.substring(0, n);
                        sParameterDescription = sLine.substring(n).trim();
                    }
                    GMSi_Parameter parameter = new GMSi_Parameter(sParameterName);
                    if (sParameterDescription != null) {
                        parameter.setDescription(sParameterDescription);
                    }
                    parameterList.add(parameter);
                }
            }
            ++nLine;
        }
    }

    @Override
    public void readSetFromModel(File modelFile, List<DE_Set> setList) throws IOException {
        if (modelFile == null) {
            return;
        }
        if (setList == null) {
            return;
        }
        assert (setList.isEmpty()) : "It is suspecious that you are passing a non-empty list to read a model. Elements in list: " + setList.size();
        int nLine = 0;
        Scanner scanner = new Scanner(modelFile);
        scanner.useDelimiter(System.getProperty("line.separator"));
        boolean bDataExpected = false;
        while (scanner.hasNext()) {
            String sLine = scanner.next().trim();
            if (sLine.startsWith("SET")) {
                ++nLine;
                continue;
            }
            if (sLine.startsWith("PARAMETER") || sLine.startsWith("SCALAR") || sLine.startsWith("TABLE")) break;
            if (bDataExpected) {
                bDataExpected = this.addToSet(sLine, setList, nLine);
            } else if (sLine.startsWith("/")) {
                sLine = sLine.replaceFirst("/", "");
                bDataExpected = this.addToSet(sLine, setList, nLine);
            } else if (!sLine.isEmpty()) {
                GMSi_Set new_set;
                String[] sParents;
                String sName = sLine;
                String sDescription = null;
                int n = sLine.indexOf(" ");
                if (n != -1) {
                    sName = sLine.substring(0, n);
                    sDescription = sLine.substring(n).trim();
                }
                if ((sParents = GMSi_Parameter.getSetsFromParameterName(sName)) != null) {
                    LinkedList<GMSi_Set> lParents = new LinkedList<GMSi_Set>();
                    for (String setName : sParents) {
                        GMSi_Set subset = (GMSi_Set)GMSi_Set.findSetNameInList(setName, setList, false);
                        assert (subset != null) : "Why this parent SET '" + setName + "' from multidim SET '" + sName + "' is not recognized?";
                        if (subset == null) continue;
                        lParents.add(subset);
                    }
                    new_set = new GMSi_Set(sName, lParents);
                } else {
                    new_set = new GMSi_Set(sName);
                }
                new_set.setDescription(sDescription);
                setList.add(new_set);
            }
            ++nLine;
        }
        scanner.close();
    }

    private boolean addToSet(String sLine, List<DE_Set> setList, int nLine) {
        String[] setObjectList = sLine.split(",");
        String setObjectName = "";
        boolean bDataExpected = true;
        for (int contObj = 0; contObj < setObjectList.length; ++contObj) {
            setObjectName = setObjectList[contObj].replaceFirst("/", "");
            assert (!setList.isEmpty()) : "Are you sure this is a valid file? line " + nLine;
            try {
                setList.get(setList.size() - 1).add(setObjectName.trim());
            }
            catch (DE_ValidationException e) {
                assert (false) : "What is wrong with model file?? " + e.getLocalizedMessage();
                e.printStackTrace(System.err);
            }
            if (!setObjectList[contObj].contains("/")) continue;
            bDataExpected = false;
            break;
        }
        return bDataExpected;
    }

    @Override
    public DE_Set createDefaultSet(String Name) {
        try {
            GMSi_Set DEset;
            if (DeepEdit.getDeepEditClasses().contains(Name)) {
                return this.createClassSet(Name);
            }
            for (DE_GeneralEnums.ConstraintCategory cc : DE_GeneralEnums.ConstraintCategory.values()) {
                if (!cc.name().equalsIgnoreCase(Name)) continue;
                return this.createSet(cc);
            }
            Simulation sim = DeepEdit.getActiveSimulation();
            Schematic actSch = DeepEdit.getActiveSchematic();
            if ("numloss".equalsIgnoreCase(Name)) {
                String sValue = sim.getParamaterValue("numloss");
                if (sValue != null) {
                    DEset = new GMSi_Set("numloss");
                    DEset.setConsecutiveNumericValues((int)Double.parseDouble(sValue));
                    return DEset;
                }
            } else if ("totalhydro".equalsIgnoreCase(Name)) {
                String sValue = sim.getParamaterValue("totalhydro");
                if (sValue != null) {
                    DEset = new GMSi_Set("totalhydro");
                    DEset.setConsecutiveNumericValues((int)Double.parseDouble(sValue));
                    return DEset;
                }
            } else {
                if ("periods".equalsIgnoreCase(Name)) {
                    List<String> lPeriods = sim.getPeriodNames();
                    DEset = new GMSi_Set("periods");
                    DEset.addAll((List)lPeriods);
                    return DEset;
                }
                if ("ldcs".equalsIgnoreCase(Name)) {
                    List<String> lLDCs = sim.getLDCNames();
                    DEset = new GMSi_Set("ldcs");
                    DEset.addAll((List)lLDCs);
                    return DEset;
                }
                if ("blocks".equalsIgnoreCase(Name)) {
                    List<String> lBlocks = sim.getBlockNames();
                    DEset = new GMSi_Set("blocks");
                    DEset.addAll((List)lBlocks);
                    return DEset;
                }
                if ("Name".equalsIgnoreCase(Name)) {
                    String sValue = sim.getParamaterValue("Name");
                    if (sValue != null) {
                        DEset = new GMSi_Set("Name");
                        DEset.add((Object)sValue);
                        return DEset;
                    }
                } else {
                    if ("ctrla".equalsIgnoreCase(Name)) {
                        List<String> lCtrla = DeepEdit.getCtrlaList();
                        DEset = new GMSi_Set("ctrla");
                        for (String s : lCtrla) {
                            DEset.add((Object)s);
                        }
                        return DEset;
                    }
                    if ("Generator_PET".equalsIgnoreCase(Name)) {
                        GMSi_Set DEset2 = new GMSi_Set("Generator_PET");
                        GMSi_Set genSet = (GMSi_Set)this.createClassSet("Generator");
                        GMSi_Set hdbSet = (GMSi_Set)this.createClassSet("hdb_units");
                        genSet.copyInto(DEset2);
                        hdbSet.copyInto(DEset2);
                        return DEset2;
                    }
                }
            }
        }
        catch (Exception e) {
            assert (false) : "What happened when creating set '" + Name + "'?? " + e.getMessage();
            e.printStackTrace(System.err);
            return null;
        }
        return null;
    }

    public DE_Set createDefaultMultidimSet(String Name, List<DE_Set> sets) throws DE_ValidationException {
        Schematic actSch = DeepEdit.getActiveSchematic();
        if ("Generator::con2".equalsIgnoreCase(Name)) {
            GMSi_Set setGenerator = (GMSi_Set)DE_Set.findSetNameInList("Generator", sets, true);
            GMSi_Set setBusbar = (GMSi_Set)DE_Set.findSetNameInList("Busbar", sets, true);
            if (setGenerator == null || setBusbar == null) {
                return null;
            }
            ArrayList<GMSi_Set> lParent = new ArrayList<GMSi_Set>();
            lParent.add(setGenerator);
            lParent.add(setBusbar);
            GMSi_Set setCon2 = new GMSi_Set(Name, lParent);
            for (comp c : setGenerator.getComponents()) {
                Busbar oCon2 = (Busbar)DeepEdit.getComponent(c.getcon2(), "Busbar");
                if (oCon2 == null) {
                    c.InformAllComponents();
                    oCon2 = (Busbar)DeepEdit.getComponent(c.getcon2(), "Busbar");
                }
                if (oCon2 != null) {
                    Object[] lo = new Object[]{c, oCon2};
                    setCon2.add(lo);
                    continue;
                }
                if (c instanceof ndb_1pol) assert (false) : "Why Generator " + c.getName() + " is not connected to any busbar?? Always validate schematic first!!";
            }
            return setCon2;
        }
        if ("Schematic::slackbusbar".equalsIgnoreCase(Name)) {
            GMSi_Set setBusbar = (GMSi_Set)DE_Set.findSetNameInList("Busbar", sets, true);
            if (setBusbar == null) {
                return null;
            }
            GMSi_Subset setSlackBus = new GMSi_Subset(Name, setBusbar);
            Busbar slackBus = actSch.getSlackBurbar();
            if (slackBus != null) {
                setSlackBus.add((Object)slackBus);
            }
            return setSlackBus;
        }
        if ("Simulation::initialperiod".equalsIgnoreCase(Name)) {
            GMSi_Set setPeriod = (GMSi_Set)DE_Set.findSetNameInList("periods", sets, true);
            if (setPeriod == null) {
                return null;
            }
            GMSi_Subset setInitPeriod = new GMSi_Subset(Name, setPeriod);
            return setInitPeriod;
        }
        if ("Simulation::initialldc".equalsIgnoreCase(Name)) {
            GMSi_Set setLDCs = (GMSi_Set)DE_Set.findSetNameInList("ldcs", sets, true);
            if (setLDCs == null) {
                return null;
            }
            GMSi_Subset setInitLDC = new GMSi_Subset(Name, setLDCs);
            return setInitLDC;
        }
        if ("Simulation::endperiod".equalsIgnoreCase(Name)) {
            GMSi_Set setPeriod = (GMSi_Set)DE_Set.findSetNameInList("periods", sets, true);
            if (setPeriod == null) {
                return null;
            }
            GMSi_Subset setEndPeriod = new GMSi_Subset(Name, setPeriod);
            return setEndPeriod;
        }
        if ("Simulation::endldc".equalsIgnoreCase(Name)) {
            GMSi_Set setLDCs = (GMSi_Set)DE_Set.findSetNameInList("ldcs", sets, true);
            if (setLDCs == null) {
                return null;
            }
            GMSi_Subset setEndLDC = new GMSi_Subset(Name, setLDCs);
            return setEndLDC;
        }
        if ("Simulation::initialhydroldc".equalsIgnoreCase(Name)) {
            GMSi_Set setLDCs = (GMSi_Set)DE_Set.findSetNameInList("ldcs", sets, true);
            if (setLDCs == null) {
                return null;
            }
            GMSi_Subset setInitHydro = new GMSi_Subset(Name, setLDCs);
            return setInitHydro;
        }
        if ("PET_rea::Generator".equalsIgnoreCase(Name)) {
            GMSi_Set setPET_rea = (GMSi_Set)DE_Set.findSetNameInList("PET_rea", sets, true);
            GMSi_Set setGenerator = (GMSi_Set)DE_Set.findSetNameInList("Generator", sets, true);
            if (setPET_rea == null || setGenerator == null) {
                return null;
            }
            GMSi_Set PET_reaGen = new GMSi_Set(Name, setPET_rea, setGenerator);
            for (comp c : setPET_rea.getComponents()) {
                Constraint PET_reaConstraint = (Constraint)c;
                for (int id : PET_reaConstraint.getAllCoefficientIDs()) {
                    Generator gen = (Generator)PET_reaConstraint.getCoefficientComp(id);
                    PET_reaGen.add(PET_reaConstraint, gen);
                }
            }
            return PET_reaGen;
        }
        if ("PET_rpa::Generator".equalsIgnoreCase(Name)) {
            GMSi_Set setPET_rpa = (GMSi_Set)DE_Set.findSetNameInList("PET_rpa", sets, true);
            GMSi_Set setGenerator = (GMSi_Set)DE_Set.findSetNameInList("Generator", sets, true);
            if (setPET_rpa == null || setGenerator == null) {
                return null;
            }
            GMSi_Set PET_rpaGen = new GMSi_Set(Name, setPET_rpa, setGenerator);
            for (comp c : setPET_rpa.getComponents()) {
                Constraint PET_rpaConstraint = (Constraint)c;
                for (int id : PET_rpaConstraint.getAllCoefficientIDs()) {
                    Generator gen = (Generator)PET_rpaConstraint.getCoefficientComp(id);
                    PET_rpaGen.add(PET_rpaConstraint, gen);
                }
            }
            return PET_rpaGen;
        }
        if ("PET_rpot::Generator".equalsIgnoreCase(Name)) {
            GMSi_Set setPET_rpot = (GMSi_Set)DE_Set.findSetNameInList("PET_rpot", sets, true);
            GMSi_Set setGenerator = (GMSi_Set)DE_Set.findSetNameInList("Generator", sets, true);
            if (setPET_rpot == null || setGenerator == null) {
                return null;
            }
            GMSi_Set PET_rpotGen = new GMSi_Set(Name, setPET_rpot, setGenerator);
            for (comp c : setPET_rpot.getComponents()) {
                Constraint PET_rpotConstraint = (Constraint)c;
                for (int id : PET_rpotConstraint.getAllCoefficientIDs()) {
                    Generator gen = (Generator)PET_rpotConstraint.getCoefficientComp(id);
                    PET_rpotGen.add(PET_rpotConstraint, gen);
                }
            }
            return PET_rpotGen;
        }
        if ("PET_rco::Generator".equalsIgnoreCase(Name)) {
            GMSi_Set setGenerator = (GMSi_Set)DE_Set.findSetNameInList("Generator", sets, true);
            if (setGenerator == null) {
                return null;
            }
            GMSi_Set PET_rco = new GMSi_Set(Name, setGenerator, setGenerator);
            for (Constraint pet_rco : this.getConstraintList(DE_GeneralEnums.ConstraintCategory.PET_rco)) {
                int[] ids = pet_rco.getAllCoefficientIDs();
                comp[] genRco = new comp[ids.length];
                assert (ids.length == 2) : "pet_rco Constraint should have only 2 coefficients. Why the Constraint builder allowed " + ids.length + " coefficients??";
                int cont = 0;
                for (int id : ids) {
                    genRco[cont] = pet_rco.getCoefficientComp(id);
                    assert (genRco[cont] instanceof Generator) : "Why this is not a generator? Coefficients in pet_rco Constraint should only belong to Generators. This object's class is " + genRco[cont].getClassName();
                    assert (pet_rco.getCoefficientValue(id) == 1.0) : "Why this coefficient is different from 1.0?";
                    ++cont;
                }
                PET_rco.add(genRco);
            }
            return PET_rco;
        }
        if ("PET_LRtx::Line_PET".equalsIgnoreCase(Name)) {
            GMSi_Set setLine = (GMSi_Set)DE_Set.findSetNameInList("Line", sets, true);
            GMSi_Set setBusbar = (GMSi_Set)DE_Set.findSetNameInList("Busbar", sets, true);
            GMSi_Set setPET_rtx = (GMSi_Set)DE_Set.findSetNameInList("PET_rtx", sets, true);
            if (setLine == null || setBusbar == null || setPET_rtx == null) {
                return null;
            }
            GMSi_Set PET_LRtx_LinePET = new GMSi_Set(Name, setPET_rtx, setLine, setBusbar, setBusbar);
            for (comp c : setPET_rtx.getComponents()) {
                assert (c instanceof Constraint) : "How a non-constraint object " + c.getName() + "[" + c.getClassName() + "] got into set " + setPET_rtx.getName();
                Constraint pet_rtx = (Constraint)c;
                for (int id : pet_rtx.getAllCoefficientIDs()) {
                    comp oc = pet_rtx.getCoefficientComp(id);
                    assert (oc instanceof ndb_branch) : "How could a comp different from ndb_branch ended up in Line's set?? Component: '" + c.getName() + " ;Class: " + c.getClassName() + "'";
                    ndb_branch cLine = (ndb_branch)oc;
                    comp cBusbar1 = cLine.getSenderComponent();
                    comp cBusbar2 = cLine.getReceiverComponent();
                    if (cBusbar1 == null || cBusbar2 == null) {
                        throw new DE_ValidationException("Invalid schematic! Branch '" + cLine.getName() + "' is not properly connected to busbars. Always check for valid schematic before creating case");
                    }
                    assert (pet_rtx.getCoefficientValue(id) == 1.0) : "Why this coefficient is different from 1.0?";
                    PET_LRtx_LinePET.add(pet_rtx, cLine, cBusbar1, cBusbar2);
                }
            }
            return PET_LRtx_LinePET;
        }
        return null;
    }

    @Override
    public boolean defaultSet(DE_Set set) throws DE_ValidationException {
        String setName = set.getName();
        DE_Set setAux = this.createDefaultSet(setName);
        return setAux.copyInto(set) > 0;
    }

    @Override
    public boolean defaultParameter(DE_Parameter de_parameter) throws DE_ValidationException {
        GMSi_Set paramSet;
        GMSi_Parameter parameter = (GMSi_Parameter)de_parameter;
        String parameterName = parameter.getName();
        Schematic actSch = DeepEdit.getActiveSchematic();
        Simulation actSim = DeepEdit.getActiveSimulation();
        ArrayList<ParameterData> lData = new ArrayList<ParameterData>();
        if (parameter.getComponentParameter(lData)) {
            for (ParameterData pData : lData) {
                try {
                    double dValue = Double.parseDouble(pData.getValue());
                    parameter.setValue(dValue, pData.getoOwnerComponent());
                }
                catch (NumberFormatException e) {
                    assert (false) : "Why parameter '" + parameterName + "' was mapped from GAMS but still not a double value?" + pData.getValue() + ". Details: " + e;
                    return false;
                }
            }
        }
        if (DeepEdit.getDeepEditClasses().contains(parameterName)) {
            this.classParameter(parameter);
        }
        for (DE_GeneralEnums.ConstraintCategory cc : DE_GeneralEnums.ConstraintCategory.values()) {
            if (cc.name().equalsIgnoreCase(parameterName) || (cc.name() + "::" + "lhs").equalsIgnoreCase(parameterName)) {
                this.constraintLHSParameter(cc, parameter);
                continue;
            }
            if (!(cc.name() + "::" + "rhs").equalsIgnoreCase(parameterName)) continue;
            this.constraintRHSParameter(cc, parameter);
        }
        if ("Generator_PET".equalsIgnoreCase(parameterName)) {
            paramSet = (GMSi_Set)parameter.getSet("parameterNames");
            GMSi_Set generatorSet = (GMSi_Set)parameter.getSet("Generator");
            for (comp c : generatorSet.getComponents()) {
                for (Object o : paramSet.values()) {
                    String sParameterName = DE_Parameter.getParameterNameFromValue(o.toString());
                    if (sParameterName == null || !c.isSupportedParameter(sParameterName)) continue;
                    String sValue = c.getParamaterValue(sParameterName);
                    try {
                        double dValue = Double.parseDouble(sValue);
                        parameter.setValue(dValue, c, o);
                    }
                    catch (NumberFormatException e) {
                        assert (false) : "Why " + c.getName() + "'s parameter '" + o.toString() + "' couldn't be mapped to double??";
                    }
                }
            }
        } else if ("Line_PET".equalsIgnoreCase(parameterName)) {
            paramSet = (GMSi_Set)parameter.getSet("parameterNames");
            GMSi_Set lineSet = (GMSi_Set)parameter.getSet("Line");
            for (comp c : lineSet.getComponents()) {
                assert (c instanceof ndb_branch) : "How could a comp different from ndb_branch ended up in Line's set?? Component: '" + c.getName() + " ;Class: " + c.getClassName() + "'";
                ndb_branch cLine = (ndb_branch)c;
                comp cBusbar1 = cLine.getSenderComponent();
                comp cBusbar2 = cLine.getReceiverComponent();
                assert (cBusbar1 != null && cBusbar2 != null) : "Invalid schematic! This branch is not properly connected to busbars. Always check valid before creating solver's case";
                for (Object o : paramSet.values()) {
                    String sParameterName = DE_Parameter.getParameterNameFromValue(o.toString());
                    if (sParameterName == null) continue;
                    try {
                        if (c.isSupportedParameter(sParameterName)) {
                            String sValue = c.getParamaterValue(sParameterName);
                            double dValue = Double.parseDouble(sValue);
                            parameter.setValue(dValue, cLine, cBusbar1, cBusbar2, o);
                            continue;
                        }
                        if ("r1_pu".equalsIgnoreCase(sParameterName)) {
                            parameter.setValue(cLine.getSeriesResistance(actSch.getsref()), cLine, cBusbar1, cBusbar2, o);
                            continue;
                        }
                        if (!"xx1_pu".equalsIgnoreCase(sParameterName)) continue;
                        parameter.setValue(cLine.getSeriesReactance(actSch.getsref()), cLine, cBusbar1, cBusbar2, o);
                    }
                    catch (NumberFormatException e) {
                        assert (false) : "Why " + c.getName() + "'s parameter '" + o.toString() + "' couldn't be mapped to double??";
                    }
                }
            }
        } else if (parameterName.startsWith("Line_PET::")) {
            GMSi_Set lineSet = (GMSi_Set)parameter.getSet("Line");
            for (comp c : lineSet.getComponents()) {
                assert (c instanceof ndb_branch) : "How could a comp different from ndb_branch ended up in Line's set?? Component: '" + c.getName() + " ;Class: " + c.getClassName() + "'";
                ndb_branch cLine = (ndb_branch)c;
                comp cBusbar1 = ((ndb_branch)c).getSenderComponent();
                comp cBusbar2 = ((ndb_branch)c).getReceiverComponent();
                assert (cBusbar1 != null && cBusbar2 != null) : "Invalid schematic! This branch is not properly connected to busbars. Always check valid before creating solver's case";
                String sParameterName = DE_Parameter.getParameterNameFromValue(parameterName);
                if (sParameterName == null) continue;
                if (c.isSupportedParameter(sParameterName)) {
                    String sValue = c.getParamaterValue(sParameterName);
                    try {
                        double dValue = Double.parseDouble(sValue);
                        parameter.setValue(dValue, c, cBusbar1, cBusbar2);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        assert (false) : "Why " + c.getName() + "'s parameter '" + sParameterName + "' couldn't be mapped to double??";
                        continue;
                    }
                }
                if ("r1_pu".equalsIgnoreCase(sParameterName)) {
                    parameter.setValue(cLine.getSeriesResistance(actSch.getsref()), cLine, cBusbar1, cBusbar2);
                    continue;
                }
                if (!"xx1_pu".equalsIgnoreCase(sParameterName)) continue;
                parameter.setValue(cLine.getSeriesReactance(actSch.getsref()), cLine, cBusbar1, cBusbar2);
            }
        } else if (!"Agreement_PET".equalsIgnoreCase(parameterName)) {
            if ("PET_irie::idrie".equalsIgnoreCase(parameterName)) {
                for (Constraint c : this.getConstraintList(DE_GeneralEnums.ConstraintCategory.PET_irie)) {
                    for (int id : c.getAllCoefficientIDs()) {
                        comp tempComp = c.getCoefficientComp(id);
                        double dValue = c.getCoefficientValue(id);
                        DE_VariableEnums.DE_Variable var = c.getCoefficientVariable(id);
                        String irie_constant = "";
                        if (var.equals(DE_VariableEnums.hdb_res.Flow_Filtered)) {
                            irie_constant = "Qver";
                        } else if (var.equals(DE_VariableEnums.hdb_res.Flow_Inflow)) {
                            irie_constant = "Qafl";
                        } else if (var.equals(DE_VariableEnums.hdb_res.Flow_Spilled)) {
                            irie_constant = "Qfil";
                        } else if (var.equals(DE_VariableEnums.hdb_res.Flow_Turbined)) {
                            irie_constant = "Qgen";
                        }
                        assert (!irie_constant.isEmpty()) : "Did you change PET_irie variable definition? What variable is this then?" + var.toString();
                        if (!(tempComp instanceof hdb_res)) continue;
                        parameter.setValue(dValue, c, tempComp, irie_constant);
                    }
                }
            } else if ("System::sref".equalsIgnoreCase(parameterName)) {
                double dSref = actSch.getsref();
                parameter.setValue(dSref, new Object[0]);
            } else if ("Busbar::beta".equalsIgnoreCase(parameterName)) {
                GMSi_Set busbarSet = (GMSi_Set)parameter.getSet("Busbar");
                for (comp c : busbarSet.getComponents()) {
                    double dValue = ((Busbar)c).getbeta();
                    if (dValue == 0.0) {
                        dValue = actSch.getUseprice();
                    }
                    parameter.setValue(dValue, c);
                }
            } else if ("System::maxuse".equalsIgnoreCase(parameterName)) {
                double dMaxUse = actSch.getMaxuse();
                parameter.setValue(dMaxUse, new Object[0]);
            } else if ("System::co2price".equalsIgnoreCase(parameterName)) {
                double dCo2price = actSch.getCo2price();
                GMSi_Set periodsSet = (GMSi_Set)parameter.getSet("periods");
                assert (periodsSet != null) : "Why this parameter doesn't have 'periods' SET??";
                for (Object o : periodsSet.values()) {
                    parameter.setValue(dCo2price, o);
                }
            } else if ("System::intrate".equalsIgnoreCase(parameterName)) {
                double dIntRate = actSch.getintrate();
                parameter.setValue(dIntRate, new Object[0]);
            } else if ("System::reservevioprice".equalsIgnoreCase(parameterName)) {
                double dReservevioprice = actSch.getReservevioprice();
                parameter.setValue(dReservevioprice, new Object[0]);
            } else if ("System::minreserve".equalsIgnoreCase(parameterName)) {
                double dMinreserve = actSch.getReservevioprice();
                parameter.setValue(dMinreserve, new Object[0]);
            } else if ("System::flow2volume".equalsIgnoreCase(parameterName)) {
                double dFlow2volume = actSch.getFlow2volume();
                parameter.setValue(dFlow2volume, new Object[0]);
            } else if ("PET_rea::price".equalsIgnoreCase(parameterName)) {
                GMSi_Set pet_reaSet = (GMSi_Set)parameter.getSet("PET_rea");
                if (pet_reaSet == null) {
                    return false;
                }
                for (comp c : pet_reaSet.getComponents()) {
                    double dPrice = ((Constraint)c).getPenaltyPrice();
                    parameter.setValue(dPrice, c);
                }
            } else if ("FCF::rhs".equalsIgnoreCase(parameterName)) {
                GMSi_Set fcfSet = (GMSi_Set)parameter.getSet("FCF");
                if (fcfSet == null) {
                    return false;
                }
                for (comp c : fcfSet.getComponents()) {
                    double dRHS = ((Constraint)c).getRHS();
                    parameter.setValue(dRHS, c);
                }
            } else if ("hdb_res::link_turb".equalsIgnoreCase(parameterName)) {
                GMSi_solver.setHdb_link(actSch, parameter);
            } else if ("hdb_res::link_filt".equalsIgnoreCase(parameterName)) {
                GMSi_solver.setHdb_link(actSch, parameter);
            } else if ("hdb_res::link_spill".equalsIgnoreCase(parameterName)) {
                GMSi_solver.setHdb_link(actSch, parameter);
            } else if ("PET_MPExcG".equalsIgnoreCase(parameterName)) {
                this.PETgen_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory.PET_pex, parameter);
            } else if ("PET_MPConjG".equalsIgnoreCase(parameterName)) {
                this.PETgen_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory.PET_pco, parameter);
            } else if ("PET_MPPrecG".equalsIgnoreCase(parameterName)) {
                this.PETgen_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory.PET_pre, parameter);
            } else if ("PET_MPExcT".equalsIgnoreCase(parameterName)) {
                this.PETline_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory.PET_pex, parameter);
            } else if ("PET_MPPrecT".equalsIgnoreCase(parameterName)) {
                this.PETline_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory.PET_pre, parameter);
            } else if ("PET_MPConjT".equalsIgnoreCase(parameterName)) {
                this.PETline_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory.PET_pco, parameter);
            } else if ("PET_MPCamET".equalsIgnoreCase(parameterName)) {
                this.PETline_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory.PET_pce, parameter);
            } else if ("PET_MPCamNT".equalsIgnoreCase(parameterName)) {
                this.PETline_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory.PET_pcn, parameter);
            }
        }
        return true;
    }

    public void classParameter(GMSi_Parameter parameter) throws DE_ValidationException {
        GMSi_Set paramSet = (GMSi_Set)parameter.getSet("parameterNames");
        GMSi_Set classSet = (GMSi_Set)parameter.getSet(parameter.getName());
        assert (classSet != null) : "This is not a valid Class Parameter! '" + paramSet.getName() + "'";
        assert (paramSet != null) : "Class Parameters should have 1 SET called 'parameterNames'";
        if (classSet == null) {
            return;
        }
        for (Object o : paramSet.values()) {
            for (comp c : classSet.getComponents()) {
                String sParameterName = DE_Parameter.getParameterNameFromValue(o.toString());
                if (sParameterName == null || !c.isSupportedParameter(sParameterName)) continue;
                String sValue = c.getParamaterValue(sParameterName);
                try {
                    double dValue = Double.parseDouble(sValue);
                    parameter.setValue(dValue, c, o);
                }
                catch (NumberFormatException e) {
                    assert (false) : "Why '" + c.getClassName() + "' class parameter '" + sParameterName + "' was mapped from GAMS but still not a double value?" + sValue + ". Details: " + e;
                }
            }
        }
    }

    private void PETgen_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory cc, GMSi_Parameter parameter) throws DE_ValidationException {
        for (Constraint c : this.getConstraintList(cc)) {
            for (int id : c.getAllCoefficientIDs()) {
                comp tempComp = c.getCoefficientComp(id);
                double dValue = c.getCoefficientValue(id);
                if (tempComp instanceof Generator) {
                    parameter.setValue(dValue, tempComp, c);
                    continue;
                }
                assert (tempComp instanceof ndb_branch) : "How this component '" + tempComp.getClassName() + "' got into constraint type '" + cc.name() + "'";
            }
        }
    }

    private void PETline_constraintLHSParameter(DE_GeneralEnums.ConstraintCategory cc, GMSi_Parameter parameter) throws DE_ValidationException {
        for (Constraint c : this.getConstraintList(cc)) {
            for (int id : c.getAllCoefficientIDs()) {
                comp tempComp = c.getCoefficientComp(id);
                double dValue = c.getCoefficientValue(id);
                if (tempComp instanceof ndb_branch) {
                    comp cBusbar1 = ((ndb_branch)tempComp).getSenderComponent();
                    comp cBusbar2 = ((ndb_branch)tempComp).getReceiverComponent();
                    assert (cBusbar1 != null && cBusbar2 != null) : "Invalid schematic! This branch is not properly connected to busbars. Always check valid before creating solver's case";
                    parameter.setValue(dValue, tempComp, cBusbar1, cBusbar2, c);
                    continue;
                }
                assert (tempComp instanceof Generator) : "How this component '" + tempComp.getClassName() + "' got into constraint type '" + cc.name() + "'";
            }
        }
    }

    private static void setHdb_link(Schematic actSch, GMSi_Parameter parameter) throws DE_ValidationException {
        String parameterName = parameter.getName();
        Collection<comp> lRes = actSch.getComponents(hdb_unit.class);
        for (comp hydroUnit : lRes) {
            for (hdb_link riverUpLink : ((hdb_unit)hydroUnit).getRiverUpLinks()) {
                if (riverUpLink.InformEndComponents()) {
                    hdb_unit riverUpUnit = riverUpLink.getUnitIN();
                    if (riverUpLink.getTipoInput().contains("Filtering from ") && "hdb_res::link_filt".equalsIgnoreCase(parameterName)) {
                        parameter.setValue(1.0, hydroUnit, riverUpUnit);
                        continue;
                    }
                    if (riverUpLink.getTipoInput().contains("Spilled from ") && "hdb_res::link_spill".equalsIgnoreCase(parameterName)) {
                        parameter.setValue(1.0, hydroUnit, riverUpUnit);
                        continue;
                    }
                    if (riverUpLink.getTipoInput().contains("Turbined from ") && "hdb_res::link_turb".equalsIgnoreCase(parameterName)) {
                        parameter.setValue(1.0, hydroUnit, riverUpUnit);
                        continue;
                    }
                    if (!riverUpLink.getTipoInput().contains("Affluent")) continue;
                }
                System.out.println("Warning: Hydro component " + riverUpLink.getName() + " is not correctly connected and wasn't added to Parameter " + parameter.getName());
            }
        }
    }

    public static String getDE_GAMSMappingValue(String gmsSetParameterName, boolean useSolverName, int parameterType, File mappingFile) {
        if (DE_GamsMappingXML == null && !GMSi_solver.initMappingFile(mappingFile)) {
            return null;
        }
        return DE_GamsMappingXML.getMappingInfoValue(gmsSetParameterName, useSolverName, parameterType);
    }

    public static String getDeepEditSETName(String gmsSetParameterName, File mappingFile) {
        if (DE_GamsMappingXML == null && !GMSi_solver.initMappingFile(mappingFile)) {
            return null;
        }
        return DE_GamsMappingXML.getDeepEditName(gmsSetParameterName);
    }

    public static String getSolverSETName(String DE_ParameterName, File mappingFile) {
        if (DE_GamsMappingXML == null && !GMSi_solver.initMappingFile(mappingFile)) {
            return null;
        }
        return DE_GamsMappingXML.getSolverName(DE_ParameterName);
    }

    private static boolean initMappingFile(File mappingFile) {
        if (mappingFile == null) {
            // empty if block
        }
        if (mappingFile != null) {
            if (mappingFile.exists()) {
                try {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DE_solverMappingInfo.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    DE_GamsMappingXML = (DE_solverMappingInfo)jaxbUnmarshaller.unmarshal(mappingFile);
                    return true;
                }
                catch (JAXBException ex) {
                    System.out.println("Error parsing parameter config file: " + ex.getMessage());
                    ex.printStackTrace(System.err);
                }
            } else {
                System.out.println("Error reading GAMS-DE mapping file. File not found: " + mappingFile.getAbsolutePath());
            }
        }
        return false;
    }

    public static boolean isDeepEditSETName(String gmsSetParameterName, File mappingFile) {
        return GMSi_solver.getDeepEditSETName(gmsSetParameterName, mappingFile) != null;
    }

    public static String getValidation_Rule(String gmsSetParameterName, File mappingFile) {
        if (DE_GamsMappingXML == null && !GMSi_solver.initMappingFile(mappingFile)) {
            return null;
        }
        return DE_GamsMappingXML.getValidation_Rule(gmsSetParameterName);
    }

    @Override
    public void writeSetToFile(File dataFile, List<DE_Set> setList) throws IOException {
        if (dataFile.exists()) {
            dataFile.delete();
        }
        PrintStream ps = new PrintStream(dataFile);
        ps.println("SETS");
        for (DE_Set set : setList) {
            GMSi_Set setGms = (GMSi_Set)set;
            if (setGms.isEmpty() && (!setGms.isEmpty() || setGms.getDimension() != 0)) continue;
            if (setGms.getSolverName() != null) {
                ps.println(setGms.getSolverName() + " " + setGms.getDescription());
            } else {
                ps.println(setGms.getName() + " " + setGms.getDescription());
            }
            ps.println(" /");
            int lastValue = set.size() - 1;
            int cont = 0;
            if (!setGms.isEmpty()) {
                for (String s : setGms.setToStringLine(true, false, false)) {
                    if (cont != lastValue) {
                        ps.println(" " + s + ",");
                    } else {
                        ps.println(" " + s);
                    }
                    ++cont;
                }
            } else {
                ps.println(" undef");
            }
            ps.println(" /");
        }
        ps.close();
    }

    @Override
    public void writeParameterToFile(File dataFile, List<DE_Parameter> parameterList) throws IOException {
        String sParameterName;
        LinkedList<GMSi_Parameter> lScalars = new LinkedList<GMSi_Parameter>();
        LinkedList<GMSi_Parameter> lParameters = new LinkedList<GMSi_Parameter>();
        LinkedList<GMSi_Parameter> lTables = new LinkedList<GMSi_Parameter>();
        for (DE_Parameter parameter : parameterList) {
            GMSi_Parameter gmsParameter = (GMSi_Parameter)parameter;
            if (gmsParameter.isEmpty()) continue;
            if (gmsParameter.isScalar()) {
                lScalars.add(gmsParameter);
                continue;
            }
            if (gmsParameter.isTable()) {
                lTables.add(gmsParameter);
                continue;
            }
            lParameters.add(gmsParameter);
        }
        PrintStream ps = new PrintStream(new FileOutputStream(dataFile, true));
        if (!lScalars.isEmpty()) {
            ps.println("SCALARS");
        }
        for (GMSi_Parameter scalar : lScalars) {
            sParameterName = scalar.getSolverName();
            ps.print(sParameterName + " ");
            if (scalar.getDescription() != null) {
                ps.print(scalar.getDescription());
            }
            ps.print("/");
            for (String s : scalar.parameterToStringLine(true, true)) {
                ps.print(s);
            }
            ps.println("/;");
        }
        if (!lParameters.isEmpty()) {
            ps.println("PARAMETERS");
        }
        for (GMSi_Parameter param : lParameters) {
            sParameterName = param.getSolverName();
            ps.print(sParameterName + " ");
            if (param.getDescription() != null) {
                ps.println(param.getDescription());
            }
            ps.println("/");
            for (String s : param.parameterToStringLine(true, true)) {
                ps.println(s);
            }
            ps.println("/;");
        }
        if (!lTables.isEmpty()) {
            // empty if block
        }
        for (GMSi_Parameter table : lTables) {
            sParameterName = table.getSolverName();
            ps.print(sParameterName + " ");
            if (table.getDescription() != null) {
                ps.println(table.getDescription());
            }
            ps.println("/");
            for (String s : table.parameterToStringLine(true, true)) {
                ps.println(s);
            }
            ps.println("/;");
        }
        ps.close();
    }
}

