/*
 * Decompiled with CFR 0.152.
 */
package de.solver.gmsi;

import de.data.DE_ValidationException;
import de.solver.DE_Set;
import de.solver.gmsi.GMSi_Set;
import de.solver.gmsi.GMSi_SetRecord;
import java.util.LinkedList;
import java.util.List;

public class GMSi_Subset
extends GMSi_Set {
    public GMSi_Subset(String setName, GMSi_Set parent) {
        super(setName, parent);
    }

    @Override
    public boolean add(Object o) throws DE_ValidationException {
        if (this.getParent().contains(o)) {
            return super.add(o);
        }
        throw new DE_ValidationException("SET identifier '" + o.toString() + "' was not found parent SET '" + this.getParent().getDisplayName() + "'");
    }

    public boolean add(String label, Object o) throws DE_ValidationException {
        if (this.getParent().contains(o)) {
            return super.add(label, o);
        }
        throw new DE_ValidationException("SET identifier '" + o.toString() + "' was not found parent SET '" + this.getParent().getDisplayName() + "'");
    }

    public boolean isValidRecord(Object o) {
        return this.getParent().contains(o);
    }

    @Override
    public int copyInto(DE_Set destSet) throws DE_ValidationException {
        assert (destSet.getDimension() == this.getDimension()) : "This will crash other SET functions since these sets have different dimensions. Source set '" + this.getName() + "' has '" + this.getDimension() + "' and destination SET '" + destSet.getName() + "' has '" + destSet.getDimension() + "' parents";
        int cont = 0;
        for (GMSi_SetRecord rec : this.lRecords) {
            if (destSet instanceof GMSi_Set) {
                if (!((GMSi_Set)destSet).add(rec.toString(), rec.getValues())) continue;
                ++cont;
                continue;
            }
            if (!destSet.add(rec.getValue())) continue;
            ++cont;
        }
        return cont;
    }

    @Override
    public List<Object> values() {
        assert (this.getDimension() == 1) : "Why this subset is not 1-dimensional SET '" + this.getName() + "'??";
        LinkedList<Object> lRet = new LinkedList<Object>();
        for (GMSi_SetRecord rec : this.lRecords) {
            lRet.add(rec.getValue());
        }
        return lRet;
    }

    public GMSi_Set getParent() {
        return this.getParents().get(0);
    }

    @Override
    public boolean isFundamental() {
        return false;
    }

    @Override
    public int getMaximumSize() {
        return this.getParent().size();
    }

    @Override
    public GMSi_Subset clone() {
        GMSi_Subset cloneSet = new GMSi_Subset(this.getName(), this.getParent());
        cloneSet.setDataSource(this.getDataSource());
        cloneSet.setDescription(this.getDescription());
        cloneSet.setFirstValueLocation(this.getFirstValueLocation());
        cloneSet.setHeaderLocation(this.getHeaderLocation());
        cloneSet.setSolverName(this.getSolverName());
        cloneSet.setDisplayName(this.getDisplayName());
        cloneSet.setDefault_value(this.getDefault_value());
        cloneSet.setInitialize(this.isInitialize());
        cloneSet.setMandatory(this.isMandatory());
        cloneSet.setValidation_rule(this.getValidation_rule());
        return cloneSet;
    }
}

