/*
 * Decompiled with CFR 0.152.
 */
package de.solver.gmsi;

import de.core.comp;
import de.data.DE_ValidationException;
import de.data.ValidationRule;
import de.solver.DE_Set;
import de.solver.gmsi.GMSi_SetRecord;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GMSi_Set
extends DE_Set {
    protected List<GMSi_SetRecord> lRecords = new LinkedList<GMSi_SetRecord>();
    private List<GMSi_Set> parents = new LinkedList<GMSi_Set>();
    private static final boolean DUPLICATES_OK = false;
    public static final String LIST_SEPARATOR = ",";
    public static final String DATA_BLOCK_SEPARATOR = "/";
    public static final String MULTIDIM_SET_SEPARATOR = ".";
    public static final String EMPTY_FUNDAMENTAL_VALUE = "undef";

    public GMSi_Set(String setName) {
        super(setName, 0);
    }

    public GMSi_Set(String setName, List<GMSi_Set> parents) {
        super(setName, parents.size());
        this.addParents(parents.toArray(new GMSi_Set[parents.size()]));
    }

    public GMSi_Set(String setName, GMSi_Set ... parents) {
        super(setName, parents.length);
        this.addParents(parents);
    }

    public void setConsecutiveNumericValues(int totalObjects) {
        for (int ii = 0; ii < totalObjects; ++ii) {
            this.lRecords.add(new GMSi_SetRecord(ii + 1));
        }
    }

    public boolean add(Object object) throws DE_ValidationException {
        if (this.isValidRecord(object)) {
            return this.lRecords.add(new GMSi_SetRecord(object));
        }
        return false;
    }

    public boolean add(Object ... oElement) throws DE_ValidationException {
        if (this.isValidRecord(oElement)) {
            return this.lRecords.add(new GMSi_SetRecord(oElement));
        }
        return false;
    }

    public boolean add(String sLabel, Object ... oElement) throws DE_ValidationException {
        if (sLabel == null || oElement == null) {
            return false;
        }
        if (this.isValidRecord(oElement)) {
            return this.lRecords.add(new GMSi_SetRecord(sLabel, oElement));
        }
        return false;
    }

    public boolean addAll(List list) throws DE_ValidationException {
        boolean isOK = true;
        for (Object o : list) {
            isOK &= this.add(o);
        }
        return isOK;
    }

    public boolean addParents(GMSi_Set ... lSets) {
        assert (lSets.length == this.getDimension()) : "Why you are not adding all parent SETS at once to multi-dimensional SET '" + this.getName() + "'";
        boolean isAdded = true;
        for (GMSi_Set set : lSets) {
            set.addSetChangeListener(this);
            assert (set.isFundamental()) : "Why are adding non-fundamental set ' " + set.getName() + "' with dimension [" + this.getDimension() + "] when only Fundamental SETs can be parents to multidim SETs??";
            isAdded &= this.parents.add(set);
        }
        return isAdded;
    }

    public boolean setValue(Object o) throws DE_ValidationException {
        return this.add(o);
    }

    public Object[] setValueAt(int index, Object[] oElement) throws DE_ValidationException {
        GMSi_SetRecord rec;
        if (this.isValidRecord(oElement) && (rec = this.lRecords.set(index, new GMSi_SetRecord(oElement))) != null) {
            return rec.getValues();
        }
        return null;
    }

    public boolean setValues(List objectList) throws DE_ValidationException {
        boolean bIsAdded = true;
        for (Object o : objectList) {
            bIsAdded &= this.add(o);
        }
        return bIsAdded;
    }

    public boolean remove(Object oElement) {
        int index = this.indexOfRecord(new Object[]{oElement});
        if (index != -1) {
            return this.remove(index);
        }
        return false;
    }

    public boolean remove(int index) {
        assert (index < this.lRecords.size()) : "Why are you trying to remove an index '" + index + "' outside of the bounds of SET '" + this.getName() + "'?? Size=" + this.size();
        GMSi_SetRecord rec = this.lRecords.remove(index);
        if (rec != null) {
            if (this.isFundamental()) {
                this.itemRemoved(rec.getValue(), this);
            }
            return true;
        }
        return false;
    }

    public boolean remove(Object ... oElements) {
        int index = this.indexOfRecord(oElements);
        if (index != -1) {
            return this.remove(index);
        }
        return false;
    }

    private GMSi_SetRecord getRecord(Object[] oElements) {
        int index = this.indexOfRecord(oElements);
        if (index != -1) {
            return this.lRecords.get(index);
        }
        return null;
    }

    @Override
    public void clear() {
        int rows = this.lRecords.size();
        for (int i = rows - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void refresh() {
        LinkedList<GMSi_SetRecord> lRec = new LinkedList<GMSi_SetRecord>(this.lRecords);
        block0: for (GMSi_SetRecord rec : lRec) {
            for (Object o : rec.getValues()) {
                if (o != null) continue;
                this.lRecords.remove(rec);
                continue block0;
            }
        }
    }

    public void removeParents() {
        assert (this.isEmpty()) : "Never clear parents of non-empty SETs!! " + this.getName() + " contain " + this.size() + " elements";
        if (this.parents != null) {
            this.parents.clear();
        }
    }

    public List<GMSi_Set> getParents() {
        return this.parents;
    }

    public GMSi_Set getParent(String parentName, boolean useDeepEditName) {
        if (parentName == null || this.parents == null) {
            return null;
        }
        for (GMSi_Set set : this.parents) {
            if (useDeepEditName && set.getName().equalsIgnoreCase(parentName)) {
                return set;
            }
            if (useDeepEditName || !set.getSolverName().equalsIgnoreCase(parentName)) continue;
            return set;
        }
        return null;
    }

    public boolean replaceValue(Object oldObject, Object newObject) {
        return this.replaceValue(oldObject, newObject, null);
    }

    public boolean replaceValue(Object oldObject, Object newObject, String sNewLable) {
        if (this.getDimension() != 0) {
            return false;
        }
        int index = this.indexOfRecord(new Object[]{oldObject});
        if (index != -1) {
            if (sNewLable == null) {
                return this.lRecords.set(index, new GMSi_SetRecord(newObject)) != null;
            }
            return this.lRecords.set(index, new GMSi_SetRecord(sNewLable, newObject)) != null;
        }
        return false;
    }

    public void setLabel(String sNewLabel, Object ... oElements) {
        int index = this.indexOfRecord(oElements);
        assert (index >= 0) : "Why are you changing the label to a list of objects that doesn't belong to this SET";
        if (index >= 0) {
            this.setLabel(index, sNewLabel);
        }
    }

    public void setLabel(int index, String sNewLabel) {
        GMSi_SetRecord rec = this.lRecords.get(index);
        if (rec != null) {
            rec.setDisplayName(sNewLabel);
        }
    }

    public List<Object> values() {
        assert (this.getDimension() <= 1) : "Why are you using a specific 1-dimensional function when SET '" + this.getName() + "' is a multidim set??";
        LinkedList<Object> lRet = new LinkedList<Object>();
        for (GMSi_SetRecord rec : this.lRecords) {
            lRet.add(rec.getValue());
        }
        return lRet;
    }

    public List<Object[]> allValues() {
        LinkedList<Object[]> lRet = new LinkedList<Object[]>();
        for (GMSi_SetRecord rec : this.lRecords) {
            lRet.add(rec.getValues());
        }
        return lRet;
    }

    public Collection<Object> keySet() {
        LinkedList<Object> lRet = new LinkedList<Object>();
        for (GMSi_SetRecord rec : this.lRecords) {
            lRet.add(rec.toString());
        }
        return lRet;
    }

    @Override
    public Iterator iterator() {
        return this.values().iterator();
    }

    @Override
    public int size() {
        return this.lRecords.size();
    }

    @Override
    public boolean isEmpty() {
        return this.lRecords.isEmpty();
    }

    public boolean contains(Object o) {
        return this.indexOfRecord(new Object[]{o}) != -1;
    }

    @Override
    public List<comp> getComponents() {
        LinkedList<comp> lRet = new LinkedList<comp>();
        assert (this.getDimension() == 0) : "This is a 1-dimensional exclusive function!";
        for (GMSi_SetRecord rec : this.lRecords) {
            Object o = rec.getValue();
            if (!(o instanceof comp)) continue;
            lRet.add((comp)o);
        }
        return lRet;
    }

    public int indexOf(Object o) {
        if (o instanceof Object[]) {
            return this.indexOfRecord((Object[])o);
        }
        return this.indexOfRecord(new Object[]{o});
    }

    private int indexOfRecord(Object[] oElements) {
        int cont = 0;
        for (GMSi_SetRecord record : this.lRecords) {
            if (record.toString().equalsIgnoreCase(GMSi_SetRecord.createLabel(oElements))) {
                return cont;
            }
            if (Arrays.equals(record.getValues(), oElements)) {
                return cont;
            }
            if (Arrays.hashCode(record.getValues()) == Arrays.hashCode(oElements)) {
                return cont;
            }
            ++cont;
        }
        return -1;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.lRecords.size()) {
            return null;
        }
        return this.lRecords.get(index).getValue();
    }

    public Object get(String sLabel) {
        if (sLabel == null) {
            return null;
        }
        for (GMSi_SetRecord rec : this.lRecords) {
            if (!rec.toString().equalsIgnoreCase(sLabel)) continue;
            return rec.getValue();
        }
        return null;
    }

    public Object[] getAll(int index) {
        return this.lRecords.get(index).getValues();
    }

    public String getDisplayName(int index) {
        GMSi_SetRecord rec = this.lRecords.get(index);
        if (rec != null) {
            return rec.toString();
        }
        return null;
    }

    public String getDisplayName(Object o) {
        assert (this.getDimension() == 0) : "This function is not meant to be used with non-fundamental SETs";
        GMSi_SetRecord rec = this.getRecord(new Object[]{o});
        if (rec != null) {
            return rec.toString();
        }
        return null;
    }

    public String getDisplayName(Object[] oElements) {
        GMSi_SetRecord rec = this.getRecord(oElements);
        if (rec != null) {
            return rec.toString();
        }
        return null;
    }

    public Object[] getAll(String sLabel) {
        if (sLabel == null) {
            return null;
        }
        for (GMSi_SetRecord rec : this.lRecords) {
            if (!sLabel.equalsIgnoreCase(rec.toString())) continue;
            return rec.getValues();
        }
        return null;
    }

    @Override
    public int copyInto(DE_Set destSet) throws DE_ValidationException {
        assert (destSet.getDimension() == this.getDimension()) : "This will crash other SET functions since these sets have different dimensions. Source set '" + this.getName() + "' has '" + this.getDimension() + "' and destination SET '" + destSet.getName() + "' has '" + destSet.getDimension() + "' parents";
        int cont = 0;
        for (GMSi_SetRecord rec : this.lRecords) {
            if (destSet instanceof GMSi_Set) {
                if (!((GMSi_Set)destSet).add(rec.toString(), rec.getValues())) continue;
                ++cont;
                continue;
            }
            if (!destSet.add(rec.getValue())) continue;
            ++cont;
        }
        return cont;
    }

    public boolean contains(Object[] oElement) {
        return this.indexOfRecord(oElement) != -1;
    }

    public static boolean checkValidationRule(Object o, String validation_rule) {
        if (validation_rule == null) {
            return true;
        }
        return ValidationRule.isValid(o.toString(), validation_rule);
    }

    public boolean isValidRecord(String sLabel) throws DE_ValidationException {
        String[] splitLabel = sLabel.split("\\.");
        if (splitLabel.length != this.parents.size()) {
            return false;
        }
        boolean bIsValid = true;
        for (int i = 0; i < splitLabel.length; ++i) {
            Object o = this.parents.get(i).get(splitLabel[i]);
            bIsValid &= o != null;
            if (o == null) {
                throw new DE_ValidationException("sub-SET value " + splitLabel[i] + "' not found in parent SET '" + this.parents.get(i).getName() + "'");
            }
            if (GMSi_Set.checkValidationRule(o.toString(), this.getValidation_rule())) continue;
            throw new DE_ValidationException(splitLabel[i], this.getValidation_rule(), "SET value validation rule violation", this.getFirstValueLocation());
        }
        return bIsValid;
    }

    public int getMaximumSize() {
        if (this.isFundamental()) {
            return this.size();
        }
        int size = 1;
        for (GMSi_Set set : this.getParents()) {
            size *= ((DE_Set)set).size();
        }
        return size;
    }

    public boolean isValidRecord(Object ... oElement) throws DE_ValidationException {
        assert (oElement != null) : "How this null got this far??? " + this.getName();
        if (this.parents == null) {
            assert (oElement.length == 1) : "Why are you including '" + oElement.length + "' elements to fundamental SET " + this.getName() + "??";
            if (!GMSi_Set.checkValidationRule(oElement[0].toString(), this.getValidation_rule())) {
                throw new DE_ValidationException(oElement[0].toString(), this.getValidation_rule(), "SET value validation rule violation", this.getFirstValueLocation());
            }
            return oElement.length == 1;
        }
        if (this.parents.isEmpty()) {
            assert (oElement.length == 1) : "Why are you including '" + oElement.length + "' elements to fundamental SET " + this.getName() + "??";
            assert (oElement[0] != null) : "How this null got this far in set '" + this.getName() + "'??";
            if (!GMSi_Set.checkValidationRule(oElement[0].toString(), this.getValidation_rule())) {
                throw new DE_ValidationException(oElement[0].toString(), this.getValidation_rule(), "SET value validation rule violation", this.getFirstValueLocation());
            }
            return oElement.length == 1;
        }
        if (oElement.length != this.parents.size()) {
            assert (false) : "Why the number of elements doesn't match the number of parents SET? Parent Sets= " + this.parents.size() + "; Elements: " + oElement.length;
            return false;
        }
        for (int i = 0; i < oElement.length; ++i) {
            if (this.parents.get(i) != null) {
                if (!this.parents.get(i).contains(oElement[i])) {
                    throw new DE_ValidationException("SET identifier '" + oElement[i] + "' was not found parent SET '" + this.parents.get(i).getName() + "' (Index: '" + i + "'");
                }
            } else assert (false) : "How a null parent SET got to position '" + i + "'??";
            if (GMSi_Set.checkValidationRule(oElement[i].toString(), this.getValidation_rule())) continue;
            throw new DE_ValidationException(oElement[i].toString(), this.getValidation_rule(), "SET value validation rule violation", this.getFirstValueLocation());
        }
        if (this.contains(oElement)) {
            throw new DE_ValidationException("Element '" + this.getDisplayName(oElement) + "' is already defined in SET '" + this.getDisplayName() + "'");
        }
        return true;
    }

    public String[] setToStringLine(boolean useDisplayNames, boolean includeHeaders, boolean includeValues) {
        String[] sRet = new String[this.size()];
        int cont = 0;
        if (useDisplayNames) {
            for (Object o : this.keySet()) {
                sRet[cont] = o.toString();
                ++cont;
            }
        } else {
            for (Object[] oElements : this.allValues()) {
                for (Object o : oElements) {
                    int n = cont;
                    sRet[n] = sRet[n] + MULTIDIM_SET_SEPARATOR + o.toString();
                }
                sRet[cont] = sRet[cont].replaceFirst(MULTIDIM_SET_SEPARATOR, "");
                ++cont;
            }
        }
        return sRet;
    }

    public static String createLabel(Object ... oElements) {
        return GMSi_SetRecord.createLabel(oElements);
    }

    public GMSi_Set clone() {
        GMSi_Set cloneSet = new GMSi_Set(this.getName(), this.parents);
        cloneSet.setDataSource(this.getDataSource());
        cloneSet.setDescription(this.getDescription());
        cloneSet.setFirstValueLocation(this.getFirstValueLocation());
        cloneSet.setHeaderLocation(this.getHeaderLocation());
        cloneSet.setSolverName(this.getSolverName());
        cloneSet.setDisplayName(this.getDisplayName());
        cloneSet.setDefault_value(this.getDefault_value());
        cloneSet.setInitialize(this.isInitialize());
        cloneSet.setMandatory(this.isMandatory());
        cloneSet.setValidation_rule(this.getValidation_rule());
        return cloneSet;
    }

    @Override
    public void itemRemoved(Object o, DE_Set set) {
        if (!this.isFundamental()) {
            int index = this.parents.indexOf(set);
            if (index == -1) {
                return;
            }
            for (Object[] oElement : this.allValues()) {
                if (!oElement[index].equals(o)) continue;
                this.remove(oElement);
            }
        }
        assert (this.isFundamental()) : "Why this event was triggered in fundamental set '" + this.getName() + "'??";
    }
}

