/*
 * Decompiled with CFR 0.152.
 */
package de.solver.gmsi;

import de.core.DeepEdit;
import de.core.comp;
import de.data.DE_GeneralEnums;
import de.data.DE_ValidationException;
import de.data.ParameterData;
import de.edil.DE_Location;
import de.edil.DE_LocationExcel;
import de.solver.DE_Parameter;
import de.solver.DE_Set;
import de.solver.SetChangeListener;
import de.solver.gmsi.GMSi_Set;
import de.utils.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GMSi_Parameter
extends DE_Parameter
implements SetChangeListener {
    private DE_Set columnSet;
    public static final String MULTI_PARAMETER_SEPARATOR = ".";
    private static final Object[] SCALAR_INDEX = new Object[0];

    public GMSi_Parameter(String Name) {
        super(Name);
    }

    public GMSi_Parameter(String Name, List<DE_Set> sets) {
        super(Name);
        for (DE_Set set : sets) {
            this.addSet(set);
        }
    }

    public GMSi_Parameter(String Name, DE_Set ... sets) {
        super(Name);
        for (DE_Set set : sets) {
            this.addSet(set);
        }
    }

    @Override
    public boolean addSet(DE_Set set) {
        assert (this.mRecord.isEmpty()) : "Never redimen a Parameter with new SETs. Reset this parameter!";
        assert (set.getDimension() == 0) : "Only fundamental SETS are supported by GAMS as references for PARAMETERS";
        if (set.getDimension() > 0) {
            return false;
        }
        set.addSetChangeListener(this);
        return this.setList.add(set);
    }

    public boolean addAllSet(Collection<DE_Set> lSet) {
        assert (this.mRecord.isEmpty()) : "Never redimen a Parameter with new SETs. Reset (call clear()) this parameter!";
        for (DE_Set set : lSet) {
            assert (set.getDimension() != 0) : "Only fundamental SETS are supported by GAMS as references for PARAMETERS";
            set.addSetChangeListener(this);
        }
        return this.setList.addAll(lSet);
    }

    @Override
    public boolean addParameter(DE_Parameter parameter) throws DE_ValidationException {
        for (Map.Entry entry : this.mRecord.entrySet()) {
            this.setValue((Double)entry.getValue(), ((List)entry.getKey()).toArray());
        }
        return true;
    }

    @Override
    public List<DE_Set> getAllSet() {
        return this.setList;
    }

    public DE_Set getSet(String setName) {
        for (DE_Set set : this.setList) {
            if (!set.getName().equalsIgnoreCase(setName)) continue;
            return set;
        }
        return null;
    }

    public DE_Set getColumnSet() {
        int index;
        if (this.columnSet == null && (index = this.getColumnSetIndex()) != -1) {
            this.columnSet = (DE_Set)this.setList.get(index);
        }
        return this.columnSet;
    }

    public int getColumnSetIndex() {
        if (this.setList.isEmpty()) {
            return -1;
        }
        DE_Location valLoc = super.getValLocation();
        DE_Location loc = super.getSetLocation();
        if (valLoc != null && loc != null) {
            return -1;
        }
        if (loc != null && loc instanceof DE_LocationExcel) {
            DE_LocationExcel locExcel = (DE_LocationExcel)loc;
            for (int i = 0; i < locExcel.getNumRanges(); ++i) {
                if (locExcel.getMissingDataOrientation(i) == null || !locExcel.getMissingDataOrientation(i).equalsIgnoreCase("horizontal")) continue;
                assert (i < this.setList.size()) : "Why mapping file is returning fewer set positions '" + (i + 1) + "' than the actual number of SETs '" + this.setList.size() + "' defined for this PARAMETER??";
                this.columnSet = (DE_Set)this.setList.get(i);
                return i;
            }
        }
        if (this.columnSet != null) {
            return this.setList.indexOf(this.columnSet);
        }
        return -1;
    }

    @Override
    @Deprecated
    public boolean setColumnSet(DE_Set set) {
        assert (set != null) : "Never use null as column Set!!";
        assert (this.setList.contains(set)) : "Why you are defining a column SET when it's not even defined in SET list for this Parameter. Always add all SETs first using addSet(DE_Set) before defining which one is the column SET";
        this.columnSet = set;
        return true;
    }

    @Override
    public boolean setValue(double dValue, Object ... oElements) throws DE_ValidationException {
        assert (oElements != null) : "Set list should always be initialized. Did you add/modified Parameter constructor?";
        if (oElements.length == 0) assert (oElements.length == 0 && this.setList.isEmpty()) : "Why are you trying as a SCALAR when this one has SETs defined?";
        if (!this.isValidEntry(dValue)) {
            throw new DE_ValidationException(String.valueOf(dValue), this.getValidation_rule(), "Invalid entry for '" + Arrays.toString(oElements) + "' parameter '" + this.getName() + "'", this.getSetLocation());
        }
        if (this.isValidRecord(oElements)) {
            if (oElements.length == 0) {
                this.mRecord.put(Collections.unmodifiableList(Arrays.asList(SCALAR_INDEX)), dValue);
            } else {
                this.mRecord.put(Collections.unmodifiableList(Arrays.asList(oElements)), dValue);
            }
            return true;
        }
        return false;
    }

    public Object[] getElements(String ... sElementLabel) throws DE_ValidationException {
        assert (sElementLabel != null) : "Set list should always be initialized. Did you add/modified Parameter constructor?";
        if (sElementLabel.length == 0) assert (sElementLabel.length == 0 && this.setList.isEmpty()) : "Why are you trying as a SCALAR when this one has SETs defined?";
        assert (sElementLabel.length == this.setList.size()) : "Why are you trying to introduce " + sElementLabel.length + " elements when there are " + this.setList.size() + " sets in parameter " + this.getName();
        Object[] o = new Object[sElementLabel.length];
        for (int i = 0; i < sElementLabel.length; ++i) {
            o[i] = ((GMSi_Set)this.setList.get(i)).get(sElementLabel[i]);
            if (o[i] != null) continue;
            throw new DE_ValidationException(sElementLabel[i], null, "Value '" + sElementLabel[i] + "' doesn't exist in '" + this.getName() + "'s set '" + ((DE_Set)this.setList.get(i)).getName() + "'", this.getSetLocation());
        }
        return o;
    }

    public boolean isValidRecord(Object ... oElements) throws DE_ValidationException {
        if (oElements.length != this.setList.size()) {
            assert (false) : "Why you are trying to introduce a record with '" + oElements.length + "' elements if there are '" + this.setList.size() + "' SETs for Parameter " + this.getDisplayName();
            return false;
        }
        for (int i = 0; i < oElements.length; ++i) {
            DE_Set set = (DE_Set)this.setList.get(i);
            if (!set.contains(oElements[i])) {
                throw new DE_ValidationException("SET identifier '" + oElements[i] + "' was not found in parameter's associated SET '" + set.getName() + "' (Set '" + i + "' of Parameter '" + this.getName() + "')");
            }
            if (oElements[i] == null) {
                throw new DE_ValidationException("Invalid SET identifier '" + i + "' (for set '" + set.getName() + "'). Set identifiers for parameter '" + this.getName() + "' should never be 'null'");
            }
            if (!oElements[i].toString().isEmpty()) continue;
            throw new DE_ValidationException("Invalid SET identifier '" + i + "' (for set '" + set.getName() + "'). Set identifiers for parameter '" + this.getName() + " 'should never be 'empty strings'");
        }
        return true;
    }

    public boolean remove(Object ... oElements) {
        return this.mRecord.remove(Collections.unmodifiableList(Arrays.asList(oElements))) != null;
    }

    public int indexOf(Object ... oSet) {
        int cont = 0;
        for (List o : this.mRecord.keySet()) {
            if (Arrays.equals(o.toArray(), oSet)) {
                return cont;
            }
            ++cont;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.mRecord.clear();
    }

    public boolean removeAllSets() {
        assert (this.isEmpty()) : "Why are you removing SETs if this is not an empty Parameter??? This will create missing references!";
        this.setList.clear();
        return this.setList.isEmpty();
    }

    public void refresh() {
        block0: for (List oElements : this.mRecord.keySet()) {
            for (Object o : oElements) {
                if (o != null) continue;
                this.mRecord.remove(oElements);
                continue block0;
            }
        }
    }

    public String[] parameterToStringLine(boolean includeHeaders, boolean includeValues) {
        LinkedHashMap<String, Double[]> mLineT = new LinkedHashMap<String, Double[]>();
        for (Map.Entry e : this.mRecord.entrySet()) {
            double dValue = (Double)e.getValue();
            Object[] oRecordID = ((List)e.getKey()).toArray();
            if (oRecordID.length == 0) {
                mLineT.put("", new Double[]{dValue});
                continue;
            }
            assert (oRecordID.length == this.setList.size()) : "This element";
            String sRecordID = "";
            boolean isFirst = true;
            for (int i = 0; i < oRecordID.length; ++i) {
                if (!isFirst) {
                    sRecordID = sRecordID + MULTI_PARAMETER_SEPARATOR;
                }
                sRecordID = sRecordID + ((GMSi_Set)this.setList.get(i)).getDisplayName(oRecordID[i]);
                isFirst = false;
            }
            mLineT.put(sRecordID, new Double[]{dValue});
        }
        int cont = 0;
        String[] sRet = new String[mLineT.size()];
        for (String s : mLineT.keySet()) {
            for (Double d : (Double[])mLineT.get(s)) {
                if (d != null) {
                    s = s + StringUtil.numformat(d, 30, 10);
                }
                s = s + StringUtil.printf("", 30);
            }
            sRet[cont] = s;
            ++cont;
        }
        return sRet;
    }

    public double getValue() {
        Double dValue;
        assert (this.isScalar()) : "Why are you using a SCALAR specific function when set list is not empty??";
        if (this.isScalar() && (dValue = (Double)this.mRecord.get(Collections.unmodifiableList(Arrays.asList(SCALAR_INDEX)))) != null) {
            return dValue;
        }
        return 0.0;
    }

    @Override
    public double getValue(Object[] oElements) {
        assert (oElements.length == this.setList.size()) : "Why you are trying to introduce a record with " + oElements.length + " elements if there are " + this.setList.size() + " SETs";
        Double d = (Double)this.mRecord.get(Collections.unmodifiableList(Arrays.asList(oElements)));
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public String[] getDisplayNames(Object[] oElements) {
        String[] lRet = new String[oElements.length];
        try {
            if (this.isValidRecord(oElements)) {
                lRet = new String[oElements.length];
                for (int i = 0; i < oElements.length; ++i) {
                    lRet[i] = ((GMSi_Set)this.setList.get(i)).getDisplayName(oElements[i]);
                }
            }
        }
        catch (DE_ValidationException e) {
            assert (false) : "Why are you looking for an invalid element list? " + e.getLocalizedMessage();
            e.printStackTrace(System.err);
            return (String[])oElements;
        }
        return lRet;
    }

    public boolean isTable() {
        return this.getColumnSet() != null;
    }

    public boolean isScalar() {
        if (this.setList == null) {
            return true;
        }
        return this.setList.isEmpty();
    }

    public static String[] getSetsFromParameterName(String sParameterName) {
        if (sParameterName == null) {
            return null;
        }
        if (sParameterName.contains("(") && sParameterName.contains(")")) {
            int iniSet = sParameterName.lastIndexOf("(");
            int endSet = sParameterName.lastIndexOf(")");
            if (iniSet != -1 && endSet != -1 && endSet + 1 > iniSet) {
                String sSetTxt = sParameterName.substring(iniSet + 1, endSet);
                String[] sSetNames = sSetTxt.split(",");
                for (int i = 0; i < sSetNames.length; ++i) {
                    sSetNames[i] = sSetNames[i].trim();
                }
                return sSetNames;
            }
        }
        return null;
    }

    public boolean isComponentParameter() {
        return GMSi_Parameter.isComponentParameter(this.getName(), true);
    }

    public static boolean isComponentParameter(String parameterName, boolean useInheritance) {
        String[] sParamSplit;
        if (parameterName.contains("::") && (sParamSplit = parameterName.split("::")).length == 2) {
            String sClassName = sParamSplit[0];
            String sDEparamName = sParamSplit[1];
            if (useInheritance) {
                try {
                    Class<?> clazz = Class.forName("de.core." + sClassName);
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            return DeepEdit.isSupportedParameter(sClassName, sDEparamName);
        }
        return false;
    }

    public boolean getComponentParameter(Collection<ParameterData> lData) {
        String[] sParamSplit;
        String parameterName = this.getName();
        if (parameterName.contains("::") && (sParamSplit = parameterName.split("::")).length == 2) {
            String sClassName = sParamSplit[0];
            String sParameterName = sParamSplit[1];
            if (lData == null) {
                lData = new LinkedList<ParameterData>();
            }
            try {
                boolean isAdded = true;
                Class<?> clazz = Class.forName("de.core." + sClassName);
                for (comp c : DeepEdit.getActiveSchematic().getComponents(clazz)) {
                    if (!c.isSupportedParameter(sParameterName)) continue;
                    ParameterData pData = new ParameterData(sParameterName);
                    if (c.getParameterInfo(sParameterName, pData)) {
                        pData.setoOwnerComponent(c);
                        isAdded &= lData.add(pData);
                        continue;
                    }
                    return false;
                }
                return isAdded;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public static ParameterData getDefaultParameterData(String parameterName) {
        String[] sParamSplit = parameterName.split("::");
        if (sParamSplit.length == 2) {
            String sClassName = sParamSplit[0];
            String sDEparamName = sParamSplit[1];
            return DeepEdit.getDefaultParameterInfo(sClassName, sDEparamName);
        }
        return null;
    }

    public Collection<ParameterData> getParameterList() {
        String[] sParamSplit;
        String parameterName = this.getName();
        LinkedList<ParameterData> lData = new LinkedList<ParameterData>();
        if (parameterName.contains("::") && (sParamSplit = parameterName.split("::")).length == 2) {
            String sClassName = sParamSplit[0];
            String sParameterName = sParamSplit[1];
            ParameterData pdataDefault = DeepEdit.getDefaultParameterInfo(sClassName, sParameterName);
            if (pdataDefault != null) {
                for (Map.Entry oEntry : this.mRecord.entrySet()) {
                    Object[] oElement = ((List)oEntry.getKey()).toArray();
                    double dValue = (Double)oEntry.getValue();
                    if (oElement.length == 1 && oElement[0] instanceof comp) {
                        comp c = (comp)oElement[0];
                        ParameterData pdata = pdataDefault.clone();
                        pdata.setValue(String.valueOf(dValue));
                        pdata.setoOwnerComponent(c);
                        lData.add(pdata);
                    }
                    if (oElement.length != 2) continue;
                }
            } else if ("System".equalsIgnoreCase(sClassName)) {
                String sValue = DeepEdit.getActiveSchematic().getSystemParameterValue(sParameterName);
                pdataDefault = new ParameterData(sParameterName);
                pdataDefault.setValue(sValue, DE_GeneralEnums.databaseDataType.StringValue);
                pdataDefault.setStrOwnerName("System");
                lData.add(pdataDefault);
            }
        }
        return lData;
    }

    @Override
    public int size() {
        return this.mRecord.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mRecord.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        assert (key instanceof Object[]) : "Only arrays of objects are valid Paramenter's key";
        return this.mRecord.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object get(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void putAll(Map m) {
        this.mRecord.putAll(m);
    }

    public Set keySet() {
        return this.mRecord.keySet();
    }

    public Collection values() {
        return this.mRecord.values();
    }

    public Set entrySet() {
        return this.mRecord.entrySet();
    }

    @Override
    public void itemRemoved(Object o, DE_Set set) {
        int index = this.setList.indexOf(set);
        if (index == -1) {
            return;
        }
        for (List oElement : this.mRecord.keySet()) {
            if (!oElement.get(index).equals(o)) continue;
            this.remove((Object)oElement);
        }
    }
}

