/*
 * Decompiled with CFR 0.152.
 */
package de.solver;

import de.core.DeepEdit;
import de.data.DE_ValidationException;
import de.solver.DE_Parameter;
import de.solver.DE_Set;
import javax.swing.table.DefaultTableModel;

class ParameterModel
extends DefaultTableModel {
    private final DE_Parameter parameter;
    private boolean editable = false;
    private static final String COLUMN_VALUE = "Value";
    private static final String COLUMN_ID = "ID";
    private int columnIndexValue = -1;

    public ParameterModel(DE_Parameter parameter) {
        this.parameter = parameter;
        Object[] columnNames = new String[parameter.getTotalNumSet() + 2];
        columnNames[0] = COLUMN_ID;
        int cont = 1;
        for (DE_Set set : parameter.getAllSet()) {
            columnNames[cont] = set.getName();
            ++cont;
        }
        this.columnIndexValue = parameter.getTotalNumSet() + 1;
        columnNames[this.columnIndexValue] = COLUMN_VALUE;
        super.setColumnIdentifiers(columnNames);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Object[] oElement = new Object[this.parameter.getTotalNumSet()];
        Object oValue = null;
        assert (this.columnIndexValue > 0) : "Why column with 'Values' is invalid??";
        for (int i = 1; i < this.getColumnCount(); ++i) {
            if (i == column) {
                if (i == this.columnIndexValue) {
                    oValue = aValue;
                    continue;
                }
                oElement[i - 1] = aValue;
                continue;
            }
            if (i == this.columnIndexValue) {
                oValue = this.getValueAt(row, i);
                continue;
            }
            oElement[i - 1] = this.getValueAt(row, i);
        }
        if (aValue != null && oValue != null) {
            try {
                double dValue = Double.parseDouble(oValue.toString());
                this.parameter.setValue(dValue, oElement);
                super.setValueAt(aValue, row, column);
            }
            catch (DE_ValidationException e) {
                DeepEdit.printlnToMessageTab("Invalid value found in row " + (row + 1) + " for parameter '" + this.parameter.getName() + "': " + e.getLocalizedMessage());
            }
            catch (NumberFormatException e) {
                DeepEdit.printlnToMessageTab("Invalid numerical value [" + aValue + "] found in row " + (row + 1) + " for parameter '" + this.parameter.getName() + "'");
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.editable) {
            return column != 0;
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.columnIndexValue) {
            return Double.class;
        }
        return super.getColumnClass(columnIndex);
    }

    public int getValueColumnIndex() {
        return this.columnIndexValue;
    }

    public DE_Parameter getParameter() {
        return this.parameter;
    }
}

