/*
 * Decompiled with CFR 0.152.
 */
package de.solver;

import de.data.DE_ValidationException;
import de.edil.pet.PETNew_Wizard;
import de.solver.DE_Set;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class DefaultSETVisualFrame
extends JDialog {
    private Map<Integer, Object> mValues;
    private DE_Set set;
    private boolean editable = false;
    public static final int COLUMN_INDEX_ID = 0;
    private JButton btnOK;
    private JScrollPane jScrollPane1;
    private JPanel pnlControlArea;
    private JTable tblSET;
    private JTextField txtDescription;

    public DefaultSETVisualFrame(Window parent, DE_Set set, boolean editable) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        assert (set != null) : "Never use null here! If you don't have set ready, use the other contructor instead!";
        this.setTitle(set.getDisplayName());
        assert (set.isFundamental()) : "Trying to display '" + set.getName() + "' BUT THIS WINDOW ONLY WORKS WITH FUNDAMENTAL SETS!!";
        this.mValues = new HashMap<Integer, Object>(set.size());
        this.setSET(set);
        this.editable = editable;
    }

    public DefaultSETVisualFrame(Window parent, String title, boolean editable) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.setTitle(title);
        this.mValues = new HashMap<Integer, Object>();
        this.editable = editable;
    }

    public final void setSET(DE_Set set) {
        this.set = set;
        int id = 1;
        for (Object[] o : set.values()) {
            this.mValues.put(id, o);
            this.addRow(id, o.toString(), null);
            ++id;
        }
        this.repaint();
    }

    private void addRow(int id, String Name, String Description) {
        Object[] rowData = new Object[3];
        rowData[0] = id;
        if (Name != null) {
            rowData[1] = Name;
        }
        if (Description != null) {
            rowData[2] = Description;
        }
        DefaultTableModel model = (DefaultTableModel)this.tblSET.getModel();
        model.addRow(rowData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeClosingWindow() {
        try {
            this.updateSET();
            if (this.getParent() instanceof PETNew_Wizard) {
                ((PETNew_Wizard)this.getParent()).refreshLabels();
            }
        }
        catch (DE_ValidationException e) {
            JOptionPane.showMessageDialog(this, "Invalid entry to SET '" + this.set.getName() + "'\nValidation info: " + e.getLocalizedMessage(), "Invalid SET entry", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Set " + this.set.getName() + "' couldn't be updated! \nException info: " + e.getMessage(), "Unexpected error updating SET", 0);
            e.printStackTrace(System.out);
        }
    }

    public void updateSET() throws DE_ValidationException {
        if (!this.editable) {
            return;
        }
        this.set.clear();
        for (int nRow = 0; nRow < this.tblSET.getRowCount(); ++nRow) {
            Object oNew = this.tblSET.getValueAt(nRow, 1);
            this.set.add(oNew);
        }
    }

    public void setDescription(String description) {
        this.txtDescription.setText(description);
        this.txtDescription.setToolTipText(description);
        this.txtDescription.setCaretPosition(0);
    }

    public Container getPanel() {
        return this.getContentPane();
    }

    public JTable getSetTable() {
        return this.tblSET;
    }

    public static Container getSetPanel(DE_Set set, boolean editable) {
        DefaultSETVisualFrame set_w = new DefaultSETVisualFrame(null, set, editable);
        return set_w.getPanel();
    }

    public static JDialog showSetWindow(DE_Set set, boolean editable) {
        return new DefaultSETVisualFrame(null, set, editable);
    }

    private void checkExitConditions() {
        if (this.tblSET.isEditing()) {
            int nRow = this.tblSET.getEditingRow() + 1;
            int nYesNo = JOptionPane.showConfirmDialog(this, "Row " + nRow + " is being editing. Are you sure you want to exit?" + "\n -Click 'no' to finish editing entry \n -Click 'yes' to leave", "Confirm exit", 0, 2);
            if (nYesNo == 1) {
                return;
            }
        }
        this.beforeClosingWindow();
        this.dispose();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblSET = new JTable();
        this.pnlControlArea = new JPanel();
        this.btnOK = new JButton();
        this.txtDescription = new JTextField();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DefaultSETVisualFrame.this.formWindowClosing(evt);
            }
        });
        this.tblSET.setModel(new DefaultTableModel(new Object[0][], new String[]{"ID", "Name", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Object.class, String.class};
                this.canEdit = new boolean[]{false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblSET.setColumnSelectionAllowed(true);
        this.jScrollPane1.setViewportView(this.tblSET);
        this.tblSET.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.tblSET.getColumnModel().getColumnCount() > 0) {
            this.tblSET.getColumnModel().getColumn(0).setMinWidth(50);
            this.tblSET.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.tblSET.getColumnModel().getColumn(0).setMaxWidth(50);
        }
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultSETVisualFrame.this.btnOKActionPerformed(evt);
            }
        });
        this.txtDescription.setEditable(false);
        this.txtDescription.setFont(new Font("Tahoma", 0, 8));
        this.txtDescription.setToolTipText("");
        GroupLayout pnlControlAreaLayout = new GroupLayout(this.pnlControlArea);
        this.pnlControlArea.setLayout(pnlControlAreaLayout);
        pnlControlAreaLayout.setHorizontalGroup(pnlControlAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlControlAreaLayout.createSequentialGroup().addComponent(this.txtDescription, -1, 175, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnOK)));
        pnlControlAreaLayout.setVerticalGroup(pnlControlAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlAreaLayout.createSequentialGroup().addGroup(pnlControlAreaLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK).addComponent(this.txtDescription, -2, 23, -2)).addGap(2, 2, 2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.pnlControlArea, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 307, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlControlArea, -2, -1, -2).addGap(0, 0, 0)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.checkExitConditions();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.checkExitConditions();
    }
}

