/*
 * Decompiled with CFR 0.152.
 */
package de.solver;

import de.data.DE_ValidationException;
import de.solver.DE_Parameter;
import de.solver.DE_Set;
import de.solver.ParameterModel;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class DefaultParameterVisualFrame
extends JDialog {
    public static final int COLUMN_INDEX_ID = 0;
    private boolean editable;
    private JToggleButton btnOK;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable tblParameter;
    private JTextField txtDescription;

    public DefaultParameterVisualFrame(Window parent, DE_Parameter parameter, boolean editable) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.setTitle(parameter.getDisplayName());
        this.setDescription(parameter.getDescription());
        ParameterModel model = new ParameterModel(parameter);
        this.tblParameter.setModel(model);
        this.tblParameter.setAutoCreateRowSorter(false);
        List<DE_Set> lSets = parameter.getAllSet();
        for (int i = 0; i < parameter.getTotalNumSet(); ++i) {
            JComboBox<Object[]> comboBox = new JComboBox<Object[]>();
            TableColumn column = this.tblParameter.getColumnModel().getColumn(i + 1);
            for (Object[] o : lSets.get(i).values()) {
                comboBox.addItem(o);
            }
            column.setCellEditor(new DefaultCellEditor(comboBox));
        }
        for (Map.Entry o : parameter.entrySet()) {
            if (!(o instanceof Map.Entry)) continue;
            Map.Entry entry = o;
            Object[] oElement = ((List)entry.getKey()).toArray();
            Object oValue = entry.getValue();
            this.addRow(oElement, oValue);
        }
        this.tblParameter.setAutoCreateRowSorter(true);
        this.tblParameter.getColumnModel().getColumn(0).setResizable(false);
        this.tblParameter.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.tblParameter.getColumnModel().getColumn(0).setMaxWidth(25);
        model.setEditable(editable);
    }

    private void addRow(Object[] oElement, Object value) {
        DefaultTableModel model = (DefaultTableModel)this.tblParameter.getModel();
        int nTotalCols = oElement.length + 2;
        int nTotalRows = model.getRowCount();
        assert (nTotalCols == model.getColumnCount()) : "Why are you trying to include '" + oElement.length + " elements if table has only '" + model.getColumnCount() + "' columns?";
        Object[] rowData = new Object[nTotalCols + 1];
        rowData[0] = nTotalRows + 1;
        System.arraycopy(oElement, 0, rowData, 1, oElement.length);
        rowData[nTotalCols - 1] = value;
        if (rowData.length > 0) {
            model.addRow(rowData);
        }
    }

    public DE_Parameter getParameter() {
        ParameterModel model = (ParameterModel)this.tblParameter.getModel();
        return model.getParameter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updatePARAMETER() {
        DE_Parameter parameter = this.getParameter();
        if (!this.editable) {
            return;
        }
        int nRow = 0;
        try {
            parameter.clear();
            assert (parameter.getTotalNumSet() + 2 == this.tblParameter.getColumnCount()) : "Why this Parameter has '" + parameter.getTotalNumSet() + " parent SETs but table has '" + this.tblParameter.getRowCount() + "' columns?";
            for (nRow = 0; nRow < this.tblParameter.getRowCount(); ++nRow) {
                Object[] oElement = new Object[parameter.getTotalNumSet()];
                for (int nCol = 1; nCol < this.tblParameter.getColumnCount() - 1; ++nCol) {
                    oElement[nCol - 1] = this.tblParameter.getValueAt(nRow, nCol);
                }
                Object oValue = this.tblParameter.getValueAt(nRow, this.tblParameter.getColumnCount() - 1);
                double dValue = Double.parseDouble(oValue.toString());
                parameter.setValue(dValue, oElement);
            }
        }
        catch (DE_ValidationException e) {
            JOptionPane.showMessageDialog(this, "Invalid entry to PARAMETER '" + parameter.getName() + "' in row '" + nRow + "'\nValidation info: " + e.getLocalizedMessage(), "Invalid PARAMETER entry", 0);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Invalid numerical value in row " + nRow + " for PARAMETER " + parameter.getName() + "'\n Parameter couldn't be updated! \nException info: " + e.getMessage(), "Invalid numerical value PARAMETER", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "PARAMETER " + parameter.getName() + "' couldn't be updated! \nException info: " + e.getMessage(), "Unexpected error updating PARAMETER", 0);
        }
        finally {
            this.dispose();
        }
    }

    public Container getPanel() {
        return this.getContentPane();
    }

    public static Container showParameterPanel(DE_Parameter parameter, boolean editable) {
        DefaultParameterVisualFrame par_w = new DefaultParameterVisualFrame(null, parameter, editable);
        return par_w.getPanel();
    }

    public static JDialog showParameterWindow(DE_Parameter parameter, boolean editable) {
        return new DefaultParameterVisualFrame(null, parameter, editable);
    }

    public void beforeClosingWindow() {
    }

    public void setDescription(String description) {
        this.txtDescription.setText(description);
        this.txtDescription.setToolTipText(description);
        this.txtDescription.setCaretPosition(0);
    }

    private void checkExitConditions() {
        if (this.tblParameter.isEditing()) {
            int nRow = this.tblParameter.getEditingRow() + 1;
            int nYesNo = JOptionPane.showConfirmDialog(this, "Row " + nRow + " is being editing. Are you sure you want to exit?" + "\n -Click 'no' to finish editing entry \n -Click 'yes' to leave", "Confirm exit", 0, 2);
            if (nYesNo == 1) {
                return;
            }
        }
        this.beforeClosingWindow();
        this.dispose();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblParameter = new JTable();
        this.jPanel1 = new JPanel();
        this.btnOK = new JToggleButton();
        this.txtDescription = new JTextField();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DefaultParameterVisualFrame.this.formWindowClosing(evt);
            }
        });
        this.tblParameter.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tblParameter.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblParameter);
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultParameterVisualFrame.this.btnOKActionPerformed(evt);
            }
        });
        this.txtDescription.setEditable(false);
        this.txtDescription.setFont(new Font("Tahoma", 0, 8));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.txtDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOK)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK).addComponent(this.txtDescription, -2, 23, -2))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 259, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, 0)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.checkExitConditions();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.checkExitConditions();
    }
}

