/*
 * Decompiled with CFR 0.152.
 */
package de.solver;

import de.solver.ButtonColumn;
import de.solver.DE_Parameter;
import de.solver.DE_Set;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public abstract class DE_solverVisual
extends JDialog {
    public static final String LABEL_SET = "SET";
    public static final String LABEL_PARAMETER = "PARAMETER";
    public static final int COLUMN_INDEX_TYPE = 0;
    public static final int COLUMN_INDEX_NAME = 1;
    private static final int COLUMN_INDEX_BUTTON = 2;
    public static final int COLUMN_INDEX_OBJECT = 3;
    private JScrollPane jScrollPane1;
    private JMenuItem menuOpenSource;
    private JMenuItem menuProperties;
    private JPopupMenu popVisualOptions;
    private JPopupMenu.Separator propSeparator;
    private JTable tblSolver;

    public DE_solverVisual(Window parent, boolean modal) {
        super(parent);
        if (modal) {
            this.setModal(modal);
        }
        this.initComponents();
        this.initTable();
    }

    private void initTable() {
        ButtonColumn buttonColumn = new ButtonColumn(this.tblSolver, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int modelRow = Integer.valueOf(e.getActionCommand());
                int viewRow = DE_solverVisual.this.tblSolver.convertRowIndexToView(modelRow);
                DE_solverVisual.this.displayContent(viewRow);
                DE_solverVisual.this.displayContent(DE_solverVisual.this.tblSolver.getValueAt(viewRow, 3));
            }
        }, 2);
        this.tblSolver.getColumnModel().getColumn(2).setMaxWidth(10);
        this.tblSolver.getColumnModel().getColumn(3).setMaxWidth(0);
        this.hideColumn(3);
    }

    public void hideColumn(int columnIndex) {
        this.tblSolver.getColumnModel().getColumn(columnIndex).setMinWidth(0);
        this.tblSolver.getColumnModel().getColumn(columnIndex).setMaxWidth(0);
    }

    public void showColumn(int columnIndex) {
        int nPreferedSize = this.tblSolver.getColumnModel().getColumn(columnIndex).getPreferredWidth();
        this.tblSolver.getColumnModel().getColumn(columnIndex).setMinWidth(nPreferedSize);
        this.tblSolver.getColumnModel().getColumn(columnIndex).setMaxWidth(nPreferedSize);
    }

    public void addSET(DE_Set set) {
        DefaultTableModel model = (DefaultTableModel)this.tblSolver.getModel();
        Object[] rowData = new Object[]{LABEL_SET, set.getDisplayName(), "...", set};
        model.addRow(rowData);
        this.initTable();
    }

    public void addParameter(DE_Parameter parameter) {
        DefaultTableModel model = (DefaultTableModel)this.tblSolver.getModel();
        Object[] rowData = new Object[]{LABEL_PARAMETER, parameter.getName(), "...", parameter};
        model.addRow(rowData);
    }

    public void clear() {
        DefaultTableModel model = (DefaultTableModel)this.tblSolver.getModel();
        int rows = model.getRowCount();
        for (int i = rows - 1; i >= 0; --i) {
            model.removeRow(i);
        }
    }

    public JTable getContentTable() {
        return this.tblSolver;
    }

    public abstract void displayContent(int var1);

    public abstract void displayContent(Object var1);

    public abstract void displaySource(Object var1);

    private void initComponents() {
        this.popVisualOptions = new JPopupMenu();
        this.menuOpenSource = new JMenuItem();
        this.propSeparator = new JPopupMenu.Separator();
        this.menuProperties = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.tblSolver = new JTable();
        this.menuOpenSource.setText("Open Source");
        this.menuOpenSource.setToolTipText("");
        this.menuOpenSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DE_solverVisual.this.menuOpenSourceActionPerformed(evt);
            }
        });
        this.popVisualOptions.add(this.menuOpenSource);
        this.popVisualOptions.add(this.propSeparator);
        this.menuProperties.setText("Properties");
        this.menuProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DE_solverVisual.this.menuPropertiesActionPerformed(evt);
            }
        });
        this.popVisualOptions.add(this.menuProperties);
        this.setDefaultCloseOperation(2);
        this.tblSolver.setAutoCreateRowSorter(true);
        this.tblSolver.setModel(new DefaultTableModel(new Object[0][], new String[]{"Type", "Name", " ", "Object"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Object.class, Object.class};
                this.canEdit = new boolean[]{false, false, true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblSolver.getTableHeader().setReorderingAllowed(false);
        this.tblSolver.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DE_solverVisual.this.tblSolverMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblSolver);
        if (this.tblSolver.getColumnModel().getColumnCount() > 0) {
            this.tblSolver.getColumnModel().getColumn(2).setResizable(false);
            this.tblSolver.getColumnModel().getColumn(2).setPreferredWidth(10);
            this.tblSolver.getColumnModel().getColumn(3).setResizable(false);
            this.tblSolver.getColumnModel().getColumn(3).setPreferredWidth(10);
        }
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void menuOpenSourceActionPerformed(ActionEvent evt) {
        int col = this.tblSolver.getSelectedRow();
        if (col > -1) {
            Object o = this.tblSolver.getValueAt(col, 3);
            this.displaySource(o);
        }
    }

    private void tblSolverMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            int col = this.tblSolver.columnAtPoint(evt.getPoint());
            int row = this.tblSolver.rowAtPoint(evt.getPoint());
            String name = this.tblSolver.getColumnName(col);
            this.tblSolver.setRowSelectionInterval(row, row);
            this.popVisualOptions.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void menuPropertiesActionPerformed(ActionEvent evt) {
        int col = this.tblSolver.getSelectedRow();
        if (col > -1) {
            Object o = this.tblSolver.getValueAt(col, 3);
            this.displayContent(o);
        }
    }
}

