/*
 * Decompiled with CFR 0.152.
 */
package de.solver;

import de.core.comp;
import de.data.DE_ValidationException;
import de.data.ValidationRule;
import de.edil.DE_Location;
import de.solver.SetChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class DE_Set<E>
implements SetChangeListener,
Serializable {
    protected String setName;
    protected String solverName;
    private String displayName;
    protected String description;
    private String dataSource;
    private String validation_rule;
    private boolean mandatory;
    private boolean initialize;
    private String default_value;
    private int nDimension = 0;
    private DE_Location firstValueLocation;
    private DE_Location headerLocation;
    private List<SetChangeListener> lListener = new ArrayList<SetChangeListener>();

    public DE_Set(String setName, int nDimension) {
        this.setName = setName;
        this.nDimension = nDimension;
    }

    public void setName(String setName) {
        this.setName = setName;
    }

    public String getName() {
        return this.setName;
    }

    public void setSolverName(String solverName) {
        this.solverName = solverName;
    }

    public String getSolverName() {
        if (this.solverName == null) {
            return this.setName;
        }
        return this.solverName;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDimension() {
        return this.nDimension;
    }

    public boolean isSchematic() {
        if (this.dataSource == null) {
            return false;
        }
        return this.dataSource.equalsIgnoreCase("Schematic");
    }

    public abstract boolean setValue(E var1) throws DE_ValidationException;

    public abstract boolean setValues(List<Object> var1) throws DE_ValidationException;

    public abstract boolean add(E var1) throws DE_ValidationException;

    public abstract boolean addAll(List<E> var1) throws DE_ValidationException;

    public abstract boolean remove(E var1);

    public abstract boolean contains(E var1);

    public abstract boolean replaceValue(E var1, E var2) throws DE_ValidationException;

    public abstract void clear();

    public abstract List<Object[]> values();

    public abstract List<comp> getComponents();

    public abstract int copyInto(DE_Set var1) throws DE_ValidationException;

    public abstract int indexOf(E var1);

    public abstract E get(int var1);

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract Iterator iterator();

    public DE_Location getFirstValueLocation() {
        return this.firstValueLocation;
    }

    public void setFirstValueLocation(DE_Location firstValueLocation) {
        this.firstValueLocation = firstValueLocation;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public DE_Location getHeaderLocation() {
        return this.headerLocation;
    }

    public void setHeaderLocation(DE_Location headerLocation) {
        this.headerLocation = headerLocation;
    }

    public String getValidation_rule() {
        return this.validation_rule;
    }

    public void setValidation_rule(String validation_rule) {
        this.validation_rule = validation_rule;
    }

    public boolean isValidEntry(Object o) {
        if (this.validation_rule == null) {
            return true;
        }
        return ValidationRule.isValid(o.toString(), this.validation_rule);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public String getDefault_value() {
        return this.default_value;
    }

    public void setDefault_value(String default_value) {
        this.default_value = default_value;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.setName;
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isFundamental() {
        return this.nDimension == 0;
    }

    public void addSetChangeListener(SetChangeListener listener) {
        this.lListener.add(listener);
    }

    public static DE_Set findSetNameInList(String Name, List<DE_Set> setList, boolean useDeepEditName) {
        if (Name == null || setList == null) {
            return null;
        }
        for (DE_Set set : setList) {
            if (useDeepEditName && set.getName().equalsIgnoreCase(Name)) {
                return set;
            }
            if (useDeepEditName || !set.getSolverName().equalsIgnoreCase(Name)) continue;
            return set;
        }
        return null;
    }
}

