/*
 * Decompiled with CFR 0.152.
 */
package de.solver;

import de.data.DE_ValidationException;
import de.data.ValidationRule;
import de.edil.DE_Location;
import de.solver.DE_Set;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DE_Parameter
extends AbstractMap
implements Map,
Serializable {
    public static final String COMPONENT_PARAMETER_SEPARATOR = "::";
    private String parameterName;
    private String solverName;
    private String displayName;
    private String description;
    private String dataSource;
    private String validation_rule;
    private boolean mandatory;
    private boolean initialize;
    private String default_value;
    protected List<DE_Set> setList = new ArrayList<DE_Set>(4);
    private DE_Location setLocation;
    private DE_Location valLocation;
    protected LinkedHashMap<List<Object>, Double> mRecord = new LinkedHashMap();

    public DE_Parameter(String Name) {
        this.parameterName = Name;
    }

    public String getName() {
        return this.parameterName;
    }

    public void setName(String newName) {
        assert (newName != null) : "Null not allowed here!!!";
        this.parameterName = newName;
    }

    public String getSolverName() {
        return this.solverName;
    }

    public void setSolverName(String solverName) {
        this.solverName = solverName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public DE_Location getSetLocation() {
        return this.setLocation;
    }

    public void setSetLocation(DE_Location setLocation) {
        this.setLocation = setLocation;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.parameterName;
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DE_Location getValLocation() {
        return this.valLocation;
    }

    public void setValLocation(DE_Location valLocation) {
        this.valLocation = valLocation;
    }

    public int getTotalNumSet() {
        return this.setList.size();
    }

    public abstract boolean addSet(DE_Set var1);

    public abstract boolean addParameter(DE_Parameter var1) throws DE_ValidationException;

    public abstract List<DE_Set> getAllSet();

    public abstract boolean setColumnSet(DE_Set var1);

    public abstract boolean setValue(double var1, Object ... var3) throws DE_ValidationException;

    public abstract double getValue(Object[] var1);

    public static String getClassNameFromValue(String name) {
        if (name == null) {
            return null;
        }
        String[] sParamSplit = name.split(COMPONENT_PARAMETER_SEPARATOR);
        if (sParamSplit.length == 2) {
            return sParamSplit[0];
        }
        return null;
    }

    public static String getParameterNameFromValue(String name) {
        if (name == null) {
            return null;
        }
        String[] sParamSplit = name.split(COMPONENT_PARAMETER_SEPARATOR);
        if (sParamSplit.length == 2) {
            return sParamSplit[1];
        }
        return null;
    }

    public static boolean isValidParameterNameValue(String name) {
        return DE_Parameter.getClassNameFromValue(name) != null && DE_Parameter.getParameterNameFromValue(name) != null;
    }

    public String getValidation_rule() {
        return this.validation_rule;
    }

    public void setValidation_rule(String validation_rule) {
        this.validation_rule = validation_rule;
    }

    public boolean isValidEntry(double dValue) {
        if (this.validation_rule == null) {
            return true;
        }
        return ValidationRule.isValid(String.valueOf(dValue), this.validation_rule);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public String getDefault_value() {
        return this.default_value;
    }

    public void setDefault_value(String default_value) {
        this.default_value = default_value;
    }

    public static DE_Parameter findPARAMETERNameInList(String Name, List<DE_Parameter> parameterList, boolean useDeepEditName) {
        if (Name == null || parameterList == null) {
            return null;
        }
        for (DE_Parameter parameter : parameterList) {
            if (useDeepEditName && parameter.getName().equalsIgnoreCase(Name)) {
                return parameter;
            }
            if (useDeepEditName || !parameter.getSolverName().equalsIgnoreCase(Name)) continue;
            return parameter;
        }
        return null;
    }
}

