/*
 * Decompiled with CFR 0.152.
 */
package de.edil.pet;

import de.core.DeepEdit;
import de.core.vsi.VSI_handler;
import de.data.DE_ClassEnums;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.edil.DE_Location;
import de.edil.DE_LocationExcel;
import de.edil.ReadOutputEdil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ReadOutputPET
implements ReadOutputEdil,
Runnable {
    private File outputFolder;
    private VSI_handler dispatch_handler;
    private VSI_handler flow_handler;
    private VSI_handler cmg_handler;
    private static final int MAX_FILE_SIZE = 100;

    public ReadOutputPET(String outputFolder) {
        assert (outputFolder != null) : "Never use null path here!";
        this.outputFolder = new File(outputFolder);
    }

    public int getCaseID() {
        String absPath = this.outputFolder.getAbsolutePath();
        return absPath.hashCode();
    }

    public DE_Location getGenerationLocation() {
        return new DE_LocationExcel(this.outputFolder.getPath() + File.separator + "PET_Sal_Despacho.csv", "A1", null);
    }

    public DE_Location getLineFlowLocation() {
        return new DE_LocationExcel(this.outputFolder.getPath() + File.separator + "PET_Sal_Flujos.csv", "A1", null);
    }

    public DE_Location getLineFlowLimitLocation() {
        return new DE_LocationExcel(this.outputFolder.getPath() + File.separator + "PET_Sal_Flujos.csv", "A1", null);
    }

    public DE_Location getNodalPriceLocation() {
        return new DE_LocationExcel(this.outputFolder.getPath() + File.separator + "PET_Sal_CMg.csv", "A1", null);
    }

    public DE_Location getNodalLoadLocation() {
        return new DE_LocationExcel(this.outputFolder.getPath() + File.separator + "PET_Sal_CMg.csv", "A1", null);
    }

    private void initHandlers() throws IOException {
        long init_time = System.currentTimeMillis();
        this.dispatch_handler = new VSI_handler(100);
        String[] Headerg = new String[]{"Agno", "Periodo", "Bloque", "Hidrologia", "Nombre"};
        String[] valuesg = new String[]{"PGen"};
        this.dispatch_handler.parseCSVFile(this.getGenerationLocation().getSourcePath(), Headerg, valuesg, true, true);
        long end_time = System.currentTimeMillis();
        long elapsed_time = (end_time - init_time) / 1000L;
        DeepEdit.printlnToMessageTab("Finished parsing dispatch output file " + this.getGenerationLocation().getSourcePath() + ". Time: " + elapsed_time + "[sec]");
        this.flow_handler = new VSI_handler(100);
        String[] Headerf = new String[]{"A\u00f1o", "Periodo", "Bloque", "Hidrologia", "Circuito", "NodoA", "NodoB"};
        String[] valuesf = new String[]{"Flujo", "FluMax"};
        this.flow_handler.parseCSVFile(this.getLineFlowLocation().getSourcePath(), Headerf, valuesf, true, true);
        elapsed_time = System.currentTimeMillis() - end_time;
        end_time = System.currentTimeMillis();
        DeepEdit.printlnToMessageTab("Finished parsing line output file " + this.getGenerationLocation().getSourcePath() + ". Time: " + elapsed_time + "[sec]");
        this.cmg_handler = new VSI_handler(100);
        String[] Headerb = new String[]{"Agno", "Periodo", "Bloque", "Hidrologia", "Nodo"};
        String[] valuesb = new String[]{"Dda", "CMg"};
        this.cmg_handler.parseCSVFile(this.getNodalPriceLocation().getSourcePath(), Headerb, valuesb, true, true);
        elapsed_time = System.currentTimeMillis() - end_time;
        DeepEdit.printlnToMessageTab("Finished parsing nodal output file " + this.getGenerationLocation().getSourcePath() + ". Time: " + elapsed_time + "[sec]");
    }

    @Override
    public void queryOutput(String[] identifiers, String output, List<ParameterData> lData) throws IOException {
        String owner_class;
        String owner;
        String pname;
        String value;
        VSI_handler hand;
        assert (lData != null) : "Never pass a null array to this function";
        if (this.dispatch_handler == null || this.flow_handler == null || this.cmg_handler == null) {
            this.initHandlers();
        }
        if ("gen_p".equalsIgnoreCase(output)) {
            hand = this.dispatch_handler;
            value = "PGen";
            pname = DE_ClassEnums.Generator.p0.name();
            owner = "Nombre";
            owner_class = "Generator";
        } else if ("flow".equalsIgnoreCase(output)) {
            hand = this.flow_handler;
            value = "Flujo";
            pname = DE_ClassEnums.Line.p12.name();
            owner = "Circuito";
            owner_class = "Line";
        } else if ("maxflow_p".equalsIgnoreCase(output)) {
            hand = this.flow_handler;
            value = "FluMax";
            pname = DE_ClassEnums.Line.smax.name();
            owner = "Circuito";
            owner_class = "Line";
        } else if ("load_p".equalsIgnoreCase(output)) {
            hand = this.cmg_handler;
            value = "Dda";
            pname = DE_ClassEnums.Busbar.p0.name();
            owner = "Nodo";
            owner_class = "Load";
        } else if ("cmg".equalsIgnoreCase(output)) {
            hand = this.cmg_handler;
            value = "CMg";
            pname = DE_ClassEnums.Busbar.spotp.name();
            owner = "Nodo";
            owner_class = "Busbar";
        } else {
            hand = this.dispatch_handler;
            value = "PGen";
            pname = DE_ClassEnums.Generator.p0.name();
            owner = "Nombre";
            owner_class = "Generator";
            assert (false) : "Why are you using an unsupported output?? " + output;
        }
        int indexVal = hand.indexOfValue(value);
        int indexId = hand.indexOfIdentifier(owner);
        int nIds = hand.getTotalIdentifierColumns();
        if (indexVal != -1 && indexId != -1) {
            Object[][] oQuery;
            for (Object[] lineQ : oQuery = hand.get(identifiers)) {
                String sValue = lineQ[nIds + indexVal].toString();
                String sOwner = lineQ[indexId].toString();
                ParameterData pData = new ParameterData(pname);
                if (!pData.setValue(sValue, DE_GeneralEnums.databaseDataType.DoubleValue)) continue;
                pData.setStrOwnerName(sOwner);
                pData.setClassName(owner_class);
                lData.add(pData);
            }
        }
    }

    @Override
    public void readOutputFiles(DE_Location[] outputFiles) throws IOException {
        assert (outputFiles != null) : "Never use null here!!";
        assert (outputFiles.length == 1) : "PET output files should be stored in only 1 folder. Are you modifying to include support to a new version?";
        this.outputFolder = new File(outputFiles[0].getSourcePath());
        this.dispatch_handler = null;
        this.flow_handler = null;
        this.cmg_handler = null;
        this.initHandlers();
    }

    @Override
    public void run() {
        try {
            this.initHandlers();
        }
        catch (IOException ex) {
            DeepEdit.printlnToMessageTab("Error parsing files: " + ex.getLocalizedMessage());
            ex.printStackTrace(System.err);
        }
    }

    public String getPETOutputFolder() {
        return this.outputFolder.getAbsolutePath();
    }

    @Override
    public DE_Location getOutputLocation(String output) {
        if ("gen_p".equalsIgnoreCase(output)) {
            return this.getGenerationLocation();
        }
        if ("flow".equalsIgnoreCase(output)) {
            return this.getLineFlowLocation();
        }
        if ("maxflow_p".equalsIgnoreCase(output)) {
            return this.getLineFlowLimitLocation();
        }
        if ("load_p".equalsIgnoreCase(output)) {
            return this.getNodalLoadLocation();
        }
        if ("cmg".equalsIgnoreCase(output)) {
            return this.getNodalPriceLocation();
        }
        assert (false) : "Why are you using an unsupported output?? " + output;
        return null;
    }
}

