/*
 * Decompiled with CFR 0.152.
 */
package de.edil.pet;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Schematic;
import de.core.Simulation;
import de.core.comp;
import de.core.hdb_unit;
import de.data.DE_ClassEnums;
import de.data.DE_ValidationException;
import de.data.ExcelRangeAddress;
import de.data.ParameterData;
import de.edil.DE_LocationExcel;
import de.edil.pet.PETNew_Wizard;
import de.edil.pet.PETVisualDisplay;
import de.edil.pet.PET_enums;
import de.edil.pet.PET_validation;
import de.edil.pet.PET_validationException;
import de.solver.DE_Parameter;
import de.solver.DE_Set;
import de.solver.gmsi.GMSi_Parameter;
import de.solver.gmsi.GMSi_Set;
import de.solver.gmsi.GMSi_Subset;
import de.solver.gmsi.GMSi_solver;
import de.utils.ExcelUtil;
import de.utils.StringUtil;
import de.utils.Utils;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;

public class PETmanager
implements Runnable {
    private static PET_enums.Actions action = null;
    private static Simulation petCase;
    private static Workbook eWorkbook;
    private static List<DE_Set> lCase_SETs;
    private static List<DE_Parameter> lCase_PARAMETERs;

    public static void showNewPETCaseWizard(Window parent) {
        eWorkbook = null;
        final Window parentW = parent;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PETNew_Wizard dw = new PETNew_Wizard(parentW);
                dw.setLocationRelativeTo(parentW);
                dw.setVisible(true);
            }
        });
    }

    public static void showOpenPETCaseWizard() {
        assert (false) : "This hasn't been implemented!!";
    }

    public static void setEnv() throws IOException, DE_ValidationException {
        if (petCase == null) {
            return;
        }
        String petLabelID = DeepEdit.addMessageTab("PET case");
        DeepEdit.setActiveSimulation(petCase);
        eWorkbook = null;
        PETmanager.updateSETsFromModel(lCase_SETs);
        String sExcelFile = petCase.getParameterValue(DE_ClassEnums.Simulation.simsourcefile.name());
        if (sExcelFile == null) {
            throw new IOException("Simulation " + petCase.getName() + " must have a valid entry to input Excel file '" + sExcelFile + "'");
        }
        for (DE_Set set : lCase_SETs) {
            if (set.getFirstValueLocation() != null) continue;
            PETmanager.setSETLocation(set, sExcelFile);
        }
        PETmanager.updateSETsFromSchematic(lCase_SETs);
        PETmanager.updatePARAMETERsFromModel(lCase_SETs, lCase_PARAMETERs);
        for (DE_Parameter parameter : lCase_PARAMETERs) {
            if (parameter.getValLocation() != null && parameter.getSetLocation() != null) continue;
            PETmanager.setParameterLocation(parameter, sExcelFile);
        }
        PETmanager.updatePARAMETERsFromSchematic(lCase_PARAMETERs);
    }

    public static void newPETCase() throws InvalidFormatException, IOException, DE_ValidationException {
        int nRecords;
        action = PET_enums.Actions.newPETCase;
        PETmanager.setEnv();
        assert (petCase != null) : "Why setEnv() failed to create a new Simulation object??";
        String sExcelFile = petCase.getParameterValue("simsourcefile");
        DeepEdit.printlnToMessageTab("Creating a new PET Excel source file...");
        PETmanager.moveDefaultExcelFile(sExcelFile);
        Schematic actSch = DeepEdit.getActiveSchematic();
        DeepEdit.saveSchematicToFile(actSch, sExcelFile);
        DeepEdit.printlnToMessageTab("Finished initializing PET Excel file");
        for (DE_Set set : lCase_SETs) {
            if (!PET_validation.shouldPrintToExcel(set)) continue;
            nRecords = PETmanager.writeSetToExcel(set, sExcelFile, PET_validation.shouldUpdateHeaders(set), true);
            DeepEdit.printlnToMessageTab("SET '" + set.getSolverName() + " values writen to Excel: " + nRecords);
        }
        for (DE_Parameter parameter : lCase_PARAMETERs) {
            if (!PET_validation.shouldPrintToExcel(parameter)) continue;
            nRecords = PETmanager.writeParameterToExcel(parameter, sExcelFile, PET_validation.shouldUpdateHeaders(parameter), PET_validation.shouldUpdateElements(parameter), PET_validation.shouldUpdateValues(parameter));
            DeepEdit.printlnToMessageTab("Parameter '" + parameter.getSolverName() + " values writen to Excel: " + nRecords);
        }
        if (ExcelUtil.saveExcelWorkbook(eWorkbook, sExcelFile)) {
            DeepEdit.printlnToMessageTab("Finish creating new PET Excel case. File " + sExcelFile);
        }
        DeepEdit.setDataTabPane(PETVisualDisplay.getSolverTable(false));
    }

    public static void openPETCase() throws InvalidFormatException, IOException, DE_ValidationException {
        action = PET_enums.Actions.openPETCase;
        String sExcelFile = DeepEdit.showOpenFileChooser();
        if (sExcelFile == null) {
            return;
        }
        if (!ExcelUtil.isExcel2007FileType(sExcelFile)) {
            throw new IOException("Selected file type " + sExcelFile + " is not currently supported by PET-DE manager. Only Excel 2007 or newer");
        }
        DeepEdit.loadSchematicFromFile(sExcelFile);
        petCase = DeepEdit.getActiveSimulation();
        if (petCase == null) {
            throw new DE_ValidationException("No active Simulation object found in schematic file '" + sExcelFile + "' \nActivate a simulation object first (setting parameter isenable='true'");
        }
        petCase.setParameterValue(sExcelFile, DE_ClassEnums.Simulation.simsourcefile.name());
        PETmanager.setEnv();
        DeepEdit.setDataTabPane(PETVisualDisplay.getSolverTable(false));
    }

    public static void savePETCase() throws IOException, InvalidFormatException, DE_ValidationException {
        action = PET_enums.Actions.savePETcase;
        if (petCase == null) {
            throw new DE_ValidationException("There is no active PET-Simulation. First load from PET manager before storing case");
        }
        String sExcelFile = petCase.getParameterValue(DE_ClassEnums.Simulation.simsourcefile.name());
        GMSi_solver gmss = new GMSi_solver();
        PETmanager.initExcelConnection(sExcelFile);
        DE_Set[] lTemp = PETmanager.createEmptySET(PET_enums.DataSource.Schematic);
        ArrayList<DE_Set> lSchSET = new ArrayList<DE_Set>(Arrays.asList(lTemp));
        PETmanager.updateSETsFromSchematic(lSchSET);
        for (DE_Set set : lCase_SETs) {
            int nSetValues;
            if (!set.isSchematic()) continue;
            LinkedList<Object[]> lDelExcel = new LinkedList<Object[]>();
            LinkedList<Object[]> lAddExcel = new LinkedList<Object[]>();
            LinkedList<Object[]> lDelMemory = new LinkedList<Object[]>();
            LinkedList<Object[]> lAddMemory = new LinkedList<Object[]>();
            GMSi_Set gmsiset = (GMSi_Set)set;
            DE_LocationExcel locHeader = (DE_LocationExcel)gmsiset.getHeaderLocation();
            DE_LocationExcel locVal = (DE_LocationExcel)gmsiset.getFirstValueLocation();
            if (locVal == null) continue;
            GMSi_Set updateSET = (GMSi_Set)GMSi_Set.findSetNameInList(gmsiset.getName(), lSchSET, true);
            for (Object[] o : updateSET.allValues()) {
                if (gmsiset.contains(o)) continue;
                lAddMemory.add(o);
            }
            for (Object[] o : gmsiset.allValues()) {
                if (updateSET.contains(o)) continue;
                lDelMemory.add(o);
            }
            GMSi_Set excelSET = gmsiset.clone();
            excelSET.clear();
            try {
                int nValuesRead = PETmanager.readSetFromExcel(excelSET, sExcelFile);
            }
            catch (DE_ValidationException e) {
                throw new PET_validationException(e.getLocalizedMessage(), locVal.getRange(), sExcelFile);
            }
            for (Object[] o : updateSET.allValues()) {
                if (excelSET.contains(o)) continue;
                lAddExcel.add(o);
            }
            for (Object[] o : excelSET.allValues()) {
                if (updateSET.contains(o)) continue;
                lDelExcel.add(o);
            }
            if ("Generator".equalsIgnoreCase(gmsiset.getName()) || "Line".equalsIgnoreCase(gmsiset.getName()) || "Busbar".equalsIgnoreCase(gmsiset.getName())) {
                ExcelRangeAddress r = locVal.getRange();
                for (Object[] o : lDelExcel) {
                    int nRow = PETmanager.findElementRowInExcel(o[0], r, true);
                    assert (nRow != -1) : "How come you just identified this deletion and now you can't find the row ??";
                    ExcelUtil.removeRowFromExcel(eWorkbook, r.getRangeSheet(), nRow);
                }
            } else {
                PETmanager.clearSETFromExcel(set, sExcelFile);
            }
            if (gmsiset.isFundamental()) {
                for (DE_Parameter parameter : lCase_PARAMETERs) {
                    DE_LocationExcel setLoc;
                    GMSi_Parameter gmsiparameter = (GMSi_Parameter)parameter;
                    if (gmsiparameter.getSet(gmsiset.getName()) != null || (setLoc = (DE_LocationExcel)gmsiparameter.getSetLocation()) == null) continue;
                    for (int i = 0; i < gmsiparameter.getTotalNumSet(); ++i) {
                        if (gmsiparameter.getSet(gmsiset.getName()) == null) continue;
                        ExcelRangeAddress r = setLoc.getRange(i);
                        if (gmsiparameter.getColumnSetIndex() == i) {
                            for (Object[] o : lDelExcel) {
                                int colToRemove = PETmanager.findElementColumnInExcel(o[0], r, true);
                                if (colToRemove != -1) {
                                    ExcelUtil.removeColumnFromExcel(eWorkbook, r.getRangeSheet(), colToRemove);
                                    continue;
                                }
                                assert (false) : "Why we couldn't find an element that should be removed from Excel??" + o[i];
                            }
                            continue;
                        }
                        for (Object[] o : lDelExcel) {
                            int rowToRemove;
                            while ((rowToRemove = PETmanager.findElementRowInExcel(o[0], r, true)) != -1) {
                                ExcelUtil.removeRowFromExcel(eWorkbook, r.getRangeSheet(), rowToRemove);
                            }
                        }
                    }
                }
            }
            for (Object[] o : lDelMemory) {
                DeepEdit.printlnToMessageTab("Schematic deletion registered: " + gmsiset.getDisplayName(o));
                gmsiset.remove(o);
            }
            for (Object[] o : lAddMemory) {
                DeepEdit.printlnToMessageTab("Schematic addition registered: " + gmsiset.getDisplayName(o));
                gmsiset.add(o);
            }
            if (PET_validation.shouldPrintToExcel(gmsiset) && (nSetValues = PETmanager.writeSetToExcel(gmsiset, sExcelFile, PET_validation.shouldUpdateHeaders(gmsiset), true)) >= 0) continue;
        }
        for (DE_Parameter parameter : lCase_PARAMETERs) {
            if (!PET_enums.DataSource.Schematic.name().equalsIgnoreCase(parameter.getDataSource())) continue;
            GMSi_Parameter gmsiparameter = (GMSi_Parameter)parameter;
            LinkedList<Object[]> lDeletions = new LinkedList<Object[]>();
            LinkedList<Object[]> lAdditions = new LinkedList<Object[]>();
            ArrayList<Object[]> lkeysetOld = new ArrayList<Object[]>();
            for (Object oldEntry : parameter.keySet()) {
                if (!(oldEntry instanceof List)) continue;
                lkeysetOld.add(((List)oldEntry).toArray());
            }
            gmsiparameter.clear();
            gmss.defaultParameter(gmsiparameter);
            for (Object[] oSet : lkeysetOld) {
                if (gmsiparameter.indexOf(oSet) != -1) continue;
                lDeletions.add(oSet);
            }
            ArrayList<Object[]> lkeysetNew = new ArrayList<Object[]>();
            for (Object newEntry : gmsiparameter.keySet()) {
                if (!(newEntry instanceof List)) continue;
                lkeysetNew.add(((List)newEntry).toArray());
            }
            for (Object[] oNewElement : lkeysetNew) {
                boolean bContains = false;
                for (Object[] oOldElement : lkeysetOld) {
                    if (Arrays.hashCode(oNewElement) != Arrays.hashCode(oOldElement)) continue;
                    bContains = true;
                    break;
                }
                if (bContains) continue;
                lAdditions.add(oNewElement);
            }
            DE_LocationExcel setLoc = (DE_LocationExcel)gmsiparameter.getSetLocation();
            for (Object[] o : lDeletions) {
                int nRow;
                if (gmsiparameter.isTable()) {
                    int colindex = gmsiparameter.getColumnSetIndex();
                    Object[] o_sans_colset = Utils.reminderArray(colindex, o);
                    nRow = PETmanager.findElementRowInExcel((Object)o_sans_colset, setLoc.getRange(), true);
                } else {
                    nRow = PETmanager.findElementRowInExcel((Object)o, setLoc.getRange(), true);
                }
                if (nRow == -1) continue;
                ExcelUtil.removeRowFromExcel(eWorkbook, setLoc.getRange().getRangeSheet(), nRow);
            }
            if (!PET_validation.shouldPrintToExcel(gmsiparameter)) continue;
            int nRemoveValues = PETmanager.clearPARAMETERFromExcel(gmsiparameter, sExcelFile, PET_validation.shouldUpdateHeaders(gmsiparameter), PET_validation.shouldUpdateElements(gmsiparameter), PET_validation.shouldUpdateValues(gmsiparameter));
            DeepEdit.printlnToMessageTab("Parameter '" + gmsiparameter.getSolverName() + " values cleared from Excel: " + nRemoveValues);
            int nWriteValues = PETmanager.writeParameterToExcel(gmsiparameter, sExcelFile, PET_validation.shouldUpdateHeaders(parameter), PET_validation.shouldUpdateElements(gmsiparameter), PET_validation.shouldUpdateValues(gmsiparameter));
            DeepEdit.printlnToMessageTab("Parameter '" + gmsiparameter.getSolverName() + " values writen to Excel: " + nWriteValues);
            if (nWriteValues >= 0) continue;
        }
        if (!ExcelUtil.saveExcelWorkbook(eWorkbook, sExcelFile)) {
            throw new DE_ValidationException("Error saving Excel file '" + sExcelFile + "' to disk. Check for file write permissions");
        }
        DeepEdit.printlnToMessageTab("Excel datasource file " + sExcelFile + " has been updated from schematic");
        Schematic actSch = DeepEdit.getActiveSchematic();
        DeepEdit.saveSchematicToFile(actSch, sExcelFile);
        DeepEdit.printlnToMessageTab("Schematic has been saved to Excel file " + sExcelFile);
    }

    public static void saveAsPETCase() throws IOException, DE_ValidationException, FileNotFoundException, InvalidFormatException {
        int nRecords;
        action = PET_enums.Actions.saveAsPETCase;
        if (petCase == null) {
            throw new DE_ValidationException("There is no active PET-Simulation. First load from PET manager before storing case");
        }
        String sExcelFile = DeepEdit.showOpenFileChooser();
        if (sExcelFile == null) {
            return;
        }
        if (!ExcelUtil.isExcel2007FileType(sExcelFile)) {
            throw new IOException("Selected file type " + sExcelFile + " is not currently supported by PET-DE manager. Only Excel 2007 or newer");
        }
        PETmanager.moveDefaultExcelFile(sExcelFile);
        petCase.setParameterValue(sExcelFile, DE_ClassEnums.Simulation.simsourcefile.name());
        Schematic actSch = DeepEdit.getActiveSchematic();
        DeepEdit.saveSchematicToFile(actSch, sExcelFile);
        DeepEdit.printlnToMessageTab("Finished initializing PET Excel file");
        PETmanager.initExcelConnection(sExcelFile);
        for (DE_Set set : lCase_SETs) {
            if (!PET_validation.shouldPrintToExcel(set)) continue;
            nRecords = PETmanager.writeSetToExcel(set, sExcelFile, PET_validation.shouldUpdateHeaders(set), true);
            DeepEdit.printlnToMessageTab("SET '" + set.getSolverName() + " values writen to Excel: " + nRecords);
        }
        for (DE_Parameter parameter : lCase_PARAMETERs) {
            if (!PET_validation.shouldPrintToExcel(parameter)) continue;
            nRecords = PETmanager.writeParameterToExcel(parameter, sExcelFile, PET_validation.shouldUpdateHeaders(parameter), PET_validation.shouldUpdateElements(parameter), PET_validation.shouldUpdateValues(parameter));
            DeepEdit.printlnToMessageTab("Parameter '" + parameter.getSolverName() + " values writen to Excel: " + nRecords);
        }
        if (ExcelUtil.saveExcelWorkbook(eWorkbook, sExcelFile)) {
            DeepEdit.printlnToMessageTab("Finish storing PET Excel case. File " + sExcelFile);
        }
    }

    public static void syncSchematicFromExcel() throws IOException, InvalidFormatException, DE_ValidationException {
        if (petCase == null) {
            return;
        }
        action = PET_enums.Actions.updateSchematicFromExcel;
        String sExcelFile = petCase.getParameterValue(DE_ClassEnums.Simulation.simsourcefile.name());
        PETmanager.initExcelConnection(sExcelFile);
        PETmanager.updatePARAMETERsFromExcel(lCase_PARAMETERs);
        for (DE_Parameter parameter : lCase_PARAMETERs) {
            if (!PET_validation.shouldUpdateFromExcel(parameter)) continue;
            int nUpdates = 0;
            GMSi_Parameter gmsi_parameter = (GMSi_Parameter)parameter;
            if (gmsi_parameter.isComponentParameter()) {
                for (ParameterData pdata : gmsi_parameter.getParameterList()) {
                    if (pdata.getoOwnerComponent() != null) {
                        comp c = pdata.getoOwnerComponent();
                        if (!c.isSupportedParameter(pdata.Name) || !c.setParameterValue(pdata.Name, pdata.getValue())) continue;
                        ++nUpdates;
                        continue;
                    }
                    if (!"System".equalsIgnoreCase(pdata.getStrOwnerName())) continue;
                    DeepEdit.getActiveSchematic().setSystemParameter(pdata.Name, pdata.getValue());
                    ++nUpdates;
                }
            }
            if ("Generator_PET".equalsIgnoreCase(gmsi_parameter.getName()) || "Line_PET".equalsIgnoreCase(gmsi_parameter.getName()) || "agreement_PET".equalsIgnoreCase(gmsi_parameter.getName()) || "PET_MPExcG".equalsIgnoreCase(gmsi_parameter.getName()) || "PET_MPConjG".equalsIgnoreCase(gmsi_parameter.getName()) || "PET_MPPrecG".equalsIgnoreCase(gmsi_parameter.getName()) || "PET_MPExcT".equalsIgnoreCase(gmsi_parameter.getName()) || "PET_MPPrecT".equalsIgnoreCase(gmsi_parameter.getName()) || "PET_MPConjT".equalsIgnoreCase(gmsi_parameter.getName()) || "PET_MPCamET".equalsIgnoreCase(gmsi_parameter.getName()) || "PET_MPCamNT".equalsIgnoreCase(gmsi_parameter.getName())) {
                // empty if block
            }
            if (nUpdates <= 0) continue;
            DeepEdit.printlnToMessageTab("Parameter '" + parameter.getSolverName() + " has been updated from Excel: " + nUpdates);
        }
    }

    public static void executePETCase() throws IOException, InvalidFormatException, DE_ValidationException {
        action = PET_enums.Actions.executePETCase;
        if (petCase == null) {
            petCase = DeepEdit.getActiveSimulation();
            PETmanager.reset();
            PETmanager.setEnv();
        }
        if (!PET_validation.shouldContinueToExecute()) {
            return;
        }
        PETmanager.updateSETsFromSchematic(lCase_SETs);
        PETmanager.updatePARAMETERsFromSchematic(lCase_PARAMETERs);
        eWorkbook = null;
        PETmanager.updateSETsFromExcel(lCase_SETs);
        PETmanager.updatePARAMETERsFromExcel(lCase_PARAMETERs);
        PETmanager.writeCaseToOutputFile();
        PETmanager.writeGAMSConfigFile();
        PETmanager.writeREPORTConfigFile();
    }

    public static void closePETCase() {
        petCase = null;
        PETmanager.reset();
        action = null;
        DeepEditFrame.removeDataTabPane();
    }

    public static void updateSETsFromModel(List<DE_Set> lSets) throws IOException, DE_ValidationException {
        GMSi_solver gmss = new GMSi_solver();
        DeepEdit.printlnToMessageTab("Reading SETs from model file...");
        String gmsModelFile = PETmanager.getPETModelFile();
        String gmsMapFile = PETmanager.getDefaultPETMappingFile();
        File f_gmsModelFile = new File(gmsModelFile);
        File f_gmsMapFile = new File(gmsMapFile);
        LinkedList<DE_Set> lmodelSets = new LinkedList<DE_Set>();
        gmss.readSetFromModel(f_gmsModelFile, lmodelSets);
        for (DE_Set set : lmodelSets) {
            if (DE_Set.findSetNameInList(set.getName(), lSets, false) != null) continue;
            String solverSETName = set.getName();
            String DeepEditSETName = GMSi_solver.getDeepEditSETName(solverSETName, f_gmsMapFile);
            String dataSource = GMSi_solver.getDE_GAMSMappingValue(solverSETName, true, 5, f_gmsMapFile);
            String type = GMSi_solver.getDE_GAMSMappingValue(solverSETName, true, 6, f_gmsMapFile);
            String description = GMSi_solver.getDE_GAMSMappingValue(solverSETName, true, 2, f_gmsMapFile);
            if (DeepEditSETName != null) {
                assert (type.equalsIgnoreCase(PET_enums.RecordType.SET.name())) : "Why we are reading SETs and this is " + type;
                set.setName(DeepEditSETName);
                set.setSolverName(solverSETName);
                set.setDescription(description);
                set.setDataSource(dataSource);
                if (!set.isEmpty()) {
                    for (Object[] o : set.values()) {
                        String sSetValue = GMSi_solver.getDeepEditSETName(o.toString(), f_gmsMapFile);
                        String sLabel = GMSi_solver.getDE_GAMSMappingValue(o.toString(), true, 7, f_gmsMapFile);
                        if (sSetValue == null) continue;
                        set.replaceValue(o, sSetValue);
                        ((GMSi_Set)set).setLabel(o.toString(), sSetValue);
                    }
                }
            }
            lSets.add(set);
        }
    }

    public static void updatePARAMETERsFromModel(List<DE_Set> lSETs, List<DE_Parameter> lPARAMETERs) throws IOException {
        GMSi_solver gmss = new GMSi_solver();
        DeepEdit.printlnToMessageTab("Reading PARAMETERs from model file...");
        String gmsModelFile = PETmanager.getPETModelFile();
        String gmsMapFile = PETmanager.getDefaultPETMappingFile();
        File f_gmsModelFile = new File(gmsModelFile);
        File f_gmsMapFile = new File(gmsMapFile);
        LinkedList<DE_Parameter> lmodelParameters = new LinkedList<DE_Parameter>();
        gmss.readParameterFromModel(f_gmsModelFile, lSETs, lmodelParameters);
        for (DE_Parameter parameter : lmodelParameters) {
            String[] tempSETNames;
            if (DE_Parameter.findPARAMETERNameInList(parameter.getName(), lPARAMETERs, false) != null) continue;
            String solverPARAMETERName = parameter.getName();
            String DeepEditPARAMETERName = GMSi_solver.getDeepEditSETName(solverPARAMETERName, f_gmsMapFile);
            parameter.setSolverName(solverPARAMETERName);
            if (DeepEditPARAMETERName != null) {
                parameter.setName(DeepEditPARAMETERName);
            }
            if ((tempSETNames = GMSi_Parameter.getSetsFromParameterName(solverPARAMETERName)) != null) {
                for (String setName : tempSETNames) {
                    DE_Set set = DE_Set.findSetNameInList(setName, lSETs, false);
                    if (set == null) continue;
                    parameter.addSet(set);
                }
            }
            lPARAMETERs.add(parameter);
        }
    }

    public static void updateSETsFromSchematic(List<DE_Set> lSets) throws DE_ValidationException {
        DeepEdit.printlnToMessageTab("Updating SETs from schematic...");
        for (DE_Set set : lSets) {
            if (!set.isSchematic()) continue;
            String DeepEditSETName = set.getName();
            GMSi_Set gmsiset = (GMSi_Set)set;
            GMSi_Set DEset = PETmanager.createSchFundamentalSET(DeepEditSETName);
            if (DEset == null) continue;
            assert (DEset.getDimension() == 0) : "Why set " + set.getName() + " is recognized as fundamental DeepEdit SET but dimension is not zero??";
            gmsiset.clear();
            DEset.copyInto(gmsiset);
        }
        for (int index = 0; index < lSets.size(); ++index) {
            GMSi_Set DEset;
            GMSi_Set gmsiset = (GMSi_Set)lSets.get(index);
            if (!gmsiset.isSchematic() || (DEset = PETmanager.createSchMultidimSET(gmsiset.getName(), lSets)) == null) continue;
            DE_Set oldSet = lSets.set(index, DEset);
            assert (oldSet != null) : "Why this set wasn't replaced??? You always need to read from model file first!";
        }
    }

    public static void updatePARAMETERsFromSchematic(List<DE_Parameter> lParameters) throws DE_ValidationException {
        GMSi_solver gmss = new GMSi_solver();
        DeepEdit.printlnToMessageTab("Updating PARAMETERs from schematic...");
        for (DE_Parameter parameter : lParameters) {
            if (parameter.getName().equals(parameter.getSolverName())) continue;
            gmss.defaultParameter((GMSi_Parameter)parameter);
        }
    }

    public static void updateSETsFromExcel(List<DE_Set> lSets) throws InvalidFormatException, IOException, DE_ValidationException {
        String sExcelFile = petCase.getParameterValue("simsourcefile");
        for (DE_Set set : lSets) {
            int nValuesAdded = set.size();
            if (!PET_validation.shouldUpdateFromExcel(set)) continue;
            int nValuesRead = PETmanager.readSetFromExcel(set, sExcelFile);
            nValuesAdded = nValuesRead == -1 ? -1 : nValuesRead - nValuesAdded;
            DeepEdit.printlnToMessageTab("Sync SET '" + set.getSolverName() + "': Values from Excel: " + nValuesAdded);
        }
    }

    public static void updatePARAMETERsFromExcel(List<DE_Parameter> lParameters) throws InvalidFormatException, IOException, DE_ValidationException {
        String sExcelFile = petCase.getParameterValue("simsourcefile");
        for (DE_Parameter parameter : lParameters) {
            int nValuesAdded = parameter.size();
            if (!PET_validation.shouldUpdateFromExcel(parameter)) continue;
            int nValuesRead = PETmanager.readParameterFromExcel(parameter, sExcelFile);
            nValuesAdded = nValuesRead == -1 ? -1 : Math.abs(nValuesRead - nValuesAdded);
            DeepEdit.printlnToMessageTab("Sync PARAMETER '" + parameter.getSolverName() + "': Values from Excel: " + nValuesAdded);
        }
    }

    public static int readSetFromExcel(DE_Set set, String excelFile) throws InvalidFormatException, IOException, DE_ValidationException {
        if (eWorkbook == null) {
            PETmanager.initExcelConnection(excelFile);
        }
        File fExcel = new File(excelFile);
        File fMap = new File(PETmanager.getDefaultPETMappingFile());
        assert (fMap.exists()) : "Why did you stored an invalid mapping file";
        if (!fExcel.exists() || !fExcel.isFile()) {
            throw new IOException("Excel sourcefile not found. Make sure path to file is correct: '" + excelFile + "'");
        }
        GMSi_Set gmsi_set = (GMSi_Set)set;
        DE_LocationExcel setLoc = (DE_LocationExcel)gmsi_set.getFirstValueLocation();
        if (setLoc == null) {
            PETmanager.setSETLocation(gmsi_set, excelFile);
            setLoc = (DE_LocationExcel)gmsi_set.getFirstValueLocation();
        }
        if (setLoc == null) {
            DeepEdit.printlnToMessageTab("No valid location found in mapping file for SET " + gmsi_set.getSolverName() + "' No values read from sourcefile '" + excelFile + "'");
            return -1;
        }
        ArrayList<String[]> lLabels = new ArrayList<String[]>();
        PETmanager.readElementsFromExcel(setLoc, PETmanager.getMaximumSETSize(gmsi_set), -1, lLabels);
        GMSi_Set cloneSET = gmsi_set.clone();
        if (gmsi_set.getDimension() > 0) {
            List<GMSi_Set> lParents = gmsi_set.getParents();
            if (setLoc.getNumRanges() == gmsi_set.getDimension() + 1) {
                int nLastElement = setLoc.getNumRanges() - 1;
                for (String[] sElementLabel : lLabels) {
                    assert (setLoc.getNumRanges() == sElementLabel.length) : "Why these are not identical???";
                    if (sElementLabel[nLastElement].equalsIgnoreCase(String.valueOf(true))) {
                        Object[] oElement = new Object[gmsi_set.getDimension()];
                        boolean addToSet = true;
                        for (int i = 0; i < gmsi_set.getDimension(); ++i) {
                            if (sElementLabel[i].trim().isEmpty()) {
                                addToSet = false;
                                break;
                            }
                            Object o = lParents.get(i).get(sElementLabel[i].trim());
                            if (o == null) {
                                addToSet = false;
                                throw new PET_validationException("Invalid value [" + sElementLabel[i].trim() + "] entry in Excel for SET '" + set.getSolverName() + "'", setLoc.getRange(i), setLoc.getSourcePath());
                            }
                            oElement[i] = o;
                        }
                        if (!addToSet || !PET_validation.isValidPETSetEntry(oElement, set, null)) continue;
                        cloneSET.add(oElement);
                        continue;
                    }
                    if (sElementLabel[nLastElement].equalsIgnoreCase(String.valueOf(false)) || sElementLabel[nLastElement].trim().equalsIgnoreCase("")) continue;
                    throw new PET_validationException("Invalid value [" + sElementLabel[nLastElement].trim() + "] entry in Excel for SET '" + set.getSolverName() + "'. Valid entries are ONLY true/false", setLoc.getRange(nLastElement), setLoc.getSourcePath());
                }
            } else if (setLoc.getNumRanges() == gmsi_set.getDimension()) {
                for (String[] sElementLabel : lLabels) {
                    assert (sElementLabel.length == gmsi_set.getDimension()) : "Why the number of elements doesnt match the dimension of set??";
                    Object[] oElement = new Object[gmsi_set.getDimension()];
                    if (sElementLabel.length != gmsi_set.getDimension()) continue;
                    boolean addToSet = true;
                    for (int i = 0; i < gmsi_set.getDimension(); ++i) {
                        Object o = lParents.get(i).get(sElementLabel[i]);
                        if (o == null) {
                            addToSet = false;
                            throw new PET_validationException("Invalid value [" + sElementLabel[i].trim() + "] entry in Excel for SET '" + set.getSolverName() + "'", setLoc.getRange(i), setLoc.getSourcePath());
                        }
                        oElement[i] = o;
                    }
                    if (!addToSet || !PET_validation.isValidPETSetEntry(oElement, set, null)) continue;
                    cloneSET.add(oElement);
                }
            }
        } else if (gmsi_set.getDimension() == 0) {
            int cont = 0;
            for (String[] sElementLabel : lLabels) {
                assert (sElementLabel.length == 1) : "Why are you reading multiple columns (cells) for a fundamental SET '" + gmsi_set.getName() + "'?? Did you modify mapping file?";
                String sLabel = GMSi_Set.createLabel(sElementLabel);
                if (gmsi_set.isSchematic()) {
                    GMSi_Set sch_set = PETmanager.createSchFundamentalSET(gmsi_set.getName());
                    Object o = sch_set.get(sLabel);
                    if (o == null) {
                        if (PET_validation.isValidPETSetEntry(sElementLabel, gmsi_set, null)) {
                            cloneSET.add(sElementLabel);
                        }
                    } else if (PET_validation.isValidPETSetEntry(new Object[]{o}, gmsi_set, null)) {
                        cloneSET.add(o);
                    }
                } else if (PET_validation.isValidPETSetEntry(sElementLabel, set, null)) {
                    cloneSET.add(sElementLabel);
                }
                ++cont;
            }
        } else {
            assert (false) : "How this mayor bug got here? SET dimension=" + gmsi_set.getDimension();
            return -1;
        }
        gmsi_set.clear();
        return cloneSET.copyInto(gmsi_set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int readParameterFromExcel(DE_Parameter parameter, String excelFile) throws InvalidFormatException, IOException, DE_ValidationException {
        if (eWorkbook == null) {
            PETmanager.initExcelConnection(excelFile);
        }
        File fExcel = new File(excelFile);
        File fMap = new File(PETmanager.getDefaultPETMappingFile());
        assert (fMap.exists()) : "Why did you stored an invalid mapping file";
        if (!fExcel.exists() || !fExcel.isFile()) {
            return -1;
        }
        GMSi_Parameter gms_parameter = (GMSi_Parameter)parameter;
        int nValuesReadFromExcel = 0;
        if (gms_parameter.isScalar()) {
            DE_LocationExcel valLoc = (DE_LocationExcel)gms_parameter.getValLocation();
            DE_LocationExcel headerLoc = (DE_LocationExcel)gms_parameter.getSetLocation();
            assert (valLoc != null) : "Why location wasn't defined for SCALAR '" + gms_parameter.getName() + "'???";
            if (valLoc != null) {
                ExcelRangeAddress r = valLoc.getRange();
                String[][] data2 = ExcelUtil.readExcel2007Data(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), r.getEndRow(), r.getEndColumn());
                if (data2.length <= 0 || data2[0].length <= 0) return nValuesReadFromExcel;
                double dValue = StringUtil.safeParseDouble(data2[0][0]);
                if (gms_parameter.setValue(dValue, new Object[0])) {
                    return 1;
                }
                DeepEdit.printlnToMessageTab("Warning: Parameter " + gms_parameter.getName() + " couldn't be updated from Excel");
                return -1;
            }
            DeepEdit.printlnToMessageTab("Warning: No valid location found for SCALAR '" + gms_parameter.getName() + "' in mapping file. No values read from Excel '" + excelFile + "'");
            return -1;
        }
        if (gms_parameter.isTable()) {
            DE_LocationExcel setLoc = (DE_LocationExcel)gms_parameter.getSetLocation();
            DE_LocationExcel valLoc = (DE_LocationExcel)gms_parameter.getValLocation();
            assert (valLoc == null) : "Why mapping file is giving a val location if this is a table?? Did you modify it latetly?";
            if (setLoc == null) {
                DeepEdit.printlnToMessageTab("No valid location found for TABLE '" + gms_parameter.getName() + "' in mapping file. No values read from Excel '" + excelFile + "'");
                return -1;
            }
            int indexColSet = gms_parameter.getColumnSetIndex();
            ArrayList<ExcelRangeAddress> rangeV = new ArrayList<ExcelRangeAddress>();
            ArrayList<ExcelRangeAddress> rangeH = new ArrayList<ExcelRangeAddress>();
            assert (setLoc.getNumRanges() == gms_parameter.getTotalNumSet()) : "Error in mapping file: There should be a location for each SET! Location blocks: " + setLoc.getNumRanges() + " ;Sets: " + gms_parameter.getTotalNumSet() + "; Parameter: " + gms_parameter.getName();
            for (int i = 0; i < setLoc.getNumRanges(); ++i) {
                if (setLoc.getMissingDataOrientation(i).equalsIgnoreCase(PET_enums.DataOrientation.vertical.name())) {
                    rangeV.add(setLoc.getRange(i));
                    continue;
                }
                if (setLoc.getMissingDataOrientation(i).equalsIgnoreCase(PET_enums.DataOrientation.horizontal.name())) {
                    rangeH.add(setLoc.getRange(i));
                    continue;
                }
                assert (false) : "Why mapping file stored an orientation different from vertical or horizontal for TABLE '" + gms_parameter.getName() + "'";
            }
            assert (rangeH.size() == 1) : "Error in mapping file: Current version only supports 1 horizontal SET but instead " + rangeH.size() + " were found for parameter " + gms_parameter.getName();
            ArrayList<String[]> lLabels = new ArrayList<String[]>();
            PETmanager.readListFromExcel(setLoc, lLabels);
            for (Object[] objectArray : lLabels) {
                Object[] oElement;
                Object[] sElements_sans_colSet = Utils.reminderArray(indexColSet, objectArray);
                int nObjRow = PETmanager.findElementRowInExcel(sElements_sans_colSet, rangeV.toArray(new ExcelRangeAddress[0]), false);
                int nValCol = PETmanager.findElementColumnInExcel(objectArray[indexColSet], (ExcelRangeAddress)rangeH.get(0), false);
                if (nValCol == -1) assert (false) : "Why if we just read???";
                double dValue = 0.0;
                String[][] data3 = ExcelUtil.readExcel2007Data(eWorkbook, ((ExcelRangeAddress)rangeH.get(0)).getRangeSheet(), nObjRow, nValCol, nObjRow, nValCol);
                if (data3 == null || data3[0][0] == null || data3[0][0].isEmpty() || PET_validation.isValidPETParameterEntry(oElement = gms_parameter.getElements((String[])objectArray), data3[0][0], gms_parameter, new ExcelRangeAddress(((ExcelRangeAddress)rangeH.get(0)).getRangeSheet(), nObjRow, nValCol))) continue;
                gms_parameter.setValue(Double.parseDouble(data3[0][0]), oElement);
                ++nValuesReadFromExcel;
            }
            return nValuesReadFromExcel;
        } else {
            String[][] stringArray;
            DE_LocationExcel setLoc = (DE_LocationExcel)gms_parameter.getSetLocation();
            DE_LocationExcel valLoc = (DE_LocationExcel)gms_parameter.getValLocation();
            if (setLoc == null || valLoc == null) {
                DeepEdit.printlnToMessageTab("No valid location found for PARAMETER '" + gms_parameter.getName() + "' in mapping file. No values read from Excel '" + excelFile + "'");
                return -1;
            }
            ArrayList<ExcelRangeAddress> rangeSet = new ArrayList<ExcelRangeAddress>(Arrays.asList(setLoc.getAllRanges()));
            LinkedList<ExcelRangeAddress> rangeVal = new LinkedList<ExcelRangeAddress>(Arrays.asList(valLoc.getAllRanges()));
            assert (setLoc.getNumRanges() == gms_parameter.getTotalNumSet()) : "Error in mapping file: There should be a location for each SET! Location blocks: " + setLoc.getNumRanges() + " ;Sets: " + gms_parameter.getTotalNumSet();
            assert (valLoc.getNumRanges() == 1) : "Error in mapping file: Why there is not only 1 location but " + valLoc.getNumRanges() + "??";
            ArrayList<String[]> lLabels = new ArrayList<String[]>();
            PETmanager.readListFromExcel(setLoc, lLabels);
            ArrayList<String> lValues = new ArrayList<String>();
            ExcelRangeAddress r = rangeVal.getFirst();
            for (String[] data1 : stringArray = ExcelUtil.readExcel2007Data(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), r.getInitRow() + lLabels.size(), r.getInitColumn())) {
                lValues.add(data1[0]);
            }
            assert (lLabels.size() != lValues.size()) : "Why there are values '" + lValues.size() + "' but only '" + lLabels.size() + "' labels??";
            gms_parameter.clear();
            for (int i = 0; i < lLabels.size(); ++i) {
                Object[] oElement = gms_parameter.getElements((String[])lLabels.get(i));
                String sValue = (String)lValues.get(i);
                if (sValue.isEmpty() || !PET_validation.isValidPETParameterEntry(oElement, sValue, gms_parameter, new ExcelRangeAddress(r.getRangeSheet(), r.getInitRow() + i, r.getInitColumn()))) continue;
                gms_parameter.setValue(Double.parseDouble(sValue), oElement);
                ++nValuesReadFromExcel;
            }
        }
        return nValuesReadFromExcel;
    }

    public static int writeSetToExcel(DE_Set set, String excelFile, boolean bPrintHeaders, boolean bPrintElements) throws InvalidFormatException, IOException {
        File fExcel;
        if (eWorkbook == null) {
            PETmanager.initExcelConnection(excelFile);
        }
        if ((fExcel = new File(excelFile)).exists() && fExcel.isFile()) {
            String[][] data2;
            int index;
            GMSi_Set gms_set = (GMSi_Set)set;
            DE_LocationExcel headerLoc = (DE_LocationExcel)gms_set.getHeaderLocation();
            DE_LocationExcel setLoc = (DE_LocationExcel)gms_set.getFirstValueLocation();
            int nValuesWritenToExcel = 0;
            if (headerLoc != null && bPrintHeaders) {
                index = 0;
                for (ExcelRangeAddress r : headerLoc.getAllRanges()) {
                    data2 = new String[1][1];
                    data2[0][0] = gms_set.getDimension() == 0 ? gms_set.getSolverName() : gms_set.getParents().get(index).getSolverName();
                    nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), data2);
                    ++index;
                }
            }
            if (setLoc != null && bPrintElements) {
                String sOrientation;
                if (set.getDimension() == 1) {
                    if (setLoc.getNumRanges() == 1) {
                        ExcelRangeAddress r = setLoc.getRange();
                        sOrientation = setLoc.getMissingDataOrientation();
                        PET_enums.DataOrientation orientation = PET_enums.DataOrientation.vertical;
                        if (sOrientation != null) {
                            orientation = PET_enums.DataOrientation.valueOf(sOrientation);
                        }
                        return PETmanager.writeListToExcel(gms_set.values(), r, orientation);
                    }
                    if (setLoc.getNumRanges() == 2) {
                        ExcelRangeAddress rParent = setLoc.getRange(0);
                        ExcelRangeAddress rValues = setLoc.getRange(1);
                        String sOrientationParent = setLoc.getMissingDataOrientation(0);
                        String sOrientationValues = setLoc.getMissingDataOrientation(1);
                        int nSize = ((GMSi_Subset)set).getParent().size();
                        int nClear = ExcelUtil.clearContentExcel(eWorkbook, rValues.getRangeSheet(), rValues.getInitRow(), rValues.getInitColumn(), rValues.getInitRow() + nSize, rValues.getInitColumn());
                        for (Object[] o : gms_set.allValues()) {
                            int nParentRow = PETmanager.findElementRowInExcel(o[0], rParent, true);
                            if (nParentRow == -1) {
                                assert (false) : "Why the parent is missing???";
                                continue;
                            }
                            String[][] data3 = new String[1][1];
                            data3[0][0] = String.valueOf(true);
                            nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, rValues.getRangeSheet(), nParentRow, rValues.getInitColumn(), data3);
                        }
                        return nValuesWritenToExcel;
                    }
                    assert (false) : "This seems to be a corrupted mapping file! Invalid number of locations for subsets";
                    return -1;
                }
                if (set.getDimension() > 1) {
                    for (index = 0; index < setLoc.getNumRanges(); ++index) {
                        ExcelRangeAddress r;
                        assert (setLoc.getNumRanges() == set.getDimension()) : "This is a corrupted mapping file! There should be one location per parent set. Locations=" + setLoc.getNumRanges() + "; Number of parent sets=" + set.getDimension();
                        if (index == 0 && PET_validation.hasReferenceColumn(gms_set)) continue;
                        if (PET_validation.hasReferenceColumn(gms_set)) {
                            r = setLoc.getRange(index);
                            ExcelRangeAddress r_1 = setLoc.getRange(index - 1);
                            for (Object[] oList : gms_set.allValues()) {
                                data2 = new String[1][1];
                                data2[0][0] = oList[index].toString();
                                int nRow = PETmanager.findElementRowInExcel(oList[index - 1], r_1, true);
                                if (nRow == -1) continue;
                                nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, r.getRangeSheet(), nRow, r.getInitColumn(), data2);
                            }
                            continue;
                        }
                        r = setLoc.getRange(index);
                        String sOrientation2 = setLoc.getMissingDataOrientation(index);
                        PET_enums.DataOrientation orientation = PET_enums.DataOrientation.vertical;
                        if (sOrientation2 != null) {
                            orientation = PET_enums.DataOrientation.valueOf(sOrientation2);
                        }
                        ArrayList<Object> lElements = new ArrayList<Object>();
                        for (Object[] oList : gms_set.allValues()) {
                            lElements.add(oList[index]);
                        }
                        nValuesWritenToExcel += PETmanager.writeListToExcel(lElements, r, orientation);
                    }
                    return nValuesWritenToExcel;
                }
                if (set.getDimension() == 0) {
                    ExcelRangeAddress r = setLoc.getRange();
                    sOrientation = setLoc.getMissingDataOrientation();
                    PET_enums.DataOrientation orientation = PET_enums.DataOrientation.vertical;
                    if (sOrientation != null) {
                        orientation = PET_enums.DataOrientation.valueOf(sOrientation);
                    }
                    List<Object> l = PETmanager.createUniqueNameList(gms_set.values());
                    return PETmanager.writeListToExcel(l, r, orientation);
                }
            }
        }
        return -1;
    }

    public static int writeParameterToExcel(DE_Parameter parameter, String excelFile, boolean bPrintHeaders, boolean bPrintElements, boolean bPrintValues) throws IOException, InvalidFormatException {
        int nValuesWritenToExcel;
        block34: {
            GMSi_Parameter gms_parameter;
            block33: {
                ExcelRangeAddress r;
                File fExcel;
                if (eWorkbook == null) {
                    PETmanager.initExcelConnection(excelFile);
                }
                if (!(fExcel = new File(excelFile)).exists() || !fExcel.isFile()) {
                    return -1;
                }
                gms_parameter = (GMSi_Parameter)parameter;
                nValuesWritenToExcel = 0;
                if (!gms_parameter.isScalar()) break block33;
                String[][] data2 = new String[1][1];
                DE_LocationExcel valLoc = (DE_LocationExcel)gms_parameter.getValLocation();
                DE_LocationExcel headerLoc = (DE_LocationExcel)gms_parameter.getSetLocation();
                assert (valLoc != null) : "Why location wasn't defined for SCALAR '" + gms_parameter.getName() + "'???";
                if (headerLoc != null && bPrintHeaders) {
                    r = headerLoc.getRange();
                    data2[0][0] = gms_parameter.getSolverName();
                    nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), data2);
                }
                if (valLoc == null || !bPrintValues) break block34;
                r = valLoc.getRange();
                double dValue = gms_parameter.getValue();
                data2[0][0] = String.valueOf(dValue);
                nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), data2);
                break block34;
            }
            if (gms_parameter.isTable()) {
                DE_LocationExcel setLoc = (DE_LocationExcel)gms_parameter.getSetLocation();
                DE_LocationExcel valLoc = (DE_LocationExcel)gms_parameter.getValLocation();
                assert (valLoc == null) : "Why there is a value location in mapping file when this is a TABLE type Parameter???";
                int indexColSet = gms_parameter.getColumnSetIndex();
                ArrayList<ExcelRangeAddress> rangeV = new ArrayList<ExcelRangeAddress>();
                ArrayList<ExcelRangeAddress> rangeH = new ArrayList<ExcelRangeAddress>();
                assert (setLoc.getNumRanges() == gms_parameter.getTotalNumSet()) : "Error in mapping file: There should be a location for each SET! Location blocks: " + setLoc.getNumRanges() + " ;Sets: " + gms_parameter.getTotalNumSet() + "; Parameter: " + gms_parameter.getName();
                for (int i = 0; i < setLoc.getNumRanges(); ++i) {
                    if (setLoc.getMissingDataOrientation(i).equalsIgnoreCase(PET_enums.DataOrientation.vertical.name())) {
                        rangeV.add(setLoc.getRange(i));
                        continue;
                    }
                    if (setLoc.getMissingDataOrientation(i).equalsIgnoreCase(PET_enums.DataOrientation.horizontal.name())) {
                        rangeH.add(setLoc.getRange(i));
                        continue;
                    }
                    assert (false) : "Why mapping file stored an orientation different from vertical or horizontal for TABLE '" + gms_parameter.getName() + "'";
                }
                assert (rangeH.size() == 1) : "Error in mapping file: Current version only supports 1 horizontal SET but instead " + rangeH.size() + " were found for parameter " + gms_parameter.getName();
                if (bPrintHeaders) {
                    DE_Set colSet = gms_parameter.getColumnSet();
                    String[][] data3 = new String[1][colSet.size()];
                    for (int i = 0; i < colSet.size(); ++i) {
                        data3[0][i] = ((GMSi_Set)colSet).getDisplayName(i);
                    }
                    nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, ((ExcelRangeAddress)rangeH.get(0)).getRangeSheet(), ((ExcelRangeAddress)rangeH.get(0)).getInitRow(), ((ExcelRangeAddress)rangeH.get(0)).getInitColumn(), data3);
                }
                for (Object entry : gms_parameter.entrySet()) {
                    Map.Entry mValue = (Map.Entry)entry;
                    Object[] oElement = ((List)mValue.getKey()).toArray();
                    Object[] sElement = gms_parameter.getDisplayNames(oElement);
                    assert (oElement.length > 1) : "Why table " + gms_parameter.getName() + " has only " + oElement.length + " elements instead (at least) 2 SET elements? All GAMS TABLES should have at least 2 SETs, one in rows and 1 in columns";
                    if (oElement.length <= 1) continue;
                    Object[] sElement_sans_colSet = Utils.reminderArray(indexColSet, sElement);
                    double dValue = (Double)mValue.getValue();
                    assert (sElement_sans_colSet != null) : "Why paramter " + gms_parameter.getName() + " has null entries???";
                    int nObjRow = PETmanager.findElementRowInExcel(sElement_sans_colSet, rangeV.toArray(new ExcelRangeAddress[0]), false);
                    assert (sElement[indexColSet] != null) : "Why column set " + indexColSet + " entry is empty in parameter '" + gms_parameter.getDisplayName() + "'?";
                    int nValCol = PETmanager.findElementColumnInExcel(sElement[indexColSet], (ExcelRangeAddress)rangeH.get(0), false);
                    if (nValCol == -1) {
                        nValCol = gms_parameter.indexOf(oElement) + ((ExcelRangeAddress)rangeH.get(0)).getInitColumn();
                    }
                    if (nObjRow == -1) {
                        nObjRow = PETmanager.findWhiteRowInExcel((ExcelRangeAddress)rangeV.get(0));
                        assert (nObjRow != -1) : "is this really true? how could it NOT find just one empty cell???";
                        if (bPrintElements) {
                            for (int i = 0; i < sElement_sans_colSet.length; ++i) {
                                assert (sElement_sans_colSet[i] != null) : "Why parameter " + gms_parameter.getName() + " has a null entry???";
                                String[][] data4 = new String[1][1];
                                data4[0][0] = sElement_sans_colSet[i].toString();
                                nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, ((ExcelRangeAddress)rangeV.get(i)).getRangeSheet(), nObjRow, ((ExcelRangeAddress)rangeV.get(i)).getInitColumn(), data4);
                            }
                        }
                    }
                    if (!bPrintValues) continue;
                    String[][] data5 = new String[1][1];
                    data5[0][0] = String.valueOf(dValue);
                    nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, ((ExcelRangeAddress)rangeH.get(0)).getRangeSheet(), nObjRow, nValCol, data5);
                }
            } else {
                DE_LocationExcel setLoc = (DE_LocationExcel)gms_parameter.getSetLocation();
                DE_LocationExcel valLoc = (DE_LocationExcel)gms_parameter.getValLocation();
                assert (setLoc != null && valLoc != null) : "Why aren't both set and value location defined in mapping file when this is a PARAMETER type Parameter???";
                ArrayList<ExcelRangeAddress> rangeSet = new ArrayList<ExcelRangeAddress>(Arrays.asList(setLoc.getAllRanges()));
                ArrayList<ExcelRangeAddress> rangeVal = new ArrayList<ExcelRangeAddress>(Arrays.asList(valLoc.getAllRanges()));
                assert (setLoc.getNumRanges() == gms_parameter.getTotalNumSet()) : "Error in mapping file: There should be a location for each SET! Location blocks: " + setLoc.getNumRanges() + " ;Sets: " + gms_parameter.getTotalNumSet();
                assert (valLoc.getNumRanges() == 1) : "Error in mapping file: Why there is not only 1 location but " + valLoc.getNumRanges() + "??";
                for (Object entry : gms_parameter.entrySet()) {
                    Map.Entry mValue = (Map.Entry)entry;
                    Object[] oElement = ((List)mValue.getKey()).toArray();
                    double dValue = (Double)mValue.getValue();
                    int nObjRow = PETmanager.findElementRowInExcel(oElement, rangeSet.toArray(new ExcelRangeAddress[0]), false);
                    if (nObjRow == -1) {
                        nObjRow = PETmanager.findWhiteRowInExcel((ExcelRangeAddress)rangeSet.get(0));
                        assert (nObjRow != -1) : "is this really true? how could it NOT find just one empty cell???";
                        if (bPrintElements) {
                            for (int i = 0; i < oElement.length; ++i) {
                                String[][] data6 = new String[1][1];
                                data6[0][0] = oElement[i].toString();
                                nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, ((ExcelRangeAddress)rangeSet.get(i)).getRangeSheet(), nObjRow, ((ExcelRangeAddress)rangeSet.get(i)).getInitColumn(), data6);
                            }
                        }
                    }
                    if (!bPrintValues) continue;
                    String[][] data7 = new String[1][1];
                    data7[0][0] = String.valueOf(dValue);
                    nValuesWritenToExcel += ExcelUtil.writeExcel2007Data(eWorkbook, ((ExcelRangeAddress)rangeVal.get(0)).getRangeSheet(), nObjRow, ((ExcelRangeAddress)rangeVal.get(0)).getInitColumn(), data7);
                }
            }
        }
        return nValuesWritenToExcel;
    }

    public static int clearSETFromExcel(DE_Set set, String excelFile) throws DE_ValidationException, IOException, InvalidFormatException {
        if (eWorkbook == null) {
            PETmanager.initExcelConnection(excelFile);
        }
        File fExcel = new File(excelFile);
        int clearValues = 0;
        if (fExcel.exists() && fExcel.isFile()) {
            GMSi_Set gms_set = (GMSi_Set)set;
            DE_LocationExcel setLoc = (DE_LocationExcel)gms_set.getFirstValueLocation();
            int nMaxSize = gms_set.getMaximumSize();
            if (setLoc != null) {
                block9: for (int i = 0; i < setLoc.getNumRanges(); ++i) {
                    ExcelRangeAddress r = setLoc.getRange(i);
                    String sOrientation = setLoc.getMissingDataOrientation(i);
                    PET_enums.DataOrientation orientation = PET_enums.DataOrientation.none;
                    if (sOrientation != null) {
                        orientation = PET_enums.DataOrientation.valueOf(sOrientation);
                    }
                    if (PET_validation.hasReferenceColumn(gms_set) && i == 0) {
                        switch (orientation) {
                            case horizontal: {
                                nMaxSize = Math.max(nMaxSize, PETmanager.findWhiteColInExcel(r));
                                break;
                            }
                            case vertical: {
                                nMaxSize = Math.max(nMaxSize, PETmanager.findWhiteRowInExcel(r));
                            }
                        }
                        continue;
                    }
                    switch (orientation) {
                        case horizontal: {
                            int nLastCol = PETmanager.findWhiteColInExcel(r);
                            nLastCol = Math.max(nLastCol, nMaxSize);
                            clearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), r.getInitRow(), nLastCol);
                            continue block9;
                        }
                        case vertical: {
                            int nLastRow = PETmanager.findWhiteRowInExcel(r);
                            nLastRow = Math.max(nLastRow, nMaxSize);
                            clearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), nLastRow, r.getInitColumn());
                            continue block9;
                        }
                        case none: {
                            clearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), r.getInitRow(), r.getInitColumn());
                            continue block9;
                        }
                        default: {
                            assert (false) : "Did you modify the orientation constants???";
                            continue block9;
                        }
                    }
                }
            }
        }
        return clearValues;
    }

    public static int clearPARAMETERFromExcel(DE_Parameter parameter, String excelFile, boolean clearHeaders, boolean clearElements, boolean clearValues) throws IOException, InvalidFormatException {
        if (eWorkbook == null) {
            PETmanager.initExcelConnection(excelFile);
        }
        File fExcel = new File(excelFile);
        int nClearValues = 0;
        int nSize = parameter.size();
        if (fExcel.exists() && fExcel.isFile()) {
            GMSi_Parameter gms_parameter = (GMSi_Parameter)parameter;
            DE_LocationExcel setLoc = (DE_LocationExcel)gms_parameter.getSetLocation();
            DE_LocationExcel valLoc = (DE_LocationExcel)gms_parameter.getValLocation();
            if (gms_parameter.isScalar()) {
                ExcelRangeAddress r = valLoc.getRange();
                nClearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), r.getInitRow(), r.getInitColumn());
            } else if (gms_parameter.isTable()) {
                ExcelRangeAddress r;
                int i;
                int indexColSet = gms_parameter.getColumnSetIndex();
                int nLastRow = 0;
                int nLastCol = 0;
                for (i = 0; i < setLoc.getNumRanges(); ++i) {
                    r = setLoc.getRange(i);
                    String sOrientation = setLoc.getMissingDataOrientation(i);
                    if (PET_enums.DataOrientation.vertical.name().equalsIgnoreCase(sOrientation)) {
                        nLastRow = Math.max(nLastRow, PETmanager.findWhiteRowInExcel(r));
                        continue;
                    }
                    if (PET_enums.DataOrientation.horizontal.name().equalsIgnoreCase(sOrientation)) {
                        nLastCol = Math.max(nLastCol, PETmanager.findWhiteColInExcel(r));
                        nLastCol = Math.max(nLastCol, gms_parameter.getColumnSet().size());
                        continue;
                    }
                    assert (false) : "Error in mapping file. Tables should always define orientation!";
                }
                nLastRow = Math.max(nLastRow, nSize);
                for (i = 0; i < setLoc.getNumRanges(); ++i) {
                    r = setLoc.getRange(i);
                    if (clearHeaders && i == indexColSet) {
                        nClearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), r.getInitRow(), nLastCol);
                    }
                    if (clearElements && i != indexColSet) {
                        assert (setLoc.getMissingDataOrientation(i).equalsIgnoreCase("vertical")) : "Error in mapping file. Only column set can have an orientation different than vertical!";
                        nClearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), nLastRow, r.getInitColumn());
                    }
                    if (!clearValues || i != indexColSet) continue;
                    assert (setLoc.getMissingDataOrientation(i).equalsIgnoreCase("horizontal")) : "Error in mapping file. Column set must have an horizontal orientation!";
                    nClearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), nLastRow, nLastCol);
                }
            } else {
                int nLastRow = 0;
                for (int i = 0; i < setLoc.getNumRanges(); ++i) {
                    ExcelRangeAddress r = setLoc.getRange(i);
                    String sOrientation = setLoc.getMissingDataOrientation(i);
                    if (PET_enums.DataOrientation.vertical.name().equalsIgnoreCase(sOrientation)) {
                        nLastRow = Math.max(nLastRow, PETmanager.findWhiteRowInExcel(r));
                        continue;
                    }
                    if (PET_enums.DataOrientation.horizontal.name().equalsIgnoreCase(sOrientation)) assert (false) : "Error in mapping file right?";
                }
                nLastRow = Math.max(nLastRow, PETmanager.findWhiteRowInExcel(valLoc.getRange()));
                if (clearElements) {
                    for (ExcelRangeAddress r : setLoc.getAllRanges()) {
                        nClearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), nLastRow, r.getInitColumn());
                    }
                }
                if (clearValues) {
                    ExcelRangeAddress r = valLoc.getRange();
                    nClearValues += ExcelUtil.clearContentExcel(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), nLastRow, r.getInitColumn());
                }
            }
        }
        return nClearValues;
    }

    private static int findElementRowInExcel(Object oElement, ExcelRangeAddress inRange, boolean matchCase) {
        return PETmanager.findElementRowInExcel(new Object[]{oElement}, new ExcelRangeAddress[]{inRange}, matchCase);
    }

    private static int findElementRowInExcel(Object[] oElement, ExcelRangeAddress[] inRange, boolean matchCase) {
        assert (oElement.length > 0) : "Never use zero lenght arrays. Always search for something!";
        assert (oElement.length <= inRange.length) : "Malformed array range. This will create an indexoutofbounds exception";
        if (oElement.length == 0) {
            return -1;
        }
        int matchRow = inRange[0].getInitRow();
        while ((matchRow = ExcelUtil.findRowInExcel(oElement[0], eWorkbook, inRange[0].getRangeSheet(), matchRow, inRange[0].getInitColumn(), matchCase)) != -1) {
            boolean isMatch = true;
            for (int i = 0; i < oElement.length; ++i) {
                String[][] data2 = ExcelUtil.readExcel2007Data(eWorkbook, inRange[i].getRangeSheet(), matchRow, inRange[i].getInitColumn(), matchRow, inRange[i].getInitColumn());
                if (matchCase) {
                    isMatch &= oElement[i].toString().equals(data2[0][0]);
                    continue;
                }
                isMatch &= oElement[i].toString().equalsIgnoreCase(data2[0][0]);
            }
            if (isMatch) {
                return matchRow;
            }
            ++matchRow;
        }
        return -1;
    }

    private static int findElementColumnInExcel(Object oElement, ExcelRangeAddress fromRange, boolean matchCase) {
        return PETmanager.findElementColumnInExcel(new Object[]{oElement}, new String[]{fromRange.getRangeSheet()}, new int[]{fromRange.getInitRow()}, new int[]{fromRange.getInitColumn()}, matchCase);
    }

    private static int findElementColumnInExcel(Object[] oElement, String[] sheet, int[] initRow, int[] initCol, boolean matchCase) {
        assert (oElement.length > 0) : "Never use zero lenght arrays. Always search for something!";
        assert (oElement.length <= sheet.length) : "Malformed array sheet. This will create an indexoutofbounds exception";
        assert (oElement.length <= initRow.length) : "Malformed array initRow. This will create an indexoutofbounds exception";
        assert (oElement.length <= initCol.length) : "Malformed array initCol. This will create an indexoutofbounds exception";
        if (oElement.length == 0) {
            return -1;
        }
        int matchCol = initCol[0];
        while ((matchCol = ExcelUtil.findColumnInExcel(oElement[0], eWorkbook, sheet[0], initRow[0], matchCol, matchCase)) != -1) {
            boolean isMatch = true;
            for (int i = 0; i < oElement.length; ++i) {
                String[][] data2 = ExcelUtil.readExcel2007Data(eWorkbook, sheet[i], initRow[i], matchCol, initRow[i], matchCol);
                if (matchCase) {
                    isMatch &= oElement[i].toString().equals(data2[0][0]);
                    continue;
                }
                isMatch &= oElement[i].toString().equalsIgnoreCase(data2[0][0]);
            }
            if (isMatch) {
                return matchCol;
            }
            ++matchCol;
        }
        return -1;
    }

    private static int findWhiteRowInExcel(ExcelRangeAddress fromRange) {
        int initRow = fromRange.getInitRow();
        int initCol = fromRange.getInitColumn();
        String[][] data2 = ExcelUtil.readExcel2007Data(eWorkbook, fromRange.getRangeSheet(), initRow, initCol, -1, initCol);
        int cont = initRow;
        if (data2 == null) {
            return cont;
        }
        if (data2.length == 0) {
            return cont;
        }
        for (String[] data1 : data2) {
            if (data1 == null) {
                return cont;
            }
            if (data1.length == 0) {
                return cont;
            }
            if (data1[0] == null) {
                return cont;
            }
            if (data1[0].isEmpty()) {
                return cont;
            }
            ++cont;
        }
        return cont;
    }

    private static int findWhiteColInExcel(ExcelRangeAddress fromRange) {
        int initRow = fromRange.getInitRow();
        int initCol = fromRange.getInitColumn();
        String[][] data2 = ExcelUtil.readExcel2007Data(eWorkbook, fromRange.getRangeSheet(), initRow, initCol, initRow, -1);
        int cont = initCol;
        if (data2 == null) {
            return cont;
        }
        if (data2.length == 0) {
            return cont;
        }
        int i$ = 0;
        String[][] arr$ = data2;
        int len$ = arr$.length;
        if (i$ < len$) {
            String[] row = arr$[i$];
            if (row == null) {
                return cont;
            }
            for (String col : row) {
                if (col == null) {
                    return cont;
                }
                if (col.isEmpty()) {
                    return cont;
                }
                ++cont;
            }
        }
        return cont;
    }

    private static void readElementsFromExcel(DE_LocationExcel setLoc, int nMaxRows, int nMaxCols, List<String[]> lLabels) {
        assert (eWorkbook != null) : "Why are you calling this function without initializing excel connection. Always call initExcelConnection before this method";
        ExcelRangeAddress[] rangeV = setLoc.getVerticalRanges();
        ExcelRangeAddress[] rangeH = setLoc.getHorizontalRanges();
        ExcelRangeAddress[] rangeN = setLoc.getAllRanges("none");
        int nRangeV = 1;
        if (rangeV != null) {
            nRangeV = rangeV.length;
        }
        boolean isTable = rangeV != null && rangeH != null;
        boolean isVertical = rangeV != null && rangeH == null;
        boolean isHorizontal = rangeV == null && rangeH != null;
        String[][] dataN = null;
        if (rangeN != null) {
            dataN = ExcelUtil.readExcel2007Data(eWorkbook, rangeN[0].getRangeSheet(), rangeN[0].getInitRow(), rangeN[0].getInitColumn(), rangeN[0].getEndRow(), rangeN[0].getEndColumn());
            if (!dataN[0][0].isEmpty()) {
                String[] sLabel = new String[]{dataN[0][0]};
                lLabels.add(sLabel);
            }
            return;
        }
        String[][] dataH = null;
        if (rangeH != null) {
            assert (rangeH.length == 1) : "GAMS Tables support only one horizontal set! Why there are '" + rangeH.length + "' ranges??";
            dataH = ExcelUtil.readExcel2007Data(eWorkbook, rangeH[0].getRangeSheet(), rangeH[0].getInitRow(), rangeH[0].getInitColumn(), rangeH[0].getEndRow(), -1);
        }
        String[][] dataV = null;
        int nLastRow = nMaxRows;
        if (rangeV != null) {
            nLastRow = nMaxRows + rangeV[0].getInitRow();
            if (nMaxRows == -1) {
                for (ExcelRangeAddress r : rangeV) {
                    nLastRow = Math.max(nLastRow, PETmanager.findWhiteRowInExcel(r));
                }
            }
            dataV = new String[nRangeV][];
            for (int i = 0; i < nRangeV; ++i) {
                String[][] dataCol = ExcelUtil.readExcel2007Data(eWorkbook, rangeV[i].getRangeSheet(), rangeV[i].getInitRow(), rangeV[i].getInitColumn(), nLastRow, rangeV[i].getEndColumn(), false);
                int nElements = dataCol.length;
                dataV[i] = new String[nElements];
                for (int k = 0; k < nElements; ++k) {
                    dataV[i][k] = dataCol[k][0];
                }
            }
        }
        if (isHorizontal) {
            for (String s : dataH[0]) {
                if (s.isEmpty()) continue;
                String[] sLabel = new String[]{s};
                lLabels.add(sLabel);
            }
            return;
        }
        int minLength = dataV[0].length;
        int maxLength = 0;
        for (String[] data1 : dataV) {
            minLength = Math.min(data1.length, minLength);
            maxLength = Math.max(data1.length, maxLength);
        }
        for (int i = 0; i < minLength; ++i) {
            boolean hasBlank = false;
            for (int j = 0; j < nRangeV; ++j) {
                if (!dataV[j][i].isEmpty()) continue;
                hasBlank = true;
                break;
            }
            if (hasBlank) continue;
            if (isTable) {
                for (int k = 0; k < dataH[0].length; ++k) {
                    if (dataH[0][k].isEmpty()) continue;
                    String[] sLabel = new String[nRangeV + 1];
                    for (int j = 0; j < nRangeV; ++j) {
                        sLabel[j] = dataV[j][i];
                    }
                    sLabel[nRangeV] = dataH[0][k];
                    lLabels.add(sLabel);
                }
                continue;
            }
            String[] sLabel = new String[nRangeV];
            for (int j = 0; j < nRangeV; ++j) {
                sLabel[j] = dataV[j][i];
            }
            lLabels.add(sLabel);
        }
    }

    @Deprecated
    private static void readListFromExcel(DE_LocationExcel setElementLocation, List<String[]> lLabels) {
        assert (eWorkbook != null) : "Why are you calling this function without initializing excel connection. Always call initExcelConnection before this method";
        ArrayList<ExcelRangeAddress> rangeSet = new ArrayList<ExcelRangeAddress>(Arrays.asList(setElementLocation.getAllRanges()));
        String[][] data2 = new String[rangeSet.size()][];
        int contSet = 0;
        for (ExcelRangeAddress r : rangeSet) {
            int nElements;
            String[][] dataCol;
            String sOrientation = setElementLocation.getMissingDataOrientation(contSet);
            if (sOrientation.equalsIgnoreCase(PET_enums.DataOrientation.horizontal.name())) {
                dataCol = ExcelUtil.readExcel2007Data(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), r.getEndRow(), -1);
                nElements = dataCol[0].length;
                data2[contSet] = new String[nElements];
                System.arraycopy(dataCol[0], 0, data2[contSet], 0, nElements);
            } else if (sOrientation.equalsIgnoreCase(PET_enums.DataOrientation.vertical.name())) {
                dataCol = ExcelUtil.readExcel2007Data(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), -1, r.getEndColumn());
                nElements = dataCol.length;
                data2[contSet] = new String[nElements];
                for (int i = 0; i < nElements; ++i) {
                    data2[contSet][i] = dataCol[i][0];
                }
            } else if (sOrientation.equalsIgnoreCase(PET_enums.DataOrientation.none.name())) {
                dataCol = ExcelUtil.readExcel2007Data(eWorkbook, r.getRangeSheet(), r.getInitRow(), r.getInitColumn(), r.getEndRow(), r.getEndColumn());
                data2[contSet] = new String[1];
                data2[contSet][0] = dataCol[0][0];
            } else {
                assert (false) : "Why you used an unsupported orientation??";
                return;
            }
            ++contSet;
        }
        int minLength = data2[0].length;
        int maxLength = 0;
        for (String[] data1 : data2) {
            minLength = Math.min(data1.length, minLength);
            maxLength = Math.max(data1.length, maxLength);
        }
        for (int col = 0; col < minLength; ++col) {
            String[] sLabel = new String[contSet];
            boolean hasEmpty = true;
            for (int row = 0; row < data2.length; ++row) {
                if (data2[row][col].isEmpty()) {
                    sLabel[row] = data2[row][col];
                    hasEmpty = true;
                    break;
                }
                sLabel[row] = data2[row][col];
                hasEmpty = false;
            }
            if (hasEmpty) continue;
            lLabels.add(sLabel);
        }
    }

    private static int writeListToExcel(DE_LocationExcel elementLocation, List<Object[]> lElements) {
        assert (eWorkbook != null) : "Why are you calling this function without initializing excel connection. Always call initExcelConnection before this method";
        int nValuesWriten = 0;
        for (int index = 0; index < elementLocation.getNumRanges(); ++index) {
            ExcelRangeAddress r = elementLocation.getRange(index);
            String sOrientation = elementLocation.getMissingDataOrientation(index);
            PET_enums.DataOrientation orientation = PET_enums.DataOrientation.none;
            if (sOrientation != null) {
                orientation = PET_enums.DataOrientation.valueOf(sOrientation);
            }
            ArrayList<Object> lCol = new ArrayList<Object>();
            for (Object[] o : lElements) {
                lCol.add(o[index]);
            }
            nValuesWriten += PETmanager.writeListToExcel(lCol, r, orientation);
        }
        return nValuesWriten;
    }

    private static int writeListToExcel(List<Object> lElements, ExcelRangeAddress rangeFrom, PET_enums.DataOrientation orientation) {
        assert (eWorkbook != null) : "Why are you calling this function without initializing excel connection. Always call initExcelConnection before this method";
        String[][] data2 = null;
        int cont = 0;
        int nValues = lElements.size();
        switch (orientation) {
            case horizontal: {
                data2 = new String[1][nValues];
                for (Object o : lElements) {
                    data2[0][cont] = o.toString();
                    ++cont;
                }
                break;
            }
            case vertical: {
                data2 = new String[nValues][1];
                for (Object o : lElements) {
                    data2[cont][0] = o.toString();
                    ++cont;
                }
                break;
            }
            case none: {
                data2 = new String[nValues][nValues];
                for (Object o : lElements) {
                    data2[cont][cont] = o.toString();
                    ++cont;
                }
                break;
            }
        }
        return ExcelUtil.writeExcel2007Data(eWorkbook, rangeFrom.getRangeSheet(), rangeFrom.getInitRow(), rangeFrom.getInitColumn(), data2);
    }

    private static void setSETLocation(DE_Set set, String sExcelFile) {
        File fMap = new File(PETmanager.getDefaultPETMappingFile());
        String sHeaderLoc = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 3, fMap);
        String sFirstLoc = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 4, fMap);
        String sDataSource = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 5, fMap);
        String sOrientation = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 8, fMap);
        String sMandatory = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 10, fMap);
        String sInitialize = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 12, fMap);
        String sDefaultValue = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 11, fMap);
        String sDescription = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 2, fMap);
        String sDisplayName = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, 7, fMap);
        set.setDisplayName(sDisplayName);
        set.setDataSource(sDataSource);
        set.setDescription(sDescription);
        if (sOrientation == null) {
            sOrientation = PET_enums.DataOrientation.none.name();
        }
        if (sHeaderLoc != null && sFirstLoc != null) {
            set.setHeaderLocation(new DE_LocationExcel(sExcelFile, sHeaderLoc, sOrientation));
            set.setFirstValueLocation(new DE_LocationExcel(sExcelFile, sFirstLoc, sOrientation));
        }
        if (sMandatory != null) {
            set.setMandatory(Boolean.parseBoolean(sMandatory));
        }
        if (sInitialize != null) {
            set.setInitialize(Boolean.parseBoolean(sInitialize));
        }
        set.setDefault_value(sDefaultValue);
    }

    private static void setParameterLocation(DE_Parameter parameter, String sExcelFile) {
        File fMap = new File(PETmanager.getDefaultPETMappingFile());
        String sSetLoc = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 3, fMap);
        String sValLoc = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 4, fMap);
        String sDataSource = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 5, fMap);
        String sOrientation = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 8, fMap);
        String sValidationRule = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 9, fMap);
        String sMandatory = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 10, fMap);
        String sInitialize = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 12, fMap);
        String sDefaultValue = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 11, fMap);
        String sDisplayName = GMSi_solver.getDE_GAMSMappingValue(parameter.getSolverName(), true, 7, fMap);
        if (sMandatory != null) {
            parameter.setMandatory(Boolean.getBoolean(sMandatory));
        }
        if (sInitialize != null) {
            parameter.setInitialize(Boolean.getBoolean(sInitialize));
        }
        parameter.setDisplayName(sDisplayName);
        parameter.setDefault_value(sDefaultValue);
        parameter.setDataSource(sDataSource);
        parameter.setValidation_rule(sValidationRule);
        if (parameter.getTotalNumSet() == 0) {
            assert (sValLoc != null) : "Scalar '" + parameter.getSolverName() + "' must define value location!! There is an error in mapping file " + fMap.getName();
            if (sValLoc != null) {
                parameter.setValLocation(new DE_LocationExcel(sExcelFile, sValLoc, PET_enums.DataOrientation.none.name()));
            }
        } else if (sSetLoc != null && sValLoc == null && sOrientation != null) {
            parameter.setSetLocation(new DE_LocationExcel(sExcelFile, sSetLoc, sOrientation));
        } else if (sSetLoc != null && sValLoc != null && sOrientation == null) {
            parameter.setSetLocation(new DE_LocationExcel(sExcelFile, sSetLoc, sOrientation));
            parameter.setValLocation(new DE_LocationExcel(sExcelFile, sValLoc, PET_enums.DataOrientation.vertical.name()));
        }
    }

    public static boolean putPET_SET(DE_Set set) {
        int index = -1;
        for (int i = 0; i < lCase_SETs.size(); ++i) {
            if (set.getName() != null && set.getName().equalsIgnoreCase(lCase_SETs.get(i).getName())) {
                index = i;
                break;
            }
            if (set.getSolverName() == null || !set.getSolverName().equalsIgnoreCase(lCase_SETs.get(i).getSolverName())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return lCase_SETs.set(index, set) != null;
        }
        return lCase_SETs.add(set);
    }

    public static boolean putPET_PARAMETER(DE_Parameter parameter) {
        int index = -1;
        for (int i = 0; i < lCase_SETs.size(); ++i) {
            if (parameter.getName() != null && parameter.getName().equalsIgnoreCase(lCase_PARAMETERs.get(i).getName())) {
                index = i;
                break;
            }
            if (parameter.getSolverName() == null || !parameter.getSolverName().equalsIgnoreCase(lCase_PARAMETERs.get(i).getSolverName())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return lCase_PARAMETERs.set(index, parameter) != null;
        }
        return lCase_PARAMETERs.add(parameter);
    }

    private static void initExcelConnection(String filePath) throws InvalidFormatException, IOException {
        eWorkbook = ExcelUtil.openExcelConnection(filePath);
    }

    public static void writeCaseToOutputFile() throws IOException, DE_ValidationException {
        GMSi_solver gmss = new GMSi_solver();
        String sFile = Utils.getSystemFullPathChooser(DeepEdit.frame, "Choose Output File", 0, ".txt");
        if (sFile == null) {
            throw new PET_validationException("PET-file execution cancelled by user. No output file selected");
        }
        File f_gmsOutFile = new File(sFile);
        for (DE_Set set : lCase_SETs) {
            PET_validation.isValidPETSet((GMSi_Set)set);
        }
        gmss.writeSetToFile(f_gmsOutFile, lCase_SETs);
        DeepEdit.printlnToMessageTab("Finished writing SET values...");
        for (DE_Parameter parameter : lCase_PARAMETERs) {
            PET_validation.isValidPETParameter((GMSi_Parameter)parameter);
        }
        gmss.writeParameterToFile(f_gmsOutFile, lCase_PARAMETERs);
        DeepEdit.printlnToMessageTab("Finished writing PARAMETER values...");
        PrintStream ps = new PrintStream(new FileOutputStream(f_gmsOutFile, true));
        for (DE_Set set : lCase_SETs) {
            GMSi_Set gmsiset = (GMSi_Set)set;
            if (!gmsiset.isEmpty() || !gmsiset.isFundamental()) continue;
            ps.println(set.getSolverName() + "=no;");
        }
        for (DE_Parameter par : lCase_PARAMETERs) {
            if (!par.isEmpty()) continue;
            ps.println(par.getSolverName() + "=no;");
        }
        ps.close();
        DeepEdit.printlnToMessageTab("Finished writing PET-GAMS case file: " + sFile);
    }

    public static void openSETSource(DE_Set set) throws IOException {
        DE_LocationExcel loc = (DE_LocationExcel)set.getFirstValueLocation();
        if (loc != null) {
            String excelFile = loc.getSourcePath();
            String sheetName = loc.getExcelSheetName();
            ExcelUtil.openExcelFile(excelFile, sheetName);
        }
    }

    public static void openPARAMETERSource(DE_Parameter parameter) throws IOException {
        GMSi_Parameter gmsi_parameter = (GMSi_Parameter)parameter;
        DE_LocationExcel loc = gmsi_parameter.isTable() ? (DE_LocationExcel)parameter.getSetLocation() : (DE_LocationExcel)parameter.getSetLocation();
        if (loc != null) {
            String excelFile = loc.getSourcePath();
            String sheetName = loc.getExcelSheetName();
            ExcelUtil.openExcelFile(excelFile, sheetName);
        }
    }

    public static void moveDefaultExcelFile(String destinationFolder) throws IOException {
        String sFile = PETmanager.getDefaultPETExcelFile();
        File fSource = new File(sFile);
        String excelFileName = fSource.getName();
        File fPath = new File(destinationFolder);
        if (fPath.isDirectory()) {
            fPath = new File(destinationFolder + File.separator + excelFileName);
        }
        Utils.copyFile(fSource, fPath);
    }

    private static void writeGAMSConfigFile() throws IOException, InvalidFormatException {
        if (petCase == null) {
            return;
        }
        String sTextFile = DeepEdit.getOptionValue("DE-PET_GamsconfigName");
        String sRange = DeepEdit.getOptionValue("DE-PET_GamsconfigExcelLoc");
        ExcelRangeAddress range = new ExcelRangeAddress(sRange);
        String excelFile = PETmanager.getExcelSourceFile();
        String destFilePath = new File(excelFile).getParent();
        PETmanager.writeTxtFileFromExcelRange(excelFile, range, destFilePath + File.separator + sTextFile);
        DeepEdit.printlnToMessageTab("Finished writing PET-GAMS Configuration text file");
    }

    private static void writeREPORTConfigFile() throws IOException, InvalidFormatException {
        if (petCase == null) {
            return;
        }
        String sTextFile = DeepEdit.getOptionValue("DE-PET_ReportName");
        String sRange = DeepEdit.getOptionValue("DE-PET_ReportExcelLoc");
        ExcelRangeAddress range = new ExcelRangeAddress(sRange);
        String excelFile = PETmanager.getExcelSourceFile();
        String destFilePath = new File(excelFile).getParent();
        PETmanager.writeTxtFileFromExcelRange(excelFile, range, destFilePath + File.separator + sTextFile);
        DeepEdit.printlnToMessageTab("Finished writing PET-Report Configuration text file");
    }

    public static void writeTxtFileFromExcelRange(String excelFile, ExcelRangeAddress range, String destFile) throws InvalidFormatException, IOException {
        if (eWorkbook == null) {
            PETmanager.initExcelConnection(excelFile);
        }
        String[][] data2 = ExcelUtil.readExcel2007Data(eWorkbook, range.getRangeSheet(), range.getInitRow(), range.getInitColumn(), -1, range.getInitColumn());
        File file = new File(destFile);
        if (!file.exists()) {
            file.createNewFile();
        }
        PrintStream ps = new PrintStream(new FileOutputStream(file, false));
        if (data2 != null) {
            String[][] arr$ = data2;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String[] row;
                for (String s : row = arr$[i$]) {
                    ps.println(s);
                }
            }
        }
        ps.close();
    }

    public static String getPETModelFile() {
        if (petCase != null) {
            return petCase.getParameterValue("simconfigfile");
        }
        return PETmanager.getDefaultPETModelFile();
    }

    public static String getDefaultPETModelFile() {
        String sFile = DeepEdit.getOptionValue("DE-PET_modelfile");
        if (sFile != null) {
            File fFile = new File(sFile);
            return fFile.getAbsolutePath();
        }
        return "./config/DE_model.txt";
    }

    public static void setDefaultPETModelFile(String filePath) {
        DeepEdit.setOptionValue("DE-PET_modelfile", filePath);
    }

    public static String getDefaultPETMappingFile() {
        String sFile = DeepEdit.getOptionValue("DE-PET_mappingfile");
        if (sFile != null) {
            File fFile = new File(sFile);
            return fFile.getAbsolutePath();
        }
        return "./config/PET-DE_mapping.xml";
    }

    public static void setDefaultPETMappingFile(String filePath) {
        DeepEdit.setOptionValue("DE-PET_mappingfile", filePath);
    }

    public static String getDefaultPETExcelFile() {
        String sFile = DeepEdit.getOptionValue("DE-PET_excelfile");
        if (sFile != null) {
            File f = new File(sFile);
            return f.getAbsolutePath();
        }
        return "./config/PET_input.xlsm";
    }

    public static void setDefaultPETExcelFile(String filePath) {
        DeepEdit.setOptionValue("DE-PET_excelfile", filePath);
    }

    public static DE_Set[] createEmptySET(PET_enums.DataSource dataSource) throws IOException, DE_ValidationException {
        return PETmanager.createEmptySET(5, dataSource.name());
    }

    public static DE_Set[] createEmptyInitSET() throws IOException, DE_ValidationException {
        return PETmanager.createEmptySET(12, Boolean.toString(true));
    }

    private static DE_Set[] createEmptySET(int info, String infoValue) throws IOException, DE_ValidationException {
        File f_gmsMapFile = new File(PETmanager.getDefaultPETMappingFile());
        LinkedList<DE_Set> lFullSets = new LinkedList<DE_Set>();
        LinkedList<DE_Set> retSets = new LinkedList<DE_Set>();
        PETmanager.updateSETsFromModel(lFullSets);
        for (DE_Set set : lFullSets) {
            String sInfo = GMSi_solver.getDE_GAMSMappingValue(set.getSolverName(), true, info, f_gmsMapFile);
            if (!infoValue.equalsIgnoreCase(sInfo)) continue;
            PETmanager.setSETLocation(set, PETmanager.getExcelSourceFile());
            retSets.add(set);
        }
        return retSets.toArray(new DE_Set[retSets.size()]);
    }

    private static GMSi_Set createSchFundamentalSET(String de_name) {
        File f_gmsMapFile = new File(PETmanager.getDefaultPETMappingFile());
        GMSi_solver gmss = new GMSi_solver();
        GMSi_Set DEset = (GMSi_Set)gmss.createDefaultSet(de_name);
        if (DEset != null) {
            String solverSETName = GMSi_solver.getSolverSETName(de_name, f_gmsMapFile);
            String sDataSource = GMSi_solver.getDE_GAMSMappingValue(solverSETName, true, 5, f_gmsMapFile);
            String description = GMSi_solver.getDE_GAMSMappingValue(solverSETName, true, 2, f_gmsMapFile);
            DEset.setSolverName(solverSETName);
            DEset.setDescription(description);
            DEset.setDataSource(sDataSource);
            PETmanager.setSETLocation(DEset, PETmanager.getExcelSourceFile());
            boolean includeHdb_IrrGenerator = DeepEdit.getBooleanOptionValue("DE-PET_includeirr");
            boolean includeGroundedGenerator = DeepEdit.getBooleanOptionValue("DE-PET_includegrounded");
            if ("Generator".equalsIgnoreCase(DEset.getName())) {
                PETmanager.add_hdb_units(DEset, includeHdb_IrrGenerator, includeGroundedGenerator);
            }
        }
        return DEset;
    }

    private static GMSi_Set createSchMultidimSET(String de_name, List<DE_Set> lfundamentalSETs) {
        GMSi_Set DEset;
        File f_gmsMapFile = new File(PETmanager.getDefaultPETMappingFile());
        try {
            GMSi_solver gmss = new GMSi_solver();
            DEset = (GMSi_Set)gmss.createDefaultMultidimSet(de_name, lfundamentalSETs);
        }
        catch (DE_ValidationException e) {
            assert (false) : "Schematic sets should always be valid! " + e.getLocalizedMessage();
            return null;
        }
        if (DEset != null) {
            String solverSETName = GMSi_solver.getSolverSETName(de_name, f_gmsMapFile);
            String sDataSource = GMSi_solver.getDE_GAMSMappingValue(solverSETName, true, 5, f_gmsMapFile);
            String description = GMSi_solver.getDE_GAMSMappingValue(solverSETName, true, 2, f_gmsMapFile);
            DEset.setSolverName(solverSETName);
            DEset.setDescription(description);
            DEset.setDataSource(sDataSource);
            PETmanager.setSETLocation(DEset, PETmanager.getExcelSourceFile());
        }
        return DEset;
    }

    private static void reset() {
        lCase_SETs.clear();
        lCase_PARAMETERs.clear();
        eWorkbook = null;
    }

    private static List<Object> createUniqueNameList(List<Object> oList) {
        ArrayList<Object> uniqueList = new ArrayList<Object>();
        for (Object o : oList) {
            if (uniqueList.contains(o.toString())) continue;
            uniqueList.add(o.toString());
        }
        return uniqueList;
    }

    public static String getExcelSourceFile() {
        if (petCase != null) {
            return petCase.getParameterValue(DE_ClassEnums.Simulation.simsourcefile.name());
        }
        return PETmanager.getDefaultPETExcelFile();
    }

    private static void add_hdb_units(GMSi_Set set, boolean includeGrounded, boolean includeIrr) {
        try {
            for (comp c : DeepEdit.getComponents("hdb_paspur")) {
                if (!includeGrounded && !((hdb_unit)c).getgrounded()) continue;
                set.setValue(c);
            }
            for (comp c : DeepEdit.getComponents("hdb_ser")) {
                if (!includeGrounded && !((hdb_unit)c).getgrounded()) continue;
                set.setValue(c);
            }
            for (comp c : DeepEdit.getComponents("hdb_res")) {
                if (set.contains(c)) continue;
                set.setValue(c);
            }
            if (includeIrr) {
                for (comp c : DeepEdit.getComponents("hdb_irr")) {
                    if (set.contains(c)) continue;
                    set.add((Object)((hdb_unit)c));
                }
            }
        }
        catch (DE_ValidationException e) {
            assert (false) : "Schematic sets should always be valid! " + e.getLocalizedMessage();
            e.printStackTrace(System.err);
        }
    }

    public static boolean getPETCase(List<DE_Set> sets, List<DE_Parameter> parameters) {
        boolean addAll = true;
        addAll &= sets.addAll(lCase_SETs);
        return addAll &= parameters.addAll(lCase_PARAMETERs);
    }

    public static DE_Set getSETByName(String setName, boolean useDEName) {
        return DE_Set.findSetNameInList(setName, lCase_SETs, useDEName);
    }

    public static DE_Parameter getPARAMETERByName(String parameterName, boolean useDEName) {
        return DE_Parameter.findPARAMETERNameInList(parameterName, lCase_PARAMETERs, useDEName);
    }

    public static Simulation getPETCase() {
        return petCase;
    }

    public static void setPETCase(Simulation petCase) {
        PETmanager.petCase = petCase;
    }

    public static void setCurrentAction(PET_enums.Actions newAction) {
        action = newAction;
    }

    public static PET_enums.Actions getCurrentAction() {
        return action;
    }

    private static int getMaximumSETSize(GMSi_Set set) {
        if (set.isFundamental() || set instanceof GMSi_Subset) {
            return set.getMaximumSize();
        }
        DE_LocationExcel loc = (DE_LocationExcel)set.getFirstValueLocation();
        if (loc != null && loc.getRange().getRangeSheet() != null) {
            GMSi_Set busbarSet;
            GMSi_Set lineSet;
            GMSi_Set setGen;
            if ("Generadores".equalsIgnoreCase(loc.getRange().getRangeSheet()) && (setGen = set.getParent("Generator", true)) != null) {
                return setGen.getMaximumSize();
            }
            if ("Lineas".equalsIgnoreCase(loc.getRange().getRangeSheet()) && (lineSet = set.getParent("Line", true)) != null) {
                return lineSet.getMaximumSize();
            }
            if ("Barras".equalsIgnoreCase(loc.getRange().getRangeSheet()) && (busbarSet = set.getParent("Busbar", true)) != null) {
                return busbarSet.getMaximumSize();
            }
        }
        return set.getMaximumSize();
    }

    @Override
    public void run() {
        try {
            PETmanager.setEnv();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        catch (PET_validationException e) {
            e.printStackTrace(System.out);
        }
        catch (DE_ValidationException e) {
            e.printStackTrace(System.out);
        }
    }

    static {
        lCase_SETs = new LinkedList<DE_Set>();
        lCase_PARAMETERs = new LinkedList<DE_Parameter>();
    }
}

