/*
 * Decompiled with CFR 0.152.
 */
package de.edil.pet;

import de.core.AnalysisTool;
import de.core.Constraint;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Schematic;
import de.core.Simulation;
import de.core.comp;
import de.core.hdb_unit;
import de.data.DE_ClassEnums;
import de.data.DE_GeneralEnums;
import de.data.DE_ValidationException;
import de.data.ExcelRangeAddress;
import de.edil.DE_LocationExcel;
import de.edil.pet.PET_enums;
import de.edil.pet.PET_validationException;
import de.edil.pet.PETmanager;
import de.solver.DE_Parameter;
import de.solver.DE_Set;
import de.solver.gmsi.GMSi_Parameter;
import de.solver.gmsi.GMSi_Set;
import de.utils.Utils;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JOptionPane;

public class PET_validation {
    public static boolean shouldUpdateHeaders(DE_Set set) {
        boolean bUpdate = DeepEdit.getBooleanOptionValue("DE-PET_updateheader");
        return bUpdate;
    }

    public static boolean shouldUpdateHeaders(DE_Parameter parameter) {
        String parameterName = parameter.getName();
        if ("Generator_PET".equalsIgnoreCase(parameterName)) {
            return false;
        }
        if ("Line_PET".equalsIgnoreCase(parameterName)) {
            return false;
        }
        return ((GMSi_Parameter)parameter).isTable();
    }

    public static boolean shouldUpdateElements(DE_Set set) {
        return !PET_enums.DataSource.EXCEL.name().equalsIgnoreCase(set.getDataSource());
    }

    public static boolean shouldUpdateElements(DE_Parameter parameter) {
        if ("hdb_res::avfiltf".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("hdb_res::constfiltf".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("hdb_res::avwaterflowf".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("hdb_res::constwaterflowf".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("hdb_res::Vfin".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator_PET".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::pmax".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::fuelprice".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::nonfuelprice".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::heatrate".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::forcedoutagerate".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::auxservice".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::cost".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::fixcost".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::economiclife".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::pmin".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::co2rate".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::noxrate".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Generator::so2rate".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("hdb_res::Vmax".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("hdb_res::Vmin".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("hdb_res::Vini".equalsIgnoreCase(parameter.getName())) {
            return false;
        }
        if ("Line_PET::r1_pu".equalsIgnoreCase(parameter.getName())) {
            return true;
        }
        if (parameter.getName().contains("Line_PET::")) {
            return false;
        }
        return !PET_enums.DataSource.EXCEL.name().equalsIgnoreCase(parameter.getDataSource());
    }

    public static boolean shouldUpdateValues(DE_Parameter parameter) {
        String parameterName = parameter.getName();
        if ("FCF".equalsIgnoreCase(parameterName)) {
            return true;
        }
        if ("FCF::rhs".equalsIgnoreCase(parameterName)) {
            return true;
        }
        if ("System::co2price".equalsIgnoreCase(parameterName)) {
            return true;
        }
        return !PET_enums.DataSource.EXCEL.name().equalsIgnoreCase(parameter.getDataSource());
    }

    public static boolean shouldPrintToExcel(DE_Set set) {
        if ("Generator".equalsIgnoreCase(set.getName())) {
            return true;
        }
        if ("Line".equalsIgnoreCase(set.getName())) {
            return false;
        }
        if (PET_enums.DataSource.Model.name().equalsIgnoreCase(set.getDataSource())) {
            return true;
        }
        return !PET_enums.DataSource.EXCEL.name().equalsIgnoreCase(set.getDataSource());
    }

    public static boolean shouldPrintToExcel(DE_Parameter parameter) {
        return true;
    }

    public static boolean shouldUpdateFromExcel(DE_Set set) {
        return PET_enums.DataSource.EXCEL.name().equalsIgnoreCase(set.getDataSource()) || PET_enums.DataSource.GUI.name().equalsIgnoreCase(set.getDataSource());
    }

    public static boolean shouldUpdateFromExcel(DE_Parameter parameter) {
        if (PET_enums.Actions.updateSchematicFromExcel == PETmanager.getCurrentAction()) {
            return PET_enums.DataSource.Schematic.name().equalsIgnoreCase(parameter.getDataSource());
        }
        return PET_enums.DataSource.EXCEL.name().equalsIgnoreCase(parameter.getDataSource());
    }

    public static boolean isValidPETSchematic(Schematic sch) throws DE_ValidationException {
        if (!AnalysisTool.isSchematicValid(sch)) {
            throw new DE_ValidationException("PET cases shouldn't be created/updated from invalid schematics\nContinuing execution may lead to errors. Check for connection problems:\nUse 'Print Connection Warnings' to print schematic detailed errors\nSelect View->View Connection menu to display connection visualization");
        }
        Collection<comp> Generators = sch.getComponents(Generator.class);
        for (comp c : sch.getComponents(hdb_unit.class)) {
            if (!((hdb_unit)c).getgrounded() || !Utils.containsName(c.getName(), Generators, true)) continue;
            throw new DE_ValidationException("Hydro unit '" + c.getName() + "' will create duplicate names! If this unit is related to an electrical generator, make sure to select the correspondant electrical generator from the list or make the attribute grounded = true");
        }
        ArrayList<comp> cloneGenerators = new ArrayList<comp>(Generators);
        for (int i = cloneGenerators.size() - 1; i >= 0; --i) {
            comp c = cloneGenerators.remove(i);
            if (c == null || !Utils.containsName(c.getName(), cloneGenerators, true)) continue;
            throw new DE_ValidationException("Generator '" + c.getName() + "' will create duplicate names! Duplicated names in any Generator or its children Wind, solar, CHP, etc is not currently supported. Use the search 'ctr+f' button to search for Generators with the same name");
        }
        return true;
    }

    public static boolean isValidPETSet(GMSi_Set set) throws DE_ValidationException {
        DE_LocationExcel valLoc = (DE_LocationExcel)set.getFirstValueLocation();
        if (set.isMandatory() && set.isEmpty()) {
            throw new PET_validationException("SET '" + set.getDisplayName() + "' is mandatory!. Values are required in source", valLoc.getRange(), valLoc.getSourcePath());
        }
        if (set.isFundamental() && set.isEmpty()) {
            set.setValue(set.getDefault_value());
        }
        PET_validation.checkSpecialPETSubsets(set, "Simulation::initialperiod", "periods");
        PET_validation.checkSpecialPETSubsets(set, "Simulation::initialldc", "ldcs");
        PET_validation.checkSpecialPETSubsets(set, "Simulation::endperiod", "periods");
        PET_validation.checkSpecialPETSubsets(set, "Simulation::endldc", "ldcs");
        return true;
    }

    private static boolean checkSpecialPETSubsets(GMSi_Set subset, String name, String parentName) throws PET_validationException {
        if (name.equalsIgnoreCase(subset.getName())) {
            DE_LocationExcel valLoc = (DE_LocationExcel)subset.getFirstValueLocation();
            assert (subset.size() == 1) : "Why set " + subset.getDisplayName() + " doesnt have exactly 1 value but " + subset.size() + " instead??";
            Object o = subset.get(0);
            DE_Set parentSet = PETmanager.getSETByName(parentName, true);
            if (!parentSet.contains(o)) {
                throw new PET_validationException("Value for set '" + subset.getDisplayName() + "' must strictly belong to parent SET '" + parentSet.getDisplayName() + "'. Fix values in source", valLoc.getRange(), valLoc.getSourcePath());
            }
        }
        return true;
    }

    public static boolean isValidPETSetEntry(Object[] oElement, DE_Set set, ExcelRangeAddress range) throws PET_validationException {
        assert (oElement != null) : "Why are you validating a null element entry??";
        if ("Simulation::initialperiod".equalsIgnoreCase(set.getName()) || "Simulation::endperiod".equalsIgnoreCase(set.getName())) {
            GMSi_Set parent = (GMSi_Set)PETmanager.getSETByName("periods", true);
            DE_LocationExcel excelValLocation = (DE_LocationExcel)set.getFirstValueLocation();
            if (parent != null && !parent.contains(oElement)) {
                throw new PET_validationException("Invalid SET entry '" + oElement[0] + "'. Values for '" + set.getDisplayName() + "' must strictly belong to parent SET '" + parent.getDisplayName() + "'", excelValLocation.getRange(), set.getFirstValueLocation().getSourcePath());
            }
        } else if ("Simulation::initialldc".equalsIgnoreCase(set.getName()) || "Simulation::endldc".equalsIgnoreCase(set.getName())) {
            GMSi_Set parent = (GMSi_Set)PETmanager.getSETByName("ldcs", true);
            DE_LocationExcel excelValLocation = (DE_LocationExcel)set.getFirstValueLocation();
            if (parent != null && !parent.contains(oElement)) {
                throw new PET_validationException("Invalid SET entry '" + oElement[0] + "'. Values for '" + set.getDisplayName() + "' must strictly belong to parent SET '" + parent.getDisplayName() + "'", excelValLocation.getRange(), set.getFirstValueLocation().getSourcePath());
            }
        }
        return true;
    }

    public static boolean isValidPETParameterEntry(Object[] oElement, String sValue, GMSi_Parameter parameter, ExcelRangeAddress range) throws PET_validationException {
        DE_LocationExcel setLoc = (DE_LocationExcel)parameter.getSetLocation();
        DE_LocationExcel setVal = (DE_LocationExcel)parameter.getValLocation();
        assert (oElement != null) : "Why are you validating a null element entry??";
        assert (sValue != null) : "Why are you validating a null value entry??";
        assert (oElement.length == parameter.getTotalNumSet()) : "Invalid number of arguments " + oElement.length + " in Parameter row " + range.getInitRow() + " in source input  + " + range.getRangeAddress() + ". Set identifiers should be " + parameter.getTotalNumSet() + ". Check mapping file for correct location of Parameter " + parameter.getName();
        assert (range != null) : "This validation relies on valid Excel range in order to throw the location in exception";
        for (Object o : oElement) {
            if (o == null) {
                throw new PET_validationException("Invalid SET identifier in Parameter row " + range.getInitRow() + " in source input  + " + range.getRangeAddress() + ". Set identifiers should never be 'null'. \nCheck mapping file for correct location of Parameter " + parameter.getDisplayName(), range);
            }
            if (!o.toString().isEmpty()) continue;
            throw new PET_validationException("Invalid SET identifier in Parameter row " + range.getInitRow() + " in source input  + " + range.getRangeAddress() + ". Set identifiers should never be 'empty' Strings. \nCheck mapping file for correct location of Parameter " + parameter.getDisplayName(), range);
        }
        try {
            parameter.isValidRecord(oElement);
        }
        catch (DE_ValidationException e) {
            throw new PET_validationException(e.getLocalizedMessage(), range, parameter.getValLocation().getSourcePath());
        }
        try {
            Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new PET_validationException("Value '" + sValue + "' couldn't be parsed to double. Only numerical values are accepted for Parameter '" + parameter.getDisplayName() + "'", range, parameter.getValLocation().getSourcePath());
        }
        return true;
    }

    public static boolean isValidPETParameter(GMSi_Parameter parameter) throws PET_validationException {
        DE_LocationExcel valLoc = (DE_LocationExcel)parameter.getValLocation();
        if (parameter.isMandatory() && parameter.isEmpty()) {
            throw new PET_validationException("Parameter '" + parameter.getDisplayName() + "' is mandatory!. Values are required in source", valLoc.getRange(), valLoc.getSourcePath());
        }
        double dTolPrb = DeepEdit.getDoubleOptionValue("DE-PET_Tolerance_prB");
        if ("Pr(h)".equalsIgnoreCase(parameter.getSolverName())) {
            double dPtotal = 0.0;
            for (Object o : parameter.values()) {
                double dValue = (Double)o;
                dPtotal += dValue;
            }
            if (dPtotal < 1.0 - dTolPrb || dPtotal > 1.0 + dTolPrb) {
                throw new PET_validationException("Warning: Probabilities in parameter '" + parameter.getDisplayName() + "' don't add up unity. sum(Pr)=" + dPtotal + ". Fix '" + parameter.getDisplayName() + "' values and execute again");
            }
            int nRequired = parameter.getSet("totalhydro").size();
            if (parameter.size() != nRequired) {
                throw new PET_validationException("Probabilities in parameter '" + parameter.getDisplayName() + "' should be defined for all hydro values. Entries found: " + parameter.size() + ". Required: " + nRequired + ". Fix '" + parameter.getDisplayName() + "' values and execute again");
            }
        }
        if ("PET_MPConjG".equalsIgnoreCase(parameter.getName())) {
            PET_validation.isValidConstraintParameter(parameter);
        } else if ("PET_MPPrecG".equalsIgnoreCase(parameter.getName())) {
            PET_validation.isValidConstraintParameter(parameter);
        } else if ("PET_MPPrecT".equalsIgnoreCase(parameter.getName())) {
            PET_validation.isValidConstraintParameter(parameter);
        } else if ("PET_MPConjT".equalsIgnoreCase(parameter.getName())) {
            PET_validation.isValidConstraintParameter(parameter);
        } else if ("PET_MPCamET".equalsIgnoreCase(parameter.getName())) {
            PET_validation.isValidConstraintParameter(parameter);
        } else if ("PET_MPCamNT".equalsIgnoreCase(parameter.getName())) {
            PET_validation.isValidConstraintParameter(parameter);
        }
        return true;
    }

    private static boolean isValidConstraintParameter(GMSi_Parameter parameter) throws PET_validationException {
        LinkedHashSet<Constraint> lConstraint = new LinkedHashSet<Constraint>();
        int nCPos = parameter.getTotalNumSet() - 1;
        for (Object o : parameter.keySet()) {
            Object[] oSet = ((List)o).toArray();
            if (oSet[nCPos] instanceof Constraint) {
                lConstraint.add((Constraint)oSet[nCPos]);
                continue;
            }
            assert (false) : "Why contraint is not the last set identifier in parameter " + parameter.getDisplayName() + "??";
        }
        double dTol = DeepEdit.getDoubleOptionValue("DE-PET_Tolerance_prB");
        for (Constraint c : lConstraint) {
            assert (c != null) : "How this null got here??? " + parameter.getName();
            boolean hasNegUnity = false;
            boolean hasPosUnity = false;
            for (double dValue : c.getAllCoefficientValues()) {
                if (1.0 - dTol < dValue && dValue < 1.0 + dTol) {
                    hasPosUnity = true;
                    continue;
                }
                if (!(-1.0 - dTol < dValue) || !(-dValue < 1.0 + dTol)) continue;
                hasNegUnity = true;
            }
            if (!hasNegUnity) {
                throw new PET_validationException("Warning: Parameter '" + parameter.getDisplayName() + "' should have at least a '-1' coefficient to indicate precendent project(s)");
            }
            if (hasPosUnity) continue;
            throw new PET_validationException("Warning: Parameter '" + parameter.getDisplayName() + "' should have at least a '+1' coefficient to indicate replacement project(s)");
        }
        return true;
    }

    public static boolean shouldContinueToSaveCase(Component parent) {
        int yesno;
        boolean checkSchematic = DeepEdit.getBooleanOptionValue("DE-PET_validate_sch");
        Simulation sim_pet = PETmanager.getPETCase();
        Simulation sim_active = DeepEdit.getActiveSimulation();
        Schematic sch = DeepEdit.getActiveSchematic();
        if (sch == null) {
            JOptionPane.showMessageDialog(parent, "No active PET-case found. \nOpen a case from File->PET Manager->Open menu menu", "Open case not found", 0);
            return false;
        }
        if (sim_pet == null) {
            JOptionPane.showMessageDialog(parent, "No active PET-case found. \nOpen a case from File->PET Manager->Open menu menu", "Open case not found", 0);
            return false;
        }
        if (sim_active == null) {
            List<comp> lComp = DeepEdit.getComponents("Simulation");
            if (lComp.size() > 0) {
                int yesno2 = JOptionPane.showConfirmDialog(parent, "No active PET-case SImulation found\nDo you wish to activate a Simulation case and attempt to continue?\nClick 'yes' to continue. 'No' to exit PET manager", "No active Simulation found", 1, 2);
                if (yesno2 != 0) {
                    return false;
                }
                sim_active = (Simulation)lComp.get(0);
                DeepEdit.setActiveSimulation(sim_active);
            } else {
                JOptionPane.showMessageDialog(parent, "No active PET-case found. \nOpen a case from File->PET Manager->Open menu menu", "Open case not found", 0);
                return false;
            }
        }
        if (!DE_GeneralEnums.DispatchSoftware.PET.name().equalsIgnoreCase(sim_active.getParameterValue(DE_ClassEnums.Simulation.type.name()))) {
            JOptionPane.showMessageDialog(parent, "No active PET-type simulation enabled \nActivate a Simulation object (setenable=true) or Open valid PET-case from File->PET Manager->Open menu", "Open case not found", 0);
            return false;
        }
        if (!sim_pet.equals(sim_active)) {
            JOptionPane.showMessageDialog(parent, "No active PET-case found. \nLast PET-case opened and current active simulation don't match. \nOpen valid PET-case from File->PET Manager->Open menu", "Open case not found", 0);
            return false;
        }
        return !checkSchematic || AnalysisTool.isSchematicValid(sch) || (yesno = JOptionPane.showConfirmDialog(parent, "PET cases shouldn't be saved from invalid schematics\nYou can still save currrent schematic to file using File->Save menu option \nAre you sure you want to continue?\nHint: Use 'Print Connection Warnings' to print schematic detailed errors\nClick 'yes' to continue. 'No' to exit PET manager", "Invalid Schematic detected", 1, 2)) == 0;
    }

    public static boolean shouldContinueToNewCase(boolean checkSchematic) throws DE_ValidationException {
        return true;
    }

    public static boolean shouldContinueToOpenCase() throws DE_ValidationException {
        return true;
    }

    public static boolean shouldContinueToExecute() throws DE_ValidationException {
        Schematic sch = DeepEdit.getActiveSchematic();
        Simulation sim_pet = PETmanager.getPETCase();
        if (!PET_validation.isValidPETSchematic(sch)) {
            throw new DE_ValidationException("PET cases shouldn't be saved from invalid schematics\nYou can still save currrent schematic to file using File->Save menu option \nHint: Use 'Print Connection Warnings' to print schematic detailed errors\n");
        }
        if (sim_pet == null) {
            throw new DE_ValidationException("No active Simulation object found! \nEnable at least 1 PET Simulation object or \nCreate a PET Simulation object by creating a new case or opening an existent in menu File->PET Manager");
        }
        if (!DE_GeneralEnums.DispatchSoftware.PET.name().equalsIgnoreCase(sim_pet.getParameterValue(DE_ClassEnums.Simulation.type.name()))) {
            throw new DE_ValidationException("No active Simulation object found! \nCreate a PET Simulation object by creating a new case or opening an existent in menu File->PET Manager");
        }
        return true;
    }

    public static boolean hasReferenceColumn(GMSi_Set set) {
        if (set.isFundamental()) {
            return false;
        }
        DE_LocationExcel loc = (DE_LocationExcel)set.getFirstValueLocation();
        if (set.getDimension() + 1 == loc.getNumRanges()) {
            return true;
        }
        return "Generator::con2".equalsIgnoreCase(set.getName());
    }

    public static boolean isValidMappingFile(File PETmappingFile) throws DE_ValidationException {
        return true;
    }
}

