/*
 * Decompiled with CFR 0.152.
 */
package de.edil.pet;

import de.core.DeepEdit;
import de.core.Simulation;
import de.edil.pet.PET_enums;
import de.edil.pet.PETmanager;
import de.solver.DE_Parameter;
import de.solver.DE_Set;
import de.solver.DE_solverVisual;
import de.solver.DefaultParameterVisualFrame;
import de.solver.gmsi.GMSi_Parameter;
import de.solver.gmsi.GMSi_Set;
import de.solver.gmsi.GmsiSETVisualFrame;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class PETVisualDisplay
extends DE_solverVisual {
    private boolean editable = false;
    private PET_enums.DataSource source;
    private List<GMSi_Set> sets;
    private List<GMSi_Parameter> parameters;

    public PETVisualDisplay(Window parent, boolean modal) {
        super(parent, modal);
        this.initPETComponents(null);
    }

    public PETVisualDisplay(Window parent, boolean modal, PET_enums.DataSource source) {
        super(parent, modal);
        this.source = source;
        this.initPETComponents(source);
    }

    public PETVisualDisplay(Window parent, boolean modal, Collection<GMSi_Set> sets, Collection<GMSi_Parameter> parameters) {
        super(parent, modal);
        this.sets = new ArrayList<GMSi_Set>(sets);
        this.parameters = new ArrayList<GMSi_Parameter>(parameters);
        for (GMSi_Set set : sets) {
            this.addSET(set);
        }
        for (GMSi_Parameter parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    private void initPETComponents() {
        if (this.source != null) {
            this.initPETComponents(this.source);
        } else {
            for (GMSi_Set set : this.sets) {
                this.addSET(set);
            }
            for (GMSi_Parameter parameter : this.parameters) {
                this.addParameter(parameter);
            }
        }
    }

    private void initPETComponents(PET_enums.DataSource source) {
        Simulation sim = PETmanager.getPETCase();
        if (sim != null) {
            ArrayList<DE_Set> lSet = new ArrayList<DE_Set>();
            ArrayList<DE_Parameter> lParameter = new ArrayList<DE_Parameter>();
            PETmanager.getPETCase(lSet, lParameter);
            for (DE_Set set : lSet) {
                if (source == null) {
                    this.addSET(set);
                    continue;
                }
                if (!source.name().equalsIgnoreCase(set.getDataSource())) continue;
                this.addSET(set);
            }
            for (DE_Parameter parameter : lParameter) {
                if (source == null) {
                    this.addParameter(parameter);
                    continue;
                }
                if (!source.name().equalsIgnoreCase(parameter.getDataSource())) continue;
                this.addParameter(parameter);
            }
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.sets != null) {
            this.sets.clear();
        }
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    public void refresh() {
        this.clear();
        this.initPETComponents();
    }

    @Override
    public void displayContent(int nRow) {
    }

    @Override
    public void displayContent(Object o) {
        assert (o != null) : "Why did you stored a null object in Solver's table??";
        if (o instanceof DE_Set) {
            DE_Set set = (DE_Set)o;
            GmsiSETVisualFrame setFrame = new GmsiSETVisualFrame((Dialog)this, (GMSi_Set)set, this.editable);
            setFrame.setLocationRelativeTo(this);
            setFrame.setVisible(true);
        } else if (o instanceof DE_Parameter) {
            DE_Parameter parameter = (DE_Parameter)o;
            DefaultParameterVisualFrame parameterFrame = new DefaultParameterVisualFrame((Window)this, parameter, this.editable);
            parameterFrame.pack();
            parameterFrame.setLocationRelativeTo(this);
            parameterFrame.setVisible(true);
        } else assert (false) : "Why unsupported object " + o + " was added to this window??? Class type: " + o.getClass().getName();
    }

    @Override
    public void displaySource(Object o) {
        if (o instanceof DE_Set) {
            DE_Set set = (DE_Set)o;
            try {
                PETmanager.openSETSource(set);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error opening source file for SET '" + set.getName() + "'.\n" + e.getLocalizedMessage(), "Error opening SET source file", 0);
                e.printStackTrace(System.err);
            }
        } else if (o instanceof DE_Parameter) {
            DE_Parameter parameter = (DE_Parameter)o;
            try {
                PETmanager.openPARAMETERSource(parameter);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error opening source file for PARAMETER '" + parameter.getName() + "'.\n" + e.getLocalizedMessage(), "Error opening PARAMETER source file", 0);
                e.printStackTrace(System.err);
            }
        } else assert (false) : "Why unsupported object " + o + " was added to this window??? Class type: " + o.getClass().getName();
    }

    public static Container getSolverContent(boolean editable) {
        PETVisualDisplay par_w = new PETVisualDisplay((Window)DeepEdit.frame, false);
        return par_w.getContentPane();
    }

    public static JTable getSolverTable(boolean editable) {
        PETVisualDisplay solver_w = new PETVisualDisplay((Window)DeepEdit.frame, false);
        return solver_w.getContentTable();
    }
}

