/*
 * Decompiled with CFR 0.152.
 */
package de.edil.pet;

import de.core.AbstractDeepEditWizard;
import de.core.Constraint;
import de.core.DeepEdit;
import de.core.Simulation;
import de.data.DE_GeneralEnums;
import de.data.DE_ValidationException;
import de.edil.pet.PETNew_Step0;
import de.edil.pet.PETNew_Step1;
import de.edil.pet.PETNew_Step2;
import de.edil.pet.PETNew_Step3;
import de.edil.pet.PETNew_Step4;
import de.edil.pet.PET_validationException;
import de.edil.pet.PETmanager;
import de.solver.DE_Set;
import de.solver.gmsi.GMSi_Parameter;
import de.solver.gmsi.GMSi_Set;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class PETNew_Wizard
extends AbstractDeepEditWizard {
    private final List<Constraint> lTempConstraints = new ArrayList<Constraint>();
    private Simulation tempSim;
    private Map<String, GMSi_Set> mTempSETs;
    private Map<String, GMSi_Parameter> mTempPARAMETERs;
    private PETNew_Step0 pnlNew;
    private PETNew_Step1 pnlCase;
    private PETNew_Step2 pnlSim;
    private PETNew_Step3 pnlConstraint;

    public PETNew_Wizard(Window parent) {
        super(parent, "Create PET Case Wizard");
        this.initComponents();
    }

    private void initComponents() {
        this.pnlNew = new PETNew_Step0(this);
        this.pnlCase = new PETNew_Step1(this);
        this.pnlSim = new PETNew_Step2(this);
        this.pnlConstraint = new PETNew_Step3(this);
        PETNew_Step4 pnlAdvanced = new PETNew_Step4(this);
        JPanel pnlFinish = new JPanel();
        pnlFinish.add(new JLabel("Ready to create a new PET case"));
        this.addTask("New Case", this.pnlNew, "New Case Options", "Create new case from existent value?");
        this.addTask("Case Info", this.pnlCase, "New Case Information", "Simulation fundamental information");
        this.addTask("Simulation", this.pnlSim, "Simulation Configuration", "Simulation advanced information: Horizon, hydro samples, LDC definition...");
        this.addTask("Constraint", this.pnlConstraint, "PET Constraints", "GUI for defining all constraints (including FCF) to be added to this PET-type simulation \nNote: Generic category constraint are not added to PET case");
        this.addTask("Advanced", pnlAdvanced, "Advanced GUI SET/PARAMETER Configuration", "Click on SETs or PARAMETERS to edit values. \nUse mapping file to define more sets/parameter to initialize by GUI");
        this.addTask("Finalize", pnlFinish, "Create case", null);
    }

    public void initGUI_SET() {
        if (this.mTempSETs == null) {
            this.mTempSETs = new LinkedHashMap<String, GMSi_Set>();
        } else {
            this.mTempSETs.clear();
        }
        if (this.mTempPARAMETERs == null) {
            this.mTempPARAMETERs = new LinkedHashMap<String, GMSi_Parameter>();
        } else {
            this.mTempSETs.clear();
        }
        try {
            DE_Set[] iniSETs;
            for (DE_Set set : iniSETs = PETmanager.createEmptyInitSET()) {
                this.mTempSETs.put(set.getName(), (GMSi_Set)set);
            }
            String sExcelFile = this.getReferenceExcelSourceFile();
            File f_excel = new File(sExcelFile);
            if (f_excel.exists() && !sExcelFile.isEmpty()) {
                String refExcelFile = this.getReferenceExcelSourceFile();
                ArrayList<String> lMessage = new ArrayList<String>();
                for (GMSi_Set set : this.mTempSETs.values()) {
                    int nValues = PETmanager.readSetFromExcel(set, refExcelFile);
                    if (nValues > 0) continue;
                    lMessage.add(set.getName());
                }
                if (!lMessage.isEmpty()) {
                    String msg = "SETs not updated from file '" + refExcelFile + "':\n";
                    for (String s : lMessage) {
                        msg = msg + " -No valid value found for SET '" + s + "'\n";
                    }
                    msg = msg + "User will have to 'manually' introduce values in Excel file";
                    this.showUnexpectedExceptionMessage(msg, null);
                }
            }
        }
        catch (IOException e) {
            this.showUnexpectedExceptionMessage("Error accessing Source Excel file ", e);
        }
        catch (InvalidFormatException e) {
            this.showUnexpectedExceptionMessage("Invalid Source Excel File format error", (Exception)((Object)e));
        }
        catch (DE_ValidationException e) {
            this.showUnexpectedExceptionMessage("Validation error", e);
        }
    }

    public Collection<GMSi_Set> getGUI_SETs() {
        if (this.mTempSETs == null) {
            this.initGUI_SET();
        }
        return this.mTempSETs.values();
    }

    public Collection<GMSi_Parameter> getGUI_PARAMETERs() {
        if (this.mTempPARAMETERs == null) {
            this.initGUI_SET();
        }
        return this.mTempPARAMETERs.values();
    }

    @Override
    public void beforeShowingPanel(JPanel pnl) {
    }

    @Override
    public void finishWizard() {
        assert (this.tempSim != null) : "Simulation should always be initialized!";
        this.tempSim.setName(this.pnlCase.getCaseName());
        String sourceFile = this.pnlCase.getCasePath() + File.separator + this.pnlCase.getCaseName() + ".xlsm";
        this.tempSim.setParameterValue(sourceFile, "simsourcefile");
        String configFile = DeepEdit.getOptionValue("DE-PET_modelfile");
        this.tempSim.setParameterValue(configFile, "simconfigfile");
        this.tempSim.setParameterValue(String.valueOf(true), "isenabled");
        this.tempSim.setParameterValue(DE_GeneralEnums.DispatchSoftware.PET.name(), "type");
        this.tempSim.setParameterValue(DE_GeneralEnums.DispatchSoftware.PET.name(), "softwaresource");
        this.tempSim.setParameterValue("1", "simId");
        this.tempSim.setParameterValue(String.valueOf(DeepEdit.getActiveSchematic().getiniperiod()), "initialperiod");
        this.tempSim.setParameterValue("1", "initialblock");
        this.tempSim.setParameterValue(String.valueOf(this.pnlSim.getTotalBlocks()), "totalblock");
        this.tempSim.setParameterValue(String.valueOf(this.pnlSim.getNumHydroSamples()), "totalhydro");
        this.tempSim.setParameterValue("Custom", "LDC_type");
        this.tempSim.setParameterValue(String.valueOf(this.pnlSim.getNumBlocks()), "LDC_numblocks");
        for (Constraint c : this.lTempConstraints) {
            DeepEdit.addComponent(c);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PETmanager.setPETCase(PETNew_Wizard.this.tempSim);
                    for (GMSi_Set set : PETNew_Wizard.this.mTempSETs.values()) {
                        PETmanager.putPET_SET(set);
                    }
                }
                catch (Exception e) {
                    PETNew_Wizard.this.showUnexpectedExceptionMessage("Unexpected error registering SETs from GUI", e);
                    return;
                }
                try {
                    PETmanager.newPETCase();
                }
                catch (FileNotFoundException e) {
                    PETNew_Wizard.this.showUnexpectedExceptionMessage("Error accesing files when storing case in Excel", e);
                }
                catch (IOException e) {
                    PETNew_Wizard.this.showUnexpectedExceptionMessage("Error accesing files when storing case in Excel", e);
                }
                catch (InvalidFormatException e) {
                    PETNew_Wizard.this.showUnexpectedExceptionMessage("Error in Excel destination file when storing case in Excel", (Exception)((Object)e));
                }
                catch (PET_validationException e) {
                    PETNew_Wizard.this.showUnexpectedExceptionMessage("PET-DeepEdit validation error", e);
                    return;
                }
                catch (DE_ValidationException e) {
                    PETNew_Wizard.this.showUnexpectedExceptionMessage("DeepEdit Solver/Schematic validation  error", e);
                    return;
                }
                catch (Exception e) {
                    PETNew_Wizard.this.showUnexpectedExceptionMessage("Unexpected error creating when storing case in Excel", e);
                }
            }
        }).start();
    }

    public GMSi_Set getTempSET(String name) {
        if (this.mTempSETs == null) {
            this.initGUI_SET();
        }
        GMSi_Set set = this.mTempSETs.get(name);
        assert (set != null) : "Why this name '" + name + "' is no longer a GUI supported set?? ";
        return set;
    }

    public Simulation getTempSimulation() {
        return this.tempSim;
    }

    public String getReferenceExcelSourceFile() {
        return this.pnlCase.getReferenceSourceFile();
    }

    public void setTempSimulation(Simulation sim) {
        this.tempSim = sim;
        DeepEdit.addComponent(this.tempSim);
    }

    public Constraint getTempConstraint(String name, DE_GeneralEnums.ConstraintCategory cc) {
        for (Constraint c : this.lTempConstraints) {
            if (!(c.getName() == null ? name == null : c.getName().equals(name)) || c.getCategory() != cc) continue;
            return c;
        }
        return null;
    }

    public Constraint createTempConstraint(String name, DE_GeneralEnums.ConstraintCategory cc) {
        Constraint tempConstraint = new Constraint(name, DeepEdit.getActiveSchematic().getiniperiod(), DeepEdit.getActiveSchematic().getendperiod());
        this.lTempConstraints.add(tempConstraint);
        return tempConstraint;
    }

    public void refreshLabels() {
        this.pnlSim.refreshLabels();
    }

    @Override
    public void wizardCancelled() {
        Simulation regSim;
        if (this.tempSim != null && (regSim = (Simulation)DeepEdit.getComponent(this.tempSim.getName(), "Simulation")) != null) {
            DeepEdit.removeComponent(regSim);
        }
    }
}

