/*
 * Decompiled with CFR 0.152.
 */
package de.edil.pet;

import de.core.AbstractWizardPanel;
import de.core.Constraint;
import de.core.ConstraintBuilderFrame;
import de.data.DE_GeneralEnums;
import de.edil.pet.PETNew_Wizard;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class PETNew_Step3
extends AbstractWizardPanel {
    private final PETNew_Wizard wiz;
    private JButton btnAdd;
    private JToggleButton btnEdit;
    private JButton btnRemove;
    private JComboBox cboAddComp;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lbl1;
    private JLabel lbl2;
    private JLabel lbl3;
    private JLabel lbl4;
    private JLabel lbl5;
    private JLabel lbl9;
    private JList lstCategory;
    private JList lstConstraints;
    private JFormattedTextField txtFCFBlocks;
    private JTextField txtName;

    public PETNew_Step3(PETNew_Wizard wiz) {
        super(wiz);
        this.initComponents();
        this.wiz = wiz;
        this.loadConstraintCategory();
    }

    private void loadConstraintCategory() {
        this.lstCategory.removeAll();
        this.lstCategory.setListData(DE_GeneralEnums.ConstraintCategory.values());
    }

    private void loadComp(DE_GeneralEnums.ConstraintCategory eCategory) {
        this.cboAddComp.removeAllItems();
        List<String> classList = Constraint.getCategoryClassNameList(eCategory);
        for (String s : classList) {
            this.cboAddComp.addItem(s);
        }
    }

    private void loadCompList(String className) {
    }

    private void clearAll() {
        this.lstCategory.clearSelection();
        this.cboAddComp.removeAllItems();
        this.btnAdd.setEnabled(false);
    }

    private void initComponents() {
        this.lbl9 = new JLabel();
        this.lbl1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstCategory = new JList();
        this.lbl2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstConstraints = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnEdit = new JToggleButton();
        this.lbl3 = new JLabel();
        this.txtName = new JTextField();
        this.lbl4 = new JLabel();
        this.cboAddComp = new JComboBox();
        this.txtFCFBlocks = new JFormattedTextField();
        this.lbl5 = new JLabel();
        this.lbl9.setText("FCF Blocks:");
        this.setName("Simulation");
        this.setPreferredSize(new Dimension(377, 300));
        this.lbl1.setText("Categories:");
        this.lstCategory.setSelectionMode(0);
        this.lstCategory.setToolTipText("");
        this.lstCategory.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PETNew_Step3.this.lstCategoryMouseClicked(evt);
            }
        });
        this.lstCategory.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PETNew_Step3.this.lstCategoryValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstCategory);
        this.lbl2.setText("Constraint List:");
        this.lstConstraints.setModel(new DefaultListModel());
        this.lstConstraints.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PETNew_Step3.this.lstConstraintsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.lstConstraints);
        this.btnAdd.setText(">");
        this.btnAdd.setEnabled(false);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PETNew_Step3.this.btnAddActionPerformed(evt);
            }
        });
        this.btnRemove.setText("<");
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PETNew_Step3.this.btnRemoveActionPerformed(evt);
            }
        });
        this.btnEdit.setText("Edit");
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PETNew_Step3.this.btnEditActionPerformed(evt);
            }
        });
        this.lbl3.setText("Name:");
        this.txtName.setText("New_Constraint");
        this.lbl4.setText("Classes:");
        this.txtFCFBlocks.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtFCFBlocks.setText("1");
        this.txtFCFBlocks.setEnabled(false);
        this.txtFCFBlocks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PETNew_Step3.this.txtFCFBlocksActionPerformed(evt);
            }
        });
        this.lbl5.setText("FCF Blocks:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.lbl1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 147, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbl3).addComponent(this.lbl5).addComponent(this.lbl4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboAddComp, -2, 88, -2).addComponent(this.txtName, -2, 88, -2).addComponent(this.txtFCFBlocks, GroupLayout.Alignment.TRAILING, -2, 25, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnAdd).addComponent(this.btnRemove)))).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lbl2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -2, 150, -2).addComponent(this.btnEdit, -2, 63, -2)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbl1).addComponent(this.lbl2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnAdd).addGap(18, 18, 18).addComponent(this.btnRemove)).addComponent(this.jScrollPane1, -2, 102, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbl3).addComponent(this.txtName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboAddComp, -2, -1, -2).addComponent(this.lbl4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtFCFBlocks, -2, -1, -2).addComponent(this.lbl5))).addComponent(this.jScrollPane2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEdit).addGap(0, 72, Short.MAX_VALUE)));
    }

    private void lstCategoryValueChanged(ListSelectionEvent evt) {
        JList theList;
        int index;
        boolean adjust = evt.getValueIsAdjusting();
        if (!adjust && (index = (theList = (JList)evt.getSource()).getSelectedIndex()) >= 0) {
            DE_GeneralEnums.ConstraintCategory cc = (DE_GeneralEnums.ConstraintCategory)((Object)theList.getModel().getElementAt(index));
            this.loadComp(cc);
            this.btnAdd.setEnabled(cc != DE_GeneralEnums.ConstraintCategory.Generic);
            this.txtFCFBlocks.setEnabled(cc == DE_GeneralEnums.ConstraintCategory.FCF);
        }
    }

    private void lstCategoryMouseClicked(MouseEvent evt) {
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        DE_GeneralEnums.ConstraintCategory cc = (DE_GeneralEnums.ConstraintCategory)((Object)this.lstCategory.getSelectedValue());
        ArrayList<String> lNames = new ArrayList<String>();
        String constraintName = this.txtName.getText();
        int nFCF = Integer.parseInt(this.txtFCFBlocks.getText());
        if (cc != null) {
            switch (cc) {
                case Generic: {
                    break;
                }
                case FCF: {
                    for (int i = 0; i < nFCF; ++i) {
                        lNames.add(constraintName + "_" + (i + 1));
                    }
                    break;
                }
                default: {
                    lNames.add(constraintName);
                }
            }
        }
        DefaultListModel model = (DefaultListModel)this.lstConstraints.getModel();
        for (String s : lNames) {
            Constraint c = this.wiz.getTempConstraint(s, cc);
            if (c != null) continue;
            c = this.wiz.createTempConstraint(s, cc);
            c.setCategory(cc);
            model.addElement(c);
        }
        this.clearAll();
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        Object o = this.lstConstraints.getSelectedValue();
        if (o != null && o instanceof Constraint) {
            ConstraintBuilderFrame builder = new ConstraintBuilderFrame((Window)this.wiz);
            builder.loadConstraint((Constraint)o);
            builder.setLocationRelativeTo(this.wiz);
            builder.setVisible(true);
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.lstConstraints.getModel();
        Object[] oList = this.lstConstraints.getSelectedValues();
        int[] index = this.lstConstraints.getSelectedIndices();
        if (oList.length > 0) {
            for (int i = oList.length - 1; i >= 0; --i) {
                if (!(oList[i] instanceof Constraint) || index[i] == -1) continue;
                dlm.removeElementAt(index[i]);
            }
        }
    }

    private void txtFCFBlocksActionPerformed(ActionEvent evt) {
        System.out.println(evt);
    }

    private void lstConstraintsValueChanged(ListSelectionEvent evt) {
        boolean adjust = evt.getValueIsAdjusting();
        if (!adjust) {
            JList theList = (JList)evt.getSource();
            int index = theList.getSelectedIndex();
            this.btnRemove.setEnabled(index >= 0);
        }
    }

    @Override
    public void beforeShowingPanel() {
    }

    @Override
    public void beforeHidingPanel() {
    }
}

