/*
 * Decompiled with CFR 0.152.
 */
package de.edil.pet;

import de.core.AbstractWizardPanel;
import de.data.DE_ValidationException;
import de.edil.pet.PETNew_Wizard;
import de.solver.gmsi.GMSi_Set;
import de.solver.gmsi.GmsiSETVisualFrame;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class PETNew_Step2
extends AbstractWizardPanel {
    private final PETNew_Wizard wiz;
    private JToggleButton btnBlocks;
    private JToggleButton btnHydro;
    private JToggleButton btnLDCs;
    private JToggleButton btnPeriods;
    private JComboBox cboEndLDC;
    private JComboBox cboEndPeriod;
    private JComboBox cboInitialHydro;
    private JComboBox cboInitialLDC;
    private JComboBox cboInitialPeriod;
    private JLabel lbl1;
    private JLabel lbl2;
    private JLabel lbl3;
    private JLabel lbl4;
    private JLabel lbl5;
    private JLabel lbl6;
    private JLabel lbl7;
    private JLabel lbl8;
    private JLabel lbl9;
    private JFormattedTextField txtBlocks;
    private JFormattedTextField txtHydroSamples;
    private JFormattedTextField txtLDCs;
    private JFormattedTextField txtPeriods;

    public PETNew_Step2(PETNew_Wizard wiz) {
        super(wiz);
        this.initComponents();
        this.wiz = wiz;
    }

    public int getNumPeriods() {
        try {
            return Integer.parseInt(this.txtPeriods.getText());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getNumLDCs() {
        try {
            return Integer.parseInt(this.txtLDCs.getText());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getNumBlocks() {
        try {
            return Integer.parseInt(this.txtBlocks.getText());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getNumHydroSamples() {
        try {
            return Integer.parseInt(this.txtHydroSamples.getText());
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getTotalBlocks() {
        return this.getNumPeriods() * this.getNumLDCs() * this.getNumBlocks();
    }

    public Object getInitialPeriod() {
        return this.cboInitialPeriod.getSelectedItem();
    }

    public Object getInitialLDC() {
        return this.cboInitialLDC.getSelectedItem();
    }

    public Object getEndPeriod() {
        return this.cboEndPeriod.getSelectedItem();
    }

    public Object getEndLDC() {
        return this.cboEndLDC.getSelectedItem();
    }

    public Object getInitialHydroPeriod() {
        return this.cboInitialHydro.getSelectedItem();
    }

    public void refreshLabels() {
        this.txtPeriods.setValue(this.getTempSET("periods").size());
        this.initializeCbo(this.cboInitialPeriod, this.getTempSET("periods").values(), this.getTempSET("Simulation::initialperiod").get(0));
        this.txtLDCs.setValue(this.getTempSET("ldcs").size());
        this.initializeCbo(this.cboInitialLDC, this.getTempSET("ldcs").values(), this.getTempSET("Simulation::initialldc").get(0));
        this.txtBlocks.setValue(this.getTempSET("blocks").size());
        this.txtHydroSamples.setValue(this.getTempSET("totalhydro").size());
        this.initializeCbo(this.cboEndPeriod, this.getTempSET("periods").values(), this.getTempSET("Simulation::endperiod").get(0));
        this.initializeCbo(this.cboEndLDC, this.getTempSET("ldcs").values(), this.getTempSET("Simulation::endldc").get(0));
        this.initializeCbo(this.cboInitialHydro, this.getTempSET("ldcs").values(), this.getTempSET("Simulation::initialhydroldc").get(0));
        this.wiz.setFowardEnabled(this.isNextReady());
    }

    private void initializeCbo(JComboBox cbo, List<Object> oList, Object selection) {
        Object oPrev = cbo.getSelectedItem();
        cbo.removeAllItems();
        for (Object o : oList) {
            cbo.addItem(o);
        }
        if (selection == null) {
            if (oList.contains(oPrev)) {
                cbo.setSelectedItem(oPrev);
            }
        } else {
            cbo.setSelectedItem(selection);
        }
    }

    private GMSi_Set getTempSET(String name) {
        if (this.wiz != null) {
            return this.wiz.getTempSET(name);
        }
        return null;
    }

    private boolean isNextReady() {
        return this.getNumPeriods() != 0 && this.getNumBlocks() != 0 && this.getNumLDCs() != 0 && this.getNumHydroSamples() != 0 && this.cboInitialPeriod.getSelectedIndex() != -1 && this.cboInitialLDC.getSelectedIndex() != -1 && this.cboEndPeriod.getSelectedIndex() != -1 && this.cboEndLDC.getSelectedIndex() != -1 && this.cboInitialHydro.getSelectedIndex() != -1;
    }

    private void changeInitSET(String setName, Object selection) throws DE_ValidationException {
        GMSi_Set iniSet = this.wiz.getTempSET(setName);
        assert (iniSet != null) : "Why this set name '" + setName + "' is no longer a valid initial GUI Set??";
        if (iniSet != null && selection != null) {
            iniSet.clear();
            iniSet.add(selection);
        }
    }

    private void initComponents() {
        this.lbl1 = new JLabel();
        this.txtPeriods = new JFormattedTextField();
        this.btnPeriods = new JToggleButton();
        this.lbl2 = new JLabel();
        this.txtLDCs = new JFormattedTextField();
        this.btnLDCs = new JToggleButton();
        this.lbl3 = new JLabel();
        this.txtBlocks = new JFormattedTextField();
        this.btnBlocks = new JToggleButton();
        this.lbl4 = new JLabel();
        this.txtHydroSamples = new JFormattedTextField();
        this.btnHydro = new JToggleButton();
        this.lbl5 = new JLabel();
        this.cboInitialPeriod = new JComboBox();
        this.lbl6 = new JLabel();
        this.cboInitialLDC = new JComboBox();
        this.lbl7 = new JLabel();
        this.cboEndPeriod = new JComboBox();
        this.lbl8 = new JLabel();
        this.cboEndLDC = new JComboBox();
        this.lbl9 = new JLabel();
        this.cboInitialHydro = new JComboBox();
        this.setName("Simulation");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                PETNew_Step2.this.formComponentShown(evt);
            }
        });
        this.lbl1.setText("Periods:");
        this.txtPeriods.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtPeriods.setText("0");
        this.btnPeriods.setText("...");
        this.btnPeriods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PETNew_Step2.this.btnPeriodsActionPerformed(evt);
            }
        });
        this.lbl2.setText("LDCs:");
        this.txtLDCs.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtLDCs.setText("0");
        this.btnLDCs.setText("...");
        this.btnLDCs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PETNew_Step2.this.btnLDCsActionPerformed(evt);
            }
        });
        this.lbl3.setText("Blocks:");
        this.txtBlocks.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtBlocks.setText("0");
        this.btnBlocks.setText("...");
        this.btnBlocks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PETNew_Step2.this.btnBlocksActionPerformed(evt);
            }
        });
        this.lbl4.setText("Hydro Samples:");
        this.txtHydroSamples.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtHydroSamples.setText("0");
        this.btnHydro.setText("...");
        this.btnHydro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PETNew_Step2.this.btnHydroActionPerformed(evt);
            }
        });
        this.lbl5.setText("Initial Period:");
        this.cboInitialPeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PETNew_Step2.this.cboInitialPeriodItemStateChanged(evt);
            }
        });
        this.lbl6.setText("Initial LDC:");
        this.lbl7.setText("End Period:");
        this.lbl8.setText("End LDC:");
        this.lbl9.setText("Init Hydro LDC:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lbl4).addGap(78, 78, 78).addComponent(this.txtHydroSamples).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lbl1, -2, 75, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbl3, -2, 75, -2).addComponent(this.lbl2, -2, 75, -2))).addGap(78, 78, 78).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtBlocks, -1, 122, Short.MAX_VALUE).addComponent(this.txtLDCs, GroupLayout.Alignment.TRAILING).addComponent(this.txtPeriods, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnPeriods, -2, 20, -2).addComponent(this.btnLDCs, -2, 20, -2).addComponent(this.btnBlocks, -2, 20, -2).addComponent(this.btnHydro, -2, 20, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbl6).addComponent(this.lbl7).addComponent(this.lbl5).addComponent(this.lbl8)).addGap(88, 88, 88)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lbl9, -2, 85, -2).addGap(66, 66, 66))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboInitialHydro, -2, 150, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cboInitialPeriod, 0, -1, Short.MAX_VALUE).addComponent(this.cboInitialLDC, 0, -1, Short.MAX_VALUE).addComponent(this.cboEndPeriod, -2, 150, -2).addComponent(this.cboEndLDC, -2, 150, -2))))).addContainerGap(51, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lbl1).addComponent(this.txtPeriods, -2, -1, -2).addComponent(this.btnPeriods)).addGap(23, 23, 23)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.txtLDCs, -2, -1, -2).addComponent(this.btnLDCs).addComponent(this.lbl2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.btnBlocks).addComponent(this.txtBlocks, -2, -1, -2).addComponent(this.lbl3)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lbl4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtHydroSamples, -2, -1, -2).addComponent(this.btnHydro))).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbl5).addComponent(this.cboInitialPeriod, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbl6).addComponent(this.cboInitialLDC, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboEndPeriod, -2, -1, -2).addComponent(this.lbl7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboEndLDC, -2, -1, -2).addComponent(this.lbl8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lbl9).addComponent(this.cboInitialHydro, -2, -1, -2)).addContainerGap(32, Short.MAX_VALUE)));
    }

    private void btnPeriodsActionPerformed(ActionEvent evt) {
        GMSi_Set set = this.getTempSET("periods");
        if (this.getNumPeriods() != set.size()) {
            set.clear();
            set.setConsecutiveNumericValues(this.getNumPeriods());
        }
        GmsiSETVisualFrame visualPeriods = new GmsiSETVisualFrame((Dialog)this.wiz, set, true);
        visualPeriods.setLocationRelativeTo(this.wiz);
        visualPeriods.setVisible(true);
    }

    private void btnLDCsActionPerformed(ActionEvent evt) {
        GMSi_Set set = this.getTempSET("ldcs");
        if (this.getNumLDCs() != set.size()) {
            set.clear();
            set.setConsecutiveNumericValues(this.getNumLDCs());
        }
        GmsiSETVisualFrame visualPeriods = new GmsiSETVisualFrame((Dialog)this.wiz, set, true);
        visualPeriods.setLocationRelativeTo(this.wiz);
        visualPeriods.setVisible(true);
    }

    private void btnBlocksActionPerformed(ActionEvent evt) {
        GMSi_Set set = this.getTempSET("blocks");
        if (this.getNumBlocks() != set.size()) {
            set.clear();
            set.setConsecutiveNumericValues(this.getNumBlocks());
        }
        GmsiSETVisualFrame visualPeriods = new GmsiSETVisualFrame((Dialog)this.wiz, set, true);
        visualPeriods.setLocationRelativeTo(this);
        visualPeriods.setVisible(true);
    }

    private void btnHydroActionPerformed(ActionEvent evt) {
        GMSi_Set set = this.getTempSET("totalhydro");
        if (this.getNumHydroSamples() != set.size()) {
            set.clear();
            set.setConsecutiveNumericValues(this.getNumHydroSamples());
        }
        GmsiSETVisualFrame visualPeriods = new GmsiSETVisualFrame((Dialog)this.wiz, set, true);
        visualPeriods.setLocationRelativeTo(this);
        visualPeriods.setVisible(true);
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void cboInitialPeriodItemStateChanged(ItemEvent evt) {
    }

    @Override
    public void beforeShowingPanel() {
        this.wiz.initGUI_SET();
        this.refreshLabels();
        this.wiz.setFowardEnabled(this.isNextReady());
    }

    @Override
    public void beforeHidingPanel() {
        if (this.wiz.getTempSimulation() != null) {
            try {
                this.changeInitSET("Simulation::initialperiod", this.cboInitialPeriod.getSelectedItem());
                this.changeInitSET("Simulation::initialldc", this.cboInitialLDC.getSelectedItem());
                this.changeInitSET("Simulation::endperiod", this.cboEndPeriod.getSelectedItem());
                this.changeInitSET("Simulation::endldc", this.cboEndLDC.getSelectedItem());
                this.changeInitSET("Simulation::initialhydroldc", this.cboInitialHydro.getSelectedItem());
            }
            catch (DE_ValidationException e) {
                this.wiz.showUnexpectedExceptionMessage("Invalid initial/end period entry: ", e);
            }
        }
    }
}

