/*
 * Decompiled with CFR 0.152.
 */
package de.edil;

import de.data.ExcelBlockAddress;
import de.data.ExcelRangeAddress;
import de.edil.DE_Location;
import java.util.ArrayList;
import java.util.List;

public class DE_LocationExcel
implements DE_Location {
    private String excelFile;
    private final ExcelBlockAddress excelBlock;
    private final List<String> missingDataOrientation = new ArrayList<String>();
    public static final String DATA_ORIENTATION_VERTICAL = "vertical";
    public static final String DATA_ORIENTATION_HORIZONTAL = "horizontal";
    public static final String DATA_ORIENTATION_NONE = "none";

    public DE_LocationExcel(String ExcelFile, String sRange, String orientation) {
        this.excelFile = ExcelFile;
        this.excelBlock = new ExcelBlockAddress(sRange);
        if (orientation != null) {
            if (orientation.contains(ExcelBlockAddress.RANGE_BLOCK_SEPARATOR)) {
                String[] splitO;
                for (String s : splitO = orientation.split(ExcelBlockAddress.RANGE_BLOCK_SEPARATOR)) {
                    this.missingDataOrientation.add(s.toLowerCase().trim());
                }
            } else {
                this.missingDataOrientation.add(orientation.toLowerCase().trim());
            }
        } else {
            for (ExcelRangeAddress r : this.excelBlock.getExcelRanges()) {
                this.missingDataOrientation.add(DATA_ORIENTATION_VERTICAL);
            }
        }
    }

    @Override
    public void setSourcePath(String name) {
        this.excelFile = name;
    }

    @Override
    public String getSourcePath() {
        return this.excelFile;
    }

    public String getExcelSheetName() {
        return this.excelBlock.getExcelRanges()[0].getRangeSheet();
    }

    public String getExcelRangeAdress() {
        return this.excelBlock.getExcelRanges()[0].getRangeAddress();
    }

    public String getExcelRangeAdress(int index) {
        assert (index >= 0) : "How a negative index got here?? index:" + index;
        return this.excelBlock.getExcelRanges()[index].getRangeAddress();
    }

    public ExcelRangeAddress getRange() {
        return this.excelBlock.getExcelRanges()[0];
    }

    public ExcelRangeAddress getRange(int index) {
        assert (index >= 0) : "How a negative index got here?? index:" + index;
        return this.excelBlock.getExcelRanges()[index];
    }

    public ExcelRangeAddress[] getAllRanges() {
        return this.excelBlock.getExcelRanges();
    }

    public ExcelRangeAddress[] getHorizontalRanges() {
        return this.getAllRanges(DATA_ORIENTATION_HORIZONTAL);
    }

    public ExcelRangeAddress[] getVerticalRanges() {
        return this.getAllRanges(DATA_ORIENTATION_VERTICAL);
    }

    public ExcelRangeAddress[] getAllRanges(String missingOrientation) {
        if (missingOrientation == null) {
            return this.excelBlock.getExcelRanges();
        }
        ArrayList<ExcelRangeAddress> lRange = new ArrayList<ExcelRangeAddress>();
        for (int i = 0; i < this.excelBlock.getNumRanges(); ++i) {
            if (!missingOrientation.equalsIgnoreCase(this.missingDataOrientation.get(i))) continue;
            lRange.add(this.excelBlock.getExcelRanges()[i]);
        }
        if (lRange.isEmpty()) {
            return null;
        }
        return lRange.toArray(new ExcelRangeAddress[0]);
    }

    public int getNumRanges() {
        return this.excelBlock.getNumRanges();
    }

    public String getMissingDataOrientation() {
        return this.missingDataOrientation.get(0);
    }

    public String getMissingDataOrientation(int index) {
        assert (index >= 0) : "How a negative index got here?? index:" + index;
        if (index >= this.missingDataOrientation.size()) {
            return null;
        }
        return this.missingDataOrientation.get(index);
    }
}

