/*
 * Decompiled with CFR 0.152.
 */
package de.data;

import de.data.DE_GeneralEnums;
import de.utils.StringUtil;

public class ValidationRule {
    public static final String EQUATION_CHARACTER = "x";
    private static final String INIT_RANGE_CHARACTER = "\\{";
    private static final String END_RANGE_CHARACTER = "\\}";
    public static final String RANGE_SEPARATOR_CHARACTER = ",";
    public static final String AND = ";";
    public static final String OR = "||";

    public static boolean isValid(String sValue, String[] sRules) {
        boolean bIsValid = true;
        for (String sRule : sRules) {
            bIsValid &= ValidationRule.isValid(sValue, sRule);
        }
        return bIsValid;
    }

    public static boolean isValid(String sValue, String sRule) {
        if (sRule == null) {
            return true;
        }
        if (sRule.contains(AND)) {
            return ValidationRule.isValid(sValue, sRule.split(AND));
        }
        assert (!sRule.contains(OR)) : "'OR' operation is not supported feature yet!";
        DE_GeneralEnums.databaseDataType type = ValidationRule.getDatabaseType(sRule);
        if (type != null) {
            return ValidationRule.isValidType(sValue, type);
        }
        if (ValidationRule.isEquationType(sRule)) {
            try {
                double d = Double.parseDouble(sValue);
                return ValidationRule.isInEquationRange(d, sRule);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (ValidationRule.isListType(sRule)) {
            return ValidationRule.isInValidRangeList(sValue, sRule);
        }
        return false;
    }

    public static boolean isDatabaseType(String sRule) {
        return ValidationRule.getDatabaseType(sRule) != null;
    }

    public static boolean isEquationType(String sRule) {
        return sRule.toLowerCase().contains(EQUATION_CHARACTER) && ValidationRule.string2RangeOperator(sRule) != Operator.free;
    }

    public static boolean isListType(String sRule) {
        return sRule.contains("{") && sRule.contains("}");
    }

    public static boolean isInEquationRange(double dValue, String sRule) {
        double dRHS = ValidationRule.getDoubleRange(sRule);
        switch (ValidationRule.string2RangeOperator(sRule)) {
            case different: {
                return dValue != dRHS;
            }
            case equal: {
                return dValue == dRHS;
            }
            case free: {
                return true;
            }
            case greater: {
                return dValue > dRHS;
            }
            case greater_or_equal: {
                return dValue >= dRHS;
            }
            case lower: {
                return dValue < dRHS;
            }
            case lower_or_equal: {
                return dValue <= dRHS;
            }
        }
        return false;
    }

    public static Operator string2RangeOperator(String sRule) {
        if (sRule.contains(Operator.different.toString())) {
            return Operator.different;
        }
        if (sRule.contains(Operator.greater_or_equal.toString())) {
            return Operator.greater_or_equal;
        }
        if (sRule.contains(Operator.lower_or_equal.toString())) {
            return Operator.lower_or_equal;
        }
        if (sRule.contains(Operator.greater.toString())) {
            return Operator.greater;
        }
        if (sRule.contains(Operator.lower.toString())) {
            return Operator.lower;
        }
        if (sRule.contains(Operator.equal.toString())) {
            return Operator.equal;
        }
        return Operator.free;
    }

    public static double getDoubleRange(String sRule) {
        String[] splitRule = sRule.split(ValidationRule.string2RangeOperator(sRule).toString());
        if (splitRule.length == 2) {
            try {
                double d = Double.parseDouble(splitRule[1]);
                return d;
            }
            catch (NumberFormatException e) {
                assert (false) : "Why this validation rule couldn't be parsed to double?" + sRule;
                return 0.0;
            }
        }
        assert (false) : "Why this validation rule couldn't be parsed?" + sRule;
        return 0.0;
    }

    public static String[] getValidRangeList(String sRule) {
        if (ValidationRule.isListType(sRule)) {
            String[] splitRule1 = sRule.split(INIT_RANGE_CHARACTER);
            assert (splitRule1.length == 2) : "This isn't supported rule:" + sRule + ". Did you change Parameter definition file?";
            String[] splitRule2 = splitRule1[1].split(END_RANGE_CHARACTER);
            assert (splitRule2.length >= 1) : "This isn't supported rule:" + sRule + ". Did you change Parameter definition file?";
            String[] splitRule3 = splitRule2[0].split(RANGE_SEPARATOR_CHARACTER);
            assert (splitRule3.length >= 1) : "This isn't supported rule:" + sRule + ". Did you change Parameter definition file?";
            String[] lRet = new String[splitRule3.length];
            int cont = 0;
            for (String s : splitRule3) {
                lRet[cont] = s.trim();
                ++cont;
            }
            return lRet;
        }
        return new String[0];
    }

    public static boolean isInValidRangeList(String sValue, String sRule) {
        for (String s : ValidationRule.getValidRangeList(sRule)) {
            if (sValue.trim().equalsIgnoreCase(s)) {
                return true;
            }
            double dValue = StringUtil.safeParseDouble(sValue.trim(), Double.NaN);
            double dRule = StringUtil.safeParseDouble(s, Double.NaN);
            if (dValue == Double.NaN || dValue != dRule) continue;
            return true;
        }
        return false;
    }

    public static DE_GeneralEnums.databaseDataType getDatabaseType(String sRule) {
        for (DE_GeneralEnums.databaseDataType type : DE_GeneralEnums.databaseDataType.values()) {
            if (!sRule.contains(type.name())) continue;
            return type;
        }
        return null;
    }

    public static boolean isValidType(String sValue, DE_GeneralEnums.databaseDataType type) {
        switch (type) {
            case BooleanValue: {
                try {
                    Boolean.parseBoolean(sValue);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case DateValue: {
                assert (false) : "Unsupported dates!!";
                break;
            }
            case DoubleValue: {
                try {
                    Double.parseDouble(sValue);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case IntegerValue: {
                try {
                    double dValue = Double.parseDouble(sValue);
                    return dValue % 1.0 == 0.0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case StringValue: {
                return sValue != null;
            }
        }
        return false;
    }

    public static enum Operator {
        equal,
        greater,
        lower,
        greater_or_equal,
        lower_or_equal,
        different,
        free;


        public String toString() {
            switch (this) {
                case equal: {
                    return "==";
                }
                case greater: {
                    return ">";
                }
                case lower: {
                    return "<";
                }
                case greater_or_equal: {
                    return ">=";
                }
                case lower_or_equal: {
                    return "<=";
                }
                case different: {
                    return "!=";
                }
                case free: {
                    return "free";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

