/*
 * Decompiled with CFR 0.152.
 */
package de.data;

import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.data.XmlParameterdataInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="data-set")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ParameterInfo {
    private final List<String> lClassName = new ArrayList<String>();
    private final LinkedHashMap<String, LinkedHashMap<Integer, XmlParameterdataInfo>> mClassList = new LinkedHashMap();
    @XmlElement(name="record")
    private List<XmlParameterdataInfo> ParameterInfo = null;

    public List<XmlParameterdataInfo> getParameterInfo() {
        return this.ParameterInfo;
    }

    public void setParameterInfo(List<XmlParameterdataInfo> ParameterInfo2) {
        this.ParameterInfo = ParameterInfo2;
    }

    public List<String> getClassNameList() {
        if (this.lClassName.isEmpty()) {
            for (XmlParameterdataInfo x : this.ParameterInfo) {
                if (this.lClassName.contains(x.getClassName())) continue;
                this.lClassName.add(x.getClassName());
            }
        }
        return this.lClassName;
    }

    private XmlParameterdataInfo getParameterInfo(String className, String parameterName) {
        this.initClassLists(className);
        int id = this.getParameterId(className, parameterName);
        return this.mClassList.get(className).get(id);
    }

    public String getDefaultParameterValue(String className, String parameterName) {
        XmlParameterdataInfo x = this.getParameterInfo(className, parameterName);
        assert (x != null) : "Why are you trying to find a parameter not supported in this version: Class: '" + className + "', Name: '" + parameterName + "'";
        return x.getDefaultValue();
    }

    public double getDoubleDefaultParameterValue(String className, String parameterName) {
        XmlParameterdataInfo x = this.getParameterInfo(className, parameterName);
        assert (x != null) : "Why are you trying to find a parameter not supported in this version: Class: '" + className + "', Name: '" + parameterName + "'";
        assert (x.getDatabaseType().equals(DE_GeneralEnums.databaseDataType.DoubleValue.toString())) : "This has to be a double parameter!! Instead, it is registerd as " + x.getDatabaseType();
        return Double.parseDouble(x.getDefaultValue());
    }

    public int getIntegerDefaultParameterValue(String className, String parameterName) {
        XmlParameterdataInfo x = this.getParameterInfo(className, parameterName);
        assert (x != null) : "Why are you trying to find a parameter not supported in this version: Class: '" + className + "', Name: '" + parameterName + "'";
        assert (x.getDatabaseType().equals(DE_GeneralEnums.databaseDataType.IntegerValue.toString())) : "This has to be an Integer parameter!! Instead, it is registerd as " + x.getDatabaseType();
        return Integer.parseInt(x.getDefaultValue());
    }

    public String getStringDefaultParameterValue(String className, String parameterName) {
        XmlParameterdataInfo x = this.getParameterInfo(className, parameterName);
        assert (x != null) : "Why are you trying to find a parameter not supported in this version: Class: '" + className + "', Name: '" + parameterName + "'";
        assert (x.getDatabaseType().equals(DE_GeneralEnums.databaseDataType.StringValue.toString())) : "This has to be a String parameter!! Instead, it is registerd as " + x.getDatabaseType();
        return x.getDefaultValue();
    }

    public boolean getBooleanDefaultParameterValue(String className, String parameterName) {
        XmlParameterdataInfo x = this.getParameterInfo(className, parameterName);
        assert (x != null) : "Why are you trying to find a parameter not supported in this version: Class: '" + className + "', Name: '" + parameterName + "'";
        assert (x.getDatabaseType().equals(DE_GeneralEnums.databaseDataType.BooleanValue.toString())) : "This has to be a Boolean parameter!! Instead, it is registerd as " + x.getDatabaseType();
        return Boolean.parseBoolean(x.getDefaultValue());
    }

    public ParameterData getDefaultParameterInfo(String className, String parameterName) {
        String sValue = this.getDefaultParameterValue(className, parameterName);
        DE_GeneralEnums.databaseDataType eType = this.getParameterDataType(className, parameterName);
        ParameterData pData = new ParameterData(parameterName);
        pData.setValue(sValue, eType);
        String sRules = this.getValidationRule(className, parameterName);
        if (sRules != null) {
            String[] lRules = this.getValidationRule(className, parameterName).split(";");
            pData.setValidationRule(lRules);
        }
        return pData;
    }

    public DE_GeneralEnums.databaseDataType getParameterDataType(String className, String parameterName) {
        XmlParameterdataInfo x = this.getParameterInfo(className, parameterName);
        assert (x != null) : "Why are you trying to find a parameter not supported in this version: Class: '" + className + "', Name: '" + parameterName + "'";
        if (x == null) {
            return DE_GeneralEnums.databaseDataType.StringValue;
        }
        try {
            DE_GeneralEnums.databaseDataType eType = DE_GeneralEnums.databaseDataType.valueOf(x.getDatabaseType());
            return eType;
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Why this database type couldn't be parsed? Value in xml: " + x.getDatabaseType();
            e.printStackTrace(System.err);
            return null;
        }
    }

    public String getValidationRule(String className, String parameterName) {
        XmlParameterdataInfo x = this.getParameterInfo(className, parameterName);
        assert (x != null) : "Why are you trying to find a parameter not supported in this version: Class: '" + className + "', Name: '" + parameterName + "'";
        return x.getValidation_rule();
    }

    public boolean isShowInGUI(String className, String parameterName) {
        XmlParameterdataInfo x = this.getParameterInfo(className, parameterName);
        return x.isShowInGUI();
    }

    public boolean isParameterSupported(String className, String parameterName) {
        return this.getParameterInfo(className, parameterName) != null;
    }

    private int getParameterId(String className, String parameterName) {
        return (className.toLowerCase() + "_" + parameterName.toLowerCase()).hashCode();
    }

    public List<String> getParameterNameList(String className) {
        return this.getParameterList(className, 0);
    }

    private List<String> getParameterList(String className, int nValue) {
        this.initClassLists(className);
        ArrayList<String> lReturn = new ArrayList<String>();
        for (XmlParameterdataInfo x : this.mClassList.get(className).values()) {
            String sValue = "";
            switch (nValue) {
                case 0: {
                    sValue = x.getParameterName();
                    break;
                }
                case 1: {
                    sValue = x.getValidation_rule();
                    break;
                }
                case 2: {
                    sValue = x.getDefaultValue();
                    break;
                }
                case 3: {
                    sValue = x.getDescription();
                }
            }
            lReturn.add(sValue);
        }
        return lReturn;
    }

    private void initClassLists(String className) {
        boolean bIsCalculate = false;
        if (this.mClassList.get(className) != null && this.mClassList.get(className).isEmpty()) {
            bIsCalculate = true;
        }
        if (this.mClassList.get(className) == null) {
            bIsCalculate = true;
        }
        if (bIsCalculate) {
            LinkedHashMap<Integer, XmlParameterdataInfo> myList = new LinkedHashMap<Integer, XmlParameterdataInfo>();
            for (XmlParameterdataInfo x : this.ParameterInfo) {
                if (!x.getClassName().equalsIgnoreCase(className)) continue;
                int id = this.getParameterId(className, x.getParameterName());
                myList.put(id, x);
            }
            this.mClassList.put(className, myList);
        }
    }
}

