/*
 * Decompiled with CFR 0.152.
 */
package de.data;

import de.core.comp;
import de.data.DE_GeneralEnums;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class ParameterData {
    public String Name;
    private String sValue;
    private double dValue;
    private boolean bValue;
    private int iValue;
    private DE_GeneralEnums.databaseDataType eDataType;
    private DE_GeneralEnums.parameterGroup eGroup;
    private ArrayList<String> sValidationRule = new ArrayList();
    private int nBlock;
    private int nHydro;
    private Calendar cDateFrom;
    private Calendar cDateTo;
    private String strOwnerName;
    private comp oOwnerComponent;
    private String sOwnerClassName;

    public ParameterData(String Name) {
        this.Name = Name;
        this.eGroup = DE_GeneralEnums.parameterGroup.Operation;
    }

    public ParameterData(String Name, String sValue, double dValue, boolean bValue, int iValue, DE_GeneralEnums.databaseDataType eDataType, DE_GeneralEnums.parameterGroup eGroup, ArrayList<String> sValidationRule) {
        this.Name = Name;
        this.sValue = sValue;
        this.dValue = dValue;
        this.bValue = bValue;
        this.iValue = iValue;
        this.eDataType = eDataType;
        this.eGroup = eGroup;
        this.sValidationRule = sValidationRule;
    }

    public ParameterData(String Name, String sValue, double dValue, boolean bValue, int iValue, DE_GeneralEnums.databaseDataType eDataType, DE_GeneralEnums.parameterGroup eGroup, ArrayList<String> sValidationRule, int nBlock, int nHydro, Calendar cDateFrom, Calendar cDateTo, String strOwnerName, comp oOwnerComponent, String sOwnerClassName) {
        this.Name = Name;
        this.sValue = sValue;
        this.dValue = dValue;
        this.bValue = bValue;
        this.iValue = iValue;
        this.eDataType = eDataType;
        this.eGroup = eGroup;
        this.sValidationRule = sValidationRule;
        this.nBlock = nBlock;
        this.nHydro = nHydro;
        this.cDateFrom = cDateFrom;
        this.cDateTo = cDateTo;
        this.strOwnerName = strOwnerName;
        this.oOwnerComponent = oOwnerComponent;
        this.sOwnerClassName = sOwnerClassName;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String Name) {
        this.Name = Name;
    }

    public double getdValue() {
        return this.dValue;
    }

    public void setdValue(double dValue) {
        this.eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
        this.dValue = dValue;
    }

    public boolean isbValue() {
        return this.bValue;
    }

    public void setbValue(boolean bValue) {
        this.eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
        this.bValue = bValue;
    }

    public String getsValue() {
        return this.sValue;
    }

    public void setsValue(String sValue) {
        this.eDataType = DE_GeneralEnums.databaseDataType.StringValue;
        this.sValue = sValue;
    }

    public boolean setValue(String sValue) {
        return this.setValue(sValue, this.eDataType);
    }

    public boolean setValue(String sValue, DE_GeneralEnums.databaseDataType eDataType) {
        if (eDataType == null) {
            return true;
        }
        this.eDataType = eDataType;
        try {
            if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.StringValue)) {
                this.sValue = sValue;
            } else if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.DoubleValue)) {
                this.dValue = Double.parseDouble(sValue);
            } else if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.BooleanValue)) {
                this.bValue = Boolean.parseBoolean(sValue);
            } else if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.DateValue)) {
                assert (false) : "This is not implemented yet. Don't use this databasetype";
            } else if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.IntegerValue)) {
                this.iValue = (int)Double.parseDouble(sValue);
            } else assert (false) : "Why are you using an unsoported databasetype?";
            return true;
        }
        catch (NumberFormatException e) {
            assert (false) : "The value '" + sValue + "' wasn't stored in parameter " + this.Name;
            return false;
        }
    }

    public boolean setValue(String sValue, DE_GeneralEnums.databaseDataType eDataType, DE_GeneralEnums.parameterGroup eGroup) {
        this.eGroup = eGroup;
        return this.setValue(sValue, eDataType);
    }

    public String getValue() {
        return this.getValue(this.eDataType);
    }

    public String getValue(DE_GeneralEnums.databaseDataType eDataType) {
        if (eDataType == null) {
            return this.sValue;
        }
        if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.StringValue)) {
            return this.sValue;
        }
        if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.DoubleValue)) {
            return String.valueOf(this.dValue);
        }
        if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.BooleanValue)) {
            return String.valueOf(this.bValue);
        }
        if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.DateValue)) {
            assert (false) : "This is not implemented yet. Don't use this databasetype";
            return null;
        }
        if (eDataType.equals((Object)DE_GeneralEnums.databaseDataType.IntegerValue)) {
            return String.valueOf(this.iValue);
        }
        assert (false) : "Why are you using an unsoported databasetype?";
        return null;
    }

    public DE_GeneralEnums.databaseDataType geteDataType() {
        return this.eDataType;
    }

    public void seteType(DE_GeneralEnums.databaseDataType eDataType) {
        this.eDataType = eDataType;
    }

    public DE_GeneralEnums.parameterGroup geteGroup() {
        return this.eGroup;
    }

    public void seteGroup(DE_GeneralEnums.parameterGroup eGroup) {
        this.eGroup = eGroup;
    }

    public void addValidationRule(String newRule) {
        this.sValidationRule.add(newRule);
    }

    public String getValidationRule(int s) {
        if (this.sValidationRule.size() <= s) {
            return "";
        }
        return this.sValidationRule.get(s);
    }

    public String[] getValidationRule() {
        return this.sValidationRule.toArray(new String[this.sValidationRule.size()]);
    }

    public void setValidationRule(String[] ArrayValidationRule) {
        this.sValidationRule = new ArrayList<String>(Arrays.asList(ArrayValidationRule));
    }

    public String getStrOwnerName() {
        return this.strOwnerName;
    }

    public void setStrOwnerName(String strOwnerName) {
        this.strOwnerName = strOwnerName;
    }

    public comp getoOwnerComponent() {
        return this.oOwnerComponent;
    }

    public void setoOwnerComponent(comp oOwnerComponent) {
        this.oOwnerComponent = oOwnerComponent;
    }

    public int getYearDateFrom() {
        if (this.cDateFrom != null) {
            return this.cDateFrom.get(1);
        }
        return -1;
    }

    public int getnBlock() {
        return this.nBlock;
    }

    public void setnBlock(int nBlock) {
        this.nBlock = nBlock;
    }

    public int getnHydro() {
        return this.nHydro;
    }

    public void setnHydro(int nHydro) {
        this.nHydro = nHydro;
    }

    public Calendar getcDateFrom() {
        return this.cDateFrom;
    }

    public void setcDateFrom(Calendar cDateFrom) {
        this.cDateFrom = cDateFrom;
    }

    public Calendar getcDateTo() {
        return this.cDateTo;
    }

    public void setcDateTo(Calendar cDateTo) {
        this.cDateTo = cDateTo;
    }

    public String getClassName() {
        return this.sOwnerClassName;
    }

    public void setClassName(String ClassName) {
        this.sOwnerClassName = ClassName;
    }

    public void copyParameterInto(ParameterData pCopyToData) {
        if (pCopyToData == null) {
            pCopyToData = new ParameterData(this.Name);
        }
        ParameterData.copyParameter(this, pCopyToData);
    }

    public void copyParameterFrom(ParameterData pDataFrom) {
        if (pDataFrom == null) {
            return;
        }
        ParameterData.copyParameter(pDataFrom, this);
    }

    public static void copyParameter(ParameterData pDataFrom, ParameterData pDataTo) {
        if (pDataFrom == null) {
            return;
        }
        if (pDataTo == null) {
            pDataTo = new ParameterData(pDataFrom.getName());
        }
        pDataTo.setName(pDataFrom.getName());
        pDataTo.setValue(pDataFrom.getValue(), pDataFrom.geteDataType());
        pDataTo.seteGroup(pDataFrom.geteGroup());
        pDataTo.setStrOwnerName(pDataFrom.getStrOwnerName());
        pDataTo.setnBlock(pDataFrom.getnBlock());
        pDataTo.setnHydro(pDataFrom.getnHydro());
        pDataTo.setcDateFrom(pDataFrom.getcDateFrom());
        pDataTo.setcDateTo(pDataFrom.getcDateTo());
        pDataTo.setoOwnerComponent(pDataFrom.getoOwnerComponent());
        pDataTo.setClassName(pDataFrom.getClassName());
    }

    public ParameterData clone() {
        return new ParameterData(this.Name, this.sValue, this.dValue, this.bValue, this.iValue, this.eDataType, this.eGroup, this.sValidationRule, this.nBlock, this.nHydro, this.cDateFrom, this.cDateTo, this.strOwnerName, this.oOwnerComponent, this.sOwnerClassName);
    }

    public static ArrayList<ParameterData> filterParameterData(List<ParameterData> lInputData, int nBlock, int nHydro) {
        ArrayList<ParameterData> lOutData = new ArrayList<ParameterData>();
        for (ParameterData pData : lInputData) {
            if (pData.getnBlock() != nBlock || pData.getnHydro() != nHydro) continue;
            lOutData.add(pData);
        }
        return lOutData;
    }

    public static void setParameterName(List<ParameterData> lData, String strNewName) {
        for (ParameterData pData : lData) {
            pData.setName(strNewName);
        }
    }

    public static void setParameterClassName(List<ParameterData> lData, String strClassName) {
        for (ParameterData pData : lData) {
            pData.setClassName(strClassName);
        }
    }

    public static void setParameterStrOwner(List<ParameterData> lData, String strObjectOwner) {
        for (ParameterData pData : lData) {
            pData.setClassName(strObjectOwner);
        }
    }

    public static void scaleDoubleParameterData(List<ParameterData> lData, double escalator) {
        for (ParameterData pData : lData) {
            double p12 = pData.getdValue();
            pData.setdValue(p12 * escalator);
        }
    }
}

