/*
 * Decompiled with CFR 0.152.
 */
package de.data;

import de.utils.ExcelUtil;

public class ExcelRangeAddress {
    public static String RANGE_CELL_SEPARATOR = ":";
    public static String SHEET_DELIMITER = "!";
    private static final int INIT_ROW = 0;
    private static final int INIT_COLUMN = 1;
    private static final int LAST_ROW = 2;
    private static final int LAST_COLUMN = 3;
    private static final boolean REMOVE_DOLLAR_SIGN = true;
    private String range;
    private String sheet = null;

    public ExcelRangeAddress(String range) {
        String sFormatRange;
        assert (range != null) : "Never create empty ranges!";
        String[] splitRange = range.split(SHEET_DELIMITER);
        if (splitRange.length == 2) {
            this.sheet = splitRange[0];
            sFormatRange = splitRange[1];
        } else {
            sFormatRange = range;
        }
        this.range = sFormatRange = sFormatRange.replaceAll("\\$", "");
    }

    public ExcelRangeAddress(String sheet, int rowFrom, int colFrom, int rowTo, int colTo) {
        this.sheet = sheet;
        this.range = ExcelUtil.columnIntegerToName(colFrom) + String.valueOf(rowFrom) + RANGE_CELL_SEPARATOR;
        this.range = this.range + ExcelUtil.columnIntegerToName(colTo) + String.valueOf(rowTo);
    }

    public ExcelRangeAddress(String sheet, int row, int col) {
        this.sheet = sheet;
        this.range = ExcelUtil.columnIntegerToName(col) + String.valueOf(row);
    }

    public ExcelRangeAddress(int row, int col) {
        this.range = ExcelUtil.columnIntegerToName(col) + String.valueOf(row);
    }

    public int getInitRow() {
        return ExcelRangeAddress.getRangeDimension(this.range)[0];
    }

    public int getInitColumn() {
        return ExcelRangeAddress.getRangeDimension(this.range)[1];
    }

    public int getEndRow() {
        return ExcelRangeAddress.getRangeDimension(this.range)[2];
    }

    public int getEndColumn() {
        return ExcelRangeAddress.getRangeDimension(this.range)[3];
    }

    public int getNumRows() {
        int iniRow = this.getInitRow();
        int endRow = this.getEndRow();
        if (iniRow == -1 || endRow == -1) {
            return 0;
        }
        return endRow - iniRow + 1;
    }

    public int getNumColumns() {
        int iniCol = this.getInitColumn();
        int endCol = this.getEndColumn();
        if (iniCol == -1 || endCol == -1) {
            return 0;
        }
        return endCol - iniCol + 1;
    }

    public int size() {
        return this.getNumRows() * this.getNumColumns();
    }

    public String getRangeAddress() {
        if (this.sheet != null) {
            return this.sheet + SHEET_DELIMITER + this.range;
        }
        return this.range;
    }

    public String getRangeSheet() {
        return this.sheet;
    }

    private static int[] getRangeDimension(String range) {
        int[] lRet = new int[4];
        String[] rangeSplit = range.split(RANGE_CELL_SEPARATOR);
        if (rangeSplit.length == 2) {
            int[] ini = ExcelRangeAddress.cellCoodinates(rangeSplit[0]);
            int[] end = ExcelRangeAddress.cellCoodinates(rangeSplit[1]);
            lRet[0] = ini[0];
            lRet[1] = ini[1];
            lRet[2] = end[0];
            lRet[3] = end[1];
        } else {
            int[] ini = ExcelRangeAddress.cellCoodinates(range);
            lRet[0] = ini[0];
            lRet[1] = ini[1];
            lRet[2] = lRet[0];
            lRet[3] = lRet[1];
        }
        return lRet;
    }

    private static int[] cellCoodinates(String cellID) {
        int nCol = -1;
        int nRow = -1;
        try {
            String cell = cellID.toLowerCase();
            int cont = 0;
            for (char c : cell.toCharArray()) {
                if (c < 'a' || c > 'z') continue;
                ++cont;
            }
            String columnID = cell.substring(0, cont);
            String rowID = cell.substring(cont);
            nCol = ExcelUtil.columnNameToInteger(columnID);
            nRow = Integer.parseInt(rowID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new int[]{nRow, nCol};
    }

    public String println() {
        return this.getRangeAddress() + ":" + "(" + this.getInitRow() + "," + this.getInitColumn() + ");(" + this.getEndRow() + "," + this.getEndColumn() + ")";
    }

    public String toString() {
        return this.getRangeAddress();
    }

    public static ExcelRangeAddress parseRange(String range) {
        try {
            ExcelRangeAddress newRange = new ExcelRangeAddress(range);
            return newRange;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

