/*
 * Decompiled with CFR 0.152.
 */
package de.data;

import de.data.ExcelRangeAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExcelBlockAddress {
    public static String RANGE_BLOCK_SEPARATOR = ",";
    private final List<ExcelRangeAddress> ranges;

    public ExcelBlockAddress(ExcelRangeAddress ... ranges) {
        assert (ranges != null) : "Never create null blocks! Why you are you defining a null address??";
        this.ranges = new ArrayList<ExcelRangeAddress>();
        this.ranges.addAll(Arrays.asList(ranges));
    }

    public ExcelBlockAddress(String block) {
        assert (block != null) : "Never create null blocks! Why you are you defining a null address??";
        this.ranges = new ArrayList<ExcelRangeAddress>();
        if (block.contains(RANGE_BLOCK_SEPARATOR)) {
            String[] splitR;
            for (String r : splitR = block.split(RANGE_BLOCK_SEPARATOR)) {
                this.ranges.add(ExcelRangeAddress.parseRange(r.trim()));
            }
        } else {
            this.ranges.add(ExcelRangeAddress.parseRange(block.trim()));
        }
    }

    public ExcelRangeAddress[] getExcelRanges() {
        return this.ranges.toArray(new ExcelRangeAddress[0]);
    }

    public int getNumRanges() {
        return this.ranges.size();
    }
}

