/*
 * Decompiled with CFR 0.152.
 */
package de.data;

import de.edil.DE_Location;
import de.edil.DE_LocationExcel;

public class DE_ValidationException
extends Exception {
    private String entry;
    private String validation_rule;
    private DE_Location location;

    public DE_ValidationException(String message) {
        super(message);
    }

    public DE_ValidationException(String entry, String validation_rule) {
        this.entry = entry;
        this.validation_rule = validation_rule;
    }

    public DE_ValidationException(String entry, String validation_rule, String message) {
        super(message);
        this.entry = entry;
        this.validation_rule = validation_rule;
    }

    public DE_ValidationException(String entry, String validation_rule, String message, DE_Location location) {
        super(message);
        this.entry = entry;
        this.validation_rule = validation_rule;
        this.location = location;
    }

    @Override
    public String getLocalizedMessage() {
        String locMessage = "Validation error: ";
        if (this.getMessage() != null) {
            locMessage = locMessage + this.getMessage();
        }
        if (this.validation_rule != null) {
            locMessage = locMessage + ". Value '" + this.entry + "' does not satisfy validation rule '" + this.validation_rule + "'";
        }
        if (this.location != null) {
            locMessage = locMessage + "\n Source data file: '" + this.location.getSourcePath() + "'";
        }
        if (this.location instanceof DE_LocationExcel) {
            locMessage = locMessage + "\n Sheet: '" + ((DE_LocationExcel)this.location).getExcelSheetName() + "'; Range/Column: '" + ((DE_LocationExcel)this.location).getExcelRangeAdress() + "'";
        }
        return locMessage;
    }
}

