/*
 * Decompiled with CFR 0.152.
 */
package de.core.vsi;

import de.core.DeepEdit;
import de.core.ZFileViewer;
import de.core.vsi.PET_report;
import de.core.vsi.VSI_dataset;
import de.core.vsi.VSI_mapping;
import de.core.vsi.VSI_report;
import de.utils.DE_ChartFactory;
import de.utils.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;

public class VSI_mainPanel
extends JPanel {
    private int prevChartType = -1;
    private String currentOutput = "";
    private final VSI_report report;
    private String[] filters;
    private JFreeChart main_chart;
    private JRadioButtonMenuItem btnAreaChart;
    private JRadioButtonMenuItem btnAreaStack;
    private JRadioButtonMenuItem btnColumn;
    private JRadioButtonMenuItem btnColumnStack;
    private ButtonGroup btnGroupChartType;
    private JRadioButtonMenuItem btnLineChart;
    private JRadioButtonMenuItem btnPie;
    private JComboBox cboReportName;
    private JComboBox cboReportOptions;
    private JCheckBoxMenuItem chkChrono;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblEmpty;
    private JLabel lblMinChart;
    private JLabel lblMinTable;
    private JMenuBar mbChartArea;
    private JMenu menuChart;
    private JMenu menuOption;
    private JPanel pnlChartArea;
    private JPanel pnlChartMenu;
    private JPanel pnlControlChart;
    private JPanel pnlControlTable;
    private JSplitPane pnlMainSplit;
    private JPanel pnlTableArea;
    private JToolBar tbConfigTable;
    private JTable tblMain;

    public VSI_mainPanel(VSI_report report) {
        this.report = report;
        this.initComponents();
        this.initReport();
    }

    private void initReport() {
        if (this.report != null) {
            this.cboReportName.removeAllItems();
            if (this.report instanceof PET_report) {
                PET_report petreport = (PET_report)this.report;
                for (String sOutput : petreport.getNameList()) {
                    this.cboReportName.addItem(sOutput);
                }
            } else {
                for (String sFile : this.report.getFileList()) {
                    this.cboReportName.addItem(sFile);
                }
            }
        }
        this.pnlChartMenu.add(this.mbChartArea);
    }

    public void update() {
        String sName;
        String[] filter = this.getSelectedDatasetFilterArray();
        VSI_dataset dataset = this.report.getDataset(filter, sName = this.getSelectedOutput());
        if (dataset == null) {
            return;
        }
        this.setTableValues(dataset);
        this.setChartValues(dataset);
        this.repaint();
    }

    public void clearTableArea() {
        DefaultTableModel model = (DefaultTableModel)this.tblMain.getModel();
        model.setNumRows(0);
    }

    public void clearChartArea() {
        if (this.main_chart != null) {
            if (this.main_chart.getPlot() instanceof CategoryPlot) {
                CategoryPlot plot = this.main_chart.getCategoryPlot();
                for (int i = 0; i < plot.getDatasetCount(); ++i) {
                    ((DefaultCategoryDataset)plot.getDataset(i)).clear();
                }
                plot.clearDomainAxes();
                plot.clearRangeAxes();
            }
            this.main_chart.setTitle((String)null);
        }
    }

    public void setTableValues(VSI_dataset dataset) {
        VSI_mapping reportconfig = this.report.getConfigInfo();
        String report_name = this.getSelectedOutput();
        String id = this.getSelectedOutputID();
        String[] xFields = reportconfig.getXFields(id);
        String[] series1 = reportconfig.getYLeftSeries(id);
        String[] series2 = reportconfig.getYRightSeries(id);
        String[] y1 = reportconfig.getYLeftField(id);
        String[] y2 = reportconfig.getYRightField(id);
        this.clearTableArea();
        DefaultTableModel model = (DefaultTableModel)this.tblMain.getModel();
        model.setNumRows(0);
        for (Map.Entry<Object[], Object[]> entry : dataset.values().entrySet()) {
            int index_s;
            double dY;
            int i;
            int index;
            String sRange = "";
            String sSerie = "";
            String sY = "";
            Object[] identifiers = entry.getKey();
            Object[] values = entry.getValue();
            Object[] row = new Object[4];
            for (String x : xFields) {
                index = dataset.getIdentifierColumnIndex(x);
                sRange = sRange + " " + identifiers[index].toString();
            }
            row[0] = sRange;
            for (i = 0; i < y1.length; ++i) {
                index = dataset.getValueColumnIndex(y1[i]);
                sY = values[index].toString();
                dY = StringUtil.safeParseDouble(sY);
                if (series1 != null) {
                    index_s = dataset.getIdentifierColumnIndex(series1[i]);
                    sSerie = identifiers[index_s].toString();
                } else {
                    sSerie = y1[i];
                }
                row[1] = sSerie;
                row[2] = dY;
                model.addRow(row);
            }
            if (y2 == null) continue;
            for (i = 0; i < y2.length; ++i) {
                index = dataset.getValueColumnIndex(y2[i]);
                sY = values[index].toString();
                dY = StringUtil.safeParseDouble(sY);
                if (series2 != null) {
                    index_s = dataset.getIdentifierColumnIndex(series2[i]);
                    sSerie = identifiers[index_s].toString();
                } else {
                    sSerie = y2[i];
                }
                row[1] = sSerie;
                row[2] = dY;
                model.addRow(row);
            }
        }
    }

    public void setChartValues(VSI_dataset dataset) {
        VSI_mapping reportconfig = this.report.getConfigInfo();
        String report_name = this.getSelectedOutput();
        String id = this.getSelectedOutputID();
        String[] Filters = this.report.getFilterList(report_name);
        List<Object> lFilter = new ArrayList();
        if (Filters != null) {
            lFilter = Arrays.asList(Filters);
        }
        String sTitle = reportconfig.getTitle(id) + Arrays.toString(this.getSelectedFilters());
        String[] xFields = reportconfig.getXFields(id);
        String[] series1 = reportconfig.getYLeftSeries(id);
        String[] series2 = reportconfig.getYRightSeries(id);
        String[] y1 = reportconfig.getYLeftField(id);
        int[] y1_types = reportconfig.getYLeftType(id);
        int y1_charttype = y1_types != null ? y1_types[0] : this.getSelectedChartType();
        String[] y2 = reportconfig.getYRightField(id);
        int[] y2_types = reportconfig.getYRightType(id);
        int y2_charttype = y2_types != null ? y2_types[0] : this.getSelectedChartType();
        DefaultCategoryDataset datasetLeft = new DefaultCategoryDataset();
        DefaultCategoryDataset datasetRigth = null;
        ArrayList<Integer> lX_index = new ArrayList<Integer>();
        ArrayList<String> lX_labels = new ArrayList<String>();
        for (String xField : xFields) {
            if (lFilter.contains(xField)) continue;
            lX_index.add(dataset.getIdentifierColumnIndex(xField));
            lX_labels.add(xField);
        }
        LinkedList<Integer> lSeries1_index = new LinkedList<Integer>();
        LinkedList<String> lSeries1_labels = new LinkedList<String>();
        LinkedList<Integer> lY1_index = new LinkedList<Integer>();
        LinkedList<String> lY1_labels = new LinkedList<String>();
        for (String s : y1) {
            lY1_index.add(dataset.getValueColumnIndex(s));
            lY1_labels.add(s);
        }
        if (series1 != null) {
            for (String s : series1) {
                lSeries1_index.add(dataset.getIdentifierColumnIndex(s));
                lSeries1_labels.add(s);
            }
        }
        boolean useRightAxis = y2 != null;
        LinkedList<Integer> lSeries2_index = new LinkedList<Integer>();
        LinkedList<String> lSeries2_labels = new LinkedList<String>();
        LinkedList<Integer> lY2_index = new LinkedList<Integer>();
        LinkedList<String> lY2_labels = new LinkedList<String>();
        if (useRightAxis) {
            for (String s : y2) {
                lY2_index.add(dataset.getValueColumnIndex(s));
                lY2_labels.add(s);
            }
            if (series2 != null) {
                for (String s : series2) {
                    lSeries2_index.add(dataset.getIdentifierColumnIndex(s));
                    lSeries2_labels.add(s);
                }
            } else {
                lSeries2_index.addAll(lY2_index);
                lSeries2_labels.addAll(lY2_labels);
            }
            datasetRigth = new DefaultCategoryDataset();
        }
        for (Map.Entry<Object[], Object[]> entry : dataset.values().entrySet()) {
            double dY;
            int i;
            String sX = "";
            String sSerie = "";
            String sY = "";
            Object[] identifiers = entry.getKey();
            Object[] values = entry.getValue();
            Iterator i$ = lX_index.iterator();
            while (i$.hasNext()) {
                int x_index = (Integer)i$.next();
                sX = sX + identifiers[x_index];
            }
            for (i = 0; i < lY1_index.size(); ++i) {
                sSerie = series1 != null ? identifiers[(Integer)lSeries1_index.get(i)].toString() : (String)lY1_labels.get(i);
                sY = values[(Integer)lY1_index.get(i)].toString();
                dY = StringUtil.safeParseDouble(sY);
                datasetLeft.setValue(dY, (Comparable)((Object)sSerie), (Comparable)((Object)sX));
            }
            if (!useRightAxis) continue;
            for (i = 0; i < lY2_index.size(); ++i) {
                sSerie = series2 != null ? identifiers[(Integer)lSeries2_index.get(i)].toString() : (String)lY2_labels.get(i);
                sY = values[(Integer)lY2_index.get(i)].toString();
                dY = StringUtil.safeParseDouble(sY);
                datasetRigth.setValue(dY, (Comparable)((Object)sSerie), (Comparable)((Object)sX));
            }
        }
        if (this.main_chart != null && this.prevChartType != 2 && !useRightAxis) {
            y1_charttype = this.prevChartType;
        }
        this.main_chart = DE_ChartFactory.createCategoryChart(sTitle, (CategoryDataset)datasetLeft, Arrays.toString(lY1_labels.toArray()), y1_charttype, (CategoryDataset)datasetRigth, Arrays.toString(lY2_labels.toArray()), y2_charttype, Arrays.toString(lX_labels.toArray()));
        this.chkChrono.setSelected(true);
        this.setChartView(y1_charttype, this.main_chart);
    }

    private void setChartView(int chartType, JFreeChart chart) {
        if (chartType == 2) {
            CategoryDataset datasetLeft = chart.getCategoryPlot().getDataset();
            PieDataset pie_dataset = DatasetUtilities.createPieDatasetForColumn((CategoryDataset)datasetLeft, (int)1);
            JFreeChart pieChart = DE_ChartFactory.createPieChart(chart.getTitle().getText(), pie_dataset);
            ChartPanel chartPanel = new ChartPanel(pieChart);
            this.jScrollPane2.setViewportView((Component)chartPanel);
        } else {
            ChartPanel chartPanel = new ChartPanel(chart);
            this.jScrollPane2.setViewportView((Component)chartPanel);
        }
        this.prevChartType = chartType;
    }

    public void setChartType(int newChartType) {
        int currentChartType;
        if (this.main_chart != null && (currentChartType = this.getSelectedChartType()) != this.prevChartType) {
            if (newChartType == 2) {
                this.setChartView(newChartType, this.main_chart);
            } else {
                DE_ChartFactory.changeCategoryChartType(this.main_chart, newChartType);
                if (this.prevChartType == 2) {
                    this.setChartView(newChartType, this.main_chart);
                }
            }
            this.prevChartType = currentChartType;
        }
    }

    private void showBoth() {
        this.pnlMainSplit.setDividerLocation(0.5);
    }

    private void hideTable() {
        this.pnlMainSplit.setDividerLocation(1.0);
    }

    private void hideChart() {
        this.pnlMainSplit.setDividerLocation(0.0);
    }

    private String[] getSelectedFilters() {
        LinkedHashMap<String, String> mFilter = new LinkedHashMap<String, String>();
        for (Component c : this.tbConfigTable.getComponents()) {
            if (c.getName() == null || !c.getName().startsWith("vsi_")) continue;
            String field_name = c.getName().replaceFirst("vsi_", "");
            String filter_value = ((JComboBox)c).getSelectedItem().toString();
            String oldVal = mFilter.put(field_name, filter_value);
        }
        return mFilter.values().toArray(new String[mFilter.size()]);
    }

    private String[] getSelectedDatasetFilterArray() {
        return this.getSelectedDatasetFilterList().toArray(new String[0]);
    }

    private Collection<String> getSelectedDatasetFilterList() {
        LinkedHashMap<String, String> mFilter = new LinkedHashMap<String, String>();
        VSI_mapping reportconfig = this.report.getConfigInfo();
        String report_name = this.getSelectedOutput();
        String id = this.getSelectedOutputID();
        String[] identifiers = reportconfig.getDatasetIdentifiers(id);
        assert (identifiers != null) : "Error in vsi mapping file! Identifiers fields can never be null!";
        for (String si : identifiers) {
            mFilter.put(si, null);
        }
        for (Component c : this.tbConfigTable.getComponents()) {
            if (c.getName() == null || !c.getName().startsWith("vsi_")) continue;
            String field_name = c.getName().replaceFirst("vsi_", "");
            String filter_value = ((JComboBox)c).getSelectedItem().toString();
            String oldVal = mFilter.put(field_name, filter_value);
        }
        return mFilter.values();
    }

    private String getSelectedOutput() {
        return this.cboReportName.getSelectedItem().toString();
    }

    private String getSelectedOutputID() {
        VSI_mapping reportconfig = this.report.getConfigInfo();
        String name = this.getSelectedOutput();
        for (String id : reportconfig.getIds()) {
            String id_name = reportconfig.getName(id);
            if (!name.equalsIgnoreCase(id_name)) continue;
            return id;
        }
        assert (false) : "Why we couldn't find a value in combobox??" + name;
        return null;
    }

    private void clearGUIFilters() {
        for (Component c : this.tbConfigTable.getComponents()) {
            if (c.getName() == null || !c.getName().startsWith("vsi_")) continue;
            this.tbConfigTable.remove(c);
        }
        this.tbConfigTable.revalidate();
        this.tbConfigTable.repaint();
    }

    private void updateGUIFilters() {
        String[] Filters = this.report.getFilterList(this.currentOutput);
        if (Filters != null) {
            for (String s : Filters) {
                String[] oList = this.report.getFilterValues(s, this.currentOutput);
                JComboBox<String> cboFilter = new JComboBox<String>(oList);
                cboFilter.setName("vsi_" + s);
                cboFilter.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VSI_mainPanel.this.cboFilterActionPerformed(e);
                    }
                });
                this.tbConfigTable.add(cboFilter);
                this.tbConfigTable.revalidate();
                this.tbConfigTable.repaint();
            }
        }
    }

    private void setOutputFile() {
        assert (this.currentOutput != null) : "Never use null here!";
        this.clearGUIFilters();
        this.clearTableArea();
        this.clearChartArea();
        String csvFile = this.report instanceof PET_report ? ((PET_report)this.report).getFullPathFile(this.currentOutput) : this.currentOutput;
        if (csvFile == null) {
            return;
        }
        if (this.report.getDatasetIdentifiers(this.currentOutput) == null) {
            ZFileViewer MyZFileViewer = new ZFileViewer(DeepEdit.frame, csvFile);
            MyZFileViewer.setVisible(true);
            return;
        }
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    VSI_mainPanel.this.report.parseFile(VSI_mainPanel.this.currentOutput);
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
                return null;
            }

            @Override
            public void done() {
                VSI_mainPanel.this.clearGUIFilters();
                VSI_mainPanel.this.updateGUIFilters();
                VSI_mainPanel.this.update();
            }
        };
        worker.execute();
    }

    private void cboFilterActionPerformed(ActionEvent e) {
        this.update();
    }

    private int getSelectedChartType() {
        if (this.btnAreaChart.isSelected()) {
            return 5;
        }
        if (this.btnAreaStack.isSelected()) {
            return 7;
        }
        if (this.btnColumn.isSelected()) {
            return 4;
        }
        if (this.btnColumnStack.isSelected()) {
            return 6;
        }
        if (this.btnLineChart.isSelected()) {
            return 3;
        }
        if (this.btnPie.isSelected()) {
            return 2;
        }
        return 3;
    }

    private void initComponents() {
        this.mbChartArea = new JMenuBar();
        this.menuChart = new JMenu();
        this.btnAreaChart = new JRadioButtonMenuItem();
        this.btnLineChart = new JRadioButtonMenuItem();
        this.btnAreaStack = new JRadioButtonMenuItem();
        this.btnColumn = new JRadioButtonMenuItem();
        this.btnColumnStack = new JRadioButtonMenuItem();
        this.btnPie = new JRadioButtonMenuItem();
        this.menuOption = new JMenu();
        this.chkChrono = new JCheckBoxMenuItem();
        this.btnGroupChartType = new ButtonGroup();
        this.pnlMainSplit = new JSplitPane();
        this.pnlChartArea = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.pnlControlChart = new JPanel();
        this.lblMinChart = new JLabel();
        this.pnlChartMenu = new JPanel();
        this.lblEmpty = new JLabel();
        this.pnlTableArea = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblMain = new JTable();
        this.tbConfigTable = new JToolBar();
        this.cboReportName = new JComboBox();
        this.cboReportOptions = new JComboBox();
        this.pnlControlTable = new JPanel();
        this.lblMinTable = new JLabel();
        this.menuChart.setText("Chart");
        this.btnGroupChartType.add(this.btnAreaChart);
        this.btnAreaChart.setSelected(true);
        this.btnAreaChart.setText("Area");
        this.btnAreaChart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSI_mainPanel.this.btnAreaChartActionPerformed(evt);
            }
        });
        this.menuChart.add(this.btnAreaChart);
        this.btnGroupChartType.add(this.btnLineChart);
        this.btnLineChart.setText("Line");
        this.btnLineChart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSI_mainPanel.this.btnLineChartActionPerformed(evt);
            }
        });
        this.menuChart.add(this.btnLineChart);
        this.btnGroupChartType.add(this.btnAreaStack);
        this.btnAreaStack.setText("AreaStack");
        this.btnAreaStack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSI_mainPanel.this.btnAreaStackActionPerformed(evt);
            }
        });
        this.menuChart.add(this.btnAreaStack);
        this.btnGroupChartType.add(this.btnColumn);
        this.btnColumn.setText("Column");
        this.btnColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSI_mainPanel.this.btnColumnActionPerformed(evt);
            }
        });
        this.menuChart.add(this.btnColumn);
        this.btnGroupChartType.add(this.btnColumnStack);
        this.btnColumnStack.setText("ColumnStack");
        this.btnColumnStack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSI_mainPanel.this.btnColumnStackActionPerformed(evt);
            }
        });
        this.menuChart.add(this.btnColumnStack);
        this.btnGroupChartType.add(this.btnPie);
        this.btnPie.setText("Pie");
        this.btnPie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSI_mainPanel.this.btnPieActionPerformed(evt);
            }
        });
        this.menuChart.add(this.btnPie);
        this.mbChartArea.add(this.menuChart);
        this.menuOption.setText("Options");
        this.chkChrono.setSelected(true);
        this.chkChrono.setText("Chronological");
        this.chkChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSI_mainPanel.this.chkChronoActionPerformed(evt);
            }
        });
        this.menuOption.add(this.chkChrono);
        this.mbChartArea.add(this.menuOption);
        this.setPreferredSize(new Dimension(600, 400));
        this.pnlMainSplit.setDividerLocation(298);
        this.pnlMainSplit.setDividerSize(4);
        this.pnlMainSplit.setResizeWeight(0.5);
        this.pnlMainSplit.setToolTipText("");
        this.lblMinChart.setText("<<");
        this.lblMinChart.setToolTipText("Show Table");
        this.lblMinChart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                VSI_mainPanel.this.lblMinChartMouseReleased(evt);
            }
        });
        GroupLayout pnlControlChartLayout = new GroupLayout(this.pnlControlChart);
        this.pnlControlChart.setLayout(pnlControlChartLayout);
        pnlControlChartLayout.setHorizontalGroup(pnlControlChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlControlChartLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.lblMinChart)));
        pnlControlChartLayout.setVerticalGroup(pnlControlChartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlChartLayout.createSequentialGroup().addContainerGap().addComponent(this.lblMinChart).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlChartMenu.setLayout(new BorderLayout());
        this.lblEmpty.setText(" ");
        this.pnlChartMenu.add((Component)this.lblEmpty, "Center");
        GroupLayout pnlChartAreaLayout = new GroupLayout(this.pnlChartArea);
        this.pnlChartArea.setLayout(pnlChartAreaLayout);
        pnlChartAreaLayout.setHorizontalGroup(pnlChartAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlControlChart, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2).addComponent(this.pnlChartMenu, -1, -1, Short.MAX_VALUE));
        pnlChartAreaLayout.setVerticalGroup(pnlChartAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlChartAreaLayout.createSequentialGroup().addComponent(this.pnlChartMenu, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jScrollPane2, -1, 348, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.pnlControlChart, -2, -1, -2)));
        this.pnlMainSplit.setLeftComponent(this.pnlChartArea);
        this.tblMain.setAutoCreateRowSorter(true);
        this.tblMain.setModel(new DefaultTableModel(new Object[0][], new String[]{"Domain", "Series", "Range"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Object.class, Double.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblMain.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblMain);
        this.tbConfigTable.setFloatable(false);
        this.tbConfigTable.setRollover(true);
        this.cboReportName.setModel(new DefaultComboBoxModel<String>(new String[]{"Report"}));
        this.cboReportName.setName("cboReportName");
        this.cboReportName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VSI_mainPanel.this.cboReportNameActionPerformed(evt);
            }
        });
        this.tbConfigTable.add(this.cboReportName);
        this.cboReportOptions.setModel(new DefaultComboBoxModel<String>(new String[]{"+"}));
        this.cboReportOptions.setMaximumSize(new Dimension(56, 30));
        this.tbConfigTable.add(this.cboReportOptions);
        this.lblMinTable.setText(">>");
        this.lblMinTable.setToolTipText("Show Chart");
        this.lblMinTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                VSI_mainPanel.this.lblMinTableMouseReleased(evt);
            }
        });
        GroupLayout pnlControlTableLayout = new GroupLayout(this.pnlControlTable);
        this.pnlControlTable.setLayout(pnlControlTableLayout);
        pnlControlTableLayout.setHorizontalGroup(pnlControlTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlTableLayout.createSequentialGroup().addComponent(this.lblMinTable).addGap(0, 280, Short.MAX_VALUE)));
        pnlControlTableLayout.setVerticalGroup(pnlControlTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlTableLayout.createSequentialGroup().addContainerGap().addComponent(this.lblMinTable).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pnlTableAreaLayout = new GroupLayout(this.pnlTableArea);
        this.pnlTableArea.setLayout(pnlTableAreaLayout);
        pnlTableAreaLayout.setHorizontalGroup(pnlTableAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addComponent(this.tbConfigTable, -1, -1, Short.MAX_VALUE).addComponent(this.pnlControlTable, -2, -1, -2));
        pnlTableAreaLayout.setVerticalGroup(pnlTableAreaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlTableAreaLayout.createSequentialGroup().addComponent(this.tbConfigTable, -2, 25, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 335, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.pnlControlTable, -2, -1, -2)));
        this.pnlMainSplit.setRightComponent(this.pnlTableArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMainSplit));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMainSplit));
    }

    private void lblMinTableMouseReleased(MouseEvent evt) {
        int pos = this.pnlMainSplit.getDividerLocation();
        if (pos == 0) {
            this.showBoth();
        } else {
            this.hideTable();
        }
    }

    private void lblMinChartMouseReleased(MouseEvent evt) {
        int pos = this.pnlMainSplit.getDividerLocation();
        if (pos == 0) {
            this.showBoth();
        } else {
            this.hideChart();
        }
    }

    private void cboReportNameActionPerformed(ActionEvent evt) {
        Object oSource = evt.getSource();
        if (oSource instanceof JComboBox) {
            Object oFile = this.cboReportName.getSelectedItem();
            if (oFile == null) {
                return;
            }
            if (!this.currentOutput.equalsIgnoreCase(oFile.toString())) {
                this.currentOutput = oFile.toString();
                this.setOutputFile();
            }
        }
    }

    private void btnAreaChartActionPerformed(ActionEvent evt) {
        this.setChartType(5);
    }

    private void btnLineChartActionPerformed(ActionEvent evt) {
        this.setChartType(3);
    }

    private void btnAreaStackActionPerformed(ActionEvent evt) {
        this.setChartType(7);
    }

    private void btnColumnActionPerformed(ActionEvent evt) {
        this.setChartType(4);
    }

    private void btnColumnStackActionPerformed(ActionEvent evt) {
        this.setChartType(6);
    }

    private void btnPieActionPerformed(ActionEvent evt) {
        this.setChartType(2);
    }

    private void chkChronoActionPerformed(ActionEvent evt) {
        JCheckBoxMenuItem chkBox;
        Object o = evt.getSource();
        if (o instanceof JCheckBoxMenuItem && !(chkBox = (JCheckBoxMenuItem)o).isSelected()) {
            DE_ChartFactory.sortDataset(this.main_chart, 0, true, true);
        }
    }
}

