/*
 * Decompiled with CFR 0.152.
 */
package de.core.vsi;

import de.core.DeepEdit;
import de.core.vsi.VSI_dataset;
import de.utils.StringUtil;
import de.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VSI_handler
implements Runnable {
    private List<String> lDatasetFile = new LinkedList<String>();
    private int maxFileSize = 50;
    private VSI_dataset unique_dataset;
    private Map<String, Integer>[] mIndex;
    private boolean autoIndex;
    private final Map<String, Integer> mId_ColPos = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> mVal_ColPos = new LinkedHashMap<String, Integer>();

    public VSI_handler() {
        this.maxFileSize = (int)DeepEdit.getDoubleOptionValue("VSI_maxFileSize");
        if (this.maxFileSize <= 0) {
            this.maxFileSize = 50;
            assert (false) : "What went wrong with config file? this value will crash the handler!";
        }
    }

    public VSI_handler(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        assert (maxFileSize > 0) : "Never use zero or negative size. this value will crash the handler!";
    }

    public void parseCSVFile(String fileName, String[] Header, String[] values, boolean createBin, boolean autoIndex) throws IOException {
        int nParts;
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        double sizeInMB = f.length() / 0x100000L;
        int nLines = Utils.countLinesInFile(fileName);
        int maxLines = (int)((double)nLines / (double)(nParts = (int)Math.floor(sizeInMB / (double)this.maxFileSize) + 1));
        if (maxLines > nLines) {
            createBin = false;
        }
        this.mId_ColPos.clear();
        this.mVal_ColPos.clear();
        int cont = 0;
        for (String h : Header) {
            this.mId_ColPos.put(h, cont);
            ++cont;
        }
        cont = 0;
        for (String v : values) {
            this.mVal_ColPos.put(v, cont);
            ++cont;
        }
        this.unique_dataset = null;
        this.lDatasetFile.clear();
        VSI_dataset dataset = new VSI_dataset(Header, values);
        int nTotalColumns = dataset.getNumIdentifiers() + dataset.getNumValues();
        LinkedHashMap<String, Integer> mId_csvColPos = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> mVal_csvColPos = new LinkedHashMap<String, Integer>();
        BufferedReader fileReader = new BufferedReader(new FileReader(fileName));
        String line = fileReader.readLine();
        if (line == null) {
            return;
        }
        String[] tokens = line.split(",");
        if (tokens.length > 0 && tokens.length >= nTotalColumns) {
            String sCellValue;
            block2: for (String id : Header) {
                for (int i = 0; i < tokens.length; ++i) {
                    sCellValue = StringUtil.trimAndRemoveQuotes(tokens[i]);
                    if (!id.equalsIgnoreCase(sCellValue)) continue;
                    mId_csvColPos.put(sCellValue, i);
                    continue block2;
                }
            }
            block4: for (String val : values) {
                for (int i = 0; i < tokens.length; ++i) {
                    sCellValue = StringUtil.trimAndRemoveQuotes(tokens[i]);
                    if (!val.equalsIgnoreCase(sCellValue)) continue;
                    mVal_csvColPos.put(sCellValue, i);
                    continue block4;
                }
            }
        }
        this.autoIndex = autoIndex;
        if (autoIndex) {
            this.mIndex = new Map[Header.length];
            for (int i = 0; i < Header.length; ++i) {
                this.mIndex[i] = new LinkedHashMap<String, Integer>();
            }
        }
        int contLine = 2;
        int contFile = 0;
        while ((line = fileReader.readLine()) != null) {
            tokens = line.split(",");
            if (tokens.length > 0 && tokens.length >= nTotalColumns) {
                String[] identifiers = new String[dataset.getNumIdentifiers()];
                cont = 0;
                Iterator<Object> i$ = mId_csvColPos.values().iterator();
                while (i$.hasNext()) {
                    String sCellValue;
                    int n = (Integer)i$.next();
                    identifiers[cont] = sCellValue = StringUtil.trimAndRemoveQuotes(tokens[n]);
                    if (autoIndex) {
                        this.mIndex[cont].put(sCellValue, n);
                    }
                    ++cont;
                }
                for (Map.Entry entry : mVal_csvColPos.entrySet()) {
                    int nColVal = (Integer)entry.getValue();
                    String nameVal = (String)entry.getKey();
                    dataset.put(nameVal, StringUtil.trimAndRemoveQuotes(tokens[nColVal]), identifiers);
                }
            }
            if (createBin && contLine % maxLines == 0) {
                String binFile = DeepEdit.createTempFile("~de_", ".bin").getAbsolutePath();
                this.writeDatasetToDisk(dataset, binFile);
                dataset = null;
                dataset = new VSI_dataset(Header, values);
                this.lDatasetFile.add(binFile);
                ++contFile;
            }
            ++contLine;
        }
        fileReader.close();
        if (!createBin) {
            this.unique_dataset = dataset;
            this.lDatasetFile.clear();
        }
        if (createBin) {
            String binFile = DeepEdit.createTempFile("~de_", ".bin").getAbsolutePath();
            this.writeDatasetToDisk(dataset, binFile);
            this.lDatasetFile.add(binFile);
            dataset = null;
            this.unique_dataset = null;
        }
    }

    public Object[][] get(String ... identifiers) {
        if (this.unique_dataset != null) {
            return this.unique_dataset.get(identifiers);
        }
        Object[][] lRet = new Object[0][0];
        try {
            for (String datasetFile : this.lDatasetFile) {
                VSI_dataset dataset = this.readDatasetFromDisk(datasetFile);
                if (identifiers == null) {
                    identifiers = dataset.getNullIdenfier();
                }
                Object[][] lRows = dataset.get(identifiers);
                lRet = this.append2DRows(lRet, lRows);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return lRet;
    }

    public Object[] getColumnSet(String columnName) {
        assert (this.mId_ColPos.get(columnName) != null) : "Why '" + columnName + "' couldn't be found???? Are you parsing a different file?";
        return this.getColumnSet(this.mId_ColPos.get(columnName));
    }

    public Object[] getColumnSet(int index) {
        if (this.unique_dataset != null) {
            assert (index < this.unique_dataset.getNumIdentifiers()) : "Why are you querying " + index + " column id when this dataset has only " + this.unique_dataset.getNumIdentifiers() + " identifiers??";
            Set<String> lVal = this.unique_dataset.getColumnIdentifiers(index);
            return lVal.toArray();
        }
        if (this.autoIndex) {
            assert (index < this.mIndex.length) : "Why are you querying " + index + " column id when this dataset has only " + this.mIndex.length + " identifiers??";
            return this.mIndex[index].keySet().toArray();
        }
        LinkedHashSet<String> lRet = new LinkedHashSet<String>();
        try {
            for (String datasetFile : this.lDatasetFile) {
                VSI_dataset dataset = this.readDatasetFromDisk(datasetFile);
                assert (index < dataset.getNumIdentifiers()) : "Why are you querying " + index + " column id when this dataset has only " + dataset.getNumIdentifiers() + " identifiers??";
                lRet.addAll(dataset.getColumnIdentifiers(index));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return lRet.toArray();
    }

    public VSI_dataset getDataset() throws IOException {
        return this.getDataset(0, null, null);
    }

    public VSI_dataset getDataset(int operation_id, String[] groupBy, String[] identifiers) throws IOException {
        if (this.unique_dataset != null) {
            return this.unique_dataset.getDataset(operation_id, groupBy, identifiers);
        }
        VSI_dataset dataset = null;
        for (String datasetName : this.lDatasetFile) {
            VSI_dataset file_dataset = this.readDatasetFromDisk(datasetName);
            if (file_dataset == null) continue;
            VSI_dataset subdataset = file_dataset.getDataset(operation_id, groupBy, identifiers);
            if (dataset == null) {
                dataset = new VSI_dataset(file_dataset.getIdentifierNames(), file_dataset.getValueNames());
            }
            if (subdataset.isEmpty()) continue;
            dataset.add(subdataset);
        }
        return dataset;
    }

    public int indexOfIdentifier(String identifier) {
        Integer index = this.mId_ColPos.get(identifier);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public int indexOfValue(String valueHeader) {
        Integer index = this.mVal_ColPos.get(valueHeader);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public int getTotalIdentifierColumns() {
        return this.mId_ColPos.size();
    }

    public int getTotalValueColumns() {
        return this.mVal_ColPos.size();
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    private VSI_dataset readDatasetFromDisk(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ObjectInputStream objIs = new ObjectInputStream(bis);
        try {
            Object o = objIs.readObject();
            if (o instanceof VSI_dataset) {
                return (VSI_dataset)o;
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        return null;
    }

    private void writeDatasetToDisk(VSI_dataset dataset, String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(dataset);
        oos.close();
    }

    private Object[][] append2DRows(Object[][] original, Object[][] toappend) {
        int nRows = original.length + toappend.length;
        Object[][] lRet = new Object[nRows][];
        System.arraycopy(original, 0, lRet, 0, original.length);
        System.arraycopy(toappend, 0, lRet, original.length, toappend.length);
        return lRet;
    }

    @Override
    public void run() {
    }
}

