/*
 * Decompiled with CFR 0.152.
 */
package de.core.vsi;

import de.core.vsi.DatasetEntry;
import de.utils.StringUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VSI_dataset
implements Serializable {
    private String name;
    private int nIdColumn;
    private int nValColumn;
    private int nSize = 0;
    private LinkedHashMap<String, Object> mDataID;
    private LinkedHashMap<String, Integer> mHeader_ID;
    private LinkedHashMap<String, Integer> mHeader_Val;
    public static final String COMMA_DELIMITER = ",";
    public static final int OPERA_LAST_VALUE = 0;
    public static final int OPERA_SUM = 1;
    public static final int OPERA_AVG = 2;
    public static final int OPERA_MAX = 3;
    public static final int OPERA_MIN = 4;
    public static final int OPERA_COUNT = 5;

    public VSI_dataset(String[] headerIdentifiers, String[] headerValues) {
        int i;
        this.mHeader_ID = new LinkedHashMap(headerIdentifiers.length);
        this.mHeader_Val = new LinkedHashMap(headerValues.length);
        this.nIdColumn = headerIdentifiers.length;
        this.nValColumn = headerValues.length;
        assert (this.nIdColumn > 1) : "Datasets are objects to store a tabular data with (at least) 2 identifiers. If only 1 identifier is needed use maps instead!";
        assert (this.nValColumn > 0) : "Datasets are objects to store a tabular data with (at least) 1 value";
        this.mDataID = new LinkedHashMap();
        for (i = 0; i < this.nIdColumn; ++i) {
            this.mHeader_ID.put(headerIdentifiers[i], i);
        }
        for (i = 0; i < this.nValColumn; ++i) {
            this.mHeader_Val.put(headerValues[i], i);
        }
    }

    public void add(VSI_dataset dataset) {
        if (dataset.getNumValues() != this.nValColumn || dataset.getNumIdentifiers() != this.nIdColumn) {
            return;
        }
        for (Map.Entry<Object[], Object[]> oEntry : dataset.values().entrySet()) {
            Object[] ids = oEntry.getKey();
            Object[] val = oEntry.getValue();
            int cont = 0;
            for (Object o : val) {
                this.put(dataset.getValueNames()[cont], o, (String[])Arrays.copyOf(ids, ids.length, String[].class));
                ++cont;
            }
        }
    }

    public void put(String valueName, Object value, String ... identifiers) {
        LinkedHashMap<String, Object> mParent = this.mDataID;
        if (identifiers.length != this.nIdColumn) {
            throw new IndexOutOfBoundsException("Invalid number of arguments '" + identifiers.length + "'. Dataset '" + this.name + "' currently has '" + this.nIdColumn + "' columns");
        }
        for (int i = 0; i < this.nIdColumn; ++i) {
            LinkedHashMap<String, Object> mCurrent = (LinkedHashMap<String, Object>)mParent.get(identifiers[i]);
            if (mCurrent == null) {
                mCurrent = new LinkedHashMap<String, Object>();
                mParent.put(identifiers[i], mCurrent);
            }
            if (i == this.nIdColumn - 1) {
                this.putInMap(mCurrent, identifiers[i], 0, valueName, value);
                ++this.nSize;
            }
            mParent = mCurrent;
        }
    }

    private void putInMap(Map<String, Object> mValues, String identifier, int operation_id, String valueName, Object value) {
        Object[] valArray = (Object[])mValues.get(identifier);
        if (valArray == null) {
            valArray = new Object[this.nValColumn];
        }
        int index = this.mHeader_Val.get(valueName);
        switch (operation_id) {
            case 0: {
                valArray[index] = value;
                mValues.put(identifier, valArray);
                break;
            }
            case 1: {
                Object oprev = valArray[index];
                if (oprev != null) {
                    double dPrevVal = StringUtil.safeParseDouble(oprev.toString(), Double.MAX_VALUE);
                    double dCurrVal = StringUtil.safeParseDouble(value.toString(), Double.MAX_VALUE);
                    if (dCurrVal != Double.MAX_VALUE) {
                        valArray[index] = String.valueOf(dCurrVal + dPrevVal);
                    }
                } else {
                    valArray[index] = value;
                }
                mValues.put(identifier, valArray);
                break;
            }
            case 3: {
                Object oprev = valArray[index];
                if (oprev != null) {
                    double dCurrVal = StringUtil.safeParseDouble(oprev.toString(), Double.MAX_VALUE);
                    double dPrevVal = StringUtil.safeParseDouble(value.toString(), Double.MAX_VALUE);
                    if (dCurrVal != Double.MAX_VALUE) {
                        valArray[index] = String.valueOf(Math.max(dCurrVal, dPrevVal));
                    }
                } else {
                    mValues.put(valueName, value);
                }
                mValues.put(identifier, valArray);
                break;
            }
            case 4: {
                Object oprev = valArray[index];
                if (oprev != null) {
                    double dCurrVal = StringUtil.safeParseDouble(oprev.toString(), Double.MAX_VALUE);
                    double dPrevVal = StringUtil.safeParseDouble(value.toString(), Double.MAX_VALUE);
                    if (dCurrVal != Double.MAX_VALUE) {
                        valArray[index] = String.valueOf(Math.min(dCurrVal, dPrevVal));
                    }
                } else {
                    mValues.put(valueName, value);
                }
                mValues.put(identifier, valArray);
                break;
            }
            default: {
                assert (false) : "Unsupported operation!!";
                break;
            }
        }
    }

    public Object[][] get(String ... identifiers) {
        if (identifiers == null) {
            identifiers = this.getNullIdenfier();
        }
        String[] tempIds = Arrays.copyOf(identifiers, this.nIdColumn);
        identifiers = tempIds;
        List<Object> lValues = VSI_dataset.getValues(0, identifiers, this.mDataID);
        Object[][] lRet = new Object[lValues.size()][];
        for (int i = 0; i < lValues.size(); ++i) {
            Object[] row = new Object[this.nIdColumn + this.nValColumn];
            Object o = lValues.get(i);
            if (o instanceof DatasetEntry) {
                DatasetEntry entry = (DatasetEntry)o;
                System.arraycopy(entry.getIdentifiers(), 0, row, 0, entry.getIdentifiers().length);
                System.arraycopy(entry.getValues(), 0, row, this.nIdColumn, entry.getValues().length);
            }
            lRet[i] = row;
        }
        return lRet;
    }

    public Object[][] getTotal(int operation_id, String[] groupBy, String[] identifiers) {
        if (identifiers == null) {
            identifiers = this.getNullIdenfier();
        }
        if (groupBy == null) {
            groupBy = this.getNullIdenfier();
        }
        String[] headerIDNames = this.getIdentifierNames();
        String[] lGroup = this.getNullIdenfier();
        for (String s : groupBy) {
            Integer Index;
            if (s == null || (Index = this.mHeader_ID.get(s)) == null) continue;
            lGroup[Index.intValue()] = s;
        }
        String[] tempIds = Arrays.copyOf(identifiers, this.nIdColumn);
        identifiers = tempIds;
        List<Object> lValues = VSI_dataset.getValues(0, identifiers, this.mDataID);
        LinkedHashMap<String, Object[]> mRet = new LinkedHashMap<String, Object[]>();
        for (Object lValue : lValues) {
            Object[] row = new Object[this.nIdColumn + this.nValColumn];
            Object oEntry = lValue;
            if (!(oEntry instanceof DatasetEntry)) continue;
            DatasetEntry entry = (DatasetEntry)oEntry;
            String id = "";
            String[] mod_id_row = entry.getIdentifiers();
            for (int k = 0; k < mod_id_row.length; ++k) {
                if (lGroup[k] != null) continue;
                mod_id_row[k] = headerIDNames[k];
            }
            for (String s : mod_id_row) {
                id = id + "_" + s;
            }
            System.arraycopy(mod_id_row, 0, row, 0, mod_id_row.length);
            System.arraycopy(entry.getValues(), 0, row, this.nIdColumn, entry.getValues().length);
            Object[] oPrev = (Object[])mRet.get(id);
            switch (operation_id) {
                case 1: {
                    double dCurr;
                    int k;
                    if (oPrev != null) {
                        for (k = this.nIdColumn; k < row.length; ++k) {
                            double dPrev = StringUtil.safeParseDouble(oPrev[k].toString(), Double.MAX_VALUE);
                            dCurr = StringUtil.safeParseDouble(row[k].toString(), Double.MAX_VALUE);
                            assert (dCurr != Double.MAX_VALUE) : "why value column couldn't be parsed to double?";
                            row[k] = String.valueOf(dPrev + dCurr);
                        }
                    }
                    mRet.put(id, row);
                    break;
                }
                case 3: {
                    double dCurr;
                    int k;
                    if (oPrev != null) {
                        for (k = this.nIdColumn; k < row.length; ++k) {
                            double dPrev = StringUtil.safeParseDouble(oPrev[k].toString(), Double.MAX_VALUE);
                            dCurr = StringUtil.safeParseDouble(row[k].toString(), Double.MAX_VALUE);
                            assert (dCurr != Double.MAX_VALUE) : "why value column couldn't be parsed to double?";
                            row[k] = String.valueOf(Math.max(dPrev, dCurr));
                        }
                    }
                    mRet.put(id, row);
                    break;
                }
                case 4: {
                    double dCurr;
                    int k;
                    if (oPrev != null) {
                        for (k = this.nIdColumn; k < row.length; ++k) {
                            double dPrev = StringUtil.safeParseDouble(oPrev[k].toString(), Double.MAX_VALUE);
                            dCurr = StringUtil.safeParseDouble(row[k].toString(), Double.MAX_VALUE);
                            assert (dCurr != Double.MAX_VALUE) : "why value column couldn't be parsed to double?";
                            row[k] = String.valueOf(Math.min(dPrev, dCurr));
                        }
                    }
                    mRet.put(id, row);
                    break;
                }
                case 0: {
                    mRet.put(id, row);
                    break;
                }
                case 2: {
                    assert (false) : "NOT implemented yet!!";
                    break;
                }
                case 5: {
                    int k;
                    if (oPrev != null) {
                        for (k = this.nIdColumn; k < row.length; ++k) {
                            int dPrev = StringUtil.safeParseInt(oPrev[k].toString(), Integer.MAX_VALUE);
                            assert (dPrev != Integer.MAX_VALUE) : "How could this be a non-integer? why value column couldn't be parsed to double?";
                            row[k] = String.valueOf(dPrev + 1);
                        }
                    } else {
                        for (k = this.nIdColumn; k < row.length; ++k) {
                            row[k] = String.valueOf(1);
                        }
                    }
                    mRet.put(id, row);
                }
            }
        }
        return (Object[][])mRet.values().toArray((T[])new Object[0][0]);
    }

    public VSI_dataset getDataset(int operation_id, String[] groupBy, String[] identifiers) {
        Object[][] oValues;
        if (identifiers == null) {
            identifiers = this.getNullIdenfier();
        }
        String[] headerIds = this.mHeader_ID.keySet().toArray(new String[this.nIdColumn]);
        String[] headerValues = this.mHeader_Val.keySet().toArray(new String[this.nValColumn]);
        VSI_dataset dataset = new VSI_dataset(headerIds, headerValues);
        for (Object[] oRow : oValues = this.getTotal(operation_id, groupBy, identifiers)) {
            String[] new_identifier = new String[this.nIdColumn];
            String[] new_values = new String[this.nValColumn];
            System.arraycopy(oRow, 0, new_identifier, 0, this.nIdColumn);
            System.arraycopy(oRow, this.nIdColumn, new_values, 0, this.nValColumn);
            int cont = 0;
            for (String o : new_values) {
                dataset.put(headerValues[cont], o, new_identifier);
                ++cont;
            }
        }
        return dataset;
    }

    public int getIdentifierColumnIndex(String columnName) {
        Integer index = this.mHeader_ID.get(columnName);
        assert (index != null) : "Why are you trying to map an inexistant column'" + columnName + "'?";
        if (index != null) {
            return index;
        }
        return -1;
    }

    public int getValueColumnIndex(String columnName) {
        Integer index = this.mHeader_Val.get(columnName);
        assert (index != null) : "Why are you trying to map an inexistant column '" + columnName + "'?";
        if (index != null) {
            return index;
        }
        return -1;
    }

    public Set<String> getColumnIdentifiers(int index) {
        return this.getColumnSet(0, index, this.mDataID);
    }

    public Set<String> getColumnIdentifiers(String columnName) {
        Integer index = this.mHeader_ID.get(columnName);
        if (index != null) {
            return this.getColumnSet(0, index, this.mDataID);
        }
        return new LinkedHashSet<String>();
    }

    private Set<String> getColumnSet(int index, int lookup_index, Map<String, Object> map) {
        LinkedHashSet<String> lValue = new LinkedHashSet<String>();
        if (index < lookup_index) {
            ++index;
            for (Object o : map.values()) {
                if (!(o instanceof Map)) continue;
                lValue.addAll(this.getColumnSet(index, lookup_index, (Map)o));
            }
        } else {
            lValue.addAll(map.keySet());
        }
        return lValue;
    }

    private static List<Object> getValues(int index, String[] lookupval, Map<String, Object> map) {
        ArrayList<Object> retVal = new ArrayList<Object>();
        assert (index <= lookupval.length) : "You reached the end of the the filter list!";
        if (index == lookupval.length) {
            Object value = map.get(lookupval[index - 1]);
            if (value instanceof Map) {
                Map mVal = (Map)value;
                retVal.add(new DatasetEntry(lookupval, mVal.values().toArray()));
            }
            if (value instanceof Object[]) {
                Object[] val = (Object[])value;
                retVal.add(new DatasetEntry(lookupval, val));
            }
        } else if (index < lookupval.length) {
            if (lookupval[index] != null) {
                Object value = map.get(lookupval[index]);
                ++index;
                if (value instanceof Map) {
                    retVal.addAll(VSI_dataset.getValues(index, lookupval, (Map)value));
                } else if (value instanceof List) assert (false) : "Why this is not a map??";
            } else {
                ++index;
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    Object value = entry.getValue();
                    String key = entry.getKey();
                    if (value instanceof Map) {
                        String[] cloneLookupval = (String[])lookupval.clone();
                        cloneLookupval[index - 1] = key;
                        retVal.addAll(VSI_dataset.getValues(index, cloneLookupval, (Map)value));
                        continue;
                    }
                    if (value instanceof List) assert (false) : "Why this is not a map??";
                }
            }
        } else assert (false) : "Why index got outside the number of columns of this dataset?? Index: " + index;
        return retVal;
    }

    public String[] getIdentifierNames() {
        return this.mHeader_ID.keySet().toArray(new String[this.nIdColumn]);
    }

    public String[] getValueNames() {
        return this.mHeader_Val.keySet().toArray(new String[this.nValColumn]);
    }

    public Map<Object[], Object[]> values() {
        Object[][] oList;
        LinkedHashMap<Object[], Object[]> lRet = new LinkedHashMap<Object[], Object[]>();
        for (Object[] row : oList = this.get(this.getNullIdenfier())) {
            Object[] identifiers = new Object[this.nIdColumn];
            Object[] values = new Object[this.nValColumn];
            System.arraycopy(row, 0, identifiers, 0, this.nIdColumn);
            System.arraycopy(row, this.nIdColumn, values, 0, this.nValColumn);
            lRet.put(identifiers, values);
        }
        return lRet;
    }

    public void populateFromCSVFile(String fileName) throws IOException {
        int nTotalColumns = this.nIdColumn + this.nValColumn;
        BufferedReader fileReader = new BufferedReader(new FileReader(fileName));
        String line = fileReader.readLine();
        if (line == null) {
            return;
        }
        String[] tokens = line.split(COMMA_DELIMITER);
        LinkedHashMap<String, Integer> mId_ColPos = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> mVal_ColPos = new LinkedHashMap<String, Integer>();
        if (tokens.length > 0 && tokens.length >= nTotalColumns) {
            int i;
            block0: for (String id : this.mHeader_ID.keySet()) {
                for (i = 0; i < tokens.length; ++i) {
                    String string = tokens[i].trim();
                    if (!id.equalsIgnoreCase(string)) continue;
                    mId_ColPos.put(string, i);
                    continue block0;
                }
            }
            block2: for (String val : this.mHeader_Val.keySet()) {
                for (i = 0; i < tokens.length; ++i) {
                    String string = tokens[i].trim();
                    if (!val.equalsIgnoreCase(string)) continue;
                    mVal_ColPos.put(string, i);
                    continue block2;
                }
            }
        }
        while ((line = fileReader.readLine()) != null) {
            tokens = line.split(COMMA_DELIMITER);
            if (tokens.length <= 0 || tokens.length < nTotalColumns) continue;
            String[] identifiers = new String[this.nIdColumn];
            int cont = 0;
            Iterator<Object> i$ = mId_ColPos.values().iterator();
            while (i$.hasNext()) {
                int n = (Integer)i$.next();
                identifiers[cont] = tokens[n].trim();
                ++cont;
            }
            for (Map.Entry entry : mVal_ColPos.entrySet()) {
                int nColVal = (Integer)entry.getValue();
                String nameVal = (String)entry.getKey();
                this.put(nameVal, tokens[nColVal].trim(), identifiers);
            }
        }
        fileReader.close();
    }

    public void populateFromDatabase(Connection conn) {
        throw new UnsupportedOperationException("Populate from dataset not implemented yet");
    }

    public int size() {
        assert (this.nSize > this.mDataID.size()) : "This can't be right! Did you modified 'put' method and forget to increment size counter?";
        return this.nSize;
    }

    public boolean isEmpty() {
        return this.mDataID.isEmpty();
    }

    public int getNumIdentifiers() {
        return this.nIdColumn;
    }

    public int getNumValues() {
        return this.nValColumn;
    }

    public void clear() {
        this.nSize = 0;
        this.mDataID.clear();
    }

    public String[] getNullIdenfier() {
        return VSI_dataset.createNullIdentifier(this.nIdColumn);
    }

    public static String[] createNullIdentifier(int size) {
        String[] nullHeader = new String[size];
        for (int i = 0; i < size; ++i) {
            nullHeader[i] = null;
        }
        return nullHeader;
    }
}

