/*
 * Decompiled with CFR 0.152.
 */
package de.core.vsi;

import de.core.AbstractDeepEditWizard;
import de.core.DeepEdit;
import de.core.vsi.PET_report;
import de.core.vsi.PET_report_Step1;
import de.core.vsi.PLP_report;
import de.core.vsi.VSI_report_Step0;
import de.data.DE_GeneralEnums;
import java.awt.Window;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PET_reportWizard
extends AbstractDeepEditWizard {
    private VSI_report_Step0 pnlStep0;
    private PET_report_Step1 pnlStep1;

    public PET_reportWizard(Window parent, String sTitle) {
        super(parent, sTitle);
        this.initComponents();
    }

    private void initComponents() {
        this.pnlStep0 = new VSI_report_Step0(this);
        this.pnlStep1 = new PET_report_Step1(this);
        JPanel pnlFinish = new JPanel();
        pnlFinish.add(new JLabel("Ready to create a new PET output report"));
        this.addTask("Software", this.pnlStep0, "Software Selection", "Software output to Visualize in DeepEdit");
        this.addTask("Location", this.pnlStep1, "PET Output Directory Location", "Selection of the folder where PET output files are located");
        this.addTask("Finalize", pnlFinish, "Create report", null);
    }

    @Override
    public void beforeShowingPanel(JPanel pnl) {
    }

    @Override
    public void finishWizard() {
        DE_GeneralEnums.DispatchSoftware dispatchSoftware = this.pnlStep0.getSelectedSoftware();
        File f = new File(this.pnlStep1.getSelectedOutputPath());
        switch (dispatchSoftware) {
            case PET: {
                PET_report PETreport = new PET_report(f.getAbsolutePath());
                DeepEdit.addReportTab("pet-vsi_" + f.getName(), PETreport);
                break;
            }
            case PLP: {
                PLP_report PLPreport = new PLP_report(f.getAbsolutePath());
                DeepEdit.addReportTab("plp-vsi_" + f.getName(), PLPreport);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Outputs for software '" + dispatchSoftware.name() + "' not implemented yet!");
            }
        }
    }
}

