/*
 * Decompiled with CFR 0.152.
 */
package de.core.vsi;

import de.core.DeepEdit;
import de.core.vsi.VSI_dataset;
import de.core.vsi.VSI_handler;
import de.core.vsi.VSI_mapping;
import de.core.vsi.VSI_report;
import de.core.vsi.XML_reportMapping;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class PET_report
implements VSI_report {
    private String currentOutput;
    private VSI_handler handler;
    public static final String PET_VSI_DEFAULT_CONFIG_FILE = "./config/pet-vsi_mapping.xml";
    private final String reportFilePath;
    private static XML_reportMapping pet_map;
    private Map<String, String> name2id = new LinkedHashMap<String, String>();

    public PET_report(String reportFilePath) {
        this.reportFilePath = reportFilePath;
        this.initMappingFile();
    }

    @Override
    public VSI_dataset readFile(String file) throws IOException {
        if (this.handler == null) {
            this.parseFile(file);
        }
        return this.handler.getDataset();
    }

    @Override
    public void parseFile(String file) throws IOException {
        assert (file != null) : "Never use null here!";
        assert (pet_map != null) : "WHy map is not initialized? Did you modify the constructor?";
        File f = new File(file);
        String id = null;
        for (String s : pet_map.getIds()) {
            if (!f.getName().equalsIgnoreCase(pet_map.getSourceFilePath(s))) continue;
            id = s;
            break;
        }
        if (id == null) {
            for (String s : pet_map.getIds()) {
                if (!f.getName().equalsIgnoreCase(pet_map.getName(s))) continue;
                id = s;
                file = this.getFullPathFile(pet_map.getName(s));
                break;
            }
        }
        assert (id != null) : "Why are you calling an unsopported file or output? " + file;
        this.currentOutput = pet_map.getName(id);
        String[] x_field = pet_map.getXFields(id);
        assert (x_field != null) : "Error in mapping file. X-field is required by VSI!";
        String[] y1 = pet_map.getYLeftField(id);
        assert (y1 != null) : "Error in mapping file. y1_field is required by VSI!";
        String[] y1_series = pet_map.getYLeftSeries(id);
        if (y1_series != null) assert (y1.length == y1_series.length) : "Error in mapping file. It's only allowed 1 series per output";
        String[] y2 = pet_map.getYRightField(id);
        String[] y2_series = pet_map.getYRightSeries(id);
        if (y2 != null && y2_series != null) assert (y2.length == y2_series.length) : "Error in mapping file. It's only allowed 1 series per output";
        LinkedList<String> lIdentifiers = new LinkedList<String>();
        String[] identifiers = pet_map.getDatasetIdentifiers(id);
        assert (identifiers != null) : "Error in mapping file. Dataset_identifiers field is mandatory!";
        assert (identifiers.length >= x_field.length) : "Error in mapping file. Dataset_identifiers must always be greater than or equal to the fields in x-axis";
        lIdentifiers.addAll(Arrays.asList(identifiers));
        LinkedList<String> lValues = new LinkedList<String>();
        String[] datasetValues = pet_map.getDatasetValues(id);
        assert (datasetValues != null) : "Error in mapping file. Dataset_values field is mandatory!";
        lValues.addAll(Arrays.asList(datasetValues));
        if (this.handler == null) {
            this.handler = new VSI_handler();
        }
        this.handler.parseCSVFile(file, lIdentifiers.toArray(new String[lIdentifiers.size()]), lValues.toArray(new String[lValues.size()]), true, true);
    }

    @Override
    public void parseFile(String[] file) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public VSI_dataset readFile(String[] file) {
        assert (file != null) : "Never use null here!";
        assert (pet_map != null) : "WHy map is not initialized? Did you modify the constructor?";
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public VSI_dataset getDataset(String[] identifiers, String name) {
        if (this.handler == null) {
            return null;
        }
        String id = this.name2id.get(name);
        int operation_id = pet_map.getYLeftOperation(id);
        String[] groupBy = this.getGroupByArray(id);
        try {
            return this.handler.getDataset(operation_id, groupBy, identifiers);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private String[] getGroupByArray(String id) {
        ArrayList<String> lIdentifiers = new ArrayList<String>(Arrays.asList(pet_map.getDatasetIdentifiers(id)));
        ArrayList<String> lToRemove = new ArrayList<String>(Arrays.asList(pet_map.getDatasetIdentifiers(id)));
        String[] Filters = pet_map.getFilters(id);
        PET_report.safeRemove(lToRemove, Filters);
        String[] XFields = pet_map.getXFields(id);
        PET_report.safeRemove(lToRemove, XFields);
        String[] Series1 = pet_map.getYLeftSeries(id);
        PET_report.safeRemove(lToRemove, Series1);
        String[] Series2 = pet_map.getYRightSeries(id);
        PET_report.safeRemove(lToRemove, Series2);
        if (lIdentifiers.isEmpty()) {
            return null;
        }
        lIdentifiers.removeAll(lToRemove);
        return lIdentifiers.toArray(new String[lIdentifiers.size()]);
    }

    private static void safeRemove(ArrayList<String> lMain, String[] toRemove) {
        if (toRemove != null) {
            ArrayList<String> lToRemove = new ArrayList<String>(Arrays.asList(toRemove));
            for (String s : lToRemove) {
                lMain.remove(s);
            }
        }
    }

    public String getConfigFile() {
        String sConfigFile = DeepEdit.getOptionValue("DE-PET_reportMappingFile");
        if (sConfigFile == null) {
            return PET_VSI_DEFAULT_CONFIG_FILE;
        }
        return sConfigFile;
    }

    public static void setConfigFile(String file) {
        if (file != null) {
            DeepEdit.setOptionValue("DE-PET_reportMappingFile", file);
        }
    }

    @Override
    public VSI_mapping parseConfigFile(String mappingFile) {
        assert (mappingFile != null) : "What happened to VSI mapping file for PET (pet-vsi_mapping.xml) file? Corrupted DE config file?";
        if (mappingFile != null) {
            File f_mappingFile = new File(mappingFile);
            if (f_mappingFile.exists()) {
                try {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XML_reportMapping.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    XML_reportMapping intpet_map = (XML_reportMapping)jaxbUnmarshaller.unmarshal(f_mappingFile);
                    return intpet_map;
                }
                catch (JAXBException ex) {
                    System.out.println("Error parsing VSI-PET report mapping file: " + ex.getMessage());
                    ex.printStackTrace(System.err);
                }
            } else {
                System.out.println("Error reading VSI-PET report mapping file. File not found: " + f_mappingFile.getAbsolutePath());
            }
        }
        return null;
    }

    private void initMappingFile() {
        pet_map = (XML_reportMapping)this.parseConfigFile(this.getConfigFile());
        if (pet_map != null) {
            for (String s : pet_map.getIdList()) {
                this.name2id.put(pet_map.getName(s), s);
            }
        }
    }

    @Override
    public String[] getFileList() {
        String[] ids;
        ArrayList<String> lFilePath = new ArrayList<String>();
        for (String id : ids = pet_map.getIds()) {
            String sFile = this.getFullPathFile(pet_map.getName(id));
            if (sFile == null) continue;
            lFilePath.add(sFile);
        }
        return lFilePath.toArray(new String[lFilePath.size()]);
    }

    public String[] getNameList() {
        String[] ids;
        ArrayList<String> lName = new ArrayList<String>();
        for (String id : ids = pet_map.getIds()) {
            lName.add(pet_map.getName(id));
        }
        return lName.toArray(new String[lName.size()]);
    }

    public String getFullPathFile(String name) {
        File f;
        if (pet_map != null && (f = new File(this.reportFilePath + File.separator + pet_map.getSourceFilePath(this.name2id.get(name)))).exists()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public int[] getYLeftType(String name) {
        if (pet_map != null) {
            return pet_map.getYLeftType(this.name2id.get(name));
        }
        return null;
    }

    public int[] getYRightType(String name) {
        if (pet_map != null) {
            return pet_map.getYRightType(this.name2id.get(name));
        }
        return null;
    }

    @Override
    public String[] getFilterList(String name) {
        if (pet_map != null) {
            return pet_map.getFilters(this.name2id.get(name));
        }
        return null;
    }

    @Override
    public String[] getDatasetIdentifiers(String Output) {
        if (pet_map != null) {
            return pet_map.getDatasetIdentifiers(this.name2id.get(Output));
        }
        return null;
    }

    public Object[] getFilterValues(int index) {
        assert (this.handler != null) : "A handler should have been initialized before calling this method!!";
        return this.handler.getColumnSet(index);
    }

    @Override
    public void parseDatabase(Connection con, VSI_dataset data2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getOutputList() {
        if (pet_map != null) {
            return this.name2id.keySet().toArray(new String[0]);
        }
        return null;
    }

    @Override
    public String[] getFilterValues(String filter, String name) {
        assert (this.handler != null) : "A handler should have been initialized before calling this method!!";
        Object[] oColSet = this.handler.getColumnSet(filter);
        return (String[])Arrays.copyOf(oColSet, oColSet.length, String[].class);
    }

    @Override
    public Object[][] getValues(String[] filter, String output) {
        assert (this.handler != null) : "A handler should have been initialized before calling this method!!";
        return this.handler.get(filter);
    }

    public String[] getX_Fields(String name) {
        if (pet_map != null) {
            return pet_map.getXFields(this.name2id.get(name));
        }
        return null;
    }

    public String[] getYLeftSeries(String name) {
        if (pet_map != null) {
            return pet_map.getYLeftSeries(this.name2id.get(name));
        }
        return null;
    }

    public String[] getYRightSeries(String name) {
        if (pet_map != null) {
            return pet_map.getYRightSeries(this.name2id.get(name));
        }
        return null;
    }

    @Override
    public VSI_mapping getConfigInfo() {
        if (pet_map == null) {
            this.initMappingFile();
        }
        return pet_map;
    }
}

