/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.GraphicsUtil;
import de.core.JMapObject;
import de.core.PietEditFrame;
import de.core.PietSchematic;
import de.core.Pin;
import de.core.comp;
import de.core.tdb_comp;
import de.core.tdb_generic_node;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class tdb_arc
extends tdb_comp {
    BufferedReader din = new BufferedReader(new InputStreamReader(System.in));
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    protected JMapObject mo;
    public int[] xpoly = new int[32];
    public int[] ypoly = new int[32];
    public int ChangingWire = 0;
    public int ChangingWirePoly = 0;
    protected int npoly;
    public double[] xpolysim = new double[300];
    public double[] ypolysim = new double[300];
    protected boolean above = true;
    protected int npolysim;
    protected int pospolysim;
    public Vector ConnComps1;
    public Vector ConnComps2;
    public String in;
    public String out;
    private double capacity = 0.0;
    private int[] my_t_modes = new int[7];
    private double length = 0.0;
    private double flujo = 0.0;
    private double velocidad = 0.0;
    private Color mycolor = Color.red;
    protected double[] f_arc_emissions = new double[9];

    public tdb_arc(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod) {
        super("Arc", entryperiod, exitperiod);
        this.ClassName = "tdb_arc";
        this.x1 = x;
        this.y1 = y;
        this.setmycolor();
    }

    public tdb_arc(Pin[][] PinGrid, int rx1, int ry1, int rx2, int ry2, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int[] xxpoly, int[] yypoly, int nnpoly, double ccapacity, int[] mmy_t_modes, double llength, String load, double fflujo, double vvelocidad, double[] ff_arc_emissions) {
        super(Name, type, owner, cost, lifetime, entryperiod, exitperiod, load);
        int i;
        this.ClassName = "tdb_arc";
        this.x1 = rx1;
        this.y1 = ry1;
        this.x2 = rx2;
        this.y2 = ry2;
        for (i = 0; i < nnpoly; ++i) {
            this.xpoly[i] = xxpoly[i];
            this.ypoly[i] = yypoly[i];
        }
        for (i = 0; i < 9; ++i) {
            this.f_arc_emissions[i] = ff_arc_emissions[i];
        }
        this.npoly = nnpoly;
        this.PlacePinsHere(PinGrid);
        this.capacity = ccapacity;
        this.my_t_modes = mmy_t_modes;
        this.length = llength;
        this.flujo = fflujo;
        this.velocidad = vvelocidad;
        this.setmycolor();
    }

    public tdb_arc(Pin[][] PinGrid, int rx1, int ry1, int rx2, int ry2, String Name, String type, String owner, double cost, int lifetime, int entryperiod, int exitperiod, int[] xxpoly, int[] yypoly, int nnpoly, double ccapacity, int[] mmy_t_modes, double llength, double fflujo, double vvelocidad, double[] ff_arc_emissions) {
        super(Name, type, owner, cost, lifetime, entryperiod, exitperiod);
        int i;
        this.ClassName = "tdb_arc";
        this.x1 = rx1;
        this.y1 = ry1;
        this.x2 = rx2;
        this.y2 = ry2;
        for (i = 0; i < nnpoly; ++i) {
            this.xpoly[i] = xxpoly[i];
            this.ypoly[i] = yypoly[i];
        }
        for (i = 0; i < 9; ++i) {
            this.f_arc_emissions[i] = ff_arc_emissions[i];
        }
        this.npoly = nnpoly;
        this.PlacePinsHere(PinGrid);
        this.capacity = ccapacity;
        this.my_t_modes = mmy_t_modes;
        this.length = llength;
        this.flujo = fflujo;
        this.velocidad = vvelocidad;
        this.setmycolor();
    }

    public tdb_arc(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        this.ComponentName = "Arc";
        this.ClassName = "tdb_arc";
    }

    @Override
    public String getinv_type() {
        return this.inv_type;
    }

    @Override
    public String getinv_owner() {
        return this.inv_owner;
    }

    @Override
    public double getinv_cost() {
        return this.inv_cost;
    }

    public int getnpoly() {
        return this.npoly;
    }

    public double getcapacity() {
        return this.capacity;
    }

    public int getmy_t_modes(int n) {
        return this.my_t_modes[n];
    }

    public boolean getmy_t_modesB(int n) {
        return this.my_t_modes[n] == 1;
    }

    public double getlength() {
        return this.length;
    }

    public Color getmycolor() {
        return this.mycolor;
    }

    public double[] get_f_arc_emissions() {
        return this.f_arc_emissions;
    }

    public double get_f_arc_emissions_at(int i) {
        return this.f_arc_emissions[i];
    }

    public double get_flujo() {
        return this.flujo;
    }

    public double get_velocidad() {
        return this.velocidad;
    }

    public JMapObject getmo() {
        return this.mo;
    }

    @Override
    public void setinv_cost(double n) {
        this.inv_cost = n;
    }

    public void setnpoly(int n) {
        this.npoly = n;
    }

    public void setcapacity(double cap) {
        this.capacity = cap;
    }

    public void setmy_t_modes(int n, int m) {
        this.my_t_modes[n] = m;
    }

    public void setmy_t_modes(int n, boolean m) {
        this.my_t_modes[n] = m ? 1 : 0;
    }

    public void setlength(double le) {
        this.length = le;
    }

    public void setmycolor() {
        this.mycolor = this.getmy_t_modes(0) == 1 || this.getmy_t_modes(1) == 1 ? (this.getmy_t_modes(2) == 0 && this.getmy_t_modes(3) == 0 && this.getmy_t_modes(4) == 0 && this.getmy_t_modes(5) == 0 && this.getmy_t_modes(6) == 0 ? Color.green : Color.red) : (this.getmy_t_modes(2) == 1 || this.getmy_t_modes(3) == 1 || this.getmy_t_modes(4) == 1 ? (this.getmy_t_modes(0) == 0 && this.getmy_t_modes(1) == 0 && this.getmy_t_modes(5) == 0 && this.getmy_t_modes(6) == 0 ? Color.orange : Color.red) : (this.getmy_t_modes(5) == 1 ? (this.getmy_t_modes(0) == 0 && this.getmy_t_modes(1) == 0 && this.getmy_t_modes(2) == 0 && this.getmy_t_modes(3) == 0 && this.getmy_t_modes(4) == 0 && this.getmy_t_modes(6) == 0 ? Color.yellow : Color.red) : (this.getmy_t_modes(6) == 1 ? (this.getmy_t_modes(0) == 0 && this.getmy_t_modes(1) == 0 && this.getmy_t_modes(2) == 0 && this.getmy_t_modes(3) == 0 && this.getmy_t_modes(4) == 0 && this.getmy_t_modes(5) == 0 ? Color.white : Color.red) : Color.red)));
    }

    public void set_f_arc_emissions(double[] em) {
        this.f_arc_emissions = em;
    }

    public void set_f_arc_emissions_at(int i, double em) {
        this.f_arc_emissions[i] = em;
    }

    public void set_flujo(double f) {
        this.flujo = f;
    }

    public void set_velocidad(double v) {
        this.velocidad = v;
    }

    public void setmo(JMapObject n) {
        this.mo = n;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public comp Copy(int xo, int yo) {
        tdb_arc NewComponent = new tdb_arc(this, xo, yo);
        NewComponent.setName("NEW_Arc");
        NewComponent.x1 = this.x1 - xo;
        NewComponent.y1 = this.y1 - yo;
        NewComponent.x2 = this.x2 - xo;
        NewComponent.y2 = this.y2 - yo;
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setinv_owner(this.getinv_owner());
        NewComponent.setcapacity(this.capacity);
        for (int i = 0; i < 7; ++i) {
            NewComponent.setmy_t_modes(i, this.my_t_modes[i]);
        }
        NewComponent.setlength(this.length);
        NewComponent.set_flujo(this.flujo);
        NewComponent.set_velocidad(this.velocidad);
        NewComponent.setmycolor();
        NewComponent.set_f_arc_emissions(this.get_f_arc_emissions());
        return NewComponent;
    }

    @Override
    public void CheckPosition(PietEditFrame app) {
        if (this.x1 < 1) {
            this.x1 = 1;
        }
        if (this.x1 >= app.MaxXPoints) {
            this.x1 = app.MaxXPoints - 1;
        }
        if (this.y1 < 1) {
            this.y1 = 1;
        }
        if (this.y1 >= app.MaxYPoints) {
            this.y1 = app.MaxYPoints - 1;
        }
        if (this.x2 < 1) {
            this.x2 = 1;
        }
        if (this.x2 >= app.MaxXPoints) {
            this.x2 = app.MaxXPoints - 1;
        }
        if (this.y2 < 1) {
            this.y2 = 1;
        }
        if (this.y2 >= app.MaxYPoints) {
            this.y2 = app.MaxYPoints - 1;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (this.xpoly[i] < 1) {
                this.xpoly[i] = 1;
            }
            if (this.xpoly[i] >= app.MaxXPoints) {
                this.xpoly[i] = app.MaxXPoints - 1;
            }
            if (this.ypoly[i] < 1) {
                this.ypoly[i] = 1;
            }
            if (this.ypoly[i] < app.MaxYPoints) continue;
            this.ypoly[i] = app.MaxYPoints - 1;
        }
    }

    @Override
    public void SimulateSetUp(int x, int y, Vector ActComps) {
        if (x == this.x1 && y == this.y1) {
            this.ConnComps1 = ActComps;
        }
        if (x == this.x2 && y == this.y2) {
            this.ConnComps2 = ActComps;
        }
    }

    public String InformAllComponents(Vector ActVector, int x, int y, int endline) {
        int nc = 0;
        int inp = -1;
        int out = -1;
        for (int ix = 0; ix < ActVector.size(); ++ix) {
            comp ConnectedComponent = (comp)ActVector.elementAt(ix);
            if (ConnectedComponent == this || !(ConnectedComponent instanceof tdb_generic_node)) continue;
            ++nc;
            inp = ConnectedComponent.InformInput(this);
            if (inp != -1) {
                if (endline == 1) {
                    this.setcon1(ConnectedComponent.ComponentName);
                }
                if (endline == 2) {
                    this.setcon2(ConnectedComponent.ComponentName);
                }
                return ConnectedComponent.ComponentName;
            }
            out = ConnectedComponent.InformOutput(this);
            if (out == -1) continue;
            if (endline == 1) {
                this.setcon1(ConnectedComponent.ComponentName);
            }
            if (endline == 2) {
                this.setcon2(ConnectedComponent.ComponentName);
            }
            return ConnectedComponent.ComponentName;
        }
        return "Not Conn.";
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate) {
        int i;
        int auxint = 1;
        g.setColor(this.mycolor);
        if (this.npoly > 0) {
            GraphicsUtil.drawLine(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.xpoly[0] - xp) * gs, (this.ypoly[0] - yp) * gs, auxint);
            for (i = 0; i < this.npoly - 1; ++i) {
                GraphicsUtil.drawLine(g, (this.xpoly[i] - xp) * gs, (this.ypoly[i] - yp) * gs, (this.xpoly[i + 1] - xp) * gs, (this.ypoly[i + 1] - yp) * gs, auxint);
            }
            GraphicsUtil.drawLine(g, (this.xpoly[this.npoly - 1] - xp) * gs, (this.ypoly[this.npoly - 1] - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, auxint);
        } else {
            GraphicsUtil.drawLine(g, (this.x1 - xp) * gs, (this.y1 - yp) * gs, (this.x2 - xp) * gs, (this.y2 - yp) * gs, auxint);
        }
        if (this.isSelected()) {
            g.setColor(TextColor1);
            if ((this.ChangingWire & 1) == 1) {
                g.drawRect((int)(((double)(this.x1 - xp) - 0.25) * (double)gs), (int)(((double)(this.y1 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
            }
            if (this.ChangingWire == 3) {
                for (i = 0; i < this.npoly; ++i) {
                    g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                }
            }
            if ((this.ChangingWire & 2) == 2) {
                g.drawRect((int)(((double)(this.x2 - xp) - 0.25) * (double)gs), (int)(((double)(this.y2 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
            }
        }
        g.setColor(TextColor1);
        for (i = 0; i < this.npoly; ++i) {
            if (this.ChangingWirePoly != i + 1) continue;
            g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
        }
        g.setColor(TextColor2);
        if (gs >= 0 && gs < 8) {
            g.setFont(Font10);
        }
        if (gs >= 4 && gs < 8) {
            g.setFont(Font9);
            if (this.npoly > 0) {
                g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
            } else {
                g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
            }
        } else if (gs >= 8 && gs < 10) {
            g.setFont(Font12);
            if (this.npoly > 0) {
                g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
            } else {
                g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
            }
        } else if (gs >= 10 && gs < 14) {
            g.setFont(Font14);
            if (this.npoly > 0) {
                g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
            } else {
                g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
            }
        } else if (gs >= 14 && gs < 18) {
            g.setFont(Font14);
            if (this.npoly > 0) {
                g.drawString(this.ComponentName, (int)((double)(this.xpoly[this.npoly / 2] - xp) + 0.5) * gs, (int)((double)(this.ypoly[this.npoly / 2] - yp) - 0.5) * gs);
            } else {
                g.drawString(this.ComponentName, (int)((0.5 * (double)(this.x1 + this.x2 - 2 * xp) + 0.5) * (double)gs), (int)((0.5 * (double)(this.y1 + this.y2 - 2 * yp) - 0.5) * (double)gs));
            }
        }
        if (gs >= 4) {
            if (gs >= 4) {
                g.setFont(Font9);
            } else if (gs >= 8) {
                g.setFont(Font10);
            } else if (gs >= 12) {
                g.setFont(Font12);
            }
        }
        if (!this.getmy_e_consumption().equals("NONE")) {
            g.setColor(Color.blue.brighter().brighter());
            if ((this.ChangingWire & 1) == 1) {
                g.drawRect((int)(((double)(this.x1 - xp) - 0.25) * (double)gs), (int)(((double)(this.y1 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
            }
            if (this.ChangingWire == 3) {
                for (i = 0; i < this.npoly; ++i) {
                    g.drawRect((int)(((double)(this.xpoly[i] - xp) - 0.25) * (double)gs), (int)(((double)(this.ypoly[i] - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
                }
            }
            if ((this.ChangingWire & 2) == 2) {
                g.drawRect((int)(((double)(this.x2 - xp) - 0.25) * (double)gs), (int)(((double)(this.y2 - yp) - 0.25) * (double)gs), gs / 2, gs / 2);
            }
        }
    }

    public void calcnumint(int px1, int py1, int px2, int py2) {
        boolean i = false;
        double numint = Math.sqrt((double)(px1 - px2) * (double)(px1 - px2) + (double)(py1 - py2) * (double)(py1 - py2)) / 2.0;
    }

    @Override
    public void RemovePinsGrid(Pin[][] PinGrid) {
        this.RemovePin(PinGrid[this.x1][this.y1]);
        this.RemovePin(PinGrid[this.x2][this.y2]);
    }

    @Override
    public void RegisterPins(Pin[][] PinGrid, int x, int y) {
        if (PinGrid == null) {
            return;
        }
        if (PinGrid[this.x1][this.y1] == null) {
            PinGrid[this.x1][this.y1] = new Pin();
        }
        if (PinGrid[this.x2][this.y2] == null) {
            PinGrid[this.x2][this.y2] = new Pin();
        }
        this.RegisterPin(PinGrid[this.x1][this.y1]);
        this.RegisterPin(PinGrid[this.x2][this.y2]);
    }

    @Override
    public void PlacePinsHere(Pin[][] PinGrid) {
        if (PinGrid == null) {
            return;
        }
        this.RegisterPins(PinGrid, 0, 0);
    }

    public void Set2ndCoord(Pin[][] PinGrid, int x, int y) {
        this.x2 = x;
        this.y2 = y;
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        int i;
        boolean emi = false;
        myPrintStream.println("describe component tdbarc");
        myPrintStream.println(" pos " + this.x1 + " " + this.y1);
        myPrintStream.println(" pos2 " + this.x2 + " " + this.y2);
        for (i = 0; i < this.npoly; ++i) {
            myPrintStream.println(" pospoly " + this.xpoly[i] + " " + this.ypoly[i]);
        }
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" cost " + this.getinv_cost());
        myPrintStream.println(" owner " + this.getinv_owner());
        myPrintStream.println(" type " + this.getinv_type());
        myPrintStream.println(" tdbload " + this.getmy_e_consumption());
        myPrintStream.println(" tdbcapacity " + this.capacity);
        myPrintStream.println(" tdblength " + this.length);
        myPrintStream.println(" tdbflujo " + this.flujo);
        myPrintStream.println(" tdbvelocidad " + this.velocidad);
        for (i = 0; i < 7; ++i) {
            if (this.my_t_modes[i] == 1) {
                myPrintStream.println(" mytmodes 1");
                continue;
            }
            myPrintStream.println(" mytmodes 0");
        }
        for (i = 0; i < 9; ++i) {
            if (this.f_arc_emissions[i] == 0.0) continue;
            emi = true;
        }
        if (emi) {
            for (i = 0; i < 9; ++i) {
                myPrintStream.println(" farcemissions " + this.f_arc_emissions[i]);
            }
        }
        myPrintStream.println("end describe ");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        int i = 0;
        Statement stmt = PietEditFrame.con.createStatement();
        String query = "INSERT INTO tdb_arc (XPos,YPos,XPos2,YPos2,numpoly,Name,type,owner,cost,lifetime,entryperiod,exitperiod,tdblength,tdbcapacity,tdbflujo,tdbvelocidad,tdbload,mytmodes1,mytmodes2,mytmodes3,mytmodes4,mytmodes5,mytmodes6,mytmodes7,farcemissions1, farcemissions2, farcemissions3, farcemissions4, farcemissions5, farcemissions6, farcemissions7, farcemissions8, farcemissions9) VALUES (" + String.valueOf(this.x1) + "," + String.valueOf(this.y1) + "," + String.valueOf(this.x2) + "," + String.valueOf(this.y2) + "," + String.valueOf(this.npoly) + ",'" + this.ComponentName + "','" + this.getinv_type() + "','" + this.getinv_owner() + "','" + this.getinv_cost() + "'," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.length) + "," + String.valueOf(this.capacity) + "," + String.valueOf(this.flujo) + "," + String.valueOf(this.velocidad) + ",'" + this.getmy_e_consumption() + "'";
        for (int ixi = 0; ixi < 7; ++ixi) {
            query = query + "," + String.valueOf(this.my_t_modes[ixi]);
        }
        for (int ixx = 0; ixx < 9; ++ixx) {
            query = query + "," + String.valueOf(this.f_arc_emissions[ixx]);
        }
        query = query + ")";
        x = stmt.executeUpdate(query);
        for (i = 0; i < this.npoly; ++i) {
            query = "UPDATE tdb_arc SET pospolyx" + String.valueOf(i + 1) + "=" + String.valueOf(this.xpoly[i]) + " WHERE Name = '" + this.ComponentName + "'";
            x = stmt.executeUpdate(query);
            query = "UPDATE tdb_arc SET pospolyy" + String.valueOf(i + 1) + "=" + String.valueOf(this.ypoly[i]) + " WHERE Name = '" + this.ComponentName + "'";
            x = stmt.executeUpdate(query);
        }
        stmt.close();
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int tx1, int ty1, int tx2, int ty2) {
        boolean Sel = false;
        if (tx1 <= this.x1 && this.x1 <= tx2 && ty1 <= this.y1 && this.y1 <= ty2) {
            Sel = true;
        }
        if (tx1 <= this.x2 && this.x2 <= tx2 && ty1 <= this.y2 && this.y2 <= ty2) {
            Sel = true;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (tx1 > this.xpoly[i] || this.xpoly[i] > tx2 || ty1 > this.ypoly[i] || this.ypoly[i] > ty2) continue;
            Sel = true;
        }
        return Sel;
    }

    @Override
    public boolean AdjustPosition(Pin[][] PinGrid, int x, int y) {
        int nx1 = this.x1;
        int ny1 = this.y1;
        int nx2 = this.x2;
        int ny2 = this.y2;
        if ((this.ChangingWire & 1) == 1) {
            nx1 += x;
            ny1 += y;
        }
        if ((this.ChangingWire & 2) == 2) {
            nx2 += x;
            ny2 += y;
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (this.ChangingWirePoly != i + 1 && this.ChangingWire != 3) continue;
            int n = i;
            this.xpoly[n] = this.xpoly[n] + x;
            int n2 = i;
            this.ypoly[n2] = this.ypoly[n2] + y;
        }
        if (nx1 == nx2 && ny1 == ny2) {
            return false;
        }
        this.x1 = nx1;
        this.y1 = ny1;
        this.x2 = nx2;
        this.y2 = ny2;
        return true;
    }

    public int sgn(int val) {
        if (val > 0) {
            return 1;
        }
        if (val < 0) {
            return -1;
        }
        return 0;
    }

    public boolean CheckIfPointInWire(int a, int b, int c, int d, int x, int y) {
        int n;
        int u = c - a;
        int v = d - b;
        int d1x = this.sgn(u);
        int d1y = this.sgn(v);
        int d2x = this.sgn(u);
        int d2y = 0;
        int m = Math.abs(u);
        if (m <= (n = Math.abs(v))) {
            d2x = 0;
            d2y = this.sgn(v);
            m = Math.abs(v);
            n = Math.abs(u);
        }
        int s = m / 2;
        for (int i = 0; i < m; ++i) {
            if (Math.abs(x - a) < 2 && Math.abs(y - b) < 2) {
                return true;
            }
            if ((s += n) >= m) {
                s -= m;
                a += d1x;
                b += d1y;
                continue;
            }
            a += d2x;
            b += d2y;
        }
        return false;
    }

    @Override
    public boolean CheckIfComponentClicked(int x, int y) {
        int i;
        if (x == this.x1 && y == this.y1) {
            this.ChangingWire = 1;
            return true;
        }
        if (x == this.x2 && y == this.y2) {
            this.ChangingWire = 2;
            return true;
        }
        for (i = 0; i < this.npoly; ++i) {
            if (Math.abs(x - this.xpoly[i]) > 2 || Math.abs(y - this.ypoly[i]) > 2) continue;
            this.ChangingWirePoly = i + 1;
            return true;
        }
        if (this.npoly == 0) {
            if (this.CheckIfPointInWire(this.x1, this.y1, this.x2, this.y2, x, y)) {
                this.ChangingWire = 3;
                return true;
            }
        } else {
            if (this.CheckIfPointInWire(this.x1, this.y1, this.xpoly[0], this.ypoly[0], x, y)) {
                this.ChangingWire = 3;
                return true;
            }
            if (this.CheckIfPointInWire(this.xpoly[this.npoly - 1], this.ypoly[this.npoly - 1], this.x2, this.y2, x, y)) {
                this.ChangingWire = 3;
                return true;
            }
            for (i = 0; i < this.npoly - 1; ++i) {
                if (!this.CheckIfPointInWire(this.xpoly[i], this.ypoly[i], this.xpoly[i + 1], this.ypoly[i + 1], x, y)) continue;
                this.ChangingWire = 3;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean CheckIfComponentInSelectBox(int tx1, int ty1, int tx2, int ty2) {
        this.setSelected(false);
        this.ChangingWire = 0;
        this.ChangingWirePoly = 0;
        if (tx1 <= this.x1 && this.x1 <= tx2 && ty1 <= this.y1 && this.y1 <= ty2) {
            this.ChangingWire |= 1;
            this.setSelected(true);
        }
        if (tx1 <= this.x2 && this.x2 <= tx2 && ty1 <= this.y2 && this.y2 <= ty2) {
            this.ChangingWire |= 2;
            this.setSelected(true);
        }
        for (int i = 0; i < this.npoly; ++i) {
            if (tx1 > this.xpoly[i] || this.xpoly[i] > tx2 || ty1 > this.ypoly[i] || this.ypoly[i] > ty2) continue;
            this.ChangingWirePoly = i + 1;
            this.setSelected(true);
        }
        return this.isSelected();
    }

    public boolean TryPlaceJunction(PietSchematic ActSchematic, Pin[][] PinGrid, int x, int y, int gs) {
        int i;
        if (x == this.x1 && y == this.y1) {
            return false;
        }
        if (x == this.x2 && y == this.y2) {
            return false;
        }
        for (i = 0; i < this.npoly; ++i) {
            if (Math.abs(x - this.xpoly[i]) > 2 || Math.abs(y - this.ypoly[i]) > 2) continue;
            --this.npoly;
            for (int j = i; j < this.npoly; ++j) {
                this.xpoly[j] = this.xpoly[j + 1];
                this.ypoly[j] = this.ypoly[j + 1];
            }
            return true;
        }
        if (this.npoly == 0) {
            if (this.CheckIfPointInWire(this.x1 * gs, this.y1 * gs, this.x2 * gs, this.y2 * gs, x * gs, y * gs)) {
                this.xpoly[this.npoly] = x;
                this.ypoly[this.npoly] = y;
                ++this.npoly;
                this.ChangingWirePoly = this.npoly;
                return true;
            }
        } else {
            if (this.CheckIfPointInWire(this.x1 * gs, this.y1 * gs, this.xpoly[0] * gs, this.ypoly[0] * gs, x * gs, y * gs)) {
                for (i = this.npoly; i > 0; --i) {
                    this.xpoly[i] = this.xpoly[i - 1];
                    this.ypoly[i] = this.ypoly[i - 1];
                }
                this.xpoly[0] = x;
                this.ypoly[0] = y;
                ++this.npoly;
                this.ChangingWirePoly = 1;
                return true;
            }
            if (this.CheckIfPointInWire(this.xpoly[this.npoly - 1] * gs, this.ypoly[this.npoly - 1] * gs, this.x2 * gs, this.y2 * gs, x * gs, y * gs)) {
                this.xpoly[this.npoly] = x;
                this.ypoly[this.npoly] = y;
                ++this.npoly;
                this.ChangingWirePoly = this.npoly;
                return true;
            }
            for (i = 0; i < this.npoly - 1; ++i) {
                if (!this.CheckIfPointInWire(this.xpoly[i] * gs, this.ypoly[i] * gs, this.xpoly[i + 1] * gs, this.ypoly[i + 1] * gs, x * gs, y * gs)) continue;
                for (int j = this.npoly; j > i; --j) {
                    this.xpoly[j] = this.xpoly[j - 1];
                    this.ypoly[j] = this.ypoly[j - 1];
                }
                this.xpoly[i + 1] = x;
                this.ypoly[i + 1] = y;
                ++this.npoly;
                this.ChangingWirePoly = i + 1;
                return true;
            }
        }
        return false;
    }

    public String Statistic(int ix) {
        String linea = "";
        linea = StringUtil.printf(ix, 6) + "    " + StringUtil.printf(this.ComponentName, 12) + " " + StringUtil.printf(this.InformAllComponents(this.ConnComps1, this.x1, this.y1, 1), 12) + " " + StringUtil.printf(this.InformAllComponents(this.ConnComps2, this.x2, this.y2, 2), 12) + " " + StringUtil.printf(String.valueOf(this.inv_cost), 6) + " " + StringUtil.printf(this.entry_period, 6) + " " + StringUtil.printf(this.exit_period, 6) + " " + StringUtil.printf(this.inv_owner, 7) + " " + StringUtil.printf(String.valueOf(this.getinv_type()), 6) + " " + StringUtil.printf(this.getmy_e_consumption(), 12) + " " + StringUtil.printf(String.valueOf(this.capacity), 9) + " " + StringUtil.printf(String.valueOf(this.length), 6);
        return linea;
    }
}

