/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import drasys.or.matrix.DenseVector;
import drasys.or.matrix.SparseMatrix;
import lp.constant;
import lp.lprec;
import lp.solve;

public class simplexmax
implements constant {
    public static DenseVector sol(SparseMatrix AA, DenseVector bb, SparseMatrix EE, DenseVector ee, DenseVector cc) {
        double RHS;
        int j;
        int auxc;
        int auxf;
        int i;
        int m = AA.sizeOfRows() + EE.sizeOfRows();
        int n = AA.sizeOfColumns();
        solve lpSolve = new solve();
        lprec lpIn = new lprec(0, n);
        double[] v = new double[n + 1];
        double[] res = new double[n + 1];
        DenseVector R = new DenseVector(n + m);
        for (i = 1; i < n + 1; ++i) {
            v[i] = cc.elementAt(i - 1);
        }
        lpSolve.set_obj_fn(lpIn, v);
        lpSolve.set_maxim(lpIn);
        for (i = 1; i < n + 1; ++i) {
            lpSolve.set_lowbo(lpIn, i, -1.0);
        }
        if (EE.sizeOfColumns() == 0 || EE.sizeOfRows() == 0) {
            auxf = 0;
            auxc = 0;
        } else {
            auxf = EE.sizeOfRows();
            auxc = EE.sizeOfColumns();
        }
        if (EE.sizeOfColumns() > 0 && EE.sizeOfRows() > 0) {
            for (i = 0; i < auxf; ++i) {
                for (j = 1; j < n + 1; ++j) {
                    res[j] = EE.elementAt(i, j - 1);
                }
                RHS = ee.elementAt(i);
                lpSolve.add_constraint(lpIn, res, (short)1, RHS);
            }
        }
        if (AA.sizeOfColumns() > 0 && AA.sizeOfRows() > 0) {
            for (i = auxf; i < m; ++i) {
                for (j = 1; j < n + 1; ++j) {
                    res[j] = AA.elementAt(i - auxf, j - 1);
                }
                RHS = bb.elementAt(i - auxf);
                lpSolve.add_constraint(lpIn, res, (short)0, RHS);
            }
        }
        for (i = 0; i <= lpIn.getRows(); ++i) {
            lpSolve.get_row(lpIn, i, v);
        }
        int result = lpSolve.solve(lpIn);
        if (result != 0) {
            System.out.println("Infeasibility founded");
        } else {
            for (i = 0; i < n; ++i) {
                R.setElementAt(i, lpIn.getBestSolution(i + m + 1));
            }
            for (i = n; i < n + m; ++i) {
                R.setElementAt(i, lpIn.getDuals(i - n + 1));
            }
        }
        return R;
    }
}

