/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import JSci.maths.Complex;
import de.core.Busbar;
import de.core.CvaLinPartes;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.Trafo;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_comp;
import de.core.hdb_irr;
import de.core.hdb_link;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.core.ndb_branch;
import de.core.ndb_inj;
import de.core.seeds.SEEDS_BendCut;
import de.core.seeds.SEEDS_Exception;
import de.core.seeds.SEEDS_Frame;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;

public final class SEEDS_Utils {
    static String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    static int[] monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static int[] monthDaysAcum = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    static String[] AffMonNames = new String[]{"ABR", "MAY", "JUN", "JUL", "AGO", "SEP", "OCT", "NOV", "DIC", "ENE", "FEB", "MAR"};
    public Vector busVector = null;
    public Vector branchesVector = null;
    public Vector generatorVector = null;
    public Vector reservoirVector = null;
    String[] busNames = null;
    double[][] busPLoad = null;
    Vector stageDef = null;
    int[] weeksDur = null;
    int[] stageFrTo = null;
    Date[][] stageDiniDend = null;
    int[][] stageIndHYear = null;
    int[][] randSimHydYear = null;
    int[] stageIndHMonth = null;
    Date iniHorizDate = null;
    Date endHorizDate = null;
    static String[] mantCxSt = new String[]{"Conexion", "Cx_Mantenimientos", "FlujoIJ_Max", "FlujoJI_Max"};
    static String[] mantGenSt = new String[]{"Generador", "Gen_Mantenimientos", "PG_Min", "PG_Max"};
    static String[] mantResSt = new String[]{"Embalse", "Emb_Mantenimientos", "Cota_Min", "Cota_Max"};
    CvaLinPartes[] funcCotaVol = null;
    public int[] bloStagNumH = null;
    public int[] bloStagMonth = null;
    public int[] bloStagYear = null;
    public Vector bloStagDefVec = null;
    Random myRandNumGen = null;
    private Schematic sch;
    private Connection dBConn;
    public Generator[] thermalGen;
    public Vector hydUnitsVec;
    public Generator[] resEleGen;
    public Generator[] serEleGen;
    public Generator[] ppEleGen;
    public hdb_res[] resHydGen;
    public hdb_ser[] serHydGen;
    public hdb_paspur[] ppHydGen;
    public hdb_ser[] filHydGen;
    public hdb_irr[] irrigs;
    private DeepEdit applet;
    private double[][] auxAffMat = null;
    private double[][] auxWeekAffMat = null;
    private double[][] auxWSAffsMat = null;
    private double[][] auxppBMat = null;
    public Vector sysLoadsV = null;

    SEEDS_Utils(Schematic psch, Connection pdBConn, DeepEdit depApp) {
        this.sch = psch;
        this.dBConn = pdBConn;
        this.applet = depApp;
    }

    public Vector getStageDef() throws Exception {
        if (this.stageDef != null) {
            return this.stageDef;
        }
        int regcount = 0;
        this.stageDef = new Vector(36);
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Def_Etapas ORDER BY Num_Etapa");
        while (r.next()) {
            int stage = r.getInt("Num_Etapa");
            int value = r.getInt("Duracion");
            if (stage != ++regcount || value < 1) {
                throw new SEEDS_Exception("tabla Def_Etapas, datos inconsistentes., SEEDSDB");
            }
            this.stageDef.addElement(new Integer(value));
        }
        s.close();
        return this.stageDef;
    }

    public double[][] getStagesLength(double rate, int b) {
        int hours_x = 0;
        try {
            rate /= 100.0;
            Vector<double[]> aux = new Vector<double[]>(12, 12);
            Statement s = this.dBConn.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM Stages_Manager ORDER BY Stages");
            while (r.next()) {
                switch (r.getInt(3)) {
                    case 1: {
                        hours_x = r.getInt(2);
                        break;
                    }
                    case 2: {
                        hours_x = r.getInt(2) * 24;
                        break;
                    }
                    case 3: {
                        hours_x = r.getInt(2) * 720;
                        break;
                    }
                    case 4: {
                        hours_x = r.getInt(2) * 8760;
                        break;
                    }
                    default: {
                        hours_x = r.getInt(2);
                        System.out.println("It was loaded " + hours_x + " hours in stage " + r.getInt(1) + ".");
                    }
                }
                double tasa = 1.0 / Math.pow(1.0 + rate, (double)hours_x / 8760.0);
                double[] val = new double[3 + 2 * b];
                val[0] = hours_x;
                val[1] = r.getDouble(4);
                val[2] = tasa;
                if (b < 2) {
                    val[3] = 100.0;
                    val[4] = 100.0;
                } else {
                    for (int i = 0; i < 2 * b; ++i) {
                        val[3 + i] = r.getDouble(5 + i);
                    }
                }
                aux.addElement(val);
            }
            s.close();
            double[][] lengths = new double[aux.size()][3 + 2 * b];
            for (int i = 0; i < lengths.length; ++i) {
                lengths[i] = (double[])aux.elementAt(i);
            }
            return lengths;
        }
        catch (Exception ex) {
            System.out.println("Information about stages were not founded && replaced by zeros.");
            return new double[1][3];
        }
    }

    public int[] getWeeksDur() throws Exception {
        if (this.weeksDur != null) {
            return this.weeksDur;
        }
        int regcount = 0;
        int month = 1;
        int week = 1;
        int dur = 7;
        int cmonth = 1;
        int cweek = 1;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FDCA_Semanas ORDER BY Mes, Semana");
        int[] weekdur = new int[48];
        while (r.next()) {
            month = r.getInt("Mes");
            week = r.getInt("Semana");
            dur = r.getInt("Num_dias");
            if (month != cmonth || week != cweek || dur < 7 || dur > 8) {
                throw new SEEDS_Exception("Numero incorrecto de dias en Dem_FDCA_Semanas, SEEDSDB");
            }
            weekdur[regcount] = dur;
            ++regcount;
            if (++cweek != 5) continue;
            cweek = 1;
            ++cmonth;
        }
        s.close();
        regcount = 0;
        for (int i = 0; i < 48; ++i) {
            regcount += weekdur[i];
        }
        if (regcount > 365) {
            System.out.println("SEEDS Problem: Number of annual days isn't 365, is " + regcount + ".");
        }
        this.weeksDur = weekdur;
        return weekdur;
    }

    public double[] getWeeksPEngy() throws Exception {
        double pEngy;
        int regcount = 0;
        int month = 1;
        int week = 1;
        int cmonth = 1;
        int cweek = 1;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FDCA_Semanas ORDER BY Mes, Semana");
        double[] weekPEngy = new double[48];
        while (r.next()) {
            month = r.getInt("Mes");
            week = r.getInt("Semana");
            pEngy = r.getDouble("FDDS");
            if (month != cmonth || week != cweek) {
                throw new SEEDS_Exception("datos incorrectos de FDDS en Dem_FDCA_Semanas, SEEDSDB");
            }
            weekPEngy[regcount] = pEngy;
            ++regcount;
            if (++cweek != 5) continue;
            cweek = 1;
            ++cmonth;
        }
        s.close();
        pEngy = 0.0;
        for (int i = 0; i < 48; ++i) {
            pEngy += weekPEngy[i];
        }
        if (pEngy > 100.1 || pEngy < 99.9) {
            System.out.println("SEEDS Problem: Temporal distribution of energy isn't 100[%], is " + pEngy + "[%].");
        }
        return weekPEngy;
    }

    public String[] getBlocksNames() throws Exception {
        int regcount = 0;
        int block = 0;
        int numblocks = SEEDS_Frame.n_Blocks;
        if (numblocks == 0) {
            throw new SEEDS_Exception("Numero de bloques incorrectos en Param_Sim, SEEDSDB");
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Nombre_Bloques_CDC WHERE (Grupo_NumBloques=" + numblocks + ") ORDER BY Num_Bloque");
        String[] BlocksNames = new String[numblocks];
        while (r.next()) {
            block = r.getInt("Num_Bloque");
            if (++regcount != block || regcount > numblocks) {
                throw new SEEDS_Exception("tabla Nombre_Bloques_CDC, datos incorrectos, SEEDSDB");
            }
            BlocksNames[regcount - 1] = r.getString("Nombre_Bloque");
        }
        s.close();
        return BlocksNames;
    }

    public double getYearRate(int Year) throws Exception {
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Tasas_Descuento WHERE (Ano=" + Year + ") ORDER BY Ano");
        double value = 1.0;
        while (r.next()) {
            value = r.getInt("Tasa_Descuento");
        }
        s.close();
        return value;
    }

    public double[][] getBlocksPDur() throws Exception {
        int regcount = 0;
        int numblocks = SEEDS_Frame.n_Blocks;
        if (numblocks == 0) {
            throw new SEEDS_Exception("Numero de bloques incorrectos en Param_Sim, SEEDSDB");
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FCDC_Semanal_" + numblocks + "B" + " ORDER BY Mes, Semana");
        double[][] blocksPDur = new double[48][numblocks];
        while (r.next()) {
            if (regcount > 47) {
                throw new SEEDS_Exception("tabla Dem_FCDC_Semanal_" + numblocks + "B, datos incorrectos, SEEDSDB");
            }
            double sumver = 0.0;
            for (int i = 1; i <= numblocks; ++i) {
                blocksPDur[regcount][i - 1] = r.getDouble("Bloq" + i + "_Fact_Dur");
                if (blocksPDur[regcount][i - 1] <= 0.0) {
                    throw new SEEDS_Exception("tabla Dem_FCDC_Semanal_" + numblocks + "B, duracion de bloques incorrecta, SEEDSDB");
                }
                sumver += blocksPDur[regcount][i - 1];
            }
            if (sumver > 100.1 || sumver < 99.9) {
                System.out.println("SEEDS Problem: Temporal distribution of blocks isn't 100[%], is " + sumver + "[%].");
            }
            ++regcount;
        }
        s.close();
        return blocksPDur;
    }

    public double[][] getBlocksPEngy() throws Exception {
        int regcount = 0;
        int numblocks = SEEDS_Frame.n_Blocks;
        if (numblocks == 0) {
            throw new SEEDS_Exception("Numero de bloques incorrectos en Param_Sim, SEEDSDB");
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FCDC_Semanal_" + numblocks + "B" + " ORDER BY Mes, Semana");
        double[][] blocksPEngy = new double[48][numblocks];
        while (r.next()) {
            if (regcount > 47) {
                throw new SEEDS_Exception("tabla Dem_FCDC_Semanal_" + numblocks + "B, datos incorrectos, SEEDSDB");
            }
            double sumver = 0.0;
            for (int i = 1; i <= numblocks; ++i) {
                blocksPEngy[regcount][i - 1] = r.getDouble("Bloq" + i + "_Fact_Dem");
                sumver += blocksPEngy[regcount][i - 1];
            }
            if (sumver > 100.1 || sumver < 99.9) {
                System.out.println("SEEDS Problem: Energy distribution of blocks isn't 100[%], is " + sumver + "[%].");
            }
            ++regcount;
        }
        s.close();
        return blocksPEngy;
    }

    public String[] getBusNames() {
        if (this.busVector == null) {
            int ix;
            this.busVector = new Vector(30);
            for (ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp TempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(TempComponent instanceof Busbar) || !TempComponent.getinservice()) continue;
                this.busVector.addElement(TempComponent);
            }
            this.busNames = new String[this.busVector.size()];
            for (ix = 0; ix < this.busVector.size(); ++ix) {
                this.busNames[ix] = ((Busbar)this.busVector.elementAt(ix)).getName();
            }
        }
        return this.busNames;
    }

    public Vector getBusVector() {
        if (this.busVector != null) {
            return this.busVector;
        }
        this.getBusNames();
        return this.busVector;
    }

    public Vector getLoadsVector() {
        if (this.sysLoadsV == null) {
            this.sysLoadsV = new Vector(40);
            for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp tempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(tempComponent instanceof Load) || !tempComponent.getinservice()) continue;
                this.sysLoadsV.addElement(tempComponent);
            }
        }
        return this.sysLoadsV;
    }

    public Vector getGenerators() {
        if (this.generatorVector == null) {
            this.generatorVector = new Vector(40);
            for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp TempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(TempComponent instanceof Generator) || !TempComponent.getinservice()) continue;
                this.generatorVector.addElement(TempComponent);
            }
        }
        return this.generatorVector;
    }

    public Vector getReservoirs() {
        if (this.reservoirVector == null) {
            this.reservoirVector = new Vector(10);
            for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp TempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(TempComponent instanceof hdb_res) || !TempComponent.getinservice()) continue;
                this.reservoirVector.addElement(TempComponent);
            }
        }
        return this.reservoirVector;
    }

    public hdb_res[] getResArr() {
        if (this.reservoirVector == null) {
            this.getReservoirs();
        }
        hdb_res[] resArr = new hdb_res[this.reservoirVector.size()];
        for (int ix = 0; ix < resArr.length; ++ix) {
            resArr[ix] = (hdb_res)this.reservoirVector.elementAt(ix);
        }
        return resArr;
    }

    public double[][] getStBlPcEn() throws Exception {
        if (this.stageDef == null) {
            this.getStageDef();
        }
        int[] daysOnWeeks = this.getWeeksDur();
        int numBlocks = SEEDS_Frame.n_Blocks;
        double[] actBlockPEngy = new double[numBlocks];
        double[][] BlocksPEngy = this.getBlocksPEngy();
        double[] WeeksPEngy = this.getWeeksPEngy();
        double[][] stBlPcEn = new double[this.stageDef.size()][numBlocks];
        int actMonth = SEEDS_Frame.n_IniMonth;
        int actWeek = SEEDS_Frame.n_IniDay;
        actWeek += actMonth * 4;
        --actWeek;
        for (int stage = 0; stage < this.stageDef.size(); ++stage) {
            int j;
            int dur = (Integer)this.stageDef.elementAt(stage);
            for (j = 0; j < numBlocks; ++j) {
                actBlockPEngy[j] = 0.0;
            }
            int stageDays = 0;
            double stagePEngy = 0.0;
            for (int i = 0; i < dur; ++i) {
                actWeek = actWeek == 47 ? 0 : ++actWeek;
                stageDays += daysOnWeeks[actWeek];
                stagePEngy += WeeksPEngy[actWeek];
                for (j = 0; j < numBlocks; ++j) {
                    int n = j;
                    actBlockPEngy[n] = actBlockPEngy[n] + (double)daysOnWeeks[actWeek] * BlocksPEngy[actWeek][j];
                }
            }
            for (j = 0; j < numBlocks; ++j) {
                stBlPcEn[stage][j] = actBlockPEngy[j] / (double)stageDays * stagePEngy / 100.0;
            }
        }
        return stBlPcEn;
    }

    public double[] getStagBlockPEn() throws Exception {
        if (this.stageDef == null) {
            this.getStageDef();
        }
        int[] daysOnWeeks = this.getWeeksDur();
        int numBlocks = SEEDS_Frame.n_Blocks;
        double[] actBlockPEngy = new double[numBlocks];
        double[][] BlocksPEngy = this.getBlocksPEngy();
        double[] WeeksPEngy = this.getWeeksPEngy();
        double[] stagBlockEn = new double[numBlocks * this.stageDef.size()];
        int actMonth = SEEDS_Frame.n_IniMonth;
        int actWeek = SEEDS_Frame.n_IniDay;
        actWeek += actMonth * 4;
        --actWeek;
        for (int stage = 0; stage < this.stageDef.size(); ++stage) {
            int i;
            int j;
            int dur = (Integer)this.stageDef.elementAt(stage);
            for (j = 0; j < numBlocks; ++j) {
                actBlockPEngy[j] = 0.0;
            }
            int stageDays = 0;
            double stagePEngy = 0.0;
            for (i = 0; i < dur; ++i) {
                actWeek = actWeek == 47 ? 0 : ++actWeek;
                stageDays += daysOnWeeks[actWeek];
                stagePEngy += WeeksPEngy[actWeek];
                for (j = 0; j < numBlocks; ++j) {
                    int n = j;
                    actBlockPEngy[n] = actBlockPEngy[n] + (double)daysOnWeeks[actWeek] * BlocksPEngy[actWeek][j];
                }
            }
            i = stage * numBlocks;
            for (j = 0; j < numBlocks; ++j) {
                stagBlockEn[i + j] = actBlockPEngy[j] / (double)stageDays * stagePEngy / 100.0;
            }
        }
        return stagBlockEn;
    }

    public double[] getBusPLoad(int iniY, int endY, int bindex) throws Exception {
        int ibus = 0;
        Statement s = this.dBConn.createStatement();
        if (endY < iniY) {
            throw new SEEDS_Exception("a\u00f1o final inferior al inicial en parametros, SEEDSDB.");
        }
        if (this.busPLoad == null) {
            if (this.busVector == null) {
                this.getBusNames();
            }
            this.busPLoad = new double[this.busNames.length][endY - iniY + 1];
            for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
                comp tempComponent = (comp)this.sch.Components.elementAt(ix);
                if (!(tempComponent instanceof Load) || !tempComponent.getinservice()) continue;
                Load tempLoad = (Load)tempComponent;
                tempLoad.InformAllComponents();
                ibus = this.numbus(tempLoad.getcon2());
                if (ibus < 0) {
                    throw new SEEDS_Exception("load '" + tempLoad.getName() + "' no conectada.");
                }
                ResultSet r = s.executeQuery("SELECT * FROM Dem_FDCA_Cargas WHERE (Carga='" + tempLoad.getName() + "') AND (Ano>=" + iniY + ") AND (Ano<=" + endY + ") ORDER BY Ano");
                int regcount = -1;
                int year = iniY - 1;
                while (r.next()) {
                    ++regcount;
                    int sy = r.getInt("Ano");
                    double value = r.getDouble("FDDC");
                    if (sy != ++year) {
                        throw new SEEDS_Exception("no se encuentra FCDC carga'" + tempLoad.getName() + "' a\u00f1o: " + year + ", SEEDSDB.");
                    }
                    double[] dArray = this.busPLoad[ibus];
                    int n = regcount;
                    dArray[n] = dArray[n] + value;
                }
                r.close();
                if (regcount < 0) {
                    throw new SEEDS_Exception("no se encuentran FCDC para la carga'" + tempLoad.getName() + ", SEEDSDB.");
                }
                if (year == endY) continue;
                throw new SEEDS_Exception("no se encuentra FCDC carga'" + tempLoad.getName() + "' a\u00f1o: " + year + ", SEEDSDB.");
            }
        }
        s.close();
        return this.busPLoad[bindex];
    }

    public double[] getLoadPcADem(int iniY, int endY, Load tempLoad) throws Exception {
        Statement s = this.dBConn.createStatement();
        if (endY < iniY) {
            throw new SEEDS_Exception("a\u00f1o final inferior al inicial en parametros, SEEDSDB.");
        }
        double[] loadPcADem = new double[endY - iniY + 1];
        ResultSet r = s.executeQuery("SELECT * FROM Dem_FDCA_Cargas WHERE (Carga='" + tempLoad.getName() + "') AND (Ano>=" + iniY + ") AND (Ano<=" + endY + ") ORDER BY Ano");
        int regcount = -1;
        int year = iniY - 1;
        while (r.next()) {
            ++regcount;
            int sy = r.getInt("Ano");
            double value = r.getDouble("FDDC");
            if (sy != ++year) {
                throw new SEEDS_Exception("no se encuentra FCDC carga'" + tempLoad.getName() + "' a\u00f1o: " + year + ", SEEDSDB.");
            }
            loadPcADem[regcount] = value;
        }
        r.close();
        if (regcount < 0) {
            throw new SEEDS_Exception("no se encuentran FCDC para la carga'" + tempLoad.getName() + ", SEEDSDB.");
        }
        if (year != endY) {
            throw new SEEDS_Exception("no se encuentra FCDC carga'" + tempLoad.getName() + "' a\u00f1o: " + year + ", SEEDSDB.");
        }
        s.close();
        return loadPcADem;
    }

    public double[] getLoadsPortions(String load, int nB) throws Exception {
        double[] portions = new double[nB];
        try {
            Statement s = this.dBConn.createStatement();
            ResultSet r = s.executeQuery("SELECT * FROM Loads_Manager WHERE TRIM(Demand)='" + load + "'");
            if (r.next()) {
                try {
                    for (int i = 0; i < nB; ++i) {
                        portions[i] = r.getDouble(3 + i);
                    }
                }
                catch (Exception e) {}
            } else {
                System.out.println("Demanda " + load + " no encontrada.");
            }
            r.close();
            s.close();
            return portions;
        }
        catch (Exception er) {
            System.out.println("Information about load '" + load + "' was not founded && replaced by zeros.");
            return new double[nB];
        }
    }

    public double[] getBusFaultCost() throws Exception {
        int ibus;
        int numsysloads = 0;
        double sysPromFailCost = 0.0;
        if (this.busVector == null) {
            this.getBusNames();
        }
        double[] failcost = new double[this.busNames.length];
        int[] numloads = new int[this.busNames.length];
        for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
            comp tempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(tempComponent instanceof Load) || !tempComponent.getinservice()) continue;
            Load tempLoad = (Load)tempComponent;
            tempLoad.InformAllComponents();
            ibus = this.numbus(tempLoad.getcon2());
            if (ibus < 0) {
                throw new SEEDS_Exception("load '" + tempLoad.getName() + "' no conectada.");
            }
            int n = ibus;
            numloads[n] = numloads[n] + 1;
            int n2 = ibus;
            failcost[n2] = failcost[n2] + tempLoad.getbeta();
            sysPromFailCost += tempLoad.getbeta();
            ++numsysloads;
        }
        if (numsysloads > 0) {
            sysPromFailCost /= (double)numsysloads;
        }
        for (ibus = 0; ibus < this.busNames.length; ++ibus) {
            if (numloads[ibus] > 0) {
                int n = ibus;
                failcost[n] = failcost[n] / (double)numloads[ibus];
                continue;
            }
            failcost[ibus] = sysPromFailCost;
        }
        return failcost;
    }

    public Vector getStBlNumHours() throws Exception {
        int iniYear;
        if (this.stageDef == null) {
            this.getStageDef();
        }
        int[] daysOnWeeks = this.getWeeksDur();
        int numBlocks = SEEDS_Frame.n_Blocks;
        int[] actBlocksNH = new int[numBlocks];
        double[][] stBlPcDur = this.getBlocksPDur();
        int[][] stBlNumHours = new int[this.stageDef.size()][numBlocks];
        int[] stageMonth = new int[this.stageDef.size()];
        int[] stageYear = new int[this.stageDef.size()];
        int[] auxhydMonth = this.getStageIndHydMonth();
        int cyear = 1;
        int actYear = iniYear = SEEDS_Frame.n_IniYear;
        int actMonth = SEEDS_Frame.n_IniMonth;
        int actWeek = SEEDS_Frame.n_IniDay;
        actWeek += actMonth * 4;
        --actWeek;
        for (int stage = 0; stage < this.stageDef.size(); ++stage) {
            int j;
            int dur = (Integer)this.stageDef.elementAt(stage);
            for (j = 0; j < numBlocks; ++j) {
                actBlocksNH[j] = 0;
            }
            int stageHours = 0;
            for (int i = 0; i < dur; ++i) {
                if (actWeek == 47) {
                    actWeek = 0;
                    ++cyear;
                } else {
                    ++actWeek;
                }
                stageHours += daysOnWeeks[actWeek] * 24;
                for (j = 0; j < numBlocks; ++j) {
                    int n = j;
                    actBlocksNH[n] = (int)((long)actBlocksNH[n] + Math.round((double)daysOnWeeks[actWeek] * stBlPcDur[actWeek][j] * 0.24));
                }
            }
            for (j = 0; j < numBlocks; ++j) {
                stageHours -= actBlocksNH[j];
            }
            int n = numBlocks - 1;
            actBlocksNH[n] = actBlocksNH[n] + stageHours;
            stageMonth[stage] = auxhydMonth[stage];
            stageYear[stage] = cyear;
            for (j = 0; j < numBlocks; ++j) {
                stBlNumHours[stage][j] = actBlocksNH[j];
            }
        }
        Vector<Object> tempVec = new Vector<Object>(3);
        tempVec.addElement(stageYear);
        tempVec.addElement(stageMonth);
        tempVec.addElement(stBlNumHours);
        return tempVec;
    }

    public Vector getBloStagNumH() throws Exception {
        int iniYear;
        if (this.bloStagDefVec != null) {
            return this.bloStagDefVec;
        }
        if (this.stageDef == null) {
            this.getStageDef();
        }
        int[] daysOnWeeks = this.getWeeksDur();
        int numBlocks = SEEDS_Frame.n_Blocks;
        int[] actBlocksNH = new int[numBlocks];
        double[][] BlocksPDur = this.getBlocksPDur();
        this.bloStagNumH = new int[numBlocks * this.stageDef.size()];
        this.bloStagMonth = new int[numBlocks * this.stageDef.size()];
        this.bloStagYear = new int[numBlocks * this.stageDef.size()];
        int[] auxhydMonth = this.getStageIndHydMonth();
        int cyear = 1;
        int actYear = iniYear = SEEDS_Frame.n_IniYear;
        int actMonth = SEEDS_Frame.n_IniMonth;
        int actWeek = SEEDS_Frame.n_IniDay;
        actWeek += actMonth * 4;
        --actWeek;
        for (int stage = 0; stage < this.stageDef.size(); ++stage) {
            int i;
            int j;
            int dur = (Integer)this.stageDef.elementAt(stage);
            for (j = 0; j < numBlocks; ++j) {
                actBlocksNH[j] = 0;
            }
            int stageHours = 0;
            for (i = 0; i < dur; ++i) {
                if (actWeek == 47) {
                    actWeek = 0;
                    ++cyear;
                } else {
                    ++actWeek;
                }
                stageHours += daysOnWeeks[actWeek] * 24;
                for (j = 0; j < numBlocks; ++j) {
                    int n = j;
                    actBlocksNH[n] = (int)((long)actBlocksNH[n] + Math.round((double)daysOnWeeks[actWeek] * BlocksPDur[actWeek][j] * 0.24));
                }
            }
            for (j = 0; j < numBlocks; ++j) {
                stageHours -= actBlocksNH[j];
            }
            int n = numBlocks - 1;
            actBlocksNH[n] = actBlocksNH[n] + stageHours;
            i = stage * numBlocks;
            for (j = 0; j < numBlocks; ++j) {
                this.bloStagYear[i + j] = cyear;
                this.bloStagNumH[i + j] = actBlocksNH[j];
                this.bloStagMonth[i + j] = auxhydMonth[stage];
            }
        }
        this.bloStagDefVec = new Vector(3);
        this.bloStagDefVec.addElement(this.bloStagYear);
        this.bloStagDefVec.addElement(this.bloStagMonth);
        this.bloStagDefVec.addElement(this.bloStagNumH);
        return this.bloStagDefVec;
    }

    public double[] getAnnEngy(int iniY, int endY) throws Exception {
        int regcount = -1;
        if (endY < iniY) {
            throw new SEEDS_Exception("a\u00f1o final inferior al inicial en parametros, SEEDSDB.");
        }
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Demanda_Anual WHERE (Ano >= " + iniY + ") AND (Ano<=" + endY + ") ORDER BY Ano");
        int year = iniY - 1;
        double[] annEngy = new double[endY - iniY + 1];
        while (r.next()) {
            ++regcount;
            int sy = r.getInt("Ano");
            double value = r.getDouble("Energia");
            if (++year != sy) {
                throw new SEEDS_Exception("no se encuentra demanada de energia a\u00f1o " + year + ", SEEDSDB.");
            }
            annEngy[regcount] = value;
        }
        s.close();
        if (regcount < 0) {
            throw new SEEDS_Exception("no se encontr\u00ed informaci\u00edn de demanada anual de energ\u00eda, SEEDSDB.");
        }
        if (year != endY) {
            throw new SEEDS_Exception("no se encuentra demanada de energia a\u00f1o " + year + ", SEEDSDB.");
        }
        return annEngy;
    }

    public int numbus(String Busbarname) {
        if (this.busVector == null) {
            this.getBusNames();
        }
        for (int ix = 0; ix < this.busNames.length; ++ix) {
            if (!this.busNames[ix].equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    public Vector getBranches() throws Exception {
        if (this.branchesVector != null) {
            return this.branchesVector;
        }
        this.branchesVector = new Vector(30);
        this.getBusNames();
        boolean[][] cxMat = new boolean[this.busNames.length][this.busNames.length];
        for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
            ndb_branch tempbranch;
            comp tempComponent = (comp)this.sch.Components.elementAt(ix);
            if (!(tempComponent instanceof ndb_branch) || !(tempbranch = (ndb_branch)tempComponent).getinservice()) continue;
            if (tempbranch instanceof Line || tempbranch instanceof Trafo) {
                if (tempbranch instanceof Line) {
                    Line TempLine = (Line)tempbranch;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                } else {
                    tempbranch.InformAllComponents();
                }
                int busi = this.numbus(tempbranch.getcon1());
                int busj = this.numbus(tempbranch.getcon2());
                if (busi < 0 || busj < 0) {
                    new SEEDS_Exception("rama '" + tempbranch.getName() + "' mal conectada.");
                }
                if (cxMat[busi][busj] || cxMat[busj][busi]) {
                    new SEEDS_Exception("herramienta SEEDS no acepta ramas en paralelo, reduzca '" + tempbranch.getName() + "'");
                } else {
                    cxMat[busj][busi] = true;
                    cxMat[busi][busj] = true;
                }
                this.branchesVector.addElement(tempbranch);
                continue;
            }
            throw new SEEDS_Exception("herramienta SEEDS no permite este objeto:'" + tempComponent.getName() + "'");
        }
        return this.branchesVector;
    }

    public double[] getCxParam(String bname) throws Exception {
        int regcount = 0;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Conexiones WHERE (Conexion = '" + bname + "')");
        double[] cxParam = new double[4];
        while (r.next()) {
            double value;
            ++regcount;
            cxParam[0] = value = r.getDouble("Flujo_Max_IJ");
            cxParam[1] = value = r.getDouble("Flujo_Max_JI");
            cxParam[2] = value = r.getDouble("Mod_Perdidas");
            cxParam[3] = value = r.getDouble("Num_Tramos");
        }
        s.close();
        if (regcount == 0) {
            throw new SEEDS_Exception("sin datos para la rama '" + bname + "' en tabla 'Conexiones', SEEDSDB.");
        }
        if (regcount > 1) {
            throw new SEEDS_Exception("tabla 'Conexiones' con exceso de registros para rama '" + bname + "', SEEDSDB.");
        }
        return cxParam;
    }

    public double[] getGenParam(String gname) throws Exception {
        double[] genParam = new double[2];
        if (this.generatorVector != null) {
            for (int ix = 0; ix < this.generatorVector.size(); ++ix) {
                Generator tempGen = (Generator)this.generatorVector.elementAt(ix);
                if (!gname.equals(tempGen.getName())) continue;
                genParam[0] = tempGen.getpmin();
                genParam[1] = tempGen.getpmax();
                break;
            }
        }
        return genParam;
    }

    public double[] getResParam(String rname) throws Exception {
        int regcount = 0;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Embalses WHERE (Embalse = '" + rname + "')");
        double[] resParam = new double[7];
        while (r.next()) {
            double value;
            ++regcount;
            resParam[0] = value = r.getDouble("Cota_Min");
            resParam[1] = value = r.getDouble("Cota_Max");
            resParam[2] = value = r.getDouble("Uso_CMg_Final");
            resParam[3] = 1.0;
            resParam[4] = value = r.getDouble("Cota_Inicial");
            resParam[5] = value = r.getDouble("Cota_Final");
            resParam[6] = value = r.getDouble("Filt_Med");
        }
        s.close();
        if (regcount == 0) {
            throw new SEEDS_Exception("sin datos para el embalse4 '" + rname + "' en tabla 'Embalses', SEEDSDB.");
        }
        if (regcount > 1) {
            throw new SEEDS_Exception("tabla 'Embalses' con exceso de registros para embalse '" + rname + "', SEEDSDB.");
        }
        return resParam;
    }

    public int getNumStages() throws Exception {
        Vector stV = this.getStageDef();
        return stV.size();
    }

    public static int daysLap1inLap2(Date iniLap1, Date endLap1, Date iniLap2, Date endLap2) {
        if (endLap1.before(iniLap2) || iniLap1.after(endLap2)) {
            return 0;
        }
        if (endLap1.equals(iniLap2) || iniLap1.equals(endLap2)) {
            return 1;
        }
        Date ini = iniLap1.after(iniLap2) || iniLap1.equals(iniLap2) ? iniLap1 : iniLap2;
        Date end = endLap1.before(endLap2) || endLap1.equals(endLap2) ? endLap1 : endLap2;
        int durdays = (int)((double)(end.getTime() - ini.getTime()) / 3600.0 / 1000.0 / 24.0);
        if (durdays < 0) {
            return 0;
        }
        return durdays + 1;
    }

    public static int daysinLap(Date iniLap, Date endLap) {
        int ndays = (int)((double)(endLap.getTime() - iniLap.getTime()) / 3600.0 / 1000.0 / 24.0);
        return ndays + 1;
    }

    public Date getIniHorizDate() throws Exception {
        if (this.iniHorizDate == null) {
            int[] weeksDur = this.getWeeksDur();
            int month = SEEDS_Frame.n_IniMonth;
            int week = SEEDS_Frame.n_IniDay;
            int day = 1;
            for (int i = 0; i < week; ++i) {
                day += weeksDur[month * 4 + i];
            }
            this.iniHorizDate = new Date(SEEDS_Frame.n_IniYear - 1900, month, day);
        }
        return this.iniHorizDate;
    }

    public Date getEndHorizDate() throws Exception {
        if (this.endHorizDate == null) {
            int[] weeksDur = this.getWeeksDur();
            int month = SEEDS_Frame.n_EndMonth;
        }
        return this.endHorizDate;
    }

    public int[] getStageIndHydMonth() throws Exception {
        if (this.stageIndHMonth != null) {
            return this.stageIndHMonth;
        }
        int actMonth = SEEDS_Frame.n_IniMonth;
        int iniStWeek = SEEDS_Frame.n_IniDay;
        iniStWeek += actMonth * 4;
        this.getStageDef();
        this.stageIndHMonth = new int[this.stageDef.size()];
        if ((iniStWeek -= 12) < 0) {
            iniStWeek += 48;
        }
        for (int stage = 0; stage < this.stageDef.size(); ++stage) {
            this.stageIndHMonth[stage] = iniStWeek / 4 + 1;
            if ((iniStWeek += ((Integer)this.stageDef.elementAt(stage)).intValue()) <= 47) continue;
            iniStWeek -= 48;
        }
        return this.stageIndHMonth;
    }

    public int getRandInt(int nmax) throws Exception {
        if (this.myRandNumGen == null) {
            this.myRandNumGen = new Random(SEEDS_Frame.n_HS_seed);
        }
        return (int)((double)(this.myRandNumGen.nextFloat() * (float)nmax) - 1.0E-6) + 1;
    }

    public int[] getAperArray(int numHStat, int numApe) throws Exception {
        int[] apeArray = new int[numApe];
        for (int i = 0; i < numApe; ++i) {
            apeArray[i] = this.getRandInt(numHStat);
        }
        return apeArray;
    }

    public int[] getAperArray(int numHStat, int numApe, int centHydIdx) throws Exception {
        int i;
        int[] apeArray = new int[numApe];
        ArrayList<Integer> apeArrL = new ArrayList<Integer>(numHStat);
        for (i = 0; i < numHStat; ++i) {
            apeArrL.add(new Integer(i + 1));
        }
        apeArrL.remove(centHydIdx - 1);
        if (numApe + 1 > numHStat) {
            for (i = numHStat; i < numApe + 1; ++i) {
                apeArrL.add(new Integer(this.getRandInt(numHStat)));
            }
        } else {
            for (i = numHStat - 1; i > numApe; --i) {
                apeArrL.remove(this.getRandInt(i) - 1);
            }
        }
        for (i = 0; i < numApe; ++i) {
            apeArray[i] = (Integer)apeArrL.get(i);
        }
        return apeArray;
    }

    public void loadFuncCotaVol() throws Exception {
        Vector resVec = null;
        resVec = this.reservoirVector == null ? this.getReservoirs() : this.reservoirVector;
        this.funcCotaVol = new CvaLinPartes[resVec.size()];
        Statement s = this.dBConn.createStatement();
        for (int i = 0; i < resVec.size(); ++i) {
            Vector<Double> vecCotas = new Vector<Double>(200);
            Vector<Double> vecVol = new Vector<Double>(200);
            hdb_res tempRes = (hdb_res)resVec.elementAt(i);
            ResultSet r = s.executeQuery("SELECT * FROM Emb_Fnc_Cota_Volumen WHERE (TRIM(Embalse)='" + tempRes.getName() + "') ORDER BY Intervalo");
            int regcount = 0;
            double prevVol = -10.0;
            double prevCota = -10.0;
            while (r.next()) {
                ++regcount;
                double cota = r.getDouble("Cota");
                double volumen = r.getDouble("Volumen");
                int intervalo = r.getInt("Intervalo");
                if (cota <= prevCota || volumen <= prevVol) {
                    throw new SEEDS_Exception("Relacion cota-volumen no creciente, intervalo '" + intervalo + "' embalse '" + tempRes.getName() + "', SEEDSDB.");
                }
                if (intervalo != regcount) {
                    throw new SEEDS_Exception("Intervalo cota-volumen '" + intervalo + "' no encontrado, embalse '" + tempRes.getName() + "', SEEDSDB.");
                }
                vecCotas.addElement(new Double(cota));
                vecVol.addElement(new Double(volumen));
                prevCota = cota;
                prevVol = volumen;
            }
            if (regcount == 0) {
                throw new SEEDS_Exception("no se encuentra relacion cota-volumen embalse '" + tempRes.getName() + "', SEEDSDB.");
            }
            r.close();
            this.funcCotaVol[i] = new CvaLinPartes(vecCotas, vecVol);
        }
        s.close();
    }

    public double evalCota2Vol(double cota, int resOrdNum) throws SEEDS_Exception {
        if (this.reservoirVector == null) {
            throw new SEEDS_Exception("numero de embalse incorrecto, evalCota2Vol.");
        }
        if (this.funcCotaVol == null) {
            throw new SEEDS_Exception("funciones de relacion cota-volumen no cargadas.");
        }
        return this.funcCotaVol[resOrdNum].evalIn(cota);
    }

    public double evalVol2Cota(double vol, int resOrdNum) throws SEEDS_Exception {
        if (this.reservoirVector == null) {
            throw new SEEDS_Exception("numero de embalse incorrecto, evalCota2Vol.");
        }
        if (this.funcCotaVol == null) {
            throw new SEEDS_Exception("funciones de relacion cota-volumen no cargadas.");
        }
        return this.funcCotaVol[resOrdNum].evalInverseIn(vol);
    }

    public double evalCota2Vol(double cota, String resName) throws SEEDS_Exception {
        int resOrd = this.getResOrd(resName);
        if (resOrd < 0) {
            throw new SEEDS_Exception("embalse '" + resName + "', no encontrado en sistema.");
        }
        return this.evalCota2Vol(cota, resOrd);
    }

    public double evalVol2Cota(double vol, String resName) throws SEEDS_Exception {
        int resOrd = this.getResOrd(resName);
        if (resOrd < 0) {
            throw new SEEDS_Exception("embalse '" + resName + "', no encontrado en sistema.");
        }
        return this.evalVol2Cota(vol, resOrd);
    }

    public int getResOrd(String resName) throws SEEDS_Exception {
        if (this.reservoirVector == null) {
            throw new SEEDS_Exception("vector de embalses no cargado");
        }
        int resOrd = -1;
        for (int i = 0; i < this.reservoirVector.size(); ++i) {
            hdb_res tempRes = (hdb_res)this.reservoirVector.elementAt(i);
            if (!resName.equals(tempRes.getName())) continue;
            resOrd = i;
            break;
        }
        return resOrd;
    }

    public double[][] getRendTangents(int resOrdNum) throws Exception {
        if (this.reservoirVector == null) {
            return null;
        }
        double[][] tangArray = null;
        hdb_res tempRes = (hdb_res)this.reservoirVector.elementAt(resOrdNum);
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Emb_Tang_Func_Rendimiento WHERE (TRIM(Embalse)='" + tempRes.getName() + "') ORDER BY Tramo");
        int regcount = 0;
        Vector<double[]> tangVec = new Vector<double[]>(10);
        while (r.next()) {
            ++regcount;
            int tramo = r.getInt("Tramo");
            double volumen = r.getDouble("Volumen");
            double pend = r.getDouble("Pendiente");
            double constante = r.getDouble("Constante");
            double fesc = r.getDouble("FEscala");
            if (tramo != regcount) {
                throw new SEEDS_Exception("tramo tang-rendimiento '" + tramo + "' no encontrado, embalse '" + tempRes.getName() + "', SEEDSDB.");
            }
            double[] auxArr = new double[]{volumen, pend, constante, fesc};
            tangVec.addElement(auxArr);
        }
        s.close();
        tangArray = new double[tangVec.size()][0];
        for (regcount = 0; regcount < tangVec.size(); ++regcount) {
            tangArray[regcount] = (double[])tangVec.elementAt(regcount);
        }
        return tangArray;
    }

    public double[][] getFilterTangents(int resOrdNum) throws Exception {
        if (this.reservoirVector == null) {
            this.getReservoirs();
        }
        double[][] tangArray = null;
        hdb_res tempRes = (hdb_res)this.reservoirVector.elementAt(resOrdNum);
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Emb_Tang_Func_Filtraciones WHERE (TRIM(Embalse)='" + tempRes.getName() + "') ORDER BY Tramo");
        int regcount = 0;
        Vector<double[]> tangVec = new Vector<double[]>(10);
        while (r.next()) {
            ++regcount;
            int tramo = r.getInt("Tramo");
            double volumen = r.getDouble("Volumen");
            double pend = r.getDouble("Pendiente");
            double constante = r.getDouble("Constante");
            double fesc = r.getDouble("FEscala");
            if (tramo != regcount) {
                throw new SEEDS_Exception("tramo tang-filtracion '" + tramo + "' no encontrado, embalse '" + tempRes.getName() + "', SEEDSDB.");
            }
            double[] auxArr = new double[]{volumen, pend, constante, fesc};
            tangVec.addElement(auxArr);
        }
        s.close();
        tangArray = new double[tangVec.size()][0];
        for (regcount = 0; regcount < tangVec.size(); ++regcount) {
            tangArray[regcount] = (double[])tangVec.elementAt(regcount);
        }
        return tangArray;
    }

    double[][] getPlanEmb(hdb_res resObj) throws Exception {
        int intervalo;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Emb_CMg_Finales WHERE (TRIM(Embalse)='" + resObj.getName() + "') ORDER BY Intervalo");
        int regcount = 0;
        Vector<double[]> interVec = new Vector<double[]>(10);
        while (r.next()) {
            intervalo = r.getInt("Intervalo");
            double cota = r.getDouble("Cota");
            double cmg = r.getDouble("CMg");
            if (intervalo != ++regcount) {
                throw new SEEDS_Exception("intervalo Emb_CMg_Finales '" + intervalo + "' no encontrado, embalse '" + resObj.getName() + "', SEEDSDB.");
            }
            double[] auxArr = new double[]{cota, cmg};
            interVec.addElement(auxArr);
        }
        s.close();
        double[][] planemb = new double[interVec.size()][2];
        for (regcount = 0; regcount < interVec.size(); ++regcount) {
            planemb[regcount] = (double[])interVec.elementAt(regcount);
        }
        for (intervalo = 0; intervalo < planemb.length; ++intervalo) {
            double vol = this.evalCota2Vol(planemb[intervalo][0], resObj.getName());
            double capa = resObj.getVmax() - resObj.getVmin();
            planemb[intervalo][0] = (vol - resObj.getVmin()) / capa;
            if (planemb[intervalo][0] < 0.0) {
                planemb[intervalo][0] = 0.0;
            }
            planemb[intervalo][1] = planemb[intervalo][1] * capa;
        }
        return planemb;
    }

    public void loadHydroConnect() throws Exception {
        int sx;
        Object tempcomp;
        int ix;
        if (this.hydUnitsVec != null) {
            return;
        }
        Object tempGen = null;
        hdb_comp temphdb = null;
        Object tempirr = null;
        Object tempInj = null;
        hdb_res tempRes = null;
        hdb_ser tempFilt = null;
        hdb_unit temphunit = null;
        int NS = 0;
        int NE = 0;
        int NP = 0;
        int NI = 0;
        int NF = 0;
        this.initTermHydroCx();
        Vector GenVec = this.getGenerators();
        Vector ElTeGen = (Vector)GenVec.clone();
        Vector ElHyGen = new Vector(20);
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            tempcomp = this.sch.Components.elementAt(ix);
            if (!(tempcomp instanceof hdb_unit) || !(temphunit = (hdb_unit)tempcomp).getinservice()) continue;
            if (temphunit instanceof hdb_paspur) {
                if (!this.checkAndClasifElGen(ElTeGen, ElHyGen, temphunit, "HydroS")) {
                    throw new SEEDS_Exception("unidad hidro '" + temphunit.getName() + "' generador el\u00e9ctrico asociado no encontrado");
                }
                ++NP;
                continue;
            }
            if (temphunit instanceof hdb_res) {
                if (!temphunit.getgrounded() && !this.checkAndClasifElGen(ElTeGen, ElHyGen, temphunit, "HydroR")) {
                    throw new SEEDS_Exception("unidad hidro '" + temphunit.getName() + "' generador el\u00e9ctrico asociado no encontrado");
                }
                tempRes = (hdb_res)temphunit;
                if (tempRes.getFiltType() > 0) {
                    ++NF;
                }
                ++NE;
                continue;
            }
            if (temphunit instanceof hdb_ser) {
                if (!temphunit.getgrounded() && !this.checkAndClasifElGen(ElTeGen, ElHyGen, temphunit, "HydroS")) {
                    throw new SEEDS_Exception("unidad hidro '" + temphunit.getName() + "' generador el\u00e9ctrico asociado no encontrado");
                }
                ++NS;
                continue;
            }
            if (!(temphunit instanceof hdb_irr)) continue;
            ++NI;
        }
        this.thermalGen = new Generator[ElTeGen.size()];
        ElTeGen.copyInto(this.thermalGen);
        this.resEleGen = new Generator[NE];
        this.resHydGen = new hdb_res[NE];
        this.serEleGen = new Generator[NS];
        this.serHydGen = new hdb_ser[NS];
        this.ppEleGen = new Generator[NP];
        this.ppHydGen = new hdb_paspur[NP];
        this.irrigs = new hdb_irr[NI];
        this.filHydGen = new hdb_ser[NF];
        int indNF = 0;
        int indNP = 0;
        int indNE = 0;
        int indNS = 0;
        int indNI = 0;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            tempcomp = this.sch.Components.elementAt(ix);
            if (!(tempcomp instanceof hdb_comp)) continue;
            temphdb = (hdb_comp)tempcomp;
            if (!temphunit.getinservice()) continue;
            if (temphdb instanceof hdb_paspur) {
                this.ppHydGen[indNP] = (hdb_paspur)temphdb;
                ++indNP;
                continue;
            }
            if (temphdb instanceof hdb_res) {
                this.resHydGen[indNE] = tempRes = (hdb_res)temphdb;
                ++indNE;
                if (tempRes.getFiltType() <= 0) continue;
                this.filHydGen[indNF] = tempFilt = new hdb_ser("Filt_" + tempRes.getName(), tempRes);
                ++indNF;
                continue;
            }
            if (temphdb instanceof hdb_ser) {
                this.serHydGen[indNS] = (hdb_ser)temphdb;
                ++indNS;
                continue;
            }
            if (!(temphdb instanceof hdb_irr)) continue;
            this.irrigs[indNI] = (hdb_irr)temphdb;
            ++indNI;
        }
        for (ix = 0; ix < NE; ++ix) {
            if (this.resHydGen[ix].getgrounded()) continue;
            sx = this.searchCompName(this.resHydGen[ix].getName(), ElHyGen);
            if (sx < 0) {
                throw new SEEDS_Exception("Generador el\u00e9ctrico asociado no encontrado '" + this.resHydGen[ix].getName() + "'.");
            }
            tempcomp = ElHyGen.elementAt(sx);
            this.resEleGen[ix] = (Generator)tempcomp;
        }
        for (ix = 0; ix < NS; ++ix) {
            if (this.serHydGen[ix].getgrounded()) continue;
            sx = this.searchCompName(this.serHydGen[ix].getName(), ElHyGen);
            if (sx < 0) {
                throw new SEEDS_Exception("Generador el\u00e9ctrico asociado no encontrado '" + this.serHydGen[ix].getName() + "'.");
            }
            tempcomp = ElHyGen.elementAt(sx);
            this.serEleGen[ix] = (Generator)tempcomp;
        }
        for (ix = 0; ix < NP; ++ix) {
            sx = this.searchCompName(this.ppHydGen[ix].getName(), ElHyGen);
            if (sx < 0) {
                throw new SEEDS_Exception("Generador el\u00e9ctrico asociado no encontrado '" + this.serHydGen[ix].getName() + "'.");
            }
            tempcomp = ElHyGen.elementAt(sx);
            this.ppEleGen[ix] = (Generator)tempcomp;
        }
        this.hydUnitsVec = new Vector(NE + NS + NP + NI);
        for (ix = 0; ix < NE; ++ix) {
            this.hydUnitsVec.addElement(this.resHydGen[ix]);
        }
        for (ix = 0; ix < NF; ++ix) {
            this.hydUnitsVec.addElement(this.filHydGen[ix]);
        }
        for (ix = 0; ix < NS; ++ix) {
            this.hydUnitsVec.addElement(this.serHydGen[ix]);
        }
        for (ix = 0; ix < NI; ++ix) {
            this.hydUnitsVec.addElement(this.irrigs[ix]);
        }
        for (ix = 0; ix < NP; ++ix) {
            this.hydUnitsVec.addElement(this.ppHydGen[ix]);
        }
    }

    public int searchCompName(String gname, Vector CompVec) {
        for (int i = 0; i < CompVec.size(); ++i) {
            if (!gname.equals(((comp)CompVec.elementAt(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    private boolean checkAndClasifElGen(Vector ElTeGen, Vector ElHyGen, hdb_unit temphunit, String GenType) {
        boolean found = false;
        for (int ix = 0; ix < ElTeGen.size(); ++ix) {
            Generator tempGen = (Generator)ElTeGen.elementAt(ix);
            if (!temphunit.getName().equals(tempGen.getName())) continue;
            found = true;
            tempGen.setinv_type(GenType);
            ElTeGen.removeElementAt(ix);
            ElHyGen.addElement(tempGen);
            break;
        }
        return found;
    }

    private void initTermHydroCx() throws Exception {
        int ix;
        Object tempcomp = null;
        hdb_link templink = null;
        hdb_unit tempHUnit = null;
        hdb_ser tempSer = null;
        hdb_res tempRes = null;
        hdb_irr tempIrr = null;
        Generator tempGen = null;
        boolean allok = false;
        SEEDS_Utils sEEDS_Utils = this;
        sEEDS_Utils.applet.SimulateSetUp();
        allok = false;
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            tempcomp = this.sch.Components.elementAt(ix);
            if (!(tempcomp instanceof hdb_link) || (allok = (templink = (hdb_link)tempcomp).InformEndComponents())) continue;
            throw new SEEDS_Exception("link conectado erroneamente: '" + templink.getName() + "'");
        }
        System.out.println("Links Initialized");
        for (ix = 0; ix < this.sch.Components.size(); ++ix) {
            tempcomp = this.sch.Components.elementAt(ix);
            if (tempcomp instanceof hdb_unit) {
                tempHUnit = tempcomp;
                if (!tempHUnit.getinservice()) continue;
                tempHUnit.InformRiverUpComps();
                if (tempHUnit.riverUpComps.size() == 0) {
                    throw new SEEDS_Exception("Unidad hidr\u00e1ulica aislada, " + tempHUnit.getName());
                }
                if (!(tempHUnit instanceof hdb_res ? !(tempRes = (hdb_res)tempHUnit).InformRecipients() : (tempHUnit instanceof hdb_ser ? !(tempSer = (hdb_ser)tempHUnit).InformRecipients() : tempHUnit instanceof hdb_irr && !(tempIrr = (hdb_irr)tempHUnit).InformRecipients()))) continue;
                throw new SEEDS_Exception("Unidad hidr\u00e1ulica mal conectada, " + tempHUnit.getName());
            }
            if (!(tempcomp instanceof Generator) || !(tempGen = (Generator)tempcomp).getinservice()) continue;
            tempGen.InformAllComponents();
        }
        System.out.println("hdb_units Initialized");
    }

    public double getAffMed(hdb_unit myhydUnit) {
        double affmed = 0.0;
        Vector rivUpCmp = myhydUnit.riverUpComps;
        for (int ix = 0; ix < rivUpCmp.size(); ++ix) {
            Object tempObj = rivUpCmp.elementAt(ix);
            if (!(tempObj instanceof hdb_affl) || ((hdb_affl)tempObj).getIsStoch()) continue;
            affmed += ((hdb_affl)tempObj).getQ();
        }
        return affmed;
    }

    public boolean isHUnitWStochAff(hdb_unit tempHUnit) throws Exception {
        for (int ix = 0; ix < tempHUnit.riverUpComps.size(); ++ix) {
            hdb_affl tempAff;
            if (!(tempHUnit.riverUpComps.elementAt(ix) instanceof hdb_affl) || !(tempAff = (hdb_affl)tempHUnit.riverUpComps.elementAt(ix)).getIsStoch()) continue;
            return true;
        }
        return false;
    }

    public Vector getStochAffVec() throws Exception {
        Vector<hdb_affl> stochAffVec = new Vector<hdb_affl>(20);
        for (int ix = 0; ix < this.sch.Components.size(); ++ix) {
            hdb_affl tempAff;
            comp tempComp = (comp)this.sch.Components.elementAt(ix);
            if (!(tempComp instanceof hdb_affl) || !(tempAff = (hdb_affl)tempComp).getIsStoch()) continue;
            stochAffVec.addElement(tempAff);
        }
        return stochAffVec;
    }

    public Vector getStochAffHydUnits() throws Exception {
        int ic;
        this.loadHydroConnect();
        this.initAuxMat();
        Vector<hdb_unit> stochAffHydUnitsVec = new Vector<hdb_unit>(20);
        for (ic = 0; ic < this.resHydGen.length; ++ic) {
            if (!this.isHUnitWStochAff(this.resHydGen[ic])) continue;
            stochAffHydUnitsVec.addElement(this.resHydGen[ic]);
        }
        for (ic = 0; ic < this.serHydGen.length; ++ic) {
            if (!this.isHUnitWStochAff(this.serHydGen[ic])) continue;
            stochAffHydUnitsVec.addElement(this.serHydGen[ic]);
        }
        for (ic = 0; ic < this.ppHydGen.length; ++ic) {
            if (!this.isHUnitWStochAff(this.ppHydGen[ic])) continue;
            stochAffHydUnitsVec.addElement(this.ppHydGen[ic]);
        }
        for (ic = 0; ic < this.irrigs.length; ++ic) {
            if (!this.isHUnitWStochAff(this.irrigs[ic])) continue;
            stochAffHydUnitsVec.addElement(this.irrigs[ic]);
        }
        return stochAffHydUnitsVec;
    }

    private void initAuxMat() throws Exception {
        int nhydros = SEEDS_Frame.n_FinalStat - SEEDS_Frame.n_InitialStat + 1;
        int numbloqs = SEEDS_Frame.n_Blocks;
        this.auxWeekAffMat = new double[48][nhydros];
        this.auxWSAffsMat = new double[48][nhydros];
        this.auxAffMat = new double[this.getNumStages()][nhydros];
        this.auxppBMat = new double[numbloqs][nhydros];
    }

    private double[][] getAffStat(int iniY, int endY, String affName) throws Exception {
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT * FROM Caudal_Afluentes WHERE (Afluente='" + affName + "') AND (Ano_Historico<=" + endY + ") AND (Ano_Historico>=" + iniY + ") ORDER BY Ano_Historico");
        int regcount = 0;
        int year = iniY;
        while (r.next()) {
            int sy = r.getInt("Ano_Historico");
            if (sy == year) {
                for (int ix = 0; ix < 12; ++ix) {
                    for (int jx = 0; jx < 4; ++jx) {
                        this.auxWeekAffMat[ix * 4 + jx][regcount] = r.getDouble(AffMonNames[ix] + (jx + 1));
                    }
                }
                ++year;
                ++regcount;
                continue;
            }
            if (sy <= year) continue;
        }
        s.close();
        if (year != endY + 1) {
            throw new SEEDS_Exception("no se encuentra caudal afluente'" + affName + "' a\u00f1o: " + year + ", SEEDSDB.");
        }
        return this.auxWeekAffMat;
    }

    public double[][] getAffCaud(int iniY, int endY, hdb_affl pAffl) throws Exception {
        int ihyd;
        int wk;
        int st;
        double[][] caudStat = null;
        this.initAuxMat();
        Vector stageDur = this.getStageDef();
        int[] wksdur = this.getWeeksDur();
        if (this.stageFrTo == null) {
            this.stageFrTo = new int[stageDur.size() + 1];
            for (st = 0; st < stageDur.size(); ++st) {
                this.stageFrTo[st + 1] = (Integer)stageDur.elementAt(st);
            }
            int iniHW = SEEDS_Frame.n_IniMonth * 4 + SEEDS_Frame.n_IniDay;
            if ((iniHW -= 12) < 0) {
                iniHW += 48;
            }
            this.stageFrTo[0] = iniHW;
            for (st = 1; st < this.stageFrTo.length; ++st) {
                int n = st;
                this.stageFrTo[n] = this.stageFrTo[n] + this.stageFrTo[st - 1];
                if (this.stageFrTo[st] <= 47) continue;
                int n2 = st;
                this.stageFrTo[n2] = this.stageFrTo[n2] - 48;
            }
        }
        caudStat = this.getAffStat(iniY, endY, pAffl.getName());
        for (wk = 0; wk < this.auxWSAffsMat.length; ++wk) {
            for (ihyd = 0; ihyd < this.auxWSAffsMat[0].length; ++ihyd) {
                this.auxWSAffsMat[wk][ihyd] = caudStat[wk][ihyd];
            }
        }
        for (st = 0; st < this.auxAffMat.length; ++st) {
            for (ihyd = 0; ihyd < this.auxAffMat[0].length; ++ihyd) {
                this.auxAffMat[st][ihyd] = 0.0;
            }
        }
        for (st = 0; st < this.auxAffMat.length; ++st) {
            int to = this.stageFrTo[st + 1];
            int from = this.stageFrTo[st];
            if (to <= from) {
                to += 48;
            }
            int sumdays = 0;
            for (wk = from; wk < to; ++wk) {
                boolean hydbias;
                int wkc;
                if (wk > 47) {
                    wkc = wk - 48;
                    hydbias = true;
                } else {
                    hydbias = false;
                    wkc = wk;
                }
                int wkcr = wkc + 12;
                if (wkcr > 47) {
                    wkcr -= 48;
                }
                sumdays += wksdur[wkcr];
                ihyd = 0;
                while (ihyd < this.auxWSAffsMat[0].length) {
                    int i2hyd;
                    if (hydbias) {
                        i2hyd = ihyd - 1;
                        if (i2hyd < 0) {
                            i2hyd += caudStat[0].length;
                        }
                    } else {
                        i2hyd = ihyd;
                    }
                    double[] dArray = this.auxAffMat[st];
                    int n = ihyd++;
                    dArray[n] = dArray[n] + this.auxWSAffsMat[wkc][i2hyd] * (double)wksdur[wkcr];
                }
            }
            ihyd = 0;
            while (ihyd < this.auxWSAffsMat[0].length) {
                double[] dArray = this.auxAffMat[st];
                int n = ihyd++;
                dArray[n] = dArray[n] / (double)sumdays;
            }
        }
        return this.auxAffMat;
    }

    public double[] getAffValues(int iniY, int endY, String Affl) throws Exception {
        int years = Math.abs(endY - iniY + 1);
        double[] caudal2St = new double[48 * years];
        try {
            Statement s = null;
            ResultSet r = null;
            s = this.dBConn.createStatement();
            for (int year = 0; year < years; ++year) {
                int i;
                r = s.executeQuery("SELECT * FROM Hydro_Manager WHERE (Numbers=" + (year + iniY + 1) + ") AND (TRIM(Inflow)='" + Affl + "')");
                if (r.next()) {
                    for (i = 0; i < 48; ++i) {
                        caudal2St[year * 48 + i] = r.getDouble(3 + i);
                    }
                    continue;
                }
                for (i = 0; i < 48; ++i) {
                    caudal2St[year * 48 + i] = 0.0;
                }
            }
            s.close();
        }
        catch (Exception ex) {
            System.out.println("Information about hydro station '" + Affl + "' was not founded && replaced by zeros");
        }
        return caudal2St;
    }

    public double[][] getCentAffCaud(int iniY, int endY, hdb_unit hdbUnit) throws Exception {
        int wk;
        int ihyd;
        int st;
        double[][] caudStat = null;
        Vector stageDur = this.getStageDef();
        int[] wksdur = this.getWeeksDur();
        if (this.stageFrTo == null) {
            this.stageFrTo = new int[stageDur.size() + 1];
            for (st = 0; st < stageDur.size(); ++st) {
                this.stageFrTo[st + 1] = (Integer)stageDur.elementAt(st);
            }
            int iniHW = SEEDS_Frame.n_IniMonth * 4 + SEEDS_Frame.n_IniDay;
            if ((iniHW -= 12) < 0) {
                iniHW += 48;
            }
            this.stageFrTo[0] = iniHW;
            for (st = 1; st < this.stageFrTo.length; ++st) {
                int n = st;
                this.stageFrTo[n] = this.stageFrTo[n] + this.stageFrTo[st - 1];
                if (this.stageFrTo[st] <= 47) continue;
                int n2 = st;
                this.stageFrTo[n2] = this.stageFrTo[n2] - 48;
            }
        }
        for (st = 0; st < this.auxAffMat.length; ++st) {
            for (ihyd = 0; ihyd < this.auxAffMat[0].length; ++ihyd) {
                this.auxAffMat[st][ihyd] = 0.0;
            }
        }
        for (wk = 0; wk < this.auxWSAffsMat.length; ++wk) {
            for (ihyd = 0; ihyd < this.auxWSAffsMat[0].length; ++ihyd) {
                this.auxWSAffsMat[wk][ihyd] = 0.0;
            }
        }
        for (int vecInd = 0; vecInd < hdbUnit.riverUpComps.size(); ++vecInd) {
            Object tempObj = hdbUnit.riverUpComps.elementAt(vecInd);
            if (!(tempObj instanceof hdb_affl)) continue;
            hdb_affl tempAff = (hdb_affl)tempObj;
            if (tempAff.getIsStoch()) {
                caudStat = this.getAffStat(iniY, endY, tempAff.getName());
                for (wk = 0; wk < this.auxWSAffsMat.length; ++wk) {
                    for (ihyd = 0; ihyd < this.auxWSAffsMat[0].length; ++ihyd) {
                        double[] dArray = this.auxWSAffsMat[wk];
                        int n = ihyd;
                        dArray[n] = dArray[n] + caudStat[wk][ihyd];
                    }
                }
                continue;
            }
            for (wk = 0; wk < this.auxWSAffsMat.length; ++wk) {
                ihyd = 0;
                while (ihyd < this.auxWSAffsMat[0].length) {
                    double[] dArray = this.auxWSAffsMat[wk];
                    int n = ihyd++;
                    dArray[n] = dArray[n] + tempAff.getQ();
                }
            }
        }
        for (st = 0; st < this.auxAffMat.length; ++st) {
            int to = this.stageFrTo[st + 1];
            int from = this.stageFrTo[st];
            if (to <= from) {
                to += 48;
            }
            int sumdays = 0;
            for (wk = from; wk < to; ++wk) {
                boolean hydbias;
                int wkc;
                if (wk > 47) {
                    wkc = wk - 48;
                    hydbias = true;
                } else {
                    hydbias = false;
                    wkc = wk;
                }
                int wkcr = wkc + 12;
                if (wkcr > 47) {
                    wkcr -= 48;
                }
                sumdays += wksdur[wkcr];
                ihyd = 0;
                while (ihyd < this.auxWSAffsMat[0].length) {
                    int i2hyd;
                    if (hydbias) {
                        i2hyd = ihyd - 1;
                        if (i2hyd < 0) {
                            i2hyd += caudStat[0].length;
                        }
                    } else {
                        i2hyd = ihyd;
                    }
                    double[] dArray = this.auxAffMat[st];
                    int n = ihyd++;
                    dArray[n] = dArray[n] + this.auxWSAffsMat[wkc][i2hyd] * (double)wksdur[wkcr];
                }
            }
            ihyd = 0;
            while (ihyd < this.auxWSAffsMat[0].length) {
                double[] dArray = this.auxAffMat[st];
                int n = ihyd++;
                dArray[n] = dArray[n] / (double)sumdays;
            }
        }
        return this.auxAffMat;
    }

    public double[][] getModAdjCaud(hdb_paspur myPaspPur, int stage, double[] stCaud) throws Exception {
        int i;
        int stageNumH = 0;
        if (this.bloStagNumH == null) {
            this.getBloStagNumH();
        }
        int numbloqs = this.auxppBMat.length;
        int actbloqSt = stage * numbloqs;
        ndb_inj tempGen = null;
        for (i = 0; i < numbloqs; ++i) {
            stageNumH += this.bloStagNumH[actbloqSt + i];
        }
        i = 0;
        while (i < stCaud.length) {
            int n = i++;
            stCaud[n] = stCaud[n] * (myPaspPur.getWat2PowRate() * (double)stageNumH);
        }
        for (i = 0; i < this.ppEleGen.length; ++i) {
            if (!this.ppEleGen[i].getName().equals(myPaspPur.getName())) continue;
            tempGen = this.ppEleGen[i];
            break;
        }
        if (numbloqs == 3 && (myPaspPur.getName().equals("PANGUE") || myPaspPur.getName().equals("RALPAN"))) {
            double[] porcPangue = new double[]{50.0, 30.0, 100.0};
            double[] porcRalPan = new double[]{50.0, 30.0, 100.0};
            double abEnergy = 0.0;
            double[] porc = myPaspPur.getName().equals("PANGUE") ? porcPangue : porcRalPan;
            for (i = 0; i < stCaud.length; ++i) {
                abEnergy = stCaud[i];
                for (int ibloq = 0; ibloq < numbloqs; ++ibloq) {
                    double emax = tempGen.getpmax() * (double)this.bloStagNumH[actbloqSt + ibloq];
                    this.auxppBMat[ibloq][i] = Math.min(Math.min(emax, stCaud[i]), abEnergy * porc[ibloq] / 100.0);
                    int n = i;
                    stCaud[n] = stCaud[n] - this.auxppBMat[ibloq][i];
                    double[] dArray = this.auxppBMat[ibloq];
                    int n2 = i;
                    dArray[n2] = dArray[n2] / (double)this.bloStagNumH[actbloqSt + ibloq];
                }
            }
        } else {
            for (int ibloq = 0; ibloq < numbloqs; ++ibloq) {
                double emax = tempGen.getpmax() * (double)this.bloStagNumH[actbloqSt + ibloq];
                i = 0;
                while (i < stCaud.length) {
                    this.auxppBMat[ibloq][i] = Math.min(emax, stCaud[i]);
                    int n = i;
                    stCaud[n] = stCaud[n] - this.auxppBMat[ibloq][i];
                    double[] dArray = this.auxppBMat[ibloq];
                    int n3 = i++;
                    dArray[n3] = dArray[n3] / (double)this.bloStagNumH[actbloqSt + ibloq];
                }
            }
        }
        return this.auxppBMat;
    }

    public static void renameTableRegSEEDSDB(String ActN, String NewN, String tableN, String columN, Connection dBCon) throws SQLException {
        Statement s = dBCon.createStatement();
        s.executeUpdate("UPDATE " + tableN + " SET " + columN + "='" + NewN + "' WHERE " + columN + "='" + ActN + "'");
        s.close();
    }

    public Vector<SEEDS_BendCut> getEndEFCF(hdb_res[] resArr) throws Exception {
        int jx;
        Vector<SEEDS_BendCut> vBC = new Vector<SEEDS_BendCut>();
        int n = 0;
        double[] aproxSlopes = new double[resArr.length];
        double[] aproxPoints = new double[resArr.length];
        double[][][] resEFCFP = new double[resArr.length][0][0];
        for (jx = 0; jx < resArr.length; ++jx) {
            resEFCFP[jx] = this.getPlanEmb(resArr[jx]);
            n = Math.max(n, resEFCFP[jx].length);
        }
        for (int ix = 0; ix < n; ++ix) {
            for (jx = 0; jx < resArr.length; ++jx) {
                if (resEFCFP[jx] != null) {
                    if (ix < resEFCFP[jx].length) {
                        aproxPoints[jx] = resEFCFP[jx][ix][0];
                        aproxSlopes[jx] = resEFCFP[jx][ix][1];
                        continue;
                    }
                    aproxPoints[jx] = 0.0;
                    aproxSlopes[jx] = 0.0;
                    continue;
                }
                aproxPoints[jx] = 0.0;
                aproxSlopes[jx] = 0.0;
            }
            vBC.add(new SEEDS_BendCut(aproxSlopes, aproxPoints, 0.0));
        }
        return vBC;
    }

    public void makeDynPar(int H) {
        comp tempComp;
        int ix;
        comp temp;
        ResultSet r;
        String query;
        Statement s = null;
        try {
            s = this.dBConn.createStatement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        String name1 = "";
        String name2 = "";
        int t1 = -1;
        int t2 = 0;
        try {
            query = "SELECT * FROM DynGen_Manager ORDER BY Generator, Stage DESC";
            r = s.executeQuery(query);
            temp = null;
            while (r.next()) {
                t2 = r.getInt(1) - 1;
                name2 = r.getString(2).trim();
                if (!name2.equalsIgnoreCase(name1)) {
                    name1 = name2;
                    temp = null;
                    for (ix = 0; ix < this.sch.Components.size(); ++ix) {
                        tempComp = (comp)this.sch.Components.elementAt(ix);
                        if (!(tempComp instanceof ndb_inj) || !tempComp.getName().equalsIgnoreCase(name1)) continue;
                        temp = (ndb_inj)tempComp;
                        break;
                    }
                } else if (t2 == t1 || t2 < 0) continue;
                if (temp == null) {
                    System.out.println("Was not found: " + name2 + " in t=" + (t2 + 1));
                    continue;
                }
                t1 = t2;
                double pmax = r.getDouble(4);
                temp.setDynPmin(r.getDouble(3), t2, H);
                temp.setDynPmax(pmax, t2, H);
                temp.setDynAlpha(r.getDouble(5), t2, H);
                temp.setDynBeta(r.getDouble(6), t2, H);
                temp.setDynGamma(r.getDouble(7), t2, H);
            }
        }
        catch (Exception ex) {
            System.out.println("DynGen_Manager was not made correctly.");
        }
        try {
            query = "SELECT * FROM DynSpg_Manager ORDER BY HydroUnit, Stage DESC";
            r = s.executeQuery(query);
            temp = null;
            name1 = "";
            t1 = 0;
            while (r.next()) {
                t2 = r.getInt(1) - 1;
                name2 = r.getString(2).trim();
                if (!name2.matches(name1)) {
                    name1 = name2;
                    temp = null;
                    for (ix = 0; ix < this.sch.Components.size(); ++ix) {
                        tempComp = (comp)this.sch.Components.elementAt(ix);
                        if (!(tempComp instanceof hdb_unit) || !tempComp.getName().matches(name1)) continue;
                        temp = (hdb_unit)tempComp;
                        break;
                    }
                } else if (t2 == t1 || t2 < 0) continue;
                if (temp == null) {
                    System.out.println("Was not found: " + name2);
                    continue;
                }
                t1 = t2;
                double d1 = r.getDouble(3);
                double d2 = r.getDouble(4);
                ((hdb_unit)temp).setDynSmax(d1, t2, H);
                ((hdb_unit)temp).setDynSmin(d2, t2, H);
            }
        }
        catch (Exception ex) {
            System.out.println("DynSpg_Manager was not made correctly.");
        }
        try {
            s.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public double[][] getLoadValues(String loadname) throws Exception {
        int i;
        int nst = 0;
        int aux = 0;
        int nblocks = -1;
        double tse = -1.0;
        double[][] potencia = null;
        double[] info = null;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT Selection FROM Param_sim WHERE Parameter = 'Number of Blocks'");
        if (r.next()) {
            nblocks = (int)r.getDouble(1);
        } else {
            System.out.println("Problema en la obtenci\u00f3n de datos");
        }
        double[] porcionbloque = new double[nblocks];
        r = s.executeQuery("SELECT Selection FROM Param_sim WHERE Parameter = 'Total System Energy'");
        if (r.next()) {
            tse = r.getDouble(1);
        } else {
            System.out.println("Problema en la obtenci\u00f3n de datos");
        }
        r = s.executeQuery("SELECT * FROM Loads_Manager WHERE (Demand = '" + loadname + "')");
        if (!r.next()) {
            System.out.println("" + loadname + " no existe");
            return potencia;
        }
        for (i = 0; i < nblocks; ++i) {
            porcionbloque[i] = r.getDouble(3 + i);
        }
        r = s.executeQuery("SELECT * FROM Stages_Manager ORDER BY Stages");
        while (r.next()) {
            ++nst;
        }
        potencia = new double[nst][nblocks];
        r = s.executeQuery("SELECT * FROM Stages_Manager ORDER BY Stages");
        while (r.next()) {
            int hours_x;
            int largo = r.getInt(2);
            int unidad = r.getInt(3);
            int nb = nblocks > 1 ? nblocks : 0;
            info = new double[1 + 2 * nb];
            for (i = 0; i < 1 + 2 * nb; ++i) {
                info[i] = r.getDouble(i + 4);
            }
            switch (unidad) {
                case 1: {
                    hours_x = largo;
                    break;
                }
                case 2: {
                    hours_x = largo * 24;
                    break;
                }
                case 3: {
                    hours_x = largo * 720;
                    break;
                }
                case 4: {
                    hours_x = largo * 8760;
                    break;
                }
                default: {
                    hours_x = largo;
                    System.out.println("It was loaded " + hours_x + " hours in stage " + r.getInt(1) + ".");
                }
            }
            if (nblocks == 1) {
                for (i = 0; i < porcionbloque.length; ++i) {
                    potencia[aux][i] = porcionbloque[i] / 100.0 * (info[0] / 100.0) * tse / (double)hours_x * 1000.0;
                }
            } else {
                for (i = 0; i < porcionbloque.length; ++i) {
                    double energia = info[0] / 100.0 * tse * (info[i + 1] / 100.0);
                    double tiempo = (double)hours_x * (info[1 + nblocks + i] / 100.0);
                    potencia[aux][i] = porcionbloque[i] / 100.0 * energia / tiempo * 1000.0;
                }
            }
            ++aux;
        }
        return potencia;
    }

    public double[][] getLoadEnergy(String loadname) throws Exception {
        int i;
        int nst = 0;
        int aux = 0;
        int nblocks = -1;
        double tse = -1.0;
        double[][] energia = null;
        double[] info = null;
        Statement s = this.dBConn.createStatement();
        ResultSet r = s.executeQuery("SELECT Selection FROM Param_sim WHERE Parameter = 'Number of Blocks'");
        if (r.next()) {
            nblocks = (int)r.getDouble(1);
        } else {
            System.out.println("Problema en la obtenci\u00f3n de datos");
        }
        double[] porcionbloque = new double[nblocks];
        r = s.executeQuery("SELECT Selection FROM Param_sim WHERE Parameter = 'Total System Energy'");
        if (r.next()) {
            tse = r.getDouble(1);
        } else {
            System.out.println("Problema en la obtenci\u00f3n de datos");
        }
        r = s.executeQuery("SELECT * FROM Loads_Manager WHERE (Demand = '" + loadname + "')");
        if (!r.next()) {
            System.out.println("" + loadname + " no existe");
            return energia;
        }
        for (i = 0; i < nblocks; ++i) {
            porcionbloque[i] = r.getDouble(3 + i);
        }
        r = s.executeQuery("SELECT * FROM Stages_Manager ORDER BY Stages");
        while (r.next()) {
            ++nst;
        }
        energia = new double[nst][nblocks];
        r = s.executeQuery("SELECT * FROM Stages_Manager ORDER BY Stages");
        while (r.next()) {
            int largo = r.getInt(2);
            int unidad = r.getInt(3);
            int nb = nblocks > 1 ? nblocks : 0;
            info = new double[1 + 2 * nb];
            for (i = 0; i < 1 + 2 * nb; ++i) {
                info[i] = r.getDouble(i + 4);
            }
            if (nblocks == 1) {
                for (i = 0; i < porcionbloque.length; ++i) {
                    energia[aux][i] = porcionbloque[i] / 100.0 * (info[0] / 100.0) * tse;
                }
            } else {
                for (i = 0; i < porcionbloque.length; ++i) {
                    double energia_aux = info[0] / 100.0 * tse * (info[i + 1] / 100.0);
                    energia[aux][i] = porcionbloque[i] / 100.0 * energia_aux;
                }
            }
            ++aux;
        }
        return energia;
    }

    public double getParam(String param) {
        double resultado = -1.0;
        try {
            Statement s = this.dBConn.createStatement();
            ResultSet r = s.executeQuery("SELECT Selection FROM Param_sim WHERE Parameter = '" + param + "'");
            if (r.next()) {
                resultado = r.getDouble(1);
            }
        }
        catch (Exception e) {
            System.out.println("Problemas obteniendo " + param);
            e.printStackTrace();
        }
        return resultado;
    }

    public static double[] getExactLineParam(double r, double x, double g, double b, double len) {
        double[] param = new double[4];
        Complex ZetaC = new Complex(r, x).divide(new Complex(g, b));
        ZetaC = ZetaC.sqrt();
        Complex Gamma = new Complex(r, x).multiply(new Complex(g, b));
        Gamma = Gamma.sqrt();
        Complex Zeta = ZetaC.multiply(Complex.sinh((Complex)Gamma.multiply(len)));
        Complex midY = Complex.tanh((Complex)Gamma.multiply(len).divide(2.0)).divide(ZetaC);
        param[0] = Zeta.real();
        param[1] = Zeta.imag();
        param[2] = midY.real();
        param[3] = midY.imag();
        System.out.print("R: " + (double)Math.round(param[0] * 1000000.0) / 1000000.0 + " - " + (double)Math.round(r * len * 1000000.0) / 1000000.0);
        System.out.print(" X: " + (double)Math.round(param[1] * 1000000.0) / 1000000.0 + " - " + (double)Math.round(x * len * 1000000.0) / 1000000.0);
        System.out.print(" B: " + (double)Math.round(param[2] * 1000000.0) / 1000000.0 + " - " + (double)Math.round(b * len / 2.0 * 1000000.0) / 1000000.0);
        System.out.println("");
        return param;
    }
}

