/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Load;
import de.core.hdb_affl;
import de.core.seeds.SEEDS_BendCut;
import de.core.seeds.SEEDS_Exception;
import de.core.seeds.SEEDS_Frame;
import de.core.seeds.SEEDS_SBHTPS;
import de.core.seeds.SEEDS_StageHTPM;
import de.core.seeds.SEEDS_Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Random;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public final class SEEDS_Tool
extends AnalysisTool
implements Runnable {
    private Connection dbtrab;
    DeepEdit applet;
    public static SEEDS_Utils mydbm;
    String query;
    Statement stmt;
    ResultSet rs;
    boolean more;
    protected double[][] BlLengths = null;
    protected int[][][] Scen2Stage = null;
    protected double[][] StLengths = null;
    boolean solutionIsValid = false;
    SEEDS_SBHTPS main_solver = null;
    SEEDS_StageHTPM[][] stProblems = null;
    Vector[] vecEFCF = null;
    static String archivoBINres;
    static String archivoBINconv;
    private double[][][] convBnds = null;
    private double[][][][][][][] convCost = null;
    private double[][][][] convCuts = null;
    private double[] tasa = null;
    private int[] iterCount = null;
    private double[][][][][][] resSols = null;
    private double[][][][] resCost = null;
    private Thread myThread = null;
    private int th_type;
    private int th_MPs;
    private int th_solver;
    private int th_SPite;
    private int th_MPite;
    private double th_SPtol;
    private double th_MPtol;
    private boolean th_fromBW;
    private boolean th_fromFlat;
    private boolean th_ShareCuts;
    private boolean th_doLastBwd;
    private ProgressMonitor th_Monitor = null;
    protected static int[] ids;
    private static boolean ratProcess;
    protected static DecimalFormat df;
    private static double[][] sigmas;
    private double[] costosMonte = null;

    SEEDS_Tool(DeepEdit app) throws Exception {
        super(DeepEdit.MySchematic);
        this.applet = app;
        this.ActSchematic = DeepEdit.MySchematic;
        this.dbtrab = SEEDS_Frame.dbtrab;
        mydbm = new SEEDS_Utils(this.ActSchematic, this.dbtrab, this.applet);
        df = new DecimalFormat("##0.0####E0");
        DecimalFormatSymbols coma = new DecimalFormatSymbols();
        coma.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(coma);
    }

    private static void seedsError(String mensaje) throws SEEDS_Exception {
        throw new SEEDS_Exception(mensaje);
    }

    public void loadBlStPd2load() throws Exception {
        int nBlock;
        int nStage;
        double[][] loadStBlPower = null;
        double engy = 0.0;
        Vector sysLoadsV = mydbm.getLoadsVector();
        double totalE = SEEDS_Frame.n_Energy;
        int totalBlocks = SEEDS_Frame.n_Blocks;
        boolean x_year = false;
        for (int nLoad = 0; nLoad < sysLoadsV.size(); ++nLoad) {
            Load tempLoad = (Load)sysLoadsV.elementAt(nLoad);
            loadStBlPower = new double[this.StLengths.length][totalBlocks];
            double[] loadPortions = mydbm.getLoadsPortions(tempLoad.getName(), totalBlocks);
            for (nStage = 0; nStage < this.StLengths.length; ++nStage) {
                for (nBlock = 0; nBlock < totalBlocks; ++nBlock) {
                    loadStBlPower[nStage][nBlock] = engy = totalE * 1000.0 * this.StLengths[nStage][1] / 100.0 * loadPortions[nBlock] / 100.0 * this.StLengths[nStage][3 + nBlock] / 100.0 / (this.StLengths[nStage][0] * this.StLengths[nStage][3 + nBlock + totalBlocks] / 100.0);
                }
            }
            tempLoad.setP_SimStBlMat(loadStBlPower);
        }
        this.BlLengths = new double[this.StLengths.length][totalBlocks];
        for (nStage = 0; nStage < this.StLengths.length; ++nStage) {
            for (nBlock = 0; nBlock < totalBlocks; ++nBlock) {
                this.BlLengths[nStage][nBlock] = this.StLengths[nStage][0] * this.StLengths[nStage][3 + totalBlocks + nBlock] / 100.0;
            }
        }
    }

    public void loadCaudMxs2Affl(int branch) throws Exception {
        Vector affVec = mydbm.getStochAffVec();
        int endY = SEEDS_Frame.n_FinalStat;
        int iniY = SEEDS_Frame.n_InitialStat;
        int iniHY = SEEDS_Frame.n_iniHY;
        int propYear = Math.abs(endY - iniY + 1) * 48;
        int x_hini = SEEDS_Utils.monthDaysAcum[SEEDS_Frame.n_IniMonth] * 24 + SEEDS_Frame.n_IniDay * 24 + SEEDS_Frame.n_IniHour;
        for (int ix = 0; ix < affVec.size(); ++ix) {
            int stage;
            int x_hour = x_hini;
            hdb_affl tempAffl = (hdb_affl)affVec.elementAt(ix);
            double[] auxStCaud1 = mydbm.getAffValues(iniY, endY, tempAffl.getName());
            double[][] AffMtxSt = new double[this.Scen2Stage[branch].length][0];
            if (iniHY > 0) {
                double[] auxStCaud2 = new double[auxStCaud1.length];
                for (stage = 0; stage < iniHY * 4; ++stage) {
                    auxStCaud2[stage] = auxStCaud1[auxStCaud1.length - iniHY * 4 + stage];
                }
                for (stage = iniHY * 4; stage < auxStCaud1.length; ++stage) {
                    auxStCaud2[stage] = auxStCaud1[stage - iniHY * 4];
                }
                auxStCaud1 = auxStCaud2;
            }
            for (stage = 0; stage < this.Scen2Stage[branch].length; ++stage) {
                AffMtxSt[stage] = new double[this.Scen2Stage[branch][stage].length];
                int hours2St = (int)this.StLengths[stage][0];
                for (int hour = 0; hour < hours2St; ++hour) {
                    int whatWik = this.idWikHour(x_hour % 8760);
                    for (int scen = 0; scen < this.Scen2Stage[branch][stage].length; ++scen) {
                        double[] dArray = AffMtxSt[stage];
                        int n = scen;
                        dArray[n] = dArray[n] + auxStCaud1[(whatWik + 48 * (this.Scen2Stage[branch][stage][scen] - 1 + x_hour / 8760 - iniY)) % propYear] / (double)hours2St;
                    }
                    ++x_hour;
                }
            }
            tempAffl.setQ_SimStMat(AffMtxSt);
        }
    }

    private int idWikHour(int x_h) {
        int x_wik = -1;
        int hT = 0;
        for (int mes = 0; mes < 12; ++mes) {
            hT = SEEDS_Utils.monthDaysAcum[mes + 1] * 24;
            if (x_h >= hT) continue;
            x_wik = 4 * mes + (x_h -= SEEDS_Utils.monthDaysAcum[mes] * 24) / (SEEDS_Utils.monthDays[mes] * 24 / 4);
            break;
        }
        return x_wik;
    }

    protected void make2DBScSeqDef() throws Exception {
        long time = System.currentTimeMillis();
        int aux1 = 0;
        int aux2 = 0;
        int hora_x = 0;
        int random_x = 0;
        boolean x_year = false;
        int H = SEEDS_Frame.n_Stages;
        int N = SEEDS_Frame.n_Seq;
        int aux3 = SEEDS_Frame.n_HS_Consider + 1;
        this.StLengths = mydbm.getStagesLength(SEEDS_Frame.n_DiscRate, SEEDS_Frame.n_Blocks);
        this.stmt = this.dbtrab.createStatement();
        try {
            this.stmt.executeUpdate("DROP TABLE Sequences_Def");
            this.stmt.executeUpdate("CREATE TABLE Tree_def (Branch SMALLINT, Stage SMALLINT, Scenario SMALLINT, Hydro_Scenario SMALLINT )");
        }
        catch (Exception e) {
            try {
                this.stmt.executeUpdate("DELETE FROM Tree_def");
            }
            catch (Exception ex) {
                this.stmt.executeUpdate("CREATE TABLE Tree_def (Branch SMALLINT, Stage SMALLINT, Scenario SMALLINT, Hydro_Scenario SMALLINT )");
            }
        }
        try {
            String values;
            int h;
            int i;
            int j;
            if (SEEDS_Frame.n_HS_Consider == 0) {
                this.Scen2Stage = new int[N][H][1];
            } else if (SEEDS_Frame.n_HS_Thaw_ini == -1) {
                this.Scen2Stage = new int[N][H][0];
                for (j = 0; j < N; ++j) {
                    this.Scen2Stage[j][0] = new int[1];
                    for (i = 1; i < H; ++i) {
                        this.Scen2Stage[j][i] = new int[aux3];
                    }
                }
            } else {
                this.Scen2Stage = new int[N][H][0];
                aux1 = SEEDS_Utils.monthDays[SEEDS_Frame.n_HS_Thaw_ini] * 24 - 1;
                aux2 = SEEDS_Utils.monthDays[SEEDS_Frame.n_HS_Thaw_end + 1] * 24;
                hora_x = SEEDS_Utils.monthDays[SEEDS_Frame.n_IniMonth] + SEEDS_Frame.n_IniDay * 24 + SEEDS_Frame.n_IniHour;
                for (j = 0; j < N; ++j) {
                    this.Scen2Stage[j][0] = new int[1];
                }
                for (i = 1; i < H; ++i) {
                    h = hora_x > aux1 && hora_x < aux2 ? 1 : aux3;
                    for (j = 0; j < N; ++j) {
                        this.Scen2Stage[j][i] = new int[h];
                    }
                    hora_x = (int)((double)hora_x + this.StLengths[i][0]);
                    hora_x %= 8760;
                }
            }
            String sqlInsert = "INSERT INTO Tree_Def ( Branch, Stage, Scenario, Hydro_Scenario )";
            Random seed = new Random(SEEDS_Frame.n_HS_seed);
            hora_x = SEEDS_Utils.monthDays[SEEDS_Frame.n_IniMonth] + SEEDS_Frame.n_IniDay * 24 + SEEDS_Frame.n_IniHour;
            aux1 = 0;
            aux2 = SEEDS_Frame.n_FinalStat - SEEDS_Frame.n_InitialStat + 1;
            for (i = 1; i < N + 1; ++i) {
                random_x = seed.nextInt(aux2) + 1;
                for (j = 1; j < this.Scen2Stage[i - 1].length + 1; ++j) {
                    switch (SEEDS_Frame.n_HS_Random) {
                        case 0: {
                            aux1 = (i - 1) % aux2 + 1;
                            break;
                        }
                        case 1: {
                            aux1 = random_x;
                            break;
                        }
                        case 2: {
                            aux1 = random_x;
                            hora_x = (int)((double)hora_x + this.StLengths[j - 1][0]);
                            if (hora_x / 8760 < 1) break;
                            random_x = seed.nextInt(aux2) + 1;
                            hora_x %= 8760;
                            break;
                        }
                        case 3: {
                            aux1 = random_x;
                            random_x = seed.nextInt(aux2) + 1;
                        }
                    }
                    this.Scen2Stage[i - 1][j - 1][0] = SEEDS_Frame.n_InitialStat + aux1;
                    values = " VALUES (" + i + ", " + j + ", " + 1 + ", " + aux1 + ")";
                    this.stmt.executeUpdate(sqlInsert + values);
                }
            }
            if (aux3 > 1) {
                for (i = 1; i < N + 1; ++i) {
                    random_x = seed.nextInt(aux2) + 1;
                    for (j = 1; j < this.Scen2Stage[i - 1].length + 1; ++j) {
                        for (h = 2; h < this.Scen2Stage[i - 1][j - 1].length + 1; ++h) {
                            switch (SEEDS_Frame.n_HS_HowApply) {
                                case 0: {
                                    aux1 = (this.Scen2Stage[i - 1][j - 1][0] + h - 2) % aux2 + 1;
                                    break;
                                }
                                case 1: {
                                    aux1 = (random_x + h + i - 3) % aux2 + 1;
                                    break;
                                }
                                case 2: {
                                    aux1 = (random_x + h + i - 3) % aux2 + 1;
                                    hora_x = (int)((double)hora_x + this.StLengths[j - 1][0]);
                                    if (hora_x / 8760 < 1) break;
                                    random_x = seed.nextInt(aux2) + 1;
                                    hora_x %= 8760;
                                    break;
                                }
                                case 3: {
                                    aux1 = random_x;
                                    random_x = seed.nextInt(aux2) + 1;
                                }
                            }
                            this.Scen2Stage[i - 1][j - 1][h - 1] = SEEDS_Frame.n_InitialStat + aux1;
                            values = " VALUES (" + i + ", " + j + ", " + h + ", " + aux1 + ")";
                            this.stmt.executeUpdate(sqlInsert + values);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                this.stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        System.out.println("Scenarios builded in " + (System.currentTimeMillis() - time) + " [ms]");
        time = System.currentTimeMillis();
        this.loadBlStPd2load();
        System.out.println("Load matrixes builded in " + (System.currentTimeMillis() - time) + " [ms]");
        time = System.currentTimeMillis();
        mydbm.makeDynPar(H);
        System.out.println("DynPar matrixes builded in " + (System.currentTimeMillis() - time) + " [ms]");
    }

    protected void makeScenFromDB() throws Exception {
        ResultSet r = null;
        int H = SEEDS_Frame.n_Stages;
        int N = SEEDS_Frame.n_Seq;
        this.stmt = this.dbtrab.createStatement();
        this.Scen2Stage = new int[N][H][0];
        Vector<String> aux = null;
        long time = System.currentTimeMillis();
        for (int i = 0; i < H; ++i) {
            for (int j = 0; j < N; ++j) {
                aux = new Vector<String>();
                r = this.stmt.executeQuery("SELECT Hydro_Scenario FROM Tree_Def WHERE Branch=" + (j + 1) + " AND Stage=" + (i + 1) + " ORDER BY Scenario");
                while (r.next()) {
                    aux.addElement(r.getString(1));
                }
                int K = aux.size();
                this.Scen2Stage[j][i] = new int[K];
                for (int k = 0; k < K; ++k) {
                    this.Scen2Stage[j][i][k] = Integer.parseInt(aux.elementAt(k).toString());
                }
            }
        }
        System.out.println("Scenarios loaded in " + (System.currentTimeMillis() - time) + " [ms]");
        time = System.currentTimeMillis();
        this.StLengths = mydbm.getStagesLength(SEEDS_Frame.n_DiscRate, SEEDS_Frame.n_Blocks);
        this.loadBlStPd2load();
        System.out.println("Load matrixes builded in " + (System.currentTimeMillis() - time) + " [ms]");
        time = System.currentTimeMillis();
        mydbm.makeDynPar(H);
        System.out.println("DynPar matrixes builded in " + (System.currentTimeMillis() - time) + " [ms]");
    }

    public void make2DBScSeqDef(File file) throws Exception {
        long time = System.currentTimeMillis();
        this.StLengths = mydbm.getStagesLength(SEEDS_Frame.n_DiscRate, SEEDS_Frame.n_Blocks);
        this.loadSeqManager(file);
        System.out.println("Scenarios builded in " + (System.currentTimeMillis() - time) + " [ms]");
        time = System.currentTimeMillis();
        this.loadBlStPd2load();
        System.out.println("Load matrixes builded in " + (System.currentTimeMillis() - time) + " [ms]");
        time = System.currentTimeMillis();
        mydbm.makeDynPar(SEEDS_Frame.n_Stages);
        System.out.println("DynPar matrixes builded in " + (System.currentTimeMillis() - time) + " [ms]");
    }

    protected void loadSeqManager(File file) {
        BufferedReader in;
        int[] valores = new int[4];
        String[] line = null;
        String[] line2 = null;
        int i = 0;
        try {
            in = new BufferedReader(new FileReader(file));
        }
        catch (Exception p) {
            System.out.println("File name was wrong.");
            return;
        }
        try {
            String lineText = in.readLine();
            if (lineText != null) {
                line = lineText.split(",");
                if (line.length != 4) {
                    System.out.println("Bad format in file.");
                    return;
                }
            } else {
                System.out.println("Bad format in file.");
                return;
            }
            line2 = in.readLine().split(",");
            SEEDS_Frame.n_InitialStat = Integer.parseInt(line[3]) - 1;
            SEEDS_Frame.n_FinalStat = Integer.parseInt(line2[0]) - 1;
            int N = Integer.parseInt(line[0]);
            int H = Integer.parseInt(line[1]);
            int NHS = Integer.parseInt(line[2]);
            SEEDS_Frame.n_Seq = N;
            SEEDS_Frame.n_HS_Consider = NHS;
            this.Scen2Stage = new int[N][H][0];
            for (int j = 0; j < N; ++j) {
                this.Scen2Stage[j][0] = new int[1];
                for (i = 1; i < H; ++i) {
                    this.Scen2Stage[j][i] = new int[Integer.parseInt(line[2]) + 1];
                }
            }
            while ((lineText = in.readLine()) != null) {
                boolean t = false;
                try {
                    line = lineText.split(",", -1);
                    for (i = 0; i < 4; ++i) {
                        valores[i] = Integer.parseInt(line[i]);
                    }
                    this.Scen2Stage[valores[0] - 1][valores[1] - 1][valores[2] - 1] = valores[3] + SEEDS_Frame.n_InitialStat;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Scenarios correctly loaded");
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Information not found");
        }
    }

    public void load2SchemStBlHyId(int pst, int pblock, int pHydroIn) throws Exception {
        int ix;
        boolean allOK = true;
        Vector objVec = mydbm.getLoadsVector();
        for (ix = 0; ix < objVec.size() && allOK; ++ix) {
            allOK = ((Load)objVec.elementAt(ix)).setPfromSimSt(pst, pblock);
        }
        if (!allOK) {
            SEEDS_Tool.seedsError("An error when loading Pd in load '" + ((Load)objVec.elementAt(ix)).getName() + "' stage " + (pst + 1) + " block " + (pblock + 1));
        }
        objVec = mydbm.getStochAffVec();
        for (ix = 0; ix < objVec.size() && allOK; ++ix) {
            allOK = ((hdb_affl)objVec.elementAt(ix)).setQfromSimStMat(pst, pHydroIn);
        }
        if (!allOK) {
            SEEDS_Tool.seedsError("An error when loading Q in Affluent '" + ((hdb_affl)objVec.elementAt(ix)).getName() + "' stage " + (pst + 1) + " hydroIn " + pHydroIn);
        }
    }

    public void update() {
        mydbm = new SEEDS_Utils(this.ActSchematic, this.dbtrab, this.applet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void solveSSHB(int n_branch, int n_stage, int n_block, int n_hydro, int tipo, int solverId, double qpCostTol, int qpNmaxIter) throws Exception {
        SEEDS_SBHTPS temp_solver = null;
        long time = System.currentTimeMillis();
        try {
            System.out.println("");
            temp_solver = new SEEDS_SBHTPS(this.ActSchematic, 744.0, 1.0, false);
            ids = new int[]{n_branch, n_stage, n_block, n_hydro};
            temp_solver.setDynParSt(n_stage);
            System.out.println("SP load ParDyn in: " + (System.currentTimeMillis() - time) + " [ms]");
            time = System.currentTimeMillis();
            temp_solver.setViniFromObj(temp_solver.resHydUnit);
            double rate = this.StLengths[n_stage][2];
            double dur = this.BlLengths[n_stage][n_block];
            this.loadCaudMxs2Affl(n_branch);
            System.out.println("SP load Affls in: " + (System.currentTimeMillis() - time) + " [ms]");
            time = System.currentTimeMillis();
            temp_solver.setHydroAffQ(n_stage, n_hydro);
            temp_solver.setBlockPLoad(n_stage, n_block);
            temp_solver.optimizeRORaff(this.BlLengths[n_stage]);
            temp_solver.setHydroAffBlock(n_hydro);
            System.out.println("SP load ParRest in: " + (System.currentTimeMillis() - time) + " [ms]");
            time = System.currentTimeMillis();
            DeepEdit.MySchematic.settypsim(1);
            DeepEdit.MySchematic.settiposimula(0);
            SEEDS_BendCut.setDimension(temp_solver.resHydUnit.length);
            Vector<Object> bC = new Vector(10);
            if (tipo == 0) {
                mydbm.loadFuncCotaVol();
                bC = mydbm.getEndEFCF(temp_solver.resHydUnit);
            } else if (tipo != 1) {
                double[][] cuts;
                if (tipo == 2) {
                    int m = SEEDS_Frame.myConver.getNSec();
                    if (m != 0 && n_branch < m) {
                        cuts = SEEDS_Frame.myConver.getCuts(n_branch, n_stage);
                        if (SEEDS_Frame.myConver.isBendersCuts() && cuts.length != 0) {
                            int n = (int)Math.rint((cuts[0].length - 1) / 2);
                            if (n != temp_solver.resHydUnit.length) {
                                System.out.println("Info loaded do not correspond to this case.");
                                return;
                            }
                            double[] aproxSlopes = new double[n];
                            double[] aproxPoints = new double[n];
                            double aproxHeight = 0.0;
                            SEEDS_BendCut.setDimension(n);
                            for (int cut = 0; cut < cuts.length; ++cut) {
                                aproxHeight = cuts[cut][0];
                                for (int res = 0; res < n; ++res) {
                                    aproxSlopes[res] = cuts[cut][res + 1];
                                    aproxPoints[res] = cuts[cut][n + res + 1];
                                    aproxHeight -= aproxSlopes[res] * aproxPoints[res];
                                }
                                bC.add(new SEEDS_BendCut(aproxSlopes, aproxPoints, aproxHeight));
                            }
                        }
                    }
                } else if (tipo == 3) {
                    int m = SEEDS_Frame.myConver.getNSec();
                    for (int h = 0; h < m; ++h) {
                        cuts = SEEDS_Frame.myConver.getCuts(h, n_stage);
                        if (!SEEDS_Frame.myConver.isBendersCuts() || cuts.length == 0) continue;
                        int n = (int)Math.rint((cuts[0].length - 1) / 2);
                        if (n != temp_solver.resHydUnit.length) {
                            System.out.println("Info loaded do not correspond to this case.");
                            return;
                        }
                        double[] aproxSlopes = new double[n];
                        double[] aproxPoints = new double[n];
                        double aproxHeight = 0.0;
                        SEEDS_BendCut.setDimension(n);
                        for (int cut = 0; cut < cuts.length; ++cut) {
                            aproxHeight = cuts[cut][0];
                            for (int res = 0; res < n; ++res) {
                                aproxSlopes[res] = cuts[cut][res + 1];
                                aproxPoints[res] = cuts[cut][n + res + 1];
                                aproxHeight -= aproxSlopes[res] * aproxPoints[res];
                            }
                            bC.add(new SEEDS_BendCut(aproxSlopes, aproxPoints, aproxHeight));
                        }
                    }
                }
            }
            temp_solver.setBCsV(bC);
            mydbm.loadFuncCotaVol();
            System.out.println("SP load EFCFs in: " + (System.currentTimeMillis() - time) + " [ms]");
            time = System.currentTimeMillis();
            temp_solver.setSolverParam(solverId, qpNmaxIter, qpCostTol);
            double cost = temp_solver.reSolve(dur, rate);
            System.out.println("SP[" + (n_branch + 1) + "," + (n_stage + 1) + "," + (n_block + 1) + "," + (n_hydro + 1) + "] Ope cost: " + df.format(cost * SEEDS_SBHTPS.ponderar) + "");
            System.out.println("SP[" + (n_branch + 1) + "," + (n_stage + 1) + "," + (n_block + 1) + "," + (n_hydro + 1) + "] Fut cost: " + df.format(temp_solver.vec_xtempabs[temp_solver.vec_xtempabs.length - 1] * rate * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar) + "");
            System.out.println("SP solved in: " + (System.currentTimeMillis() - time) + " [ms]");
            temp_solver.writeResults();
            if (DeepEdit.isGUI && !ratProcess) {
                temp_solver.showResults();
                DeepEdit.MySchematicPanel.repaint();
            } else {
                System.out.println(" End Solve SP.");
            }
        }
        catch (Exception e) {
            System.out.println("Exception caught in SEEDS_Tool");
            e.printStackTrace();
        }
        finally {
            try {
                temp_solver.finalize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            temp_solver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSSHB(double[] vecSol, double[] vecLam, double cost, int n_branch, int n_stage, int n_block, int n_hydro) throws Exception {
        SEEDS_SBHTPS temp_solver = null;
        try {
            SEEDS_SBHTPS.ponderar = 1.0;
            double dur = this.BlLengths[n_stage][n_block];
            temp_solver = !ratProcess ? new SEEDS_SBHTPS(this.ActSchematic, dur, 1.0, false) : new SEEDS_SBHTPS(this.ActSchematic, dur, 1.0, true);
            this.loadCaudMxs2Affl(n_branch);
            this.load2SchemStBlHyId(n_stage, n_block, n_hydro);
            temp_solver.setDynParSt(n_stage);
            temp_solver.vec_xtempabs = vecSol;
            temp_solver.vec_lam = vecLam;
            System.out.println("SP[" + (n_branch + 1) + "," + (n_stage + 1) + "," + (n_block + 1) + "," + (n_hydro + 1) + "] Ope cost: " + df.format(cost * SEEDS_SBHTPS.ponderar) + "-");
            mydbm.loadFuncCotaVol();
            if (!ratProcess) {
                temp_solver.writeResults();
            } else {
                temp_solver.writeResults(true);
            }
            temp_solver.showResults();
            DeepEdit.MySchematicPanel.repaint();
            SEEDS_SBHTPS.ponderar = 1000000.0;
        }
        catch (Exception e) {
            System.out.println("It's not the same schematic");
            e.printStackTrace();
        }
        finally {
            temp_solver.finalize();
            temp_solver = null;
        }
    }

    private void solveSeqs(int nS, boolean initBWMode, boolean fromFlatSol, double ssTol, int nMaxIter) throws Exception {
        SEEDS_BendCut tempBC2;
        int hyd;
        int st;
        SEEDS_Tool.ids[0] = nS;
        this.solutionIsValid = false;
        int nS_aux = this.th_MPs > -1 ? 0 : nS;
        DeepEdit.MySchematic.settypsim(1);
        DeepEdit.MySchematic.settiposimula(0);
        this.loadCaudMxs2Affl(nS);
        this.tasa = new double[this.StLengths.length];
        this.tasa[0] = this.StLengths[0][2];
        for (st = 1; st < this.Scen2Stage[nS].length; ++st) {
            this.tasa[st] = this.tasa[st - 1] * this.StLengths[st][2];
        }
        this.stProblems = new SEEDS_StageHTPM[this.Scen2Stage[nS].length][0];
        for (st = 0; st < this.stProblems.length; ++st) {
            this.stProblems[st] = new SEEDS_StageHTPM[this.Scen2Stage[nS][st].length];
            for (hyd = 0; hyd < this.Scen2Stage[nS][st].length; ++hyd) {
                this.stProblems[st][hyd] = new SEEDS_StageHTPM(st, hyd, this.main_solver, this.BlLengths[st], this.StLengths[st][2]);
            }
        }
        this.stProblems[0][0].setStDependencies(null, this.stProblems[1]);
        for (st = 1; st < this.stProblems.length; ++st) {
            if (st < this.stProblems.length - 1) {
                this.stProblems[st][0].setStDependencies(this.stProblems[st - 1][0], this.stProblems[st + 1]);
            } else {
                this.stProblems[st][0].setStDependencies(this.stProblems[st - 1][0], null);
            }
            for (hyd = 1; hyd < this.stProblems[st].length; ++hyd) {
                this.stProblems[st][hyd].setStDependencies(this.stProblems[st - 1][0], null);
            }
        }
        this.vecEFCF = new Vector[this.stProblems.length];
        for (st = 0; st < this.stProblems.length - 1; ++st) {
            this.vecEFCF[st] = new Vector();
        }
        SEEDS_BendCut.setDimension(this.main_solver.resHydUnit.length);
        mydbm.loadFuncCotaVol();
        this.vecEFCF[this.stProblems.length - 1] = mydbm.getEndEFCF(this.main_solver.resHydUnit);
        for (st = 0; st < this.stProblems.length; ++st) {
            for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                this.stProblems[st][hyd].setEFCF(this.vecEFCF[st]);
            }
        }
        this.stProblems[0][0].setRes2SetVini(mydbm.getResArr());
        this.convBnds[nS_aux] = new double[2][nMaxIter];
        if (SEEDS_Frame.addConv2) {
            this.convCost[nS_aux] = new double[this.stProblems.length][2][0][0][0][0];
            for (st = 0; st < this.stProblems.length; ++st) {
                this.convCost[nS_aux][st] = new double[this.stProblems[st].length][nMaxIter][2][2][this.BlLengths[0].length];
            }
        }
        if (SEEDS_Frame.addConv3) {
            this.convCuts[nS_aux] = new double[this.stProblems.length][0][0];
        }
        this.iterCount[nS_aux] = 0;
        SEEDS_BendCut tempBC = null;
        SEEDS_StageHTPM.initSolveMode = true;
        SEEDS_StageHTPM.initBWMode = initBWMode;
        SEEDS_StageHTPM.solveFromFlatSol = fromFlatSol;
        SEEDS_StageHTPM.initBWMSimVini = 0.5;
        double delta = 100.0;
        if (SEEDS_StageHTPM.initBWMode) {
            if (!DeepEdit.isGUI) {
                System.out.println("");
                System.out.print("Backward initialization:");
            }
            for (st = this.stProblems.length - 1; st > 0; --st) {
                for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                        this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Bwd h=" + (hyd + 1) + ". Delta: " + delta + "[%]");
                    }
                    tempBC2 = this.stProblems[st][hyd].solveBackward();
                    tempBC2.pond(1.0 / (double)this.Scen2Stage[nS][st].length);
                    if (tempBC == null) {
                        tempBC = tempBC2;
                        continue;
                    }
                    tempBC.algSum(tempBC2);
                }
                if (!DeepEdit.isGUI) {
                    System.out.print(" " + st);
                }
                this.vecEFCF[st - 1].add(tempBC);
                tempBC = null;
            }
            this.stProblems[0][0].solveBackward();
        }
        SEEDS_StageHTPM.initSolveMode = false;
        do {
            int n = nS_aux;
            this.iterCount[n] = this.iterCount[n] + 1;
            if (DeepEdit.isGUI && !ratProcess) {
                this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + 1 + " Fwd s=" + 1 + ". Delta: " + delta + "[%]");
            } else if (!DeepEdit.isGUI) {
                System.out.println("");
                System.out.print("In ite" + this.iterCount[nS_aux] + " Fwd: 1");
            }
            this.stProblems[0][0].solveForward();
            this.convBnds[nS_aux][0][this.iterCount[nS_aux] - 1] = this.stProblems[0][0].getStSPOpC();
            this.convBnds[nS_aux][1][this.iterCount[nS_aux] - 1] = this.stProblems[0][0].getStSPOpC() + this.stProblems[0][0].getEBSPFuC();
            for (st = 1; st < this.stProblems.length; ++st) {
                hyd = 0;
                if (DeepEdit.isGUI && !ratProcess) {
                    this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                    this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Fwd h=" + (hyd + 1) + ". Delta: " + delta + "[%]");
                } else if (!DeepEdit.isGUI) {
                    System.out.print("-" + (st + 1));
                }
                this.stProblems[st][hyd].solveForward();
                double[] dArray = this.convBnds[nS_aux][0];
                int n2 = this.iterCount[nS_aux] - 1;
                dArray[n2] = dArray[n2] + this.tasa[st - 1] * 1.0 * this.stProblems[st][hyd].getStSPOpC();
            }
            if (SEEDS_Frame.addConv2) {
                for (st = 0; st < this.stProblems.length - 1; ++st) {
                    for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                        this.convCost[nS_aux][st][hyd][this.iterCount[nS_aux] - 1][0] = this.stProblems[st][hyd].get_Ope_Fc();
                    }
                }
            }
            if (!DeepEdit.isGUI) {
                System.out.print("/");
            }
            for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                if (DeepEdit.isGUI && !ratProcess) {
                    this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                    this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Bwd h=" + (hyd + 1) + ". Delta: " + delta + "[%]");
                }
                tempBC2 = this.stProblems[st][hyd].solveBackward();
                tempBC2.pond(1.0 / (double)this.Scen2Stage[nS][st].length);
                if (tempBC == null) {
                    tempBC = tempBC2;
                    continue;
                }
                tempBC.algSum(tempBC2);
            }
            if (!DeepEdit.isGUI) {
                System.out.print(" ");
            }
            this.vecEFCF[st - 1].add(tempBC);
            tempBC = null;
            double[] dArray = this.convBnds[nS_aux][0];
            int n3 = this.iterCount[nS_aux] - 1;
            dArray[n3] = dArray[n3] + this.tasa[st - 1] * 1.0 * this.stProblems[st][0].getStSPOpC();
            double[] dArray2 = this.convBnds[nS_aux][0];
            int n4 = this.iterCount[nS_aux] - 1;
            dArray2[n4] = dArray2[n4] + this.tasa[st - 1] * 1.0 * this.stProblems[st][0].getEBSPFuC();
            if (!DeepEdit.isGUI) {
                System.out.print("dif=");
            }
            double converge = (this.convBnds[nS_aux][0][this.iterCount[nS_aux] - 1] - this.convBnds[nS_aux][1][this.iterCount[nS_aux] - 1]) / this.convBnds[nS_aux][0][this.iterCount[nS_aux] - 1] * 100.0;
            delta = Math.rint(converge * 100.0) / 100.0;
            if (DeepEdit.isGUI && !ratProcess && this.th_Monitor.isCanceled() && !this.th_doLastBwd || this.iterCount[nS_aux] == nMaxIter && !this.th_doLastBwd || Math.abs(converge) <= ssTol) break;
            if (!DeepEdit.isGUI) {
                System.out.print(delta + "[%] /Bwd: " + (st + 1));
            }
            for (st = this.stProblems.length - 2; st > 0; --st) {
                if (!DeepEdit.isGUI) {
                    System.out.print("-" + (st + 1));
                }
                for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                        this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Bwd h=" + (hyd + 1) + ". Delta: " + delta + "[%]");
                    }
                    tempBC2 = this.stProblems[st][hyd].solveBackward();
                    tempBC2.pond(1.0 / (double)this.Scen2Stage[nS][st].length);
                    if (tempBC == null) {
                        tempBC = tempBC2;
                        continue;
                    }
                    tempBC.algSum(tempBC2);
                }
                this.vecEFCF[st - 1].add(tempBC);
                tempBC = null;
            }
            for (hyd = 0; hyd < this.stProblems[0].length; ++hyd) {
                if (DeepEdit.isGUI && !ratProcess) {
                    this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                    this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Bwd s=" + (hyd + 1) + ". Delta: " + delta + "[%]" + ".");
                }
                this.stProblems[0][hyd].solveBackward();
            }
            if (!SEEDS_Frame.addConv2) continue;
            for (st = 1; st < this.stProblems.length; ++st) {
                for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                    this.convCost[nS_aux][st][hyd][this.iterCount[nS_aux] - 1][1] = this.stProblems[st][hyd].get_Ope_Fc();
                }
            }
        } while ((!DeepEdit.isGUI || ratProcess || !this.th_Monitor.isCanceled() || !this.th_doLastBwd) && (this.iterCount[nS_aux] != nMaxIter || !this.th_doLastBwd));
        if (SEEDS_Frame.addConv3) {
            for (st = 0; st < this.stProblems.length; ++st) {
                this.convCuts[nS_aux][st] = new double[this.vecEFCF[st].size()][1 + 2 * this.main_solver.resHydUnit.length];
                for (hyd = 0; hyd < this.convCuts[nS_aux][st].length; ++hyd) {
                    this.convCuts[nS_aux][st][hyd][0] = ((SEEDS_BendCut)this.vecEFCF[st].elementAt((int)hyd)).f0 * SEEDS_SBHTPS.ponderar;
                    for (int aux = 0; aux < this.main_solver.resHydUnit.length; ++aux) {
                        this.convCuts[nS_aux][st][hyd][1 + aux] = ((SEEDS_BendCut)this.vecEFCF[st].elementAt((int)hyd)).mi[aux] * SEEDS_SBHTPS.ponderar;
                        this.convCuts[nS_aux][st][hyd][1 + this.main_solver.resHydUnit.length + aux] = ((SEEDS_BendCut)this.vecEFCF[st].elementAt((int)hyd)).xi[aux];
                        double[] dArray = this.convCuts[nS_aux][st][hyd];
                        dArray[0] = dArray[0] - this.convCuts[nS_aux][st][hyd][1 + aux] * this.convCuts[nS_aux][st][hyd][1 + this.main_solver.resHydUnit.length + aux];
                    }
                }
            }
        }
        this.resSols[nS_aux] = new double[2][this.Scen2Stage[nS].length][0][0][0];
        this.resCost[nS_aux] = new double[this.Scen2Stage[nS].length][0][0];
        for (st = 0; st < this.resSols[nS_aux][0].length; ++st) {
            this.resSols[nS_aux][0][st] = new double[this.Scen2Stage[nS][st].length][0][0];
            this.resSols[nS_aux][1][st] = new double[this.resSols[nS_aux][0][st].length][0][0];
            this.resCost[nS_aux][st] = new double[this.resSols[nS_aux][0][st].length][0];
            for (hyd = 0; hyd < this.resSols[nS_aux][0][st].length; ++hyd) {
                this.resSols[nS_aux][0][st][hyd] = this.stProblems[st][hyd].actSolutionArr;
                this.resSols[nS_aux][1][st][hyd] = this.stProblems[st][hyd].getFinalDualCost();
                for (int bl = 0; bl < this.stProblems[st][hyd].actSolutionArr.length; ++bl) {
                    this.resSols[nS_aux][0][st][hyd][bl][this.resSols[nS_aux][0][st][hyd][bl].length - 1] = this.resSols[nS_aux][0][st][hyd][bl][this.resSols[nS_aux][0][st][hyd][bl].length - 1] * this.stProblems[st][hyd].discRateFEFCF * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar;
                }
                this.resCost[nS_aux][st][hyd] = this.stProblems[st][hyd].getFinalOperCost();
            }
        }
        this.solutionIsValid = true;
    }

    private void solveTree(int nS, boolean initBWMode, boolean fromFlatSol, double ssTol, int nMaxIter) throws Exception {
        SEEDS_BendCut tempBC2;
        int pre;
        int hyd;
        int st;
        SEEDS_Tool.ids[0] = nS;
        this.solutionIsValid = false;
        int nS_aux = this.th_MPs > -1 ? 0 : nS;
        DeepEdit.MySchematic.settypsim(1);
        DeepEdit.MySchematic.settiposimula(0);
        this.loadCaudMxs2Affl(nS);
        this.tasa = new double[this.StLengths.length];
        this.tasa[0] = this.StLengths[0][2];
        for (st = 1; st < this.Scen2Stage[nS].length; ++st) {
            this.tasa[st] = this.tasa[st - 1] * this.StLengths[st][2];
        }
        int[] SPs = new int[this.Scen2Stage[nS].length];
        this.stProblems = new SEEDS_StageHTPM[SPs.length][];
        SPs[0] = this.Scen2Stage[nS][0].length;
        this.stProblems[0] = new SEEDS_StageHTPM[SPs[0]];
        for (hyd = 0; hyd < this.Scen2Stage[nS][0].length; ++hyd) {
            this.stProblems[0][hyd] = new SEEDS_StageHTPM(0, hyd, this.main_solver, this.BlLengths[0], this.StLengths[0][2]);
        }
        for (st = 1; st < this.Scen2Stage[nS].length; ++st) {
            SPs[st] = SPs[st - 1] * this.Scen2Stage[nS][st].length;
            this.stProblems[st] = new SEEDS_StageHTPM[SPs[st]];
            for (pre = 0; pre < SPs[st - 1]; ++pre) {
                for (hyd = 0; hyd < this.Scen2Stage[nS][st].length; ++hyd) {
                    this.stProblems[st][pre * this.Scen2Stage[nS][st].length + hyd] = new SEEDS_StageHTPM(st, hyd, this.main_solver, this.BlLengths[st], this.StLengths[st][2]);
                }
            }
        }
        for (hyd = 0; hyd < this.Scen2Stage[nS][0].length; ++hyd) {
            this.stProblems[0][hyd].setStDependencies(null, this.stProblems[1]);
        }
        for (st = 1; st < this.stProblems.length - 1; ++st) {
            for (pre = 0; pre < SPs[st - 1]; ++pre) {
                for (hyd = 0; hyd < this.Scen2Stage[nS][st].length; ++hyd) {
                    SEEDS_StageHTPM[] tempo = new SEEDS_StageHTPM[this.Scen2Stage[nS][st + 1].length];
                    for (int hyd2 = 0; hyd2 < this.Scen2Stage[nS][st + 1].length; ++hyd2) {
                        tempo[hyd2] = this.stProblems[st + 1][pre * this.Scen2Stage[nS][st].length + hyd * this.Scen2Stage[nS][st + 1].length + hyd2];
                    }
                    this.stProblems[st][pre * this.Scen2Stage[nS][st].length + hyd].setStDependencies(this.stProblems[st - 1][pre], tempo);
                }
            }
        }
        for (pre = 0; pre < SPs[st - 1]; ++pre) {
            for (hyd = 0; hyd < this.Scen2Stage[nS][st].length; ++hyd) {
                this.stProblems[st][pre * this.Scen2Stage[nS][st].length + hyd].setStDependencies(this.stProblems[st - 1][pre], null);
            }
        }
        Vector<SEEDS_BendCut> auxVec = new Vector<SEEDS_BendCut>(2, 2);
        this.vecEFCF = new Vector[this.stProblems.length];
        for (st = 0; st < this.stProblems.length; ++st) {
            this.vecEFCF[st] = new Vector();
        }
        SEEDS_BendCut.setDimension(this.main_solver.resHydUnit.length);
        mydbm.loadFuncCotaVol();
        this.vecEFCF[this.stProblems.length - 1] = mydbm.getEndEFCF(this.main_solver.resHydUnit);
        for (st = 0; st < this.stProblems.length; ++st) {
            for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                this.stProblems[st][hyd].setEFCF(this.vecEFCF[st]);
            }
        }
        this.stProblems[0][0].setRes2SetVini(mydbm.getResArr());
        this.convBnds[nS_aux] = new double[2][nMaxIter];
        if (SEEDS_Frame.addConv2) {
            this.convCost[nS_aux] = new double[this.stProblems.length][2][0][0][0][0];
            for (st = 0; st < this.stProblems.length; ++st) {
                this.convCost[nS_aux][st] = new double[this.stProblems[st].length][nMaxIter][2][2][this.BlLengths[0].length];
            }
        }
        if (SEEDS_Frame.addConv3) {
            this.convCuts[nS_aux] = new double[this.stProblems.length][0][0];
        }
        this.iterCount[nS_aux] = 0;
        SEEDS_BendCut tempBC = null;
        SEEDS_StageHTPM.initSolveMode = true;
        SEEDS_StageHTPM.initBWMode = initBWMode;
        SEEDS_StageHTPM.solveFromFlatSol = fromFlatSol;
        SEEDS_StageHTPM.initBWMSimVini = 0.5;
        double delta = 100.0;
        if (SEEDS_StageHTPM.initBWMode) {
            System.out.println("");
            System.out.print("Backward initialization: " + this.stProblems.length);
            for (st = this.stProblems.length - 1; st > 0; --st) {
                if (!DeepEdit.isGUI) {
                    System.out.print("-" + (st + 1));
                }
                for (pre = 0; pre < SPs[st - 1]; ++pre) {
                    for (hyd = 0; hyd < this.Scen2Stage[nS][st].length; ++hyd) {
                        if (DeepEdit.isGUI && !ratProcess) {
                            this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                            this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Bwd s=" + (pre * this.Scen2Stage[nS][st].length + hyd + 1) + ". Delta: " + delta + "[%]" + ".");
                        }
                        tempBC2 = this.stProblems[st][pre * this.Scen2Stage[nS][st].length + hyd].solveBackward();
                        tempBC2.pond(1.0 / (double)this.Scen2Stage[nS][st].length);
                        if (tempBC == null) {
                            tempBC = tempBC2;
                            continue;
                        }
                        tempBC.algSum(tempBC2);
                    }
                    auxVec.add(tempBC);
                    tempBC = null;
                }
                for (pre = 0; pre < SPs[st - 1]; ++pre) {
                    this.vecEFCF[st - 1].add((SEEDS_BendCut)auxVec.elementAt(pre));
                }
                auxVec = new Vector(2, 2);
            }
            this.stProblems[0][0].solveBackward();
        }
        SEEDS_StageHTPM.initSolveMode = false;
        do {
            int n = nS_aux;
            this.iterCount[n] = this.iterCount[n] + 1;
            if (DeepEdit.isGUI && !ratProcess) {
                this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Fwd s=" + 1 + ". Delta: " + delta + "[%]" + ".");
            } else if (!DeepEdit.isGUI) {
                System.out.println("");
                System.out.print("In ite" + this.iterCount[nS_aux] + " Fwd: 1");
            }
            this.stProblems[0][0].solveForward();
            this.convBnds[nS_aux][0][this.iterCount[nS_aux] - 1] = this.stProblems[0][0].getStSPOpC();
            this.convBnds[nS_aux][1][this.iterCount[nS_aux] - 1] = this.stProblems[0][0].getStSPOpC() + this.stProblems[0][0].getEBSPFuC();
            for (st = 1; st < this.stProblems.length; ++st) {
                if (!DeepEdit.isGUI) {
                    System.out.print("-" + (st + 1));
                }
                for (pre = 0; pre < SPs[st - 1]; ++pre) {
                    for (hyd = 0; hyd < this.Scen2Stage[nS][st].length; ++hyd) {
                        if (DeepEdit.isGUI && !ratProcess) {
                            this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                            this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Fwd s=" + (pre * this.Scen2Stage[nS][st].length + hyd + 1) + ". Delta: " + delta + "[%]" + ".");
                        }
                        this.stProblems[st][pre * this.Scen2Stage[nS][st].length + hyd].solveForward();
                        double[] dArray = this.convBnds[nS_aux][0];
                        int n2 = this.iterCount[nS_aux] - 1;
                        dArray[n2] = dArray[n2] + this.tasa[st - 1] * 1.0 / (double)SPs[st] * this.stProblems[st][pre * this.Scen2Stage[nS_aux][st].length + hyd].getStSPOpC();
                    }
                }
            }
            if (SEEDS_Frame.addConv2) {
                for (st = 0; st < this.stProblems.length - 1; ++st) {
                    for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                        this.convCost[nS_aux][st][hyd][this.iterCount[nS_aux] - 1][0] = this.stProblems[st][hyd].get_Ope_Fc();
                    }
                }
            }
            for (pre = 0; pre < SPs[st - 1]; ++pre) {
                for (hyd = 0; hyd < this.Scen2Stage[nS][st].length; ++hyd) {
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                        this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Bwd s=" + (pre * this.Scen2Stage[nS][st].length + hyd + 1) + ". Delta: " + delta + "[%]" + ".");
                    }
                    tempBC2 = this.stProblems[st][pre * this.Scen2Stage[nS][st].length + hyd].solveBackward();
                    double[] dArray = this.convBnds[nS_aux][0];
                    int n3 = this.iterCount[nS_aux] - 1;
                    dArray[n3] = dArray[n3] + this.tasa[st - 1] * 1.0 / (double)SPs[st] * this.stProblems[st][pre * this.Scen2Stage[nS][st].length + hyd].getEBSPFuC();
                    tempBC2.pond(1.0 / (double)this.Scen2Stage[nS][st].length);
                    if (tempBC == null) {
                        tempBC = tempBC2;
                        continue;
                    }
                    tempBC.algSum(tempBC2);
                }
                auxVec.add(tempBC);
                tempBC = null;
            }
            for (pre = 0; pre < SPs[st - 1]; ++pre) {
                this.vecEFCF[st - 1].add((SEEDS_BendCut)auxVec.elementAt(pre));
            }
            auxVec = new Vector(2, 2);
            double converge = (this.convBnds[nS_aux][0][this.iterCount[nS_aux] - 1] - this.convBnds[nS_aux][1][this.iterCount[nS_aux] - 1]) / this.convBnds[nS_aux][0][this.iterCount[nS_aux] - 1] * 100.0;
            delta = Math.rint(converge * 100.0) / 100.0;
            if (DeepEdit.isGUI && !ratProcess && this.th_Monitor.isCanceled() && !this.th_doLastBwd || this.iterCount[nS_aux] == nMaxIter && !this.th_doLastBwd || Math.abs(converge) <= ssTol) break;
            if (!DeepEdit.isGUI) {
                System.out.print("/ dif=" + delta + "[%] /Bwd: " + (st + 1));
            }
            for (st = this.stProblems.length - 2; st > 0; --st) {
                if (!DeepEdit.isGUI) {
                    System.out.print("-" + (st + 1));
                }
                for (pre = 0; pre < SPs[st - 1]; ++pre) {
                    for (hyd = 0; hyd < this.Scen2Stage[nS][st].length; ++hyd) {
                        if (DeepEdit.isGUI && !ratProcess) {
                            this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                            this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Bwd s=" + (pre * this.Scen2Stage[nS][st].length + hyd + 1) + ". Delta: " + delta + "[%]" + ".");
                        }
                        tempBC2 = this.stProblems[st][pre * this.Scen2Stage[nS][st].length + hyd].solveBackward();
                        tempBC2.pond(1.0 / (double)this.Scen2Stage[nS][st].length);
                        if (tempBC == null) {
                            tempBC = tempBC2;
                            continue;
                        }
                        tempBC.algSum(tempBC2);
                    }
                    auxVec.add(tempBC);
                    tempBC = null;
                }
                for (pre = 0; pre < SPs[st - 1]; ++pre) {
                    this.vecEFCF[st - 1].add((SEEDS_BendCut)auxVec.elementAt(pre));
                }
                auxVec = new Vector(2, 2);
            }
            for (hyd = 0; hyd < this.stProblems[0].length; ++hyd) {
                if (DeepEdit.isGUI && !ratProcess) {
                    this.th_Monitor.setProgress(this.iterCount[nS_aux]);
                    this.th_Monitor.setNote("In ite " + this.iterCount[nS_aux] + "/" + this.th_MPite + ", t=" + (st + 1) + " Bwd s=" + (hyd + 1) + ". Delta: " + delta + "[%]" + ".");
                }
                this.stProblems[0][hyd].solveBackward();
            }
            if (!SEEDS_Frame.addConv2) continue;
            for (st = 1; st < this.stProblems.length; ++st) {
                for (hyd = 0; hyd < this.stProblems[st].length; ++hyd) {
                    this.convCost[nS_aux][st][hyd][this.iterCount[nS_aux] - 1][1] = this.stProblems[st][hyd].get_Ope_Fc();
                }
            }
        } while ((!DeepEdit.isGUI || ratProcess || !this.th_Monitor.isCanceled() || !this.th_doLastBwd) && (this.iterCount[nS_aux] != nMaxIter || !this.th_doLastBwd));
        if (SEEDS_Frame.addConv3) {
            for (st = 0; st < this.stProblems.length; ++st) {
                this.convCuts[nS_aux][st] = new double[this.vecEFCF[st].size()][1 + 2 * this.main_solver.resHydUnit.length];
                for (hyd = 0; hyd < this.convCuts[nS_aux][st].length; ++hyd) {
                    this.convCuts[nS_aux][st][hyd][0] = ((SEEDS_BendCut)this.vecEFCF[st].elementAt((int)hyd)).f0 * SEEDS_SBHTPS.ponderar;
                    for (int aux = 0; aux < this.main_solver.resHydUnit.length; ++aux) {
                        this.convCuts[nS_aux][st][hyd][1 + aux] = ((SEEDS_BendCut)this.vecEFCF[st].elementAt((int)hyd)).mi[aux] * SEEDS_SBHTPS.ponderar;
                        this.convCuts[nS_aux][st][hyd][1 + this.main_solver.resHydUnit.length + aux] = ((SEEDS_BendCut)this.vecEFCF[st].elementAt((int)hyd)).xi[aux];
                        double[] dArray = this.convCuts[nS_aux][st][hyd];
                        dArray[0] = dArray[0] - this.convCuts[nS_aux][st][hyd][1 + aux] * this.convCuts[nS_aux][st][hyd][1 + this.main_solver.resHydUnit.length + aux];
                    }
                }
            }
        }
        this.resSols[nS_aux] = new double[2][this.Scen2Stage[nS].length][0][0][0];
        this.resCost[nS_aux] = new double[this.Scen2Stage[nS].length][0][0];
        for (st = 0; st < this.resSols[nS_aux][0].length; ++st) {
            this.resSols[nS_aux][0][st] = new double[this.stProblems[st].length][0][0];
            this.resSols[nS_aux][1][st] = new double[this.resSols[nS_aux][0][st].length][0][0];
            this.resCost[nS_aux][st] = new double[this.resSols[nS_aux][0][st].length][0];
            for (hyd = 0; hyd < this.resSols[nS_aux][0][st].length; ++hyd) {
                this.resSols[nS_aux][0][st][hyd] = this.stProblems[st][hyd].actSolutionArr;
                this.resSols[nS_aux][1][st][hyd] = this.stProblems[st][hyd].getFinalDualCost();
                for (int bl = 0; bl < this.stProblems[st][hyd].actSolutionArr.length; ++bl) {
                    this.resSols[nS_aux][0][st][hyd][bl][this.resSols[nS_aux][0][st][hyd][bl].length - 1] = this.resSols[nS_aux][0][st][hyd][bl][this.resSols[nS_aux][0][st][hyd][bl].length - 1] * this.stProblems[st][hyd].discRateFEFCF * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar;
                }
                this.resCost[nS_aux][st][hyd] = this.stProblems[st][hyd].getFinalOperCost();
            }
        }
        this.solutionIsValid = true;
    }

    private double solveMonte(int Cuts, int nS) throws Exception {
        double[][] cuts;
        int st;
        SEEDS_Tool.ids[0] = nS;
        int nS_aux = this.th_MPs > -1 ? 0 : nS;
        DeepEdit.MySchematic.settypsim(1);
        DeepEdit.MySchematic.settiposimula(0);
        this.loadCaudMxs2Affl(nS);
        this.tasa = new double[this.StLengths.length];
        this.tasa[0] = this.StLengths[0][2];
        for (st = 1; st < this.Scen2Stage[nS].length; ++st) {
            this.tasa[st] = this.tasa[st - 1] * this.StLengths[st][2];
        }
        this.stProblems = new SEEDS_StageHTPM[this.Scen2Stage[nS].length][1];
        for (st = 0; st < this.Scen2Stage[nS].length; ++st) {
            this.stProblems[st][0] = new SEEDS_StageHTPM(st, 0, this.main_solver, this.BlLengths[st], this.StLengths[st][2]);
        }
        this.stProblems[0][0].setStDependencies(null, this.stProblems[1]);
        for (st = 1; st < this.stProblems.length - 1; ++st) {
            this.stProblems[st][0].setStDependencies(this.stProblems[st - 1][0], this.stProblems[st + 1]);
        }
        this.stProblems[st][0].setStDependencies(this.stProblems[st - 1][0], null);
        this.vecEFCF = new Vector[this.stProblems.length];
        if (Cuts == 0) {
            int m = SEEDS_Frame.myConver.getNSec();
            for (st = 0; st < this.stProblems.length - 1; ++st) {
                this.vecEFCF[st] = new Vector(2);
                for (int h = 0; h < m; ++h) {
                    cuts = SEEDS_Frame.myConver.getCuts(h, st);
                    if (!SEEDS_Frame.myConver.isBendersCuts() || cuts == null) continue;
                    int n = (cuts[0].length - 1) / 2;
                    if (n == this.main_solver.resHydUnit.length) {
                        double[] aproxSlopes = new double[n];
                        double[] aproxPoints = new double[n];
                        double aproxHeight = 0.0;
                        SEEDS_BendCut.setDimension(n);
                        for (int cut = 0; cut < cuts.length; ++cut) {
                            aproxHeight = cuts[cut][0];
                            for (int res = 0; res < n; ++res) {
                                aproxSlopes[res] = cuts[cut][res + 1];
                                aproxPoints[res] = cuts[cut][n + res + 1];
                            }
                            this.vecEFCF[st].add(new SEEDS_BendCut(aproxSlopes, aproxPoints, aproxHeight));
                        }
                        continue;
                    }
                    System.out.println("Info loaded do not correspond to this case.");
                }
            }
        } else {
            for (st = 0; st < this.stProblems.length - 1; ++st) {
                this.vecEFCF[st] = new Vector(2);
                cuts = SEEDS_Frame.myConver.getCuts(Cuts - 1, st);
                if (!SEEDS_Frame.myConver.isBendersCuts() || cuts.length == 0) continue;
                int n = (cuts[0].length - 1) / 2;
                if (n == this.main_solver.resHydUnit.length) {
                    double[] aproxSlopes = new double[n];
                    double[] aproxPoints = new double[n];
                    double aproxHeight = 0.0;
                    SEEDS_BendCut.setDimension(n);
                    for (int cut = 0; cut < cuts.length; ++cut) {
                        aproxHeight = cuts[cut][0];
                        for (int res = 0; res < n; ++res) {
                            aproxSlopes[res] = cuts[cut][res + 1];
                            aproxPoints[res] = cuts[cut][n + res + 1];
                        }
                        this.vecEFCF[st].add(new SEEDS_BendCut(aproxSlopes, aproxPoints, aproxHeight));
                    }
                    continue;
                }
                System.out.println("Info loaded do not correspond to this case.");
            }
        }
        mydbm.loadFuncCotaVol();
        this.vecEFCF[this.stProblems.length - 1] = mydbm.getEndEFCF(this.main_solver.resHydUnit);
        for (st = 0; st < this.stProblems.length; ++st) {
            this.stProblems[st][0].setEFCF(this.vecEFCF[st]);
        }
        this.stProblems[0][0].setRes2SetVini(mydbm.getResArr());
        this.stProblems[0][0].solveForward();
        double cost = this.stProblems[0][0].getStSPOpC();
        if (DeepEdit.isGUI && !ratProcess) {
            this.th_Monitor.setProgress(0);
            this.th_Monitor.setNote("In stage 1/" + this.stProblems.length + ". Agreggate cost : " + cost + "[%]");
        }
        for (st = 1; st < this.stProblems.length - 1; ++st) {
            this.stProblems[st][0].solveForward();
            cost += this.stProblems[st][0].getStSPOpC() * this.tasa[st - 1];
            if (!DeepEdit.isGUI || ratProcess) continue;
            this.th_Monitor.setProgress(st);
            this.th_Monitor.setNote("In stage " + (st + 1) + "/" + this.stProblems.length + ". Agreggate cost : " + cost + "[%]");
        }
        this.stProblems[st][0].solveBackward();
        cost += this.stProblems[st][0].getStSPOpC() * this.tasa[st - 1];
        if (DeepEdit.isGUI && !ratProcess) {
            this.th_Monitor.setProgress(st);
            this.th_Monitor.setNote("In stage " + (st + 1) + "/" + this.stProblems.length + ". Agreggate cost : " + cost + "[%]");
        }
        this.resSols[nS_aux] = new double[2][this.Scen2Stage[nS].length][1][0][0];
        this.resCost[nS_aux] = new double[this.Scen2Stage[nS].length][1][0];
        for (st = 0; st < this.resSols[nS_aux][0].length; ++st) {
            this.resSols[nS_aux][0][st][0] = this.stProblems[st][0].actSolutionArr;
            for (int bl = 0; bl < this.stProblems[st][0].actSolutionArr.length; ++bl) {
                this.resSols[nS_aux][0][st][0][bl][this.resSols[nS_aux][0][st][0][bl].length - 1] = this.resSols[nS_aux][0][st][0][bl][this.resSols[nS_aux][0][st][0][bl].length - 1] * this.stProblems[st][0].discRateFEFCF * SEEDS_SBHTPS.fEscBC * SEEDS_SBHTPS.ponderar;
            }
            this.resSols[nS_aux][1][st][0] = this.stProblems[st][0].getFinalDualCost();
            this.resCost[nS_aux][st][0] = this.stProblems[st][0].getFinalOperCost();
        }
        this.vecEFCF = null;
        this.solutionIsValid = true;
        return cost;
    }

    protected void manageHTCP() throws Exception {
        int i;
        int amnt = 0;
        int nroSPs = 0;
        amnt = this.th_MPs == -1 ? SEEDS_Frame.n_Seq : 1;
        if (this.th_type == 1) {
            for (i = 0; i < this.Scen2Stage[0].length; ++i) {
                nroSPs += this.Scen2Stage[0][i].length;
            }
        } else if (this.th_type == 2) {
            int aux = 1;
            nroSPs = 0;
            for (int i2 = 0; i2 < this.Scen2Stage[0].length; ++i2) {
                nroSPs += (aux *= this.Scen2Stage[0][i2].length);
            }
        }
        nroSPs *= amnt;
        if (DeepEdit.isGUI && !ratProcess) {
            if (nroSPs > 100 && 0 != JOptionPane.showOptionDialog(DeepEditFrame.MySEEDS_Frame, "You are triying to solve " + nroSPs + " Sub-problems by iteration. Are you sure?", "Warning: it would be taking long time", 0, 3, null, new String[]{"Sure!", "No"}, 0)) {
                return;
            }
        } else {
            System.out.println("There will be " + nroSPs + " SPs by iteration.");
        }
        this.costosMonte = new double[amnt];
        this.iterCount = new int[amnt];
        this.convBnds = new double[amnt][][];
        this.convCost = new double[amnt][][][][][][];
        this.convCuts = new double[amnt][][][];
        this.resSols = new double[amnt][][][][][];
        this.resCost = new double[amnt][][][];
        try {
            this.main_solver = new SEEDS_SBHTPS(this.ActSchematic, 744.0, 1.0, ratProcess);
            this.main_solver.setSolverParam(this.th_solver, this.th_SPite, this.th_SPtol);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problems assembling structure or Solver without license.");
            return;
        }
        long time = System.currentTimeMillis();
        try {
            System.out.println("___________________________________________________________________________");
            System.out.println("--------------------     HYDROTHERMAL COORDINATION     --------------------");
            System.out.println("--------------------              SEEDS                --------------------");
            System.out.println("");
            System.out.println("H=" + SEEDS_Frame.n_Stages + " [Stages] - K=" + (SEEDS_Frame.n_HS_Consider + 1) + " [Scenarios]");
            if (this.th_type == 1) {
                if (this.th_MPs == -1) {
                    for (i = 0; i < amnt; ++i) {
                        if (DeepEdit.isGUI && !ratProcess) {
                            this.th_Monitor = new ProgressMonitor(DeepEditFrame.MySEEDS_Frame, "Solving MP " + (i + 1), "", 0, this.th_MPite);
                            this.th_Monitor.setMillisToPopup(100);
                        }
                        this.solveSeqs(i, this.th_fromBW, this.th_fromFlat, this.th_MPtol, this.th_MPite);
                        System.out.println("Sequence: " + (1 + i) + ", solved on: " + this.iterCount[i] + "[ite], in: " + (System.currentTimeMillis() - time) + " [ms].");
                        System.out.println(" -> Final UB: " + df.format(this.convBnds[i][0][this.iterCount[i] - 1]) + "[MU$]" + " - LB: " + df.format(this.convBnds[i][1][this.iterCount[i] - 1]) + "[MU$].");
                        time = System.currentTimeMillis();
                        if (!DeepEdit.isGUI || ratProcess) continue;
                        this.th_Monitor.close();
                    }
                } else {
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor = new ProgressMonitor(DeepEditFrame.MySEEDS_Frame, "Solving MP 1", "", 0, this.th_MPite);
                        this.th_Monitor.setMillisToPopup(100);
                    }
                    this.solveSeqs(this.th_MPs, this.th_fromBW, this.th_fromFlat, this.th_MPtol, this.th_MPite);
                    System.out.println("Convergence process end over " + this.iterCount[0] + " iterations");
                    System.out.println(" Execution time: " + (System.currentTimeMillis() - time) + " [ms]");
                    System.out.println(" Final upper bound: " + df.format(this.convBnds[0][0][this.iterCount[0] - 1]) + "[MU$]");
                    System.out.println(" Final lower bound: " + df.format(this.convBnds[0][1][this.iterCount[0] - 1]) + "[MU$]");
                    time = System.currentTimeMillis();
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor.close();
                    }
                }
            } else if (this.th_type == 2) {
                if (this.th_MPs == -1) {
                    for (i = 0; i < amnt; ++i) {
                        if (DeepEdit.isGUI && !ratProcess) {
                            this.th_Monitor = new ProgressMonitor(DeepEditFrame.MySEEDS_Frame, "Solving MP " + (i + 1), "", 0, this.th_MPite);
                            this.th_Monitor.setMillisToPopup(100);
                        }
                        this.solveTree(i, this.th_fromBW, this.th_fromFlat, this.th_MPtol, this.th_MPite);
                        System.out.println("Tree: " + (1 + i) + ", solved on: " + this.iterCount[i] + "[ite], in: " + (System.currentTimeMillis() - time) + " [ms].");
                        System.out.println(" -> Final UB: " + df.format(this.convBnds[i][0][this.iterCount[i] - 1]) + "[MU$]" + " - LB: " + df.format(this.convBnds[i][1][this.iterCount[i] - 1]) + "[MU$].");
                        time = System.currentTimeMillis();
                        if (!DeepEdit.isGUI || ratProcess) continue;
                        this.th_Monitor.close();
                    }
                } else {
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor = new ProgressMonitor(DeepEditFrame.MySEEDS_Frame, "Solving MP 1", "", 0, this.th_MPite);
                        this.th_Monitor.setMillisToPopup(100);
                    }
                    this.solveTree(this.th_MPs, this.th_fromBW, this.th_fromFlat, this.th_MPtol, this.th_MPite);
                    System.out.println("Convergence process end over " + this.iterCount[0] + " iterations");
                    System.out.println(" Execution time: " + (System.currentTimeMillis() - time) + " [ms]");
                    System.out.println(" Final upper bound: " + df.format(this.convBnds[0][0][this.iterCount[0] - 1]) + "[MU$]");
                    System.out.println(" Final lower bound: " + df.format(this.convBnds[0][1][this.iterCount[0] - 1]) + "[MU$]");
                    time = System.currentTimeMillis();
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor.close();
                    }
                }
            } else if (this.th_type < 1) {
                if (this.th_MPs == -1) {
                    for (i = 0; i < amnt; ++i) {
                        if (DeepEdit.isGUI && !ratProcess) {
                            this.th_Monitor = new ProgressMonitor(DeepEditFrame.MySEEDS_Frame, "Solving MP " + (i + 1), "", 0, this.Scen2Stage[0].length);
                            this.th_Monitor.setMillisToPopup(100);
                        }
                        double cost = this.solveMonte(-this.th_type, i);
                        if (this.th_type == 0) {
                            System.out.println("Seq " + (1 + i) + ", solved with EFCF builded from ALL last seq solved, in: " + (System.currentTimeMillis() - time) + " [ms].");
                        } else {
                            System.out.println("Sequence " + (1 + i) + ", solved with EFCF builded from last solved sequence " + -this.th_type + " , in: " + (System.currentTimeMillis() - time) + " [ms].");
                        }
                        System.out.println(" -> Total cost for sequence " + (1 + i) + " is: " + df.format(cost) + " [UM$]");
                        this.costosMonte[i] = cost;
                        time = System.currentTimeMillis();
                        if (!DeepEdit.isGUI || ratProcess) continue;
                        this.th_Monitor.close();
                    }
                } else {
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor = new ProgressMonitor(DeepEditFrame.MySEEDS_Frame, "Solving MP 1", "", 0, this.Scen2Stage[0].length);
                        this.th_Monitor.setMillisToPopup(100);
                    }
                    double cost = this.solveMonte(-this.th_type, this.th_MPs);
                    if (this.th_type == 0) {
                        System.out.println("Seq " + (1 + this.th_MPs) + ", solved with EFCF builded from ALL last seq solved, in: " + (System.currentTimeMillis() - time) + " [ms].");
                    } else {
                        System.out.println("Sequence " + (1 + this.th_MPs) + ", solved with EFCF builded from last solved sequence " + -this.th_type + " , in: " + (System.currentTimeMillis() - time) + " [ms].");
                    }
                    System.out.println(" -> Total cost for sequence " + (1 + this.th_MPs) + " is: " + df.format(cost) + " [UM$]");
                    time = System.currentTimeMillis();
                    if (DeepEdit.isGUI && !ratProcess) {
                        this.th_Monitor.close();
                    }
                }
            }
            System.out.println("");
            System.out.println("___________________________________________________________________________");
        }
        catch (Exception e) {
            System.out.println("Problems solving structure based on MP: " + this.th_MPs);
            e.printStackTrace();
        }
        if (this.solutionIsValid) {
            try {
                FileOutputStream out = new FileOutputStream(archivoBINres);
                ObjectOutputStream s = new ObjectOutputStream(out);
                s.writeObject(new int[]{this.main_solver.numload, this.main_solver.numgenT, this.main_solver.numnod, this.main_solver.numtrafo, this.main_solver.numbran, this.main_solver.numReserG, this.main_solver.numSerieG, this.main_solver.numReserH, this.main_solver.numSerieH, this.main_solver.numPasad, this.main_solver.numIrr, SEEDS_Frame.n_HS_Consider});
                String[][][] resNames = !ratProcess ? this.main_solver.getSystemNames() : this.main_solver.getSystemNames(true);
                s.writeObject(resNames);
                s.writeObject(this.resSols);
                s.writeObject(this.resCost);
                double[] iniReser = new double[this.main_solver.resHydUnit.length];
                for (int aux = 0; aux < iniReser.length; ++aux) {
                    iniReser[aux] = (this.main_solver.resHydUnit[aux].getVini() - this.main_solver.resHydUnit[aux].getVmin()) / (this.main_solver.resHydUnit[aux].getVmax() - this.main_solver.resHydUnit[aux].getVmin());
                }
                s.writeObject(iniReser);
                s.flush();
                s.close();
                out.close();
                if (this.th_type > 0) {
                    out = new FileOutputStream(archivoBINconv);
                    s = new ObjectOutputStream(out);
                    s.writeObject(this.convBnds);
                    s.writeObject(this.convCost);
                    s.writeObject(this.convCuts);
                    String[] convNames = new String[this.main_solver.resHydUnit.length];
                    for (int aux = 0; aux < convNames.length; ++aux) {
                        convNames[aux] = this.main_solver.resHydUnit[aux].getName();
                    }
                    s.writeObject(convNames);
                    s.writeObject(this.iterCount);
                    s.flush();
                    s.close();
                    out.close();
                }
                System.out.println("Wrote BINs in " + (System.currentTimeMillis() - time) + " [ms]");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Problems writing serializable files");
            }
        }
        try {
            this.main_solver.finalize();
            this.main_solver = null;
        }
        catch (Exception e) {
            System.out.println("Imposible to close main solver");
        }
    }

    protected void toRun(int type, int nroSeq, int solverId, double qpCostTol, int qpNmaxIter, boolean initBWMode, boolean solveFromFlatSol, double ssTol, int nMaxIter, boolean shareCuts, boolean doLastBwd) throws Exception {
        if (this.myThread == null) {
            this.th_type = type;
            this.th_MPs = nroSeq;
            this.th_solver = solverId;
            this.th_SPtol = qpCostTol;
            this.th_SPite = qpNmaxIter;
            this.th_fromBW = initBWMode;
            this.th_fromFlat = solveFromFlatSol;
            this.th_MPtol = ssTol;
            this.th_MPite = nMaxIter;
            this.th_doLastBwd = doLastBwd;
            this.th_ShareCuts = shareCuts;
            if (DeepEdit.isGUI) {
                this.myThread = new Thread(this);
                this.myThread.start();
            } else {
                this.manageHTCP();
            }
        } else {
            System.out.println("Simulation currently is running.");
        }
    }

    protected void toRun(int type, int nroSeq, int solverId, double qpCostTol, int qpNmaxIter, boolean initBWMode, boolean solveFromFlatSol, double ssTol, int nMaxIter) throws Exception {
        this.toRun(type, nroSeq, solverId, qpCostTol, qpNmaxIter, initBWMode, solveFromFlatSol, ssTol, nMaxIter, false, false);
    }

    @Override
    public void run() {
        try {
            DeepEditFrame.MySEEDS_Frame.setEnabled(false);
            this.manageHTCP();
            DeepEditFrame.MySEEDS_Frame.finishSol();
            this.myThread = null;
            DeepEditFrame.MySEEDS_Frame.setEnabled(true);
        }
        catch (Exception e) {
            this.myThread = null;
            DeepEditFrame.MySEEDS_Frame.finishSol();
            DeepEditFrame.MySEEDS_Frame.setEnabled(true);
            e.printStackTrace();
        }
    }

    protected void runRationing(boolean b) {
        ratProcess = b;
    }

    protected static boolean isRat() {
        return ratProcess;
    }

    protected void busyThread() {
        try {
            this.myThread.join();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void defOutFile(String na) {
        archivoBINres = "." + File.separator + "results" + File.separator + na + "resSEEDS.bin";
        archivoBINconv = "." + File.separator + "results" + File.separator + na + "convSEEDS.bin";
    }

    protected void initializeSigmas(int s, int b) {
        sigmas = new double[s][b];
        for (int i = 0; i < s; ++i) {
            for (int j = 0; j < b; ++j) {
                SEEDS_Tool.sigmas[i][j] = 100.0;
            }
        }
    }

    protected void defineSigmas(int s, int b, double value) {
        SEEDS_Tool.sigmas[s][b] = value;
    }

    protected static double getSigma(int s, int b) {
        return sigmas[s][b];
    }

    protected void printSigma() {
        for (int i = 0; i < sigmas.length; ++i) {
            System.out.println("etapa: " + (i + 1) + ":");
            for (int j = 0; j < sigmas[i].length; ++j) {
                System.out.println("bloque: " + (j + 1) + " -sigma: " + sigmas[i][j]);
            }
        }
    }

    protected double[] returnCostMonte() {
        return this.costosMonte;
    }

    static {
        archivoBINres = "." + File.separator + "results" + File.separator + "resSEEDS.bin";
        archivoBINconv = "." + File.separator + "results" + File.separator + "convSEEDS.bin";
        ids = new int[]{-1, -1, -1, -1};
        ratProcess = false;
        df = null;
        sigmas = null;
    }
}

