/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.AnalysisTool;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Example;
import de.core.seeds.SEEDS_Exception;
import de.core.seeds.SEEDS_Frame;
import java.awt.Choice;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.DriverManager;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SEEDS_StudiesFrame
extends JFrame
implements ItemListener,
ActionListener {
    DeepEdit applet;
    Choice c;
    JTextField TType;
    JTextField TDescription;
    JTextField TLocation;
    String Categoria = "all";
    List l;
    Vector ExamplesVector;
    Vector ExamplesVectorOrg;
    String WaitMessage = "Favor esperar, cargando Estudios SEEDS.";
    String FileName;
    JButton OKButton;
    JButton CancelButton;
    JButton delButton;
    JButton addButton;
    JRadioButton accessDB;
    JRadioButton sqlliteDB;
    JCheckBox cbx_isRationing = null;

    public SEEDS_StudiesFrame(DeepEdit app) {
        super("SEEDS Studies Manager Frame");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object obj = e.getSource();
        if (obj == this.l) {
            int s = this.l.getSelectedIndex();
            if (s == -1) {
                return;
            }
            this.updateText(this.l.getSelectedItem());
            this.repaint();
        } else {
            this.ShowExamples(((Choice)obj).getSelectedItem());
        }
    }

    public void ShowExamples(String Category2) {
    }

    public void ShowCategories() {
        this.c.removeAll();
        this.c.addItem("all");
        if (this.ExamplesVector.size() == 0) {
            return;
        }
        for (int ix = 0; ix < this.ExamplesVector.size(); ++ix) {
            Example TempExample = (Example)this.ExamplesVector.elementAt(ix);
            boolean exist = false;
            for (int cl = 0; cl < this.c.getItemCount(); ++cl) {
                if (!this.c.getItem(cl).equals(TempExample.getType())) continue;
                exist = true;
            }
            if (exist) continue;
            this.c.addItem(TempExample.getType());
        }
    }

    public void LoadExamples() {
    }

    public String getFileName(String example) {
        for (int ix = 0; ix < this.ExamplesVector.size(); ++ix) {
            Example TempExample = (Example)this.ExamplesVector.elementAt(ix);
            if (!example.equals(TempExample.getDescription())) continue;
            return TempExample.getLocation();
        }
        return null;
    }

    public void removeExample(String example) {
        for (int ix = 0; ix < this.ExamplesVector.size(); ++ix) {
            Example TempExample = (Example)this.ExamplesVector.elementAt(ix);
            if (!example.equals(TempExample.getDescription())) continue;
            this.ExamplesVector.remove(TempExample);
            return;
        }
    }

    public void updateText(String example) {
        for (int ix = 0; ix < this.ExamplesVector.size(); ++ix) {
            Example TempExample = (Example)this.ExamplesVector.elementAt(ix);
            if (!example.equals(TempExample.getDescription())) continue;
            this.TType.setText(TempExample.getType());
            this.TDescription.setText(TempExample.getDescription());
            this.TLocation.setText(TempExample.getLocation());
            return;
        }
    }

    public void updateall() throws SEEDS_Exception {
        Example TempExample = null;
        FileWriter f1 = null;
        BufferedWriter f2 = null;
        boolean ff = true;
        boolean anyUpdate = false;
        try {
            Example auxEx;
            int ixx;
            int ix;
            f1 = new FileWriter("." + File.separator + "SeedsFiles" + File.separator + "description.txt");
            f2 = new BufferedWriter(f1);
            for (ix = 0; ix < this.ExamplesVector.size(); ++ix) {
                TempExample = (Example)this.ExamplesVector.elementAt(ix);
                f2.write(TempExample.getType());
                f2.newLine();
                f2.write(TempExample.getDescription());
                f2.newLine();
                f2.write(TempExample.getLocation());
                f2.newLine();
            }
            f2.close();
            ((Writer)f1).close();
            f1 = new FileWriter("." + File.separator + "SeedsFiles" + File.separator + "seeds.bat");
            f2 = new BufferedWriter(f1);
            f2.write("echo off");
            f2.newLine();
            f2.write("cd SeedsFiles");
            f2.newLine();
            for (ix = 0; ix < this.ExamplesVector.size(); ++ix) {
                TempExample = (Example)this.ExamplesVector.elementAt(ix);
                ff = true;
                for (ixx = 0; ixx < this.ExamplesVectorOrg.size(); ++ixx) {
                    auxEx = (Example)this.ExamplesVectorOrg.elementAt(ixx);
                    if (auxEx != TempExample) continue;
                    ff = false;
                    break;
                }
                if (!ff) continue;
                System.out.println("Copy new Study");
                f2.write("mkdir " + TempExample.getLocation());
                f2.newLine();
                f2.write("copy seeds.sim " + TempExample.getLocation());
                f2.newLine();
                f2.write("copy SeedsDB.mdb " + TempExample.getLocation());
                f2.newLine();
                f2.write("copy SeedsDB.db " + TempExample.getLocation());
                f2.newLine();
                anyUpdate = true;
            }
            for (ix = 0; ix < this.ExamplesVectorOrg.size(); ++ix) {
                TempExample = (Example)this.ExamplesVectorOrg.elementAt(ix);
                ff = true;
                for (ixx = 0; ixx < this.ExamplesVector.size(); ++ixx) {
                    auxEx = (Example)this.ExamplesVector.elementAt(ixx);
                    if (auxEx != TempExample) continue;
                    ff = false;
                    break;
                }
                if (!ff) continue;
                System.out.println("Delete Study");
                f2.write("rmdir /Q /S " + TempExample.getLocation());
                f2.newLine();
                anyUpdate = true;
            }
            f2.close();
            ((Writer)f1).close();
            f2 = null;
            f1 = null;
            if (anyUpdate) {
                AnalysisTool.Dorun(DeepEdit.PathDOS + "SeedsFiles" + File.separator + "seeds.bat", DeepEdit.PathUNIX + "SeedsFiles" + File.separator + "seeds.bat");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addExample() {
        if (this.TType.getText() != null && this.TDescription.getText() != null && this.TLocation.getText() != null && !this.TLocation.getText().equals("")) {
            for (int ix = 0; ix < this.ExamplesVector.size(); ++ix) {
                Example TempExample = (Example)this.ExamplesVector.elementAt(ix);
                if (!this.TLocation.getText().equals(TempExample.getLocation())) continue;
                return;
            }
            Example NewEx = new Example(this.TType.getText(), this.TDescription.getText(), this.TLocation.getText());
            this.ExamplesVector.addElement(NewEx);
            this.ShowCategories();
            this.ShowExamples(this.Categoria);
        }
    }

    public void openStudy(String studyDir) throws SEEDS_Exception {
        File tmpFile = null;
        this.FileName = "." + File.separator + "SeedsFiles" + File.separator + studyDir;
        tmpFile = new File(this.FileName);
        if (!tmpFile.exists()) {
            throw new SEEDS_Exception("Study folder '" + studyDir + "' does not exist.");
        }
        this.FileName = this.FileName + File.separator + "SeedsDB";
        this.FileName = this.accessDB.isSelected() ? this.FileName + ".mdb" : this.FileName + ".db";
        tmpFile = new File(this.FileName);
        if (!tmpFile.exists()) {
            throw new SEEDS_Exception("Missing SEEDS Database in folder '" + studyDir + "'.");
        }
        try {
            this.applet.UserWantsOpenExample("." + File.separator + "SeedsFiles" + File.separator + studyDir + File.separator + "Seeds.sim");
            DeepEdit.MySchematic.FileDir = "." + File.separator + "SeedsFiles" + File.separator + studyDir + File.separator;
            DeepEdit.MySchematic.FileName = "Seeds.sim";
            SEEDS_StudiesFrame sEEDS_StudiesFrame = this;
            sEEDS_StudiesFrame.applet.SimulateSetUp();
            if (this.accessDB.isSelected()) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                this.FileName = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + this.FileName;
            } else {
                Class.forName("org.sqlite.JDBC");
                this.FileName = "jdbc:sqlite:" + this.FileName;
            }
            DeepEditFrame.conSEEDSDB = DriverManager.getConnection(this.FileName);
            DeepEditFrame.conSEEDSDB.setAutoCommit(false);
            DeepEditFrame.MySEEDS_Frame = new SEEDS_Frame(this.applet, this.cbx_isRationing.isSelected());
            DeepEditFrame.MySEEDS_Frame.Location = studyDir;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }
}

