/*
 * Decompiled with CFR 0.152.
 */
package de.core.seeds;

import de.core.seeds.SEEDS_Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SEEDS_StageManager {
    private Connection dbtrab;
    private SEEDS_Frame mySEEDSFrame = null;
    private JTable t = null;
    private Statement s;
    private JFileChooser chooser;
    private String dondeGrabar = "Stage_Manager";

    SEEDS_StageManager(SEEDS_Frame ff, Connection cc) {
        this.mySEEDSFrame = ff;
        this.dbtrab = cc;
    }

    protected void makeStageManager(int a, int b) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showSaveDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            this.dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            if (!this.dondeGrabar.substring(this.dondeGrabar.length() - 4, this.dondeGrabar.length()).equalsIgnoreCase(".csv")) {
                this.dondeGrabar = this.dondeGrabar + ".csv";
            }
            try {
                int i;
                PrintWriter pw = new PrintWriter(new FileWriter(this.dondeGrabar));
                String resp = "Stages, Length, Units, Demand";
                if (b > 1) {
                    for (i = 0; i < b; ++i) {
                        resp = resp + ",B" + (i + 1) + "_Energy";
                    }
                    for (i = 0; i < b; ++i) {
                        resp = resp + ",B" + (i + 1) + "_time";
                    }
                }
                pw.println(resp);
                resp = "[N\u00b0],[Units],[h-d-30d-y],[%]";
                if (b > 1) {
                    for (i = 0; i < b; ++i) {
                        resp = resp + ",[%]";
                    }
                    for (i = 0; i < b; ++i) {
                        resp = resp + ",[%]";
                    }
                }
                pw.println(resp);
                if (b > 1) {
                    double aux1 = Math.rint(100000 / a) / 1000.0;
                    double aux2 = Math.rint(100000 / b) / 1000.0;
                    for (i = 0; i < a; ++i) {
                        resp = "" + (i + 1) + ",1,1," + aux1;
                        for (int j = 0; j < 2 * b; ++j) {
                            resp = resp + "," + aux2;
                        }
                        pw.println(resp);
                    }
                } else {
                    double aux1 = Math.rint(100000 / a) / 1000.0;
                    for (i = 0; i < a; ++i) {
                        resp = "" + (i + 1) + ",1,1," + aux1;
                        pw.println(resp);
                    }
                }
                pw.close();
                System.out.println("File " + this.chooser.getSelectedFile().getName() + " was saved succesfully");
            }
            catch (Exception e) {
                System.out.println("Actually " + this.chooser.getSelectedFile().getName() + ".csv it's opened");
            }
        }
    }

    protected void editStageManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showSaveDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            this.dondeGrabar = this.chooser.getSelectedFile().getAbsolutePath();
            if (!this.dondeGrabar.substring(this.dondeGrabar.length() - 4, this.dondeGrabar.length()).equalsIgnoreCase(".csv")) {
                this.dondeGrabar = this.dondeGrabar + ".csv";
            }
            int i = 0;
            boolean j = false;
            int b = 1;
            ResultSet r = null;
            PrintWriter pw = null;
            try {
                this.s = this.dbtrab.createStatement();
                r = this.s.executeQuery("SELECT * FROM Stages_Manager ORDER BY Stages");
                if (r.next()) {
                    try {
                        while (true) {
                            r.getDouble("B" + b + "_time");
                            ++b;
                        }
                    }
                    catch (SQLException es) {
                        --b;
                    }
                }
                pw = new PrintWriter(new FileWriter(this.dondeGrabar));
                String resp = "Stages, Length, Units, Demand";
                if (b > 1) {
                    for (i = 0; i < b; ++i) {
                        resp = resp + ",B" + (i + 1) + "_Energy";
                    }
                    for (i = 0; i < b; ++i) {
                        resp = resp + ",B" + (i + 1) + "_time";
                    }
                }
                pw.println(resp);
                resp = "[N\u00b0],[Units],[h-d-30d-y],[%]";
                if (b > 1) {
                    for (i = 0; i < b; ++i) {
                        resp = resp + ",[%]";
                    }
                    for (i = 0; i < b; ++i) {
                        resp = resp + ",[%]";
                    }
                }
                pw.println(resp);
                r = this.s.executeQuery("SELECT * FROM Stages_Manager ORDER BY Stages");
                while (r.next()) {
                    resp = "" + r.getInt(1) + "," + r.getInt(2) + "," + r.getInt(3) + "," + r.getDouble(4);
                    for (i = 0; i < 2 * b; ++i) {
                        resp = resp + ", " + r.getDouble(5 + i);
                    }
                    pw.println(resp);
                }
                r.close();
                this.s.close();
                pw.close();
                System.out.println("File " + this.chooser.getSelectedFile().getName() + " was saved succesfully");
            }
            catch (Exception e) {
                pw.close();
                System.out.println("Actually " + this.chooser.getSelectedFile().getName() + ".csv it's opened");
                e.printStackTrace();
            }
        }
    }

    protected void loadStageManager() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filtro = new FileNameExtensionFilter("CSV Files", "csv", "dat");
        this.chooser.addChoosableFileFilter(filtro);
        int retorno = this.chooser.showOpenDialog(this.mySEEDSFrame);
        if (retorno == 0) {
            File file = this.chooser.getSelectedFile().getAbsoluteFile();
            this.mySEEDSFrame.StatusLabel.setText("Loading " + this.chooser.getSelectedFile().getName());
            try {
                int i = 0;
                int bl = 0;
                int m = 0;
                BufferedReader in = new BufferedReader(new FileReader(file));
                String lineText = in.readLine();
                String[] line = null;
                if (lineText == null) {
                    System.out.println("Bad format in file.");
                    return;
                }
                line = lineText.split(",");
                bl = (line.length - 4) / 2;
                this.s = this.dbtrab.createStatement();
                try {
                    this.s.executeUpdate("DROP TABLE Stages_Manager");
                    this.s.executeUpdate("DROP TABLE Def_Etapas");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    lineText = "CREATE TABLE Stages_Manager (Stages SMALLINT, Large SMALLINT, Unit SMALLINT, Demand DOUBLE";
                    for (i = 0; i < 2 * bl; ++i) {
                        lineText = lineText + ", " + line[4 + i].trim() + " DOUBLE";
                    }
                    lineText = lineText + ")";
                    this.s.executeUpdate(lineText);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                lineText = in.readLine();
                int etapas = 0;
                while ((lineText = in.readLine()) != null && (line = lineText.split(",")).length == 4 + 2 * bl) {
                    lineText = "INSERT INTO Stages_Manager VALUES (" + line[0].trim();
                    for (i = 1; i < 4 + 2 * bl; ++i) {
                        lineText = lineText + ", " + line[i].trim();
                    }
                    lineText = lineText + ")";
                    this.s.executeUpdate(lineText);
                    switch (Integer.parseInt(line[2].trim())) {
                        case 1: {
                            m += Integer.parseInt(line[1].trim());
                            break;
                        }
                        case 2: {
                            m += Integer.parseInt(line[1].trim()) * 24;
                            break;
                        }
                        case 3: {
                            m += Integer.parseInt(line[1].trim()) * 720;
                            break;
                        }
                        case 4: {
                            m += Integer.parseInt(line[1].trim()) * 8760;
                        }
                    }
                    etapas = Integer.parseInt(line[0].trim());
                }
                this.mySEEDSFrame.setNumStages(etapas);
                if (bl == 0) {
                    this.mySEEDSFrame.setNumBlocks(1);
                } else {
                    this.mySEEDSFrame.setNumBlocks(bl);
                }
                SEEDS_Frame.stagesLength = m;
                if (etapas < 1) {
                    System.out.println("Format problems in file loaded.");
                } else {
                    System.out.println("Load Stages_Manager correctly.");
                }
                this.s.close();
                this.dbtrab.commit();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Information not found");
            }
        }
    }
}

